// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;


/**
 *  btConstraintSolverPoolMt - masquerades as a constraint solver, but really it is a threadsafe pool of them.
 * 
 *   Each solver in the pool is protected by a mutex.  When solveGroup is called from a thread,
 *   the pool looks for a solver that isn't being used by another thread, locks it, and dispatches the
 *   call to the solver.
 *   So long as there are at least as many solvers as there are hardware threads, it should never need to
 *   spin wait.
 *  */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btConstraintSolverPoolMt extends btConstraintSolver {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btConstraintSolverPoolMt(Pointer p) { super(p); }

	// create the solvers for me
	public btConstraintSolverPoolMt(int numSolvers) { super((Pointer)null); allocate(numSolvers); }
	private native void allocate(int numSolvers);

	// pass in fully constructed solvers (destructor will delete them)
	public btConstraintSolverPoolMt(@Cast("btConstraintSolver**") PointerPointer solvers, int numSolvers) { super((Pointer)null); allocate(solvers, numSolvers); }
	private native void allocate(@Cast("btConstraintSolver**") PointerPointer solvers, int numSolvers);
	public btConstraintSolverPoolMt(@ByPtrPtr btConstraintSolver solvers, int numSolvers) { super((Pointer)null); allocate(solvers, numSolvers); }
	private native void allocate(@ByPtrPtr btConstraintSolver solvers, int numSolvers);

	/**solve a group of constraints */
	public native @Cast("btScalar") double solveGroup(@Cast("btCollisionObject**") PointerPointer bodies,
									int numBodies,
									@Cast("btPersistentManifold**") PointerPointer manifolds,
									int numManifolds,
									@Cast("btTypedConstraint**") PointerPointer constraints,
									int numConstraints,
									@Const @ByRef btContactSolverInfo info,
									btIDebugDraw debugDrawer,
									btDispatcher dispatcher);
	public native @Cast("btScalar") double solveGroup(@ByPtrPtr btCollisionObject bodies,
									int numBodies,
									@ByPtrPtr btPersistentManifold manifolds,
									int numManifolds,
									@ByPtrPtr btTypedConstraint constraints,
									int numConstraints,
									@Const @ByRef btContactSolverInfo info,
									btIDebugDraw debugDrawer,
									btDispatcher dispatcher);

	public native void reset();
	public native @Cast("btConstraintSolverType") int getSolverType();
}
