// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletSoftBody;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;
import org.bytedeco.bullet.BulletDynamics.*;
import static org.bytedeco.bullet.global.BulletDynamics.*;

import static org.bytedeco.bullet.global.BulletSoftBody.*;


@Properties(inherit = org.bytedeco.bullet.presets.BulletSoftBody.class)
public class btSoftBodyHelpers extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public btSoftBodyHelpers() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btSoftBodyHelpers(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btSoftBodyHelpers(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public btSoftBodyHelpers position(long position) {
        return (btSoftBodyHelpers)super.position(position);
    }
    @Override public btSoftBodyHelpers getPointer(long i) {
        return new btSoftBodyHelpers((Pointer)this).offsetAddress(i);
    }

	/* Draw body															*/
	public static native void Draw(btSoftBody psb,
						 btIDebugDraw idraw,
						 int drawflags/*=fDrawFlags::Std*/);
	public static native void Draw(btSoftBody psb,
						 btIDebugDraw idraw);
	/* Draw body infos														*/
	public static native void DrawInfos(btSoftBody psb,
							  btIDebugDraw idraw,
							  @Cast("bool") boolean masses,
							  @Cast("bool") boolean areas,
							  @Cast("bool") boolean stress);
	/* Draw node tree														*/
	public static native void DrawNodeTree(btSoftBody psb,
								 btIDebugDraw idraw,
								 int mindepth/*=0*/,
								 int maxdepth/*=-1*/);
	public static native void DrawNodeTree(btSoftBody psb,
								 btIDebugDraw idraw);
	/* Draw face tree														*/
	public static native void DrawFaceTree(btSoftBody psb,
								 btIDebugDraw idraw,
								 int mindepth/*=0*/,
								 int maxdepth/*=-1*/);
	public static native void DrawFaceTree(btSoftBody psb,
								 btIDebugDraw idraw);
	/* Draw cluster tree													*/
	public static native void DrawClusterTree(btSoftBody psb,
									btIDebugDraw idraw,
									int mindepth/*=0*/,
									int maxdepth/*=-1*/);
	public static native void DrawClusterTree(btSoftBody psb,
									btIDebugDraw idraw);
	/* Draw rigid frame														*/
	public static native void DrawFrame(btSoftBody psb,
							  btIDebugDraw idraw);
	/* Create a rope														*/
	public static native btSoftBody CreateRope(@ByRef btSoftBodyWorldInfo worldInfo,
									  @Const @ByRef btVector3 from,
									  @Const @ByRef btVector3 to,
									  int res,
									  int fixeds);
	/* Create a patch														*/
	public static native btSoftBody CreatePatch(@ByRef btSoftBodyWorldInfo worldInfo,
									   @Const @ByRef btVector3 corner00,
									   @Const @ByRef btVector3 corner10,
									   @Const @ByRef btVector3 corner01,
									   @Const @ByRef btVector3 corner11,
									   int resx,
									   int resy,
									   int fixeds,
									   @Cast("bool") boolean gendiags,
									   @Cast("btScalar") double perturbation/*=0.*/);
	public static native btSoftBody CreatePatch(@ByRef btSoftBodyWorldInfo worldInfo,
									   @Const @ByRef btVector3 corner00,
									   @Const @ByRef btVector3 corner10,
									   @Const @ByRef btVector3 corner01,
									   @Const @ByRef btVector3 corner11,
									   int resx,
									   int resy,
									   int fixeds,
									   @Cast("bool") boolean gendiags);
	/* Create a patch with UV Texture Coordinates	*/
	public static native btSoftBody CreatePatchUV(@ByRef btSoftBodyWorldInfo worldInfo,
										 @Const @ByRef btVector3 corner00,
										 @Const @ByRef btVector3 corner10,
										 @Const @ByRef btVector3 corner01,
										 @Const @ByRef btVector3 corner11,
										 int resx,
										 int resy,
										 int fixeds,
										 @Cast("bool") boolean gendiags,
										 FloatPointer tex_coords/*=0*/);
	public static native btSoftBody CreatePatchUV(@ByRef btSoftBodyWorldInfo worldInfo,
										 @Const @ByRef btVector3 corner00,
										 @Const @ByRef btVector3 corner10,
										 @Const @ByRef btVector3 corner01,
										 @Const @ByRef btVector3 corner11,
										 int resx,
										 int resy,
										 int fixeds,
										 @Cast("bool") boolean gendiags);
	public static native btSoftBody CreatePatchUV(@ByRef btSoftBodyWorldInfo worldInfo,
										 @Const @ByRef btVector3 corner00,
										 @Const @ByRef btVector3 corner10,
										 @Const @ByRef btVector3 corner01,
										 @Const @ByRef btVector3 corner11,
										 int resx,
										 int resy,
										 int fixeds,
										 @Cast("bool") boolean gendiags,
										 FloatBuffer tex_coords/*=0*/);
	public static native btSoftBody CreatePatchUV(@ByRef btSoftBodyWorldInfo worldInfo,
										 @Const @ByRef btVector3 corner00,
										 @Const @ByRef btVector3 corner10,
										 @Const @ByRef btVector3 corner01,
										 @Const @ByRef btVector3 corner11,
										 int resx,
										 int resy,
										 int fixeds,
										 @Cast("bool") boolean gendiags,
										 float[] tex_coords/*=0*/);
	public static native float CalculateUV(int resx, int resy, int ix, int iy, int id);
	/* Create an ellipsoid													*/
	public static native btSoftBody CreateEllipsoid(@ByRef btSoftBodyWorldInfo worldInfo,
										   @Const @ByRef btVector3 center,
										   @Const @ByRef btVector3 radius,
										   int res);
	/* Create from trimesh													*/
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") DoublePointer vertices,
											 @Const IntPointer triangles,
											 int ntriangles,
											 @Cast("bool") boolean randomizeConstraints/*=true*/);
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") DoublePointer vertices,
											 @Const IntPointer triangles,
											 int ntriangles);
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") DoubleBuffer vertices,
											 @Const IntBuffer triangles,
											 int ntriangles,
											 @Cast("bool") boolean randomizeConstraints/*=true*/);
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") DoubleBuffer vertices,
											 @Const IntBuffer triangles,
											 int ntriangles);
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") double[] vertices,
											 @Const int[] triangles,
											 int ntriangles,
											 @Cast("bool") boolean randomizeConstraints/*=true*/);
	public static native btSoftBody CreateFromTriMesh(@ByRef btSoftBodyWorldInfo worldInfo,
											 @Cast("const btScalar*") double[] vertices,
											 @Const int[] triangles,
											 int ntriangles);
	/* Create from convex-hull												*/
	public static native btSoftBody CreateFromConvexHull(@ByRef btSoftBodyWorldInfo worldInfo,
												@Const btVector3 vertices,
												int nvertices,
												@Cast("bool") boolean randomizeConstraints/*=true*/);
	public static native btSoftBody CreateFromConvexHull(@ByRef btSoftBodyWorldInfo worldInfo,
												@Const btVector3 vertices,
												int nvertices);

	/* Export TetGen compatible .smesh file									*/
	//	static void				ExportAsSMeshFile(	btSoftBody* psb,
	//												const char* filename);
	/* Create from TetGen .ele, .face, .node files							*/
	//	static btSoftBody*		CreateFromTetGenFile(	btSoftBodyWorldInfo& worldInfo,
	//													const char* ele,
	//													const char* face,
	//													const char* node,
	//													bool bfacelinks,
	//													bool btetralinks,
	//													bool bfacesfromtetras);
	/* Create from TetGen .ele, .face, .node data							*/
	public static native btSoftBody CreateFromTetGenData(@ByRef btSoftBodyWorldInfo worldInfo,
												@Cast("const char*") BytePointer ele,
												@Cast("const char*") BytePointer face,
												@Cast("const char*") BytePointer node,
												@Cast("bool") boolean bfacelinks,
												@Cast("bool") boolean btetralinks,
												@Cast("bool") boolean bfacesfromtetras);
	public static native btSoftBody CreateFromTetGenData(@ByRef btSoftBodyWorldInfo worldInfo,
												String ele,
												String face,
												String node,
												@Cast("bool") boolean bfacelinks,
												@Cast("bool") boolean btetralinks,
												@Cast("bool") boolean bfacesfromtetras);
	public static native btSoftBody CreateFromVtkFile(@ByRef btSoftBodyWorldInfo worldInfo, @Cast("const char*") BytePointer vtk_file);
	public static native btSoftBody CreateFromVtkFile(@ByRef btSoftBodyWorldInfo worldInfo, String vtk_file);

	public static native void writeObj(@Cast("const char*") BytePointer file, @Const btSoftBody psb);
	public static native void writeObj(String file, @Const btSoftBody psb);

	public static native void writeState(@Cast("const char*") BytePointer file, @Const btSoftBody psb);
	public static native void writeState(String file, @Const btSoftBody psb);

  //this code cannot be here, dependency on example code are not allowed
	//static std::string loadDeformableState(btAlignedObjectArray<btVector3>& qs, btAlignedObjectArray<btVector3>& vs, const char* filename, CommonFileIOInterface* fileIO);

	public static native void getBarycentricWeights(@Const @ByRef btVector3 a, @Const @ByRef btVector3 b, @Const @ByRef btVector3 c, @Const @ByRef btVector3 d, @Const @ByRef btVector3 p, @ByRef btVector4 bary);

	public static native void getBarycentricWeights(@Const @ByRef btVector3 a, @Const @ByRef btVector3 b, @Const @ByRef btVector3 c, @Const @ByRef btVector3 p, @ByRef btVector4 bary);

	public static native void interpolateBarycentricWeights(btSoftBody psb);

	public static native void extrapolateBarycentricWeights(btSoftBody psb);

	public static native void generateBoundaryFaces(btSoftBody psb);

	public static native void duplicateFaces(@Cast("const char*") BytePointer filename, @Const btSoftBody psb);
	public static native void duplicateFaces(String filename, @Const btSoftBody psb);
	/** Sort the list of links to move link calculations that are dependent upon earlier
	 *  ones as far as possible away from the calculation of those values
	 *  This tends to make adjacent loop iterations not dependent upon one another,
	 *  so out-of-order processors can execute instructions from multiple iterations at once */
	public static native void ReoptimizeLinkOrder(btSoftBody psb);
}
