// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.BulletSoftBody.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;
import org.bytedeco.bullet.BulletDynamics.*;
import static org.bytedeco.bullet.global.BulletDynamics.*;

public class BulletSoftBody extends org.bytedeco.bullet.presets.BulletSoftBody {
    static { Loader.load(); }

// Parsed from LinearMath/btAlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBJECT_ARRAY__
// #define BT_OBJECT_ARRAY__

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE
// #include "btAlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable BT_USE_PLACEMENT_NEW
 * then the btAlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable BT_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int BT_USE_PLACEMENT_NEW = 1;
//#define BT_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define BT_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef BT_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //BT_USE_MEMCPY

// #ifdef BT_USE_PLACEMENT_NEW
// #include <new>
// Targeting ../BulletSoftBody/LagrangeMultiplierArray.java


// Targeting ../BulletSoftBody/btDeformableFaceNodeContactConstraintArrayArray.java


// Targeting ../BulletSoftBody/btDeformableFaceRigidContactConstraintArrayArray.java


// Targeting ../BulletSoftBody/btDeformableNodeAnchorConstraintArrayArray.java


// Targeting ../BulletSoftBody/btDeformableNodeRigidContactConstraintArrayArray.java


// Targeting ../BulletSoftBody/btDeformableStaticConstraintArrayArray.java


// Targeting ../BulletSoftBody/btDeformableContactConstraintArray.java


// Targeting ../BulletSoftBody/btDeformableFaceNodeContactConstraintArray.java


// Targeting ../BulletSoftBody/btDeformableFaceRigidContactConstraintArray.java


// Targeting ../BulletSoftBody/btDeformableLagrangianForceArray.java


// Targeting ../BulletSoftBody/btDeformableNodeAnchorConstraintArray.java


// Targeting ../BulletSoftBody/btDeformableNodeRigidContactConstraintArray.java


// Targeting ../BulletSoftBody/btDeformableStaticConstraintArray.java


// Targeting ../BulletSoftBody/btSoftBodyArray.java


// Targeting ../BulletSoftBody/btSoftBodyAnchorArray.java


// Targeting ../BulletSoftBody/btSoftBodyClusterArray.java


// Targeting ../BulletSoftBody/btSoftBodyDeformableFaceNodeContactArray.java


// Targeting ../BulletSoftBody/btSoftBodyDeformableFaceRigidContactArray.java


// Targeting ../BulletSoftBody/btSoftBodyDeformableNodeRigidAnchorArray.java


// Targeting ../BulletSoftBody/btSoftBodyDeformableNodeRigidContactArray.java


// Targeting ../BulletSoftBody/btSoftBodyFaceArray.java


// Targeting ../BulletSoftBody/btSoftBodyJointArray.java


// Targeting ../BulletSoftBody/btSoftBodyLinkArray.java


// Targeting ../BulletSoftBody/btSoftBodyMaterialArray.java


// Targeting ../BulletSoftBody/btSoftBodyNodePointerArray.java


// Targeting ../BulletSoftBody/btSoftBodyNodeArray.java


// Targeting ../BulletSoftBody/btSoftBodyNoteArray.java


// Targeting ../BulletSoftBody/btSoftBodyRContactArray.java


// Targeting ../BulletSoftBody/btSoftBodyRenderFaceArray.java


// Targeting ../BulletSoftBody/btSoftBodyRenderNodeArray.java


// Targeting ../BulletSoftBody/btSoftBodySContactArray.java


// Targeting ../BulletSoftBody/btSoftBodyTetraArray.java


// Targeting ../BulletSoftBody/btSoftBodyTetraSratchArray.java


// Targeting ../BulletSoftBody/btSparseSdf3CellArray.java



// #endif  //BT_OBJECT_ARRAY__


// Parsed from BulletSoftBody/btSoftBody.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**btSoftBody implementation by Nathanael Presson */

// #ifndef _BT_SOFT_BODY_H
// #define _BT_SOFT_BODY_H

// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btIDebugDraw.h"
// #include "LinearMath/btVector3.h"
// #include "BulletDynamics/Dynamics/btRigidBody.h"

// #include "BulletCollision/CollisionShapes/btConcaveShape.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "btSparseSDF.h"
// #include "BulletCollision/BroadphaseCollision/btDbvt.h"
// #include "BulletDynamics/Featherstone/btMultiBodyLinkCollider.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraint.h"
//#ifdef BT_USE_DOUBLE_PRECISION
//#define btRigidBodyData	btRigidBodyDoubleData
//#define btRigidBodyDataName	"btRigidBodyDoubleData"
//#else
// #define btSoftBodyData btSoftBodyFloatData
public static final String btSoftBodyDataName = "btSoftBodyFloatData";
@MemberGetter public static native @Cast("const btScalar") double OVERLAP_REDUCTION_FACTOR();
public static final double OVERLAP_REDUCTION_FACTOR = OVERLAP_REDUCTION_FACTOR();
public static native @Cast("unsigned long") long seed(); public static native void seed(long setter);
//#endif //BT_USE_DOUBLE_PRECISION
// Targeting ../BulletSoftBody/btSoftBodyWorldInfo.java


// Targeting ../BulletSoftBody/btSoftBody.java



// #endif  //_BT_SOFT_BODY_H


// Parsed from BulletSoftBody/btCGProjection.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_CG_PROJECTION_H
// #define BT_CG_PROJECTION_H

// #include "btSoftBody.h"
// #include "BulletDynamics/Featherstone/btMultiBodyLinkCollider.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraint.h"
// Targeting ../BulletSoftBody/DeformableContactConstraint.java


// Targeting ../BulletSoftBody/btCGProjection.java



// #endif /* btCGProjection_h */


// Parsed from BulletSoftBody/btConjugateGradient.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_CONJUGATE_GRADIENT_H
// #define BT_CONJUGATE_GRADIENT_H
// #include "btKrylovSolver.h"
// #endif /* btConjugateGradient_h */


// Parsed from BulletSoftBody/btConjugateResidual.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_CONJUGATE_RESIDUAL_H
// #define BT_CONJUGATE_RESIDUAL_H
// #include "btKrylovSolver.h"
// #endif /* btConjugateResidual_h */


// Parsed from BulletSoftBody/btDefaultSoftBodySolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_BODY_DEFAULT_SOLVER_H
// #define BT_SOFT_BODY_DEFAULT_SOLVER_H

// #include "BulletSoftBody/btSoftBodySolvers.h"
// #include "btSoftBodySolverVertexBuffer.h"
// Targeting ../BulletSoftBody/btDefaultSoftBodySolver.java



// #endif  // #ifndef BT_ACCELERATED_SOFT_BODY_CPU_SOLVER_H


// Parsed from BulletSoftBody/btDeformableBackwardEulerObjective.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_BACKWARD_EULER_OBJECTIVE_H
// #define BT_BACKWARD_EULER_OBJECTIVE_H
//#include "btConjugateGradient.h"
// #include "btDeformableLagrangianForce.h"
// #include "btDeformableMassSpringForce.h"
// #include "btDeformableGravityForce.h"
// #include "btDeformableCorotatedForce.h"
// #include "btDeformableMousePickingForce.h"
// #include "btDeformableLinearElasticityForce.h"
// #include "btDeformableNeoHookeanForce.h"
// #include "btDeformableContactProjection.h"
// #include "btPreconditioner.h"
// #include "btDeformableMultiBodyDynamicsWorld.h"
// #include "LinearMath/btQuickprof.h"
// Targeting ../BulletSoftBody/btDeformableBackwardEulerObjective.java



// #endif /* btBackwardEulerObjective_h */


// Parsed from BulletSoftBody/btDeformableBodySolver.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_BODY_SOLVERS_H
// #define BT_DEFORMABLE_BODY_SOLVERS_H

// #include "btSoftBodySolvers.h"
// #include "btDeformableBackwardEulerObjective.h"
// #include "btDeformableMultiBodyDynamicsWorld.h"
// #include "BulletDynamics/Featherstone/btMultiBodyLinkCollider.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraint.h"
// #include "btConjugateResidual.h"
// #include "btConjugateGradient.h"
// Targeting ../BulletSoftBody/btDeformableBodySolver.java



// #endif /* btDeformableBodySolver_h */


// Parsed from BulletSoftBody/btDeformableContactConstraint.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_CONTACT_CONSTRAINT_H
// #define BT_DEFORMABLE_CONTACT_CONSTRAINT_H
// #include "btSoftBody.h"
// Targeting ../BulletSoftBody/btDeformableContactConstraint.java


// Targeting ../BulletSoftBody/btDeformableStaticConstraint.java


// Targeting ../BulletSoftBody/btDeformableNodeAnchorConstraint.java


// Targeting ../BulletSoftBody/btDeformableRigidContactConstraint.java


// Targeting ../BulletSoftBody/btDeformableNodeRigidContactConstraint.java


// Targeting ../BulletSoftBody/btDeformableFaceRigidContactConstraint.java


// Targeting ../BulletSoftBody/btDeformableFaceNodeContactConstraint.java


// #endif /* BT_DEFORMABLE_CONTACT_CONSTRAINT_H */


// Parsed from BulletSoftBody/btDeformableContactProjection.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_CONTACT_PROJECTION_H
// #define BT_CONTACT_PROJECTION_H
// #include "btCGProjection.h"
// #include "btSoftBody.h"
// #include "BulletDynamics/Featherstone/btMultiBodyLinkCollider.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraint.h"
// #include "btDeformableContactConstraint.h"
// #include "LinearMath/btHashMap.h"
// #include "LinearMath/btReducedVector.h"
// #include "LinearMath/btModifiedGramSchmidt.h"
// #include <vector>
// Targeting ../BulletSoftBody/LagrangeMultiplier.java


// Targeting ../BulletSoftBody/btDeformableContactProjection.java


// #endif /* btDeformableContactProjection_h */


// Parsed from BulletSoftBody/btDeformableLagrangianForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_LAGRANGIAN_FORCE_H
// #define BT_DEFORMABLE_LAGRANGIAN_FORCE_H

// #include "btSoftBody.h"
// #include <LinearMath/btHashMap.h>
// #include <iostream>

/** enum btDeformableLagrangianForceType */
public static final int
	BT_GRAVITY_FORCE = 1,
	BT_MASSSPRING_FORCE = 2,
	BT_COROTATED_FORCE = 3,
	BT_NEOHOOKEAN_FORCE = 4,
	BT_LINEAR_ELASTICITY_FORCE = 5,
	BT_MOUSE_PICKING_FORCE = 6;

public static native double randomDouble(double low, double high);
// Targeting ../BulletSoftBody/btDeformableLagrangianForce.java


// #endif /* BT_DEFORMABLE_LAGRANGIAN_FORCE */


// Parsed from BulletSoftBody/btDeformableCorotatedForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_COROTATED_H
// #define BT_COROTATED_H

// #include "btDeformableLagrangianForce.h"
// #include "LinearMath/btPolarDecomposition.h"

public static native int PolarDecomposition(@Const @ByRef btMatrix3x3 m, @ByRef btMatrix3x3 q, @ByRef btMatrix3x3 s);
// Targeting ../BulletSoftBody/btDeformableCorotatedForce.java



// #endif /* btCorotated_h */


// Parsed from BulletSoftBody/btDeformableGravityForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_GRAVITY_FORCE_H
// #define BT_DEFORMABLE_GRAVITY_FORCE_H

// #include "btDeformableLagrangianForce.h"
// Targeting ../BulletSoftBody/btDeformableGravityForce.java


// #endif /* BT_DEFORMABLE_GRAVITY_FORCE_H */


// Parsed from BulletSoftBody/btDeformableLinearElasticityForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_LINEAR_ELASTICITY_H
// #define BT_LINEAR_ELASTICITY_H

// #include "btDeformableLagrangianForce.h"
// #include "LinearMath/btQuickprof.h"
// #include "btSoftBodyInternals.h"
public static final double TETRA_FLAT_THRESHOLD = 0.01;
// Targeting ../BulletSoftBody/btDeformableLinearElasticityForce.java


// #endif /* BT_LINEAR_ELASTICITY_H */


// Parsed from BulletSoftBody/btDeformableMassSpringForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_MASS_SPRING_H
// #define BT_MASS_SPRING_H

// #include "btDeformableLagrangianForce.h"
// Targeting ../BulletSoftBody/btDeformableMassSpringForce.java



// #endif /* btMassSpring_h */


// Parsed from BulletSoftBody/btDeformableMousePickingForce.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_MOUSE_PICKING_FORCE_H
// #define BT_MOUSE_PICKING_FORCE_H

// #include "btDeformableLagrangianForce.h"
// Targeting ../BulletSoftBody/btDeformableMousePickingForce.java



// #endif /* btMassSpring_h */


// Parsed from BulletSoftBody/btDeformableMultiBodyConstraintSolver.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_MULTIBODY_CONSTRAINT_SOLVER_H
// #define BT_DEFORMABLE_MULTIBODY_CONSTRAINT_SOLVER_H

// #include "btDeformableBodySolver.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraintSolver.h"
// Targeting ../BulletSoftBody/btDeformableMultiBodyConstraintSolver.java



// #endif /* BT_DEFORMABLE_MULTIBODY_CONSTRAINT_SOLVER_H */


// Parsed from BulletSoftBody/btDeformableMultiBodyDynamicsWorld.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_DEFORMABLE_MULTIBODY_DYNAMICS_WORLD_H
// #define BT_DEFORMABLE_MULTIBODY_DYNAMICS_WORLD_H

// #include "btSoftMultiBodyDynamicsWorld.h"
// #include "btDeformableLagrangianForce.h"
// #include "btDeformableMassSpringForce.h"
// #include "btDeformableBodySolver.h"
// #include "btDeformableMultiBodyConstraintSolver.h"
// #include "btSoftBodyHelpers.h"
// #include "BulletCollision/CollisionDispatch/btSimulationIslandManager.h"
// #include <functional>
// Targeting ../BulletSoftBody/btDeformableMultiBodyDynamicsWorld.java



// #endif  //BT_DEFORMABLE_MULTIBODY_DYNAMICS_WORLD_H


// Parsed from BulletSoftBody/btDeformableNeoHookeanForce.h

/*
Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>

Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2019 Google Inc. http://bulletphysics.org
This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:
1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_NEOHOOKEAN_H
// #define BT_NEOHOOKEAN_H

// #include "btDeformableLagrangianForce.h"
// #include "LinearMath/btQuickprof.h"
// #include "LinearMath/btImplicitQRSVD.h"
// Targeting ../BulletSoftBody/btDeformableNeoHookeanForce.java


// #endif /* BT_NEOHOOKEAN_H */


// Parsed from BulletSoftBody/btKrylovSolver.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_KRYLOV_SOLVER_H
// #define BT_KRYLOV_SOLVER_H
// #include <iostream>
// #include <cmath>
// #include <limits>
// #include <LinearMath/btAlignedObjectArray.h>
// #include <LinearMath/btVector3.h>
// #include <LinearMath/btScalar.h>
// #include "LinearMath/btQuickprof.h"
// #endif /* BT_KRYLOV_SOLVER_H */


// Parsed from BulletSoftBody/btPreconditioner.h

/*
 Written by Xuchen Han <xuchenhan2015@u.northwestern.edu>
 
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_PRECONDITIONER_H
// #define BT_PRECONDITIONER_H
// Targeting ../BulletSoftBody/Preconditioner.java


// Targeting ../BulletSoftBody/DefaultPreconditioner.java


// Targeting ../BulletSoftBody/MassPreconditioner.java


// Targeting ../BulletSoftBody/KKTPreconditioner.java



// #endif /* BT_PRECONDITIONER_H */


// Parsed from BulletSoftBody/btSoftBodyConcaveCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_BODY_CONCAVE_COLLISION_ALGORITHM_H
// #define BT_SOFT_BODY_CONCAVE_COLLISION_ALGORITHM_H

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"
// #include "BulletCollision/CollisionShapes/btTriangleCallback.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"

// #include "LinearMath/btHashMap.h"

// #include "BulletCollision/BroadphaseCollision/btQuantizedBvh.h"
// Targeting ../BulletSoftBody/btTriIndex.java


// Targeting ../BulletSoftBody/btSoftBodyTriangleCallback.java


// Targeting ../BulletSoftBody/btSoftBodyConcaveCollisionAlgorithm.java



// #endif  //BT_SOFT_BODY_CONCAVE_COLLISION_ALGORITHM_H


// Parsed from BulletSoftBody/btSoftBodyData.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFTBODY_FLOAT_DATA
// #define BT_SOFTBODY_FLOAT_DATA

// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"
// #include "BulletDynamics/Dynamics/btRigidBody.h"
// Targeting ../BulletSoftBody/SoftBodyMaterialData.java


// Targeting ../BulletSoftBody/SoftBodyNodeData.java


// Targeting ../BulletSoftBody/SoftBodyLinkData.java


// Targeting ../BulletSoftBody/SoftBodyFaceData.java


// Targeting ../BulletSoftBody/SoftBodyTetraData.java


// Targeting ../BulletSoftBody/SoftRigidAnchorData.java


// Targeting ../BulletSoftBody/SoftBodyConfigData.java


// Targeting ../BulletSoftBody/SoftBodyPoseData.java


// Targeting ../BulletSoftBody/SoftBodyClusterData.java



/** enum btSoftJointBodyType */
public static final int
	BT_JOINT_SOFT_BODY_CLUSTER = 1,
	BT_JOINT_RIGID_BODY = 2,
	BT_JOINT_COLLISION_OBJECT = 3;
// Targeting ../BulletSoftBody/btSoftBodyJointData.java


// Targeting ../BulletSoftBody/btSoftBodyFloatData.java



// #endif  //BT_SOFTBODY_FLOAT_DATA


// Parsed from BulletSoftBody/btSoftBodyHelpers.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_BODY_HELPERS_H
// #define BT_SOFT_BODY_HELPERS_H

// #include "btSoftBody.h"
// #include <fstream>
// #include <string>
// Targeting ../BulletSoftBody/fDrawFlags.java


// Targeting ../BulletSoftBody/btSoftBodyHelpers.java



// #endif  //BT_SOFT_BODY_HELPERS_H


// Parsed from BulletSoftBody/btSoftBodyInternals.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**btSoftBody implementation by Nathanael Presson */

// #ifndef _BT_SOFT_BODY_INTERNALS_H
// #define _BT_SOFT_BODY_INTERNALS_H

// #include "btSoftBody.h"
// #include "LinearMath/btQuickprof.h"
// #include "LinearMath/btPolarDecomposition.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"
// #include "BulletCollision/CollisionDispatch/btCollisionDispatcher.h"
// #include "BulletCollision/CollisionShapes/btConvexInternalShape.h"
// #include "BulletCollision/NarrowPhaseCollision/btGjkEpa2.h"
// #include "BulletDynamics/Featherstone/btMultiBodyLinkCollider.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraint.h"
// #include <string.h>  //for memset
// #include <cmath>
// #include "poly34.h"

// Given a multibody link, a contact point and a contact direction, fill in the jacobian data needed to calculate the velocity change given an impulse in the contact direction
public static native void findJacobian(@Const btMultiBodyLinkCollider multibodyLinkCol,
										   @ByRef btMultiBodyJacobianData jacobianData,
										   @Const @ByRef btVector3 contact_point,
										   @Const @ByRef btVector3 dir);
public static native @ByVal btVector3 generateUnitOrthogonalVector(@Const @ByRef btVector3 u);

public static native @Cast("bool") boolean proximityTest(@Const @ByRef btVector3 x1, @Const @ByRef btVector3 x2, @Const @ByRef btVector3 x3, @Const @ByRef btVector3 x4, @Const @ByRef btVector3 normal, @Cast("const btScalar") double mrg, @ByRef btVector3 bary);
@MemberGetter public static native int KDOP_COUNT();
public static final int KDOP_COUNT = KDOP_COUNT();
public static native @ByRef btVector3 dop(int i); public static native void dop(int i, btVector3 setter);
@MemberGetter public static native btVector3 dop();

public static native int getSign(@Const @ByRef btVector3 n, @Const @ByRef btVector3 x);

public static native @Cast("bool") boolean hasSeparatingPlane(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt);

public static native @Cast("bool") boolean nearZero(@Cast("const btScalar") double a);
public static native @Cast("bool") boolean sameSign(@Cast("const btScalar") double a, @Cast("const btScalar") double b);
public static native @Cast("bool") boolean diffSign(@Cast("const btScalar") double a, @Cast("const btScalar") double b);
public static native @Cast("btScalar") double evaluateBezier2(@Cast("const btScalar") double p0, @Cast("const btScalar") double p1, @Cast("const btScalar") double p2, @Cast("const btScalar") double t, @Cast("const btScalar") double s);
public static native @Cast("btScalar") double evaluateBezier(@Cast("const btScalar") double p0, @Cast("const btScalar") double p1, @Cast("const btScalar") double p2, @Cast("const btScalar") double p3, @Cast("const btScalar") double t, @Cast("const btScalar") double s);
public static native @Cast("bool") boolean getSigns(@Cast("bool") boolean type_c, @Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("const btScalar") double t1, @Cast("btScalar*") @ByRef DoublePointer lt0, @Cast("btScalar*") @ByRef DoublePointer lt1);
public static native @Cast("bool") boolean getSigns(@Cast("bool") boolean type_c, @Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("const btScalar") double t1, @Cast("btScalar*") @ByRef DoubleBuffer lt0, @Cast("btScalar*") @ByRef DoubleBuffer lt1);
public static native @Cast("bool") boolean getSigns(@Cast("bool") boolean type_c, @Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("const btScalar") double t1, @Cast("btScalar*") @ByRef double[] lt0, @Cast("btScalar*") @ByRef double[] lt1);

public static native void getBernsteinCoeff(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef DoublePointer k0, @Cast("btScalar*") @ByRef DoublePointer k1, @Cast("btScalar*") @ByRef DoublePointer k2, @Cast("btScalar*") @ByRef DoublePointer k3);
public static native void getBernsteinCoeff(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef DoubleBuffer k0, @Cast("btScalar*") @ByRef DoubleBuffer k1, @Cast("btScalar*") @ByRef DoubleBuffer k2, @Cast("btScalar*") @ByRef DoubleBuffer k3);
public static native void getBernsteinCoeff(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef double[] k0, @Cast("btScalar*") @ByRef double[] k1, @Cast("btScalar*") @ByRef double[] k2, @Cast("btScalar*") @ByRef double[] k3);

public static native void polyDecomposition(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double j0, @Cast("const btScalar") double j1, @Cast("const btScalar") double j2, @Cast("btScalar*") @ByRef DoublePointer u0, @Cast("btScalar*") @ByRef DoublePointer u1, @Cast("btScalar*") @ByRef DoublePointer v0, @Cast("btScalar*") @ByRef DoublePointer v1);
public static native void polyDecomposition(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double j0, @Cast("const btScalar") double j1, @Cast("const btScalar") double j2, @Cast("btScalar*") @ByRef DoubleBuffer u0, @Cast("btScalar*") @ByRef DoubleBuffer u1, @Cast("btScalar*") @ByRef DoubleBuffer v0, @Cast("btScalar*") @ByRef DoubleBuffer v1);
public static native void polyDecomposition(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double j0, @Cast("const btScalar") double j1, @Cast("const btScalar") double j2, @Cast("btScalar*") @ByRef double[] u0, @Cast("btScalar*") @ByRef double[] u1, @Cast("btScalar*") @ByRef double[] v0, @Cast("btScalar*") @ByRef double[] v1);

public static native @Cast("bool") boolean rootFindingLemma(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3);

public static native void getJs(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Node a, @Const btSoftBody.Node b, @Const btSoftBody.Node c, @Const btSoftBody.Node p, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef DoublePointer j0, @Cast("btScalar*") @ByRef DoublePointer j1, @Cast("btScalar*") @ByRef DoublePointer j2);
public static native void getJs(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Node a, @Const btSoftBody.Node b, @Const btSoftBody.Node c, @Const btSoftBody.Node p, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef DoubleBuffer j0, @Cast("btScalar*") @ByRef DoubleBuffer j1, @Cast("btScalar*") @ByRef DoubleBuffer j2);
public static native void getJs(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Node a, @Const btSoftBody.Node b, @Const btSoftBody.Node c, @Const btSoftBody.Node p, @Cast("const btScalar") double dt, @Cast("btScalar*") @ByRef double[] j0, @Cast("btScalar*") @ByRef double[] j1, @Cast("btScalar*") @ByRef double[] j2);

public static native @Cast("bool") boolean signDetermination1Internal(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double u0, @Cast("const btScalar") double u1, @Cast("const btScalar") double v0, @Cast("const btScalar") double v1);

public static native @Cast("bool") boolean signDetermination2Internal(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double j0, @Cast("const btScalar") double j1, @Cast("const btScalar") double j2, @Cast("const btScalar") double u0, @Cast("const btScalar") double u1, @Cast("const btScalar") double v0, @Cast("const btScalar") double v1);

public static native @Cast("bool") boolean signDetermination1(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt);

public static native @Cast("bool") boolean signDetermination2(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt);

public static native @Cast("bool") boolean coplanarAndInsideTest(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt);
public static native @Cast("bool") boolean conservativeCulling(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double mrg);

public static native @Cast("bool") boolean bernsteinVFTest(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double mrg, @Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt);

public static native void deCasteljau(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("btScalar*") @ByRef DoublePointer k10, @Cast("btScalar*") @ByRef DoublePointer k20, @Cast("btScalar*") @ByRef DoublePointer k30, @Cast("btScalar*") @ByRef DoublePointer k21, @Cast("btScalar*") @ByRef DoublePointer k12);
public static native void deCasteljau(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("btScalar*") @ByRef DoubleBuffer k10, @Cast("btScalar*") @ByRef DoubleBuffer k20, @Cast("btScalar*") @ByRef DoubleBuffer k30, @Cast("btScalar*") @ByRef DoubleBuffer k21, @Cast("btScalar*") @ByRef DoubleBuffer k12);
public static native void deCasteljau(@Cast("const btScalar") double k0, @Cast("const btScalar") double k1, @Cast("const btScalar") double k2, @Cast("const btScalar") double k3, @Cast("const btScalar") double t0, @Cast("btScalar*") @ByRef double[] k10, @Cast("btScalar*") @ByRef double[] k20, @Cast("btScalar*") @ByRef double[] k30, @Cast("btScalar*") @ByRef double[] k21, @Cast("btScalar*") @ByRef double[] k12);
public static native @Cast("bool") boolean bernsteinVFTest(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("const btScalar") double mrg);

public static native @Cast("bool") boolean continuousCollisionDetection(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("const btScalar") double mrg, @ByRef btVector3 bary);
public static native @Cast("bool") boolean bernsteinCCD(@Const btSoftBody.Face face, @Const btSoftBody.Node node, @Cast("const btScalar") double dt, @Cast("const btScalar") double mrg, @ByRef btVector3 bary);

//
// btSymMatrix
//
// Targeting ../BulletSoftBody/btSoftBodyCollisionShape.java


// Targeting ../BulletSoftBody/btSoftClusterCollisionShape.java



//
// Inline's
//

//
//
//
//
//
//
public static native @ByVal btMatrix3x3 Lerp(@Const @ByRef btMatrix3x3 a,
							   @Const @ByRef btMatrix3x3 b,
							   @Cast("btScalar") double t);
//
public static native @ByVal btVector3 Clamp(@Const @ByRef btVector3 v, @Cast("btScalar") double maxlength);
//
//
//
//
//
//
public static native @Cast("btScalar") double ClusterMetric(@Const @ByRef btVector3 x, @Const @ByRef btVector3 y);
//
public static native @ByVal btMatrix3x3 ScaleAlongAxis(@Const @ByRef btVector3 a, @Cast("btScalar") double s);
//
public static native @ByVal btMatrix3x3 Cross(@Const @ByRef btVector3 v);
//
public static native @ByVal btMatrix3x3 Diagonal(@Cast("btScalar") double x);

public static native @ByVal btMatrix3x3 Diagonal(@Const @ByRef btVector3 v);

public static native @Cast("btScalar") double Dot(@Cast("const btScalar*") DoublePointer a, @Cast("const btScalar*") DoublePointer b, int ndof);
public static native @Cast("btScalar") double Dot(@Cast("const btScalar*") DoubleBuffer a, @Cast("const btScalar*") DoubleBuffer b, int ndof);
public static native @Cast("btScalar") double Dot(@Cast("const btScalar*") double[] a, @Cast("const btScalar*") double[] b, int ndof);

public static native @ByVal btMatrix3x3 OuterProduct(@Cast("const btScalar*") DoublePointer v1, @Cast("const btScalar*") DoublePointer v2, @Cast("const btScalar*") DoublePointer v3,
									   @Cast("const btScalar*") DoublePointer u1, @Cast("const btScalar*") DoublePointer u2, @Cast("const btScalar*") DoublePointer u3, int ndof);
public static native @ByVal btMatrix3x3 OuterProduct(@Cast("const btScalar*") DoubleBuffer v1, @Cast("const btScalar*") DoubleBuffer v2, @Cast("const btScalar*") DoubleBuffer v3,
									   @Cast("const btScalar*") DoubleBuffer u1, @Cast("const btScalar*") DoubleBuffer u2, @Cast("const btScalar*") DoubleBuffer u3, int ndof);
public static native @ByVal btMatrix3x3 OuterProduct(@Cast("const btScalar*") double[] v1, @Cast("const btScalar*") double[] v2, @Cast("const btScalar*") double[] v3,
									   @Cast("const btScalar*") double[] u1, @Cast("const btScalar*") double[] u2, @Cast("const btScalar*") double[] u3, int ndof);

public static native @ByVal btMatrix3x3 OuterProduct(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

//
public static native @ByVal btMatrix3x3 Add(@Const @ByRef btMatrix3x3 a,
							  @Const @ByRef btMatrix3x3 b);
//
public static native @ByVal btMatrix3x3 Sub(@Const @ByRef btMatrix3x3 a,
							  @Const @ByRef btMatrix3x3 b);
//
public static native @ByVal btMatrix3x3 Mul(@Const @ByRef btMatrix3x3 a,
							  @Cast("btScalar") double b);
//
public static native void Orthogonalize(@ByRef btMatrix3x3 m);
//
public static native @ByVal btMatrix3x3 MassMatrix(@Cast("btScalar") double im, @Const @ByRef btMatrix3x3 iwi, @Const @ByRef btVector3 r);

//
public static native @ByVal btMatrix3x3 ImpulseMatrix(@Cast("btScalar") double dt,
										@Cast("btScalar") double ima,
										@Cast("btScalar") double imb,
										@Const @ByRef btMatrix3x3 iwi,
										@Const @ByRef btVector3 r);

//
public static native @ByVal btMatrix3x3 ImpulseMatrix(@Cast("btScalar") double dt,
										@Const @ByRef btMatrix3x3 effective_mass_inv,
										@Cast("btScalar") double imb,
										@Const @ByRef btMatrix3x3 iwi,
										@Const @ByRef btVector3 r);

//
public static native @ByVal btMatrix3x3 ImpulseMatrix(@Cast("btScalar") double ima, @Const @ByRef btMatrix3x3 iia, @Const @ByRef btVector3 ra,
										@Cast("btScalar") double imb, @Const @ByRef btMatrix3x3 iib, @Const @ByRef btVector3 rb);

//
public static native @ByVal btMatrix3x3 AngularImpulseMatrix(@Const @ByRef btMatrix3x3 iia,
											   @Const @ByRef btMatrix3x3 iib);

//
public static native @ByVal btVector3 ProjectOnAxis(@Const @ByRef btVector3 v,
									  @Const @ByRef btVector3 a);
//
public static native @ByVal btVector3 ProjectOnPlane(@Const @ByRef btVector3 v,
									   @Const @ByRef btVector3 a);

//
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef DoublePointer sqd);
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef DoubleBuffer sqd);
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef double[] sqd);
//
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @Const @ByRef btVector3 c,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef DoublePointer sqd);
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @Const @ByRef btVector3 c,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef DoubleBuffer sqd);
public static native void ProjectOrigin(@Const @ByRef btVector3 a,
								 @Const @ByRef btVector3 b,
								 @Const @ByRef btVector3 c,
								 @ByRef btVector3 prj,
								 @Cast("btScalar*") @ByRef double[] sqd);

//
public static native @Cast("bool") boolean rayIntersectsTriangle(@Const @ByRef btVector3 origin, @Const @ByRef btVector3 dir, @Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2, @Cast("btScalar*") @ByRef DoublePointer t);
public static native @Cast("bool") boolean rayIntersectsTriangle(@Const @ByRef btVector3 origin, @Const @ByRef btVector3 dir, @Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2, @Cast("btScalar*") @ByRef DoubleBuffer t);
public static native @Cast("bool") boolean rayIntersectsTriangle(@Const @ByRef btVector3 origin, @Const @ByRef btVector3 dir, @Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2, @Cast("btScalar*") @ByRef double[] t);

public static native @Cast("bool") boolean lineIntersectsTriangle(@Const @ByRef btVector3 rayStart, @Const @ByRef btVector3 rayEnd, @Const @ByRef btVector3 p1, @Const @ByRef btVector3 p2, @Const @ByRef btVector3 p3, @ByRef btVector3 sect, @ByRef btVector3 normal);

//
//
public static native @ByVal btVector3 BaryCoord(@Const @ByRef btVector3 a,
								  @Const @ByRef btVector3 b,
								  @Const @ByRef btVector3 c,
								  @Const @ByRef btVector3 p);

//
public static native @Cast("btScalar") double ImplicitSolve(btSoftBody.ImplicitFn fn,
									 @Const @ByRef btVector3 a,
									 @Const @ByRef btVector3 b,
									 @Cast("const btScalar") double accuracy,
									 int maxiterations/*=256*/);
public static native @Cast("btScalar") double ImplicitSolve(btSoftBody.ImplicitFn fn,
									 @Const @ByRef btVector3 a,
									 @Const @ByRef btVector3 b,
									 @Cast("const btScalar") double accuracy);

public static native void EvaluateMedium(@Const btSoftBodyWorldInfo wfi,
								  @Const @ByRef btVector3 x,
								  @ByRef btSoftBody.sMedium medium);

//
public static native @ByVal btVector3 NormalizeAny(@Const @ByRef btVector3 v);

//
public static native @ByVal @Cast("btDbvtVolume*") btDbvtAabbMm VolumeOf(@Const @ByRef btSoftBody.Face f,
									@Cast("btScalar") double margin);

//
public static native @ByVal btVector3 CenterOf(@Const @ByRef btSoftBody.Face f);

//
public static native @Cast("btScalar") double AreaOf(@Const @ByRef btVector3 x0,
							  @Const @ByRef btVector3 x1,
							  @Const @ByRef btVector3 x2);

//
public static native @Cast("btScalar") double VolumeOf(@Const @ByRef btVector3 x0,
								@Const @ByRef btVector3 x1,
								@Const @ByRef btVector3 x2,
								@Const @ByRef btVector3 x3);

//

//
public static native void ApplyClampedForce(@ByRef btSoftBody.Node n,
									 @Const @ByRef btVector3 f,
									 @Cast("btScalar") double dt);

//
public static native int MatchEdge(@Const btSoftBody.Node a,
							@Const btSoftBody.Node b,
							@Const btSoftBody.Node ma,
							@Const btSoftBody.Node mb);
// Targeting ../BulletSoftBody/btEigen.java



//
// Polar decomposition,
// "Computing the Polar Decomposition with Applications", Nicholas J. Higham, 1986.
//
public static native int PolarDecompose(@Const @ByRef btMatrix3x3 m, @ByRef btMatrix3x3 q, @ByRef btMatrix3x3 s);
// Targeting ../BulletSoftBody/btSoftColliders.java


// #endif  //_BT_SOFT_BODY_INTERNALS_H


// Parsed from BulletSoftBody/btSoftBodyRigidBodyCollisionConfiguration.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFTBODY_RIGIDBODY_COLLISION_CONFIGURATION
// #define BT_SOFTBODY_RIGIDBODY_COLLISION_CONFIGURATION

// #include "BulletCollision/CollisionDispatch/btDefaultCollisionConfiguration.h"
// Targeting ../BulletSoftBody/btSoftBodyRigidBodyCollisionConfiguration.java



// #endif  //BT_SOFTBODY_RIGIDBODY_COLLISION_CONFIGURATION


// Parsed from BulletSoftBody/btSoftBodySolvers.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_BODY_SOLVERS_H
// #define BT_SOFT_BODY_SOLVERS_H

// #include "BulletCollision/CollisionShapes/btTriangleIndexVertexArray.h"
// Targeting ../BulletSoftBody/btSoftBodyTriangleData.java


// Targeting ../BulletSoftBody/btSoftBodyLinkData.java


// Targeting ../BulletSoftBody/btSoftBodyVertexData.java


// Targeting ../BulletSoftBody/btSoftBodySolver.java


// Targeting ../BulletSoftBody/btSoftBodySolverOutput.java



// #endif  // #ifndef BT_SOFT_BODY_SOLVERS_H


// Parsed from BulletSoftBody/btSoftBodySolverVertexBuffer.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_BODY_SOLVER_VERTEX_BUFFER_H
// #define BT_SOFT_BODY_SOLVER_VERTEX_BUFFER_H
// Targeting ../BulletSoftBody/btVertexBufferDescriptor.java


// Targeting ../BulletSoftBody/btCPUVertexBufferDescriptor.java



// #endif  // #ifndef BT_SOFT_BODY_SOLVER_VERTEX_BUFFER_H


// Parsed from BulletSoftBody/btSoftMultiBodyDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_MULTIBODY_DYNAMICS_WORLD_H
// #define BT_SOFT_MULTIBODY_DYNAMICS_WORLD_H

// #include "BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h"
// #include "BulletDynamics/Featherstone/btMultiBodyDynamicsWorld.h"
// #include "BulletSoftBody/btSoftBody.h"

// #ifndef BT_SOFT_RIGID_DYNAMICS_WORLD_H
// Targeting ../BulletSoftBody/btSoftMultiBodyDynamicsWorld.java



// #endif  //BT_SOFT_MULTIBODY_DYNAMICS_WORLD_H


// Parsed from BulletSoftBody/btSoftRigidCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_RIGID_COLLISION_ALGORITHM_H
// #define BT_SOFT_RIGID_COLLISION_ALGORITHM_H

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "BulletCollision/CollisionDispatch/btCollisionDispatcher.h"

// #include "LinearMath/btVector3.h"
// Targeting ../BulletSoftBody/btSoftRigidCollisionAlgorithm.java



// #endif  //BT_SOFT_RIGID_COLLISION_ALGORITHM_H


// Parsed from BulletSoftBody/btSoftRigidDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_RIGID_DYNAMICS_WORLD_H
// #define BT_SOFT_RIGID_DYNAMICS_WORLD_H

// #include "BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h"
// #include "btSoftBody.h"
// Targeting ../BulletSoftBody/btSoftRigidDynamicsWorld.java



// #endif  //BT_SOFT_RIGID_DYNAMICS_WORLD_H


// Parsed from BulletSoftBody/btSoftSoftCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOFT_SOFT_COLLISION_ALGORITHM_H
// #define BT_SOFT_SOFT_COLLISION_ALGORITHM_H

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// Targeting ../BulletSoftBody/btSoftSoftCollisionAlgorithm.java



// #endif  //BT_SOFT_SOFT_COLLISION_ALGORITHM_H


// Parsed from BulletSoftBody/btSparseSDF.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**btSparseSdf implementation by Nathanael Presson */

// #ifndef BT_SPARSE_SDF_H
// #define BT_SPARSE_SDF_H

// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"
// #include "BulletCollision/NarrowPhaseCollision/btGjkEpa2.h"

// Fast Hash

// #if !defined(get16bits)
// #define get16bits(d) ((((unsigned int)(((const unsigned char*)(d))[1])) << 8) + (unsigned int)(((const unsigned char*)(d))[0]))
// #endif
//
// super hash function by Paul Hsieh
//
public static native @Cast("unsigned int") int HsiehHash(@Cast("const char*") BytePointer data, int len);
public static native @Cast("unsigned int") int HsiehHash(String data, int len);
// Targeting ../BulletSoftBody/btSparseSdf3.java



// #endif  //BT_SPARSE_SDF_H


// Parsed from BulletSoftBody/DeformableBodyInplaceSolverIslandCallback.h

//
//  DeformableBodyInplaceSolverIslandCallback.h
//  BulletSoftBody
//
//  Created by Xuchen Han on 12/16/19.
//

// #ifndef DeformableBodyInplaceSolverIslandCallback_h
// #define DeformableBodyInplaceSolverIslandCallback_h
// Targeting ../BulletSoftBody/DeformableBodyInplaceSolverIslandCallback.java



// #endif /* DeformableBodyInplaceSolverIslandCallback_h */


}
