// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Common;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.Bullet3Common.*;

@Name("b3AlignedObjectArray<int>") @NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3Common.class)
public class b3IntArray extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3IntArray(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3IntArray(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3IntArray position(long position) {
        return (b3IntArray)super.position(position);
    }
    @Override public b3IntArray getPointer(long i) {
        return new b3IntArray((Pointer)this).offsetAddress(i);
    }

	public native @ByRef @Name("operator =") b3IntArray put(@Const @ByRef b3IntArray other);
	public b3IntArray() { super((Pointer)null); allocate(); }
	private native void allocate();

	/**Generally it is best to avoid using the copy constructor of an b3AlignedObjectArray, and use a (const) reference to the array instead. */
	public b3IntArray(@Const @ByRef b3IntArray otherArray) { super((Pointer)null); allocate(otherArray); }
	private native void allocate(@Const @ByRef b3IntArray otherArray);

	/** return the number of elements in the array */
	public native int size();

	public native @ByRef IntPointer at(int n);

	public native @ByRef @Name("operator []") IntPointer get(int n);

	/**clear the array, deallocated memory. Generally it is better to use array.resize(0), to reduce performance overhead of run-time memory (de)allocations. */
	public native void clear();

	public native void pop_back();

	/**resize changes the number of elements in the array. If the new size is larger, the new elements will be constructed using the optional second argument.
	 * when the new number of elements is smaller, the destructor will be called, but memory will not be freed, to reduce performance overhead of run-time memory (de)allocations. */
	public native void resizeNoInitialize(int newsize);

	public native void resize(int newsize, int fillData/*=int()*/);
	public native void resize(int newsize);
	public native @ByRef IntPointer expandNonInitializing();

	public native @ByRef IntPointer expand(int fillValue/*=int()*/);
	public native @ByRef IntPointer expand();

	public native void push_back(int _Val);

	/** return the pre-allocated (reserved) elements, this is at least as large as the total number of elements,see size() and reserve() */
	public native @Name("capacity") int _capacity();

	public native void reserve(int _Count);

	/**heap sort from http://www.csse.monash.edu.au/~lloyd/tildeAlgDS/Sort/Heap/ */ /*downHeap*/

	public native void swap(int index0, int index1);

	/**non-recursive binary search, assumes sorted array */
	public native int findBinarySearch(int key);

	public native int findLinearSearch(int key);

	public native int findLinearSearch2(int key);

	public native void remove(int key);

	//PCK: whole function
	public native void initializeFromBuffer(Pointer buffer, int size, int _capacity);

	public native void copyFromArray(@Const @ByRef b3IntArray otherArray);

	public native void removeAtIndex(int index);
}
