// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Common;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.Bullet3Common.*;

// #endif  //B3_USE_DOUBLE_PRECISION

/**\brief The b3Matrix3x3 class implements a 3x3 rotation matrix, to perform linear algebra in combination with b3Quaternion, b3Transform and b3Vector3.
* Make sure to only include a pure orthogonal matrix without scaling. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3Common.class)
public class b3Matrix3x3 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3Matrix3x3(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3Matrix3x3(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3Matrix3x3 position(long position) {
        return (b3Matrix3x3)super.position(position);
    }
    @Override public b3Matrix3x3 getPointer(long i) {
        return new b3Matrix3x3((Pointer)this).offsetAddress(i);
    }

	/** \brief No initializaion constructor */
	public b3Matrix3x3() { super((Pointer)null); allocate(); }
	private native void allocate();

	//		explicit b3Matrix3x3(const b3Scalar *m) { setFromOpenGLSubMatrix(m); }

	/**\brief Constructor from Quaternion */
	public b3Matrix3x3(@Const @ByRef b3Quaternion q) { super((Pointer)null); allocate(q); }
	private native void allocate(@Const @ByRef b3Quaternion q);
	/*
	template <typename b3Scalar>
	Matrix3x3(const b3Scalar& yaw, const b3Scalar& pitch, const b3Scalar& roll)
	{ 
	setEulerYPR(yaw, pitch, roll);
	}
	*/
	/** \brief Constructor with row major formatting */
	public b3Matrix3x3(@Cast("const b3Scalar") float xx, @Cast("const b3Scalar") float xy, @Cast("const b3Scalar") float xz,
					@Cast("const b3Scalar") float yx, @Cast("const b3Scalar") float yy, @Cast("const b3Scalar") float yz,
					@Cast("const b3Scalar") float zx, @Cast("const b3Scalar") float zy, @Cast("const b3Scalar") float zz) { super((Pointer)null); allocate(xx, xy, xz, yx, yy, yz, zx, zy, zz); }
	private native void allocate(@Cast("const b3Scalar") float xx, @Cast("const b3Scalar") float xy, @Cast("const b3Scalar") float xz,
					@Cast("const b3Scalar") float yx, @Cast("const b3Scalar") float yy, @Cast("const b3Scalar") float yz,
					@Cast("const b3Scalar") float zx, @Cast("const b3Scalar") float zy, @Cast("const b3Scalar") float zz);

// #if (defined(B3_USE_SSE_IN_API) && defined(B3_USE_SSE)) || defined(B3_USE_NEON)

// #else

	/** \brief Copy constructor */
	public b3Matrix3x3(@Const @ByRef b3Matrix3x3 other) { super((Pointer)null); allocate(other); }
	private native void allocate(@Const @ByRef b3Matrix3x3 other);

	/** \brief Assignment Operator */
	public native @ByRef @Name("operator =") b3Matrix3x3 put(@Const @ByRef b3Matrix3x3 other);

// #endif

	/** \brief Get a column of the matrix as a vector 
	*  @param i Column number 0 indexed */
	public native @ByVal b3Vector3 getColumn(int i);

	/** \brief Get a row of the matrix as a vector 
	*  @param i Row number 0 indexed */
	public native @Const @ByRef b3Vector3 getRow(int i);

	/** \brief Get a mutable reference to a row of the matrix as a vector 
	*  @param i Row number 0 indexed */
	public native @ByRef @Name("operator []") b3Vector3 get(int i);

	/** \brief Get a const reference to a row of the matrix as a vector 
	*  @param i Row number 0 indexed */

	/** \brief Multiply by the target matrix on the right
	*  @param m Rotation matrix to be applied 
	* Equivilant to this = this * m */
	public native @ByRef @Name("operator *=") b3Matrix3x3 multiplyPut(@Const @ByRef b3Matrix3x3 m);

	/** \brief Adds by the target matrix on the right
	*  @param m matrix to be applied 
	* Equivilant to this = this + m */
	public native @ByRef @Name("operator +=") b3Matrix3x3 addPut(@Const @ByRef b3Matrix3x3 m);

	/** \brief Substractss by the target matrix on the right
	*  @param m matrix to be applied 
	* Equivilant to this = this - m */
	public native @ByRef @Name("operator -=") b3Matrix3x3 subtractPut(@Const @ByRef b3Matrix3x3 m);

	/** \brief Set from the rotational part of a 4x4 OpenGL matrix
	*  @param m A pointer to the beginning of the array of scalars*/
	public native void setFromOpenGLSubMatrix(@Cast("const b3Scalar*") FloatPointer m);
	public native void setFromOpenGLSubMatrix(@Cast("const b3Scalar*") FloatBuffer m);
	public native void setFromOpenGLSubMatrix(@Cast("const b3Scalar*") float[] m);
	/** \brief Set the values of the matrix explicitly (row major)
	*  @param xx Top left
	*  @param xy Top Middle
	*  @param xz Top Right
	*  @param yx Middle Left
	*  @param yy Middle Middle
	*  @param yz Middle Right
	*  @param zx Bottom Left
	*  @param zy Bottom Middle
	*  @param zz Bottom Right*/
	public native void setValue(@Cast("const b3Scalar") float xx, @Cast("const b3Scalar") float xy, @Cast("const b3Scalar") float xz,
					  @Cast("const b3Scalar") float yx, @Cast("const b3Scalar") float yy, @Cast("const b3Scalar") float yz,
					  @Cast("const b3Scalar") float zx, @Cast("const b3Scalar") float zy, @Cast("const b3Scalar") float zz);

	/** \brief Set the matrix from a quaternion
	*  @param q The Quaternion to match */
	public native void setRotation(@Const @ByRef b3Quaternion q);

	/** \brief Set the matrix from euler angles using YPR around YXZ respectively
	*  @param yaw Yaw about Y axis
	*  @param pitch Pitch about X axis
	*  @param roll Roll about Z axis 
	*/
	public native void setEulerYPR(@Cast("const b3Scalar") float yaw, @Cast("const b3Scalar") float pitch, @Cast("const b3Scalar") float roll);

	/** \brief Set the matrix from euler angles YPR around ZYX axes
	* @param eulerX Roll about X axis
	* @param eulerY Pitch around Y axis
	* @param eulerZ Yaw aboud Z axis
	* 
	* These angles are used to produce a rotation matrix. The euler
	* angles are applied in ZYX order. I.e a vector is first rotated 
	* about X then Y and then Z
	**/
	public native void setEulerZYX(@Cast("b3Scalar") float eulerX, @Cast("b3Scalar") float eulerY, @Cast("b3Scalar") float eulerZ);

	/**\brief Set the matrix to the identity */
	public native void setIdentity();

	public static native @Const @ByRef b3Matrix3x3 getIdentity();

	/**\brief Fill the rotational part of an OpenGL matrix and clear the shear/perspective
	* @param m The array to be filled */
	public native void getOpenGLSubMatrix(@Cast("b3Scalar*") FloatPointer m);
	public native void getOpenGLSubMatrix(@Cast("b3Scalar*") FloatBuffer m);
	public native void getOpenGLSubMatrix(@Cast("b3Scalar*") float[] m);

	/**\brief Get the matrix represented as a quaternion 
	* @param q The quaternion which will be set */
	public native void getRotation(@ByRef b3Quaternion q);

	/**\brief Get the matrix represented as euler angles around YXZ, roundtrip with setEulerYPR
	* @param yaw Yaw around Y axis
	* @param pitch Pitch around X axis
	* @param roll around Z axis */
	public native void getEulerYPR(@Cast("b3Scalar*") @ByRef FloatPointer yaw, @Cast("b3Scalar*") @ByRef FloatPointer pitch, @Cast("b3Scalar*") @ByRef FloatPointer roll);
	public native void getEulerYPR(@Cast("b3Scalar*") @ByRef FloatBuffer yaw, @Cast("b3Scalar*") @ByRef FloatBuffer pitch, @Cast("b3Scalar*") @ByRef FloatBuffer roll);
	public native void getEulerYPR(@Cast("b3Scalar*") @ByRef float[] yaw, @Cast("b3Scalar*") @ByRef float[] pitch, @Cast("b3Scalar*") @ByRef float[] roll);

	/**\brief Get the matrix represented as euler angles around ZYX
	* @param yaw Yaw around X axis
	* @param pitch Pitch around Y axis
	* @param roll around X axis 
	* @param solution_number Which solution of two possible solutions ( 1 or 2) are possible values*/
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef FloatPointer yaw, @Cast("b3Scalar*") @ByRef FloatPointer pitch, @Cast("b3Scalar*") @ByRef FloatPointer roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef FloatPointer yaw, @Cast("b3Scalar*") @ByRef FloatPointer pitch, @Cast("b3Scalar*") @ByRef FloatPointer roll);
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef FloatBuffer yaw, @Cast("b3Scalar*") @ByRef FloatBuffer pitch, @Cast("b3Scalar*") @ByRef FloatBuffer roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef FloatBuffer yaw, @Cast("b3Scalar*") @ByRef FloatBuffer pitch, @Cast("b3Scalar*") @ByRef FloatBuffer roll);
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef float[] yaw, @Cast("b3Scalar*") @ByRef float[] pitch, @Cast("b3Scalar*") @ByRef float[] roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("b3Scalar*") @ByRef float[] yaw, @Cast("b3Scalar*") @ByRef float[] pitch, @Cast("b3Scalar*") @ByRef float[] roll);

	/**\brief Create a scaled copy of the matrix 
	* @param s Scaling vector The elements of the vector will scale each column */

	public native @ByVal b3Matrix3x3 scaled(@Const @ByRef b3Vector3 s);

	/**\brief Return the determinant of the matrix */
	public native @Cast("b3Scalar") float determinant();
	/**\brief Return the adjoint of the matrix */
	public native @ByVal b3Matrix3x3 adjoint();
	/**\brief Return the matrix with all values non negative */
	public native @ByVal b3Matrix3x3 absolute();
	/**\brief Return the transpose of the matrix */
	public native @ByVal b3Matrix3x3 transpose();
	/**\brief Return the inverse of the matrix */
	public native @ByVal b3Matrix3x3 inverse();

	public native @ByVal b3Matrix3x3 transposeTimes(@Const @ByRef b3Matrix3x3 m);
	public native @ByVal b3Matrix3x3 timesTranspose(@Const @ByRef b3Matrix3x3 m);

	public native @Cast("b3Scalar") float tdotx(@Const @ByRef b3Vector3 v);
	public native @Cast("b3Scalar") float tdoty(@Const @ByRef b3Vector3 v);
	public native @Cast("b3Scalar") float tdotz(@Const @ByRef b3Vector3 v);

	/**\brief diagonalizes this matrix by the Jacobi method.
	* @param rot stores the rotation from the coordinate system in which the matrix is diagonal to the original
	* coordinate system, i.e., old_this = rot * new_this * rot^T. 
	* @param threshold See iteration
	* @param iteration The iteration stops when all off-diagonal elements are less than the threshold multiplied 
	* by the sum of the absolute values of the diagonal, or when maxSteps have been executed. 
	* 
	* Note that this matrix is assumed to be symmetric. 
	*/
	public native void diagonalize(@ByRef b3Matrix3x3 rot, @Cast("b3Scalar") float threshold, int maxSteps);

	/**\brief Calculate the matrix cofactor 
	* @param r1 The first row to use for calculating the cofactor
	* @param c1 The first column to use for calculating the cofactor
	* @param r1 The second row to use for calculating the cofactor
	* @param c1 The second column to use for calculating the cofactor
	* See http://en.wikipedia.org/wiki/Cofactor_(linear_algebra) for more details
	*/
	public native @Cast("b3Scalar") float cofac(int r1, int c1, int r2, int c2);

	public native void serialize(@ByRef b3Matrix3x3FloatData dataOut);

	public native void serializeFloat(@ByRef b3Matrix3x3FloatData dataOut);

	public native void deSerialize(@Const @ByRef b3Matrix3x3FloatData dataIn);

	public native void deSerializeFloat(@Const @ByRef b3Matrix3x3FloatData dataIn);

	public native void deSerializeDouble(@Const @ByRef b3Matrix3x3DoubleData dataIn);
}
