// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Common;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.Bullet3Common.*;
  //for placement new
// #endif          //B3_USE_PLACEMENT_NEW

/**The b3AlignedObjectArray template class uses a subset of the stl::vector interface for its methods
 * It is developed to replace stl::vector to avoid portability issues, including STL alignment issues to add SIMD/SSE data */
@Name("b3AlignedObjectArray<unsigned char>") @NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3Common.class)
public class b3UnsignedCharArray extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3UnsignedCharArray(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3UnsignedCharArray(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3UnsignedCharArray position(long position) {
        return (b3UnsignedCharArray)super.position(position);
    }
    @Override public b3UnsignedCharArray getPointer(long i) {
        return new b3UnsignedCharArray((Pointer)this).offsetAddress(i);
    }

	public native @ByRef @Name("operator =") b3UnsignedCharArray put(@Const @ByRef b3UnsignedCharArray other);
	public b3UnsignedCharArray() { super((Pointer)null); allocate(); }
	private native void allocate();

	/**Generally it is best to avoid using the copy constructor of an b3AlignedObjectArray, and use a (const) reference to the array instead. */
	public b3UnsignedCharArray(@Const @ByRef b3UnsignedCharArray otherArray) { super((Pointer)null); allocate(otherArray); }
	private native void allocate(@Const @ByRef b3UnsignedCharArray otherArray);

	/** return the number of elements in the array */
	public native int size();

	public native @Cast("unsigned char*") @ByRef BytePointer at(int n);

	public native @Cast("unsigned char*") @ByRef @Name("operator []") BytePointer get(int n);

	/**clear the array, deallocated memory. Generally it is better to use array.resize(0), to reduce performance overhead of run-time memory (de)allocations. */
	public native void clear();

	public native void pop_back();

	/**resize changes the number of elements in the array. If the new size is larger, the new elements will be constructed using the optional second argument.
	 * when the new number of elements is smaller, the destructor will be called, but memory will not be freed, to reduce performance overhead of run-time memory (de)allocations. */
	public native void resizeNoInitialize(int newsize);

	public native void resize(int newsize, @Cast("const unsigned char") byte fillData/*=unsigned char()*/);
	public native void resize(int newsize);
	public native @Cast("unsigned char*") @ByRef BytePointer expandNonInitializing();

	public native @Cast("unsigned char*") @ByRef BytePointer expand(@Cast("const unsigned char") byte fillValue/*=unsigned char()*/);
	public native @Cast("unsigned char*") @ByRef BytePointer expand();

	public native void push_back(@Cast("const unsigned char") byte _Val);

	/** return the pre-allocated (reserved) elements, this is at least as large as the total number of elements,see size() and reserve() */
	public native @Name("capacity") int _capacity();

	public native void reserve(int _Count);

	/**heap sort from http://www.csse.monash.edu.au/~lloyd/tildeAlgDS/Sort/Heap/ */ /*downHeap*/

	public native void swap(int index0, int index1);

	/**non-recursive binary search, assumes sorted array */
	public native int findBinarySearch(@Cast("const unsigned char") byte key);

	public native int findLinearSearch(@Cast("const unsigned char") byte key);

	public native int findLinearSearch2(@Cast("const unsigned char") byte key);

	public native void remove(@Cast("const unsigned char") byte key);

	//PCK: whole function
	public native void initializeFromBuffer(Pointer buffer, int size, int _capacity);

	public native void copyFromArray(@Const @ByRef b3UnsignedCharArray otherArray);

	public native void removeAtIndex(int index);
}
