// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3OpenCL;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.Bullet3Common.*;
import static org.bytedeco.bullet.global.Bullet3Common.*;
import org.bytedeco.bullet.Bullet3Collision.*;
import static org.bytedeco.bullet.global.Bullet3Collision.*;
import org.bytedeco.bullet.Bullet3Dynamics.*;
import static org.bytedeco.bullet.global.Bullet3Dynamics.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.Bullet3OpenCL.*;


/**The b3IndexedMesh indexes a single vertex and index array. Multiple b3IndexedMesh objects can be passed into a b3TriangleIndexVertexArray using addIndexedMesh.
 * Instead of the number of indices, we pass the number of triangles. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3OpenCL.class)
public class b3IndexedMesh extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3IndexedMesh(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3IndexedMesh(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3IndexedMesh position(long position) {
        return (b3IndexedMesh)super.position(position);
    }
    @Override public b3IndexedMesh getPointer(long i) {
        return new b3IndexedMesh((Pointer)this).offsetAddress(i);
    }


	public native int m_numTriangles(); public native b3IndexedMesh m_numTriangles(int setter);
	public native @Cast("const unsigned char*") BytePointer m_triangleIndexBase(); public native b3IndexedMesh m_triangleIndexBase(BytePointer setter);
	// Size in byte of the indices for one triangle (3*sizeof(index_type) if the indices are tightly packed)
	public native int m_triangleIndexStride(); public native b3IndexedMesh m_triangleIndexStride(int setter);
	public native int m_numVertices(); public native b3IndexedMesh m_numVertices(int setter);
	public native @Cast("const unsigned char*") BytePointer m_vertexBase(); public native b3IndexedMesh m_vertexBase(BytePointer setter);
	// Size of a vertex, in bytes
	public native int m_vertexStride(); public native b3IndexedMesh m_vertexStride(int setter);

	// The index type is set when adding an indexed mesh to the
	// b3TriangleIndexVertexArray, do not set it manually
	public native @Cast("PHY_ScalarType") int m_indexType(); public native b3IndexedMesh m_indexType(int setter);

	// The vertex type has a default type similar to Bullet's precision mode (float or double)
	// but can be set manually if you for example run Bullet with double precision but have
	// mesh data in single precision..
	public native @Cast("PHY_ScalarType") int m_vertexType(); public native b3IndexedMesh m_vertexType(int setter);

	public b3IndexedMesh() { super((Pointer)null); allocate(); }
	private native void allocate();
}
