// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btConvexInternalShape is an internal base class, shared by most convex shape implementations.
 * The btConvexInternalShape uses a default collision margin set to CONVEX_DISTANCE_MARGIN.
 * This collision margin used by Gjk and some other algorithms, see also btCollisionMargin.h
 * Note that when creating small shapes (derived from btConvexInternalShape),
 * you need to make sure to set a smaller collision margin, using the 'setMargin' API
 * There is a automatic mechanism 'setSafeMargin' used by btBoxShape and btCylinderShape */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btConvexInternalShape extends btConvexShape {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btConvexInternalShape(Pointer p) { super(p); }


	public native @ByVal btVector3 localGetSupportingVertex(@Const @ByRef btVector3 vec);

	public native @Const @ByRef btVector3 getImplicitShapeDimensions();

	/**warning: use setImplicitShapeDimensions with care
	 * changing a collision shape while the body is in the world is not recommended,
	 * it is best to remove the body from the world, then make the change, and re-add it
	 * alternatively flush the contact points, see documentation for 'cleanProxyFromPairs' */
	public native void setImplicitShapeDimensions(@Const @ByRef btVector3 dimensions);

	public native void setSafeMargin(@Cast("btScalar") double minDimension, @Cast("btScalar") double defaultMarginMultiplier/*=0.1f*/);
	public native void setSafeMargin(@Cast("btScalar") double minDimension);
	public native void setSafeMargin(@Const @ByRef btVector3 halfExtents, @Cast("btScalar") double defaultMarginMultiplier/*=0.1f*/);
	public native void setSafeMargin(@Const @ByRef btVector3 halfExtents);

	/**getAabb's default implementation is brute force, expected derived classes to implement a fast dedicated version */
	public native void getAabb(@Const @ByRef btTransform t, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	public native void getAabbSlow(@Const @ByRef btTransform t, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	public native void setLocalScaling(@Const @ByRef btVector3 scaling);
	public native @Const @ByRef btVector3 getLocalScaling();

	public native @Const @ByRef btVector3 getLocalScalingNV();

	public native void setMargin(@Cast("btScalar") double margin);
	public native @Cast("btScalar") double getMargin();

	public native @Cast("btScalar") double getMarginNV();

	public native int getNumPreferredPenetrationDirections();

	public native void getPreferredPenetrationDirection(int index, @ByRef btVector3 penetrationVector);

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
