// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;


/**btConeTwistConstraint can be used to simulate ragdoll joints (upper arm, leg etc) */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btConeTwistConstraint extends btTypedConstraint {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btConeTwistConstraint(Pointer p) { super(p); }


	public btConeTwistConstraint(@ByRef btRigidBody rbA, @ByRef btRigidBody rbB, @Const @ByRef btTransform rbAFrame, @Const @ByRef btTransform rbBFrame) { super((Pointer)null); allocate(rbA, rbB, rbAFrame, rbBFrame); }
	private native void allocate(@ByRef btRigidBody rbA, @ByRef btRigidBody rbB, @Const @ByRef btTransform rbAFrame, @Const @ByRef btTransform rbBFrame);

	public btConeTwistConstraint(@ByRef btRigidBody rbA, @Const @ByRef btTransform rbAFrame) { super((Pointer)null); allocate(rbA, rbAFrame); }
	private native void allocate(@ByRef btRigidBody rbA, @Const @ByRef btTransform rbAFrame);

	public native void buildJacobian();

	public native void getInfo1(btConstraintInfo1 info);

	public native void getInfo1NonVirtual(btConstraintInfo1 info);

	public native void getInfo2(btConstraintInfo2 info);

	public native void getInfo2NonVirtual(btConstraintInfo2 info, @Const @ByRef btTransform transA, @Const @ByRef btTransform transB, @Const @ByRef btMatrix3x3 invInertiaWorldA, @Const @ByRef btMatrix3x3 invInertiaWorldB);

	public native void solveConstraintObsolete(@ByRef btSolverBody bodyA, @ByRef btSolverBody bodyB, @Cast("btScalar") double timeStep);

	public native void updateRHS(@Cast("btScalar") double timeStep);

	public native @Const @ByRef btRigidBody getRigidBodyA();
	public native @Const @ByRef btRigidBody getRigidBodyB();

	public native void setAngularOnly(@Cast("bool") boolean angularOnly);

	public native @Cast("bool") boolean getAngularOnly();

	public native void setLimit(int limitIndex, @Cast("btScalar") double limitValue);

	public native @Cast("btScalar") double getLimit(int limitIndex);

	// setLimit(), a few notes:
	// _softness:
	//		0->1, recommend ~0.8->1.
	//		describes % of limits where movement is free.
	//		beyond this softness %, the limit is gradually enforced until the "hard" (1.0) limit is reached.
	// _biasFactor:
	//		0->1?, recommend 0.3 +/-0.3 or so.
	//		strength with which constraint resists zeroth order (angular, not angular velocity) limit violation.
	// __relaxationFactor:
	//		0->1, recommend to stay near 1.
	//		the lower the value, the less the constraint will fight velocities which violate the angular limits.
	public native void setLimit(@Cast("btScalar") double _swingSpan1, @Cast("btScalar") double _swingSpan2, @Cast("btScalar") double _twistSpan, @Cast("btScalar") double _softness/*=1.f*/, @Cast("btScalar") double _biasFactor/*=0.3f*/, @Cast("btScalar") double _relaxationFactor/*=1.0f*/);
	public native void setLimit(@Cast("btScalar") double _swingSpan1, @Cast("btScalar") double _swingSpan2, @Cast("btScalar") double _twistSpan);

	public native @Const @ByRef btTransform getAFrame();
	public native @Const @ByRef btTransform getBFrame();

	public native int getSolveTwistLimit();

	public native int getSolveSwingLimit();

	public native @Cast("btScalar") double getTwistLimitSign();

	public native void calcAngleInfo();
	public native void calcAngleInfo2(@Const @ByRef btTransform transA, @Const @ByRef btTransform transB, @Const @ByRef btMatrix3x3 invInertiaWorldA, @Const @ByRef btMatrix3x3 invInertiaWorldB);

	public native @Cast("btScalar") double getSwingSpan1();
	public native @Cast("btScalar") double getSwingSpan2();
	public native @Cast("btScalar") double getTwistSpan();
	public native @Cast("btScalar") double getLimitSoftness();
	public native @Cast("btScalar") double getBiasFactor();
	public native @Cast("btScalar") double getRelaxationFactor();
	public native @Cast("btScalar") double getTwistAngle();
	public native @Cast("bool") boolean isPastSwingLimit();

	public native @Cast("btScalar") double getDamping();
	public native void setDamping(@Cast("btScalar") double damping);

	public native void enableMotor(@Cast("bool") boolean b);
	public native @Cast("bool") boolean isMotorEnabled();
	public native @Cast("btScalar") double getMaxMotorImpulse();
	public native @Cast("bool") boolean isMaxMotorImpulseNormalized();
	public native void setMaxMotorImpulse(@Cast("btScalar") double maxMotorImpulse);
	public native void setMaxMotorImpulseNormalized(@Cast("btScalar") double maxMotorImpulse);

	public native @Cast("btScalar") double getFixThresh();
	public native void setFixThresh(@Cast("btScalar") double fixThresh);

	// setMotorTarget:
	// q: the desired rotation of bodyA wrt bodyB.
	// note: if q violates the joint limits, the internal target is clamped to avoid conflicting impulses (very bad for stability)
	// note: don't forget to enableMotor()
	public native void setMotorTarget(@Const @ByRef btQuaternion q);
	public native @Const @ByRef btQuaternion getMotorTarget();

	// same as above, but q is the desired rotation of frameA wrt frameB in constraint space
	public native void setMotorTargetInConstraintSpace(@Const @ByRef btQuaternion q);

	public native @ByVal btVector3 GetPointForAngle(@Cast("btScalar") double fAngleInRadians, @Cast("btScalar") double fLength);

	/**override the default global value of a parameter (such as ERP or CFM), optionally provide the axis (0..5).
	 * If no axis is provided, it uses the default axis for this constraint. */
	public native void setParam(int num, @Cast("btScalar") double value, int axis/*=-1*/);
	public native void setParam(int num, @Cast("btScalar") double value);

	public native void setFrames(@Const @ByRef btTransform frameA, @Const @ByRef btTransform frameB);

	public native @Const @ByRef btTransform getFrameOffsetA();

	public native @Const @ByRef btTransform getFrameOffsetB();

	/**return the local value of parameter */
	public native @Cast("btScalar") double getParam(int num, int axis/*=-1*/);
	public native @Cast("btScalar") double getParam(int num);

	public native int getFlags();

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
