// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.LinearMath;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.LinearMath.*;

// #else
// #endif  //BT_USE_DOUBLE_PRECISION

/**\brief The btMatrix3x3 class implements a 3x3 rotation matrix, to perform linear algebra in combination with btQuaternion, btTransform and btVector3.
* Make sure to only include a pure orthogonal matrix without scaling. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.LinearMath.class)
public class btMatrix3x3 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btMatrix3x3(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btMatrix3x3(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btMatrix3x3 position(long position) {
        return (btMatrix3x3)super.position(position);
    }
    @Override public btMatrix3x3 getPointer(long i) {
        return new btMatrix3x3((Pointer)this).offsetAddress(i);
    }

	/** \brief No initializaion constructor */
	public btMatrix3x3() { super((Pointer)null); allocate(); }
	private native void allocate();

	//		explicit btMatrix3x3(const btScalar *m) { setFromOpenGLSubMatrix(m); }

	/**\brief Constructor from Quaternion */
	public btMatrix3x3(@Const @ByRef btQuaternion q) { super((Pointer)null); allocate(q); }
	private native void allocate(@Const @ByRef btQuaternion q);
	/*
	template <typename btScalar>
	Matrix3x3(const btScalar& yaw, const btScalar& pitch, const btScalar& roll)
	{ 
	setEulerYPR(yaw, pitch, roll);
	}
	*/
	/** \brief Constructor with row major formatting */
	public btMatrix3x3(@Cast("const btScalar") double xx, @Cast("const btScalar") double xy, @Cast("const btScalar") double xz,
					@Cast("const btScalar") double yx, @Cast("const btScalar") double yy, @Cast("const btScalar") double yz,
					@Cast("const btScalar") double zx, @Cast("const btScalar") double zy, @Cast("const btScalar") double zz) { super((Pointer)null); allocate(xx, xy, xz, yx, yy, yz, zx, zy, zz); }
	private native void allocate(@Cast("const btScalar") double xx, @Cast("const btScalar") double xy, @Cast("const btScalar") double xz,
					@Cast("const btScalar") double yx, @Cast("const btScalar") double yy, @Cast("const btScalar") double yz,
					@Cast("const btScalar") double zx, @Cast("const btScalar") double zy, @Cast("const btScalar") double zz);

// #if (defined(BT_USE_SSE_IN_API) && defined(BT_USE_SSE)) || defined(BT_USE_NEON)

// #else

	/** \brief Copy constructor */
	public btMatrix3x3(@Const @ByRef btMatrix3x3 other) { super((Pointer)null); allocate(other); }
	private native void allocate(@Const @ByRef btMatrix3x3 other);

	/** \brief Assignment Operator */
	public native @ByRef @Name("operator =") btMatrix3x3 put(@Const @ByRef btMatrix3x3 other);
    
    public btMatrix3x3(@Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2) { super((Pointer)null); allocate(v0, v1, v2); }
    private native void allocate(@Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

// #endif

	/** \brief Get a column of the matrix as a vector 
	*  @param i Column number 0 indexed */
	public native @ByVal btVector3 getColumn(int i);

	/** \brief Get a row of the matrix as a vector 
	*  @param i Row number 0 indexed */
	public native @Const @ByRef btVector3 getRow(int i);

	/** \brief Get a mutable reference to a row of the matrix as a vector 
	*  @param i Row number 0 indexed */
	public native @ByRef @Name("operator []") btVector3 get(int i);

	/** \brief Get a const reference to a row of the matrix as a vector 
	*  @param i Row number 0 indexed */

	/** \brief Multiply by the target matrix on the right
	*  @param m Rotation matrix to be applied 
	* Equivilant to this = this * m */
	public native @ByRef @Name("operator *=") btMatrix3x3 multiplyPut(@Const @ByRef btMatrix3x3 m);

	/** \brief Adds by the target matrix on the right
	*  @param m matrix to be applied 
	* Equivilant to this = this + m */
	public native @ByRef @Name("operator +=") btMatrix3x3 addPut(@Const @ByRef btMatrix3x3 m);

	/** \brief Substractss by the target matrix on the right
	*  @param m matrix to be applied 
	* Equivilant to this = this - m */
	public native @ByRef @Name("operator -=") btMatrix3x3 subtractPut(@Const @ByRef btMatrix3x3 m);

	/** \brief Set from the rotational part of a 4x4 OpenGL matrix
	*  @param m A pointer to the beginning of the array of scalars*/
	public native void setFromOpenGLSubMatrix(@Cast("const btScalar*") DoublePointer m);
	public native void setFromOpenGLSubMatrix(@Cast("const btScalar*") DoubleBuffer m);
	public native void setFromOpenGLSubMatrix(@Cast("const btScalar*") double[] m);
	/** \brief Set the values of the matrix explicitly (row major)
	*  @param xx Top left
	*  @param xy Top Middle
	*  @param xz Top Right
	*  @param yx Middle Left
	*  @param yy Middle Middle
	*  @param yz Middle Right
	*  @param zx Bottom Left
	*  @param zy Bottom Middle
	*  @param zz Bottom Right*/
	public native void setValue(@Cast("const btScalar") double xx, @Cast("const btScalar") double xy, @Cast("const btScalar") double xz,
					  @Cast("const btScalar") double yx, @Cast("const btScalar") double yy, @Cast("const btScalar") double yz,
					  @Cast("const btScalar") double zx, @Cast("const btScalar") double zy, @Cast("const btScalar") double zz);

	/** \brief Set the matrix from a quaternion
	*  @param q The Quaternion to match */
	public native void setRotation(@Const @ByRef btQuaternion q);

	/** \brief Set the matrix from euler angles using YPR around YXZ respectively
	*  @param yaw Yaw about Y axis
	*  @param pitch Pitch about X axis
	*  @param roll Roll about Z axis 
	*/
	public native void setEulerYPR(@Cast("const btScalar") double yaw, @Cast("const btScalar") double pitch, @Cast("const btScalar") double roll);

	/** \brief Set the matrix from euler angles YPR around ZYX axes
	* @param eulerX Roll about X axis
	* @param eulerY Pitch around Y axis
	* @param eulerZ Yaw about Z axis
	* 
	* These angles are used to produce a rotation matrix. The euler
	* angles are applied in ZYX order. I.e a vector is first rotated 
	* about X then Y and then Z
	**/
	public native void setEulerZYX(@Cast("btScalar") double eulerX, @Cast("btScalar") double eulerY, @Cast("btScalar") double eulerZ);

	/**\brief Set the matrix to the identity */
	public native void setIdentity();
    
    /**\brief Set the matrix to the identity */
    public native void setZero();

	public static native @Const @ByRef btMatrix3x3 getIdentity();

	/**\brief Fill the rotational part of an OpenGL matrix and clear the shear/perspective
	* @param m The array to be filled */
	public native void getOpenGLSubMatrix(@Cast("btScalar*") DoublePointer m);
	public native void getOpenGLSubMatrix(@Cast("btScalar*") DoubleBuffer m);
	public native void getOpenGLSubMatrix(@Cast("btScalar*") double[] m);

	/**\brief Get the matrix represented as a quaternion 
	* @param q The quaternion which will be set */
	public native void getRotation(@ByRef btQuaternion q);

	/**\brief Get the matrix represented as euler angles around YXZ, roundtrip with setEulerYPR
	* @param yaw Yaw around Y axis
	* @param pitch Pitch around X axis
	* @param roll around Z axis */
	public native void getEulerYPR(@Cast("btScalar*") @ByRef DoublePointer yaw, @Cast("btScalar*") @ByRef DoublePointer pitch, @Cast("btScalar*") @ByRef DoublePointer roll);
	public native void getEulerYPR(@Cast("btScalar*") @ByRef DoubleBuffer yaw, @Cast("btScalar*") @ByRef DoubleBuffer pitch, @Cast("btScalar*") @ByRef DoubleBuffer roll);
	public native void getEulerYPR(@Cast("btScalar*") @ByRef double[] yaw, @Cast("btScalar*") @ByRef double[] pitch, @Cast("btScalar*") @ByRef double[] roll);

	/**\brief Get the matrix represented as euler angles around ZYX
	* @param yaw Yaw around Z axis
	* @param pitch Pitch around Y axis
	* @param roll around X axis 
	* @param solution_number Which solution of two possible solutions ( 1 or 2) are possible values*/
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoublePointer yaw, @Cast("btScalar*") @ByRef DoublePointer pitch, @Cast("btScalar*") @ByRef DoublePointer roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoublePointer yaw, @Cast("btScalar*") @ByRef DoublePointer pitch, @Cast("btScalar*") @ByRef DoublePointer roll);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoubleBuffer yaw, @Cast("btScalar*") @ByRef DoubleBuffer pitch, @Cast("btScalar*") @ByRef DoubleBuffer roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoubleBuffer yaw, @Cast("btScalar*") @ByRef DoubleBuffer pitch, @Cast("btScalar*") @ByRef DoubleBuffer roll);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef double[] yaw, @Cast("btScalar*") @ByRef double[] pitch, @Cast("btScalar*") @ByRef double[] roll, @Cast("unsigned int") int solution_number/*=1*/);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef double[] yaw, @Cast("btScalar*") @ByRef double[] pitch, @Cast("btScalar*") @ByRef double[] roll);

	/**\brief Create a scaled copy of the matrix 
	* @param s Scaling vector The elements of the vector will scale each column */

	public native @ByVal btMatrix3x3 scaled(@Const @ByRef btVector3 s);

	/**\brief Return the determinant of the matrix */
	public native @Cast("btScalar") double determinant();
	/**\brief Return the adjoint of the matrix */
	public native @ByVal btMatrix3x3 adjoint();
	/**\brief Return the matrix with all values non negative */
	public native @ByVal btMatrix3x3 absolute();
	/**\brief Return the transpose of the matrix */
	public native @ByVal btMatrix3x3 transpose();
	/**\brief Return the inverse of the matrix */
	public native @ByVal btMatrix3x3 inverse();

	/** Solve A * x = b, where b is a column vector. This is more efficient
	 *  than computing the inverse in one-shot cases.
	 * Solve33 is from Box2d, thanks to Erin Catto, */
	public native @ByVal btVector3 solve33(@Const @ByRef btVector3 b);

	public native @ByVal btMatrix3x3 transposeTimes(@Const @ByRef btMatrix3x3 m);
	public native @ByVal btMatrix3x3 timesTranspose(@Const @ByRef btMatrix3x3 m);

	public native @Cast("btScalar") double tdotx(@Const @ByRef btVector3 v);
	public native @Cast("btScalar") double tdoty(@Const @ByRef btVector3 v);
	public native @Cast("btScalar") double tdotz(@Const @ByRef btVector3 v);

	/**extractRotation is from "A robust method to extract the rotational part of deformations"
	 * See http://dl.acm.org/citation.cfm?doid=2994258.2994269
	 * decomposes a matrix A in a orthogonal matrix R and a
	 * symmetric matrix S:
	 * A = R*S.
	 * note that R can include both rotation and scaling. */
	public native void extractRotation(@ByRef btQuaternion q, @Cast("btScalar") double tolerance/*=1.0e-9*/, int maxIter/*=100*/);
	public native void extractRotation(@ByRef btQuaternion q);

	/**\brief diagonalizes this matrix by the Jacobi method.
	* @param rot stores the rotation from the coordinate system in which the matrix is diagonal to the original
	* coordinate system, i.e., old_this = rot * new_this * rot^T.
	* @param threshold See iteration
	* @param iteration The iteration stops when all off-diagonal elements are less than the threshold multiplied
	* by the sum of the absolute values of the diagonal, or when maxSteps have been executed.
	*
	* Note that this matrix is assumed to be symmetric.
	*/
	public native void diagonalize(@ByRef btMatrix3x3 rot, @Cast("btScalar") double threshold, int maxSteps);

	/**\brief Calculate the matrix cofactor 
	* @param r1 The first row to use for calculating the cofactor
	* @param c1 The first column to use for calculating the cofactor
	* @param r1 The second row to use for calculating the cofactor
	* @param c1 The second column to use for calculating the cofactor
	* See http://en.wikipedia.org/wiki/Cofactor_(linear_algebra) for more details
	*/
	public native @Cast("btScalar") double cofac(int r1, int c1, int r2, int c2);

	public native void serialize(@ByRef btMatrix3x3DoubleData dataOut);

	public native void serializeFloat(@ByRef btMatrix3x3FloatData dataOut);

	public native void deSerialize(@Const @ByRef btMatrix3x3DoubleData dataIn);

	public native void deSerializeFloat(@Const @ByRef btMatrix3x3FloatData dataIn);

	public native void deSerializeDouble(@Const @ByRef btMatrix3x3DoubleData dataIn);
}
