// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.LinearMath;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.LinearMath.*;

// #else
// #endif  //BT_USE_DOUBLE_PRECISION

// #ifdef BT_USE_SSE

// #endif

// #if defined(BT_USE_SSE)

// #elif defined(BT_USE_NEON)

// #endif

/**\brief The btQuaternion implements quaternion to perform linear algebra rotations in combination with btMatrix3x3, btVector3 and btTransform. */
@Properties(inherit = org.bytedeco.bullet.presets.LinearMath.class)
public class btQuaternion extends btQuadWord {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btQuaternion(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btQuaternion(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btQuaternion position(long position) {
        return (btQuaternion)super.position(position);
    }
    @Override public btQuaternion getPointer(long i) {
        return new btQuaternion((Pointer)this).offsetAddress(i);
    }

	/**\brief No initialization constructor */
	public btQuaternion() { super((Pointer)null); allocate(); }
	private native void allocate();

// #if (defined(BT_USE_SSE_IN_API) && defined(BT_USE_SSE)) || defined(BT_USE_NEON)

// #endif

	//		template <typename btScalar>
	//		explicit Quaternion(const btScalar *v) : Tuple4<btScalar>(v) {}
	/**\brief Constructor from scalars */
	public btQuaternion(@Cast("const btScalar") double _x, @Cast("const btScalar") double _y, @Cast("const btScalar") double _z, @Cast("const btScalar") double _w) { super((Pointer)null); allocate(_x, _y, _z, _w); }
	private native void allocate(@Cast("const btScalar") double _x, @Cast("const btScalar") double _y, @Cast("const btScalar") double _z, @Cast("const btScalar") double _w);
	/**\brief Axis angle Constructor
   * @param axis The axis which the rotation is around
   * @param angle The magnitude of the rotation around the angle (Radians) */
	public btQuaternion(@Const @ByRef btVector3 _axis, @Cast("const btScalar") double _angle) { super((Pointer)null); allocate(_axis, _angle); }
	private native void allocate(@Const @ByRef btVector3 _axis, @Cast("const btScalar") double _angle);
	/**\brief Constructor from Euler angles
   * @param yaw Angle around Y unless BT_EULER_DEFAULT_ZYX defined then Z
   * @param pitch Angle around X unless BT_EULER_DEFAULT_ZYX defined then Y
   * @param roll Angle around Z unless BT_EULER_DEFAULT_ZYX defined then X */
	public btQuaternion(@Cast("const btScalar") double yaw, @Cast("const btScalar") double pitch, @Cast("const btScalar") double roll) { super((Pointer)null); allocate(yaw, pitch, roll); }
	private native void allocate(@Cast("const btScalar") double yaw, @Cast("const btScalar") double pitch, @Cast("const btScalar") double roll);
	/**\brief Set the rotation using axis angle notation 
   * @param axis The axis around which to rotate
   * @param angle The magnitude of the rotation in Radians */
	public native void setRotation(@Const @ByRef btVector3 axis, @Cast("const btScalar") double _angle);
	/**\brief Set the quaternion using Euler angles
   * @param yaw Angle around Y
   * @param pitch Angle around X
   * @param roll Angle around Z */
	public native void setEuler(@Cast("const btScalar") double yaw, @Cast("const btScalar") double pitch, @Cast("const btScalar") double roll);
	/**\brief Set the quaternion using euler angles 
   * @param yaw Angle around Z
   * @param pitch Angle around Y
   * @param roll Angle around X */
	public native void setEulerZYX(@Cast("const btScalar") double yawZ, @Cast("const btScalar") double pitchY, @Cast("const btScalar") double rollX);

	/**\brief Get the euler angles from this quaternion
	   * @param yaw Angle around Z
	   * @param pitch Angle around Y
	   * @param roll Angle around X */
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoublePointer yawZ, @Cast("btScalar*") @ByRef DoublePointer pitchY, @Cast("btScalar*") @ByRef DoublePointer rollX);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef DoubleBuffer yawZ, @Cast("btScalar*") @ByRef DoubleBuffer pitchY, @Cast("btScalar*") @ByRef DoubleBuffer rollX);
	public native void getEulerZYX(@Cast("btScalar*") @ByRef double[] yawZ, @Cast("btScalar*") @ByRef double[] pitchY, @Cast("btScalar*") @ByRef double[] rollX);

	/**\brief Add two quaternions
   * @param q The quaternion to add to this one */
	public native @ByRef @Name("operator +=") btQuaternion addPut(@Const @ByRef btQuaternion q);

	/**\brief Subtract out a quaternion
   * @param q The quaternion to subtract from this one */
	public native @ByRef @Name("operator -=") btQuaternion subtractPut(@Const @ByRef btQuaternion q);

	/**\brief Scale this quaternion
   * @param s The scalar to scale by */
	public native @ByRef @Name("operator *=") btQuaternion multiplyPut(@Cast("const btScalar") double s);

	/**\brief Multiply this quaternion by q on the right
   * @param q The other quaternion 
   * Equivilant to this = this * q */
	public native @ByRef @Name("operator *=") btQuaternion multiplyPut(@Const @ByRef btQuaternion q);
	/**\brief Return the dot product between this quaternion and another
   * @param q The other quaternion */
	public native @Cast("btScalar") double dot(@Const @ByRef btQuaternion q);

	/**\brief Return the length squared of the quaternion */
	public native @Cast("btScalar") double length2();

	/**\brief Return the length of the quaternion */
	public native @Cast("btScalar") double length();
	public native @ByRef btQuaternion safeNormalize();
	/**\brief Normalize the quaternion 
   * Such that x^2 + y^2 + z^2 +w^2 = 1 */
	public native @ByRef btQuaternion normalize();

	/**\brief Return a scaled version of this quaternion
   * @param s The scale factor */
	public native @ByVal @Name("operator *") btQuaternion multiply(@Cast("const btScalar") double s);

	/**\brief Return an inversely scaled versionof this quaternion
   * @param s The inverse scale factor */
	public native @ByVal @Name("operator /") btQuaternion divide(@Cast("const btScalar") double s);

	/**\brief Inversely scale this quaternion
   * @param s The scale factor */
	public native @ByRef @Name("operator /=") btQuaternion dividePut(@Cast("const btScalar") double s);

	/**\brief Return a normalized version of this quaternion */
	public native @ByVal btQuaternion normalized();
	/**\brief Return the ***half*** angle between this quaternion and the other
   * @param q The other quaternion */
	public native @Cast("btScalar") double angle(@Const @ByRef btQuaternion q);

	/**\brief Return the angle between this quaternion and the other along the shortest path
	* @param q The other quaternion */
	public native @Cast("btScalar") double angleShortestPath(@Const @ByRef btQuaternion q);

	/**\brief Return the angle [0, 2Pi] of rotation represented by this quaternion */
	public native @Cast("btScalar") double getAngle();

	/**\brief Return the angle [0, Pi] of rotation represented by this quaternion along the shortest path */
	public native @Cast("btScalar") double getAngleShortestPath();

	/**\brief Return the axis of the rotation represented by this quaternion */
	public native @ByVal btVector3 getAxis();

	/**\brief Return the inverse of this quaternion */
	public native @ByVal btQuaternion inverse();

	/**\brief Return the sum of this quaternion and the other 
   * @param q2 The other quaternion */
	public native @ByVal @Name("operator +") btQuaternion add(@Const @ByRef btQuaternion q2);

	/**\brief Return the difference between this quaternion and the other 
   * @param q2 The other quaternion */
	public native @ByVal @Name("operator -") btQuaternion subtract(@Const @ByRef btQuaternion q2);

	/**\brief Return the negative of this quaternion 
   * This simply negates each element */
	public native @ByVal @Name("operator -") btQuaternion subtract();
	/**\todo document this and it's use */
	public native @ByVal btQuaternion farthest(@Const @ByRef btQuaternion qd);

	/**\todo document this and it's use */
	public native @ByVal btQuaternion nearest(@Const @ByRef btQuaternion qd);

	/**\brief Return the quaternion which is the result of Spherical Linear Interpolation between this and the other quaternion
   * @param q The other quaternion to interpolate with 
   * @param t The ratio between this and q to interpolate.  If t = 0 the result is this, if t=1 the result is q.
   * Slerp interpolates assuming constant velocity.  */
	public native @ByVal btQuaternion slerp(@Const @ByRef btQuaternion q, @Cast("const btScalar") double t);

	public static native @Const @ByRef btQuaternion getIdentity();

	public native @Cast("const btScalar") double getW();

	public native void serialize(@ByRef btQuaternionDoubleData dataOut);

	public native void deSerialize(@Const @ByRef btQuaternionFloatData dataIn);

	public native void deSerialize(@Const @ByRef btQuaternionDoubleData dataIn);

	public native void serializeFloat(@ByRef btQuaternionFloatData dataOut);

	public native void deSerializeFloat(@Const @ByRef btQuaternionFloatData dataIn);

	public native void serializeDouble(@ByRef btQuaternionDoubleData dataOut);

	public native void deSerializeDouble(@Const @ByRef btQuaternionDoubleData dataIn);
}
