// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.LinearMath;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.LinearMath.*;


/** Utils related to temporal transforms */
@Properties(inherit = org.bytedeco.bullet.presets.LinearMath.class)
public class btTransformUtil extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public btTransformUtil() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btTransformUtil(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btTransformUtil(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public btTransformUtil position(long position) {
        return (btTransformUtil)super.position(position);
    }
    @Override public btTransformUtil getPointer(long i) {
        return new btTransformUtil((Pointer)this).offsetAddress(i);
    }

	public static native void integrateTransform(@Const @ByRef btTransform curTrans, @Const @ByRef btVector3 linvel, @Const @ByRef btVector3 angvel, @Cast("btScalar") double timeStep, @ByRef btTransform predictedTransform);

	public static native void calculateVelocityQuaternion(@Const @ByRef btVector3 pos0, @Const @ByRef btVector3 pos1, @Const @ByRef btQuaternion orn0, @Const @ByRef btQuaternion orn1, @Cast("btScalar") double timeStep, @ByRef btVector3 linVel, @ByRef btVector3 angVel);

	public static native void calculateDiffAxisAngleQuaternion(@Const @ByRef btQuaternion orn0, @Const @ByRef btQuaternion orn1a, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef DoublePointer angle);
	public static native void calculateDiffAxisAngleQuaternion(@Const @ByRef btQuaternion orn0, @Const @ByRef btQuaternion orn1a, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef DoubleBuffer angle);
	public static native void calculateDiffAxisAngleQuaternion(@Const @ByRef btQuaternion orn0, @Const @ByRef btQuaternion orn1a, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef double[] angle);

	public static native void calculateVelocity(@Const @ByRef btTransform transform0, @Const @ByRef btTransform transform1, @Cast("btScalar") double timeStep, @ByRef btVector3 linVel, @ByRef btVector3 angVel);

	public static native void calculateDiffAxisAngle(@Const @ByRef btTransform transform0, @Const @ByRef btTransform transform1, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef DoublePointer angle);
	public static native void calculateDiffAxisAngle(@Const @ByRef btTransform transform0, @Const @ByRef btTransform transform1, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef DoubleBuffer angle);
	public static native void calculateDiffAxisAngle(@Const @ByRef btTransform transform0, @Const @ByRef btTransform transform1, @ByRef btVector3 axis, @Cast("btScalar*") @ByRef double[] angle);
}
