// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.Bullet3Collision.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.Bullet3Common.*;
import static org.bytedeco.bullet.global.Bullet3Common.*;

public class Bullet3Collision extends org.bytedeco.bullet.presets.Bullet3Collision {
    static { Loader.load(); }

// Parsed from Bullet3Common/b3AlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_OBJECT_ARRAY__
// #define B3_OBJECT_ARRAY__

// #include "b3Scalar.h"  // has definitions like B3_FORCE_INLINE
// #include "b3AlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable B3_USE_PLACEMENT_NEW
 * then the b3AlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable B3_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int B3_USE_PLACEMENT_NEW = 1;
//#define B3_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define B3_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef B3_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //B3_USE_MEMCPY

// #ifdef B3_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\Bullet3Collision\sStkNNArray.java


// Targeting ..\Bullet3Collision\sStkNPSArray.java


// Targeting ..\Bullet3Collision\b3AabbArray.java


// Targeting ..\Bullet3Collision\b3CollidableArray.java


// Targeting ..\Bullet3Collision\b3Contact4DataArray.java


// Targeting ..\Bullet3Collision\b3ConvexPolyhedronDataArray.java


// Targeting ..\Bullet3Collision\b3DbvtProxyArray.java


// Targeting ..\Bullet3Collision\b3GpuChildShapeArray.java


// Targeting ..\Bullet3Collision\b3GpuFaceArray.java


// Targeting ..\Bullet3Collision\b3MyFaceArray.java


// Targeting ..\Bullet3Collision\b3RayHitArray.java


// Targeting ..\Bullet3Collision\b3RayInfoArray.java


// Targeting ..\Bullet3Collision\b3RigidBodyDataArray.java



// #endif  //B3_OBJECT_ARRAY__


// Parsed from Bullet3Collision/BroadPhaseCollision/b3DynamicBvh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**b3DynamicBvh implementation by Nathanael Presson */

// #ifndef B3_DYNAMIC_BOUNDING_VOLUME_TREE_H
// #define B3_DYNAMIC_BOUNDING_VOLUME_TREE_H

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Common/b3Transform.h"
// #include "Bullet3Geometry/b3AabbUtil.h"

//
// Compile time configuration
//

// Implementation profiles
public static final int B3_DBVT_IMPL_GENERIC = 0;  // Generic implementation
public static final int B3_DBVT_IMPL_SSE = 1;      // SSE

// Template implementation of ICollide
// #ifdef _WIN32
// #else
// #define B3_DBVT_USE_TEMPLATE 0
// #endif

// Use only intrinsics instead of inline asm
public static final int B3_DBVT_USE_INTRINSIC_SSE = 1;

// Using memmov for collideOCL
public static final int B3_DBVT_USE_MEMMOVE = 1;

// Enable benchmarking code
public static final int B3_DBVT_ENABLE_BENCHMARK = 0;

// Inlining
// #define B3_DBVT_INLINE B3_FORCE_INLINE

// Specific methods implementation

//SSE gives errors on a MSVC 7.1
// #if defined(B3_USE_SSE)  //&& defined (_WIN32)
// #else
public static final int B3_DBVT_SELECT_IMPL = B3_DBVT_IMPL_GENERIC;
public static final int B3_DBVT_MERGE_IMPL = B3_DBVT_IMPL_GENERIC;
public static final int B3_DBVT_INT0_IMPL = B3_DBVT_IMPL_GENERIC;
// #endif

// #if (B3_DBVT_SELECT_IMPL == B3_DBVT_IMPL_SSE) ||
// 	(B3_DBVT_MERGE_IMPL == B3_DBVT_IMPL_SSE) ||
// 	(B3_DBVT_INT0_IMPL == B3_DBVT_IMPL_SSE)
// #include <emmintrin.h>
// #endif

//
// Auto config and checks
//

// #if B3_DBVT_USE_TEMPLATE
// #else
// #define B3_DBVT_VIRTUAL_DTOR(a)
// 	virtual ~a() {}
// #define B3_DBVT_VIRTUAL virtual
// #define B3_DBVT_PREFIX
// #define B3_DBVT_IPOLICY ICollide& policy
// #define B3_DBVT_CHECKTYPE
// #endif

// #if B3_DBVT_USE_MEMMOVE
// #if !defined(__CELLOS_LV2__) && !defined(__MWERKS__)
// #include <memory.h>
// #endif
// #include <string.h>
// #endif

// #ifndef B3_DBVT_USE_TEMPLATE
// #error "B3_DBVT_USE_TEMPLATE undefined"
// Targeting ..\Bullet3Collision\b3DbvtAabbMm.java



// Types
// Targeting ..\Bullet3Collision\b3DbvtNode.java


// Targeting ..\Bullet3Collision\b3DynamicBvh.java



//
// Inline's
//

//


//


//


//


//


//


//


//


//


//


//


//
public static native @Cast("bool") boolean b3Intersect(@Const @ByRef b3DbvtAabbMm a,
								@Const @ByRef b3DbvtAabbMm b);

//
public static native @Cast("bool") boolean b3Intersect(@Const @ByRef b3DbvtAabbMm a,
								@Const @ByRef b3Vector3 b);

//////////////////////////////////////

//
public static native @Cast("b3Scalar") float b3Proximity(@Const @ByRef b3DbvtAabbMm a,
									@Const @ByRef b3DbvtAabbMm b);

//
public static native int b3Select(@Const @ByRef b3DbvtAabbMm o,
							@Const @ByRef b3DbvtAabbMm a,
							@Const @ByRef b3DbvtAabbMm b);

//
public static native void b3Merge(@Const @ByRef b3DbvtAabbMm a,
							@Const @ByRef b3DbvtAabbMm b,
							@ByRef b3DbvtAabbMm r);

//
public static native @Cast("bool") boolean b3NotEqual(@Const @ByRef b3DbvtAabbMm a,
							   @Const @ByRef b3DbvtAabbMm b);

//
// Inline's
//

//


//


//




// #if 0
// #endif

//




//


//


//


//


//
// PP Cleanup
//

// #undef B3_DBVT_USE_MEMMOVE
// #undef B3_DBVT_USE_TEMPLATE
// #undef B3_DBVT_VIRTUAL_DTOR
// #undef B3_DBVT_VIRTUAL
// #undef B3_DBVT_PREFIX
// #undef B3_DBVT_IPOLICY
// #undef B3_DBVT_CHECKTYPE
// #undef B3_DBVT_IMPL_GENERIC
// #undef B3_DBVT_IMPL_SSE
// #undef B3_DBVT_USE_INTRINSIC_SSE
// #undef B3_DBVT_SELECT_IMPL
// #undef B3_DBVT_MERGE_IMPL
// #undef B3_DBVT_INT0_IMPL

// #endif


// Parsed from Bullet3Collision/BroadPhaseCollision/b3OverlappingPair.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_OVERLAPPING_PAIR_H
// #define B3_OVERLAPPING_PAIR_H

// #include "Bullet3Common/shared/b3Int4.h"

public static final int B3_NEW_PAIR_MARKER = -1;
public static final int B3_REMOVED_PAIR_MARKER = -2;

public static native @ByVal b3Int4 b3MakeBroadphasePair(int xx, int yy);
// Targeting ..\Bullet3Collision\b3BroadphasePairSortPredicate.java



public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b3Int4 a, @Const @ByRef b3Int4 b);

// #endif  //B3_OVERLAPPING_PAIR_H


// Parsed from Bullet3Collision/BroadPhaseCollision/b3OverlappingPairCache.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_OVERLAPPING_PAIR_CACHE_H
// #define B3_OVERLAPPING_PAIR_CACHE_H

// #include "Bullet3Common/shared/b3Int2.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// Targeting ..\Bullet3Collision\b3Dispatcher.java


// #include "b3OverlappingPair.h"
// Targeting ..\Bullet3Collision\b3OverlapCallback.java


// Targeting ..\Bullet3Collision\b3OverlapFilterCallback.java



public static native int b3g_removePairs(); public static native void b3g_removePairs(int setter);
public static native int b3g_addedPairs(); public static native void b3g_addedPairs(int setter);
public static native int b3g_findPairs(); public static native void b3g_findPairs(int setter);

@MemberGetter public static native int B3_NULL_PAIR();
// Targeting ..\Bullet3Collision\b3OverlappingPairCache.java


// Targeting ..\Bullet3Collision\b3HashedOverlappingPairCache.java


// Targeting ..\Bullet3Collision\b3SortedOverlappingPairCache.java


// Targeting ..\Bullet3Collision\b3NullPairCache.java



// #endif  //B3_OVERLAPPING_PAIR_CACHE_H


// Parsed from Bullet3Collision/BroadPhaseCollision/b3BroadphaseCallback.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_BROADPHASE_CALLBACK_H
// #define B3_BROADPHASE_CALLBACK_H

// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3Collision\b3BroadphaseAabbCallback.java


// Targeting ..\Bullet3Collision\b3BroadphaseRayCallback.java



// #endif  //B3_BROADPHASE_CALLBACK_H


// Parsed from Bullet3Collision/BroadPhaseCollision/b3DynamicBvhBroadphase.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**b3DynamicBvhBroadphase implementation by Nathanael Presson */
// #ifndef B3_DBVT_BROADPHASE_H
// #define B3_DBVT_BROADPHASE_H

// #include "Bullet3Collision/BroadPhaseCollision/b3DynamicBvh.h"
// #include "Bullet3Collision/BroadPhaseCollision/b3OverlappingPairCache.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"

// #include "b3BroadphaseCallback.h"

//
// Compile time config
//

// #define B3_DBVT_BP_PROFILE 0
//#define B3_DBVT_BP_SORTPAIRS				1
public static final int B3_DBVT_BP_PREVENTFALSEUPDATE = 0;
public static final int B3_DBVT_BP_ACCURATESLEEPING = 0;
public static final int B3_DBVT_BP_ENABLE_BENCHMARK = 0;
public static final double B3_DBVT_BP_MARGIN = (float)0.05;
// Targeting ..\Bullet3Collision\b3BroadphaseProxy.java


// Targeting ..\Bullet3Collision\b3DbvtProxy.java


// Targeting ..\Bullet3Collision\b3DynamicBvhBroadphase.java



// #endif


// Parsed from Bullet3Collision/BroadPhaseCollision/shared/b3Aabb.h


// #ifndef B3_AABB_H
// #define B3_AABB_H

// #include "Bullet3Common/shared/b3Float4.h"
// #include "Bullet3Common/shared/b3Mat3x3.h"
// Targeting ..\Bullet3Collision\b3Aabb.java



public static native void b3TransformAabb2(@Const @ByRef b3Vector3 localAabbMin, @Const @ByRef b3Vector3 localAabbMax, float margin,
							 @Const @ByRef b3Vector3 pos,
							 @Const @ByRef b3Quaternion orn,
							 b3Vector3 aabbMinOut, b3Vector3 aabbMaxOut);

/** conservative test for overlap between two aabbs */
public static native @Cast("bool") boolean b3TestAabbAgainstAabb(@Const @ByRef b3Vector3 aabbMin1, @Const @ByRef b3Vector3 aabbMax1,
								  @Const @ByRef b3Vector3 aabbMin2, @Const @ByRef b3Vector3 aabbMax2);

// #endif  //B3_AABB_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3Config.h

// #ifndef B3_CONFIG_H
// #define B3_CONFIG_H
// Targeting ..\Bullet3Collision\b3Config.java



// #endif  //B3_CONFIG_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3Contact4.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_CONTACT4_H
// #define B3_CONTACT4_H

// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Contact4Data.h"
// Targeting ..\Bullet3Collision\b3Contact4.java



// #endif  //B3_CONTACT4_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3ConvexUtility.h


/*
Copyright (c) 2012 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef _BT_CONVEX_UTILITY_H
// #define _BT_CONVEX_UTILITY_H

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Transform.h"
// Targeting ..\Bullet3Collision\b3MyFace.java


// Targeting ..\Bullet3Collision\b3ConvexUtility.java


// #endif


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3CpuNarrowPhase.h

// #ifndef B3_CPU_NARROWPHASE_H
// #define B3_CPU_NARROWPHASE_H

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Collision/BroadPhaseCollision/shared/b3Aabb.h"
// #include "Bullet3Common/shared/b3Int4.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Contact4Data.h"
// Targeting ..\Bullet3Collision\b3CpuNarrowPhase.java



// #endif  //B3_CPU_NARROWPHASE_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3RaycastInfo.h


// #ifndef B3_RAYCAST_INFO_H
// #define B3_RAYCAST_INFO_H

// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3Collision\b3RayInfo.java


// Targeting ..\Bullet3Collision\b3RayHit.java



// #endif  //B3_RAYCAST_INFO_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/b3RigidBodyCL.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_RIGID_BODY_CL
// #define B3_RIGID_BODY_CL

// #include "Bullet3Common/b3Scalar.h"
// #include "Bullet3Common/b3Matrix3x3.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"

public static native float b3GetInvMass(@Const @ByRef b3RigidBodyData body);

// #endif  //B3_RIGID_BODY_CL


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h


// #ifndef B3_COLLIDABLE_H
// #define B3_COLLIDABLE_H

// #include "Bullet3Common/shared/b3Float4.h"
// #include "Bullet3Common/shared/b3Quat.h"

/** enum b3ShapeTypes */
public static final int
	SHAPE_HEIGHT_FIELD = 1,

	SHAPE_CONVEX_HULL = 3,
	SHAPE_PLANE = 4,
	SHAPE_CONCAVE_TRIMESH = 5,
	SHAPE_COMPOUND_OF_CONVEX_HULLS = 6,
	SHAPE_SPHERE = 7,
	MAX_NUM_SHAPE_TYPES = 8;
// Targeting ..\Bullet3Collision\b3Collidable.java


// Targeting ..\Bullet3Collision\b3GpuChildShape.java


// Targeting ..\Bullet3Collision\b3CompoundOverlappingPair.java



// #endif  //B3_COLLIDABLE_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h


// #ifndef B3_CONVEX_POLYHEDRON_DATA_H
// #define B3_CONVEX_POLYHEDRON_DATA_H

// #include "Bullet3Common/shared/b3Float4.h"
// #include "Bullet3Common/shared/b3Quat.h"
// Targeting ..\Bullet3Collision\b3GpuFace.java


// Targeting ..\Bullet3Collision\b3ConvexPolyhedronData.java



// #endif  //B3_CONVEX_POLYHEDRON_DATA_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h

// #ifndef B3_RIGIDBODY_DATA_H
// #define B3_RIGIDBODY_DATA_H

// #include "Bullet3Common/shared/b3Float4.h"
// #include "Bullet3Common/shared/b3Quat.h"
// #include "Bullet3Common/shared/b3Mat3x3.h"
// Targeting ..\Bullet3Collision\b3RigidBodyData.java


// Targeting ..\Bullet3Collision\b3InertiaData.java



// #endif  //B3_RIGIDBODY_DATA_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3BvhSubtreeInfoData.h


// #ifndef B3_BVH_SUBTREE_INFO_DATA_H
// #define B3_BVH_SUBTREE_INFO_DATA_H
// Targeting ..\Bullet3Collision\b3BvhSubtreeInfoData.java



// #endif  //B3_BVH_SUBTREE_INFO_DATA_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3Contact4Data.h

// #ifndef B3_CONTACT4DATA_H
// #define B3_CONTACT4DATA_H

// #include "Bullet3Common/shared/b3Float4.h"
// Targeting ..\Bullet3Collision\b3Contact4Data.java



public static native int b3Contact4Data_getNumPoints(@Const b3Contact4Data contact);

public static native void b3Contact4Data_setNumPoints(b3Contact4Data contact, int numPoints);

// #endif  //B3_CONTACT4DATA_H

// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3ContactConvexConvexSAT.h


// #ifndef B3_CONTACT_CONVEX_CONVEX_SAT_H
// #define B3_CONTACT_CONVEX_CONVEX_SAT_H

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Contact4Data.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3FindSeparatingAxis.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ReduceContacts.h"

public static final int B3_MAX_VERTS = 1024;

public static native @ByVal b3Vector3 b3Lerp3(@Const @ByRef b3Vector3 a, @Const @ByRef b3Vector3 b, float t);

// Clips a face to the back of a plane, return the number of vertices out, stored in ppVtxOut
public static native int b3ClipFace(@Const b3Vector3 pVtxIn, int numVertsIn, @ByRef b3Vector3 planeNormalWS, float planeEqWS, b3Vector3 ppVtxOut);

public static native int b3ClipFaceAgainstHull(@Const @ByRef b3Vector3 separatingNormal, @Const b3ConvexPolyhedronData hullA,
								 @Const @ByRef b3Vector3 posA, @Const @ByRef b3Quaternion ornA, b3Vector3 worldVertsB1, int numWorldVertsB1,
								 b3Vector3 worldVertsB2, int capacityWorldVertsB2,
								 float minDist, float maxDist,
								 @Const @ByRef b3Vector3Array verticesA, @Const @ByRef b3GpuFaceArray facesA, @Const @ByRef b3IntArray indicesA,
								 b3Vector3 contactsOut,
								 int contactCapacity);

public static native int b3ClipHullAgainstHull(@Const @ByRef b3Vector3 separatingNormal,
								 @Const @ByRef b3ConvexPolyhedronData hullA, @Const @ByRef b3ConvexPolyhedronData hullB,
								 @Const @ByRef b3Vector3 posA, @Const @ByRef b3Quaternion ornA, @Const @ByRef b3Vector3 posB, @Const @ByRef b3Quaternion ornB,
								 b3Vector3 worldVertsB1, b3Vector3 worldVertsB2, int capacityWorldVerts,
								 float minDist, float maxDist,
								 @Const @ByRef b3Vector3Array verticesA, @Const @ByRef b3GpuFaceArray facesA, @Const @ByRef b3IntArray indicesA,
								 @Const @ByRef b3Vector3Array verticesB, @Const @ByRef b3GpuFaceArray facesB, @Const @ByRef b3IntArray indicesB,

								 b3Vector3 contactsOut,
								 int contactCapacity);

public static native int b3ClipHullHullSingle(
	int bodyIndexA, int bodyIndexB,
	@Const @ByRef b3Vector3 posA,
	@Const @ByRef b3Quaternion ornA,
	@Const @ByRef b3Vector3 posB,
	@Const @ByRef b3Quaternion ornB,

	int collidableIndexA, int collidableIndexB,

	@Const b3RigidBodyDataArray bodyBuf,
	b3Contact4DataArray globalContactOut,
	@ByRef IntPointer nContacts,

	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataA,
	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataB,

	@Const @ByRef b3Vector3Array verticesA,
	@Const @ByRef b3Vector3Array uniqueEdgesA,
	@Const @ByRef b3GpuFaceArray facesA,
	@Const @ByRef b3IntArray indicesA,

	@Const @ByRef b3Vector3Array verticesB,
	@Const @ByRef b3Vector3Array uniqueEdgesB,
	@Const @ByRef b3GpuFaceArray facesB,
	@Const @ByRef b3IntArray indicesB,

	@Const @ByRef b3CollidableArray hostCollidablesA,
	@Const @ByRef b3CollidableArray hostCollidablesB,
	@Const @ByRef b3Vector3 sepNormalWorldSpace,
	int maxContactCapacity);
public static native int b3ClipHullHullSingle(
	int bodyIndexA, int bodyIndexB,
	@Const @ByRef b3Vector3 posA,
	@Const @ByRef b3Quaternion ornA,
	@Const @ByRef b3Vector3 posB,
	@Const @ByRef b3Quaternion ornB,

	int collidableIndexA, int collidableIndexB,

	@Const b3RigidBodyDataArray bodyBuf,
	b3Contact4DataArray globalContactOut,
	@ByRef IntBuffer nContacts,

	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataA,
	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataB,

	@Const @ByRef b3Vector3Array verticesA,
	@Const @ByRef b3Vector3Array uniqueEdgesA,
	@Const @ByRef b3GpuFaceArray facesA,
	@Const @ByRef b3IntArray indicesA,

	@Const @ByRef b3Vector3Array verticesB,
	@Const @ByRef b3Vector3Array uniqueEdgesB,
	@Const @ByRef b3GpuFaceArray facesB,
	@Const @ByRef b3IntArray indicesB,

	@Const @ByRef b3CollidableArray hostCollidablesA,
	@Const @ByRef b3CollidableArray hostCollidablesB,
	@Const @ByRef b3Vector3 sepNormalWorldSpace,
	int maxContactCapacity);
public static native int b3ClipHullHullSingle(
	int bodyIndexA, int bodyIndexB,
	@Const @ByRef b3Vector3 posA,
	@Const @ByRef b3Quaternion ornA,
	@Const @ByRef b3Vector3 posB,
	@Const @ByRef b3Quaternion ornB,

	int collidableIndexA, int collidableIndexB,

	@Const b3RigidBodyDataArray bodyBuf,
	b3Contact4DataArray globalContactOut,
	@ByRef int[] nContacts,

	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataA,
	@Const @ByRef b3ConvexPolyhedronDataArray hostConvexDataB,

	@Const @ByRef b3Vector3Array verticesA,
	@Const @ByRef b3Vector3Array uniqueEdgesA,
	@Const @ByRef b3GpuFaceArray facesA,
	@Const @ByRef b3IntArray indicesA,

	@Const @ByRef b3Vector3Array verticesB,
	@Const @ByRef b3Vector3Array uniqueEdgesB,
	@Const @ByRef b3GpuFaceArray facesB,
	@Const @ByRef b3IntArray indicesB,

	@Const @ByRef b3CollidableArray hostCollidablesA,
	@Const @ByRef b3CollidableArray hostCollidablesB,
	@Const @ByRef b3Vector3 sepNormalWorldSpace,
	int maxContactCapacity);

public static native int b3ContactConvexConvexSAT(
	int pairIndex,
	int bodyIndexA, int bodyIndexB,
	int collidableIndexA, int collidableIndexB,
	@Const @ByRef b3RigidBodyDataArray rigidBodies,
	@Const @ByRef b3CollidableArray collidables,
	@Const @ByRef b3ConvexPolyhedronDataArray convexShapes,
	@Const @ByRef b3Vector3Array convexVertices,
	@Const @ByRef b3Vector3Array uniqueEdges,
	@Const @ByRef b3IntArray convexIndices,
	@Const @ByRef b3GpuFaceArray faces,
	@ByRef b3Contact4DataArray globalContactsOut,
	@ByRef IntPointer nGlobalContactsOut,
	int maxContactCapacity);
public static native int b3ContactConvexConvexSAT(
	int pairIndex,
	int bodyIndexA, int bodyIndexB,
	int collidableIndexA, int collidableIndexB,
	@Const @ByRef b3RigidBodyDataArray rigidBodies,
	@Const @ByRef b3CollidableArray collidables,
	@Const @ByRef b3ConvexPolyhedronDataArray convexShapes,
	@Const @ByRef b3Vector3Array convexVertices,
	@Const @ByRef b3Vector3Array uniqueEdges,
	@Const @ByRef b3IntArray convexIndices,
	@Const @ByRef b3GpuFaceArray faces,
	@ByRef b3Contact4DataArray globalContactsOut,
	@ByRef IntBuffer nGlobalContactsOut,
	int maxContactCapacity);
public static native int b3ContactConvexConvexSAT(
	int pairIndex,
	int bodyIndexA, int bodyIndexB,
	int collidableIndexA, int collidableIndexB,
	@Const @ByRef b3RigidBodyDataArray rigidBodies,
	@Const @ByRef b3CollidableArray collidables,
	@Const @ByRef b3ConvexPolyhedronDataArray convexShapes,
	@Const @ByRef b3Vector3Array convexVertices,
	@Const @ByRef b3Vector3Array uniqueEdges,
	@Const @ByRef b3IntArray convexIndices,
	@Const @ByRef b3GpuFaceArray faces,
	@ByRef b3Contact4DataArray globalContactsOut,
	@ByRef int[] nGlobalContactsOut,
	int maxContactCapacity);

// #endif  //B3_CONTACT_CONVEX_CONVEX_SAT_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3FindSeparatingAxis.h

// #ifndef B3_FIND_SEPARATING_AXIS_H
// #define B3_FIND_SEPARATING_AXIS_H

public static native void b3ProjectAxis(@Const @ByRef b3ConvexPolyhedronData hull, @Const @ByRef b3Vector3 pos, @Const @ByRef b3Quaternion orn, @Const @ByRef b3Vector3 dir, @Const @ByRef b3Vector3Array vertices, @Cast("b3Scalar*") @ByRef FloatPointer min, @Cast("b3Scalar*") @ByRef FloatPointer max);
public static native void b3ProjectAxis(@Const @ByRef b3ConvexPolyhedronData hull, @Const @ByRef b3Vector3 pos, @Const @ByRef b3Quaternion orn, @Const @ByRef b3Vector3 dir, @Const @ByRef b3Vector3Array vertices, @Cast("b3Scalar*") @ByRef FloatBuffer min, @Cast("b3Scalar*") @ByRef FloatBuffer max);
public static native void b3ProjectAxis(@Const @ByRef b3ConvexPolyhedronData hull, @Const @ByRef b3Vector3 pos, @Const @ByRef b3Quaternion orn, @Const @ByRef b3Vector3 dir, @Const @ByRef b3Vector3Array vertices, @Cast("b3Scalar*") @ByRef float[] min, @Cast("b3Scalar*") @ByRef float[] max);

public static native @Cast("bool") boolean b3TestSepAxis(@Const @ByRef b3ConvexPolyhedronData hullA, @Const @ByRef b3ConvexPolyhedronData hullB,
						  @Const @ByRef b3Vector3 posA, @Const @ByRef b3Quaternion ornA,
						  @Const @ByRef b3Vector3 posB, @Const @ByRef b3Quaternion ornB,
						  @Const @ByRef b3Vector3 sep_axis, @Const @ByRef b3Vector3Array verticesA, @Const @ByRef b3Vector3Array verticesB, @Cast("b3Scalar*") @ByRef FloatPointer depth);
public static native @Cast("bool") boolean b3TestSepAxis(@Const @ByRef b3ConvexPolyhedronData hullA, @Const @ByRef b3ConvexPolyhedronData hullB,
						  @Const @ByRef b3Vector3 posA, @Const @ByRef b3Quaternion ornA,
						  @Const @ByRef b3Vector3 posB, @Const @ByRef b3Quaternion ornB,
						  @Const @ByRef b3Vector3 sep_axis, @Const @ByRef b3Vector3Array verticesA, @Const @ByRef b3Vector3Array verticesB, @Cast("b3Scalar*") @ByRef FloatBuffer depth);
public static native @Cast("bool") boolean b3TestSepAxis(@Const @ByRef b3ConvexPolyhedronData hullA, @Const @ByRef b3ConvexPolyhedronData hullB,
						  @Const @ByRef b3Vector3 posA, @Const @ByRef b3Quaternion ornA,
						  @Const @ByRef b3Vector3 posB, @Const @ByRef b3Quaternion ornB,
						  @Const @ByRef b3Vector3 sep_axis, @Const @ByRef b3Vector3Array verticesA, @Const @ByRef b3Vector3Array verticesB, @Cast("b3Scalar*") @ByRef float[] depth);

public static native @Cast("bool") boolean b3FindSeparatingAxis(@Const @ByRef b3ConvexPolyhedronData hullA, @Const @ByRef b3ConvexPolyhedronData hullB,
								 @Const @ByRef b3Vector3 posA1,
								 @Const @ByRef b3Quaternion ornA,
								 @Const @ByRef b3Vector3 posB1,
								 @Const @ByRef b3Quaternion ornB,
								 @Const @ByRef b3Vector3Array verticesA,
								 @Const @ByRef b3Vector3Array uniqueEdgesA,
								 @Const @ByRef b3GpuFaceArray facesA,
								 @Const @ByRef b3IntArray indicesA,
								 @Const @ByRef b3Vector3Array verticesB,
								 @Const @ByRef b3Vector3Array uniqueEdgesB,
								 @Const @ByRef b3GpuFaceArray facesB,
								 @Const @ByRef b3IntArray indicesB,

								 @ByRef b3Vector3 sep);

// #endif  //B3_FIND_SEPARATING_AXIS_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3MprPenetration.h


/***
 * ---------------------------------
 * Copyright (c)2012 Daniel Fiser <danfis\danfis.cz>
 *
 *  This file was ported from mpr.c file, part of libccd.
 *  The Minkoski Portal Refinement implementation was ported 
 *  to OpenCL by Erwin Coumans for the Bullet 3 Physics library.
 *  at http://github.com/erwincoumans/bullet3
 *
 *  Distributed under the OSI-approved BSD License (the "License");
 *  see <http://www.opensource.org/licenses/bsd-license.php>.
 *  This software is distributed WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the License for more information.
 */

// #ifndef B3_MPR_PENETRATION_H
// #define B3_MPR_PENETRATION_H

// #include "Bullet3Common/shared/b3PlatformDefinitions.h"
// #include "Bullet3Common/shared/b3Float4.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"

// #ifdef __cplusplus
// #define B3_MPR_SQRT sqrtf
// #else
// #endif
// #define B3_MPR_FMIN(x, y) ((x) < (y) ? (x) : (y))
// #define B3_MPR_FABS fabs

public static final double B3_MPR_TOLERANCE = 1E-6f;
public static final int B3_MPR_MAX_ITERATIONS = 1000;
// Targeting ..\Bullet3Collision\b3MprSupport_t.java


// Targeting ..\Bullet3Collision\b3MprSimplex_t.java



public static native b3MprSupport_t b3MprSimplexPointW(b3MprSimplex_t s, int idx);

public static native void b3MprSimplexSetSize(b3MprSimplex_t s, int size);

public static native int b3MprSimplexSize(@Const b3MprSimplex_t s);

public static native @Const b3MprSupport_t b3MprSimplexPoint(@Const b3MprSimplex_t s, int idx);

public static native void b3MprSupportCopy(b3MprSupport_t d, @Const b3MprSupport_t s);

public static native void b3MprSimplexSet(b3MprSimplex_t s, @Cast("size_t") long pos, @Const b3MprSupport_t a);

public static native void b3MprSimplexSwap(b3MprSimplex_t s, @Cast("size_t") long pos1, @Cast("size_t") long pos2);

public static native int b3MprIsZero(float val);

public static native int b3MprEq(float _a, float _b);

public static native int b3MprVec3Eq(@Const b3Vector3 a, @Const b3Vector3 b);

public static native @ByVal b3Vector3 b3LocalGetSupportVertex(@Const @ByRef b3Vector3 supportVec, @Const b3ConvexPolyhedronData hull, @Const b3Vector3 verticesA);

public static native void b3MprConvexSupport(int pairIndex, int bodyIndex, @Const b3RigidBodyData cpuBodyBuf,
								  @Const b3ConvexPolyhedronData cpuConvexData,
								  @Const b3Collidable cpuCollidables,
								  @Const b3Vector3 cpuVertices,
								  b3Vector3 sepAxis,
								  @Const b3Vector3 _dir, b3Vector3 outp, int logme);

public static native void b3MprSupport(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
						 @Const b3ConvexPolyhedronData cpuConvexData,
						 @Const b3Collidable cpuCollidables,
						 @Const b3Vector3 cpuVertices,
						 b3Vector3 sepAxis,
						 @Const b3Vector3 _dir, b3MprSupport_t supp);

public static native void b3FindOrigin(int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf, b3MprSupport_t center);

public static native void b3MprVec3Set(b3Vector3 v, float x, float y, float z);

public static native void b3MprVec3Add(b3Vector3 v, @Const b3Vector3 w);

public static native void b3MprVec3Copy(b3Vector3 v, @Const b3Vector3 w);

public static native void b3MprVec3Scale(b3Vector3 d, float k);

public static native float b3MprVec3Dot(@Const b3Vector3 a, @Const b3Vector3 b);

public static native float b3MprVec3Len2(@Const b3Vector3 v);

public static native void b3MprVec3Normalize(b3Vector3 d);

public static native void b3MprVec3Cross(b3Vector3 d, @Const b3Vector3 a, @Const b3Vector3 b);

public static native void b3MprVec3Sub2(b3Vector3 d, @Const b3Vector3 v, @Const b3Vector3 w);

public static native void b3PortalDir(@Const b3MprSimplex_t portal, b3Vector3 dir);

public static native int portalEncapsulesOrigin(@Const b3MprSimplex_t portal,
								  @Const b3Vector3 dir);

public static native int portalReachTolerance(@Const b3MprSimplex_t portal,
								@Const b3MprSupport_t v4,
								@Const b3Vector3 dir);

public static native int portalCanEncapsuleOrigin(@Const b3MprSimplex_t portal,
									@Const b3MprSupport_t v4,
									@Const b3Vector3 dir);

public static native void b3ExpandPortal(b3MprSimplex_t portal,
						   @Const b3MprSupport_t v4);

public static native int b3DiscoverPortal(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							   @Const b3ConvexPolyhedronData cpuConvexData,
							   @Const b3Collidable cpuCollidables,
							   @Const b3Vector3 cpuVertices,
							   b3Vector3 sepAxis,
							   IntPointer hasSepAxis,
							   b3MprSimplex_t portal);
public static native int b3DiscoverPortal(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							   @Const b3ConvexPolyhedronData cpuConvexData,
							   @Const b3Collidable cpuCollidables,
							   @Const b3Vector3 cpuVertices,
							   b3Vector3 sepAxis,
							   IntBuffer hasSepAxis,
							   b3MprSimplex_t portal);
public static native int b3DiscoverPortal(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							   @Const b3ConvexPolyhedronData cpuConvexData,
							   @Const b3Collidable cpuCollidables,
							   @Const b3Vector3 cpuVertices,
							   b3Vector3 sepAxis,
							   int[] hasSepAxis,
							   b3MprSimplex_t portal);

public static native int b3RefinePortal(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							 @Const b3ConvexPolyhedronData cpuConvexData,
							 @Const b3Collidable cpuCollidables,
							 @Const b3Vector3 cpuVertices,
							 b3Vector3 sepAxis,
							 b3MprSimplex_t portal);

public static native void b3FindPos(@Const b3MprSimplex_t portal, b3Vector3 pos);

public static native float b3MprVec3Dist2(@Const b3Vector3 a, @Const b3Vector3 b);

public static native float _b3MprVec3PointSegmentDist2(@Const b3Vector3 P,
										 @Const b3Vector3 x0,
										 @Const b3Vector3 b,
										 b3Vector3 witness);

public static native float b3MprVec3PointTriDist2(@Const b3Vector3 P,
									@Const b3Vector3 x0, @Const b3Vector3 B,
									@Const b3Vector3 C,
									b3Vector3 witness);

public static native void b3FindPenetr(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							b3MprSimplex_t portal,
							FloatPointer depth, b3Vector3 pdir, b3Vector3 pos);
public static native void b3FindPenetr(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							b3MprSimplex_t portal,
							FloatBuffer depth, b3Vector3 pdir, b3Vector3 pos);
public static native void b3FindPenetr(int pairIndex, int bodyIndexA, int bodyIndexB, @Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							b3MprSimplex_t portal,
							float[] depth, b3Vector3 pdir, b3Vector3 pos);

public static native void b3FindPenetrTouch(b3MprSimplex_t portal, FloatPointer depth, b3Vector3 dir, b3Vector3 pos);
public static native void b3FindPenetrTouch(b3MprSimplex_t portal, FloatBuffer depth, b3Vector3 dir, b3Vector3 pos);
public static native void b3FindPenetrTouch(b3MprSimplex_t portal, float[] depth, b3Vector3 dir, b3Vector3 pos);

public static native void b3FindPenetrSegment(b3MprSimplex_t portal,
								   FloatPointer depth, b3Vector3 dir, b3Vector3 pos);
public static native void b3FindPenetrSegment(b3MprSimplex_t portal,
								   FloatBuffer depth, b3Vector3 dir, b3Vector3 pos);
public static native void b3FindPenetrSegment(b3MprSimplex_t portal,
								   float[] depth, b3Vector3 dir, b3Vector3 pos);

public static native int b3MprPenetration(int pairIndex, int bodyIndexA, int bodyIndexB,
							@Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							IntPointer hasSepAxis,
							FloatPointer depthOut, b3Vector3 dirOut, b3Vector3 posOut);
public static native int b3MprPenetration(int pairIndex, int bodyIndexA, int bodyIndexB,
							@Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							IntBuffer hasSepAxis,
							FloatBuffer depthOut, b3Vector3 dirOut, b3Vector3 posOut);
public static native int b3MprPenetration(int pairIndex, int bodyIndexA, int bodyIndexB,
							@Const b3RigidBodyData cpuBodyBuf,
							@Const b3ConvexPolyhedronData cpuConvexData,
							@Const b3Collidable cpuCollidables,
							@Const b3Vector3 cpuVertices,
							b3Vector3 sepAxis,
							int[] hasSepAxis,
							float[] depthOut, b3Vector3 dirOut, b3Vector3 posOut);

// #endif  //B3_MPR_PENETRATION_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3QuantizedBvhNodeData.h



// #ifndef B3_QUANTIZED_BVH_NODE_H
// #define B3_QUANTIZED_BVH_NODE_H

// #include "Bullet3Common/shared/b3Float4.h"

public static final int B3_MAX_NUM_PARTS_IN_BITS = 10;
// Targeting ..\Bullet3Collision\b3QuantizedBvhNodeData.java



public static native int b3GetTriangleIndex(@Const b3QuantizedBvhNodeData rootNode);

public static native int b3IsLeaf(@Const b3QuantizedBvhNodeData rootNode);

public static native int b3GetEscapeIndex(@Const b3QuantizedBvhNodeData rootNode);

public static native void b3QuantizeWithClamp(@Cast("unsigned short*") ShortPointer out, @Const @ByRef b3Vector3 point2, int isMax, @Const @ByRef b3Vector3 bvhAabbMin, @Const @ByRef b3Vector3 bvhAabbMax, @Const @ByRef b3Vector3 bvhQuantization);
public static native void b3QuantizeWithClamp(@Cast("unsigned short*") ShortBuffer out, @Const @ByRef b3Vector3 point2, int isMax, @Const @ByRef b3Vector3 bvhAabbMin, @Const @ByRef b3Vector3 bvhAabbMax, @Const @ByRef b3Vector3 bvhQuantization);
public static native void b3QuantizeWithClamp(@Cast("unsigned short*") short[] out, @Const @ByRef b3Vector3 point2, int isMax, @Const @ByRef b3Vector3 bvhAabbMin, @Const @ByRef b3Vector3 bvhAabbMax, @Const @ByRef b3Vector3 bvhQuantization);

public static native int b3TestQuantizedAabbAgainstQuantizedAabbSlow(
	@Cast("const unsigned short int*") ShortPointer aabbMin1,
	@Cast("const unsigned short int*") ShortPointer aabbMax1,
	@Cast("const unsigned short int*") ShortPointer aabbMin2,
	@Cast("const unsigned short int*") ShortPointer aabbMax2);
public static native int b3TestQuantizedAabbAgainstQuantizedAabbSlow(
	@Cast("const unsigned short int*") ShortBuffer aabbMin1,
	@Cast("const unsigned short int*") ShortBuffer aabbMax1,
	@Cast("const unsigned short int*") ShortBuffer aabbMin2,
	@Cast("const unsigned short int*") ShortBuffer aabbMax2);
public static native int b3TestQuantizedAabbAgainstQuantizedAabbSlow(
	@Cast("const unsigned short int*") short[] aabbMin1,
	@Cast("const unsigned short int*") short[] aabbMax1,
	@Cast("const unsigned short int*") short[] aabbMin2,
	@Cast("const unsigned short int*") short[] aabbMax2);

// #endif  //B3_QUANTIZED_BVH_NODE_H


// Parsed from Bullet3Collision/NarrowPhaseCollision/shared/b3ReduceContacts.h

// #ifndef B3_REDUCE_CONTACTS_H
// #define B3_REDUCE_CONTACTS_H

public static native int b3ReduceContacts(@Const b3Vector3 p, int nPoints, @Const @ByRef b3Vector3 nearNormal, b3Int4 contactIdx);

// #endif  //B3_REDUCE_CONTACTS_H


}
