// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.Bullet3Common.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class Bullet3Common extends org.bytedeco.bullet.presets.Bullet3Common {
    static { Loader.load(); }

// Parsed from Bullet3Common/b3AlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_OBJECT_ARRAY__
// #define B3_OBJECT_ARRAY__

// #include "b3Scalar.h"  // has definitions like B3_FORCE_INLINE
// #include "b3AlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable B3_USE_PLACEMENT_NEW
 * then the b3AlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable B3_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int B3_USE_PLACEMENT_NEW = 1;
//#define B3_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define B3_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef B3_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //B3_USE_MEMCPY

// #ifdef B3_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\Bullet3Common\b3UnsignedCharArray.java


// Targeting ..\Bullet3Common\b3IntArray.java


// Targeting ..\Bullet3Common\b3UnsignedIntArray.java


// Targeting ..\Bullet3Common\b3FloatArray.java


// Targeting ..\Bullet3Common\b3Int2Array.java


// Targeting ..\Bullet3Common\b3Int4Array.java


// Targeting ..\Bullet3Common\b3Vector3Array.java



// #endif  //B3_OBJECT_ARRAY__


// Parsed from Bullet3Common/b3CommandLineArgs.h

// #ifndef COMMAND_LINE_ARGS_H
// #define COMMAND_LINE_ARGS_H

/******************************************************************************
 * Command-line parsing
 ******************************************************************************/
// #include <map>
// #include <algorithm>
// #include <string>
// #include <cstring>
// #include <sstream>
// Targeting ..\Bullet3Common\b3CommandLineArgs.java







// #endif  //COMMAND_LINE_ARGS_H


// Parsed from Bullet3Common/b3FileUtils.h

// #ifndef B3_FILE_UTILS_H
// #define B3_FILE_UTILS_H

// #include <stdio.h>
// #include "b3Scalar.h"
// #include <stddef.h>  //ptrdiff_h
// #include <string.h>
// Targeting ..\Bullet3Common\b3FileUtils.java


// #endif  //B3_FILE_UTILS_H


// Parsed from Bullet3Common/b3HashMap.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_HASH_MAP_H
// #define B3_HASH_MAP_H

// #include "b3AlignedObjectArray.h"

// #include <string>
// Targeting ..\Bullet3Common\b3HashString.java



@MemberGetter public static native int B3_HASH_NULL();
// Targeting ..\Bullet3Common\b3HashInt.java


// Targeting ..\Bullet3Common\b3HashPtr.java



/**The b3HashMap template class implements a generic and lightweight hashmap.
 * A basic sample of how to use b3HashMap is located in Demos\BasicDemo\main.cpp */

// #endif  //B3_HASH_MAP_H


// Parsed from Bullet3Common/b3Logging.h


// #ifndef B3_LOGGING_H
// #define B3_LOGGING_H

// #ifdef __cplusplus
// #endif

/**We add the do/while so that the statement "if (condition) b3Printf("test"); else {...}" would fail
 * You can also customize the message by uncommenting out a different line below */
// #define b3Printf(...) b3OutputPrintfVarArgsInternal(__VA_ARGS__)
	//#define b3Printf(...) do {b3OutputPrintfVarArgsInternal("b3Printf[%s,%d]:",__FILE__,__LINE__);b3OutputPrintfVarArgsInternal(__VA_ARGS__); } while(0)
	//#define b3Printf b3OutputPrintfVarArgsInternal
	//#define b3Printf(...) printf(__VA_ARGS__)
	//#define b3Printf(...)
// #define b3Warning(...) do{	b3OutputWarningMessageVarArgsInternal("b3Warning[%s,%d]:\n", __FILE__, __LINE__);b3OutputWarningMessageVarArgsInternal(__VA_ARGS__);} while (0)
// #define b3Error(...)do	{b3OutputErrorMessageVarArgsInternal("b3Error[%s,%d]:\n", __FILE__, __LINE__);b3OutputErrorMessageVarArgsInternal(__VA_ARGS__);} while (0)
// #ifndef B3_NO_PROFILE

	public static native void b3EnterProfileZone(@Cast("const char*") BytePointer name);
	public static native void b3EnterProfileZone(String name);
	public static native void b3LeaveProfileZone();
// Targeting ..\Bullet3Common\b3ProfileZone.java



// #define B3_PROFILE(name) b3ProfileZone __profile(name)
// #endif

// #else  //B3_NO_PROFILE

// #define B3_PROFILE(name)
// #define b3StartProfile(a)
// #define b3StopProfile
// Targeting ..\Bullet3Common\b3PrintfFunc.java


// Targeting ..\Bullet3Common\b3WarningMessageFunc.java


// Targeting ..\Bullet3Common\b3ErrorMessageFunc.java


// Targeting ..\Bullet3Common\b3EnterProfileZoneFunc.java


// Targeting ..\Bullet3Common\b3LeaveProfileZoneFunc.java



	/**The developer can route b3Printf output using their own implementation */
	public static native void b3SetCustomPrintfFunc(b3PrintfFunc printfFunc);
	public static native void b3SetCustomWarningMessageFunc(b3WarningMessageFunc warningMsgFunc);
	public static native void b3SetCustomErrorMessageFunc(b3ErrorMessageFunc errorMsgFunc);

	/**Set custom profile zone functions (zones can be nested) */
	public static native void b3SetCustomEnterProfileZoneFunc(b3EnterProfileZoneFunc enterFunc);
	public static native void b3SetCustomLeaveProfileZoneFunc(b3LeaveProfileZoneFunc leaveFunc);

	/**Don't use those internal functions directly, use the b3Printf or b3SetCustomPrintfFunc instead (or warning/error version) */
	public static native void b3OutputPrintfVarArgsInternal(@Cast("const char*") BytePointer str);
	public static native void b3OutputPrintfVarArgsInternal(String str);
	public static native void b3OutputWarningMessageVarArgsInternal(@Cast("const char*") BytePointer str);
	public static native void b3OutputWarningMessageVarArgsInternal(String str);
	public static native void b3OutputErrorMessageVarArgsInternal(@Cast("const char*") BytePointer str);
	public static native void b3OutputErrorMessageVarArgsInternal(String str);

// #ifdef __cplusplus
// #endif

// #endif  //B3_LOGGING_H

// Parsed from Bullet3Common/b3Scalar.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_SCALAR_H
// #define B3_SCALAR_H

// #ifdef B3_MANAGED_CODE
//Aligned data types not supported in managed code
// #pragma unmanaged
// #endif

// #include <math.h>
// #include <stdlib.h>  //size_t for MSVC 6.0
// #include <float.h>

//Original repository is at http://github.com/erwincoumans/bullet3
public static final int B3_BULLET_VERSION = 300;

public static native int b3GetVersion();

// #if defined(DEBUG) || defined(_DEBUG)
// #define B3_DEBUG
// #endif

// #include "b3Logging.h"  //for b3Error

// #ifdef _WIN32

// #else

// #if defined(__CELLOS_LV2__)
// #define B3_FORCE_INLINE inline __attribute__((always_inline))
// #define B3_ATTRIBUTE_ALIGNED16(a) a __attribute__((aligned(16)))
// #define B3_ATTRIBUTE_ALIGNED64(a) a __attribute__((aligned(64)))
// #define B3_ATTRIBUTE_ALIGNED128(a) a __attribute__((aligned(128)))
// #ifndef assert
// #include <assert.h>
// #endif
// #ifdef B3_DEBUG

// #else
// #define b3Assert(x)
// #endif
//b3FullAssert is optional, slows down a lot
// #define b3FullAssert(x)

// #define b3Likely(_c) _c
// #define b3Unlikely(_c) _c

// #else

// #ifdef USE_LIBSPE2

// #define B3_FORCE_INLINE __inline
// #define B3_ATTRIBUTE_ALIGNED16(a) a __attribute__((aligned(16)))
// #define B3_ATTRIBUTE_ALIGNED64(a) a __attribute__((aligned(64)))
// #define B3_ATTRIBUTE_ALIGNED128(a) a __attribute__((aligned(128)))
// #ifndef assert
// #include <assert.h>
// #endif
// #ifdef B3_DEBUG
// #else
// #define b3Assert(x)
// #endif
//b3FullAssert is optional, slows down a lot
// #define b3FullAssert(x)

// #define b3Likely(_c) __builtin_expect((_c), 1)
// #define b3Unlikely(_c) __builtin_expect((_c), 0)

// #else
//non-windows systems

// #if (defined(__APPLE__) && (!defined(B3_USE_DOUBLE_PRECISION)))
// #if defined(__i386__) || defined(__x86_64__)
// #define B3_USE_SSE
//B3_USE_SSE_IN_API is enabled on Mac OSX by default, because memory is automatically aligned on 16-byte boundaries
//if apps run into issues, we will disable the next line
// #define B3_USE_SSE_IN_API
// #ifdef B3_USE_SSE
// #endif  //B3_USE_SSE
// #elif defined(__armv7__)
// #ifdef __clang__
// #endif  //__clang__
// #endif  //__arm__

// #define B3_FORCE_INLINE inline __attribute__((always_inline))
/**\todo: check out alignment methods for other platforms/compilers */
// #define B3_ATTRIBUTE_ALIGNED16(a) a __attribute__((aligned(16)))
// #define B3_ATTRIBUTE_ALIGNED64(a) a __attribute__((aligned(64)))
// #define B3_ATTRIBUTE_ALIGNED128(a) a __attribute__((aligned(128)))
// #ifndef assert
// #include <assert.h>
// #endif

// #if defined(DEBUG) || defined(_DEBUG)
// #if defined(__i386__) || defined(__x86_64__)
// #include <stdio.h>
// #define b3Assert(x)
// 	{
// 		if (!(x))
// 		{
// 			b3Error("Assert %s in line %d, file %s\n", #x, __LINE__, __FILE__);
// 			asm volatile("int3");
// 		}
// 	}
// #else  //defined (__i386__) || defined (__x86_64__)
// #define b3Assert assert
// #endif  //defined (__i386__) || defined (__x86_64__)
// #else   //defined(DEBUG) || defined (_DEBUG)
// #define b3Assert(x)
// #endif  //defined(DEBUG) || defined (_DEBUG)

//b3FullAssert is optional, slows down a lot
// #define b3FullAssert(x)
// #define b3Likely(_c) _c
// #define b3Unlikely(_c) _c

// #else

// #define B3_FORCE_INLINE inline
/**\todo: check out alignment methods for other platforms/compilers */
// #define B3_ATTRIBUTE_ALIGNED16(a) a __attribute__((aligned(16)))
// #define B3_ATTRIBUTE_ALIGNED64(a) a __attribute__((aligned(64)))
// #define B3_ATTRIBUTE_ALIGNED128(a) a __attribute__((aligned(128)))
/**#define B3_ATTRIBUTE_ALIGNED16(a) a
 * #define B3_ATTRIBUTE_ALIGNED64(a) a
 * #define B3_ATTRIBUTE_ALIGNED128(a) a */
// #ifndef assert
// #include <assert.h>
// #endif

// #if defined(DEBUG) || defined(_DEBUG)
// #define b3Assert assert
// #else
// #define b3Assert(x)
// #endif

//b3FullAssert is optional, slows down a lot
// #define b3FullAssert(x)
// #define b3Likely(_c) _c
// #define b3Unlikely(_c) _c
// #endif  //__APPLE__

// #endif  // LIBSPE2

// #endif  //__CELLOS_LV2__
// #endif

/**The b3Scalar type abstracts floating point numbers, to easily switch between double and single floating point precision. */
// #if defined(B3_USE_DOUBLE_PRECISION)
// #else
//keep B3_LARGE_FLOAT*B3_LARGE_FLOAT < FLT_MAX
public static native @MemberGetter float B3_LARGE_FLOAT();
public static final float B3_LARGE_FLOAT = B3_LARGE_FLOAT();
// #endif

// #ifdef B3_USE_SSE
// #endif  //B3_USE_SSE

// #if defined B3_USE_SSE_IN_API && defined(B3_USE_SSE)
// #ifdef _WIN32

// #else  //_WIN32

// #define b3CastfTo128i(a) ((__m128i)(a))
// #define b3CastfTo128d(a) ((__m128d)(a))
// #define b3CastiTo128f(a) ((__m128)(a))
// #define b3CastdTo128f(a) ((__m128)(a))
// #define b3CastdTo128i(a) ((__m128i)(a))
// #define b3Assign128(r0, r1, r2, r3)
// 	(__m128) { r0, r1, r2, r3 }
// #endif  //_WIN32
// #endif  //B3_USE_SSE_IN_API

// #ifdef B3_USE_NEON
// #endif

// #define B3_DECLARE_ALIGNED_ALLOCATOR()
// 	B3_FORCE_INLINE void *operator new(size_t sizeInBytes) { return b3AlignedAlloc(sizeInBytes, 16); }
// 	B3_FORCE_INLINE void operator delete(void *ptr) { b3AlignedFree(ptr); }
// 	B3_FORCE_INLINE void *operator new(size_t, void *ptr) { return ptr; }
// 	B3_FORCE_INLINE void operator delete(void *, void *) {}
// 	B3_FORCE_INLINE void *operator new[](size_t sizeInBytes) { return b3AlignedAlloc(sizeInBytes, 16); }
// 	B3_FORCE_INLINE void operator delete[](void *ptr) { b3AlignedFree(ptr); }
// 	B3_FORCE_INLINE void *operator new[](size_t, void *ptr) { return ptr; }
// 	B3_FORCE_INLINE void operator delete[](void *, void *) {}

// #if defined(B3_USE_DOUBLE_PRECISION) || defined(B3_FORCE_DOUBLE_FUNCTIONS)

// #else

public static native @Cast("b3Scalar") float b3Sqrt(@Cast("b3Scalar") float y);
public static native @Cast("b3Scalar") float b3Fabs(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Cos(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Sin(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Tan(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Acos(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Asin(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Atan(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Atan2(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y);
public static native @Cast("b3Scalar") float b3Exp(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Log(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Pow(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y);
public static native @Cast("b3Scalar") float b3Fmod(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y);

// #endif

public static native @MemberGetter double B3_2_PI();
public static final double B3_2_PI = B3_2_PI();
public static native @MemberGetter double B3_PI();
public static final double B3_PI = B3_PI();
public static native @MemberGetter double B3_HALF_PI();
public static final double B3_HALF_PI = B3_HALF_PI();
public static native @MemberGetter double B3_RADS_PER_DEG();
public static final double B3_RADS_PER_DEG = B3_RADS_PER_DEG();
public static native @MemberGetter double B3_DEGS_PER_RAD();
public static final double B3_DEGS_PER_RAD = B3_DEGS_PER_RAD();
public static native @MemberGetter double B3_SQRT12();
public static final double B3_SQRT12 = B3_SQRT12();

// #define b3RecipSqrt(x) ((b3Scalar)(b3Scalar(1.0) / b3Sqrt(b3Scalar(x)))) /* reciprocal square root */

// #ifdef B3_USE_DOUBLE_PRECISION
// #else
public static native @MemberGetter float B3_EPSILON();
public static final float B3_EPSILON = B3_EPSILON();
public static native @MemberGetter float B3_INFINITY();
public static final float B3_INFINITY = B3_INFINITY();
// #endif

public static native @Cast("b3Scalar") float b3Atan2Fast(@Cast("b3Scalar") float y, @Cast("b3Scalar") float x);

public static native @Cast("bool") boolean b3FuzzyZero(@Cast("b3Scalar") float x);

public static native @Cast("bool") boolean b3Equal(@Cast("b3Scalar") float a, @Cast("b3Scalar") float eps);
public static native @Cast("bool") boolean b3GreaterEqual(@Cast("b3Scalar") float a, @Cast("b3Scalar") float eps);

public static native int b3IsNegative(@Cast("b3Scalar") float x);

public static native @Cast("b3Scalar") float b3Radians(@Cast("b3Scalar") float x);
public static native @Cast("b3Scalar") float b3Degrees(@Cast("b3Scalar") float x);

// #define B3_DECLARE_HANDLE(name)
// 	typedef struct name##__
// 	{
// 		int unused;
// 	} * name

// #ifndef b3Fsel
public static native @Cast("b3Scalar") float b3Fsel(@Cast("b3Scalar") float a, @Cast("b3Scalar") float b, @Cast("b3Scalar") float c);
// #endif
// #define b3Fsels(a, b, c) (b3Scalar) b3Fsel(a, b, c)

public static native @Cast("bool") boolean b3MachineIsLittleEndian();

/**b3Select avoids branches, which makes performance much better for consoles like Playstation 3 and XBox 360
 * Thanks Phil Knight. See also http://www.cellperformance.com/articles/2006/04/more_techniques_for_eliminatin_1.html */
public static native @Cast("unsigned") int b3Select(@Cast("unsigned") int condition, @Cast("unsigned") int valueIfConditionNonZero, @Cast("unsigned") int valueIfConditionZero);
public static native float b3Select(@Cast("unsigned") int condition, float valueIfConditionNonZero, float valueIfConditionZero);

//PCK: endian swapping functions
public static native @Cast("unsigned") int b3SwapEndian(@Cast("unsigned") int val);

public static native @Cast("unsigned short") short b3SwapEndian(@Cast("unsigned short") short val);

/**b3SwapFloat uses using char pointers to swap the endianness
////b3SwapFloat/b3SwapDouble will NOT return a float, because the machine might 'correct' invalid floating point values
 * Not all values of sign/exponent/mantissa are valid floating point numbers according to IEEE 754.
 * When a floating point unit is faced with an invalid value, it may actually change the value, or worse, throw an exception.
 * In most systems, running user mode code, you wouldn't get an exception, but instead the hardware/os/runtime will 'fix' the number for you.
 * so instead of returning a float/double, we return integer/long long integer */
public static native @Cast("unsigned int") int b3SwapEndianFloat(float d);

// unswap using char pointers
public static native float b3UnswapEndianFloat(@Cast("unsigned int") int a);

// swap using char pointers
public static native void b3SwapEndianDouble(double d, @Cast("unsigned char*") BytePointer dst);
public static native void b3SwapEndianDouble(double d, @Cast("unsigned char*") ByteBuffer dst);
public static native void b3SwapEndianDouble(double d, @Cast("unsigned char*") byte[] dst);

// unswap using char pointers
public static native double b3UnswapEndianDouble(@Cast("const unsigned char*") BytePointer src);
public static native double b3UnswapEndianDouble(@Cast("const unsigned char*") ByteBuffer src);
public static native double b3UnswapEndianDouble(@Cast("const unsigned char*") byte[] src);

// returns normalized value in range [-B3_PI, B3_PI]
public static native @Cast("b3Scalar") float b3NormalizeAngle(@Cast("b3Scalar") float angleInRadians);
// Targeting ..\Bullet3Common\b3TypedObject.java



/**align a pointer to the provided alignment, upwards */

// #endif  //B3_SCALAR_H


// Parsed from Bullet3Common/b3Vector3.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_VECTOR3_H
// #define B3_VECTOR3_H

//#include <stdint.h>
// #include "b3Scalar.h"
// #include "b3MinMax.h"
// #include "b3AlignedAllocator.h"

// #ifdef B3_USE_DOUBLE_PRECISION
// #else
// #define b3Vector3Data b3Vector3FloatData
public static final String b3Vector3DataName = "b3Vector3FloatData";
// #endif  //B3_USE_DOUBLE_PRECISION

// #if defined B3_USE_SSE

// #endif

// #ifdef B3_USE_NEON

// #endif

// #if defined(B3_USE_SSE_IN_API) && defined(B3_USE_SSE)
// #endif

public static native @ByVal b3Vector3 b3MakeVector3(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y, @Cast("b3Scalar") float z);
public static native @ByVal b3Vector3 b3MakeVector3(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y, @Cast("b3Scalar") float z, @Cast("b3Scalar") float w);
public static native @ByVal b3Vector4 b3MakeVector4(@Cast("b3Scalar") float x, @Cast("b3Scalar") float y, @Cast("b3Scalar") float z, @Cast("b3Scalar") float w);
// Targeting ..\Bullet3Common\b3Vector3.java



/**\brief Return the sum of two vectors (Point symantics)*/
public static native @ByVal @Name("operator +") b3Vector3 add(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the elementwise product of two vectors */
public static native @ByVal @Name("operator *") b3Vector3 multiply(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the difference between two vectors */
public static native @ByVal @Name("operator -") b3Vector3 subtract(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the negative of the vector */
public static native @ByVal @Name("operator -") b3Vector3 subtract(@Const @ByRef b3Vector3 v);

/**\brief Return the vector scaled by s */
public static native @ByVal @Name("operator *") b3Vector3 multiply(@Const @ByRef b3Vector3 v, @Cast("const b3Scalar") float s);

/**\brief Return the vector scaled by s */
public static native @ByVal @Name("operator *") b3Vector3 multiply(@Cast("const b3Scalar") float s, @Const @ByRef b3Vector3 v);

/**\brief Return the vector inversely scaled by s */
public static native @ByVal @Name("operator /") b3Vector3 divide(@Const @ByRef b3Vector3 v, @Cast("const b3Scalar") float s);

/**\brief Return the vector inversely scaled by s */
public static native @ByVal @Name("operator /") b3Vector3 divide(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the dot product between two vectors */
public static native @Cast("b3Scalar") float b3Dot(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the distance squared between two vectors */
public static native @Cast("b3Scalar") float b3Distance2(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the distance between two vectors */
public static native @Cast("b3Scalar") float b3Distance(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the angle between two vectors */
public static native @Cast("b3Scalar") float b3Angle(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

/**\brief Return the cross product of two vectors */
public static native @ByVal b3Vector3 b3Cross(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

public static native @Cast("b3Scalar") float b3Triple(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2, @Const @ByRef b3Vector3 v3);

/**\brief Return the linear interpolation between two vectors
 * @param v1 One vector
 * @param v2 The other vector
 * @param t The ration of this to v (t = 0 => return v1, t=1 => return v2) */
public static native @ByVal b3Vector3 b3Lerp(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2, @Cast("const b3Scalar") float t);












// Targeting ..\Bullet3Common\b3Vector4.java



/**b3SwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void b3SwapScalarEndian(@Cast("const b3Scalar") float sourceVal, @Cast("b3Scalar*") @ByRef FloatPointer destVal);
public static native void b3SwapScalarEndian(@Cast("const b3Scalar") float sourceVal, @Cast("b3Scalar*") @ByRef FloatBuffer destVal);
public static native void b3SwapScalarEndian(@Cast("const b3Scalar") float sourceVal, @Cast("b3Scalar*") @ByRef float[] destVal);
/**b3SwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void b3SwapVector3Endian(@Const @ByRef b3Vector3 sourceVec, @ByRef b3Vector3 destVec);

/**b3UnSwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void b3UnSwapVector3Endian(@ByRef b3Vector3 vector);
// Targeting ..\Bullet3Common\b3Vector3FloatData.java


// Targeting ..\Bullet3Common\b3Vector3DoubleData.java















// #if defined(B3_USE_SSE_IN_API) && defined(B3_USE_SSE)

// #endif

// #endif  //B3_VECTOR3_H


// Parsed from Bullet3Common/b3QuadWord.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_SIMD_QUADWORD_H
// #define B3_SIMD_QUADWORD_H

// #include "b3Scalar.h"
// #include "b3MinMax.h"

// #if defined(__CELLOS_LV2) && defined(__SPU__)
// #include <altivec.h>
// Targeting ..\Bullet3Common\b3QuadWord.java



// #endif  //B3_SIMD_QUADWORD_H


// Parsed from Bullet3Common/b3Quaternion.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_SIMD__QUATERNION_H_
// #define B3_SIMD__QUATERNION_H_

// #include "b3Vector3.h"
// #include "b3QuadWord.h"
// Targeting ..\Bullet3Common\b3Quaternion.java



/**\brief Return the product of two quaternions */
public static native @ByVal @Name("operator *") b3Quaternion multiply(@Const @ByRef b3Quaternion q1, @Const @ByRef b3Quaternion q2);

public static native @ByVal @Name("operator *") b3Quaternion multiply(@Const @ByRef b3Quaternion q, @Const @ByRef b3Vector3 w);

public static native @ByVal @Name("operator *") b3Quaternion multiply(@Const @ByRef b3Vector3 w, @Const @ByRef b3Quaternion q);

/**\brief Calculate the dot product between two quaternions */
public static native @Cast("b3Scalar") float b3Dot(@Const @ByRef b3Quaternion q1, @Const @ByRef b3Quaternion q2);

/**\brief Return the length of a quaternion */
public static native @Cast("b3Scalar") float b3Length(@Const @ByRef b3Quaternion q);

/**\brief Return the angle between two quaternions*/
public static native @Cast("b3Scalar") float b3Angle(@Const @ByRef b3Quaternion q1, @Const @ByRef b3Quaternion q2);

/**\brief Return the inverse of a quaternion*/
public static native @ByVal b3Quaternion b3Inverse(@Const @ByRef b3Quaternion q);

/**\brief Return the result of spherical linear interpolation betwen two quaternions 
 * @param q1 The first quaternion
 * @param q2 The second quaternion 
 * @param t The ration between q1 and q2.  t = 0 return q1, t=1 returns q2 
 * Slerp assumes constant velocity between positions. */
public static native @ByVal b3Quaternion b3Slerp(@Const @ByRef b3Quaternion q1, @Const @ByRef b3Quaternion q2, @Cast("const b3Scalar") float t);

public static native @ByVal b3Quaternion b3QuatMul(@Const @ByRef b3Quaternion rot0, @Const @ByRef b3Quaternion rot1);

public static native @ByVal b3Quaternion b3QuatNormalized(@Const @ByRef b3Quaternion orn);

public static native @ByVal b3Vector3 b3QuatRotate(@Const @ByRef b3Quaternion rotation, @Const @ByRef b3Vector3 v);

public static native @ByVal b3Quaternion b3ShortestArcQuat(@Const @ByRef b3Vector3 v0, @Const @ByRef b3Vector3 v1);

public static native @ByVal b3Quaternion b3ShortestArcQuatNormalize2(@ByRef b3Vector3 v0, @ByRef b3Vector3 v1);

// #endif  //B3_SIMD__QUATERNION_H_


// Parsed from Bullet3Common/b3Matrix3x3.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_MATRIX3x3_H
// #define B3_MATRIX3x3_H

// #include "b3Vector3.h"
// #include "b3Quaternion.h"
// #include <stdio.h>

// #ifdef B3_USE_SSE
// #endif

// #if defined(B3_USE_SSE) || defined(B3_USE_NEON)
// #endif

// #ifdef B3_USE_DOUBLE_PRECISION
// #else
// #define b3Matrix3x3Data b3Matrix3x3FloatData
// Targeting ..\Bullet3Common\b3Matrix3x3.java







public static native @ByVal @Name("operator *") b3Matrix3x3 multiply(@Const @ByRef b3Matrix3x3 m, @Cast("const b3Scalar") float k);

public static native @ByVal @Name("operator +") b3Matrix3x3 add(@Const @ByRef b3Matrix3x3 m1, @Const @ByRef b3Matrix3x3 m2);

public static native @ByVal @Name("operator -") b3Matrix3x3 subtract(@Const @ByRef b3Matrix3x3 m1, @Const @ByRef b3Matrix3x3 m2);

















public static native @ByVal @Name("operator *") b3Vector3 multiply(@Const @ByRef b3Matrix3x3 m, @Const @ByRef b3Vector3 v);

public static native @ByVal @Name("operator *") b3Vector3 multiply(@Const @ByRef b3Vector3 v, @Const @ByRef b3Matrix3x3 m);

public static native @ByVal @Name("operator *") b3Matrix3x3 multiply(@Const @ByRef b3Matrix3x3 m1, @Const @ByRef b3Matrix3x3 m2);

/*
B3_FORCE_INLINE b3Matrix3x3 b3MultTransposeLeft(const b3Matrix3x3& m1, const b3Matrix3x3& m2) {
return b3Matrix3x3(
m1[0][0] * m2[0][0] + m1[1][0] * m2[1][0] + m1[2][0] * m2[2][0],
m1[0][0] * m2[0][1] + m1[1][0] * m2[1][1] + m1[2][0] * m2[2][1],
m1[0][0] * m2[0][2] + m1[1][0] * m2[1][2] + m1[2][0] * m2[2][2],
m1[0][1] * m2[0][0] + m1[1][1] * m2[1][0] + m1[2][1] * m2[2][0],
m1[0][1] * m2[0][1] + m1[1][1] * m2[1][1] + m1[2][1] * m2[2][1],
m1[0][1] * m2[0][2] + m1[1][1] * m2[1][2] + m1[2][1] * m2[2][2],
m1[0][2] * m2[0][0] + m1[1][2] * m2[1][0] + m1[2][2] * m2[2][0],
m1[0][2] * m2[0][1] + m1[1][2] * m2[1][1] + m1[2][2] * m2[2][1],
m1[0][2] * m2[0][2] + m1[1][2] * m2[1][2] + m1[2][2] * m2[2][2]);
}
*/

/**\brief Equality operator between two matrices
* It will test all elements are equal.  */
public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b3Matrix3x3 m1, @Const @ByRef b3Matrix3x3 m2);
// Targeting ..\Bullet3Common\b3Matrix3x3FloatData.java


// Targeting ..\Bullet3Common\b3Matrix3x3DoubleData.java













// #endif  //B3_MATRIX3x3_H


// Parsed from Bullet3Common/b3MinMax.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_GEN_MINMAX_H
// #define B3_GEN_MINMAX_H

// #include "b3Scalar.h"

// #endif  //B3_GEN_MINMAX_H


// Parsed from Bullet3Common/b3ResizablePool.h


// #ifndef B3_RESIZABLE_POOL_H
// #define B3_RESIZABLE_POOL_H

// #include "Bullet3Common/b3AlignedObjectArray.h"

/** enum  */
public static final int
	B3_POOL_HANDLE_TERMINAL_FREE = -1,
	B3_POOL_HANDLE_TERMINAL_USED = -2;
/**end handle management */

// #endif  //B3_RESIZABLE_POOL_H


// Parsed from Bullet3Common/b3Transform.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_TRANSFORM_H
// #define B3_TRANSFORM_H

// #include "b3Matrix3x3.h"

// #ifdef B3_USE_DOUBLE_PRECISION
// #else
// #define b3TransformData b3TransformFloatData
// Targeting ..\Bullet3Common\b3Transform.java









/**\brief Test if two transforms have all elements equal */
public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b3Transform t1, @Const @ByRef b3Transform t2);
// Targeting ..\Bullet3Common\b3TransformFloatData.java


// Targeting ..\Bullet3Common\b3TransformDoubleData.java













// #endif  //B3_TRANSFORM_H


// Parsed from Bullet3Common/b3TransformUtil.h

/*
Copyright (c) 2003-2013 Gino van den Bergen / Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_TRANSFORM_UTIL_H
// #define B3_TRANSFORM_UTIL_H

// #include "b3Transform.h"
public static native @MemberGetter double B3_ANGULAR_MOTION_THRESHOLD();
public static final double B3_ANGULAR_MOTION_THRESHOLD = B3_ANGULAR_MOTION_THRESHOLD();

public static native @ByVal b3Vector3 b3AabbSupport(@Const @ByRef b3Vector3 halfExtents, @Const @ByRef b3Vector3 supportDir);
// Targeting ..\Bullet3Common\b3TransformUtil.java


// Targeting ..\Bullet3Common\b3ConvexSeparatingDistanceUtil.java



// #endif  //B3_TRANSFORM_UTIL_H


// Parsed from Bullet3Common/shared/b3Float4.h

// #ifndef B3_FLOAT4_H
// #define B3_FLOAT4_H

// #include "Bullet3Common/shared/b3PlatformDefinitions.h"

// #ifdef __cplusplus
// #include "Bullet3Common/b3Vector3.h"
// #define b3Float4 b3Vector3
// #define b3Float4ConstArg const b3Vector3&
// #define b3Dot3F4 b3Dot
// #define b3Cross3 b3Cross
// #define b3MakeFloat4 b3MakeVector3
public static native @ByVal b3Vector3 b3Normalized(@Const @ByRef b3Vector3 vec);

public static native @ByVal b3Vector3 b3FastNormalized3(@Const @ByRef b3Vector3 v);

public static native @ByVal b3Vector3 b3MaxFloat4(@Const @ByRef b3Vector3 a, @Const @ByRef b3Vector3 b);
public static native @ByVal b3Vector3 b3MinFloat4(@Const @ByRef b3Vector3 a, @Const @ByRef b3Vector3 b);

// #else

// #endif

public static native @Cast("bool") boolean b3IsAlmostZero(@Const @ByRef b3Vector3 v);

public static native int b3MaxDot(@Const @ByRef b3Vector3 vec, @Const b3Vector3 vecArray, int vecLen, FloatPointer dotOut);
public static native int b3MaxDot(@Const @ByRef b3Vector3 vec, @Const b3Vector3 vecArray, int vecLen, FloatBuffer dotOut);
public static native int b3MaxDot(@Const @ByRef b3Vector3 vec, @Const b3Vector3 vecArray, int vecLen, float[] dotOut);

// #endif  //B3_FLOAT4_H


// Parsed from Bullet3Common/shared/b3Int2.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_INT2_H
// #define B3_INT2_H
// Targeting ..\Bullet3Common\b3UnsignedInt2.java


// Targeting ..\Bullet3Common\b3Int2.java



public static native @ByVal b3Int2 b3MakeInt2(int x, int y);
// #else

// #endif  //__cplusplus
// #endif

// Parsed from Bullet3Common/shared/b3Int4.h

// #ifndef B3_INT4_H
// #define B3_INT4_H

// #ifdef __cplusplus

// #include "Bullet3Common/b3Scalar.h"
// Targeting ..\Bullet3Common\b3UnsignedInt4.java


// Targeting ..\Bullet3Common\b3Int4.java



public static native @ByVal b3Int4 b3MakeInt4(int x, int y, int z, int w/*=0*/);
public static native @ByVal b3Int4 b3MakeInt4(int x, int y, int z);

public static native @ByVal b3UnsignedInt4 b3MakeUnsignedInt4(@Cast("unsigned int") int x, @Cast("unsigned int") int y, @Cast("unsigned int") int z, @Cast("unsigned int") int w/*=0*/);
public static native @ByVal b3UnsignedInt4 b3MakeUnsignedInt4(@Cast("unsigned int") int x, @Cast("unsigned int") int y, @Cast("unsigned int") int z);

// #else

// #endif  //__cplusplus

// #endif  //B3_INT4_H


// Parsed from Bullet3Common/shared/b3Quat.h

// #ifndef B3_QUAT_H
// #define B3_QUAT_H

// #include "Bullet3Common/shared/b3PlatformDefinitions.h"
// #include "Bullet3Common/shared/b3Float4.h"

// #ifdef __cplusplus
// #include "Bullet3Common/b3Quaternion.h"
// #include "Bullet3Common/b3Transform.h"

// #define b3Quat b3Quaternion
// #define b3QuatConstArg const b3Quaternion&
public static native @ByVal b3Quaternion b3QuatInverse(@Const @ByRef b3Quaternion orn);

public static native @ByVal b3Vector3 b3TransformPoint(@Const @ByRef b3Vector3 point, @Const @ByRef b3Vector3 translation, @Const @ByRef b3Quaternion orientation);

// #else

// #endif

// #endif  //B3_QUAT_H


// Parsed from Bullet3Common/shared/b3Mat3x3.h


// #ifndef B3_MAT3x3_H
// #define B3_MAT3x3_H

// #include "Bullet3Common/shared/b3Quat.h"

// #ifdef __cplusplus

// #include "Bullet3Common/b3Matrix3x3.h"

// #define b3Mat3x3 b3Matrix3x3
// #define b3Mat3x3ConstArg const b3Matrix3x3&

public static native @ByVal b3Matrix3x3 b3QuatGetRotationMatrix(@Const @ByRef b3Quaternion quat);

public static native @ByVal b3Matrix3x3 b3AbsoluteMat3x3(@Const @ByRef b3Matrix3x3 mat);

// #define b3GetRow(m, row) m.getRow(row)

public static native @ByVal b3Vector3 mtMul3(@Const @ByRef b3Vector3 a, @Const @ByRef b3Matrix3x3 b);

// #else

// #endif

// #endif  //B3_MAT3x3_H


// Parsed from Bullet3Common/shared/b3PlatformDefinitions.h

// #ifndef B3_PLATFORM_DEFINITIONS_H
// #define B3_PLATFORM_DEFINITIONS_H
// Targeting ..\Bullet3Common\MyTest.java



// #ifdef __cplusplus
//#define b3ConstArray(a) const b3AlignedObjectArray<a>&
// #define b3ConstArray(a) const a *
// #define b3AtomicInc(a) ((*a)++)

public static native int b3AtomicAdd(IntPointer p, int val);
public static native int b3AtomicAdd(IntBuffer p, int val);
public static native int b3AtomicAdd(int[] p, int val);

// #define __global

// #define B3_STATIC static
// #else
// #endif

// #endif


}
