// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.Bullet3OpenCL.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.Bullet3Common.*;
import static org.bytedeco.bullet.global.Bullet3Common.*;
import org.bytedeco.bullet.Bullet3Collision.*;
import static org.bytedeco.bullet.global.Bullet3Collision.*;
import org.bytedeco.bullet.Bullet3Dynamics.*;
import static org.bytedeco.bullet.global.Bullet3Dynamics.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

public class Bullet3OpenCL extends org.bytedeco.bullet.presets.Bullet3OpenCL {
    static { Loader.load(); }

// Parsed from Bullet3Common/b3AlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_OBJECT_ARRAY__
// #define B3_OBJECT_ARRAY__

// #include "b3Scalar.h"  // has definitions like B3_FORCE_INLINE
// #include "b3AlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable B3_USE_PLACEMENT_NEW
 * then the b3AlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable B3_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int B3_USE_PLACEMENT_NEW = 1;
//#define B3_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define B3_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef B3_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //B3_USE_MEMCPY

// #ifdef B3_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\Bullet3OpenCL\b3ConvexUtilityArray.java


// Targeting ..\Bullet3OpenCL\b3UnsignedCharOCLArrayArray.java


// Targeting ..\Bullet3OpenCL\b3OptimizedBvhArray.java


// Targeting ..\Bullet3OpenCL\b3TriangleIndexVertexArrayArray.java


// Targeting ..\Bullet3OpenCL\b3BvhInfoArray.java


// Targeting ..\Bullet3OpenCL\b3BvhSubtreeInfoArray.java


// Targeting ..\Bullet3OpenCL\b3CompoundOverlappingPairArray.java


// Targeting ..\Bullet3OpenCL\b3Contact4Array.java


// Targeting ..\Bullet3OpenCL\b3GpuConstraint4Array.java


// Targeting ..\Bullet3OpenCL\b3GpuGenericConstraintArray.java


// Targeting ..\Bullet3OpenCL\b3InertiaDataArray.java


// Targeting ..\Bullet3OpenCL\b3QuantizedBvhNodeArray.java


// Targeting ..\Bullet3OpenCL\b3SapAabbArray.java


// Targeting ..\Bullet3OpenCL\b3SortDataArray.java



// #endif  //B3_OBJECT_ARRAY__


// Parsed from Bullet3OpenCL/Initialize/b3OpenCLUtils.h

/*
Bullet Continuous Collision Detection and Physics Library, http://bulletphysics.org
Copyright (C) 2006 - 2011 Sony Computer Entertainment Inc. 

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

//original author: Roman Ponomarev
//cleanup by Erwin Coumans

// #ifndef B3_OPENCL_UTILS_H
// #define B3_OPENCL_UTILS_H

// #include "b3OpenCLInclude.h"

// #ifdef __cplusplus
// #endif

	/**C API for OpenCL utilities: convenience functions, see below for C++ API
	 <p>
	 *  CL Context optionally takes a GL context. This is a generic type because we don't really want this code
	 *  to have to understand GL types. It is a HGLRC in _WIN32 or a GLXContext otherwise. */
	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromType(@Cast("cl_device_type") long deviceType, @Cast("cl_int*") IntPointer pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex, @Cast("cl_platform_id*") PointerPointer platformId);
	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromType(@Cast("cl_device_type") long deviceType, @Cast("cl_int*") IntBuffer pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex, @Cast("cl_platform_id*") PointerPointer platformId);
	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromType(@Cast("cl_device_type") long deviceType, @Cast("cl_int*") int[] pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex, @Cast("cl_platform_id*") PointerPointer platformId);

	public static native int b3OpenCLUtils_getNumDevices(@Cast("cl_context") Pointer cxMainContext);

	public static native @Cast("cl_device_id") Pointer b3OpenCLUtils_getDevice(@Cast("cl_context") Pointer cxMainContext, int nr);

	public static native void b3OpenCLUtils_printDeviceInfo(@Cast("cl_device_id") Pointer device);

	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("const char*") BytePointer kernelName, @Cast("cl_int*") IntPointer pErrNum, @Cast("cl_program") Pointer prog, @Cast("const char*") BytePointer additionalMacros);
	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, String kernelName, @Cast("cl_int*") IntBuffer pErrNum, @Cast("cl_program") Pointer prog, String additionalMacros);
	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("const char*") BytePointer kernelName, @Cast("cl_int*") int[] pErrNum, @Cast("cl_program") Pointer prog, @Cast("const char*") BytePointer additionalMacros);
	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, String kernelName, @Cast("cl_int*") IntPointer pErrNum, @Cast("cl_program") Pointer prog, String additionalMacros);
	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("const char*") BytePointer kernelName, @Cast("cl_int*") IntBuffer pErrNum, @Cast("cl_program") Pointer prog, @Cast("const char*") BytePointer additionalMacros);
	public static native @Cast("cl_kernel") Pointer b3OpenCLUtils_compileCLKernelFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, String kernelName, @Cast("cl_int*") int[] pErrNum, @Cast("cl_program") Pointer prog, String additionalMacros);

	//optional
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("cl_int*") IntPointer pErrNum, @Cast("const char*") BytePointer additionalMacros, @Cast("const char*") BytePointer srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, @Cast("cl_int*") IntBuffer pErrNum, String additionalMacros, String srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("cl_int*") int[] pErrNum, @Cast("const char*") BytePointer additionalMacros, @Cast("const char*") BytePointer srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, @Cast("cl_int*") IntPointer pErrNum, String additionalMacros, String srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, @Cast("const char*") BytePointer kernelSource, @Cast("cl_int*") IntBuffer pErrNum, @Cast("const char*") BytePointer additionalMacros, @Cast("const char*") BytePointer srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);
	public static native @Cast("cl_program") Pointer b3OpenCLUtils_compileCLProgramFromString(@Cast("cl_context") Pointer clContext, @Cast("cl_device_id") Pointer device, String kernelSource, @Cast("cl_int*") int[] pErrNum, String additionalMacros, String srcFileNameForCaching, @Cast("bool") boolean disableBinaryCaching);

	//the following optional APIs provide access using specific platform information
	public static native int b3OpenCLUtils_getNumPlatforms(@Cast("cl_int*") IntPointer pErrNum);
	public static native int b3OpenCLUtils_getNumPlatforms(@Cast("cl_int*") IntBuffer pErrNum);
	public static native int b3OpenCLUtils_getNumPlatforms(@Cast("cl_int*") int[] pErrNum);

	/**get the nr'th platform, where nr is in the range [0..getNumPlatforms) */
	public static native @Cast("cl_platform_id") Pointer b3OpenCLUtils_getPlatform(int nr, @Cast("cl_int*") IntPointer pErrNum);
	public static native @Cast("cl_platform_id") Pointer b3OpenCLUtils_getPlatform(int nr, @Cast("cl_int*") IntBuffer pErrNum);
	public static native @Cast("cl_platform_id") Pointer b3OpenCLUtils_getPlatform(int nr, @Cast("cl_int*") int[] pErrNum);

	public static native void b3OpenCLUtils_printPlatformInfo(@Cast("cl_platform_id") Pointer platform);

	public static native @Cast("const char*") BytePointer b3OpenCLUtils_getSdkVendorName();

	/**set the path (directory/folder) where the compiled OpenCL kernel are stored */
	public static native void b3OpenCLUtils_setCachePath(@Cast("const char*") BytePointer path);
	public static native void b3OpenCLUtils_setCachePath(String path);

	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromPlatform(@Cast("cl_platform_id") Pointer platform, @Cast("cl_device_type") long deviceType, @Cast("cl_int*") IntPointer pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex);
	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromPlatform(@Cast("cl_platform_id") Pointer platform, @Cast("cl_device_type") long deviceType, @Cast("cl_int*") IntBuffer pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex);
	public static native @Cast("cl_context") Pointer b3OpenCLUtils_createContextFromPlatform(@Cast("cl_platform_id") Pointer platform, @Cast("cl_device_type") long deviceType, @Cast("cl_int*") int[] pErrNum, Pointer pGLCtx, Pointer pGLDC, int preferredDeviceIndex, int preferredPlatformIndex);

// #ifdef __cplusplus

public static final int B3_MAX_STRING_LENGTH = 1024;
// Targeting ..\Bullet3OpenCL\b3OpenCLDeviceInfo.java


// Targeting ..\Bullet3OpenCL\b3OpenCLPlatformInfo.java


// Targeting ..\Bullet3OpenCL\b3OpenCLUtils.java



// #endif  //__cplusplus

// #endif  // B3_OPENCL_UTILS_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3BufferInfoCL.h


// #ifndef B3_BUFFER_INFO_CL_H
// #define B3_BUFFER_INFO_CL_H

// #include "b3OpenCLArray.h"
// Targeting ..\Bullet3OpenCL\b3BufferInfoCL.java



// #endif  //B3_BUFFER_INFO_CL_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3LauncherCL.h


// #ifndef B3_LAUNCHER_CL_H
// #define B3_LAUNCHER_CL_H

// #include "b3BufferInfoCL.h"
// #include "Bullet3Common/b3MinMax.h"
// #include "b3OpenCLArray.h"
// #include <stdio.h>

// #define B3_DEBUG_SERIALIZE_CL

// #ifdef _WIN32
// #endif
public static final int B3_CL_MAX_ARG_SIZE = 16;
// Targeting ..\Bullet3OpenCL\b3KernelArgData.java


// Targeting ..\Bullet3OpenCL\b3LauncherCL.java



// #endif  //B3_LAUNCHER_CL_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h

// #ifndef B3_OPENCL_ARRAY_H
// #define B3_OPENCL_ARRAY_H

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// Targeting ..\Bullet3OpenCL\b3UnsignedCharOCLArray.java


// Targeting ..\Bullet3OpenCL\b3IntOCLArray.java


// Targeting ..\Bullet3OpenCL\b3UnsignedIntOCLArray.java


// Targeting ..\Bullet3OpenCL\b3FloatOCLArray.java


// Targeting ..\Bullet3OpenCL\b3Int4OCLArray.java


// Targeting ..\Bullet3OpenCL\b3AabbOCLArray.java


// Targeting ..\Bullet3OpenCL\b3BvhInfoOCLArray.java


// Targeting ..\Bullet3OpenCL\b3BvhSubtreeInfoOCLArray.java


// Targeting ..\Bullet3OpenCL\b3CollidableOCLArray.java


// Targeting ..\Bullet3OpenCL\b3CompoundOverlappingPairOCLArray.java


// Targeting ..\Bullet3OpenCL\b3Contact4OCLArray.java


// Targeting ..\Bullet3OpenCL\b3ConvexPolyhedronDataOCLArray.java


// Targeting ..\Bullet3OpenCL\b3GpuChildShapeOCLArray.java


// Targeting ..\Bullet3OpenCL\b3GpuConstraint4OCLArray.java


// Targeting ..\Bullet3OpenCL\b3GpuFaceOCLArray.java


// Targeting ..\Bullet3OpenCL\b3GpuGenericConstraintOCLArray.java


// Targeting ..\Bullet3OpenCL\b3InertiaDataOCLArray.java


// Targeting ..\Bullet3OpenCL\b3Int2OCLArray.java


// Targeting ..\Bullet3OpenCL\b3QuantizedBvhNodeOCLArray.java


// Targeting ..\Bullet3OpenCL\b3RayInfoOCLArray.java


// Targeting ..\Bullet3OpenCL\b3RigidBodyDataOCLArray.java


// Targeting ..\Bullet3OpenCL\b3SapAabbOCLArray.java


// Targeting ..\Bullet3OpenCL\b3SortDataOCLArray.java


// Targeting ..\Bullet3OpenCL\b3Vector3OCLArray.java



// #endif  //B3_OPENCL_ARRAY_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3FillCL.h

// #ifndef B3_FILL_CL_H
// #define B3_FILL_CL_H

// #include "b3OpenCLArray.h"
// #include "Bullet3Common/b3Scalar.h"

// #include "Bullet3Common/shared/b3Int2.h"
// #include "Bullet3Common/shared/b3Int4.h"
// Targeting ..\Bullet3OpenCL\b3FillCL.java



// #endif  //B3_FILL_CL_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3PrefixScanFloat4CL.h


// #ifndef B3_PREFIX_SCAN_CL_H
// #define B3_PREFIX_SCAN_CL_H

// #include "b3OpenCLArray.h"
// #include "b3BufferInfoCL.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3OpenCL\b3PrefixScanFloat4CL.java



// #endif  //B3_PREFIX_SCAN_CL_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3RadixSort32CL.h


// #ifndef B3_RADIXSORT32_H
// #define B3_RADIXSORT32_H

// #include "b3OpenCLArray.h"
// Targeting ..\Bullet3OpenCL\b3SortData.java


// #include "b3BufferInfoCL.h"
// Targeting ..\Bullet3OpenCL\b3RadixSort32CL.java


// #endif  //B3_RADIXSORT32_H


// Parsed from Bullet3OpenCL/ParallelPrimitives/b3BoundSearchCL.h

/*
Copyright (c) 2012 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Takahiro Harada

// #ifndef B3_BOUNDSEARCH_H
// #define B3_BOUNDSEARCH_H

// #pragma once

/*#include <Adl/Adl.h>
#include <AdlPrimitives/Math/Math.h>
#include <AdlPrimitives/Sort/SortData.h>
#include <AdlPrimitives/Fill/Fill.h>
*/

// #include "b3OpenCLArray.h"
// #include "b3FillCL.h"
// #include "b3RadixSort32CL.h"
// Targeting ..\Bullet3OpenCL\b3BoundSearchCL.java



// #endif  //B3_BOUNDSEARCH_H


// Parsed from Bullet3OpenCL/BroadphaseCollision/b3SapAabb.h

// #ifndef B3_SAP_AABB_H
// #define B3_SAP_AABB_H

// #include "Bullet3Common/b3Scalar.h"
// #include "Bullet3Collision/BroadPhaseCollision/shared/b3Aabb.h"
// Targeting ..\Bullet3OpenCL\b3SapAabb.java



// #endif  //B3_SAP_AABB_H


// Parsed from Bullet3OpenCL/BroadphaseCollision/b3GpuBroadphaseInterface.h


// #ifndef B3_GPU_BROADPHASE_INTERFACE_H
// #define B3_GPU_BROADPHASE_INTERFACE_H

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3Common/b3Vector3.h"
// #include "b3SapAabb.h"
// #include "Bullet3Common/shared/b3Int2.h"
// #include "Bullet3Common/shared/b3Int4.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// Targeting ..\Bullet3OpenCL\b3GpuBroadphaseInterface.java



// #endif  //B3_GPU_BROADPHASE_INTERFACE_H


// Parsed from Bullet3OpenCL/BroadphaseCollision/b3GpuGridBroadphase.h

// #ifndef B3_GPU_GRID_BROADPHASE_H
// #define B3_GPU_GRID_BROADPHASE_H

// #include "b3GpuBroadphaseInterface.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3RadixSort32CL.h"
// Targeting ..\Bullet3OpenCL\b3ParamsGridBroadphaseCL.java


// Targeting ..\Bullet3OpenCL\b3GpuGridBroadphase.java



// #endif  //B3_GPU_GRID_BROADPHASE_H

// Parsed from Bullet3OpenCL/BroadphaseCollision/b3GpuParallelLinearBvhBroadphase.h

/*
This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Initial Author Jackson Lee, 2014

// #ifndef B3_GPU_PARALLEL_LINEAR_BVH_BROADPHASE_H
// #define B3_GPU_PARALLEL_LINEAR_BVH_BROADPHASE_H

// #include "Bullet3OpenCL/BroadphaseCollision/b3GpuBroadphaseInterface.h"

// #include "b3GpuParallelLinearBvh.h"
// Targeting ..\Bullet3OpenCL\b3GpuParallelLinearBvhBroadphase.java



// #endif


// Parsed from Bullet3OpenCL/BroadphaseCollision/b3GpuParallelLinearBvh.h

/*
This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Initial Author Jackson Lee, 2014

// #ifndef B3_GPU_PARALLEL_LINEAR_BVH_H
// #define B3_GPU_PARALLEL_LINEAR_BVH_H

//#include "Bullet3Collision/BroadPhaseCollision/shared/b3Aabb.h"
// #include "Bullet3OpenCL/BroadphaseCollision/b3SapAabb.h"
// #include "Bullet3Common/shared/b3Int2.h"
// #include "Bullet3Common/shared/b3Int4.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3RaycastInfo.h"

// #include "Bullet3OpenCL/ParallelPrimitives/b3FillCL.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3RadixSort32CL.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3PrefixScanCL.h"

// #include "Bullet3OpenCL/BroadphaseCollision/kernels/parallelLinearBvhKernels.h"

// #define b3Int64 cl_long
// Targeting ..\Bullet3OpenCL\b3GpuParallelLinearBvh.java



// #endif


// Parsed from Bullet3OpenCL/BroadphaseCollision/b3GpuSapBroadphase.h

// #ifndef B3_GPU_SAP_BROADPHASE_H
// #define B3_GPU_SAP_BROADPHASE_H

// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3FillCL.h"  //b3Int2
// #include "Bullet3OpenCL/ParallelPrimitives/b3RadixSort32CL.h"

// #include "b3SapAabb.h"
// #include "Bullet3Common/shared/b3Int2.h"

// #include "b3GpuBroadphaseInterface.h"
// Targeting ..\Bullet3OpenCL\b3GpuSapBroadphase.java



// #endif  //B3_GPU_SAP_BROADPHASE_H

// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3BvhInfo.h

// #ifndef B3_BVH_INFO_H
// #define B3_BVH_INFO_H

// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3OpenCL\b3BvhInfo.java



// #endif  //B3_BVH_INFO_H

// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3ConvexHullContact.h


// #ifndef _CONVEX_HULL_CONTACT_H
// #define _CONVEX_HULL_CONTACT_H

// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Contact4.h"
// #include "Bullet3Common/shared/b3Int2.h"
// #include "Bullet3Common/shared/b3Int4.h"
// #include "b3OptimizedBvh.h"
// #include "b3BvhInfo.h"
// #include "Bullet3Collision/BroadPhaseCollision/shared/b3Aabb.h"
// Targeting ..\Bullet3OpenCL\GpuSatCollision.java



// #endif  //_CONVEX_HULL_CONTACT_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3ConvexPolyhedronCL.h

// #ifndef CONVEX_POLYHEDRON_CL
// #define CONVEX_POLYHEDRON_CL

// #include "Bullet3Common/b3Transform.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h"

// #endif  //CONVEX_POLYHEDRON_CL


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3GjkEpa.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the
use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software in a
product, an acknowledgment in the product documentation would be appreciated
but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
GJK-EPA collision solver by Nathanael Presson, 2008
*/
// #ifndef B3_GJK_EPA2_H
// #define B3_GJK_EPA2_H

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Transform.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h"
// Targeting ..\Bullet3OpenCL\b3GjkEpaSolver2.java



// #endif  //B3_GJK_EPA2_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3OptimizedBvh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**Contains contributions from Disney Studio's */

// #ifndef B3_OPTIMIZED_BVH_H
// #define B3_OPTIMIZED_BVH_H

// #include "b3QuantizedBvh.h"
// Targeting ..\Bullet3OpenCL\b3OptimizedBvh.java



// #endif  //B3_OPTIMIZED_BVH_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3QuantizedBvh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_QUANTIZED_BVH_H
// #define B3_QUANTIZED_BVH_H
// Targeting ..\Bullet3OpenCL\b3Serializer.java



//#define DEBUG_CHECK_DEQUANTIZATION 1
// #ifdef DEBUG_CHECK_DEQUANTIZATION
// #endif  //DEBUG_CHECK_DEQUANTIZATION

// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Common/b3AlignedAllocator.h"

// #ifdef B3_USE_DOUBLE_PRECISION
// #else
// #define b3QuantizedBvhData b3QuantizedBvhFloatData
// #define b3OptimizedBvhNodeData b3OptimizedBvhNodeFloatData
public static final String b3QuantizedBvhDataName = "b3QuantizedBvhFloatData";
// #endif

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3QuantizedBvhNodeData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3BvhSubtreeInfoData.h"

//http://msdn.microsoft.com/library/default.asp?url=/library/en-us/vclang/html/vclrf__m128.asp

//Note: currently we have 16 bytes per quantized node
public static final int MAX_SUBTREE_SIZE_IN_BYTES = 2048;

// 10 gives the potential for 1024 parts, with at most 2^21 (2097152) (minus one
// actually) triangles each (since the sign bit is reserved
public static final int MAX_NUM_PARTS_IN_BITS = 10;
// Targeting ..\Bullet3OpenCL\b3QuantizedBvhNode.java


// Targeting ..\Bullet3OpenCL\b3OptimizedBvhNode.java


// Targeting ..\Bullet3OpenCL\b3BvhSubtreeInfo.java


// Targeting ..\Bullet3OpenCL\b3NodeOverlapCallback.java



// #include "Bullet3Common/b3AlignedAllocator.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"

/**for code readability: */
// Targeting ..\Bullet3OpenCL\b3QuantizedBvh.java


// Targeting ..\Bullet3OpenCL\b3OptimizedBvhNodeFloatData.java


// Targeting ..\Bullet3OpenCL\b3OptimizedBvhNodeDoubleData.java


// Targeting ..\Bullet3OpenCL\b3QuantizedBvhFloatData.java


// Targeting ..\Bullet3OpenCL\b3QuantizedBvhDoubleData.java





// #endif  //B3_QUANTIZED_BVH_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3StridingMeshInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_STRIDING_MESHINTERFACE_H
// #define B3_STRIDING_MESHINTERFACE_H

// #include "Bullet3Common/b3Vector3.h"
// #include "b3TriangleCallback.h"
//#include "b3ConcaveShape.h"

/** enum PHY_ScalarType */
public static final int
	PHY_FLOAT = 0,
	PHY_DOUBLE = 1,
	PHY_INTEGER = 2,
	PHY_SHORT = 3,
	PHY_FIXEDPOINT88 = 4,
	PHY_UCHAR = 5;
// Targeting ..\Bullet3OpenCL\b3StridingMeshInterface.java


// Targeting ..\Bullet3OpenCL\b3IntIndexData.java


// Targeting ..\Bullet3OpenCL\b3ShortIntIndexData.java


// Targeting ..\Bullet3OpenCL\b3ShortIntIndexTripletData.java


// Targeting ..\Bullet3OpenCL\b3CharIndexTripletData.java


// Targeting ..\Bullet3OpenCL\b3MeshPartData.java


// Targeting ..\Bullet3OpenCL\b3StridingMeshInterfaceData.java





// #endif  //B3_STRIDING_MESHINTERFACE_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3VectorFloat4.h

// #ifndef B3_VECTOR_FLOAT4_H
// #define B3_VECTOR_FLOAT4_H

// #include "Bullet3Common/b3Transform.h"

//#define cross3(a,b) (a.cross(b))
// #define float4 b3Vector3
//#define make_float4(x,y,z,w) b3Vector4(x,y,z,w)

// #endif  //B3_VECTOR_FLOAT4_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3SupportMappings.h


// #ifndef B3_SUPPORT_MAPPINGS_H
// #define B3_SUPPORT_MAPPINGS_H

// #include "Bullet3Common/b3Transform.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "b3VectorFloat4.h"
// Targeting ..\Bullet3OpenCL\b3GjkPairDetector.java



public static native @ByVal b3Vector3 localGetSupportVertexWithMargin(@Const @ByRef b3Vector3 supportVec, @Const b3ConvexPolyhedronData hull,
												 @Const @ByRef b3Vector3Array verticesA, @Cast("b3Scalar") float margin);

public static native @ByVal b3Vector3 localGetSupportVertexWithoutMargin(@Const @ByRef b3Vector3 supportVec, @Const b3ConvexPolyhedronData hull,
													@Const @ByRef b3Vector3Array verticesA);

// #endif  //B3_SUPPORT_MAPPINGS_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3TriangleCallback.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_TRIANGLE_CALLBACK_H
// #define B3_TRIANGLE_CALLBACK_H

// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3OpenCL\b3TriangleCallback.java


// Targeting ..\Bullet3OpenCL\b3InternalTriangleIndexCallback.java



// #endif  //B3_TRIANGLE_CALLBACK_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3TriangleIndexVertexArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_TRIANGLE_INDEX_VERTEX_ARRAY_H
// #define B3_TRIANGLE_INDEX_VERTEX_ARRAY_H

// #include "b3StridingMeshInterface.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Scalar.h"
// Targeting ..\Bullet3OpenCL\b3IndexedMesh.java


// Targeting ..\Bullet3OpenCL\b3TriangleIndexVertexArray.java



// #endif  //B3_TRIANGLE_INDEX_VERTEX_ARRAY_H


// Parsed from Bullet3OpenCL/NarrowphaseCollision/b3VoronoiSimplexSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_VORONOI_SIMPLEX_SOLVER_H
// #define B3_VORONOI_SIMPLEX_SOLVER_H

// #include "Bullet3Common/b3Vector3.h"

public static final int VORONOI_SIMPLEX_MAX_VERTS = 5;

/**disable next define, or use defaultCollisionConfiguration->getSimplexSolver()->setEqualVertexThreshold(0.f) to disable/configure */
//#define BT_USE_EQUAL_VERTEX_THRESHOLD
public static final double VORONOI_DEFAULT_EQUAL_VERTEX_THRESHOLD = 0.0001f;
// Targeting ..\Bullet3OpenCL\b3UsageBitfield.java


// Targeting ..\Bullet3OpenCL\b3SubSimplexClosestResult.java


// Targeting ..\Bullet3OpenCL\b3VoronoiSimplexSolver.java



// #endif  //B3_VORONOI_SIMPLEX_SOLVER_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuConstraint4.h


// #ifndef B3_CONSTRAINT4_h
// #define B3_CONSTRAINT4_h
// #include "Bullet3Common/b3Vector3.h"

// #include "Bullet3Dynamics/shared/b3ContactConstraint4.h"
// Targeting ..\Bullet3OpenCL\b3GpuConstraint4.java



// #endif  //B3_CONSTRAINT4_h


// Parsed from Bullet3OpenCL/RigidBody/b3GpuGenericConstraint.h

/*
Copyright (c) 2013 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef B3_GPU_GENERIC_CONSTRAINT_H
// #define B3_GPU_GENERIC_CONSTRAINT_H

// #include "Bullet3Common/b3Quaternion.h"
/** enum B3_CONSTRAINT_FLAGS */
public static final int
	B3_CONSTRAINT_FLAG_ENABLED = 1;

/** enum b3GpuGenericConstraintType */
public static final int
	B3_GPU_POINT2POINT_CONSTRAINT_TYPE = 3,
	B3_GPU_FIXED_CONSTRAINT_TYPE = 4,
	//	B3_HINGE_CONSTRAINT_TYPE,
	//	B3_CONETWIST_CONSTRAINT_TYPE,
	//	B3_D6_CONSTRAINT_TYPE,
	//	B3_SLIDER_CONSTRAINT_TYPE,
	//	B3_CONTACT_CONSTRAINT_TYPE,
	//	B3_D6_SPRING_CONSTRAINT_TYPE,
	//	B3_GEAR_CONSTRAINT_TYPE,

	B3_GPU_MAX_CONSTRAINT_TYPE = 5;
// Targeting ..\Bullet3OpenCL\b3GpuConstraintInfo2.java


// Targeting ..\Bullet3OpenCL\b3GpuGenericConstraint.java



// #endif  //B3_GPU_GENERIC_CONSTRAINT_H

// Parsed from Bullet3OpenCL/RigidBody/b3GpuJacobiContactSolver.h


// #ifndef B3_GPU_JACOBI_CONTACT_SOLVER_H
// #define B3_GPU_JACOBI_CONTACT_SOLVER_H
// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
//#include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Contact4Data.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// Targeting ..\Bullet3OpenCL\b3JacobiSolverInfo.java


// Targeting ..\Bullet3OpenCL\b3GpuJacobiContactSolver.java


// #endif  //B3_GPU_JACOBI_CONTACT_SOLVER_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuNarrowPhase.h

// #ifndef B3_GPU_NARROWPHASE_H
// #define B3_GPU_NARROWPHASE_H

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"
// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Vector3.h"
// Targeting ..\Bullet3OpenCL\b3GpuNarrowPhase.java



// #endif  //B3_GPU_NARROWPHASE_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuNarrowPhaseInternalData.h


// #ifndef B3_GPU_NARROWPHASE_INTERNAL_DATA_H
// #define B3_GPU_NARROWPHASE_INTERNAL_DATA_H

// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3ConvexPolyhedronData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Config.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Common/b3Vector3.h"

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Contact4.h"
// #include "Bullet3OpenCL/BroadphaseCollision/b3SapAabb.h"

// #include "Bullet3OpenCL/NarrowphaseCollision/b3QuantizedBvh.h"
// #include "Bullet3OpenCL/NarrowphaseCollision/b3BvhInfo.h"
// #include "Bullet3Common/shared/b3Int4.h"
// #include "Bullet3Common/shared/b3Int2.h"
// Targeting ..\Bullet3OpenCL\b3GpuNarrowPhaseInternalData.java



// #endif  //B3_GPU_NARROWPHASE_INTERNAL_DATA_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuPgsConstraintSolver.h

/*
Copyright (c) 2013 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef B3_GPU_PGS_CONSTRAINT_SOLVER_H
// #define B3_GPU_PGS_CONSTRAINT_SOLVER_H
// Targeting ..\Bullet3OpenCL\b3ContactPoint.java


// Targeting ..\Bullet3OpenCL\b3Dispatcher.java



// #include "Bullet3Dynamics/ConstraintSolver/b3TypedConstraint.h"
// #include "Bullet3Dynamics/ConstraintSolver/b3ContactSolverInfo.h"
// #include "b3GpuSolverBody.h"
// #include "b3GpuSolverConstraint.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "b3GpuGenericConstraint.h"
// Targeting ..\Bullet3OpenCL\b3GpuPgsConstraintSolver.java



// #endif  //B3_GPU_PGS_CONSTRAINT_SOLVER_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuPgsContactSolver.h


// #ifndef B3_GPU_BATCHING_PGS_SOLVER_H
// #define B3_GPU_BATCHING_PGS_SOLVER_H

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Contact4.h"
// #include "b3GpuConstraint4.h"
// Targeting ..\Bullet3OpenCL\b3GpuPgsContactSolver.java



// #endif  //B3_GPU_BATCHING_PGS_SOLVER_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuRigidBodyPipeline.h

/*
Copyright (c) 2013 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef B3_GPU_RIGIDBODY_PIPELINE_H
// #define B3_GPU_RIGIDBODY_PIPELINE_H

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Config.h"

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3RaycastInfo.h"
// Targeting ..\Bullet3OpenCL\b3GpuRigidBodyPipeline.java



// #endif  //B3_GPU_RIGIDBODY_PIPELINE_H

// Parsed from Bullet3OpenCL/Raycast/b3GpuRaycast.h

// #ifndef B3_GPU_RAYCAST_H
// #define B3_GPU_RAYCAST_H

// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"

// #include "Bullet3Common/b3AlignedObjectArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3RaycastInfo.h"
// Targeting ..\Bullet3OpenCL\b3GpuRaycast.java



// #endif  //B3_GPU_RAYCAST_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuRigidBodyPipelineInternalData.h

/*
Copyright (c) 2013 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef B3_GPU_RIGIDBODY_PIPELINE_INTERNAL_DATA_H
// #define B3_GPU_RIGIDBODY_PIPELINE_INTERNAL_DATA_H

// #include "Bullet3OpenCL/Initialize/b3OpenCLInclude.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"

// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3Collidable.h"

// #include "Bullet3OpenCL/BroadphaseCollision/b3SapAabb.h"
// #include "Bullet3Dynamics/ConstraintSolver/b3TypedConstraint.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Config.h"

// #include "Bullet3Collision/BroadPhaseCollision/b3OverlappingPair.h"
// #include "Bullet3OpenCL/RigidBody/b3GpuGenericConstraint.h"
// Targeting ..\Bullet3OpenCL\b3GpuRigidBodyPipelineInternalData.java



// #endif  //B3_GPU_RIGIDBODY_PIPELINE_INTERNAL_DATA_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuSolverBody.h

/*
Copyright (c) 2013 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Erwin Coumans

// #ifndef B3_GPU_SOLVER_BODY_H
// #define B3_GPU_SOLVER_BODY_H

// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Common/b3Matrix3x3.h"

// #include "Bullet3Common/b3AlignedAllocator.h"
// #include "Bullet3Common/b3TransformUtil.h"
// Targeting ..\Bullet3OpenCL\b3GpuSolverBody.java



// #endif  //B3_SOLVER_BODY_H


// Parsed from Bullet3OpenCL/RigidBody/b3GpuSolverConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans http://github.com/erwincoumans/bullet3

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B3_GPU_SOLVER_CONSTRAINT_H
// #define B3_GPU_SOLVER_CONSTRAINT_H

// #include "Bullet3Common/b3Vector3.h"
// #include "Bullet3Common/b3Matrix3x3.h"
//#include "b3JacobianEntry.h"
// #include "Bullet3Common/b3AlignedObjectArray.h"
// Targeting ..\Bullet3OpenCL\b3GpuSolverConstraint.java



// #endif  //B3_GPU_SOLVER_CONSTRAINT_H


// Parsed from Bullet3OpenCL/RigidBody/b3Solver.h

/*
Copyright (c) 2012 Advanced Micro Devices, Inc.  

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
//Originally written by Takahiro Harada

// #ifndef __ADL_SOLVER_H
// #define __ADL_SOLVER_H

// #include "Bullet3OpenCL/ParallelPrimitives/b3OpenCLArray.h"
// #include "b3GpuConstraint4.h"

// #include "Bullet3Collision/NarrowPhaseCollision/shared/b3RigidBodyData.h"
// #include "Bullet3Collision/NarrowPhaseCollision/b3Contact4.h"

// #include "Bullet3OpenCL/ParallelPrimitives/b3PrefixScanCL.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3RadixSort32CL.h"
// #include "Bullet3OpenCL/ParallelPrimitives/b3BoundSearchCL.h"

// #include "Bullet3OpenCL/Initialize/b3OpenCLUtils.h"

// #define B3NEXTMULTIPLEOF(num, alignment) (((num) / (alignment) + (((num) % (alignment) == 0) ? 0 : 1)) * (alignment))

/** enum  */
public static final int
	B3_SOLVER_N_SPLIT_X = 8,  //16,//4,
	B3_SOLVER_N_SPLIT_Y = 4,  //16,//4,
	B3_SOLVER_N_SPLIT_Z = 8,  //,
	B3_SOLVER_N_CELLS = B3_SOLVER_N_SPLIT_X * B3_SOLVER_N_SPLIT_Y * B3_SOLVER_N_SPLIT_Z,
	B3_SOLVER_N_BATCHES = 8,  //4,//8,//4,
	B3_MAX_NUM_BATCHES = 128;
// Targeting ..\Bullet3OpenCL\b3SolverBase.java


// Targeting ..\Bullet3OpenCL\b3Solver.java



// #endif  //__ADL_SOLVER_H


}
