// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Common;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.Bullet3Common.*;


/**\brief b3Vector3 can be used to represent 3D points and vectors.
 * It has an un-used w component to suit 16-byte alignment when b3Vector3 is stored in containers. This extra component can be used by derived classes (Quaternion?) or by user
 * Ideally, this class should be replaced by a platform optimized SIMD version that keeps the data in registers
 */
@Properties(inherit = org.bytedeco.bullet.presets.Bullet3Common.class)
public class b3Vector3 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public b3Vector3() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3Vector3(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3Vector3(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public b3Vector3 position(long position) {
        return (b3Vector3)super.position(position);
    }
    @Override public b3Vector3 getPointer(long i) {
        return new b3Vector3((Pointer)this).offsetAddress(i);
    }

// #if defined(B3_USE_SSE) || defined(B3_USE_NEON)  // _WIN32 || ARM
// #else
		public native float m_floats(int i); public native b3Vector3 m_floats(int i, float setter);
		@MemberGetter public native FloatPointer m_floats();
			public native float x(); public native b3Vector3 x(float setter);
			public native float y(); public native b3Vector3 y(float setter);
			public native float z(); public native b3Vector3 z(float setter);
			public native float w(); public native b3Vector3 w(float setter);
	/**\brief Add a vector to this one
 * @param The vector to add to this one */
	public native @ByRef @Name("operator +=") b3Vector3 addPut(@Const @ByRef b3Vector3 v);

	/**\brief Subtract a vector from this one
   * @param The vector to subtract */
	public native @ByRef @Name("operator -=") b3Vector3 subtractPut(@Const @ByRef b3Vector3 v);

	/**\brief Scale the vector
   * @param s Scale factor */
	public native @ByRef @Name("operator *=") b3Vector3 multiplyPut(@Cast("const b3Scalar") float s);

	/**\brief Inversely scale the vector
   * @param s Scale factor to divide by */
	public native @ByRef @Name("operator /=") b3Vector3 dividePut(@Cast("const b3Scalar") float s);

	/**\brief Return the dot product
   * @param v The other vector in the dot product */
	public native @Cast("b3Scalar") float dot(@Const @ByRef b3Vector3 v);

	/**\brief Return the length of the vector squared */
	public native @Cast("b3Scalar") float length2();

	/**\brief Return the length of the vector */
	public native @Cast("b3Scalar") float length();

	/**\brief Return the distance squared between the ends of this and another vector
   * This is symantically treating the vector like a point */
	public native @Cast("b3Scalar") float distance2(@Const @ByRef b3Vector3 v);

	/**\brief Return the distance between the ends of this and another vector
   * This is symantically treating the vector like a point */
	public native @Cast("b3Scalar") float distance(@Const @ByRef b3Vector3 v);

	public native @ByRef b3Vector3 safeNormalize();

	/**\brief Normalize this vector
   * x^2 + y^2 + z^2 = 1 */
	public native @ByRef b3Vector3 normalize();

	/**\brief Return a normalized version of this vector */
	public native @ByVal b3Vector3 normalized();

	/**\brief Return a rotated version of this vector
   * @param wAxis The axis to rotate about
   * @param angle The angle to rotate by */
	public native @ByVal b3Vector3 rotate(@Const @ByRef b3Vector3 wAxis, @Cast("const b3Scalar") float angle);

	/**\brief Return the angle between this and another vector
   * @param v The other vector */
	public native @Cast("b3Scalar") float angle(@Const @ByRef b3Vector3 v);

	/**\brief Return a vector will the absolute values of each element */
	public native @ByVal b3Vector3 absolute();

	/**\brief Return the cross product between this and another vector
   * @param v The other vector */
	public native @ByVal b3Vector3 cross(@Const @ByRef b3Vector3 v);

	public native @Cast("b3Scalar") float triple(@Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);

	/**\brief Return the axis with the smallest value
   * Note return values are 0,1,2 for x, y, or z */
	public native int minAxis();

	/**\brief Return the axis with the largest value
   * Note return values are 0,1,2 for x, y, or z */
	public native int maxAxis();

	public native int furthestAxis();

	public native int closestAxis();

	public native void setInterpolate3(@Const @ByRef b3Vector3 v0, @Const @ByRef b3Vector3 v1, @Cast("b3Scalar") float rt);

	/**\brief Return the linear interpolation between this and another vector
   * @param v The other vector
   * @param t The ration of this to v (t = 0 => return this, t=1 => return other) */
	public native @ByVal b3Vector3 lerp(@Const @ByRef b3Vector3 v, @Cast("const b3Scalar") float t);

	/**\brief Elementwise multiply this vector by the other
   * @param v The other vector */
	public native @ByRef @Name("operator *=") b3Vector3 multiplyPut(@Const @ByRef b3Vector3 v);

	/**\brief Return the x value */
	public native @Cast("const b3Scalar") float getX();
	/**\brief Return the y value */
	public native @Cast("const b3Scalar") float getY();
	/**\brief Return the z value */
	public native @Cast("const b3Scalar") float getZ();
	/**\brief Return the w value */
	public native @Cast("const b3Scalar") float getW();

	/**\brief Set the x value */
	public native void setX(@Cast("b3Scalar") float _x);
	/**\brief Set the y value */
	public native void setY(@Cast("b3Scalar") float _y);
	/**\brief Set the z value */
	public native void setZ(@Cast("b3Scalar") float _z);
	/**\brief Set the w value */
	public native void setW(@Cast("b3Scalar") float _w);

	//B3_FORCE_INLINE b3Scalar&       operator[](int i)       { return (&m_floats[0])[i];	}
	//B3_FORCE_INLINE const b3Scalar& operator[](int i) const { return (&m_floats[0])[i]; }
	/**operator b3Scalar*() replaces operator[], using implicit conversion. We added operator != and operator == to avoid pointer comparisons. */
	public native @Cast("b3Scalar*") @Name("operator b3Scalar*") FloatPointer asFloatPointer();

	public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b3Vector3 other);

	public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef b3Vector3 other);

	/**\brief Set each element to the max of the current values and the values of another b3Vector3
   * @param other The other b3Vector3 to compare with
   */
	public native void setMax(@Const @ByRef b3Vector3 other);

	/**\brief Set each element to the min of the current values and the values of another b3Vector3
   * @param other The other b3Vector3 to compare with
   */
	public native void setMin(@Const @ByRef b3Vector3 other);

	public native void setValue(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z);

	public native void getSkewSymmetricMatrix(b3Vector3 v0, b3Vector3 v1, b3Vector3 v2);

	public native void setZero();

	public native @Cast("bool") boolean isZero();

	public native @Cast("bool") boolean fuzzyZero();

	public native void serialize(@ByRef b3Vector3FloatData dataOut);

	public native void deSerialize(@Const @ByRef b3Vector3FloatData dataIn);

	public native void serializeFloat(@ByRef b3Vector3FloatData dataOut);

	public native void deSerializeFloat(@Const @ByRef b3Vector3FloatData dataIn);

	public native void serializeDouble(@ByRef b3Vector3DoubleData dataOut);

	public native void deSerializeDouble(@Const @ByRef b3Vector3DoubleData dataIn);

	/**\brief returns index of maximum dot product between this and vectors in array[]
         * @param array The other vectors
         * @param array_count The number of other vectors
         * @param dotOut The maximum dot product */
	public native long maxDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef FloatPointer dotOut);
	public native long maxDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef FloatBuffer dotOut);
	public native long maxDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef float[] dotOut);

	/**\brief returns index of minimum dot product between this and vectors in array[]
         * @param array The other vectors
         * @param array_count The number of other vectors
         * @param dotOut The minimum dot product */
	public native long minDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef FloatPointer dotOut);
	public native long minDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef FloatBuffer dotOut);
	public native long minDot(@Const b3Vector3 array, long array_count, @Cast("b3Scalar*") @ByRef float[] dotOut);

	/* create a vector as  b3Vector3( this->dot( b3Vector3 v0 ), this->dot( b3Vector3 v1), this->dot( b3Vector3 v2 ))  */
	public native @ByVal b3Vector3 dot3(@Const @ByRef b3Vector3 v0, @Const @ByRef b3Vector3 v1, @Const @ByRef b3Vector3 v2);
}
