// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btBroadphaseInterface class provides an interface to detect aabb-overlapping object pairs.
 * Some implementations for this broadphase interface include btAxisSweep3, bt32BitAxisSweep3 and btDbvtBroadphase.
 * The actual overlapping pair management, storage, adding and removing of pairs is dealt by the btOverlappingPairCache class. */
@Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btBroadphaseInterface extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btBroadphaseInterface(Pointer p) { super(p); }


	public native btBroadphaseProxy createProxy(@Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, int shapeType, Pointer userPtr, int collisionFilterGroup, int collisionFilterMask, btDispatcher dispatcher);
	public native void destroyProxy(btBroadphaseProxy proxy, btDispatcher dispatcher);
	public native void setAabb(btBroadphaseProxy proxy, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, btDispatcher dispatcher);
	public native void getAabb(btBroadphaseProxy proxy, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	public native void rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @ByRef btBroadphaseRayCallback rayCallback, @Const @ByRef(nullValue = "btVector3(0, 0, 0)") btVector3 aabbMin, @Const @ByRef(nullValue = "btVector3(0, 0, 0)") btVector3 aabbMax);
	public native void rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @ByRef btBroadphaseRayCallback rayCallback);

	public native void aabbTest(@Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, @ByRef btBroadphaseAabbCallback callback);

	/**calculateOverlappingPairs is optional: incremental algorithms (sweep and prune) might do it during the set aabb */
	public native void calculateOverlappingPairs(btDispatcher dispatcher);

	public native btOverlappingPairCache getOverlappingPairCache();

	/**getAabb returns the axis aligned bounding box in the 'global' coordinate frame
	 * will add some transform later */
	public native void getBroadphaseAabb(@ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	/**reset broadphase internal structures, to ensure determinism/reproducability */
	public native void resetPool(btDispatcher dispatcher);

	public native void printStats();
}
