// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btQuantizedBvh class stores an AABB tree that can be quickly traversed on CPU and Cell SPU.
 * It is used by the btBvhTriangleMeshShape as midphase.
 * It is recommended to use quantization for better performance and lower memory requirements. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btQuantizedBvh extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btQuantizedBvh(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btQuantizedBvh(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btQuantizedBvh position(long position) {
        return (btQuantizedBvh)super.position(position);
    }
    @Override public btQuantizedBvh getPointer(long i) {
        return new btQuantizedBvh((Pointer)this).offsetAddress(i);
    }

	/** enum btQuantizedBvh::btTraversalMode */
	public static final int
		TRAVERSAL_STACKLESS = 0,
		TRAVERSAL_STACKLESS_CACHE_FRIENDLY = 1,
		TRAVERSAL_RECURSIVE = 2;

	public btQuantizedBvh() { super((Pointer)null); allocate(); }
	private native void allocate();

	///***************************************** expert/internal use only *************************
	public native void setQuantizationValues(@Const @ByRef btVector3 bvhAabbMin, @Const @ByRef btVector3 bvhAabbMax, @Cast("btScalar") double quantizationMargin/*=btScalar(1.0)*/);
	public native void setQuantizationValues(@Const @ByRef btVector3 bvhAabbMin, @Const @ByRef btVector3 bvhAabbMax);
	public native @Cast("QuantizedNodeArray*") @ByRef btQuantizedBvhNodeArray getLeafNodeArray();
	/**buildInternal is expert use only: assumes that setQuantizationValues and LeafNodeArray are initialized */
	public native void buildInternal();
	///***************************************** expert/internal use only *************************

	public native void reportAabbOverlappingNodex(btNodeOverlapCallback nodeCallback, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax);
	public native void reportRayOverlappingNodex(btNodeOverlapCallback nodeCallback, @Const @ByRef btVector3 raySource, @Const @ByRef btVector3 rayTarget);
	public native void reportBoxCastOverlappingNodex(btNodeOverlapCallback nodeCallback, @Const @ByRef btVector3 raySource, @Const @ByRef btVector3 rayTarget, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax);

	public native void quantize(@Cast("unsigned short*") ShortPointer out, @Const @ByRef btVector3 point, int isMax);
	public native void quantize(@Cast("unsigned short*") ShortBuffer out, @Const @ByRef btVector3 point, int isMax);
	public native void quantize(@Cast("unsigned short*") short[] out, @Const @ByRef btVector3 point, int isMax);

	public native void quantizeWithClamp(@Cast("unsigned short*") ShortPointer out, @Const @ByRef btVector3 point2, int isMax);
	public native void quantizeWithClamp(@Cast("unsigned short*") ShortBuffer out, @Const @ByRef btVector3 point2, int isMax);
	public native void quantizeWithClamp(@Cast("unsigned short*") short[] out, @Const @ByRef btVector3 point2, int isMax);

	public native @ByVal btVector3 unQuantize(@Cast("const unsigned short*") ShortPointer vecIn);
	public native @ByVal btVector3 unQuantize(@Cast("const unsigned short*") ShortBuffer vecIn);
	public native @ByVal btVector3 unQuantize(@Cast("const unsigned short*") short[] vecIn);

	/**setTraversalMode let's you choose between stackless, recursive or stackless cache friendly tree traversal. Note this is only implemented for quantized trees. */
	public native void setTraversalMode(@Cast("btQuantizedBvh::btTraversalMode") int traversalMode);

	public native @Cast("QuantizedNodeArray*") @ByRef btQuantizedBvhNodeArray getQuantizedNodeArray();

	public native @Cast("BvhSubtreeInfoArray*") @ByRef btBvhSubtreeInfoArray getSubtreeInfoArray();

	////////////////////////////////////////////////////////////////////

	/////Calculate space needed to store BVH for serialization
	public native @Cast("unsigned") int calculateSerializeBufferSize();

	/** Data buffer MUST be 16 byte aligned */
	public native @Cast("bool") boolean serialize(Pointer o_alignedDataBuffer, @Cast("unsigned") int i_dataBufferSize, @Cast("bool") boolean i_swapEndian);

	/**deSerializeInPlace loads and initializes a BVH from a buffer in memory 'in place' */
	public static native btQuantizedBvh deSerializeInPlace(Pointer i_alignedDataBuffer, @Cast("unsigned int") int i_dataBufferSize, @Cast("bool") boolean i_swapEndian);

	public static native @Cast("unsigned int") int getAlignmentSerializationPadding();
	//////////////////////////////////////////////////////////////////////

	public native int calculateSerializeBufferSizeNew();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);

	public native void deSerializeFloat(@ByRef btQuantizedBvhFloatData quantizedBvhFloatData);

	public native void deSerializeDouble(@ByRef btQuantizedBvhDoubleData quantizedBvhDoubleData);

	////////////////////////////////////////////////////////////////////

	public native @Cast("bool") boolean isQuantized();
}
