// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletSoftBody;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;
import org.bytedeco.bullet.BulletDynamics.*;
import static org.bytedeco.bullet.global.BulletDynamics.*;

import static org.bytedeco.bullet.global.BulletSoftBody.*;


/**The btSoftBody is an class to simulate cloth and volumetric soft bodies.
 * There is two-way interaction between btSoftBody and btRigidBody/btCollisionObject. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletSoftBody.class)
public class btSoftBody extends btCollisionObject {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btSoftBody(Pointer p) { super(p); }

	

	// The solver object that handles this soft body
	public native btSoftBodySolver m_softBodySolver(); public native btSoftBody m_softBodySolver(btSoftBodySolver setter);

	//
	// Enumerations
	//

	/**eAeroModel */
	public static class eAeroModel extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public eAeroModel() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public eAeroModel(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public eAeroModel(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public eAeroModel position(long position) {
	        return (eAeroModel)super.position(position);
	    }
	    @Override public eAeroModel getPointer(long i) {
	        return new eAeroModel((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::eAeroModel::_ */
		public static final int
			V_Point = 0,             /**Vertex normals are oriented toward velocity */
			V_TwoSided = 1,          /**Vertex normals are flipped to match velocity */
			V_TwoSidedLiftDrag = 2,  /**Vertex normals are flipped to match velocity and lift and drag forces are applied */
			V_OneSided = 3,          /**Vertex normals are taken as it is */
			F_TwoSided = 4,          /**Face normals are flipped to match velocity */
			F_TwoSidedLiftDrag = 5,  /**Face normals are flipped to match velocity and lift and drag forces are applied */
			F_OneSided = 6,          /**Face normals are taken as it is */
			END = 7;
	}

	/**eVSolver : velocities solvers */
	public static class eVSolver extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public eVSolver() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public eVSolver(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public eVSolver(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public eVSolver position(long position) {
	        return (eVSolver)super.position(position);
	    }
	    @Override public eVSolver getPointer(long i) {
	        return new eVSolver((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::eVSolver::_ */
		public static final int
			Linear = 0,  /**Linear solver */
			END = 1;
	}

	/**ePSolver : positions solvers */
	public static class ePSolver extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public ePSolver() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public ePSolver(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public ePSolver(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public ePSolver position(long position) {
	        return (ePSolver)super.position(position);
	    }
	    @Override public ePSolver getPointer(long i) {
	        return new ePSolver((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::ePSolver::_ */
		public static final int
			Linear = 0,     /**Linear solver */
			Anchors = 1,    /**Anchor solver */
			RContacts = 2,  /**Rigid contacts solver */
			SContacts = 3,  /**Soft contacts solver */
			END = 4;
	}

	/**eSolverPresets */
	public static class eSolverPresets extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public eSolverPresets() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public eSolverPresets(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public eSolverPresets(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public eSolverPresets position(long position) {
	        return (eSolverPresets)super.position(position);
	    }
	    @Override public eSolverPresets getPointer(long i) {
	        return new eSolverPresets((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::eSolverPresets::_ */
		public static final int
			Positions = 0,
			Velocities = 1,
			Default = Positions,
			END = Positions + 1;
	}

	/**eFeature */
	public static class eFeature extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public eFeature() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public eFeature(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public eFeature(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public eFeature position(long position) {
	        return (eFeature)super.position(position);
	    }
	    @Override public eFeature getPointer(long i) {
	        return new eFeature((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::eFeature::_ */
		public static final int
			None = 0,
			Node = 1,
			Link = 2,
			Face = 3,
			Tetra = 4,
			END = 5;
	}

	//
	// Flags
	//

	/**fCollision */
	public static class fCollision extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fCollision() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fCollision(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fCollision(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fCollision position(long position) {
	        return (fCollision)super.position(position);
	    }
	    @Override public fCollision getPointer(long i) {
	        return new fCollision((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::fCollision::_ */
		public static final int
			RVSmask = 0x000f,  /**Rigid versus soft mask */
			SDF_RS = 0x0001,   /**SDF based rigid vs soft */
			CL_RS = 0x0002,    /**Cluster vs convex rigid vs soft */
			SDF_RD = 0x0004,   /**rigid vs deformable */

			SVSmask = 0x00f0,  /**Rigid versus soft mask */
			VF_SS = 0x0010,    /**Vertex vs face soft vs soft handling */
			CL_SS = 0x0020,    /**Cluster vs cluster soft vs soft handling */
			CL_SELF = 0x0040,  /**Cluster soft body self collision */
			VF_DD = 0x0080,    /**Vertex vs face soft vs soft handling */

			RVDFmask = 0x0f00,  /** Rigid versus deformable face mask */
			SDF_RDF = 0x0100,   /** GJK based Rigid vs. deformable face */
			SDF_MDF = 0x0200,   /** GJK based Multibody vs. deformable face */
			SDF_RDN = 0x0400,   /** SDF based Rigid vs. deformable node */
			/* presets	*/
			Default = SDF_RS,
			END = SDF_RS + 1;
	}

	/**fMaterial */
	public static class fMaterial extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fMaterial() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fMaterial(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fMaterial(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fMaterial position(long position) {
	        return (fMaterial)super.position(position);
	    }
	    @Override public fMaterial getPointer(long i) {
	        return new fMaterial((Pointer)this).offsetAddress(i);
	    }
	
		/** enum btSoftBody::fMaterial::_ */
		public static final int
			DebugDraw = 0x0001,  /** Enable debug draw */
			/* presets	*/
			Default = DebugDraw,
			END = DebugDraw + 1;
	}

	//
	// API Types
	//

	/* sRayCast		*/
	public static class sRayCast extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public sRayCast() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public sRayCast(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sRayCast(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public sRayCast position(long position) {
	        return (sRayCast)super.position(position);
	    }
	    @Override public sRayCast getPointer(long i) {
	        return new sRayCast((Pointer)this).offsetAddress(i);
	    }
	
		public native btSoftBody body(); public native sRayCast body(btSoftBody setter);     /** soft body */
		public native @Cast("btSoftBody::eFeature::_") int feature(); public native sRayCast feature(int setter);  /** feature type */
		public native int index(); public native sRayCast index(int setter);            /** feature index */
		public native @Cast("btScalar") double fraction(); public native sRayCast fraction(double setter);    /** time of impact fraction (rayorg+(rayto-rayfrom)*fraction) */
	}

	/* ImplicitFn	*/
	public static class ImplicitFn extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public ImplicitFn(Pointer p) { super(p); }
	
		public native @Cast("btScalar") double Eval(@Const @ByRef btVector3 x);
	}

	//
	// Internal types
	//

	/* sCti is Softbody contact info	*/
	public static class sCti extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public sCti() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public sCti(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sCti(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public sCti position(long position) {
	        return (sCti)super.position(position);
	    }
	    @Override public sCti getPointer(long i) {
	        return new sCti((Pointer)this).offsetAddress(i);
	    }
	
		public native @Const btCollisionObject m_colObj(); public native sCti m_colObj(btCollisionObject setter); /* Rigid body			*/
		public native @ByRef btVector3 m_normal(); public native sCti m_normal(btVector3 setter);                /* Outward normal		*/
		public native @Cast("btScalar") double m_offset(); public native sCti m_offset(double setter);                 /* Offset from origin	*/
		public native @ByRef btVector3 m_bary(); public native sCti m_bary(btVector3 setter);                  /* Barycentric weights for faces */
	}

	/* sMedium		*/
	public static class sMedium extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public sMedium() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public sMedium(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sMedium(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public sMedium position(long position) {
	        return (sMedium)super.position(position);
	    }
	    @Override public sMedium getPointer(long i) {
	        return new sMedium((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_velocity(); public native sMedium m_velocity(btVector3 setter); /* Velocity				*/
		public native @Cast("btScalar") double m_pressure(); public native sMedium m_pressure(double setter);  /* Pressure				*/
		public native @Cast("btScalar") double m_density(); public native sMedium m_density(double setter);   /* Density				*/
	}

	/* Base type	*/
	@NoOffset public static class Element extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Element(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Element(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public Element position(long position) {
	        return (Element)super.position(position);
	    }
	    @Override public Element getPointer(long i) {
	        return new Element((Pointer)this).offsetAddress(i);
	    }
	
		public native Pointer m_tag(); public native Element m_tag(Pointer setter);  // User data
		public Element() { super((Pointer)null); allocate(); }
		private native void allocate();
	}
	/* Material		*/
	@NoOffset public static class Material extends Element {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Material() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Material(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Material(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Material position(long position) {
	        return (Material)super.position(position);
	    }
	    @Override public Material getPointer(long i) {
	        return new Material((Pointer)this).offsetAddress(i);
	    }
	
		public native @Cast("btScalar") double m_kLST(); public native Material m_kLST(double setter);  // Linear stiffness coefficient [0,1]
		public native @Cast("btScalar") double m_kAST(); public native Material m_kAST(double setter);  // Area/Angular stiffness coefficient [0,1]
		public native @Cast("btScalar") double m_kVST(); public native Material m_kVST(double setter);  // Volume stiffness coefficient [0,1]
		public native int m_flags(); public native Material m_flags(int setter);      // Flags
	}

	/* Feature		*/
	@NoOffset public static class Feature extends Element {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Feature() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Feature(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Feature(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Feature position(long position) {
	        return (Feature)super.position(position);
	    }
	    @Override public Feature getPointer(long i) {
	        return new Feature((Pointer)this).offsetAddress(i);
	    }
	
		public native Material m_material(); public native Feature m_material(Material setter);  // Material
	}
	/* Node			*/
	public static class RenderNode extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public RenderNode() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public RenderNode(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public RenderNode(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public RenderNode position(long position) {
	        return (RenderNode)super.position(position);
	    }
	    @Override public RenderNode getPointer(long i) {
	        return new RenderNode((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_x(); public native RenderNode m_x(btVector3 setter);
		public native @ByRef btVector3 m_uv1(); public native RenderNode m_uv1(btVector3 setter);
		public native @ByRef btVector3 m_normal(); public native RenderNode m_normal(btVector3 setter);
	}
	@NoOffset public static class Node extends Feature {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Node() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Node(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Node(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Node position(long position) {
	        return (Node)super.position(position);
	    }
	    @Override public Node getPointer(long i) {
	        return new Node((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_x(); public native Node m_x(btVector3 setter);       // Position
		public native @ByRef btVector3 m_q(); public native Node m_q(btVector3 setter);       // Previous step position/Test position
		public native @ByRef btVector3 m_v(); public native Node m_v(btVector3 setter);       // Velocity
		public native @ByRef btVector3 m_vn(); public native Node m_vn(btVector3 setter);      // Previous step velocity
		public native @ByRef btVector3 m_f(); public native Node m_f(btVector3 setter);       // Force accumulator
		public native @ByRef btVector3 m_n(); public native Node m_n(btVector3 setter);       // Normal
		public native @Cast("btScalar") double m_im(); public native Node m_im(double setter);       // 1/mass
		public native @Cast("btScalar") double m_area(); public native Node m_area(double setter);     // Area
		public native btDbvtNode m_leaf(); public native Node m_leaf(btDbvtNode setter);  // Leaf data
		public native int m_constrained(); public native Node m_constrained(int setter);   // depth of penetration
		public native @NoOffset int m_battach(); public native Node m_battach(int setter);   // Attached
		public native int index(); public native Node index(int setter);
		public native @ByRef btVector3 m_splitv(); public native Node m_splitv(btVector3 setter);               // velocity associated with split impulse
		public native @ByRef btMatrix3x3 m_effectiveMass(); public native Node m_effectiveMass(btMatrix3x3 setter);      // effective mass in contact
		public native @ByRef btMatrix3x3 m_effectiveMass_inv(); public native Node m_effectiveMass_inv(btMatrix3x3 setter);  // inverse of effective mass
	}
	/* Link			*/
	@NoOffset public static class Link extends Feature {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Link() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Link(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Link(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Link position(long position) {
	        return (Link)super.position(position);
	    }
	    @Override public Link getPointer(long i) {
	        return new Link((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_c3(); public native Link m_c3(btVector3 setter);      // gradient
		public native Node m_n(int i); public native Link m_n(int i, Node setter);
		@MemberGetter public native @Cast("btSoftBody::Node**") PointerPointer m_n();        // Node pointers
		public native @Cast("btScalar") double m_rl(); public native Link m_rl(double setter);       // Rest length
		public native @NoOffset int m_bbending(); public native Link m_bbending(int setter);  // Bending link
		public native @Cast("btScalar") double m_c0(); public native Link m_c0(double setter);       // (ima+imb)*kLST
		public native @Cast("btScalar") double m_c1(); public native Link m_c1(double setter);       // rl^2
		public native @Cast("btScalar") double m_c2(); public native Link m_c2(double setter);       // |gradient|^2/c0
	}
	public static class RenderFace extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public RenderFace() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public RenderFace(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public RenderFace(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public RenderFace position(long position) {
	        return (RenderFace)super.position(position);
	    }
	    @Override public RenderFace getPointer(long i) {
	        return new RenderFace((Pointer)this).offsetAddress(i);
	    }
	
		public native RenderNode m_n(int i); public native RenderFace m_n(int i, RenderNode setter);
		@MemberGetter public native @Cast("btSoftBody::RenderNode**") PointerPointer m_n();  // Node pointers
	}

	/* Face			*/
	@NoOffset public static class Face extends Feature {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Face() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Face(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Face(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Face position(long position) {
	        return (Face)super.position(position);
	    }
	    @Override public Face getPointer(long i) {
	        return new Face((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_n(int i); public native Face m_n(int i, Node setter);
		@MemberGetter public native @Cast("btSoftBody::Node**") PointerPointer m_n();          // Node pointers
		public native @ByRef btVector3 m_normal(); public native Face m_normal(btVector3 setter);    // Normal
		public native @Cast("btScalar") double m_ra(); public native Face m_ra(double setter);         // Rest area
		public native btDbvtNode m_leaf(); public native Face m_leaf(btDbvtNode setter);    // Leaf data
		public native @ByRef btVector4 m_pcontact(); public native Face m_pcontact(btVector4 setter);  // barycentric weights of the persistent contact
		public native @ByRef btVector3 m_n0(); public native Face m_n0(btVector3 setter);
		public native @ByRef btVector3 m_n1(); public native Face m_n1(btVector3 setter);
		public native @ByRef btVector3 m_vn(); public native Face m_vn(btVector3 setter);
		public native int m_index(); public native Face m_index(int setter);
	}
	/* Tetra		*/
	@NoOffset public static class Tetra extends Feature {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Tetra() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Tetra(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Tetra(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Tetra position(long position) {
	        return (Tetra)super.position(position);
	    }
	    @Override public Tetra getPointer(long i) {
	        return new Tetra((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_n(int i); public native Tetra m_n(int i, Node setter);
		@MemberGetter public native @Cast("btSoftBody::Node**") PointerPointer m_n();              // Node pointers
		public native @Cast("btScalar") double m_rv(); public native Tetra m_rv(double setter);             // Rest volume
		public native btDbvtNode m_leaf(); public native Tetra m_leaf(btDbvtNode setter);        // Leaf data
		public native @ByRef btVector3 m_c0(int i); public native Tetra m_c0(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_c0();         // gradients
		public native @Cast("btScalar") double m_c1(); public native Tetra m_c1(double setter);             // (4*kVST)/(im0+im1+im2+im3)
		public native @Cast("btScalar") double m_c2(); public native Tetra m_c2(double setter);             // m_c1/sum(|g0..3|^2)
		public native @ByRef btMatrix3x3 m_Dm_inverse(); public native Tetra m_Dm_inverse(btMatrix3x3 setter);  // rest Dm^-1
		public native @ByRef btMatrix3x3 m_F(); public native Tetra m_F(btMatrix3x3 setter);
		public native @Cast("btScalar") double m_element_measure(); public native Tetra m_element_measure(double setter);
		public native @ByRef btVector4 m_P_inv(int i); public native Tetra m_P_inv(int i, btVector4 setter);
		@MemberGetter public native btVector4 m_P_inv();  // first three columns of P_inv matrix
	}

	/*  TetraScratch  */
	public static class TetraScratch extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public TetraScratch() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public TetraScratch(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public TetraScratch(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public TetraScratch position(long position) {
	        return (TetraScratch)super.position(position);
	    }
	    @Override public TetraScratch getPointer(long i) {
	        return new TetraScratch((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btMatrix3x3 m_F(); public native TetraScratch m_F(btMatrix3x3 setter);           // deformation gradient F
		public native @Cast("btScalar") double m_trace(); public native TetraScratch m_trace(double setter);          // trace of F^T * F
		public native @Cast("btScalar") double m_J(); public native TetraScratch m_J(double setter);              // det(F)
		public native @ByRef btMatrix3x3 m_cofF(); public native TetraScratch m_cofF(btMatrix3x3 setter);        // cofactor of F
		public native @ByRef btMatrix3x3 m_corotation(); public native TetraScratch m_corotation(btMatrix3x3 setter);  // corotatio of the tetra
	}

	/* RContact		*/
	public static class RContact extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public RContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public RContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public RContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public RContact position(long position) {
	        return (RContact)super.position(position);
	    }
	    @Override public RContact getPointer(long i) {
	        return new RContact((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef sCti m_cti(); public native RContact m_cti(sCti setter);        // Contact infos
		public native Node m_node(); public native RContact m_node(Node setter);      // Owner node
		public native @ByRef btMatrix3x3 m_c0(); public native RContact m_c0(btMatrix3x3 setter);  // Impulse matrix
		public native @ByRef btVector3 m_c1(); public native RContact m_c1(btVector3 setter);    // Relative anchor
		public native @Cast("btScalar") double m_c2(); public native RContact m_c2(double setter);     // ima*dt
		public native @Cast("btScalar") double m_c3(); public native RContact m_c3(double setter);     // Friction
		public native @Cast("btScalar") double m_c4(); public native RContact m_c4(double setter);     // Hardness

		// jacobians and unit impulse responses for multibody
		public native @ByRef btMultiBodyJacobianData jacobianData_normal(); public native RContact jacobianData_normal(btMultiBodyJacobianData setter);
		public native @ByRef btMultiBodyJacobianData jacobianData_t1(); public native RContact jacobianData_t1(btMultiBodyJacobianData setter);
		public native @ByRef btMultiBodyJacobianData jacobianData_t2(); public native RContact jacobianData_t2(btMultiBodyJacobianData setter);
		public native @ByRef btVector3 t1(); public native RContact t1(btVector3 setter);
		public native @ByRef btVector3 t2(); public native RContact t2(btVector3 setter);
	}

	public static class DeformableRigidContact extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public DeformableRigidContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public DeformableRigidContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public DeformableRigidContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public DeformableRigidContact position(long position) {
	        return (DeformableRigidContact)super.position(position);
	    }
	    @Override public DeformableRigidContact getPointer(long i) {
	        return new DeformableRigidContact((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef sCti m_cti(); public native DeformableRigidContact m_cti(sCti setter);        // Contact infos
		public native @ByRef btMatrix3x3 m_c0(); public native DeformableRigidContact m_c0(btMatrix3x3 setter);  // Impulse matrix
		public native @ByRef btVector3 m_c1(); public native DeformableRigidContact m_c1(btVector3 setter);    // Relative anchor
		public native @Cast("btScalar") double m_c2(); public native DeformableRigidContact m_c2(double setter);     // inverse mass of node/face
		public native @Cast("btScalar") double m_c3(); public native DeformableRigidContact m_c3(double setter);     // Friction
		public native @Cast("btScalar") double m_c4(); public native DeformableRigidContact m_c4(double setter);     // Hardness
		public native @ByRef btMatrix3x3 m_c5(); public native DeformableRigidContact m_c5(btMatrix3x3 setter);  // inverse effective mass

		// jacobians and unit impulse responses for multibody
		public native @ByRef btMultiBodyJacobianData jacobianData_normal(); public native DeformableRigidContact jacobianData_normal(btMultiBodyJacobianData setter);
		public native @ByRef btMultiBodyJacobianData jacobianData_t1(); public native DeformableRigidContact jacobianData_t1(btMultiBodyJacobianData setter);
		public native @ByRef btMultiBodyJacobianData jacobianData_t2(); public native DeformableRigidContact jacobianData_t2(btMultiBodyJacobianData setter);
		public native @ByRef btVector3 t1(); public native DeformableRigidContact t1(btVector3 setter);
		public native @ByRef btVector3 t2(); public native DeformableRigidContact t2(btVector3 setter);
	}

	@NoOffset public static class DeformableNodeRigidContact extends DeformableRigidContact {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public DeformableNodeRigidContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public DeformableNodeRigidContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public DeformableNodeRigidContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public DeformableNodeRigidContact position(long position) {
	        return (DeformableNodeRigidContact)super.position(position);
	    }
	    @Override public DeformableNodeRigidContact getPointer(long i) {
	        return new DeformableNodeRigidContact((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_node(); public native DeformableNodeRigidContact m_node(Node setter);  // Owner node
	}

	@NoOffset public static class DeformableNodeRigidAnchor extends DeformableNodeRigidContact {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public DeformableNodeRigidAnchor() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public DeformableNodeRigidAnchor(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public DeformableNodeRigidAnchor(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public DeformableNodeRigidAnchor position(long position) {
	        return (DeformableNodeRigidAnchor)super.position(position);
	    }
	    @Override public DeformableNodeRigidAnchor getPointer(long i) {
	        return new DeformableNodeRigidAnchor((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_local(); public native DeformableNodeRigidAnchor m_local(btVector3 setter);  // Anchor position in body space
	}

	@NoOffset public static class DeformableFaceRigidContact extends DeformableRigidContact {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public DeformableFaceRigidContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public DeformableFaceRigidContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public DeformableFaceRigidContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public DeformableFaceRigidContact position(long position) {
	        return (DeformableFaceRigidContact)super.position(position);
	    }
	    @Override public DeformableFaceRigidContact getPointer(long i) {
	        return new DeformableFaceRigidContact((Pointer)this).offsetAddress(i);
	    }
	
		public native Face m_face(); public native DeformableFaceRigidContact m_face(Face setter);              // Owner face
		public native @ByRef btVector3 m_contactPoint(); public native DeformableFaceRigidContact m_contactPoint(btVector3 setter);  // Contact point
		public native @ByRef btVector3 m_bary(); public native DeformableFaceRigidContact m_bary(btVector3 setter);          // Barycentric weights
		public native @ByRef btVector3 m_weights(); public native DeformableFaceRigidContact m_weights(btVector3 setter);       // v_contactPoint * m_weights[i] = m_face->m_node[i]->m_v;
	}

	public static class DeformableFaceNodeContact extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public DeformableFaceNodeContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public DeformableFaceNodeContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public DeformableFaceNodeContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public DeformableFaceNodeContact position(long position) {
	        return (DeformableFaceNodeContact)super.position(position);
	    }
	    @Override public DeformableFaceNodeContact getPointer(long i) {
	        return new DeformableFaceNodeContact((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_node(); public native DeformableFaceNodeContact m_node(Node setter);         // Node
		public native Face m_face(); public native DeformableFaceNodeContact m_face(Face setter);         // Face
		public native @ByRef btVector3 m_bary(); public native DeformableFaceNodeContact m_bary(btVector3 setter);     // Barycentric weights
		public native @ByRef btVector3 m_weights(); public native DeformableFaceNodeContact m_weights(btVector3 setter);  // v_contactPoint * m_weights[i] = m_face->m_node[i]->m_v;
		public native @ByRef btVector3 m_normal(); public native DeformableFaceNodeContact m_normal(btVector3 setter);   // Normal
		public native @Cast("btScalar") double m_margin(); public native DeformableFaceNodeContact m_margin(double setter);    // Margin
		public native @Cast("btScalar") double m_friction(); public native DeformableFaceNodeContact m_friction(double setter);  // Friction
		public native @Cast("btScalar") double m_imf(); public native DeformableFaceNodeContact m_imf(double setter);       // inverse mass of the face at contact point
		public native @Cast("btScalar") double m_c0(); public native DeformableFaceNodeContact m_c0(double setter);        // scale of the impulse matrix;
		public native @Const btCollisionObject m_colObj(); public native DeformableFaceNodeContact m_colObj(btCollisionObject setter);  // Collision object to collide with.
	}

	/* SContact		*/
	public static class SContact extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public SContact() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public SContact(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public SContact(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public SContact position(long position) {
	        return (SContact)super.position(position);
	    }
	    @Override public SContact getPointer(long i) {
	        return new SContact((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_node(); public native SContact m_node(Node setter);         // Node
		public native Face m_face(); public native SContact m_face(Face setter);         // Face
		public native @ByRef btVector3 m_weights(); public native SContact m_weights(btVector3 setter);  // Weigths
		public native @ByRef btVector3 m_normal(); public native SContact m_normal(btVector3 setter);   // Normal
		public native @Cast("btScalar") double m_margin(); public native SContact m_margin(double setter);    // Margin
		public native @Cast("btScalar") double m_friction(); public native SContact m_friction(double setter);  // Friction
		public native @Cast("btScalar") double m_cfm(int i); public native SContact m_cfm(int i, double setter);
		@MemberGetter public native @Cast("btScalar*") DoublePointer m_cfm();    // Constraint force mixing
	}
	/* Anchor		*/
	public static class Anchor extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Anchor() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Anchor(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Anchor(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Anchor position(long position) {
	        return (Anchor)super.position(position);
	    }
	    @Override public Anchor getPointer(long i) {
	        return new Anchor((Pointer)this).offsetAddress(i);
	    }
	
		public native Node m_node(); public native Anchor m_node(Node setter);         // Node pointer
		public native @ByRef btVector3 m_local(); public native Anchor m_local(btVector3 setter);    // Anchor position in body space
		public native btRigidBody m_body(); public native Anchor m_body(btRigidBody setter);  // Body
		public native @Cast("btScalar") double m_influence(); public native Anchor m_influence(double setter);
		public native @ByRef btMatrix3x3 m_c0(); public native Anchor m_c0(btMatrix3x3 setter);  // Impulse matrix
		public native @ByRef btVector3 m_c1(); public native Anchor m_c1(btVector3 setter);    // Relative anchor
		public native @Cast("btScalar") double m_c2(); public native Anchor m_c2(double setter);     // ima*dt
	}
	/* Note			*/
	@NoOffset public static class Note extends Element {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Note() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Note(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Note(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Note position(long position) {
	        return (Note)super.position(position);
	    }
	    @Override public Note getPointer(long i) {
	        return new Note((Pointer)this).offsetAddress(i);
	    }
	
		public native @Cast("const char*") BytePointer m_text(); public native Note m_text(BytePointer setter);    // Text
		public native @ByRef btVector3 m_offset(); public native Note m_offset(btVector3 setter);    // Offset
		public native int m_rank(); public native Note m_rank(int setter);            // Rank
		public native Node m_nodes(int i); public native Note m_nodes(int i, Node setter);
		@MemberGetter public native @Cast("btSoftBody::Node**") PointerPointer m_nodes();      // Nodes
		public native @Cast("btScalar") double m_coords(int i); public native Note m_coords(int i, double setter);
		@MemberGetter public native @Cast("btScalar*") DoublePointer m_coords();  // Coordinates
	}
	/* Pose			*/
	public static class Pose extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Pose() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Pose(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Pose(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Pose position(long position) {
	        return (Pose)super.position(position);
	    }
	    @Override public Pose getPointer(long i) {
	        return new Pose((Pointer)this).offsetAddress(i);
	    }
	
		public native @Cast("bool") boolean m_bvolume(); public native Pose m_bvolume(boolean setter);       // Is valid
		public native @Cast("bool") boolean m_bframe(); public native Pose m_bframe(boolean setter);        // Is frame
		public native @Cast("btScalar") double m_volume(); public native Pose m_volume(double setter);    // Rest volume
		public native @ByRef @Cast("btSoftBody::tVector3Array*") btVector3Array m_pos(); public native Pose m_pos(btVector3Array setter);  // Reference positions
		public native @ByRef @Cast("btSoftBody::tScalarArray*") btScalarArray m_wgh(); public native Pose m_wgh(btScalarArray setter);   // Weights
		public native @ByRef btVector3 m_com(); public native Pose m_com(btVector3 setter);      // COM
		public native @ByRef btMatrix3x3 m_rot(); public native Pose m_rot(btMatrix3x3 setter);    // Rotation
		public native @ByRef btMatrix3x3 m_scl(); public native Pose m_scl(btMatrix3x3 setter);    // Scale
		public native @ByRef btMatrix3x3 m_aqq(); public native Pose m_aqq(btMatrix3x3 setter);    // Base scaling
	}
	/* Cluster		*/
	@NoOffset public static class Cluster extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Cluster(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Cluster(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public Cluster position(long position) {
	        return (Cluster)super.position(position);
	    }
	    @Override public Cluster getPointer(long i) {
	        return new Cluster((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef @Cast("btSoftBody::tScalarArray*") btScalarArray m_masses(); public native Cluster m_masses(btScalarArray setter);
		public native @ByRef btSoftBodyNodePointerArray m_nodes(); public native Cluster m_nodes(btSoftBodyNodePointerArray setter);
		public native @ByRef @Cast("btSoftBody::tVector3Array*") btVector3Array m_framerefs(); public native Cluster m_framerefs(btVector3Array setter);
		public native @ByRef btTransform m_framexform(); public native Cluster m_framexform(btTransform setter);
		public native @Cast("btScalar") double m_idmass(); public native Cluster m_idmass(double setter);
		public native @Cast("btScalar") double m_imass(); public native Cluster m_imass(double setter);
		public native @ByRef btMatrix3x3 m_locii(); public native Cluster m_locii(btMatrix3x3 setter);
		public native @ByRef btMatrix3x3 m_invwi(); public native Cluster m_invwi(btMatrix3x3 setter);
		public native @ByRef btVector3 m_com(); public native Cluster m_com(btVector3 setter);
		public native @ByRef btVector3 m_vimpulses(int i); public native Cluster m_vimpulses(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_vimpulses();
		public native @ByRef btVector3 m_dimpulses(int i); public native Cluster m_dimpulses(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_dimpulses();
		public native int m_nvimpulses(); public native Cluster m_nvimpulses(int setter);
		public native int m_ndimpulses(); public native Cluster m_ndimpulses(int setter);
		public native @ByRef btVector3 m_lv(); public native Cluster m_lv(btVector3 setter);
		public native @ByRef btVector3 m_av(); public native Cluster m_av(btVector3 setter);
		public native btDbvtNode m_leaf(); public native Cluster m_leaf(btDbvtNode setter);
		public native @Cast("btScalar") double m_ndamping(); public native Cluster m_ndamping(double setter); /* Node damping		*/
		public native @Cast("btScalar") double m_ldamping(); public native Cluster m_ldamping(double setter); /* Linear damping	*/
		public native @Cast("btScalar") double m_adamping(); public native Cluster m_adamping(double setter); /* Angular damping	*/
		public native @Cast("btScalar") double m_matching(); public native Cluster m_matching(double setter);
		public native @Cast("btScalar") double m_maxSelfCollisionImpulse(); public native Cluster m_maxSelfCollisionImpulse(double setter);
		public native @Cast("btScalar") double m_selfCollisionImpulseFactor(); public native Cluster m_selfCollisionImpulseFactor(double setter);
		public native @Cast("bool") boolean m_containsAnchor(); public native Cluster m_containsAnchor(boolean setter);
		public native @Cast("bool") boolean m_collide(); public native Cluster m_collide(boolean setter);
		public native int m_clusterIndex(); public native Cluster m_clusterIndex(int setter);
		public Cluster() { super((Pointer)null); allocate(); }
		private native void allocate();
	}
	/* Impulse		*/
	@NoOffset public static class Impulse extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Impulse(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Impulse(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public Impulse position(long position) {
	        return (Impulse)super.position(position);
	    }
	    @Override public Impulse getPointer(long i) {
	        return new Impulse((Pointer)this).offsetAddress(i);
	    }
	
		public native @ByRef btVector3 m_velocity(); public native Impulse m_velocity(btVector3 setter);
		public native @ByRef btVector3 m_drift(); public native Impulse m_drift(btVector3 setter);
		public native @NoOffset int m_asVelocity(); public native Impulse m_asVelocity(int setter);
		public native @NoOffset int m_asDrift(); public native Impulse m_asDrift(int setter);
		public Impulse() { super((Pointer)null); allocate(); }
		private native void allocate();
		public native @ByVal @Name("operator -") Impulse subtract();
		public native @ByVal @Name("operator *") Impulse multiply(@Cast("btScalar") double x);
	}
	/* Body			*/
	@NoOffset public static class Body extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Body(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Body(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public Body position(long position) {
	        return (Body)super.position(position);
	    }
	    @Override public Body getPointer(long i) {
	        return new Body((Pointer)this).offsetAddress(i);
	    }
	
		public native Cluster m_soft(); public native Body m_soft(Cluster setter);
		public native btRigidBody m_rigid(); public native Body m_rigid(btRigidBody setter);
		public native @Const btCollisionObject m_collisionObject(); public native Body m_collisionObject(btCollisionObject setter);

		public Body() { super((Pointer)null); allocate(); }
		private native void allocate();
		public Body(Cluster p) { super((Pointer)null); allocate(p); }
		private native void allocate(Cluster p);
		public Body(@Const btCollisionObject colObj) { super((Pointer)null); allocate(colObj); }
		private native void allocate(@Const btCollisionObject colObj);

		public native void activate();
		public native @Const @ByRef btMatrix3x3 invWorldInertia();
		public native @Cast("btScalar") double invMass();
		public native @Const @ByRef btTransform xform();
		public native @ByVal btVector3 linearVelocity();
		public native @ByVal btVector3 angularVelocity(@Const @ByRef btVector3 rpos);
		public native @ByVal btVector3 angularVelocity();
		public native @ByVal btVector3 velocity(@Const @ByRef btVector3 rpos);
		public native void applyVImpulse(@Const @ByRef btVector3 impulse, @Const @ByRef btVector3 rpos);
		public native void applyDImpulse(@Const @ByRef btVector3 impulse, @Const @ByRef btVector3 rpos);
		public native void applyImpulse(@Const @ByRef Impulse impulse, @Const @ByRef btVector3 rpos);
		public native void applyVAImpulse(@Const @ByRef btVector3 impulse);
		public native void applyDAImpulse(@Const @ByRef btVector3 impulse);
		public native void applyAImpulse(@Const @ByRef Impulse impulse);
		public native void applyDCImpulse(@Const @ByRef btVector3 impulse);
	}
	/* Joint		*/
	@NoOffset public static class Joint extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Joint(Pointer p) { super(p); }
	
		public static class eType extends Pointer {
		    static { Loader.load(); }
		    /** Default native constructor. */
		    public eType() { super((Pointer)null); allocate(); }
		    /** Native array allocator. Access with {@link Pointer#position(long)}. */
		    public eType(long size) { super((Pointer)null); allocateArray(size); }
		    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
		    public eType(Pointer p) { super(p); }
		    private native void allocate();
		    private native void allocateArray(long size);
		    @Override public eType position(long position) {
		        return (eType)super.position(position);
		    }
		    @Override public eType getPointer(long i) {
		        return new eType((Pointer)this).offsetAddress(i);
		    }
		
			/** enum btSoftBody::Joint::eType::_ */
			public static final int
				Linear = 0,
				Angular = 1,
				Contact = 2;
		}
		@NoOffset public static class Specs extends Pointer {
		    static { Loader.load(); }
		    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
		    public Specs(Pointer p) { super(p); }
		    /** Native array allocator. Access with {@link Pointer#position(long)}. */
		    public Specs(long size) { super((Pointer)null); allocateArray(size); }
		    private native void allocateArray(long size);
		    @Override public Specs position(long position) {
		        return (Specs)super.position(position);
		    }
		    @Override public Specs getPointer(long i) {
		        return new Specs((Pointer)this).offsetAddress(i);
		    }
		
			public Specs() { super((Pointer)null); allocate(); }
			private native void allocate();
			public native @Cast("btScalar") double erp(); public native Specs erp(double setter);
			public native @Cast("btScalar") double cfm(); public native Specs cfm(double setter);
			public native @Cast("btScalar") double split(); public native Specs split(double setter);
		}
		public native @ByRef Body m_bodies(int i); public native Joint m_bodies(int i, Body setter);
		@MemberGetter public native Body m_bodies();
		public native @ByRef btVector3 m_refs(int i); public native Joint m_refs(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_refs();
		public native @Cast("btScalar") double m_cfm(); public native Joint m_cfm(double setter);
		public native @Cast("btScalar") double m_erp(); public native Joint m_erp(double setter);
		public native @Cast("btScalar") double m_split(); public native Joint m_split(double setter);
		public native @ByRef btVector3 m_drift(); public native Joint m_drift(btVector3 setter);
		public native @ByRef btVector3 m_sdrift(); public native Joint m_sdrift(btVector3 setter);
		public native @ByRef btMatrix3x3 m_massmatrix(); public native Joint m_massmatrix(btMatrix3x3 setter);
		public native @Cast("bool") boolean m_delete(); public native Joint m_delete(boolean setter);
		public native void Prepare(@Cast("btScalar") double dt, int iterations);
		public native void Solve(@Cast("btScalar") double dt, @Cast("btScalar") double sor);
		public native void Terminate(@Cast("btScalar") double dt);
		public native @Cast("btSoftBody::Joint::eType::_") int Type();
	}
	/* LJoint		*/
	@NoOffset public static class LJoint extends Joint {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public LJoint() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public LJoint(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public LJoint(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public LJoint position(long position) {
	        return (LJoint)super.position(position);
	    }
	    @Override public LJoint getPointer(long i) {
	        return new LJoint((Pointer)this).offsetAddress(i);
	    }
	
		@NoOffset public static class Specs extends Joint.Specs {
		    static { Loader.load(); }
		    /** Default native constructor. */
		    public Specs() { super((Pointer)null); allocate(); }
		    /** Native array allocator. Access with {@link Pointer#position(long)}. */
		    public Specs(long size) { super((Pointer)null); allocateArray(size); }
		    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
		    public Specs(Pointer p) { super(p); }
		    private native void allocate();
		    private native void allocateArray(long size);
		    @Override public Specs position(long position) {
		        return (Specs)super.position(position);
		    }
		    @Override public Specs getPointer(long i) {
		        return new Specs((Pointer)this).offsetAddress(i);
		    }
		
			public native @ByRef @Name("position") btVector3 _position(); public native Specs _position(btVector3 setter);
		}
		public native @ByRef btVector3 m_rpos(int i); public native LJoint m_rpos(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_rpos();
		public native void Prepare(@Cast("btScalar") double dt, int iterations);
		public native void Solve(@Cast("btScalar") double dt, @Cast("btScalar") double sor);
		public native void Terminate(@Cast("btScalar") double dt);
		
	}
	/* AJoint		*/
	@NoOffset public static class AJoint extends Joint {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public AJoint() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public AJoint(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public AJoint(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public AJoint position(long position) {
	        return (AJoint)super.position(position);
	    }
	    @Override public AJoint getPointer(long i) {
	        return new AJoint((Pointer)this).offsetAddress(i);
	    }
	
		public static class IControl extends Pointer {
		    static { Loader.load(); }
		    /** Default native constructor. */
		    public IControl() { super((Pointer)null); allocate(); }
		    /** Native array allocator. Access with {@link Pointer#position(long)}. */
		    public IControl(long size) { super((Pointer)null); allocateArray(size); }
		    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
		    public IControl(Pointer p) { super(p); }
		    private native void allocate();
		    private native void allocateArray(long size);
		    @Override public IControl position(long position) {
		        return (IControl)super.position(position);
		    }
		    @Override public IControl getPointer(long i) {
		        return new IControl((Pointer)this).offsetAddress(i);
		    }
		
			public native void Prepare(AJoint arg0);
			public native @Cast("btScalar") double Speed(AJoint arg0, @Cast("btScalar") double current);
			public static native IControl Default();
		}
		@NoOffset public static class Specs extends Joint.Specs {
		    static { Loader.load(); }
		    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
		    public Specs(Pointer p) { super(p); }
		    /** Native array allocator. Access with {@link Pointer#position(long)}. */
		    public Specs(long size) { super((Pointer)null); allocateArray(size); }
		    private native void allocateArray(long size);
		    @Override public Specs position(long position) {
		        return (Specs)super.position(position);
		    }
		    @Override public Specs getPointer(long i) {
		        return new Specs((Pointer)this).offsetAddress(i);
		    }
		
			public Specs() { super((Pointer)null); allocate(); }
			private native void allocate();
			public native @ByRef btVector3 axis(); public native Specs axis(btVector3 setter);
			public native IControl icontrol(); public native Specs icontrol(IControl setter);
		}
		public native @ByRef btVector3 m_axis(int i); public native AJoint m_axis(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_axis();
		public native IControl m_icontrol(); public native AJoint m_icontrol(IControl setter);
		public native void Prepare(@Cast("btScalar") double dt, int iterations);
		public native void Solve(@Cast("btScalar") double dt, @Cast("btScalar") double sor);
		public native void Terminate(@Cast("btScalar") double dt);
		
	}
	/* CJoint		*/
	@NoOffset public static class CJoint extends Joint {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public CJoint() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public CJoint(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public CJoint(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public CJoint position(long position) {
	        return (CJoint)super.position(position);
	    }
	    @Override public CJoint getPointer(long i) {
	        return new CJoint((Pointer)this).offsetAddress(i);
	    }
	
		public native int m_life(); public native CJoint m_life(int setter);
		public native int m_maxlife(); public native CJoint m_maxlife(int setter);
		public native @ByRef btVector3 m_rpos(int i); public native CJoint m_rpos(int i, btVector3 setter);
		@MemberGetter public native btVector3 m_rpos();
		public native @ByRef btVector3 m_normal(); public native CJoint m_normal(btVector3 setter);
		public native @Cast("btScalar") double m_friction(); public native CJoint m_friction(double setter);
		public native void Prepare(@Cast("btScalar") double dt, int iterations);
		public native void Solve(@Cast("btScalar") double dt, @Cast("btScalar") double sor);
		public native void Terminate(@Cast("btScalar") double dt);
		
	}
	/* Config		*/
	public static class Config extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Config() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Config(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Config(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Config position(long position) {
	        return (Config)super.position(position);
	    }
	    @Override public Config getPointer(long i) {
	        return new Config((Pointer)this).offsetAddress(i);
	    }
	
		public native @Cast("btSoftBody::eAeroModel::_") int aeromodel(); public native Config aeromodel(int setter);    // Aerodynamic model (default: V_Point)
		public native @Cast("btScalar") double kVCF(); public native Config kVCF(double setter);              // Velocities correction factor (Baumgarte)
		public native @Cast("btScalar") double kDP(); public native Config kDP(double setter);               // Damping coefficient [0,1]
		public native @Cast("btScalar") double kDG(); public native Config kDG(double setter);               // Drag coefficient [0,+inf]
		public native @Cast("btScalar") double kLF(); public native Config kLF(double setter);               // Lift coefficient [0,+inf]
		public native @Cast("btScalar") double kPR(); public native Config kPR(double setter);               // Pressure coefficient [-inf,+inf]
		public native @Cast("btScalar") double kVC(); public native Config kVC(double setter);               // Volume conversation coefficient [0,+inf]
		public native @Cast("btScalar") double kDF(); public native Config kDF(double setter);               // Dynamic friction coefficient [0,1]
		public native @Cast("btScalar") double kMT(); public native Config kMT(double setter);               // Pose matching coefficient [0,1]
		public native @Cast("btScalar") double kCHR(); public native Config kCHR(double setter);              // Rigid contacts hardness [0,1]
		public native @Cast("btScalar") double kKHR(); public native Config kKHR(double setter);              // Kinetic contacts hardness [0,1]
		public native @Cast("btScalar") double kSHR(); public native Config kSHR(double setter);              // Soft contacts hardness [0,1]
		public native @Cast("btScalar") double kAHR(); public native Config kAHR(double setter);              // Anchors hardness [0,1]
		public native @Cast("btScalar") double kSRHR_CL(); public native Config kSRHR_CL(double setter);          // Soft vs rigid hardness [0,1] (cluster only)
		public native @Cast("btScalar") double kSKHR_CL(); public native Config kSKHR_CL(double setter);          // Soft vs kinetic hardness [0,1] (cluster only)
		public native @Cast("btScalar") double kSSHR_CL(); public native Config kSSHR_CL(double setter);          // Soft vs soft hardness [0,1] (cluster only)
		public native @Cast("btScalar") double kSR_SPLT_CL(); public native Config kSR_SPLT_CL(double setter);       // Soft vs rigid impulse split [0,1] (cluster only)
		public native @Cast("btScalar") double kSK_SPLT_CL(); public native Config kSK_SPLT_CL(double setter);       // Soft vs rigid impulse split [0,1] (cluster only)
		public native @Cast("btScalar") double kSS_SPLT_CL(); public native Config kSS_SPLT_CL(double setter);       // Soft vs rigid impulse split [0,1] (cluster only)
		public native @Cast("btScalar") double maxvolume(); public native Config maxvolume(double setter);         // Maximum volume ratio for pose
		public native @Cast("btScalar") double timescale(); public native Config timescale(double setter);         // Time scale
		public native int viterations(); public native Config viterations(int setter);            // Velocities solver iterations
		public native int piterations(); public native Config piterations(int setter);            // Positions solver iterations
		public native int diterations(); public native Config diterations(int setter);            // Drift solver iterations
		public native int citerations(); public native Config citerations(int setter);            // Cluster solver iterations
		public native int collisions(); public native Config collisions(int setter);             // Collisions flags
		public native @ByRef @Cast("btSoftBody::tVSolverArray*") LagrangeMultiplierArray m_vsequence(); public native Config m_vsequence(LagrangeMultiplierArray setter);  // Velocity solvers sequence
		public native @ByRef @Cast("btSoftBody::tPSolverArray*") LagrangeMultiplierArray m_psequence(); public native Config m_psequence(LagrangeMultiplierArray setter);  // Position solvers sequence
		public native @ByRef @Cast("btSoftBody::tPSolverArray*") LagrangeMultiplierArray m_dsequence(); public native Config m_dsequence(LagrangeMultiplierArray setter);  // Drift solvers sequence
		public native @Cast("btScalar") double drag(); public native Config drag(double setter);              // deformable air drag
		public native @Cast("btScalar") double m_maxStress(); public native Config m_maxStress(double setter);       // Maximum principle first Piola stress
	}
	/* SolverState	*/
	@NoOffset public static class SolverState extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public SolverState(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public SolverState(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public SolverState position(long position) {
	        return (SolverState)super.position(position);
	    }
	    @Override public SolverState getPointer(long i) {
	        return new SolverState((Pointer)this).offsetAddress(i);
	    }
	
		//if you add new variables, always initialize them!
		public SolverState() { super((Pointer)null); allocate(); }
		private native void allocate();
		public native @Cast("btScalar") double sdt(); public native SolverState sdt(double setter);     // dt*timescale
		public native @Cast("btScalar") double isdt(); public native SolverState isdt(double setter);    // 1/sdt
		public native @Cast("btScalar") double velmrg(); public native SolverState velmrg(double setter);  // velocity margin
		public native @Cast("btScalar") double radmrg(); public native SolverState radmrg(double setter);  // radial margin
		public native @Cast("btScalar") double updmrg(); public native SolverState updmrg(double setter);  // Update margin
	}
	/** RayFromToCaster takes a ray from, ray to (instead of direction!) */
	@NoOffset public static class RayFromToCaster extends btDbvt.ICollide {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public RayFromToCaster(Pointer p) { super(p); }
	
		public native @ByRef btVector3 m_rayFrom(); public native RayFromToCaster m_rayFrom(btVector3 setter);
		public native @ByRef btVector3 m_rayTo(); public native RayFromToCaster m_rayTo(btVector3 setter);
		public native @ByRef btVector3 m_rayNormalizedDirection(); public native RayFromToCaster m_rayNormalizedDirection(btVector3 setter);
		public native @Cast("btScalar") double m_mint(); public native RayFromToCaster m_mint(double setter);
		public native Face m_face(); public native RayFromToCaster m_face(Face setter);
		public native int m_tests(); public native RayFromToCaster m_tests(int setter);
		public RayFromToCaster(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @Cast("btScalar") double mxt) { super((Pointer)null); allocate(rayFrom, rayTo, mxt); }
		private native void allocate(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @Cast("btScalar") double mxt);
		public native void Process(@Const btDbvtNode leaf);

		public static native @Cast("btScalar") double rayFromToTriangle(@Const @ByRef btVector3 rayFrom,
															 @Const @ByRef btVector3 rayTo,
															 @Const @ByRef btVector3 rayNormalizedDirection,
															 @Const @ByRef btVector3 a,
															 @Const @ByRef btVector3 b,
															 @Const @ByRef btVector3 c,
															 @Cast("btScalar") double maxt/*=SIMD_INFINITY*/);
		public static native @Cast("btScalar") double rayFromToTriangle(@Const @ByRef btVector3 rayFrom,
															 @Const @ByRef btVector3 rayTo,
															 @Const @ByRef btVector3 rayNormalizedDirection,
															 @Const @ByRef btVector3 a,
															 @Const @ByRef btVector3 b,
															 @Const @ByRef btVector3 c);
	}

	//
	// Typedefs
	//

	public static class psolver_t extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    psolver_t(Pointer p) { super(p); }
	    protected psolver_t() { allocate(); }
	    private native void allocate();
	    public native void call(btSoftBody arg0, @Cast("btScalar") double arg1, @Cast("btScalar") double arg2);
	}
	public static class vsolver_t extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    vsolver_t(Pointer p) { super(p); }
	    protected vsolver_t() { allocate(); }
	    private native void allocate();
	    public native void call(btSoftBody arg0, @Cast("btScalar") double arg1);
	}

	//
	// Fields
	//

	public native @ByRef Config m_cfg(); public native btSoftBody m_cfg(Config setter);                      // Configuration
	public native @ByRef SolverState m_sst(); public native btSoftBody m_sst(SolverState setter);                 // Solver state
	public native @ByRef Pose m_pose(); public native btSoftBody m_pose(Pose setter);                       // Pose
	public native Pointer m_tag(); public native btSoftBody m_tag(Pointer setter);                       // User data
	public native btSoftBodyWorldInfo m_worldInfo(); public native btSoftBody m_worldInfo(btSoftBodyWorldInfo setter);  // World info
	public native @ByRef @Cast("btSoftBody::tNoteArray*") btSoftBodyNoteArray m_notes(); public native btSoftBody m_notes(btSoftBodyNoteArray setter);                // Notes
	public native @ByRef @Cast("btSoftBody::tNodeArray*") btSoftBodyNodeArray m_nodes(); public native btSoftBody m_nodes(btSoftBodyNodeArray setter);                // Nodes
	public native @ByRef @Cast("btSoftBody::tRenderNodeArray*") btSoftBodyRenderNodeArray m_renderNodes(); public native btSoftBody m_renderNodes(btSoftBodyRenderNodeArray setter);    // Render Nodes
	public native @ByRef @Cast("btSoftBody::tLinkArray*") btSoftBodyLinkArray m_links(); public native btSoftBody m_links(btSoftBodyLinkArray setter);                // Links
	public native @ByRef @Cast("btSoftBody::tFaceArray*") btSoftBodyFaceArray m_faces(); public native btSoftBody m_faces(btSoftBodyFaceArray setter);                // Faces
	public native @ByRef @Cast("btSoftBody::tRenderFaceArray*") btSoftBodyRenderFaceArray m_renderFaces(); public native btSoftBody m_renderFaces(btSoftBodyRenderFaceArray setter);    // Faces
	public native @ByRef @Cast("btSoftBody::tTetraArray*") btSoftBodyTetraArray m_tetras(); public native btSoftBody m_tetras(btSoftBodyTetraArray setter);              // Tetras
	public native @ByRef btSoftBodyTetraSratchArray m_tetraScratches(); public native btSoftBody m_tetraScratches(btSoftBodyTetraSratchArray setter);
	public native @ByRef btSoftBodyTetraSratchArray m_tetraScratchesTn(); public native btSoftBody m_tetraScratchesTn(btSoftBodyTetraSratchArray setter);
	public native @ByRef @Cast("btSoftBody::tAnchorArray*") btSoftBodyAnchorArray m_anchors(); public native btSoftBody m_anchors(btSoftBodyAnchorArray setter);  // Anchors
	public native @ByRef btSoftBodyDeformableNodeRigidAnchorArray m_deformableAnchors(); public native btSoftBody m_deformableAnchors(btSoftBodyDeformableNodeRigidAnchorArray setter);
	public native @ByRef @Cast("btSoftBody::tRContactArray*") btSoftBodyRContactArray m_rcontacts(); public native btSoftBody m_rcontacts(btSoftBodyRContactArray setter);  // Rigid contacts
	public native @ByRef btSoftBodyDeformableNodeRigidContactArray m_nodeRigidContacts(); public native btSoftBody m_nodeRigidContacts(btSoftBodyDeformableNodeRigidContactArray setter);
	public native @ByRef btSoftBodyDeformableFaceNodeContactArray m_faceNodeContacts(); public native btSoftBody m_faceNodeContacts(btSoftBodyDeformableFaceNodeContactArray setter);
	public native @ByRef btSoftBodyDeformableFaceRigidContactArray m_faceRigidContacts(); public native btSoftBody m_faceRigidContacts(btSoftBodyDeformableFaceRigidContactArray setter);
	public native @ByRef btSoftBodyDeformableFaceNodeContactArray m_faceNodeContactsCCD(); public native btSoftBody m_faceNodeContactsCCD(btSoftBodyDeformableFaceNodeContactArray setter);
	public native @ByRef @Cast("btSoftBody::tSContactArray*") btSoftBodySContactArray m_scontacts(); public native btSoftBody m_scontacts(btSoftBodySContactArray setter);     // Soft contacts
	public native @ByRef @Cast("btSoftBody::tJointArray*") btSoftBodyJointArray m_joints(); public native btSoftBody m_joints(btSoftBodyJointArray setter);           // Joints
	public native @ByRef @Cast("btSoftBody::tMaterialArray*") btSoftBodyMaterialArray m_materials(); public native btSoftBody m_materials(btSoftBodyMaterialArray setter);     // Materials
	public native @Cast("btScalar") double m_timeacc(); public native btSoftBody m_timeacc(double setter);             // Time accumulator
	public native @ByRef btVector3 m_bounds(int i); public native btSoftBody m_bounds(int i, btVector3 setter);
	@MemberGetter public native btVector3 m_bounds();          // Spatial bounds
	public native @Cast("bool") boolean m_bUpdateRtCst(); public native btSoftBody m_bUpdateRtCst(boolean setter);            // Update runtime constants
	public native @ByRef btDbvt m_ndbvt(); public native btSoftBody m_ndbvt(btDbvt setter);                 // Nodes tree
	public native @ByRef btDbvt m_fdbvt(); public native btSoftBody m_fdbvt(btDbvt setter);                 // Faces tree
	public native btDbvntNode m_fdbvnt(); public native btSoftBody m_fdbvnt(btDbvntNode setter);          // Faces tree with normals
	public native @ByRef btDbvt m_cdbvt(); public native btSoftBody m_cdbvt(btDbvt setter);                 // Clusters tree
	public native @ByRef @Cast("btSoftBody::tClusterArray*") btSoftBodyClusterArray m_clusters(); public native btSoftBody m_clusters(btSoftBodyClusterArray setter);       // Clusters
	public native @Cast("btScalar") double m_dampingCoefficient(); public native btSoftBody m_dampingCoefficient(double setter);  // Damping Coefficient
	public native @Cast("btScalar") double m_sleepingThreshold(); public native btSoftBody m_sleepingThreshold(double setter);
	public native @Cast("btScalar") double m_maxSpeedSquared(); public native btSoftBody m_maxSpeedSquared(double setter);
	public native @ByRef btVector3Array m_quads(); public native btSoftBody m_quads(btVector3Array setter);  // quadrature points for collision detection
	public native @Cast("btScalar") double m_repulsionStiffness(); public native btSoftBody m_repulsionStiffness(double setter);
	public native @Cast("btScalar") double m_gravityFactor(); public native btSoftBody m_gravityFactor(double setter);
	public native @Cast("bool") boolean m_cacheBarycenter(); public native btSoftBody m_cacheBarycenter(boolean setter);
	public native @ByRef btVector3Array m_X(); public native btSoftBody m_X(btVector3Array setter);  // initial positions

	public native @ByRef btVector4Array m_renderNodesInterpolationWeights(); public native btSoftBody m_renderNodesInterpolationWeights(btVector4Array setter);
	
	public native @ByRef btScalarArray m_z(); public native btSoftBody m_z(btScalarArray setter);  // vertical distance used in extrapolation
	public native @Cast("bool") boolean m_useSelfCollision(); public native btSoftBody m_useSelfCollision(boolean setter);
	public native @Cast("bool") boolean m_softSoftCollision(); public native btSoftBody m_softSoftCollision(boolean setter);

	public native @ByRef btBoolArray m_clusterConnectivity(); public native btSoftBody m_clusterConnectivity(btBoolArray setter);  //cluster connectivity, for self-collision

	public native @ByRef btVector3 m_windVelocity(); public native btSoftBody m_windVelocity(btVector3 setter);

	public native @Cast("btScalar") double m_restLengthScale(); public native btSoftBody m_restLengthScale(double setter);

	public native @Cast("bool") boolean m_reducedModel(); public native btSoftBody m_reducedModel(boolean setter);	// Reduced deformable model flag
	
	//
	// Api
	//

	/* ctor																	*/
	public btSoftBody(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") DoublePointer m) { super((Pointer)null); allocate(worldInfo, node_count, x, m); }
	private native void allocate(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") DoublePointer m);
	public btSoftBody(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") DoubleBuffer m) { super((Pointer)null); allocate(worldInfo, node_count, x, m); }
	private native void allocate(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") DoubleBuffer m);
	public btSoftBody(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") double[] m) { super((Pointer)null); allocate(worldInfo, node_count, x, m); }
	private native void allocate(btSoftBodyWorldInfo worldInfo, int node_count, @Const btVector3 x, @Cast("const btScalar*") double[] m);

	/* ctor																	*/
	public btSoftBody(btSoftBodyWorldInfo worldInfo) { super((Pointer)null); allocate(worldInfo); }
	private native void allocate(btSoftBodyWorldInfo worldInfo);

	public native void initDefaults();

	/* dtor																	*/
	/* Check for existing link												*/

	public native @ByRef btIntArray m_userIndexMapping(); public native btSoftBody m_userIndexMapping(btIntArray setter);

	public native btSoftBodyWorldInfo getWorldInfo();

	public native void setDampingCoefficient(@Cast("btScalar") double damping_coeff);

	/**\todo: avoid internal softbody shape hack and move collision code to collision library */
	public native void setCollisionShape(btCollisionShape collisionShape);

	public native @Cast("bool") boolean checkLink(int node0,
					   int node1);
	public native @Cast("bool") boolean checkLink(@Const Node node0,
					   @Const Node node1);
	/* Check for existring face												*/
	public native @Cast("bool") boolean checkFace(int node0,
					   int node1,
					   int node2);
	/* Append material														*/
	public native Material appendMaterial();
	/* Append note															*/
	public native void appendNote(@Cast("const char*") BytePointer text,
						@Const @ByRef btVector3 o,
						@Const @ByRef(nullValue = "btVector4(1, 0, 0, 0)") btVector4 c,
						Node n0/*=0*/,
						Node n1/*=0*/,
						Node n2/*=0*/,
						Node n3/*=0*/);
	public native void appendNote(@Cast("const char*") BytePointer text,
						@Const @ByRef btVector3 o);
	public native void appendNote(String text,
						@Const @ByRef btVector3 o,
						@Const @ByRef(nullValue = "btVector4(1, 0, 0, 0)") btVector4 c,
						Node n0/*=0*/,
						Node n1/*=0*/,
						Node n2/*=0*/,
						Node n3/*=0*/);
	public native void appendNote(String text,
						@Const @ByRef btVector3 o);
	public native void appendNote(@Cast("const char*") BytePointer text,
						@Const @ByRef btVector3 o,
						Node feature);
	public native void appendNote(String text,
						@Const @ByRef btVector3 o,
						Node feature);
	public native void appendNote(@Cast("const char*") BytePointer text,
						@Const @ByRef btVector3 o,
						Link feature);
	public native void appendNote(String text,
						@Const @ByRef btVector3 o,
						Link feature);
	public native void appendNote(@Cast("const char*") BytePointer text,
						@Const @ByRef btVector3 o,
						Face feature);
	public native void appendNote(String text,
						@Const @ByRef btVector3 o,
						Face feature);
	/* Append node															*/
	public native void appendNode(@Const @ByRef btVector3 x, @Cast("btScalar") double m);
	/* Append link															*/
	public native void appendLink(int model/*=-1*/, Material mat/*=0*/);
	public native void appendLink();
	public native void appendLink(int node0,
						int node1,
						Material mat/*=0*/,
						@Cast("bool") boolean bcheckexist/*=false*/);
	public native void appendLink(int node0,
						int node1);
	public native void appendLink(Node node0,
						Node node1,
						Material mat/*=0*/,
						@Cast("bool") boolean bcheckexist/*=false*/);
	public native void appendLink(Node node0,
						Node node1);
	/* Append face															*/
	public native void appendFace(int model/*=-1*/, Material mat/*=0*/);
	public native void appendFace();
	public native void appendFace(int node0,
						int node1,
						int node2,
						Material mat/*=0*/);
	public native void appendFace(int node0,
						int node1,
						int node2);
	public native void appendTetra(int model, Material mat);
	//
	public native void appendTetra(int node0,
						 int node1,
						 int node2,
						 int node3,
						 Material mat/*=0*/);
	public native void appendTetra(int node0,
						 int node1,
						 int node2,
						 int node3);

	/* Append anchor														*/
	public native void appendDeformableAnchor(int node, btRigidBody body);
	public native void appendDeformableAnchor(int node, btMultiBodyLinkCollider link);
	public native void appendAnchor(int node,
						  btRigidBody body, @Cast("bool") boolean disableCollisionBetweenLinkedBodies/*=false*/, @Cast("btScalar") double influence/*=1*/);
	public native void appendAnchor(int node,
						  btRigidBody body);
	public native void appendAnchor(int node, btRigidBody body, @Const @ByRef btVector3 localPivot, @Cast("bool") boolean disableCollisionBetweenLinkedBodies/*=false*/, @Cast("btScalar") double influence/*=1*/);
	public native void appendAnchor(int node, btRigidBody body, @Const @ByRef btVector3 localPivot);
	public native void removeAnchor(int node);
	/* Append linear joint													*/
	public native void appendLinearJoint(@Const @ByRef LJoint.Specs specs, Cluster body0, @ByVal Body body1);
	public native void appendLinearJoint(@Const @ByRef LJoint.Specs specs, @ByVal(nullValue = "btSoftBody::Body()") Body body);
	public native void appendLinearJoint(@Const @ByRef LJoint.Specs specs);
	public native void appendLinearJoint(@Const @ByRef LJoint.Specs specs, btSoftBody body);
	/* Append linear joint													*/
	public native void appendAngularJoint(@Const @ByRef AJoint.Specs specs, Cluster body0, @ByVal Body body1);
	public native void appendAngularJoint(@Const @ByRef AJoint.Specs specs, @ByVal(nullValue = "btSoftBody::Body()") Body body);
	public native void appendAngularJoint(@Const @ByRef AJoint.Specs specs);
	public native void appendAngularJoint(@Const @ByRef AJoint.Specs specs, btSoftBody body);
	/* Add force (or gravity) to the entire body							*/
	public native void addForce(@Const @ByRef btVector3 force);
	/* Add force (or gravity) to a node of the body							*/
	public native void addForce(@Const @ByRef btVector3 force,
					  int node);
	/* Add aero force to a node of the body */
	public native void addAeroForceToNode(@Const @ByRef btVector3 windVelocity, int nodeIndex);

	/* Add aero force to a face of the body */
	public native void addAeroForceToFace(@Const @ByRef btVector3 windVelocity, int faceIndex);

	/* Add velocity to the entire body										*/
	public native void addVelocity(@Const @ByRef btVector3 velocity);

	/* Set velocity for the entire body										*/
	public native void setVelocity(@Const @ByRef btVector3 velocity);

	/* Add velocity to a node of the body									*/
	public native void addVelocity(@Const @ByRef btVector3 velocity,
						 int node);
	/* Set mass																*/
	public native void setMass(int node,
					 @Cast("btScalar") double mass);
	/* Get mass																*/
	public native @Cast("btScalar") double getMass(int node);
	/* Get total mass														*/
	public native @Cast("btScalar") double getTotalMass();
	/* Set total mass (weighted by previous masses)							*/
	public native void setTotalMass(@Cast("btScalar") double mass,
						  @Cast("bool") boolean fromfaces/*=false*/);
	public native void setTotalMass(@Cast("btScalar") double mass);
	/* Set total density													*/
	public native void setTotalDensity(@Cast("btScalar") double density);
	/* Set volume mass (using tetrahedrons)									*/
	public native void setVolumeMass(@Cast("btScalar") double mass);
	/* Set volume density (using tetrahedrons)								*/
	public native void setVolumeDensity(@Cast("btScalar") double density);
	/* Get the linear velocity of the center of mass                        */
	public native @ByVal btVector3 getLinearVelocity();
	/* Set the linear velocity of the center of mass                        */
	public native void setLinearVelocity(@Const @ByRef btVector3 linVel);
	/* Set the angular velocity of the center of mass                       */
	public native void setAngularVelocity(@Const @ByRef btVector3 angVel);
	/* Get best fit rigid transform                                         */
	public native @ByVal btTransform getRigidTransform();
	/* Transform to given pose                                              */
	public native void transformTo(@Const @ByRef btTransform trs);
	/* Transform															*/
	public native void transform(@Const @ByRef btTransform trs);
	/* Translate															*/
	public native void translate(@Const @ByRef btVector3 trs);
	/* Rotate															*/
	public native void rotate(@Const @ByRef btQuaternion rot);
	/* Scale																*/
	public native void scale(@Const @ByRef btVector3 scl);
	/* Get link resting lengths scale										*/
	public native @Cast("btScalar") double getRestLengthScale();
	/* Scale resting length of all springs									*/
	public native void setRestLengthScale(@Cast("btScalar") double restLength);
	/* Set current state as pose											*/
	public native void setPose(@Cast("bool") boolean bvolume,
					 @Cast("bool") boolean bframe);
	/* Set current link lengths as resting lengths							*/
	public native void resetLinkRestLengths();
	/* Return the volume													*/
	public native @Cast("btScalar") double getVolume();
	/* Cluster count														*/
	public native @ByVal btVector3 getCenterOfMass();
	public native int clusterCount();
	/* Cluster center of mass												*/
	public static native @ByVal btVector3 clusterCom(@Const Cluster cluster);
	public native @ByVal btVector3 clusterCom(int cluster);
	/* Cluster velocity at rpos												*/
	public static native @ByVal btVector3 clusterVelocity(@Const Cluster cluster, @Const @ByRef btVector3 rpos);
	/* Cluster impulse														*/
	public static native void clusterVImpulse(Cluster cluster, @Const @ByRef btVector3 rpos, @Const @ByRef btVector3 impulse);
	public static native void clusterDImpulse(Cluster cluster, @Const @ByRef btVector3 rpos, @Const @ByRef btVector3 impulse);
	public static native void clusterImpulse(Cluster cluster, @Const @ByRef btVector3 rpos, @Const @ByRef Impulse impulse);
	public static native void clusterVAImpulse(Cluster cluster, @Const @ByRef btVector3 impulse);
	public static native void clusterDAImpulse(Cluster cluster, @Const @ByRef btVector3 impulse);
	public static native void clusterAImpulse(Cluster cluster, @Const @ByRef Impulse impulse);
	public static native void clusterDCImpulse(Cluster cluster, @Const @ByRef btVector3 impulse);
	/* Generate bending constraints based on distance in the adjency graph	*/
	public native int generateBendingConstraints(int distance,
									   Material mat/*=0*/);
	public native int generateBendingConstraints(int distance);
	/* Randomize constraints to reduce solver bias							*/
	public native void randomizeConstraints();

	public native void updateState(@Const @ByRef btVector3Array qs, @Const @ByRef btVector3Array vs);

	/* Release clusters														*/
	public native void releaseCluster(int index);
	public native void releaseClusters();
	/* Generate clusters (K-mean)											*/
	/**generateClusters with k=0 will create a convex cluster for each tetrahedron or triangle
	/**otherwise an approximation will be used (better performance) */
	public native int generateClusters(int k, int maxiterations/*=8192*/);
	public native int generateClusters(int k);
	/* Refine																*/
	public native void refine(ImplicitFn ifn, @Cast("btScalar") double accurary, @Cast("bool") boolean cut);
	/* CutLink																*/
	public native @Cast("bool") boolean cutLink(int node0, int node1, @Cast("btScalar") double _position);
	public native @Cast("bool") boolean cutLink(@Const Node node0, @Const Node node1, @Cast("btScalar") double _position);

	/**Ray casting using rayFrom and rayTo in worldspace, (not direction!) */
	public native @Cast("bool") boolean rayTest(@Const @ByRef btVector3 rayFrom,
					 @Const @ByRef btVector3 rayTo,
					 @ByRef sRayCast results);
	public native @Cast("bool") boolean rayFaceTest(@Const @ByRef btVector3 rayFrom,
						 @Const @ByRef btVector3 rayTo,
						 @ByRef sRayCast results);
	public native int rayFaceTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
						@Cast("btScalar*") @ByRef DoublePointer mint, @ByRef IntPointer index);
	public native int rayFaceTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
						@Cast("btScalar*") @ByRef DoubleBuffer mint, @ByRef IntBuffer index);
	public native int rayFaceTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
						@Cast("btScalar*") @ByRef double[] mint, @ByRef int[] index);
	/* Solver presets														*/
	public native void setSolver(@Cast("btSoftBody::eSolverPresets::_") int preset);
	/* predictMotion														*/
	public native void predictMotion(@Cast("btScalar") double dt);
	/* solveConstraints														*/
	public native void solveConstraints();
	/* staticSolve															*/
	public native void staticSolve(int iterations);
	/* solveCommonConstraints												*/
	public static native void solveCommonConstraints(@Cast("btSoftBody**") PointerPointer bodies, int count, int iterations);
	public static native void solveCommonConstraints(@ByPtrPtr btSoftBody bodies, int count, int iterations);
	/* solveClusters														*/
	public static native void solveClusters(@Const @ByRef btSoftBodyArray bodies);
	/* integrateMotion														*/
	public native void integrateMotion();
	/* defaultCollisionHandlers												*/
	public native void defaultCollisionHandler(@Const btCollisionObjectWrapper pcoWrap);
	public native void defaultCollisionHandler(btSoftBody psb);
	public native void setSelfCollision(@Cast("bool") boolean useSelfCollision);
	public native @Cast("bool") boolean useSelfCollision();
	public native void updateDeactivation(@Cast("btScalar") double timeStep);
	public native void setZeroVelocity();
	public native @Cast("bool") boolean wantsSleeping();

	public native @ByVal btMatrix3x3 getImpulseFactor(int n_node);

	//
	// Functionality to deal with new accelerated solvers.
	//

	/**
	 * Set a wind velocity for interaction with the air.
	 */
	public native void setWindVelocity(@Const @ByRef btVector3 velocity);

	/**
	 * Return the wind velocity for interaction with the air.
	 */
	public native @Const @ByRef btVector3 getWindVelocity();

	//
	// Set the solver that handles this soft body
	// Should not be allowed to get out of sync with reality
	// Currently called internally on addition to the world
	public native void setSoftBodySolver(btSoftBodySolver softBodySolver);

	//
	// Return the solver that handles this soft body
	//
	public native btSoftBodySolver getSoftBodySolver();

	//
	// Return the solver that handles this soft body
	//

	//
	// Cast
	//

	public static native @Const btSoftBody upcast(@Const btCollisionObject colObj);

	//
	// ::btCollisionObject
	//

	public native void getAabb(@ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);
	//
	// Private
	//
	public native void pointersToIndices();
	public native void indicesToPointers(@Const IntPointer map/*=0*/);
	public native void indicesToPointers();
	public native void indicesToPointers(@Const IntBuffer map/*=0*/);
	public native void indicesToPointers(@Const int[] map/*=0*/);

	public native int rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
					@Cast("btScalar*") @ByRef DoublePointer mint, @Cast("btSoftBody::eFeature::_*") @ByRef IntPointer feature, @ByRef IntPointer index, @Cast("bool") boolean bcountonly);
	public native int rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
					@Cast("btScalar*") @ByRef DoubleBuffer mint, @Cast("btSoftBody::eFeature::_*") @ByRef IntBuffer feature, @ByRef IntBuffer index, @Cast("bool") boolean bcountonly);
	public native int rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo,
					@Cast("btScalar*") @ByRef double[] mint, @Cast("btSoftBody::eFeature::_*") @ByRef int[] feature, @ByRef int[] index, @Cast("bool") boolean bcountonly);
	public native void initializeFaceTree();
	public native void rebuildNodeTree();
	public native @ByVal btVector3 evaluateCom();
	public native @Cast("bool") boolean checkDeformableContact(@Const btCollisionObjectWrapper colObjWrap, @Const @ByRef btVector3 x, @Cast("btScalar") double margin, @ByRef sCti cti, @Cast("bool") boolean predict/*=false*/);
	public native @Cast("bool") boolean checkDeformableContact(@Const btCollisionObjectWrapper colObjWrap, @Const @ByRef btVector3 x, @Cast("btScalar") double margin, @ByRef sCti cti);
	public native @Cast("bool") boolean checkDeformableFaceContact(@Const btCollisionObjectWrapper colObjWrap, @ByRef Face f, @ByRef btVector3 contact_point, @ByRef btVector3 bary, @Cast("btScalar") double margin, @ByRef sCti cti, @Cast("bool") boolean predict/*=false*/);
	public native @Cast("bool") boolean checkDeformableFaceContact(@Const btCollisionObjectWrapper colObjWrap, @ByRef Face f, @ByRef btVector3 contact_point, @ByRef btVector3 bary, @Cast("btScalar") double margin, @ByRef sCti cti);
	public native @Cast("bool") boolean checkContact(@Const btCollisionObjectWrapper colObjWrap, @Const @ByRef btVector3 x, @Cast("btScalar") double margin, @ByRef sCti cti);
	public native void updateNormals();
	public native void updateBounds();
	public native void updatePose();
	public native void updateConstants();
	public native void updateLinkConstants();
	public native void updateArea(@Cast("bool") boolean averageArea/*=true*/);
	public native void updateArea();
	public native void initializeClusters();
	public native void updateClusters();
	public native void cleanupClusters();
	public native void prepareClusters(int iterations);
	public native void solveClusters(@Cast("btScalar") double sor);
	public native void applyClusters(@Cast("bool") boolean drift);
	public native void dampClusters();
	public native void setSpringStiffness(@Cast("btScalar") double k);
	public native void setGravityFactor(@Cast("btScalar") double gravFactor);
	public native void setCacheBarycenter(@Cast("bool") boolean cacheBarycenter);
	public native void initializeDmInverse();
	public native void updateDeformation();
	public native void advanceDeformation();
	public native void applyForces();
	public native void setMaxStress(@Cast("btScalar") double maxStress);
	public native void interpolateRenderMesh();
	public native void setCollisionQuadrature(int N);
	public static native void PSolve_Anchors(btSoftBody psb, @Cast("btScalar") double kst, @Cast("btScalar") double ti);
	public static native void PSolve_RContacts(btSoftBody psb, @Cast("btScalar") double kst, @Cast("btScalar") double ti);
	public static native void PSolve_SContacts(btSoftBody psb, @Cast("btScalar") double arg1, @Cast("btScalar") double ti);
	public static native void PSolve_Links(btSoftBody psb, @Cast("btScalar") double kst, @Cast("btScalar") double ti);
	public static native void VSolve_Links(btSoftBody psb, @Cast("btScalar") double kst);
	public static native psolver_t getSolver(@Cast("btSoftBody::ePSolver::_") int solver);
	public native void geometricCollisionHandler(btSoftBody psb);
// #define SAFE_EPSILON SIMD_EPSILON * 100.0
	public native void updateNode(btDbvtNode node, @Cast("bool") boolean use_velocity, @Cast("bool") boolean margin);

	public native void updateNodeTree(@Cast("bool") boolean use_velocity, @Cast("bool") boolean margin);
	public native void updateFaceTree(@Cast("bool") boolean use_velocity, @Cast("bool") boolean margin);

	public native void applyRepulsionForce(@Cast("btScalar") double timeStep, @Cast("bool") boolean applySpringForce);
	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
