// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.LinearMath;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.LinearMath.*;


/**The HullLibrary class can create a convex hull from a collection of vertices, using the ComputeHull method.
 * The btShapeHull class uses this HullLibrary to create a approximate convex mesh given a general (non-polyhedral) convex shape. */
@Properties(inherit = org.bytedeco.bullet.presets.LinearMath.class)
public class HullLibrary extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public HullLibrary() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public HullLibrary(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HullLibrary(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public HullLibrary position(long position) {
        return (HullLibrary)super.position(position);
    }
    @Override public HullLibrary getPointer(long i) {
        return new HullLibrary((Pointer)this).offsetAddress(i);
    }

	public native @ByRef btIntArray m_vertexIndexMapping(); public native HullLibrary m_vertexIndexMapping(btIntArray setter);

	public native @Cast("HullError") int CreateConvexHull(@Const @ByRef HullDesc desc,
								   @ByRef HullResult result);   // contains the resulst
	public native @Cast("HullError") int ReleaseResult(@ByRef HullResult result);
}
