// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.LinearMath;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.LinearMath.*;


/** Convex hull implementation based on Preparata and Hong
 *  See http://code.google.com/p/bullet/issues/detail?id=275
 *  Ole Kniemeyer, MAXON Computer GmbH */
@Properties(inherit = org.bytedeco.bullet.presets.LinearMath.class)
public class btConvexHullComputer extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public btConvexHullComputer() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btConvexHullComputer(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btConvexHullComputer(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public btConvexHullComputer position(long position) {
        return (btConvexHullComputer)super.position(position);
    }
    @Override public btConvexHullComputer getPointer(long i) {
        return new btConvexHullComputer((Pointer)this).offsetAddress(i);
    }

	public static class Edge extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public Edge() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public Edge(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public Edge(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public Edge position(long position) {
	        return (Edge)super.position(position);
	    }
	    @Override public Edge getPointer(long i) {
	        return new Edge((Pointer)this).offsetAddress(i);
	    }
	
		public native int getSourceVertex();

		public native int getTargetVertex();

		public native @Const Edge getNextEdgeOfVertex();

		public native @Const Edge getNextEdgeOfFace();

		public native @Const Edge getReverseEdge();
	}

	// Vertices of the output hull
	public native @ByRef btVector3Array vertices(); public native btConvexHullComputer vertices(btVector3Array setter);

	// The original vertex index in the input coords array
	public native @ByRef btIntArray original_vertex_index(); public native btConvexHullComputer original_vertex_index(btIntArray setter);

	// Edges of the output hull
	public native @ByRef btConvexHullComputerEdgeArray edges(); public native btConvexHullComputer edges(btConvexHullComputerEdgeArray setter);

	// Faces of the convex hull. Each entry is an index into the "edges" array pointing to an edge of the face. Faces are planar n-gons
	public native @ByRef btIntArray faces(); public native btConvexHullComputer faces(btIntArray setter);

	/*
		Compute convex hull of "count" vertices stored in "coords". "stride" is the difference in bytes
		between the addresses of consecutive vertices. If "shrink" is positive, the convex hull is shrunken
		by that amount (each face is moved by "shrink" length units towards the center along its normal).
		If "shrinkClamp" is positive, "shrink" is clamped to not exceed "shrinkClamp * innerRadius", where "innerRadius"
		is the minimum distance of a face to the center of the convex hull.

		The returned value is the amount by which the hull has been shrunken. If it is negative, the amount was so large
		that the resulting convex hull is empty.

		The output convex hull can be found in the member variables "vertices", "edges", "faces".
		*/
	public native @Cast("btScalar") double compute(@Const FloatPointer coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);
	public native @Cast("btScalar") double compute(@Const FloatBuffer coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);
	public native @Cast("btScalar") double compute(@Const float[] coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);

	// same as above, but double precision
	public native @Cast("btScalar") double compute(@Const DoublePointer coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);
	public native @Cast("btScalar") double compute(@Const DoubleBuffer coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);
	public native @Cast("btScalar") double compute(@Const double[] coords, int stride, int count, @Cast("btScalar") double shrink, @Cast("btScalar") double shrinkClamp);
}
