// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.LinearMath.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class LinearMath extends org.bytedeco.bullet.presets.LinearMath {
    static { Loader.load(); }

// Parsed from LinearMath/btScalar.h

/*
Copyright (c) 2003-2009 Erwin Coumans  http://bullet.googlecode.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SCALAR_H
// #define BT_SCALAR_H

// #ifdef BT_MANAGED_CODE
//Aligned data types not supported in managed code
// #pragma unmanaged
// #endif

// #include <math.h>
// #include <stdlib.h>  //size_t for MSVC 6.0
// #include <float.h>

/* SVN $Revision$ on $Date$ from http://bullet.googlecode.com*/
public static final int BT_BULLET_VERSION = 325;

public static native int btGetVersion();

public static native int btIsDoublePrecision();


// The following macro "BT_NOT_EMPTY_FILE" can be put into a file
// in order suppress the MS Visual C++ Linker warning 4221
//
// warning LNK4221: no public symbols found; archive member will be inaccessible
//
// This warning occurs on PC and XBOX when a file compiles out completely
// has no externally visible symbols which may be dependant on configuration
// #defines and options.
//
// see more https://stackoverflow.com/questions/1822887/what-is-the-best-way-to-eliminate-ms-visual-c-linker-warning-warning-lnk422

// #if defined(_MSC_VER)
// #else
// #define BT_NOT_EMPTY_FILE
// #endif

// clang and most formatting tools don't support indentation of preprocessor guards, so turn it off
// clang-format off
// #if defined(DEBUG) || defined (_DEBUG)
// #endif

// #ifdef _WIN32

// #else//_WIN32
	
// 	#if defined	(__CELLOS_LV2__)

// 	#else//defined	(__CELLOS_LV2__)

// 		#ifdef USE_LIBSPE2
		

// 		#else//USE_LIBSPE2
	//non-windows systems

// 			#if (defined (__APPLE__) && (!defined (BT_USE_DOUBLE_PRECISION)))

// 			#else//__APPLE__

// 				#define SIMD_FORCE_INLINE inline
				/**\todo: check out alignment methods for other platforms/compilers
				 * #define ATTRIBUTE_ALIGNED16(a) a __attribute__ ((aligned (16)))
				 * #define ATTRIBUTE_ALIGNED64(a) a __attribute__ ((aligned (64)))
				 * #define ATTRIBUTE_ALIGNED128(a) a __attribute__ ((aligned (128))) */
// 				#define ATTRIBUTE_ALIGNED16(a) a
// 				#define ATTRIBUTE_ALIGNED64(a) a
// 				#define ATTRIBUTE_ALIGNED128(a) a
// 				#ifndef assert
// 				#include <assert.h>
// 				#endif

// 				#if defined(DEBUG) || defined (_DEBUG)
// 				#else
// 					#define btAssert(x)
// 				#endif

				//btFullAssert is optional, slows down a lot
// 				#define btFullAssert(x)
// 				#define btLikely(_c)  _c
// 				#define btUnlikely(_c) _c
// 			#endif //__APPLE__ 
// 		#endif // LIBSPE2
// 	#endif	//__CELLOS_LV2__
// #endif//_WIN32


/**The btScalar type abstracts floating point numbers, to easily switch between double and single floating point precision. */
// #if defined(BT_USE_DOUBLE_PRECISION)
	//this number could be bigger in double precision
	public static final double BT_LARGE_FLOAT = 1e30;
// #else
// #endif

// #ifdef BT_USE_SSE
// #endif  //BT_USE_SSE

// #if defined(BT_USE_SSE)
// #else//BT_USE_SSE

// 	#ifdef BT_USE_NEON
// 	#else  //BT_USE_NEON

// 	#ifndef BT_INFINITY
// 	#define BT_INFINITY (btInfinityMask.mask)
	
// 	#endif
// 	#endif  //BT_USE_NEON

// #endif  //BT_USE_SSE

// #ifdef BT_USE_NEON
// #endif//BT_USE_NEON

// #define BT_DECLARE_ALIGNED_ALLOCATOR()
// 	SIMD_FORCE_INLINE void *operator new(size_t sizeInBytes) { return btAlignedAlloc(sizeInBytes, 16); }
// 	SIMD_FORCE_INLINE void operator delete(void *ptr) { btAlignedFree(ptr); }
// 	SIMD_FORCE_INLINE void *operator new(size_t, void *ptr) { return ptr; }
// 	SIMD_FORCE_INLINE void operator delete(void *, void *) {}
// 	SIMD_FORCE_INLINE void *operator new[](size_t sizeInBytes) { return btAlignedAlloc(sizeInBytes, 16); }
// 	SIMD_FORCE_INLINE void operator delete[](void *ptr) { btAlignedFree(ptr); }
// 	SIMD_FORCE_INLINE void *operator new[](size_t, void *ptr) { return ptr; }
// 	SIMD_FORCE_INLINE void operator delete[](void *, void *) {}

// #if defined(BT_USE_DOUBLE_PRECISION) || defined(BT_FORCE_DOUBLE_FUNCTIONS)

	public static native @Cast("btScalar") double btSqrt(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btFabs(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btCos(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btSin(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btTan(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btAcos(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btAsin(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btAtan(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btAtan2(@Cast("btScalar") double x, @Cast("btScalar") double y);
	public static native @Cast("btScalar") double btExp(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btLog(@Cast("btScalar") double x);
	public static native @Cast("btScalar") double btPow(@Cast("btScalar") double x, @Cast("btScalar") double y);
	public static native @Cast("btScalar") double btFmod(@Cast("btScalar") double x, @Cast("btScalar") double y);

// #else//BT_USE_DOUBLE_PRECISION

// #endif//BT_USE_DOUBLE_PRECISION

public static native @MemberGetter double SIMD_PI();
public static final double SIMD_PI = SIMD_PI();
public static native @MemberGetter double SIMD_2_PI();
public static final double SIMD_2_PI = SIMD_2_PI();
public static native @MemberGetter double SIMD_HALF_PI();
public static final double SIMD_HALF_PI = SIMD_HALF_PI();
public static native @MemberGetter double SIMD_RADS_PER_DEG();
public static final double SIMD_RADS_PER_DEG = SIMD_RADS_PER_DEG();
public static native @MemberGetter double SIMD_DEGS_PER_RAD();
public static final double SIMD_DEGS_PER_RAD = SIMD_DEGS_PER_RAD();
public static native @MemberGetter double SIMDSQRT12();
public static final double SIMDSQRT12 = SIMDSQRT12();
// #define btRecipSqrt(x) ((btScalar)(btScalar(1.0) / btSqrt(btScalar(x)))) /* reciprocal square root */
// #define btRecip(x) (btScalar(1.0) / btScalar(x))

// #ifdef BT_USE_DOUBLE_PRECISION
// 	#define SIMD_EPSILON DBL_EPSILON
// 	#define SIMD_INFINITY DBL_MAX
	public static final double BT_ONE = 1.0;
	public static final double BT_ZERO = 0.0;
	public static final double BT_TWO = 2.0;
	public static final double BT_HALF = 0.5;
// #else
// #endif

// clang-format on

public static native @Cast("btScalar") double btAtan2Fast(@Cast("btScalar") double y, @Cast("btScalar") double x);

public static native @Cast("bool") boolean btFuzzyZero(@Cast("btScalar") double x);

public static native @Cast("bool") boolean btEqual(@Cast("btScalar") double a, @Cast("btScalar") double eps);
public static native @Cast("bool") boolean btGreaterEqual(@Cast("btScalar") double a, @Cast("btScalar") double eps);

public static native int btIsNegative(@Cast("btScalar") double x);

public static native @Cast("btScalar") double btRadians(@Cast("btScalar") double x);
public static native @Cast("btScalar") double btDegrees(@Cast("btScalar") double x);

// #define BT_DECLARE_HANDLE(name)
// 	typedef struct name##__
// 	{
// 		int unused;
// 	} * name

// #ifndef btFsel
public static native @Cast("btScalar") double btFsel(@Cast("btScalar") double a, @Cast("btScalar") double b, @Cast("btScalar") double c);
// #endif
// #define btFsels(a, b, c) (btScalar) btFsel(a, b, c)

public static native @Cast("bool") boolean btMachineIsLittleEndian();

/**btSelect avoids branches, which makes performance much better for consoles like Playstation 3 and XBox 360
 * Thanks Phil Knight. See also http://www.cellperformance.com/articles/2006/04/more_techniques_for_eliminatin_1.html */
public static native @Cast("unsigned") int btSelect(@Cast("unsigned") int condition, @Cast("unsigned") int valueIfConditionNonZero, @Cast("unsigned") int valueIfConditionZero);
public static native float btSelect(@Cast("unsigned") int condition, float valueIfConditionNonZero, float valueIfConditionZero);

//PCK: endian swapping functions
public static native @Cast("unsigned") int btSwapEndian(@Cast("unsigned") int val);

public static native @Cast("unsigned short") short btSwapEndian(@Cast("unsigned short") short val);

/**btSwapFloat uses using char pointers to swap the endianness
////btSwapFloat/btSwapDouble will NOT return a float, because the machine might 'correct' invalid floating point values
 * Not all values of sign/exponent/mantissa are valid floating point numbers according to IEEE 754.
 * When a floating point unit is faced with an invalid value, it may actually change the value, or worse, throw an exception.
 * In most systems, running user mode code, you wouldn't get an exception, but instead the hardware/os/runtime will 'fix' the number for you.
 * so instead of returning a float/double, we return integer/long long integer */
public static native @Cast("unsigned int") int btSwapEndianFloat(float d);

// unswap using char pointers
public static native float btUnswapEndianFloat(@Cast("unsigned int") int a);

// swap using char pointers
public static native void btSwapEndianDouble(double d, @Cast("unsigned char*") BytePointer dst);
public static native void btSwapEndianDouble(double d, @Cast("unsigned char*") ByteBuffer dst);
public static native void btSwapEndianDouble(double d, @Cast("unsigned char*") byte[] dst);

// unswap using char pointers
public static native double btUnswapEndianDouble(@Cast("const unsigned char*") BytePointer src);
public static native double btUnswapEndianDouble(@Cast("const unsigned char*") ByteBuffer src);
public static native double btUnswapEndianDouble(@Cast("const unsigned char*") byte[] src);

public static native @Cast("btScalar") double btLargeDot(@Cast("const btScalar*") DoublePointer a, @Cast("const btScalar*") DoublePointer b, int n);
public static native @Cast("btScalar") double btLargeDot(@Cast("const btScalar*") DoubleBuffer a, @Cast("const btScalar*") DoubleBuffer b, int n);
public static native @Cast("btScalar") double btLargeDot(@Cast("const btScalar*") double[] a, @Cast("const btScalar*") double[] b, int n);

// returns normalized value in range [-SIMD_PI, SIMD_PI]
public static native @Cast("btScalar") double btNormalizeAngle(@Cast("btScalar") double angleInRadians);
// Targeting ..\LinearMath\btTypedObject.java



/**align a pointer to the provided alignment, upwards */

// #endif  //BT_SCALAR_H


// Parsed from LinearMath/btVector3.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_VECTOR3_H
// #define BT_VECTOR3_H

//#include <stdint.h>
// #include "btScalar.h"
// #include "btMinMax.h"
// #include "btAlignedAllocator.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btVector3Data btVector3DoubleData
public static final String btVector3DataName = "btVector3DoubleData";
// Targeting ..\LinearMath\btVector3.java



/**\brief Return the sum of two vectors (Point symantics)*/
public static native @ByVal @Name("operator +") btVector3 add(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the elementwise product of two vectors */
public static native @ByVal @Name("operator *") btVector3 multiply(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the difference between two vectors */
public static native @ByVal @Name("operator -") btVector3 subtract(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the negative of the vector */
public static native @ByVal @Name("operator -") btVector3 subtract(@Const @ByRef btVector3 v);

/**\brief Return the vector scaled by s */
public static native @ByVal @Name("operator *") btVector3 multiply(@Const @ByRef btVector3 v, @Cast("const btScalar") double s);

/**\brief Return the vector scaled by s */
public static native @ByVal @Name("operator *") btVector3 multiply(@Cast("const btScalar") double s, @Const @ByRef btVector3 v);

/**\brief Return the vector inversely scaled by s */
public static native @ByVal @Name("operator /") btVector3 divide(@Const @ByRef btVector3 v, @Cast("const btScalar") double s);

/**\brief Return the vector inversely scaled by s */
public static native @ByVal @Name("operator /") btVector3 divide(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the dot product between two vectors */
public static native @Cast("btScalar") double btDot(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the distance squared between two vectors */
public static native @Cast("btScalar") double btDistance2(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the distance between two vectors */
public static native @Cast("btScalar") double btDistance(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the angle between two vectors */
public static native @Cast("btScalar") double btAngle(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

/**\brief Return the cross product of two vectors */
public static native @ByVal btVector3 btCross(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2);

public static native @Cast("btScalar") double btTriple(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2, @Const @ByRef btVector3 v3);

/**\brief Return the linear interpolation between two vectors
 * @param v1 One vector 
 * @param v2 The other vector 
 * @param t The ration of this to v (t = 0 => return v1, t=1 => return v2) */
public static native @ByVal btVector3 lerp(@Const @ByRef btVector3 v1, @Const @ByRef btVector3 v2, @Cast("const btScalar") double t);












// Targeting ..\LinearMath\btVector4.java



/**btSwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void btSwapScalarEndian(@Cast("const btScalar") double sourceVal, @Cast("btScalar*") @ByRef DoublePointer destVal);
public static native void btSwapScalarEndian(@Cast("const btScalar") double sourceVal, @Cast("btScalar*") @ByRef DoubleBuffer destVal);
public static native void btSwapScalarEndian(@Cast("const btScalar") double sourceVal, @Cast("btScalar*") @ByRef double[] destVal);
/**btSwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void btSwapVector3Endian(@Const @ByRef btVector3 sourceVec, @ByRef btVector3 destVec);

/**btUnSwapVector3Endian swaps vector endianness, useful for network and cross-platform serialization */
public static native void btUnSwapVector3Endian(@ByRef btVector3 vector);
// Targeting ..\LinearMath\btVector3FloatData.java


// Targeting ..\LinearMath\btVector3DoubleData.java

















// #endif  //BT_VECTOR3_H


// Parsed from LinearMath/btQuadWord.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMD_QUADWORD_H
// #define BT_SIMD_QUADWORD_H

// #include "btScalar.h"
// #include "btMinMax.h"

// #if defined(__CELLOS_LV2) && defined(__SPU__)
// #include <altivec.h>
// Targeting ..\LinearMath\btQuadWord.java



// #endif  //BT_SIMD_QUADWORD_H


// Parsed from LinearMath/btQuaternion.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMD__QUATERNION_H_
// #define BT_SIMD__QUATERNION_H_

// #include "btVector3.h"
// #include "btQuadWord.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btQuaternionData btQuaternionDoubleData
public static final String btQuaternionDataName = "btQuaternionDoubleData";
// Targeting ..\LinearMath\btQuaternion.java



/**\brief Return the product of two quaternions */
public static native @ByVal @Name("operator *") btQuaternion multiply(@Const @ByRef btQuaternion q1, @Const @ByRef btQuaternion q2);

public static native @ByVal @Name("operator *") btQuaternion multiply(@Const @ByRef btQuaternion q, @Const @ByRef btVector3 w);

public static native @ByVal @Name("operator *") btQuaternion multiply(@Const @ByRef btVector3 w, @Const @ByRef btQuaternion q);

/**\brief Calculate the dot product between two quaternions */
public static native @Cast("btScalar") double dot(@Const @ByRef btQuaternion q1, @Const @ByRef btQuaternion q2);

/**\brief Return the length of a quaternion */
public static native @Cast("btScalar") double length(@Const @ByRef btQuaternion q);

/**\brief Return the angle between two quaternions*/
public static native @Cast("btScalar") double btAngle(@Const @ByRef btQuaternion q1, @Const @ByRef btQuaternion q2);

/**\brief Return the inverse of a quaternion*/
public static native @ByVal btQuaternion inverse(@Const @ByRef btQuaternion q);

/**\brief Return the result of spherical linear interpolation betwen two quaternions 
 * @param q1 The first quaternion
 * @param q2 The second quaternion 
 * @param t The ration between q1 and q2.  t = 0 return q1, t=1 returns q2 
 * Slerp assumes constant velocity between positions. */
public static native @ByVal btQuaternion slerp(@Const @ByRef btQuaternion q1, @Const @ByRef btQuaternion q2, @Cast("const btScalar") double t);

public static native @ByVal btVector3 quatRotate(@Const @ByRef btQuaternion rotation, @Const @ByRef btVector3 v);

public static native @ByVal btQuaternion shortestArcQuat(@Const @ByRef btVector3 v0, @Const @ByRef btVector3 v1);

public static native @ByVal btQuaternion shortestArcQuatNormalize2(@ByRef btVector3 v0, @ByRef btVector3 v1);
// Targeting ..\LinearMath\btQuaternionFloatData.java


// Targeting ..\LinearMath\btQuaternionDoubleData.java

















// #endif  //BT_SIMD__QUATERNION_H_


// Parsed from LinearMath/btMatrix3x3.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MATRIX3x3_H
// #define BT_MATRIX3x3_H

// #include "btVector3.h"
// #include "btQuaternion.h"
// #include <stdio.h>

// #ifdef BT_USE_SSE
// #endif

// #if defined(BT_USE_SSE)
// #elif defined(BT_USE_NEON)
// #endif

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btMatrix3x3Data btMatrix3x3DoubleData
// Targeting ..\LinearMath\btMatrix3x3.java







public static native @ByVal @Name("operator *") btMatrix3x3 multiply(@Const @ByRef btMatrix3x3 m, @Cast("const btScalar") double k);

public static native @ByVal @Name("operator +") btMatrix3x3 add(@Const @ByRef btMatrix3x3 m1, @Const @ByRef btMatrix3x3 m2);

public static native @ByVal @Name("operator -") btMatrix3x3 subtract(@Const @ByRef btMatrix3x3 m1, @Const @ByRef btMatrix3x3 m2);

















public static native @ByVal @Name("operator *") btVector3 multiply(@Const @ByRef btMatrix3x3 m, @Const @ByRef btVector3 v);

public static native @ByVal @Name("operator *") btVector3 multiply(@Const @ByRef btVector3 v, @Const @ByRef btMatrix3x3 m);

public static native @ByVal @Name("operator *") btMatrix3x3 multiply(@Const @ByRef btMatrix3x3 m1, @Const @ByRef btMatrix3x3 m2);

/*
SIMD_FORCE_INLINE btMatrix3x3 btMultTransposeLeft(const btMatrix3x3& m1, const btMatrix3x3& m2) {
return btMatrix3x3(
m1[0][0] * m2[0][0] + m1[1][0] * m2[1][0] + m1[2][0] * m2[2][0],
m1[0][0] * m2[0][1] + m1[1][0] * m2[1][1] + m1[2][0] * m2[2][1],
m1[0][0] * m2[0][2] + m1[1][0] * m2[1][2] + m1[2][0] * m2[2][2],
m1[0][1] * m2[0][0] + m1[1][1] * m2[1][0] + m1[2][1] * m2[2][0],
m1[0][1] * m2[0][1] + m1[1][1] * m2[1][1] + m1[2][1] * m2[2][1],
m1[0][1] * m2[0][2] + m1[1][1] * m2[1][2] + m1[2][1] * m2[2][2],
m1[0][2] * m2[0][0] + m1[1][2] * m2[1][0] + m1[2][2] * m2[2][0],
m1[0][2] * m2[0][1] + m1[1][2] * m2[1][1] + m1[2][2] * m2[2][1],
m1[0][2] * m2[0][2] + m1[1][2] * m2[1][2] + m1[2][2] * m2[2][2]);
}
*/

/**\brief Equality operator between two matrices
* It will test all elements are equal.  */
public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef btMatrix3x3 m1, @Const @ByRef btMatrix3x3 m2);
// Targeting ..\LinearMath\btMatrix3x3FloatData.java


// Targeting ..\LinearMath\btMatrix3x3DoubleData.java













// #endif  //BT_MATRIX3x3_H


// Parsed from LinearMath/btTransform.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRANSFORM_H
// #define BT_TRANSFORM_H

// #include "btMatrix3x3.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btTransformData btTransformDoubleData
// Targeting ..\LinearMath\btTransform.java









/**\brief Test if two transforms have all elements equal */
public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef btTransform t1, @Const @ByRef btTransform t2);
// Targeting ..\LinearMath\btTransformFloatData.java


// Targeting ..\LinearMath\btTransformDoubleData.java













// #endif  //BT_TRANSFORM_H


// Parsed from LinearMath/btAlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBJECT_ARRAY__
// #define BT_OBJECT_ARRAY__

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE
// #include "btAlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable BT_USE_PLACEMENT_NEW
 * then the btAlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable BT_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int BT_USE_PLACEMENT_NEW = 1;
//#define BT_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define BT_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef BT_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //BT_USE_MEMCPY

// #ifdef BT_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\LinearMath\btBoolArray.java


// Targeting ..\LinearMath\btCharArray.java


// Targeting ..\LinearMath\btIntArray.java


// Targeting ..\LinearMath\btUIntArray.java


// Targeting ..\LinearMath\btFloatArray.java


// Targeting ..\LinearMath\btDoubleArray.java


// Targeting ..\LinearMath\btScalarArray.java


// Targeting ..\LinearMath\btMatrix3x3Array.java


// Targeting ..\LinearMath\btQuaternionArray.java


// Targeting ..\LinearMath\btVector3Array.java


// Targeting ..\LinearMath\btVector4Array.java


// Targeting ..\LinearMath\btPlaneArray.java


// Targeting ..\LinearMath\btConvexHHalfEdgeArray.java


// Targeting ..\LinearMath\btConvexHullComputerEdgeArray.java


// Targeting ..\LinearMath\btIntArrayArray.java


// Targeting ..\LinearMath\btUnsignedIntArrayArray.java


// Targeting ..\LinearMath\btDoubleArrayArray.java



// #endif  //BT_OBJECT_ARRAY__


// Parsed from LinearMath/btHashMap.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_HASH_MAP_H
// #define BT_HASH_MAP_H

// #include <string>
// #include "btAlignedObjectArray.h"
// Targeting ..\LinearMath\btHashString.java



@MemberGetter public static native int BT_HASH_NULL();
// Targeting ..\LinearMath\btHashInt.java


// Targeting ..\LinearMath\btHashPtr.java


// Targeting ..\LinearMath\btHashMap_btHashPtr_voidPointer.java


// Targeting ..\LinearMath\btHashMap_btHashInt_btVector3Array.java



// #endif  //BT_HASH_MAP_H


// Parsed from LinearMath/btSerializer.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SERIALIZER_H
// #define BT_SERIALIZER_H

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE
// #include "btHashMap.h"

// #if !defined(__CELLOS_LV2__) && !defined(__MWERKS__)
// #include <memory.h>
// #endif
// #include <string.h>

public static native @Cast("char") byte sBulletDNAstr(int i); public static native void sBulletDNAstr(int i, byte setter);
@MemberGetter public static native @Cast("char*") BytePointer sBulletDNAstr();
public static native int sBulletDNAlen(); public static native void sBulletDNAlen(int setter);
public static native @Cast("char") byte sBulletDNAstr64(int i); public static native void sBulletDNAstr64(int i, byte setter);
@MemberGetter public static native @Cast("char*") BytePointer sBulletDNAstr64();
public static native int sBulletDNAlen64(); public static native void sBulletDNAlen64(int setter);

public static native int btStrLen(@Cast("const char*") BytePointer str);
public static native int btStrLen(String str);
// Targeting ..\LinearMath\btChunk.java



/** enum btSerializationFlags */
public static final int
	BT_SERIALIZE_NO_BVH = 1,
	BT_SERIALIZE_NO_TRIANGLEINFOMAP = 2,
	BT_SERIALIZE_NO_DUPLICATE_ASSERT = 4,
	BT_SERIALIZE_CONTACT_MANIFOLDS = 8;
// Targeting ..\LinearMath\btSerializer.java



public static final int BT_HEADER_LENGTH = 12;
// #if defined(__sgi) || defined(__sparc) || defined(__sparc__) || defined(__PPC__) || defined(__ppc__) || defined(__BIG_ENDIAN__)
// #define BT_MAKE_ID(a, b, c, d) ((int)(a) << 24 | (int)(b) << 16 | (c) << 8 | (d))
// #else
// #define BT_MAKE_ID(a, b, c, d) ((int)(d) << 24 | (int)(c) << 16 | (b) << 8 | (a))
// #endif

public static native @MemberGetter int BT_MULTIBODY_CODE();
public static final int BT_MULTIBODY_CODE = BT_MULTIBODY_CODE();
public static native @MemberGetter int BT_MB_LINKCOLLIDER_CODE();
public static final int BT_MB_LINKCOLLIDER_CODE = BT_MB_LINKCOLLIDER_CODE();
public static native @MemberGetter int BT_SOFTBODY_CODE();
public static final int BT_SOFTBODY_CODE = BT_SOFTBODY_CODE();
public static native @MemberGetter int BT_COLLISIONOBJECT_CODE();
public static final int BT_COLLISIONOBJECT_CODE = BT_COLLISIONOBJECT_CODE();
public static native @MemberGetter int BT_RIGIDBODY_CODE();
public static final int BT_RIGIDBODY_CODE = BT_RIGIDBODY_CODE();
public static native @MemberGetter int BT_CONSTRAINT_CODE();
public static final int BT_CONSTRAINT_CODE = BT_CONSTRAINT_CODE();
public static native @MemberGetter int BT_BOXSHAPE_CODE();
public static final int BT_BOXSHAPE_CODE = BT_BOXSHAPE_CODE();
public static native @MemberGetter int BT_QUANTIZED_BVH_CODE();
public static final int BT_QUANTIZED_BVH_CODE = BT_QUANTIZED_BVH_CODE();
public static native @MemberGetter int BT_TRIANLGE_INFO_MAP();
public static final int BT_TRIANLGE_INFO_MAP = BT_TRIANLGE_INFO_MAP();
public static native @MemberGetter int BT_SHAPE_CODE();
public static final int BT_SHAPE_CODE = BT_SHAPE_CODE();
public static native @MemberGetter int BT_ARRAY_CODE();
public static final int BT_ARRAY_CODE = BT_ARRAY_CODE();
public static native @MemberGetter int BT_SBMATERIAL_CODE();
public static final int BT_SBMATERIAL_CODE = BT_SBMATERIAL_CODE();
public static native @MemberGetter int BT_SBNODE_CODE();
public static final int BT_SBNODE_CODE = BT_SBNODE_CODE();
public static native @MemberGetter int BT_DYNAMICSWORLD_CODE();
public static final int BT_DYNAMICSWORLD_CODE = BT_DYNAMICSWORLD_CODE();
public static native @MemberGetter int BT_CONTACTMANIFOLD_CODE();
public static final int BT_CONTACTMANIFOLD_CODE = BT_CONTACTMANIFOLD_CODE();
public static native @MemberGetter int BT_DNA_CODE();
public static final int BT_DNA_CODE = BT_DNA_CODE();
// Targeting ..\LinearMath\btPointerUid.java


// Targeting ..\LinearMath\btDefaultSerializer.java



/**In general it is best to use btDefaultSerializer,
 * in particular when writing the data to disk or sending it over the network.
 * The btInMemorySerializer is experimental and only suitable in a few cases.
 * The btInMemorySerializer takes a shortcut and can be useful to create a deep-copy
 * of objects. There will be a demo on how to use the btInMemorySerializer. */
// #ifdef ENABLE_INMEMORY_SERIALIZER
// #endif  //ENABLE_INMEMORY_SERIALIZER

// #endif  //BT_SERIALIZER_H


// Parsed from LinearMath/btIDebugDraw.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_IDEBUG_DRAW__H
// #define BT_IDEBUG_DRAW__H

// #include "btVector3.h"
// #include "btTransform.h"
// Targeting ..\LinearMath\btIDebugDraw.java



// #endif  //BT_IDEBUG_DRAW__H


// Parsed from LinearMath/btQuickprof.h


/***************************************************************************************************
**
** Real-Time Hierarchical Profiling for Game Programming Gems 3
**
** by Greg Hjelstrom & Byon Garrabrant
**
***************************************************************************************************/

// Credits: The Clock class was inspired by the Timer classes in
// Ogre (www.ogre3d.org).

// #ifndef BT_QUICK_PROF_H
// #define BT_QUICK_PROF_H

// #include "btScalar.h"
public static final int USE_BT_CLOCK = 1;
// Targeting ..\LinearMath\btClock.java


// Targeting ..\LinearMath\btEnterProfileZoneFunc.java


// Targeting ..\LinearMath\btLeaveProfileZoneFunc.java



public static native btEnterProfileZoneFunc btGetCurrentEnterProfileZoneFunc();
public static native btLeaveProfileZoneFunc btGetCurrentLeaveProfileZoneFunc();

public static native void btSetCustomEnterProfileZoneFunc(btEnterProfileZoneFunc enterFunc);
public static native void btSetCustomLeaveProfileZoneFunc(btLeaveProfileZoneFunc leaveFunc);

// #ifndef BT_ENABLE_PROFILE
public static final int BT_NO_PROFILE = 1;
// #endif  //BT_NO_PROFILE

@MemberGetter public static native @Cast("const unsigned int") int BT_QUICKPROF_MAX_THREAD_COUNT();

//btQuickprofGetCurrentThreadIndex will return -1 if thread index cannot be determined,
//otherwise returns thread index in range [0..maxThreads]
public static native @Cast("unsigned int") int btQuickprofGetCurrentThreadIndex2();
// Targeting ..\LinearMath\CProfileSample.java



// #define BT_PROFILE(name) CProfileSample __profile(name)

// #endif  //BT_QUICK_PROF_H


// Parsed from LinearMath/btMotionState.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MOTIONSTATE_H
// #define BT_MOTIONSTATE_H

// #include "btTransform.h"
// Targeting ..\LinearMath\btMotionState.java



// #endif  //BT_MOTIONSTATE_H


// Parsed from LinearMath/btDefaultMotionState.h

// #ifndef BT_DEFAULT_MOTION_STATE_H
// #define BT_DEFAULT_MOTION_STATE_H

// #include "btMotionState.h"
// Targeting ..\LinearMath\btDefaultMotionState.java



// #endif  //BT_DEFAULT_MOTION_STATE_H


// Parsed from LinearMath/btSpatialAlgebra.h

/*
Copyright (c) 2003-2015 Erwin Coumans, Jakub Stepien

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**These spatial algebra classes are used for btMultiBody,
/**see BulletDynamics/Featherstone */

// #ifndef BT_SPATIAL_ALGEBRA_H
// #define BT_SPATIAL_ALGEBRA_H

// #include "btMatrix3x3.h"
// Targeting ..\LinearMath\btSpatialForceVector.java


// Targeting ..\LinearMath\btSpatialMotionVector.java


// Targeting ..\LinearMath\btSymmetricSpatialDyad.java


// Targeting ..\LinearMath\btSpatialTransformationMatrix.java



// #endif  //BT_SPATIAL_ALGEBRA_H


// Parsed from LinearMath/btPoolAllocator.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef _BT_POOL_ALLOCATOR_H
// #define _BT_POOL_ALLOCATOR_H

// #include "btScalar.h"
// #include "btAlignedAllocator.h"
// #include "btThreads.h"
// Targeting ..\LinearMath\btPoolAllocator.java



// #endif  //_BT_POOL_ALLOCATOR_H


// Parsed from LinearMath/btStackAlloc.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
StackAlloc extracted from GJK-EPA collision solver by Nathanael Presson
Nov.2006
*/

// #ifndef BT_STACK_ALLOC
// #define BT_STACK_ALLOC

// #include "btScalar.h"  //for btAssert
// #include "btAlignedAllocator.h"
// Targeting ..\LinearMath\btBlock.java


// Targeting ..\LinearMath\btStackAlloc.java



// #endif  //BT_STACK_ALLOC


// Parsed from LinearMath/TaskScheduler/btThreadSupportInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2018 Erwin Coumans  http://bulletphysics.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_THREAD_SUPPORT_INTERFACE_H
// #define BT_THREAD_SUPPORT_INTERFACE_H
// Targeting ..\LinearMath\btCriticalSection.java


// Targeting ..\LinearMath\btThreadSupportInterface.java



// #endif  //BT_THREAD_SUPPORT_INTERFACE_H


// Parsed from LinearMath/btThreads.h

/*
Copyright (c) 2003-2014 Erwin Coumans  http://bullet.googlecode.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_THREADS_H
// #define BT_THREADS_H

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE

// #if defined(_MSC_VER) && _MSC_VER >= 1600
// give us a compile error if any signatures of overriden methods is changed
// #define BT_OVERRIDE override
// #endif

// #ifndef BT_OVERRIDE
// #define BT_OVERRIDE
// #endif

// Don't set this to larger than 64, without modifying btThreadSupportPosix
// and btThreadSupportWin32. They use UINT64 bit-masks.
@MemberGetter public static native @Cast("const unsigned int") int BT_MAX_THREAD_COUNT();  // only if BT_THREADSAFE is 1

// for internal use only
public static native @Cast("bool") boolean btIsMainThread();
public static native @Cast("bool") boolean btThreadsAreRunning();
public static native @Cast("unsigned int") int btGetCurrentThreadIndex();


///
///
public static native void btResetThreadIndexCounter();
// Targeting ..\LinearMath\btSpinMutex.java



//
// NOTE: btMutex* is for internal Bullet use only
//
// If BT_THREADSAFE is undefined or 0, should optimize away to nothing.
// This is good because for the single-threaded build of Bullet, any calls
// to these functions will be optimized out.
//
// However, for users of the multi-threaded build of Bullet this is kind
// of bad because if you call any of these functions from external code
// (where BT_THREADSAFE is undefined) you will get unexpected race conditions.
//
public static native void btMutexLock(btSpinMutex mutex);

public static native void btMutexUnlock(btSpinMutex mutex);

public static native @Cast("bool") boolean btMutexTryLock(btSpinMutex mutex);
// Targeting ..\LinearMath\btIParallelForBody.java


// Targeting ..\LinearMath\btIParallelSumBody.java


// Targeting ..\LinearMath\btITaskScheduler.java



// set the task scheduler to use for all calls to btParallelFor()
// NOTE: you must set this prior to using any of the multi-threaded "Mt" classes
public static native void btSetTaskScheduler(btITaskScheduler ts);

// get the current task scheduler
public static native btITaskScheduler btGetTaskScheduler();

// get non-threaded task scheduler (always available)
public static native btITaskScheduler btGetSequentialTaskScheduler();

// create a default task scheduler (Win32 or pthreads based)
public static native btITaskScheduler btCreateDefaultTaskScheduler();

// get OpenMP task scheduler (if available, otherwise returns null)
public static native btITaskScheduler btGetOpenMPTaskScheduler();

// get Intel TBB task scheduler (if available, otherwise returns null)
public static native btITaskScheduler btGetTBBTaskScheduler();

// get PPL task scheduler (if available, otherwise returns null)
public static native btITaskScheduler btGetPPLTaskScheduler();

// btParallelFor -- call this to dispatch work like a for-loop
//                 (iterations may be done out of order, so no dependencies are allowed)
public static native void btParallelFor(int iBegin, int iEnd, int grainSize, @Const @ByRef btIParallelForBody body);

// btParallelSum -- call this to dispatch work like a for-loop, returns the sum of all iterations
//                 (iterations may be done out of order, so no dependencies are allowed)
public static native @Cast("btScalar") double btParallelSum(int iBegin, int iEnd, int grainSize, @Const @ByRef btIParallelSumBody body);

// #endif


// Parsed from LinearMath/btAlignedAllocator.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_ALIGNED_ALLOCATOR
// #define BT_ALIGNED_ALLOCATOR

/**we probably replace this with our own aligned memory allocator
 * so we replace _aligned_malloc and _aligned_free with our own
 * that is better portable and more predictable */

// #include "btScalar.h"

/**BT_DEBUG_MEMORY_ALLOCATIONS preprocessor can be set in build system
 * for regression tests to detect memory leaks
 * #define BT_DEBUG_MEMORY_ALLOCATIONS 1 */
// #ifdef BT_DEBUG_MEMORY_ALLOCATIONS

// #else
public static native Pointer btAlignedAllocInternal(@Cast("size_t") long size, int alignment);
public static native void btAlignedFreeInternal(Pointer ptr);

// #define btAlignedAlloc(size, alignment) btAlignedAllocInternal(size, alignment)
// #define btAlignedFree(ptr) btAlignedFreeInternal(ptr)

// #endif
// Targeting ..\LinearMath\btAlignedAllocFunc.java


// Targeting ..\LinearMath\btAlignedFreeFunc.java


// Targeting ..\LinearMath\btAllocFunc.java


// Targeting ..\LinearMath\btFreeFunc.java



/**The developer can let all Bullet memory allocations go through a custom memory allocator, using btAlignedAllocSetCustom */
public static native void btAlignedAllocSetCustom(btAllocFunc allocFunc, btFreeFunc freeFunc);
/**If the developer has already an custom aligned allocator, then btAlignedAllocSetCustomAligned can be used. The default aligned allocator pre-allocates extra memory using the non-aligned allocator, and instruments it. */
public static native void btAlignedAllocSetCustomAligned(btAlignedAllocFunc allocFunc, btAlignedFreeFunc freeFunc);

/**The btAlignedAllocator is a portable class for aligned memory allocations.
 * Default implementations for unaligned and aligned allocations can be overridden by a custom allocator using btAlignedAllocSetCustom and btAlignedAllocSetCustomAligned. */

// #endif  //BT_ALIGNED_ALLOCATOR


// Parsed from LinearMath/btConvexHull.h


/*
Stan Melax Convex Hull Computation
Copyright (c) 2008 Stan Melax http://www.melax.com/

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**includes modifications/improvements by John Ratcliff, see BringOutYourDead below. */

// #ifndef BT_CD_HULL_H
// #define BT_CD_HULL_H

// #include "btVector3.h"
// #include "btAlignedObjectArray.h"
// Targeting ..\LinearMath\HullResult.java



/** enum HullFlag */
public static final int
	QF_TRIANGLES = (1 << 0),      // report results as triangles, not polygons.
	QF_REVERSE_ORDER = (1 << 1),  // reverse order of the triangle indices.
	QF_DEFAULT = QF_TRIANGLES;
// Targeting ..\LinearMath\HullDesc.java



/** enum HullError */
public static final int
	QE_OK = 0,   // success!
	QE_FAIL = 1;  // failed.
// Targeting ..\LinearMath\btPlane.java


// Targeting ..\LinearMath\ConvexH.java


// Targeting ..\LinearMath\Int4.java


// Targeting ..\LinearMath\PHullResult.java


// Targeting ..\LinearMath\HullLibrary.java



// #endif  //BT_CD_HULL_H


// Parsed from LinearMath/btConvexHullComputer.h

/*
Copyright (c) 2011 Ole Kniemeyer, MAXON, www.maxon.net

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_HULL_COMPUTER_H
// #define BT_CONVEX_HULL_COMPUTER_H

// #include "btVector3.h"
// #include "btAlignedObjectArray.h"
// Targeting ..\LinearMath\btConvexHullComputer.java



// #endif  //BT_CONVEX_HULL_COMPUTER_H


// Parsed from LinearMath/btGeometryUtil.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GEOMETRY_UTIL_H
// #define BT_GEOMETRY_UTIL_H

// #include "btVector3.h"
// #include "btAlignedObjectArray.h"
// Targeting ..\LinearMath\btGeometryUtil.java



// #endif  //BT_GEOMETRY_UTIL_H


// Parsed from LinearMath/btMinMax.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GEN_MINMAX_H
// #define BT_GEN_MINMAX_H

// #include "btScalar.h"

// #endif  //BT_GEN_MINMAX_H


// Parsed from LinearMath/btTransformUtil.h

/*
Copyright (c) 2003-2006 Gino van den Bergen / Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRANSFORM_UTIL_H
// #define BT_TRANSFORM_UTIL_H

// #include "btTransform.h"
public static native @MemberGetter double ANGULAR_MOTION_THRESHOLD();
public static final double ANGULAR_MOTION_THRESHOLD = ANGULAR_MOTION_THRESHOLD();

public static native @ByVal btVector3 btAabbSupport(@Const @ByRef btVector3 halfExtents, @Const @ByRef btVector3 supportDir);
// Targeting ..\LinearMath\btTransformUtil.java


// Targeting ..\LinearMath\btConvexSeparatingDistanceUtil.java



// #endif  //BT_TRANSFORM_UTIL_H


// Parsed from LinearMath/btMatrixX.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_MATRIX_X_H
// #define BT_MATRIX_X_H

// #include "LinearMath/btQuickprof.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include <stdio.h>
// Targeting ..\LinearMath\btIntSortPredicate.java


// Targeting ..\LinearMath\btVectorXf.java


// Targeting ..\LinearMath\btVectorXd.java


// Targeting ..\LinearMath\btMatrixXf.java


// Targeting ..\LinearMath\btMatrixXd.java



// #ifdef BT_DEBUG_OSTREAM

// #endif  //BT_DEBUG_OSTREAM

public static native void setElem(@ByRef btMatrixXd mat, int row, int col, double val);

public static native void setElem(@ByRef btMatrixXf mat, int row, int col, float val);

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btVectorXu btVectorXd
// #define btMatrixXu btMatrixXd
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

// #endif  //BT_MATRIX_H_H


}
