// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.caffe;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;

import static org.bytedeco.caffe.global.caffe.*;


/**
 * \brief A generalization of MultinomialLogisticLossLayer that takes an
 *        "information gain" (infogain) matrix specifying the "value" of all label
 *        pairs.
 *
 * Equivalent to the MultinomialLogisticLossLayer if the infogain matrix is the
 * identity.
 *
 * @param bottom input Blob vector (length 2-3)
 *   -# {@code  (N \times C \times H \times W) }
 *      the predictions {@code  \hat{p} }, a Blob with values in
 *      {@code  [0, 1] } indicating the predicted probability of each of the
 *      {@code  K = CHW } classes.  Each prediction vector {@code  \hat{p}_n }
 *      should sum to 1 as in a probability distribution: {@code 
 *      \forall n \sum\limits_{k=1}^K \hat{p}_{nk} = 1 }.
 *   -# {@code  (N \times 1 \times 1 \times 1) }
 *      the labels {@code  l }, an integer-valued Blob with values
 *      {@code  l_n \in [0, 1, 2, ..., K - 1] }
 *      indicating the correct class label among the {@code  K } classes
 *   -# {@code  (1 \times 1 \times K \times K) }
 *      (\b optional) the infogain matrix {@code  H }.  This must be provided as
 *      the third bottom blob input if not provided as the infogain_mat in the
 *      InfogainLossParameter. If {@code  H = I }, this layer is equivalent to the
 *      MultinomialLogisticLossLayer.
 * @param top output Blob vector (length 1)
 *   -# {@code  (1 \times 1 \times 1 \times 1) }
 *      the computed infogain multinomial logistic loss: {@code  E =
 *        \frac{-1}{N} \sum\limits_{n=1}^N H_{l_n} \log(\hat{p}_n) =
 *        \frac{-1}{N} \sum\limits_{n=1}^N \sum\limits_{k=1}^{K} H_{l_n,k}
 *        \log(\hat{p}_{n,k})
 *      }, where {@code  H_{l_n} } denotes row {@code l_n} of {@code H}.
 */
@Name("caffe::InfogainLossLayer<float>") @NoOffset @Properties(inherit = org.bytedeco.caffe.presets.caffe.class)
public class FloatInfogainLossLayer extends FloatLossLayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FloatInfogainLossLayer(Pointer p) { super(p); }

  public FloatInfogainLossLayer(@Const @ByRef LayerParameter param) { super((Pointer)null); allocate(param); }
  private native void allocate(@Const @ByRef LayerParameter param);
  @Virtual public native void LayerSetUp(@Const @ByRef FloatBlobVector bottom,
        @Const @ByRef FloatBlobVector top);
  @Virtual public native void Reshape(@Const @ByRef FloatBlobVector bottom,
        @Const @ByRef FloatBlobVector top);

  // InfogainLossLayer takes 2-3 bottom Blobs; if there are 3 the third should
  // be the infogain matrix.  (Otherwise the infogain matrix is loaded from a
  // file specified by LayerParameter.)
  @Virtual public native @Const({false, false, true}) int ExactNumBottomBlobs();
  @Virtual public native @Const({false, false, true}) int MinBottomBlobs();
  @Virtual public native @Const({false, false, true}) int MaxBottomBlobs();

  // InfogainLossLayer computes softmax prob internally.
  // optional second "top" outputs the softmax prob
  @Virtual public native @Const({false, false, true}) int ExactNumTopBlobs();
  @Virtual public native @Const({false, false, true}) int MinTopBlobs();
  @Virtual public native @Const({false, false, true}) int MaxTopBlobs();

  @Virtual public native @Const({false, false, true}) @Cast("const char*") BytePointer type();
  @Virtual protected native void Forward_cpu(@Const @ByRef FloatBlobVector bottom,
        @Const @ByRef FloatBlobVector top);
  @Virtual protected native void Backward_cpu(@Const @ByRef FloatBlobVector top,
        @Const @ByRef BoolVector propagate_down, @Const @ByRef FloatBlobVector bottom);
  @Virtual protected native float get_normalizer(
        @Cast("caffe::LossParameter_NormalizationMode") int normalization_mode, int valid_count);
  @Virtual protected native void sum_rows_of_H(@Const FloatBlob H);
}
