// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.caffe;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.hdf5.*;
import static org.bytedeco.hdf5.global.hdf5.*;

import static org.bytedeco.caffe.global.caffe.*;

@Name("caffe::Net<double>") @NoOffset @Properties(inherit = org.bytedeco.caffe.presets.caffe.class)
public class DoubleNet extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DoubleNet(Pointer p) { super(p); }

  public DoubleNet(@Const @ByRef NetParameter param) { super((Pointer)null); allocate(param); }
  private native void allocate(@Const @ByRef NetParameter param);
  public DoubleNet(@StdString BytePointer param_file, @Cast("caffe::Phase") int phase,
        int level/*=0*/, @Const StringVector stages/*=NULL*/) { super((Pointer)null); allocate(param_file, phase, level, stages); }
  private native void allocate(@StdString BytePointer param_file, @Cast("caffe::Phase") int phase,
        int level/*=0*/, @Const StringVector stages/*=NULL*/);
  public DoubleNet(@StdString BytePointer param_file, @Cast("caffe::Phase") int phase) { super((Pointer)null); allocate(param_file, phase); }
  private native void allocate(@StdString BytePointer param_file, @Cast("caffe::Phase") int phase);
  public DoubleNet(@StdString String param_file, @Cast("caffe::Phase") int phase,
        int level/*=0*/, @Const StringVector stages/*=NULL*/) { super((Pointer)null); allocate(param_file, phase, level, stages); }
  private native void allocate(@StdString String param_file, @Cast("caffe::Phase") int phase,
        int level/*=0*/, @Const StringVector stages/*=NULL*/);
  public DoubleNet(@StdString String param_file, @Cast("caffe::Phase") int phase) { super((Pointer)null); allocate(param_file, phase); }
  private native void allocate(@StdString String param_file, @Cast("caffe::Phase") int phase);

  /** \brief Initialize a network with a NetParameter. */
  public native void Init(@Const @ByRef NetParameter param);

  /**
   * \brief Run Forward and return the result.
   *
   */
  public native @Const @ByRef DoubleBlobVector Forward(DoublePointer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector Forward();
  public native @Const @ByRef DoubleBlobVector Forward(DoubleBuffer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector Forward(double[] loss/*=NULL*/);
  /** \brief DEPRECATED; use Forward() instead. */
  public native @Const @ByRef DoubleBlobVector ForwardPrefilled(DoublePointer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector ForwardPrefilled();
  public native @Const @ByRef DoubleBlobVector ForwardPrefilled(DoubleBuffer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector ForwardPrefilled(double[] loss/*=NULL*/);

  /**
   * The From and To variants of Forward and Backward operate on the
   * (topological) ordering by which the net is specified. For general DAG
   * networks, note that (1) computing from one layer to another might entail
   * extra computation on unrelated branches, and (2) computation starting in
   * the middle may be incorrect if all of the layers of a fan-in are not
   * included.
   */
  public native double ForwardFromTo(int start, int end);
  public native double ForwardFrom(int start);
  public native double ForwardTo(int end);
  /** \brief DEPRECATED; set input blobs then use Forward() instead. */
  public native @Const @ByRef DoubleBlobVector Forward(@Const @ByRef DoubleBlobVector bottom,
        DoublePointer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector Forward(@Const @ByRef DoubleBlobVector bottom);
  public native @Const @ByRef DoubleBlobVector Forward(@Const @ByRef DoubleBlobVector bottom,
        DoubleBuffer loss/*=NULL*/);
  public native @Const @ByRef DoubleBlobVector Forward(@Const @ByRef DoubleBlobVector bottom,
        double[] loss/*=NULL*/);

  /**
   * \brief Zeroes out the diffs of all net parameters.
   *        Should be run before Backward.
   */
  public native void ClearParamDiffs();

  /**
   * The network backward should take no input and output, since it solely
   * computes the gradient w.r.t the parameters, and the data has already been
   * provided during the forward pass.
   */
  public native void Backward();
  public native void BackwardFromTo(int start, int end);
  public native void BackwardFrom(int start);
  public native void BackwardTo(int end);

  /**
   * \brief Reshape all layers from bottom to top.
   *
   * This is useful to propagate changes to layer sizes without running
   * a forward pass, e.g. to compute output feature size.
   */
  public native void Reshape();

  public native double ForwardBackward();

  /** \brief Updates the network weights based on the diff values computed. */
  public native void Update();
  /**
   * \brief Shares weight data of owner blobs with shared blobs.
   *
   * Note: this is called by Net::Init, and thus should normally not be
   * called manually.
   */
  public native void ShareWeights();

  /**
   * \brief For an already initialized net, implicitly copies (i.e., using no
   *        additional memory) the pre-trained layers from another Net.
   */
  public native void ShareTrainedLayersWith(@Const DoubleNet other);
  // For an already initialized net, CopyTrainedLayersFrom() copies the already
  // trained layers from another net parameter instance.
  /**
   * \brief For an already initialized net, copies the pre-trained layers from
   *        another Net.
   */
  public native void CopyTrainedLayersFrom(@Const @ByRef NetParameter param);
  public native void CopyTrainedLayersFrom(@StdString BytePointer trained_filename);
  public native void CopyTrainedLayersFrom(@StdString String trained_filename);
  public native void CopyTrainedLayersFromBinaryProto(@StdString BytePointer trained_filename);
  public native void CopyTrainedLayersFromBinaryProto(@StdString String trained_filename);
  public native void CopyTrainedLayersFromHDF5(@StdString BytePointer trained_filename);
  public native void CopyTrainedLayersFromHDF5(@StdString String trained_filename);
  /** \brief Writes the net to a proto. */
  public native void ToProto(NetParameter param, @Cast("bool") boolean write_diff/*=false*/);
  public native void ToProto(NetParameter param);
  /** \brief Writes the net to an HDF5 file. */
  public native void ToHDF5(@StdString BytePointer filename, @Cast("bool") boolean write_diff/*=false*/);
  public native void ToHDF5(@StdString BytePointer filename);
  public native void ToHDF5(@StdString String filename, @Cast("bool") boolean write_diff/*=false*/);
  public native void ToHDF5(@StdString String filename);

  /** \brief returns the network name. */
  public native @StdString BytePointer name();
  /** \brief returns the layer names */
  public native @Const @ByRef StringVector layer_names();
  /** \brief returns the blob names */
  public native @Const @ByRef StringVector blob_names();
  /** \brief returns the blobs */
  public native @Const @ByRef DoubleBlobSharedVector blobs();
  /** \brief returns the layers */
  public native @Const @ByRef DoubleLayerSharedVector layers();
  /** \brief returns the phase: TRAIN or TEST */
  public native @Cast("caffe::Phase") int phase();
  /**
   * \brief returns the bottom vecs for each layer -- usually you won't
   *        need this unless you do per-layer checks such as gradients.
   */
  public native @Const @ByRef DoubleBlobVectorVector bottom_vecs();
  /**
   * \brief returns the top vecs for each layer -- usually you won't
   *        need this unless you do per-layer checks such as gradients.
   */
  public native @Const @ByRef DoubleBlobVectorVector top_vecs();
  /** \brief returns the ids of the top blobs of layer i */
  public native @StdVector IntPointer top_ids(int i);
  /** \brief returns the ids of the bottom blobs of layer i */
  public native @StdVector IntPointer bottom_ids(int i);
  public native @Const @ByRef BoolVectorVector bottom_need_backward();
  public native @StdVector DoublePointer blob_loss_weights();
  public native @Const @ByRef BoolVector layer_need_backward();
  /** \brief returns the parameters */
  public native @Const @ByRef DoubleBlobSharedVector params();
  public native @Const @ByRef DoubleBlobVector learnable_params();
  /** \brief returns the learnable parameter learning rate multipliers */
  public native @StdVector FloatPointer params_lr();
  public native @Const @ByRef BoolVector has_params_lr();
  /** \brief returns the learnable parameter decay multipliers */
  public native @StdVector FloatPointer params_weight_decay();
  public native @Const @ByRef BoolVector has_params_decay();
  public native @Const @ByRef StringIntMap param_names_index();
  public native @StdVector IntPointer param_owners();
  public native @Const @ByRef StringVector param_display_names();
  /** \brief Input and output blob numbers */
  public native int num_inputs();
  public native int num_outputs();
  public native @Const @ByRef DoubleBlobVector input_blobs();
  public native @Const @ByRef DoubleBlobVector output_blobs();
  public native @StdVector IntPointer input_blob_indices();
  public native @StdVector IntPointer output_blob_indices();
  public native @Cast("bool") boolean has_blob(@StdString BytePointer blob_name);
  public native @Cast("bool") boolean has_blob(@StdString String blob_name);
  public native @Const @SharedPtr @ByVal DoubleBlob blob_by_name(@StdString BytePointer blob_name);
  public native @Const @SharedPtr @ByVal DoubleBlob blob_by_name(@StdString String blob_name);
  public native @Cast("bool") boolean has_layer(@StdString BytePointer layer_name);
  public native @Cast("bool") boolean has_layer(@StdString String layer_name);
  public DoubleLayer layer_by_name(BytePointer layer_name) { return layer_by_name(DoubleLayer.class, layer_name); }
  public DoubleLayer layer_by_name(String layer_name) { return layer_by_name(DoubleLayer.class, layer_name); };
  public native @Const @Cast({"", "boost::shared_ptr<caffe::Layer<double> >"}) @SharedPtr @ByVal <L extends DoubleLayer> L layer_by_name(Class<L> cls, @StdString BytePointer layer_name);
  public native @Const @Cast({"", "boost::shared_ptr<caffe::Layer<double> >"}) @SharedPtr @ByVal <L extends DoubleLayer> L layer_by_name(Class<L> cls, @StdString String layer_name);

  public native void set_debug_info(@Cast("const bool") boolean value);

  // Helpers for Init.
  /**
   * \brief Remove layers that the user specified should be excluded given the current
   *        phase, level, and stage.
   */
  public static native void FilterNet(@Const @ByRef NetParameter param,
        NetParameter param_filtered);
  /** \brief return whether NetState state meets NetStateRule rule */
  public static native @Cast("bool") boolean StateMeetsRule(@Const @ByRef NetState state, @Const @ByRef NetStateRule rule,
        @StdString BytePointer layer_name);
  public static native @Cast("bool") boolean StateMeetsRule(@Const @ByRef NetState state, @Const @ByRef NetStateRule rule,
        @StdString String layer_name);

  // Invoked at specific points during an iteration
  public static class Callback extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Callback(Pointer p) { super(p); }
  
  }
  public native @Cast("caffe::Net<double>::Callback**") @StdVector PointerPointer before_forward();
  public native void add_before_forward(Callback value);
  public native @Cast("caffe::Net<double>::Callback**") @StdVector PointerPointer after_forward();
  public native void add_after_forward(Callback value);
  public native @Cast("caffe::Net<double>::Callback**") @StdVector PointerPointer before_backward();
  public native void add_before_backward(Callback value);
  public native @Cast("caffe::Net<double>::Callback**") @StdVector PointerPointer after_backward();
  public native void add_after_backward(Callback value);
}
