/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.caffe;

import java.util.Arrays;
import org.bytedeco.caffe.DoubleNet;
import org.bytedeco.caffe.presets.caffe;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;

@Name(value={"std::vector<boost::shared_ptr<caffe::Net<double> > >"})
@Properties(inherit={caffe.class})
public class DoubleNetSharedVector
extends Pointer {
    public DoubleNetSharedVector(Pointer p) {
        super(p);
    }

    public DoubleNetSharedVector(DoubleNet value) {
        this(1L);
        this.put(0L, value);
    }

    public DoubleNetSharedVector(DoubleNet ... array) {
        this(array.length);
        this.put(array);
    }

    public DoubleNetSharedVector() {
        this.allocate();
    }

    public DoubleNetSharedVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native DoubleNetSharedVector put(@ByRef DoubleNetSharedVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @SharedPtr
    public native DoubleNet get(@Cast(value={"size_t"}) long var1);

    public native DoubleNetSharedVector put(@Cast(value={"size_t"}) long var1, DoubleNet var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @SharedPtr DoubleNet var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public DoubleNet[] get() {
        DoubleNet[] array = new DoubleNet[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public DoubleNet pop_back() {
        long size = this.size();
        DoubleNet value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public DoubleNetSharedVector push_back(DoubleNet value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public DoubleNetSharedVector put(DoubleNet value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public DoubleNetSharedVector put(DoubleNet ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @SharedPtr
        @Const
        public native DoubleNet get();
    }
}

