// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppitc extends org.bytedeco.cuda.presets.nppitc {
    static { Loader.load(); }

// Parsed from <nppi_threshold_and_compare_operations.h>

 /* Copyright 2009-2018 NVIDIA Corporation.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are 
  * subject to NVIDIA intellectual property rights under U.S. and 
  * international Copyright laws. 
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED 
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY 
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_THRESHOLD_AND_COMPARE_OPERATIONS_H
// #define NV_NPPI_THRESHOLD_AND_COMPARE_OPERATIONS_H
 
/**
 * \file nppi_threshold_and_compare_operations.h
 * NPP Image Processing Functionality.
 */
 
// #include "nppdefs.h"


// #ifdef __cplusplus
// #endif


/** \defgroup image_threshold_and_compare_operations Threshold and Compare Operations
 *  \ingroup nppi
 *
 * Methods for pixel-wise threshold and compare operations.
 *
 * \{
 *
 * These functions can be found in the nppitc library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 *
 */

/** 
 * \defgroup image_thresholding_operations Thresholding Operations
 * Various types of image thresholding operations.
 *
 * \{
 *
 */

/** 
 * \defgroup image_threshold_operations Threshold Operations
 * Threshold image pixels.
 *
 * <h3><a name="CommonThresholdParameters">Common parameters for nppiThreshold non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param eComparisonOperation The type of comparison operation to be used. The only valid
 *      values are: NPP_CMP_LESS and NPP_CMP_GREATER.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_NOT_SUPPORTED_MODE_ERROR if an invalid
 * comparison operation type is specified.
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                     @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                     @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                     @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u") byte nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                      @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                      @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                      @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                      @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                      @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                      @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s") short nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                      @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                      @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                      @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f") float nThreshold, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                     @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                     @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                     @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                      @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                      @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                      @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                      @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                      @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                      @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                      @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                      @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                      @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                          @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                          @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                          @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                      @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                      @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                      @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp8u*") BytePointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp8u*") byte[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                           @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                           @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                           @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                       @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                       @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                       @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16u*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                           @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                           @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                           @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                       @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                       @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                       @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp16s*") short[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                           @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                           @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                           @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                       @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                       @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                       @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                 @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdParameters">Common parameters for nppiThreshold functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] rThresholds, @Cast("NppCmpOp") int eComparisonOperation);

/** \} image_threshold_operations */

/** 
 * \defgroup image_threshold_greater_than_operations Threshold Greater Than Operations
 * Threshold greater than image pixels.
 *
 * <h3><a name="CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes.
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                        @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                         @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                        @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") byte[] rThresholds); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") short[] rThresholds); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") short[] rThresholds); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                         @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] rThresholds); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                             @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                              @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanParameters">Common parameters for nppiThreshold_GT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_GT_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds);

/** \} image_threshold_greater_than_operations */

/** 
 * \defgroup image_threshold_less_than_operations Threshold Less Than Operations
 * Threshold less than image pixels.
 *
 * <h3><a name="CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes.
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                        @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u") byte nThreshold); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u") short nThreshold); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s") short nThreshold); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                         @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f") float nThreshold); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                        @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                        @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                  @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp8u*") byte[] rThresholds); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16u*") short[] rThresholds); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                         @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                         @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp16s*") short[] rThresholds); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                         @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                         @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] rThresholds); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                             @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") BytePointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") ByteBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") byte[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") short[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                              @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * value is set to nThreshold, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanParameters">Common parameters for nppiThreshold_LT functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatPointer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatBuffer rThresholds, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") float[] rThresholds, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds);
public static native @Cast("NppStatus") int nppiThreshold_LT_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds);

/** \} image_threshold_less_than_operations */

/** 
 * \defgroup image_threshold_value_operations Threshold Value Operations
 * Replace thresholded image pixels with a value.
 *
 * <h3><a name="CommonThresholdValueParameters">Common parameters for nppiThreshold_Val non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param nValue The threshold replacement value.
 * @param eComparisonOperation The type of comparison operation to be used. The only valid
 *      values are: NPP_CMP_LESS and NPP_CMP_GREATER.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_NOT_SUPPORTED_MODE_ERROR if an invalid
 * comparison operation type is specified.
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                             @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 
                                     
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @Cast("NppCmpOp") int eComparisonOperation); 
                                     
/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                              @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                             @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                             @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                         @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                         @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                   @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                              @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                              @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                          @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                          @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations OP the predicate (sourcePixel OP nThreshold) is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation); 


/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                              @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                              @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                              @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                          @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                          @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                          @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                    @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                               @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                               @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                               @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                           @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                           @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                           @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                               @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                               @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                               @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                           @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                           @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                           @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                               @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                               @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                               @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                           @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                           @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                           @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations OP the predicate (sourcePixel.channel OP nThreshold) is true, the channel
 * value is set to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdValueParameters">Common parameters for nppiThreshold_Val functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiThreshold_Val_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @Cast("NppCmpOp") int eComparisonOperation);

/** \} image_threshold_value_operations */

/** 
 * \defgroup image_threshold_greater_than_value_operations Threshold Greater Than Value Operations
 * Replace image pixels greater than threshold with a value.
 *
 * <h3><a name="CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param nValue The threshold replacement value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes.
 *
 * \{
 *
 */



/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                               @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                           @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                            @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is greater than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                               @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                           @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 
                                       
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues); 
                                       
/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                            @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is greater than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdGreaterThanValueParameters">Common parameters for nppiThreshold_GTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_GTVal_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues);

/** \} image_threshold_greater_than_value_operations */

/** 
 * \defgroup image_threshold_less_than_value_operations Threshold Less Than Value Operations
 * Replace image pixels less than threshold with a value.
 *
 * <h3><a name="CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThreshold The threshold value.
 * @param nValue The threshold replacement value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes.
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                               @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                           @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u") byte nThreshold, @Cast("const Npp8u") byte nValue); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u") short nThreshold, @Cast("const Npp16u") short nValue); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s") short nThreshold, @Cast("const Npp16s") short nValue); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                            @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than nThreshold is true, the pixel is set
 * to nValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f") float nThreshold, @Cast("const Npp32f") float nValue); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                               @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                               @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                         @ByVal NppiSize oSizeROI, 
                                         @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                           @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                           @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                     @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                            @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                            @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                            @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                            @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                            @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                      @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") BytePointer rThresholds, @Cast("const Npp8u*") BytePointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") ByteBuffer rThresholds, @Cast("const Npp8u*") ByteBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp8u*") byte[] rThresholds, @Cast("const Npp8u*") byte[] rValues);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortPointer rThresholds, @Cast("const Npp16u*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") ShortBuffer rThresholds, @Cast("const Npp16u*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16u*") short[] rThresholds, @Cast("const Npp16u*") short[] rValues);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                             @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                             @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortPointer rThresholds, @Cast("const Npp16s*") ShortPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") ShortBuffer rThresholds, @Cast("const Npp16s*") ShortBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp16s*") short[] rThresholds, @Cast("const Npp16s*") short[] rValues);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                             @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                             @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                       @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThreshold is true, the pixel is set
 * value is set to rValue, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueParameters">Common parameters for nppiThreshold_LTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatPointer rThresholds, @Cast("const Npp32f*") FloatPointer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") FloatBuffer rThresholds, @Cast("const Npp32f*") FloatBuffer rValues);
public static native @Cast("NppStatus") int nppiThreshold_LTVal_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                        @ByVal NppiSize oSizeROI, 
                                        @Cast("const Npp32f*") float[] rThresholds, @Cast("const Npp32f*") float[] rValues);

/** \} image_threshold_less_than_value_operations */

/** 
 * \defgroup image_threshold_less_than_value_greater_than_value_operations Threshold Less Than Value Or Greater Than Value Operations
 * Replace image pixels less than thresholdLT or greater than thresholdGT with with valueLT or valueGT respectively.
 *
 * <h3><a name="CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal non-inplace and inplace functions include:</a></h3>
 *
 * @param pSrcDst \ref in_place_image_pointer for inplace functions.
 * @param nSrcDstStep \ref in_place_image_line_step for inplace functions.
 * @param pSrc \ref source_image_pointer for non-inplace functions.
 * @param nSrcStep \ref source_image_line_step for non-inplace functions.
 * @param pDst \ref destination_image_pointer for non-inplace functions.
 * @param nDstStep \ref destination_image_line_step for non-inplace functions.
 * @param oSizeROI \ref roi_specification.
 * @param nThresholdLT The thresholdLT value.
 * @param nValueLT The thresholdLT replacement value.
 * @param nThresholdGT The thresholdGT value.
 * @param nValueGT The thresholdGT replacement value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes.
 *
 * \{
 *
 */


/** 
 * 1 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT); 

/** 
 * 1 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u") byte nThresholdLT, @Cast("const Npp8u") byte nValueLT, @Cast("const Npp8u") byte nThresholdGT, @Cast("const Npp8u") byte nValueGT); 

/** 
 * 1 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT); 

/** 
 * 1 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u") short nThresholdLT, @Cast("const Npp16u") short nValueLT, @Cast("const Npp16u") short nThresholdGT, @Cast("const Npp16u") short nValueGT); 

/** 
 * 1 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT); 

/** 
 * 1 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s") short nThresholdLT, @Cast("const Npp16s") short nValueLT, @Cast("const Npp16s") short nThresholdGT, @Cast("const Npp16s") short nValueGT); 

/** 
 * 1 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT); 

/** 
 * 1 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than nThresholdLT is true, the pixel is set
 * to nValueLT, else if sourcePixel is greater than nThresholdGT the pixel is set to nValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f") float nThresholdLT, @Cast("const Npp32f") float nValueLT, @Cast("const Npp32f") float nThresholdGT, @Cast("const Npp32f") float nValueGT); 

/** 
 * 3 channel 8-bit unsigned char threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                              @ByVal NppiSize oSizeROI, 
                                              @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                          @ByVal NppiSize oSizeROI, 
                                          @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT); 

/** 
 * 3 channel 8-bit unsigned char in place threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT); 

/** 
 * 3 channel 16-bit unsigned short threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                     @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT); 

/** 
 * 3 channel 16-bit unsigned short in place threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT); 

/** 
 * 3 channel 16-bit signed short threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                     @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                 @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT); 

/** 
 * 3 channel 16-bit signed short in place threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT); 

/** 
 * 3 channel 32-bit floating point threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                     @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                 @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT); 

/** 
 * 3 channel 32-bit floating point in place threshold.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT); 

/** 
 * 4 channel 8-bit unsigned char image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                     @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                     @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                     @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                               @ByVal NppiSize oSizeROI, 
                                               @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                 @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                 @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                 @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                           @ByVal NppiSize oSizeROI, 
                                           @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT);

/** 
 * 4 channel 8-bit unsigned char in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp8u*") BytePointer rThresholdsLT, @Cast("const Npp8u*") BytePointer rValuesLT, @Cast("const Npp8u*") BytePointer rThresholdsGT, @Cast("const Npp8u*") BytePointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp8u*") ByteBuffer rThresholdsLT, @Cast("const Npp8u*") ByteBuffer rValuesLT, @Cast("const Npp8u*") ByteBuffer rThresholdsGT, @Cast("const Npp8u*") ByteBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp8u*") byte[] rThresholdsLT, @Cast("const Npp8u*") byte[] rValuesLT, @Cast("const Npp8u*") byte[] rThresholdsGT, @Cast("const Npp8u*") byte[] rValuesGT);

/** 
 * 4 channel 16-bit unsigned short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                      @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                      @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                      @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                                  @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                                  @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                                  @Cast("Npp16u*") short[] pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT);

/** 
 * 4 channel 16-bit unsigned short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16u*") ShortPointer rThresholdsLT, @Cast("const Npp16u*") ShortPointer rValuesLT, @Cast("const Npp16u*") ShortPointer rThresholdsGT, @Cast("const Npp16u*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16u*") ShortBuffer rThresholdsLT, @Cast("const Npp16u*") ShortBuffer rValuesLT, @Cast("const Npp16u*") ShortBuffer rThresholdsGT, @Cast("const Npp16u*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16u*") short[] rThresholdsLT, @Cast("const Npp16u*") short[] rValuesLT, @Cast("const Npp16u*") short[] rThresholdsGT, @Cast("const Npp16u*") short[] rValuesGT);

/** 
 * 4 channel 16-bit signed short image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                      @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                      @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                      @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                  @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                  @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                  @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT);

/** 
 * 4 channel 16-bit signed short in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16s*") ShortPointer rThresholdsLT, @Cast("const Npp16s*") ShortPointer rValuesLT, @Cast("const Npp16s*") ShortPointer rThresholdsGT, @Cast("const Npp16s*") ShortPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16s*") ShortBuffer rThresholdsLT, @Cast("const Npp16s*") ShortBuffer rValuesLT, @Cast("const Npp16s*") ShortBuffer rThresholdsGT, @Cast("const Npp16s*") ShortBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp16s*") short[] rThresholdsLT, @Cast("const Npp16s*") short[] rValuesLT, @Cast("const Npp16s*") short[] rThresholdsGT, @Cast("const Npp16s*") short[] rValuesGT);

/** 
 * 4 channel 32-bit floating point image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                      @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                      @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                      @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                                @ByVal NppiSize oSizeROI, 
                                                @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                                  @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                                  @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                                  @Cast("Npp32f*") float[] pDst, int nDstStep, 
                                            @ByVal NppiSize oSizeROI, 
                                            @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT);

/** 
 * 4 channel 32-bit floating point in place image threshold, not affecting Alpha.
 * If for a comparison operations sourcePixel is less than rThresholdLT is true, the pixel is set
 * value is set to rValueLT, else if sourcePixel is greater than rThresholdGT the pixel is set to rValueGT, otherwise it is set to sourcePixel.
 * 
 * For common parameter descriptions, see <a href="#CommonThresholdLessThanValueGreaterThanValueParameters">Common parameters for nppiThreshold_LTValGTVal functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                                 @ByVal NppiSize oSizeROI, 
                                                 @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp32f*") FloatPointer rThresholdsLT, @Cast("const Npp32f*") FloatPointer rValuesLT, @Cast("const Npp32f*") FloatPointer rThresholdsGT, @Cast("const Npp32f*") FloatPointer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp32f*") FloatBuffer rThresholdsLT, @Cast("const Npp32f*") FloatBuffer rValuesLT, @Cast("const Npp32f*") FloatBuffer rThresholdsGT, @Cast("const Npp32f*") FloatBuffer rValuesGT);
public static native @Cast("NppStatus") int nppiThreshold_LTValGTVal_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                                             @ByVal NppiSize oSizeROI, 
                                             @Cast("const Npp32f*") float[] rThresholdsLT, @Cast("const Npp32f*") float[] rValuesLT, @Cast("const Npp32f*") float[] rThresholdsGT, @Cast("const Npp32f*") float[] rValuesGT);

/** \} image_threshold_less_than_value_greater_than_value_operations */

/** \} image_thresholding_operations */

/** \defgroup image_comparison_operations Comparison Operations
 * Compare the pixels of two images or one image and a constant value and create a binary result image. In case of multi-channel
 * image types, the condition must be fulfilled for all channels, otherwise the comparison
 * is considered false.
 * The "binary" result image is of type 8u_C1. False is represented by 0, true by NPP_MAX_8U.
 *
 * \{
 *
 */


/** \defgroup compare_images_operations Compare Images Operations
 * Compare the pixels of two images and create a binary result image. In case of multi-channel
 * image types, the condition must be fulfilled for all channels, otherwise the comparison
 * is considered false.
 * The "binary" result image is of type 8u_C1. False is represented by 0, true by NPP_MAX_8U.
 *
 * <h3><a name="CommonCompareImagesParameters">Common parameters for nppiCompare functions include:</a></h3>
 *
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eComparisonOperation Specifies the comparison operation to be used in the pixel comparison.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 8-bit unsigned char image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                       @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                 @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                             @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                             @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char image compare, not affecting Alpha.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step,
                              @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step,
                              @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 16-bit unsigned short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 16-bit unsigned short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image compare, not affecting Alpha.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,
                               @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,
                               @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,
                               @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 16-bit signed short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C1R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 16-bit signed short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C3R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_C4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                              @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image compare, not affecting Alpha.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step,
                               @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step,
                               @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_16s_AC4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step,
                               @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 32-bit floating point image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 32-bit floating point image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point image compare.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                              @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit signed floating point compare, not affecting Alpha.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImagesParameters">Common parameters for nppiCompare functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompare_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompare_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompare_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                               @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                               @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompare_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                               @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** \} compare_images_operations */

/** \defgroup compare_image_with_constant_operations Compare Image With Constant Operations
 * Compare the pixels of an image with a constant value and create a binary result image. In case of multi-channel
 * image types, the condition must be fulfilled for all channels, otherwise the comparison
 * is considered false.
 * The "binary" result image is of type 8u_C1. False is represented by 0, true by NPP_MAX_8U.
 *
 * <h3><a name="CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param nConstant constant value for single channel functions.
 * @param pConstants pointer to a list of constant values, one per color channel for multi-channel functions.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eComparisonOperation Specifies the comparison operation to be used in the pixel comparison.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/** 
 * 1 channel 8-bit unsigned char image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                  @Cast("const Npp8u") byte nConstant,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                  @Cast("const Npp8u") byte nConstant,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                  @Cast("const Npp8u") byte nConstant,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                              @Cast("const Npp8u") byte nConstant,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                              @Cast("const Npp8u") byte nConstant,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                              @Cast("const Npp8u") byte nConstant,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 8-bit unsigned char image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") BytePointer pConstants,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") ByteBuffer pConstants,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") byte[] pConstants,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                              @Cast("const Npp8u*") BytePointer pConstants,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                              @Cast("const Npp8u*") ByteBuffer pConstants,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                              @Cast("const Npp8u*") byte[] pConstants,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") BytePointer pConstants,
                                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") ByteBuffer pConstants,
                                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                  @Cast("const Npp8u*") byte[] pConstants,
                                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                  @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                              @Cast("const Npp8u*") BytePointer pConstants,
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                              @Cast("const Npp8u*") ByteBuffer pConstants,
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                              @Cast("const Npp8u*") byte[] pConstants,
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                              @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 8-bit unsigned char image compare, not affecting Alpha.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                   @Cast("const Npp8u*") BytePointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp8u*") ByteBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                   @Cast("const Npp8u*") byte[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                               @Cast("const Npp8u*") BytePointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                               @Cast("const Npp8u*") ByteBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                               @Cast("const Npp8u*") byte[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 16-bit unsigned short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16u") short nConstant,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16u") short nConstant,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16u") short nConstant,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16u") short nConstant,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16u") short nConstant,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16u") short nConstant,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 16-bit unsigned short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") ShortPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") ShortBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") short[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16u*") ShortPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16u*") ShortBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16u*") short[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") ShortPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") ShortBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16u*") short[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16u*") ShortPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16u*") ShortBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16u*") short[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit unsigned short image compare, not affecting Alpha.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                    @Cast("const Npp16u*") ShortPointer pConstants,
                                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                    @Cast("const Npp16u*") ShortBuffer pConstants,
                                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                    @Cast("const Npp16u*") short[] pConstants,
                                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep,
                                @Cast("const Npp16u*") ShortPointer pConstants,
                                      @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep,
                                @Cast("const Npp16u*") ShortBuffer pConstants,
                                      @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep,
                                @Cast("const Npp16u*") short[] pConstants,
                                      @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 16-bit signed short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16s") short nConstant,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16s") short nConstant,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16s") short nConstant,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16s") short nConstant,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16s") short nConstant,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16s") short nConstant,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 16-bit signed short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") ShortPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") ShortBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") short[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16s*") ShortPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16s*") ShortBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16s*") short[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") ShortPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") ShortBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                   @Cast("const Npp16s*") short[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                               @Cast("const Npp16s*") ShortPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                               @Cast("const Npp16s*") ShortBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                               @Cast("const Npp16s*") short[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 16-bit signed short image compare, not affecting Alpha.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                    @Cast("const Npp16s*") ShortPointer pConstants,
                                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                    @Cast("const Npp16s*") ShortBuffer pConstants,
                                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                    @Cast("const Npp16s*") short[] pConstants,
                                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                @Cast("const Npp16s*") ShortPointer pConstants,
                                      @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                @Cast("const Npp16s*") ShortBuffer pConstants,
                                      @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                @Cast("const Npp16s*") short[] pConstants,
                                      @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 1 channel 32-bit floating point image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                   @Cast("const Npp32f") float nConstant,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp32f") float nConstant,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                   @Cast("const Npp32f") float nConstant,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                               @Cast("const Npp32f") float nConstant,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                               @Cast("const Npp32f") float nConstant,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                               @Cast("const Npp32f") float nConstant,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 3 channel 32-bit floating point image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") FloatPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") FloatBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") float[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                               @Cast("const Npp32f*") FloatPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                               @Cast("const Npp32f*") FloatBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                               @Cast("const Npp32f*") float[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit floating point image compare with constant value.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") FloatPointer pConstants,
                                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") FloatBuffer pConstants,
                                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                   @Cast("const Npp32f*") float[] pConstants,
                                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                   @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                               @Cast("const Npp32f*") FloatPointer pConstants,
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                               @Cast("const Npp32f*") FloatBuffer pConstants,
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                               @Cast("const Npp32f*") float[] pConstants,
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                               @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** 
 * 4 channel 32-bit signed floating point compare, not affecting Alpha.
 * Compare pSrc's pixels with constant value. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageWithConstantParameters">Common parameters for nppiCompareC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                    @Cast("const Npp32f*") FloatPointer pConstants,
                                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                    @Cast("const Npp32f*") FloatBuffer pConstants,
                                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                    @Cast("const Npp32f*") float[] pConstants,
                                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                    @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                @Cast("const Npp32f*") FloatPointer pConstants,
                                      @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                @Cast("const Npp32f*") FloatBuffer pConstants,
                                      @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);
public static native @Cast("NppStatus") int nppiCompareC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                @Cast("const Npp32f*") float[] pConstants,
                                      @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                @ByVal NppiSize oSizeROI, @Cast("NppCmpOp") int eComparisonOperation);

/** \} compare_image_with_constant_operations */

/** \defgroup compare_image_differences_with_epsilon_operations Compare Image Differences With Epsilon Operations
 * Compare the pixels value differences of two images with an epsilon value and create a binary result image. In case of multi-channel
 * image types, the condition must be fulfilled for all channels, otherwise the comparison
 * is considered false.
 * The "binary" result image is of type 8u_C1. False is represented by 0, true by NPP_MAX_8U.
 *
 * <h3><a name="CommonCompareImageDifferencesWithEpsilonParameters">Common parameters for nppiCompareEqualEps functions include:</a></h3>
 *
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nEpsilon epsilon tolerance value to compare to pixel absolute differences
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/** 
 * 1 channel 32-bit floating point image compare whether two images are equal within epsilon.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2 to determine whether they are equal with a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferencesWithEpsilonParameters">Common parameters for nppiCompareEqualEps functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 3 channel 32-bit floating point image compare whether two images are equal within epsilon.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2 to determine whether they are equal with a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferencesWithEpsilonParameters">Common parameters for nppiCompareEqualEps functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 4 channel 32-bit floating point image compare whether two images are equal within epsilon.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2 to determine whether they are equal with a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferencesWithEpsilonParameters">Common parameters for nppiCompareEqualEps functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                          @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                                @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                          @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                            @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 4 channel 32-bit signed floating point compare whether two images are equal within epsilon, not affecting Alpha.
 * Compare pSrc1's pixels with corresponding pixels in pSrc2 to determine whether they are equal with a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferencesWithEpsilonParameters">Common parameters for nppiCompareEqualEps functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                           @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                                 @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                           @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                                 @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                           @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                                 @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                             @Cast("Npp8u*") BytePointer pDst,   int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                             @Cast("Npp8u*") ByteBuffer pDst,   int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEps_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                             @Cast("Npp8u*") byte[] pDst,   int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** \} compare_image_differences_with_epsilon_operations */


/** \defgroup compare_image_difference_to_constant_with_epsilon_operations Compare Image Difference With Constant Within Epsilon Operations
 * Compare differences between image pixels and constant within an epsilon value and create a binary result image. In case of multi-channel
 * image types, the condition must be fulfilled for all channels, otherwise the comparison
 * is considered false.
 * The "binary" result image is of type 8u_C1. False is represented by 0, true by NPP_MAX_8U.
 *
 * <h3><a name="CommonCompareImageDifferenceWithConstantWithinEpsilonParameters">Common parameters for nppiCompareEqualEpsC functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param nConstant constant value for single channel functions.
 * @param pConstants pointer to a list of constants, one per color channel for multi-channel image functions.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nEpsilon epsilon tolerance value to compare to per color channel pixel absolute differences
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/** 
 * 1 channel 32-bit floating point image compare whether image and constant are equal within epsilon.
 * Compare pSrc's pixels with constant value to determine whether they are equal within a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferenceWithConstantWithinEpsilonParameters">Common parameters for nppiCompareEqualEpsC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                           @Cast("const Npp32f") float nConstant,
                                                 @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                           @Cast("const Npp32f") float nConstant,
                                                 @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                           @Cast("const Npp32f") float nConstant,
                                                 @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                       @Cast("const Npp32f") float nConstant,
                                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                       @Cast("const Npp32f") float nConstant,
                                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                       @Cast("const Npp32f") float nConstant,
                                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 3 channel 32-bit floating point image compare whether image and constant are equal within epsilon.
 * Compare pSrc's pixels with constant value to determine whether they are equal within a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferenceWithConstantWithinEpsilonParameters">Common parameters for nppiCompareEqualEpsC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") FloatPointer pConstants,
                                                 @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") FloatBuffer pConstants,
                                                 @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") float[] pConstants,
                                                 @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") FloatPointer pConstants,
                                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") FloatBuffer pConstants,
                                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") float[] pConstants,
                                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 4 channel 32-bit floating point image compare whether image and constant are equal within epsilon.
 * Compare pSrc's pixels with constant value to determine whether they are equal within a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferenceWithConstantWithinEpsilonParameters">Common parameters for nppiCompareEqualEpsC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") FloatPointer pConstants,
                                                 @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") FloatBuffer pConstants,
                                                 @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                           @Cast("const Npp32f*") float[] pConstants,
                                                 @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                           @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") FloatPointer pConstants,
                                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") FloatBuffer pConstants,
                                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                       @Cast("const Npp32f*") float[] pConstants,
                                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** 
 * 4 channel 32-bit signed floating point compare whether image and constant are equal within epsilon, not affecting Alpha.
 * Compare pSrc's pixels with constant value to determine whether they are equal within a difference of epsilon. 
 * 
 * For common parameter descriptions, see <a href="#CommonCompareImageDifferenceWithConstantWithinEpsilonParameters">Common parameters for nppiCompareEqualEpsC functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                            @Cast("const Npp32f*") FloatPointer pConstants,
                                                  @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                            @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                            @Cast("const Npp32f*") FloatBuffer pConstants,
                                                  @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                            @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                            @Cast("const Npp32f*") float[] pConstants,
                                                  @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                            @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep,
                                        @Cast("const Npp32f*") FloatPointer pConstants,
                                              @Cast("Npp8u*") BytePointer pDst,  int nDstStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep,
                                        @Cast("const Npp32f*") FloatBuffer pConstants,
                                              @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);
public static native @Cast("NppStatus") int nppiCompareEqualEpsC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep,
                                        @Cast("const Npp32f*") float[] pConstants,
                                              @Cast("Npp8u*") byte[] pDst,  int nDstStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nEpsilon);

/** \} compare_image_difference_to_constant_within_epsilon_operations */

/** \} image_comparison_operations */

/** \} image_threshold_and_compare_operations */

// #ifdef __cplusplus /* extern "C" */
// #endif

// #endif /* NV_NPPI_THRESHOLD_AND_COMPARE_OPERATIONS_H */


}
