// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvgraph;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvgraph.*;


@Properties(inherit = org.bytedeco.cuda.presets.nvgraph.class)
public class SpectralClusteringParameter extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public SpectralClusteringParameter() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SpectralClusteringParameter(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SpectralClusteringParameter(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public SpectralClusteringParameter position(long position) {
        return (SpectralClusteringParameter)super.position(position);
    }

       public native int n_clusters(); public native SpectralClusteringParameter n_clusters(int setter); //number of clusters
       public native int n_eig_vects(); public native SpectralClusteringParameter n_eig_vects(int setter); // //number of eigenvectors
       public native @Cast("nvgraphSpectralClusteringType_t") int algorithm(); public native SpectralClusteringParameter algorithm(int setter); // algorithm to use
       public native float evs_tolerance(); public native SpectralClusteringParameter evs_tolerance(float setter); // tolerance of the eigensolver
       public native int evs_max_iter(); public native SpectralClusteringParameter evs_max_iter(int setter); // maximum number of iterations of the eigensolver
       public native float kmean_tolerance(); public native SpectralClusteringParameter kmean_tolerance(float setter); // tolerance of kmeans
       public native int kmean_max_iter(); public native SpectralClusteringParameter kmean_max_iter(int setter); // maximum number of iterations of kemeans 
       public native Pointer opt(); public native SpectralClusteringParameter opt(Pointer setter); // optional parameter that can be used for preconditioning in the future
}
