// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cusparse.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class cusparse extends org.bytedeco.cuda.presets.cusparse {
    static { Loader.load(); }

// Parsed from <cusparse.h>

/*
 * Copyright 1993-2019 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */
// #if !defined(CUSPARSE_H_)
// #define CUSPARSE_H_

// #include <cuComplex.h>
// #include <cuda_fp16.h>
// #include <driver_types.h>
// #include <library_types.h>
// #include <stdint.h>

//##############################################################################
//# CUSPARSE VERSION INFORMATION
//##############################################################################

public static final int CUSPARSE_VER_MAJOR = 10;
public static final int CUSPARSE_VER_MINOR = 2;
public static final int CUSPARSE_VER_PATCH = 0;
public static final int CUSPARSE_VER_BUILD = 0;

//##############################################################################
//# MACRO
//##############################################################################

// #ifndef CUSPARSEAPI
// #    if defined(_WIN32)
// #        define CUSPARSEAPI __stdcall
// #    else
// #        define CUSPARSEAPI
// #    endif
// #endif

//------------------------------------------------------------------------------
// #define DISABLE_CUSPARSE_DEPRECATED

// #if !defined(DISABLE_CUSPARSE_DEPRECATED)

// #else // defined(DISABLE_CUSPARSE_DEPRECATED)
// #   define CUSPARSE_DEPRECATED(new_func)
// #endif // !defined(DISABLE_CUSPARSE_DEPRECATED)
//------------------------------------------------------------------------------

// #if defined(__cplusplus)
// Targeting ../cusparse/cusparseContext.java


// Targeting ../cusparse/cusparseMatDescr.java


// Targeting ../cusparse/cusparseSolveAnalysisInfo.java


// Targeting ../cusparse/csrsv2Info.java


// Targeting ../cusparse/csrsm2Info.java


// Targeting ../cusparse/bsrsv2Info.java


// Targeting ../cusparse/bsrsm2Info.java


// Targeting ../cusparse/csric02Info.java


// Targeting ../cusparse/bsric02Info.java


// Targeting ../cusparse/csrilu02Info.java


// Targeting ../cusparse/bsrilu02Info.java


// Targeting ../cusparse/cusparseHybMat.java


// Targeting ../cusparse/csrgemm2Info.java


// Targeting ../cusparse/csru2csrInfo.java


// Targeting ../cusparse/cusparseColorInfo.java


// Targeting ../cusparse/pruneInfo.java



//##############################################################################
//# ENUMERATORS
//##############################################################################

/** enum cusparseStatus_t */
public static final int
    CUSPARSE_STATUS_SUCCESS                   = 0,
    CUSPARSE_STATUS_NOT_INITIALIZED           = 1,
    CUSPARSE_STATUS_ALLOC_FAILED              = 2,
    CUSPARSE_STATUS_INVALID_VALUE             = 3,
    CUSPARSE_STATUS_ARCH_MISMATCH             = 4,
    CUSPARSE_STATUS_MAPPING_ERROR             = 5,
    CUSPARSE_STATUS_EXECUTION_FAILED          = 6,
    CUSPARSE_STATUS_INTERNAL_ERROR            = 7,
    CUSPARSE_STATUS_MATRIX_TYPE_NOT_SUPPORTED = 8,
    CUSPARSE_STATUS_ZERO_PIVOT                = 9,
    CUSPARSE_STATUS_NOT_SUPPORTED             = 10;

/** enum cusparsePointerMode_t */
public static final int
    CUSPARSE_POINTER_MODE_HOST   = 0,
    CUSPARSE_POINTER_MODE_DEVICE = 1;

/** enum cusparseAction_t */
public static final int
    CUSPARSE_ACTION_SYMBOLIC = 0,
    CUSPARSE_ACTION_NUMERIC  = 1;

/** enum cusparseMatrixType_t */
public static final int
    CUSPARSE_MATRIX_TYPE_GENERAL    = 0,
    CUSPARSE_MATRIX_TYPE_SYMMETRIC  = 1,
    CUSPARSE_MATRIX_TYPE_HERMITIAN  = 2,
    CUSPARSE_MATRIX_TYPE_TRIANGULAR = 3;

/** enum cusparseFillMode_t */
public static final int
    CUSPARSE_FILL_MODE_LOWER = 0,
    CUSPARSE_FILL_MODE_UPPER = 1;

/** enum cusparseDiagType_t */
public static final int
    CUSPARSE_DIAG_TYPE_NON_UNIT = 0,
    CUSPARSE_DIAG_TYPE_UNIT     = 1;

/** enum cusparseIndexBase_t */
public static final int
    CUSPARSE_INDEX_BASE_ZERO = 0,
    CUSPARSE_INDEX_BASE_ONE  = 1;

/** enum cusparseOperation_t */
public static final int
    CUSPARSE_OPERATION_NON_TRANSPOSE       = 0,
    CUSPARSE_OPERATION_TRANSPOSE           = 1,
    CUSPARSE_OPERATION_CONJUGATE_TRANSPOSE = 2;

/** enum cusparseDirection_t */
public static final int
    CUSPARSE_DIRECTION_ROW    = 0,
    CUSPARSE_DIRECTION_COLUMN = 1;

/** enum cusparseHybPartition_t */
public static final int
    CUSPARSE_HYB_PARTITION_AUTO = 0,
    CUSPARSE_HYB_PARTITION_USER = 1,
    CUSPARSE_HYB_PARTITION_MAX = 2;

/** enum cusparseSolvePolicy_t */
public static final int
    CUSPARSE_SOLVE_POLICY_NO_LEVEL = 0,
    CUSPARSE_SOLVE_POLICY_USE_LEVEL = 1;

/** enum cusparseSideMode_t */
public static final int
    CUSPARSE_SIDE_LEFT  = 0,
    CUSPARSE_SIDE_RIGHT = 1;

/** enum cusparseColorAlg_t */
public static final int
    CUSPARSE_COLOR_ALG0 = 0, // default
    CUSPARSE_COLOR_ALG1 = 1;

/** enum cusparseAlgMode_t */
public static final int
    CUSPARSE_ALG0           = 0, // default, naive
    CUSPARSE_ALG1           = 1, // merge path
    CUSPARSE_ALG_NAIVE      = 0,
    CUSPARSE_ALG_MERGE_PATH = 1; // merge path alias

//##############################################################################
//# INITILIAZATION AND MANAGMENT ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCreate(@ByPtrPtr cusparseContext handle);

public static native @Cast("cusparseStatus_t") int cusparseDestroy(cusparseContext handle);

public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   IntPointer version);
public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   IntBuffer version);
public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   int[] version);

public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    IntPointer value);
public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    IntBuffer value);
public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    int[] value);

public static native @Cast("cusparseStatus_t") int cusparseSetStream(cusparseContext handle,
                  CUstream_st streamId);

public static native @Cast("cusparseStatus_t") int cusparseGetStream(cusparseContext handle,
                  @ByPtrPtr CUstream_st streamId);

public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") IntPointer mode);
public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") IntBuffer mode);
public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") int[] mode);

public static native @Cast("cusparseStatus_t") int cusparseSetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t") int mode);

//##############################################################################
//# HELPER ROUTINES
//##############################################################################

public static native @Cast("const char*") BytePointer cusparseGetErrorName(@Cast("cusparseStatus_t") int status);

public static native @Cast("const char*") BytePointer cusparseGetErrorString(@Cast("cusparseStatus_t") int status);

public static native @Cast("cusparseStatus_t") int cusparseCreateMatDescr(@ByPtrPtr cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseDestroyMatDescr(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseCopyMatDescr(cusparseMatDescr dest,
                     cusparseMatDescr src);

public static native @Cast("cusparseStatus_t") int cusparseSetMatType(cusparseMatDescr descrA,
                   @Cast("cusparseMatrixType_t") int type);

public static native @Cast("cusparseMatrixType_t") int cusparseGetMatType(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatFillMode(cusparseMatDescr descrA,
                       @Cast("cusparseFillMode_t") int fillMode);

public static native @Cast("cusparseFillMode_t") int cusparseGetMatFillMode(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatDiagType(cusparseMatDescr descrA,
                       @Cast("cusparseDiagType_t") int diagType);

public static native @Cast("cusparseDiagType_t") int cusparseGetMatDiagType(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatIndexBase(cusparseMatDescr descrA,
                        @Cast("cusparseIndexBase_t") int base);

public static native @Cast("cusparseIndexBase_t") int cusparseGetMatIndexBase(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseCreateSolveAnalysisInfo(@ByPtrPtr cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroySolveAnalysisInfo(cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseGetLevelInfo(cusparseContext handle,
                     cusparseSolveAnalysisInfo info,
                     IntPointer nlevels,
                     @Cast("int**") PointerPointer levelPtr,
                     @Cast("int**") PointerPointer levelInd);
public static native @Cast("cusparseStatus_t") int cusparseGetLevelInfo(cusparseContext handle,
                     cusparseSolveAnalysisInfo info,
                     IntPointer nlevels,
                     @ByPtrPtr IntPointer levelPtr,
                     @ByPtrPtr IntPointer levelInd);
public static native @Cast("cusparseStatus_t") int cusparseGetLevelInfo(cusparseContext handle,
                     cusparseSolveAnalysisInfo info,
                     IntBuffer nlevels,
                     @ByPtrPtr IntBuffer levelPtr,
                     @ByPtrPtr IntBuffer levelInd);
public static native @Cast("cusparseStatus_t") int cusparseGetLevelInfo(cusparseContext handle,
                     cusparseSolveAnalysisInfo info,
                     int[] nlevels,
                     @ByPtrPtr int[] levelPtr,
                     @ByPtrPtr int[] levelInd);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsrsv2Info(@ByPtrPtr csrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsrsv2Info(csrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsric02Info(@ByPtrPtr csric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsric02Info(csric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsric02Info(@ByPtrPtr bsric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsric02Info(bsric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsrilu02Info(@ByPtrPtr csrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsrilu02Info(csrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrilu02Info(@ByPtrPtr bsrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrilu02Info(bsrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrsv2Info(@ByPtrPtr bsrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrsv2Info(bsrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrsm2Info(@ByPtrPtr bsrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrsm2Info(bsrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateHybMat(@ByPtrPtr cusparseHybMat hybA);

public static native @Cast("cusparseStatus_t") int cusparseDestroyHybMat(cusparseHybMat hybA);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsru2csrInfo(@ByPtrPtr csru2csrInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsru2csrInfo(csru2csrInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCreateColorInfo(@ByPtrPtr cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyColorInfo(cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseSetColorAlgs(cusparseColorInfo info,
                     @Cast("cusparseColorAlg_t") int alg);

public static native @Cast("cusparseStatus_t") int cusparseGetColorAlgs(cusparseColorInfo info,
                     @Cast("cusparseColorAlg_t*") IntPointer alg);
public static native @Cast("cusparseStatus_t") int cusparseGetColorAlgs(cusparseColorInfo info,
                     @Cast("cusparseColorAlg_t*") IntBuffer alg);
public static native @Cast("cusparseStatus_t") int cusparseGetColorAlgs(cusparseColorInfo info,
                     @Cast("cusparseColorAlg_t*") int[] alg);

public static native @Cast("cusparseStatus_t") int cusparseCreatePruneInfo(@ByPtrPtr pruneInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyPruneInfo(pruneInfo info);

//##############################################################################
//# SPARSE LEVEL 1 ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSaxpyi(cusparseContext handle,
               int nnz,
               @Const FloatPointer alpha,
               @Const FloatPointer xVal,
               @Const IntPointer xInd,
               FloatPointer y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSaxpyi(cusparseContext handle,
               int nnz,
               @Const FloatBuffer alpha,
               @Const FloatBuffer xVal,
               @Const IntBuffer xInd,
               FloatBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSaxpyi(cusparseContext handle,
               int nnz,
               @Const float[] alpha,
               @Const float[] xVal,
               @Const int[] xInd,
               float[] y,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseDaxpyi(cusparseContext handle,
               int nnz,
               @Const DoublePointer alpha,
               @Const DoublePointer xVal,
               @Const IntPointer xInd,
               DoublePointer y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDaxpyi(cusparseContext handle,
               int nnz,
               @Const DoubleBuffer alpha,
               @Const DoubleBuffer xVal,
               @Const IntBuffer xInd,
               DoubleBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDaxpyi(cusparseContext handle,
               int nnz,
               @Const double[] alpha,
               @Const double[] xVal,
               @Const int[] xInd,
               double[] y,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseCaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntPointer xInd,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntBuffer xInd,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 xVal,
               @Const int[] xInd,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseZaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntPointer xInd,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntBuffer xInd,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZaxpyi(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const int[] xInd,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseSdoti(cusparseContext handle,
              int nnz,
              @Const FloatPointer xVal,
              @Const IntPointer xInd,
              @Const FloatPointer y,
              FloatPointer resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseSdoti(cusparseContext handle,
              int nnz,
              @Const FloatBuffer xVal,
              @Const IntBuffer xInd,
              @Const FloatBuffer y,
              FloatBuffer resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseSdoti(cusparseContext handle,
              int nnz,
              @Const float[] xVal,
              @Const int[] xInd,
              @Const float[] y,
              float[] resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDdoti(cusparseContext handle,
              int nnz,
              @Const DoublePointer xVal,
              @Const IntPointer xInd,
              @Const DoublePointer y,
              DoublePointer resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDdoti(cusparseContext handle,
              int nnz,
              @Const DoubleBuffer xVal,
              @Const IntBuffer xInd,
              @Const DoubleBuffer y,
              DoubleBuffer resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDdoti(cusparseContext handle,
              int nnz,
              @Const double[] xVal,
              @Const int[] xInd,
              @Const double[] y,
              double[] resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const IntPointer xInd,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const IntBuffer xInd,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const int[] xInd,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const IntPointer xInd,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const IntBuffer xInd,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdoti(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const int[] xInd,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuComplex*") float2 y,
               @Cast("cuComplex*") float2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuComplex*") float2 y,
               @Cast("cuComplex*") float2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const int[] xInd,
               @Cast("const cuComplex*") float2 y,
               @Cast("cuComplex*") float2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZdotci(cusparseContext handle,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const int[] xInd,
               @Cast("const cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 resultDevHostPtr,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseSgthr(cusparseContext handle,
              int nnz,
              @Const FloatPointer y,
              FloatPointer xVal,
              @Const IntPointer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSgthr(cusparseContext handle,
              int nnz,
              @Const FloatBuffer y,
              FloatBuffer xVal,
              @Const IntBuffer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSgthr(cusparseContext handle,
              int nnz,
              @Const float[] y,
              float[] xVal,
              @Const int[] xInd,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseDgthr(cusparseContext handle,
              int nnz,
              @Const DoublePointer y,
              DoublePointer xVal,
              @Const IntPointer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDgthr(cusparseContext handle,
              int nnz,
              @Const DoubleBuffer y,
              DoubleBuffer xVal,
              @Const IntBuffer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDgthr(cusparseContext handle,
              int nnz,
              @Const double[] y,
              double[] xVal,
              @Const int[] xInd,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseCgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 xVal,
              @Const IntPointer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 xVal,
              @Const IntBuffer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 y,
              @Cast("cuComplex*") float2 xVal,
              @Const int[] xInd,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseZgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 xVal,
              @Const IntPointer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 xVal,
              @Const IntBuffer xInd,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZgthr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 y,
              @Cast("cuDoubleComplex*") double2 xVal,
              @Const int[] xInd,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseSgthrz(cusparseContext handle,
               int nnz,
               FloatPointer y,
               FloatPointer xVal,
               @Const IntPointer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSgthrz(cusparseContext handle,
               int nnz,
               FloatBuffer y,
               FloatBuffer xVal,
               @Const IntBuffer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSgthrz(cusparseContext handle,
               int nnz,
               float[] y,
               float[] xVal,
               @Const int[] xInd,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseDgthrz(cusparseContext handle,
               int nnz,
               DoublePointer y,
               DoublePointer xVal,
               @Const IntPointer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDgthrz(cusparseContext handle,
               int nnz,
               DoubleBuffer y,
               DoubleBuffer xVal,
               @Const IntBuffer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDgthrz(cusparseContext handle,
               int nnz,
               double[] y,
               double[] xVal,
               @Const int[] xInd,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseCgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuComplex*") float2 y,
               @Cast("cuComplex*") float2 xVal,
               @Const IntPointer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuComplex*") float2 y,
               @Cast("cuComplex*") float2 xVal,
               @Const IntBuffer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuComplex*") float2 y,
               @Cast("cuComplex*") float2 xVal,
               @Const int[] xInd,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseZgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 xVal,
               @Const IntPointer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 xVal,
               @Const IntBuffer xInd,
               @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZgthrz(cusparseContext handle,
               int nnz,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cuDoubleComplex*") double2 xVal,
               @Const int[] xInd,
               @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseSsctr(cusparseContext handle,
              int nnz,
              @Const FloatPointer xVal,
              @Const IntPointer xInd,
              FloatPointer y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSsctr(cusparseContext handle,
              int nnz,
              @Const FloatBuffer xVal,
              @Const IntBuffer xInd,
              FloatBuffer y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSsctr(cusparseContext handle,
              int nnz,
              @Const float[] xVal,
              @Const int[] xInd,
              float[] y,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseDsctr(cusparseContext handle,
              int nnz,
              @Const DoublePointer xVal,
              @Const IntPointer xInd,
              DoublePointer y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDsctr(cusparseContext handle,
              int nnz,
              @Const DoubleBuffer xVal,
              @Const IntBuffer xInd,
              DoubleBuffer y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDsctr(cusparseContext handle,
              int nnz,
              @Const double[] xVal,
              @Const int[] xInd,
              double[] y,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseCsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const IntPointer xInd,
              @Cast("cuComplex*") float2 y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const IntBuffer xInd,
              @Cast("cuComplex*") float2 y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseCsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuComplex*") float2 xVal,
              @Const int[] xInd,
              @Cast("cuComplex*") float2 y,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseZsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const IntPointer xInd,
              @Cast("cuDoubleComplex*") double2 y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const IntBuffer xInd,
              @Cast("cuDoubleComplex*") double2 y,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseZsctr(cusparseContext handle,
              int nnz,
              @Cast("const cuDoubleComplex*") double2 xVal,
              @Const int[] xInd,
              @Cast("cuDoubleComplex*") double2 y,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseSroti(cusparseContext handle,
              int nnz,
              FloatPointer xVal,
              @Const IntPointer xInd,
              FloatPointer y,
              @Const FloatPointer c,
              @Const FloatPointer s,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSroti(cusparseContext handle,
              int nnz,
              FloatBuffer xVal,
              @Const IntBuffer xInd,
              FloatBuffer y,
              @Const FloatBuffer c,
              @Const FloatBuffer s,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseSroti(cusparseContext handle,
              int nnz,
              float[] xVal,
              @Const int[] xInd,
              float[] y,
              @Const float[] c,
              @Const float[] s,
              @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseDroti(cusparseContext handle,
              int nnz,
              DoublePointer xVal,
              @Const IntPointer xInd,
              DoublePointer y,
              @Const DoublePointer c,
              @Const DoublePointer s,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDroti(cusparseContext handle,
              int nnz,
              DoubleBuffer xVal,
              @Const IntBuffer xInd,
              DoubleBuffer y,
              @Const DoubleBuffer c,
              @Const DoubleBuffer s,
              @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseDroti(cusparseContext handle,
              int nnz,
              double[] xVal,
              @Const int[] xInd,
              double[] y,
              @Const double[] c,
              @Const double[] s,
              @Cast("cusparseIndexBase_t") int idxBase);

//##############################################################################
//# SPARSE LEVEL 2 ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const FloatPointer alpha,
               @Const FloatPointer A,
               int lda,
               int nnz,
               @Const FloatPointer xVal,
               @Const IntPointer xInd,
               @Const FloatPointer beta,
               FloatPointer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const FloatBuffer alpha,
               @Const FloatBuffer A,
               int lda,
               int nnz,
               @Const FloatBuffer xVal,
               @Const IntBuffer xInd,
               @Const FloatBuffer beta,
               FloatBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const float[] alpha,
               @Const float[] A,
               int lda,
               int nnz,
               @Const float[] xVal,
               @Const int[] xInd,
               @Const float[] beta,
               float[] y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const DoublePointer alpha,
               @Const DoublePointer A,
               int lda,
               int nnz,
               @Const DoublePointer xVal,
               @Const IntPointer xInd,
               @Const DoublePointer beta,
               DoublePointer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const DoubleBuffer alpha,
               @Const DoubleBuffer A,
               int lda,
               int nnz,
               @Const DoubleBuffer xVal,
               @Const IntBuffer xInd,
               @Const DoubleBuffer beta,
               DoubleBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const double[] alpha,
               @Const double[] A,
               int lda,
               int nnz,
               @Const double[] xVal,
               @Const int[] xInd,
               @Const double[] beta,
               double[] y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const int[] xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const int[] xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Const FloatPointer x,
               @Const FloatPointer beta,
               FloatPointer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Const FloatBuffer x,
               @Const FloatBuffer beta,
               FloatBuffer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Const float[] x,
               @Const float[] beta,
               float[] y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Const DoublePointer x,
               @Const DoublePointer beta,
               DoublePointer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Const DoubleBuffer x,
               @Const DoubleBuffer beta,
               DoubleBuffer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Const double[] x,
               @Const double[] beta,
               double[] y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx_bufferSize(cusparseContext handle,
                           @Cast("cusparseAlgMode_t") int alg,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int n,
                           int nnz,
                           @Const Pointer alpha,
                           @Cast("cudaDataType") int alphatype,
                           cusparseMatDescr descrA,
                           @Const Pointer csrValA,
                           @Cast("cudaDataType") int csrValAtype,
                           @Const IntPointer csrRowPtrA,
                           @Const IntPointer csrColIndA,
                           @Const Pointer x,
                           @Cast("cudaDataType") int xtype,
                           @Const Pointer beta,
                           @Cast("cudaDataType") int betatype,
                           Pointer y,
                           @Cast("cudaDataType") int ytype,
                           @Cast("cudaDataType") int executiontype,
                           @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx_bufferSize(cusparseContext handle,
                           @Cast("cusparseAlgMode_t") int alg,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int n,
                           int nnz,
                           @Const Pointer alpha,
                           @Cast("cudaDataType") int alphatype,
                           cusparseMatDescr descrA,
                           @Const Pointer csrValA,
                           @Cast("cudaDataType") int csrValAtype,
                           @Const IntBuffer csrRowPtrA,
                           @Const IntBuffer csrColIndA,
                           @Const Pointer x,
                           @Cast("cudaDataType") int xtype,
                           @Const Pointer beta,
                           @Cast("cudaDataType") int betatype,
                           Pointer y,
                           @Cast("cudaDataType") int ytype,
                           @Cast("cudaDataType") int executiontype,
                           @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx_bufferSize(cusparseContext handle,
                           @Cast("cusparseAlgMode_t") int alg,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int n,
                           int nnz,
                           @Const Pointer alpha,
                           @Cast("cudaDataType") int alphatype,
                           cusparseMatDescr descrA,
                           @Const Pointer csrValA,
                           @Cast("cudaDataType") int csrValAtype,
                           @Const int[] csrRowPtrA,
                           @Const int[] csrColIndA,
                           @Const Pointer x,
                           @Cast("cudaDataType") int xtype,
                           @Const Pointer beta,
                           @Cast("cudaDataType") int betatype,
                           Pointer y,
                           @Cast("cudaDataType") int ytype,
                           @Cast("cudaDataType") int executiontype,
                           @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx(cusparseContext handle,
                @Cast("cusparseAlgMode_t") int alg,
                @Cast("cusparseOperation_t") int transA,
                int m,
                int n,
                int nnz,
                @Const Pointer alpha,
                @Cast("cudaDataType") int alphatype,
                cusparseMatDescr descrA,
                @Const Pointer csrValA,
                @Cast("cudaDataType") int csrValAtype,
                @Const IntPointer csrRowPtrA,
                @Const IntPointer csrColIndA,
                @Const Pointer x,
                @Cast("cudaDataType") int xtype,
                @Const Pointer beta,
                @Cast("cudaDataType") int betatype,
                Pointer y,
                @Cast("cudaDataType") int ytype,
                @Cast("cudaDataType") int executiontype,
                Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx(cusparseContext handle,
                @Cast("cusparseAlgMode_t") int alg,
                @Cast("cusparseOperation_t") int transA,
                int m,
                int n,
                int nnz,
                @Const Pointer alpha,
                @Cast("cudaDataType") int alphatype,
                cusparseMatDescr descrA,
                @Const Pointer csrValA,
                @Cast("cudaDataType") int csrValAtype,
                @Const IntBuffer csrRowPtrA,
                @Const IntBuffer csrColIndA,
                @Const Pointer x,
                @Cast("cudaDataType") int xtype,
                @Const Pointer beta,
                @Cast("cudaDataType") int betatype,
                Pointer y,
                @Cast("cudaDataType") int ytype,
                @Cast("cudaDataType") int executiontype,
                Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsrmvEx(cusparseContext handle,
                @Cast("cusparseAlgMode_t") int alg,
                @Cast("cusparseOperation_t") int transA,
                int m,
                int n,
                int nnz,
                @Const Pointer alpha,
                @Cast("cudaDataType") int alphatype,
                cusparseMatDescr descrA,
                @Const Pointer csrValA,
                @Cast("cudaDataType") int csrValAtype,
                @Const int[] csrRowPtrA,
                @Const int[] csrColIndA,
                @Const Pointer x,
                @Cast("cudaDataType") int xtype,
                @Const Pointer beta,
                @Cast("cudaDataType") int betatype,
                Pointer y,
                @Cast("cudaDataType") int ytype,
                @Cast("cudaDataType") int executiontype,
                Pointer buffer);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const FloatPointer alpha,
                  cusparseMatDescr descrA,
                  @Const FloatPointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const FloatPointer x,
                  @Const FloatPointer beta,
                  FloatPointer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const FloatBuffer alpha,
                  cusparseMatDescr descrA,
                  @Const FloatBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const FloatBuffer x,
                  @Const FloatBuffer beta,
                  FloatBuffer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const float[] alpha,
                  cusparseMatDescr descrA,
                  @Const float[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const float[] x,
                  @Const float[] beta,
                  float[] y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const DoublePointer alpha,
                  cusparseMatDescr descrA,
                  @Const DoublePointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const DoublePointer x,
                  @Const DoublePointer beta,
                  DoublePointer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const DoubleBuffer alpha,
                  cusparseMatDescr descrA,
                  @Const DoubleBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const DoubleBuffer x,
                  @Const DoubleBuffer beta,
                  DoubleBuffer y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Const double[] alpha,
                  cusparseMatDescr descrA,
                  @Const double[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const double[] x,
                  @Const double[] beta,
                  double[] y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 x,
                  @Cast("const cuComplex*") float2 beta,
                  @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 x,
                  @Cast("const cuComplex*") float2 beta,
                  @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuComplex*") float2 x,
                  @Cast("const cuComplex*") float2 beta,
                  @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 x,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 x,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmv_mp(cusparseContext handle,
                  @Cast("cusparseOperation_t") int transA,
                  int m,
                  int n,
                  int nnz,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 x,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseShybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const FloatPointer x,
               @Const FloatPointer beta,
               FloatPointer y);
public static native @Cast("cusparseStatus_t") int cusparseShybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const FloatBuffer x,
               @Const FloatBuffer beta,
               FloatBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseShybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const float[] x,
               @Const float[] beta,
               float[] y);

public static native @Cast("cusparseStatus_t") int cusparseDhybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const DoublePointer x,
               @Const DoublePointer beta,
               DoublePointer y);
public static native @Cast("cusparseStatus_t") int cusparseDhybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const DoubleBuffer x,
               @Const DoubleBuffer beta,
               DoubleBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseDhybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Const double[] x,
               @Const double[] beta,
               double[] y);

public static native @Cast("cusparseStatus_t") int cusparseChybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") int cusparseZhybmv(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               cusparseHybMat hybA,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Const FloatPointer x,
               @Const FloatPointer beta,
               FloatPointer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Const FloatBuffer x,
               @Const FloatBuffer beta,
               FloatBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Const float[] x,
               @Const float[] beta,
               float[] y);

public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Const DoublePointer x,
               @Const DoublePointer beta,
               DoublePointer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Const DoubleBuffer x,
               @Const DoubleBuffer beta,
               DoubleBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Const double[] x,
               @Const double[] beta,
               double[] y);

public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const FloatPointer alpha,
                cusparseMatDescr descrA,
                @Const FloatPointer bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Const FloatPointer x,
                @Const FloatPointer beta,
                FloatPointer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const FloatBuffer alpha,
                cusparseMatDescr descrA,
                @Const FloatBuffer bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Const FloatBuffer x,
                @Const FloatBuffer beta,
                FloatBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const float[] alpha,
                cusparseMatDescr descrA,
                @Const float[] bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Const float[] x,
                @Const float[] beta,
                float[] y);

public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const DoublePointer alpha,
                cusparseMatDescr descrA,
                @Const DoublePointer bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Const DoublePointer x,
                @Const DoublePointer beta,
                DoublePointer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const DoubleBuffer alpha,
                cusparseMatDescr descrA,
                @Const DoubleBuffer bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Const DoubleBuffer x,
                @Const DoubleBuffer beta,
                DoubleBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const double[] alpha,
                cusparseMatDescr descrA,
                @Const double[] bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Const double[] x,
                @Const double[] beta,
                double[] y);

public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             @Cast("cusparseOperation_t") int transA,
             int sizeOfMask,
             int mb,
             int nb,
             int nnzb,
             @Cast("const cuDoubleComplex*") double2 alpha,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
             @Const IntPointer bsrSortedMaskPtrA,
             @Const IntPointer bsrSortedRowPtrA,
             @Const IntPointer bsrSortedEndPtrA,
             @Const IntPointer bsrSortedColIndA,
             int blockDim,
             @Cast("const cuDoubleComplex*") double2 x,
             @Cast("const cuDoubleComplex*") double2 beta,
             @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             @Cast("cusparseOperation_t") int transA,
             int sizeOfMask,
             int mb,
             int nb,
             int nnzb,
             @Cast("const cuDoubleComplex*") double2 alpha,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
             @Const IntBuffer bsrSortedMaskPtrA,
             @Const IntBuffer bsrSortedRowPtrA,
             @Const IntBuffer bsrSortedEndPtrA,
             @Const IntBuffer bsrSortedColIndA,
             int blockDim,
             @Cast("const cuDoubleComplex*") double2 x,
             @Cast("const cuDoubleComplex*") double2 beta,
             @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             @Cast("cusparseOperation_t") int transA,
             int sizeOfMask,
             int mb,
             int nb,
             int nnzb,
             @Cast("const cuDoubleComplex*") double2 alpha,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
             @Const int[] bsrSortedMaskPtrA,
             @Const int[] bsrSortedRowPtrA,
             @Const int[] bsrSortedEndPtrA,
             @Const int[] bsrSortedColIndA,
             int blockDim,
             @Cast("const cuDoubleComplex*") double2 x,
             @Cast("const cuDoubleComplex*") double2 beta,
             @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_analysisEx(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const Pointer csrSortedValA,
                         @Cast("cudaDataType") int csrSortedValAtype,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         cusparseSolveAnalysisInfo info,
                         @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_analysisEx(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const Pointer csrSortedValA,
                         @Cast("cudaDataType") int csrSortedValAtype,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         cusparseSolveAnalysisInfo info,
                         @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_analysisEx(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const Pointer csrSortedValA,
                         @Cast("cudaDataType") int csrSortedValAtype,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         cusparseSolveAnalysisInfo info,
                         @Cast("cudaDataType") int executiontype);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const FloatPointer csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const FloatBuffer csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const float[] csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const DoublePointer csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const DoubleBuffer csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const double[] csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_solveEx(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      @Const Pointer alpha,
                      @Cast("cudaDataType") int alphatype,
                      cusparseMatDescr descrA,
                      @Const Pointer csrSortedValA,
                      @Cast("cudaDataType") int csrSortedValAtype,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      cusparseSolveAnalysisInfo info,
                      @Const Pointer f,
                      @Cast("cudaDataType") int ftype,
                      Pointer x,
                      @Cast("cudaDataType") int xtype,
                      @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_solveEx(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      @Const Pointer alpha,
                      @Cast("cudaDataType") int alphatype,
                      cusparseMatDescr descrA,
                      @Const Pointer csrSortedValA,
                      @Cast("cudaDataType") int csrSortedValAtype,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      cusparseSolveAnalysisInfo info,
                      @Const Pointer f,
                      @Cast("cudaDataType") int ftype,
                      Pointer x,
                      @Cast("cudaDataType") int xtype,
                      @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsrsv_solveEx(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      @Const Pointer alpha,
                      @Cast("cudaDataType") int alphatype,
                      cusparseMatDescr descrA,
                      @Const Pointer csrSortedValA,
                      @Cast("cudaDataType") int csrSortedValAtype,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      cusparseSolveAnalysisInfo info,
                      @Const Pointer f,
                      @Cast("cudaDataType") int ftype,
                      Pointer x,
                      @Cast("cudaDataType") int xtype,
                      @Cast("cudaDataType") int executiontype);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const FloatPointer alpha,
                     cusparseMatDescr descrA,
                     @Const FloatPointer csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatPointer f,
                     FloatPointer x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const FloatBuffer alpha,
                     cusparseMatDescr descrA,
                     @Const FloatBuffer csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatBuffer f,
                     FloatBuffer x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const float[] alpha,
                     cusparseMatDescr descrA,
                     @Const float[] csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const float[] f,
                     float[] x);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const DoublePointer alpha,
                     cusparseMatDescr descrA,
                     @Const DoublePointer csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoublePointer f,
                     DoublePointer x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const DoubleBuffer alpha,
                     cusparseMatDescr descrA,
                     @Const DoubleBuffer csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoubleBuffer f,
                     DoubleBuffer x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Const double[] alpha,
                     cusparseMatDescr descrA,
                     @Const double[] csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const double[] f,
                     double[] x);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 f,
                     @Cast("cuComplex*") float2 x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 f,
                     @Cast("cuComplex*") float2 x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 f,
                     @Cast("cuComplex*") float2 x);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 f,
                     @Cast("cuDoubleComplex*") double2 x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 f,
                     @Cast("cuDoubleComplex*") double2 x);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 f,
                     @Cast("cuDoubleComplex*") double2 x);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsv2_zeroPivot(cusparseContext handle,
                          csrsv2Info info,
                          IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsv2_zeroPivot(cusparseContext handle,
                          csrsv2Info info,
                          IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsv2_zeroPivot(cusparseContext handle,
                          csrsv2Info info,
                          int[] position);

public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           FloatPointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           FloatBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           float[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           DoublePointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           DoubleBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           double[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseOperation_t") int transA,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              FloatPointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              FloatBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              float[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              DoublePointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              DoubleBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              double[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseOperation_t") int transA,
                              int m,
                              int nnz,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              csrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const FloatPointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const float[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const DoublePointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Const double[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseOperation_t") int transA,
                         int m,
                         int nnz,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         csrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      csrsv2Info info,
                      @Const FloatPointer f,
                      FloatPointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      csrsv2Info info,
                      @Const FloatBuffer f,
                      FloatBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      csrsv2Info info,
                      @Const float[] f,
                      float[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      csrsv2Info info,
                      @Const DoublePointer f,
                      DoublePointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      csrsv2Info info,
                      @Const DoubleBuffer f,
                      DoubleBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      csrsv2Info info,
                      @Const double[] f,
                      double[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseOperation_t") int transA,
                      int m,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      csrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          int[] position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              FloatPointer bsrSortedValA,
                              @Const IntPointer bsrSortedRowPtrA,
                              @Const IntPointer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              FloatBuffer bsrSortedValA,
                              @Const IntBuffer bsrSortedRowPtrA,
                              @Const IntBuffer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              float[] bsrSortedValA,
                              @Const int[] bsrSortedRowPtrA,
                              @Const int[] bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              DoublePointer bsrSortedValA,
                              @Const IntPointer bsrSortedRowPtrA,
                              @Const IntPointer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              DoubleBuffer bsrSortedValA,
                              @Const IntBuffer bsrSortedRowPtrA,
                              @Const IntBuffer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              double[] bsrSortedValA,
                              @Const int[] bsrSortedRowPtrA,
                              @Const int[] bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedValA,
                              @Const IntPointer bsrSortedRowPtrA,
                              @Const IntPointer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedValA,
                              @Const IntBuffer bsrSortedRowPtrA,
                              @Const IntBuffer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedValA,
                              @Const int[] bsrSortedRowPtrA,
                              @Const int[] bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                              @Const IntPointer bsrSortedRowPtrA,
                              @Const IntPointer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                              @Const IntBuffer bsrSortedRowPtrA,
                              @Const IntBuffer bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              int mb,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                              @Const int[] bsrSortedRowPtrA,
                              @Const int[] bsrSortedColIndA,
                              int blockSize,
                              bsrsv2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatPointer bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const float[] bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoublePointer bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const double[] bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const FloatPointer f,
                      FloatPointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const FloatBuffer f,
                      FloatBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const float[] f,
                      float[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const DoublePointer f,
                      DoublePointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const DoubleBuffer f,
                      DoubleBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const double[] f,
                      double[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseShybsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        cusparseMatDescr descrA,
                        cusparseHybMat hybA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDhybsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        cusparseMatDescr descrA,
                        cusparseHybMat hybA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseChybsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        cusparseMatDescr descrA,
                        cusparseHybMat hybA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseZhybsv_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        cusparseMatDescr descrA,
                        cusparseHybMat hybA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseShybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const FloatPointer alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatPointer f,
                     FloatPointer x);
public static native @Cast("cusparseStatus_t") int cusparseShybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const FloatBuffer alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatBuffer f,
                     FloatBuffer x);
public static native @Cast("cusparseStatus_t") int cusparseShybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const float[] alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const float[] f,
                     float[] x);

public static native @Cast("cusparseStatus_t") int cusparseChybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 f,
                     @Cast("cuComplex*") float2 x);

public static native @Cast("cusparseStatus_t") int cusparseDhybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const DoublePointer alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoublePointer f,
                     DoublePointer x);
public static native @Cast("cusparseStatus_t") int cusparseDhybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const DoubleBuffer alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoubleBuffer f,
                     DoubleBuffer x);
public static native @Cast("cusparseStatus_t") int cusparseDhybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Const double[] alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Const double[] f,
                     double[] x);

public static native @Cast("cusparseStatus_t") int cusparseZhybsv_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int trans,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     cusparseHybMat hybA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 f,
                     @Cast("cuDoubleComplex*") double2 x);

//##############################################################################
//# SPARSE LEVEL 3 ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Const FloatPointer B,
               int ldb,
               @Const FloatPointer beta,
               FloatPointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Const FloatBuffer B,
               int ldb,
               @Const FloatBuffer beta,
               FloatBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Const float[] B,
               int ldb,
               @Const float[] beta,
               float[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Const DoublePointer B,
               int ldb,
               @Const DoublePointer beta,
               DoublePointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Const DoubleBuffer B,
               int ldb,
               @Const DoubleBuffer beta,
               DoubleBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Const double[] B,
               int ldb,
               @Const double[] beta,
               double[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const IntPointer csrSortedRowPtrA,
               @Const IntPointer csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 B,
               int ldb,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const IntBuffer csrSortedRowPtrA,
               @Const IntBuffer csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 B,
               int ldb,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               int k,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 csrSortedValA,
               @Const int[] csrSortedRowPtrA,
               @Const int[] csrSortedColIndA,
               @Cast("const cuDoubleComplex*") double2 B,
               int ldb,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 C,
               int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const FloatPointer alpha,
                cusparseMatDescr descrA,
                @Const FloatPointer csrSortedValA,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                @Const FloatPointer B,
                int ldb,
                @Const FloatPointer beta,
                FloatPointer C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const FloatBuffer alpha,
                cusparseMatDescr descrA,
                @Const FloatBuffer csrSortedValA,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                @Const FloatBuffer B,
                int ldb,
                @Const FloatBuffer beta,
                FloatBuffer C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const float[] alpha,
                cusparseMatDescr descrA,
                @Const float[] csrSortedValA,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                @Const float[] B,
                int ldb,
                @Const float[] beta,
                float[] C,
                int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const DoublePointer alpha,
                cusparseMatDescr descrA,
                @Const DoublePointer csrSortedValA,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                @Const DoublePointer B,
                int ldb,
                @Const DoublePointer beta,
                DoublePointer C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const DoubleBuffer alpha,
                cusparseMatDescr descrA,
                @Const DoubleBuffer csrSortedValA,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                @Const DoubleBuffer B,
                int ldb,
                @Const DoubleBuffer beta,
                DoubleBuffer C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Const double[] alpha,
                cusparseMatDescr descrA,
                @Const double[] csrSortedValA,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                @Const double[] B,
                int ldb,
                @Const double[] beta,
                double[] C,
                int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 csrSortedValA,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                @Cast("const cuComplex*") float2 B,
                int ldb,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 csrSortedValA,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                @Cast("const cuComplex*") float2 B,
                int ldb,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 csrSortedValA,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                @Cast("const cuComplex*") float2 B,
                int ldb,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 C,
                int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrmm2(cusparseContext handle,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int m,
                int n,
                int k,
                int nnz,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Const FloatPointer B,
               int ldb,
               @Const FloatPointer beta,
               FloatPointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Const FloatBuffer B,
               int ldb,
               @Const FloatBuffer beta,
               FloatBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Const float[] B,
               int ldb,
               @Const float[] beta,
               float[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Const DoublePointer B,
               int ldb,
               @Const DoublePointer beta,
               DoublePointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Const DoubleBuffer B,
               int ldb,
               @Const DoubleBuffer beta,
               DoubleBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Const double[] B,
               int ldb,
               @Const double[] beta,
               double[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseSgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const FloatPointer alpha,
                                @Const FloatPointer A,
                                int lda,
                                @Const FloatPointer cscValB,
                                @Const IntPointer cscColPtrB,
                                @Const IntPointer cscRowIndB,
                                @Const FloatPointer beta,
                                FloatPointer C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const FloatBuffer alpha,
                                @Const FloatBuffer A,
                                int lda,
                                @Const FloatBuffer cscValB,
                                @Const IntBuffer cscColPtrB,
                                @Const IntBuffer cscRowIndB,
                                @Const FloatBuffer beta,
                                FloatBuffer C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const float[] alpha,
                                @Const float[] A,
                                int lda,
                                @Const float[] cscValB,
                                @Const int[] cscColPtrB,
                                @Const int[] cscRowIndB,
                                @Const float[] beta,
                                float[] C,
                                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseDgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const DoublePointer alpha,
                                @Const DoublePointer A,
                                int lda,
                                @Const DoublePointer cscValB,
                                @Const IntPointer cscColPtrB,
                                @Const IntPointer cscRowIndB,
                                @Const DoublePointer beta,
                                DoublePointer C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const DoubleBuffer alpha,
                                @Const DoubleBuffer A,
                                int lda,
                                @Const DoubleBuffer cscValB,
                                @Const IntBuffer cscColPtrB,
                                @Const IntBuffer cscRowIndB,
                                @Const DoubleBuffer beta,
                                DoubleBuffer C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Const double[] alpha,
                                @Const double[] A,
                                int lda,
                                @Const double[] cscValB,
                                @Const int[] cscColPtrB,
                                @Const int[] cscRowIndB,
                                @Const double[] beta,
                                double[] C,
                                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseCgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuComplex*") float2 alpha,
                                @Cast("const cuComplex*") float2 A,
                                int lda,
                                @Cast("const cuComplex*") float2 cscValB,
                                @Const IntPointer cscColPtrB,
                                @Const IntPointer cscRowIndB,
                                @Cast("const cuComplex*") float2 beta,
                                @Cast("cuComplex*") float2 C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuComplex*") float2 alpha,
                                @Cast("const cuComplex*") float2 A,
                                int lda,
                                @Cast("const cuComplex*") float2 cscValB,
                                @Const IntBuffer cscColPtrB,
                                @Const IntBuffer cscRowIndB,
                                @Cast("const cuComplex*") float2 beta,
                                @Cast("cuComplex*") float2 C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuComplex*") float2 alpha,
                                @Cast("const cuComplex*") float2 A,
                                int lda,
                                @Cast("const cuComplex*") float2 cscValB,
                                @Const int[] cscColPtrB,
                                @Const int[] cscRowIndB,
                                @Cast("const cuComplex*") float2 beta,
                                @Cast("cuComplex*") float2 C,
                                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseZgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                @Cast("const cuDoubleComplex*") double2 A,
                                int lda,
                                @Cast("const cuDoubleComplex*") double2 cscValB,
                                @Const IntPointer cscColPtrB,
                                @Const IntPointer cscRowIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                @Cast("cuDoubleComplex*") double2 C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                @Cast("const cuDoubleComplex*") double2 A,
                                int lda,
                                @Cast("const cuDoubleComplex*") double2 cscValB,
                                @Const IntBuffer cscColPtrB,
                                @Const IntBuffer cscRowIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                @Cast("cuDoubleComplex*") double2 C,
                                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZgemmi(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                int nnz,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                @Cast("const cuDoubleComplex*") double2 A,
                                int lda,
                                @Cast("const cuDoubleComplex*") double2 cscValB,
                                @Const int[] cscColPtrB,
                                @Const int[] cscRowIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                @Cast("cuDoubleComplex*") double2 C,
                                int ldc);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const FloatPointer csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const FloatBuffer csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const float[] csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const DoublePointer csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const DoubleBuffer csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Const double[] csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuComplex*") float2 csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const IntPointer csrSortedRowPtrA,
                        @Const IntPointer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const IntBuffer csrSortedRowPtrA,
                        @Const IntBuffer csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_analysis(cusparseContext handle,
                        @Cast("cusparseOperation_t") int transA,
                        int m,
                        int nnz,
                        cusparseMatDescr descrA,
                        @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                        @Const int[] csrSortedRowPtrA,
                        @Const int[] csrSortedColIndA,
                        cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const FloatPointer alpha,
                     cusparseMatDescr descrA,
                     @Const FloatPointer csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatPointer B,
                     int ldb,
                     FloatPointer X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const FloatBuffer alpha,
                     cusparseMatDescr descrA,
                     @Const FloatBuffer csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const FloatBuffer B,
                     int ldb,
                     FloatBuffer X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const float[] alpha,
                     cusparseMatDescr descrA,
                     @Const float[] csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const float[] B,
                     int ldb,
                     float[] X,
                     int ldx);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const DoublePointer alpha,
                     cusparseMatDescr descrA,
                     @Const DoublePointer csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoublePointer B,
                     int ldb,
                     DoublePointer X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const DoubleBuffer alpha,
                     cusparseMatDescr descrA,
                     @Const DoubleBuffer csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const DoubleBuffer B,
                     int ldb,
                     DoubleBuffer X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Const double[] alpha,
                     cusparseMatDescr descrA,
                     @Const double[] csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Const double[] B,
                     int ldb,
                     double[] X,
                     int ldx);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 B,
                     int ldb,
                     @Cast("cuComplex*") float2 X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 B,
                     int ldb,
                     @Cast("cuComplex*") float2 X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuComplex*") float2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuComplex*") float2 B,
                     int ldb,
                     @Cast("cuComplex*") float2 X,
                     int ldx);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 B,
                     int ldb,
                     @Cast("cuDoubleComplex*") double2 X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 B,
                     int ldb,
                     @Cast("cuDoubleComplex*") double2 X,
                     int ldx);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrsm_solve(cusparseContext handle,
                     @Cast("cusparseOperation_t") int transA,
                     int m,
                     int n,
                     @Cast("const cuDoubleComplex*") double2 alpha,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseSolveAnalysisInfo info,
                     @Cast("const cuDoubleComplex*") double2 B,
                     int ldb,
                     @Cast("cuDoubleComplex*") double2 X,
                     int ldx);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsrsm2Info(@ByPtrPtr csrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsrsm2Info(csrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsm2_zeroPivot(cusparseContext handle,
                          csrsm2Info info,
                          IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsm2_zeroPivot(cusparseContext handle,
                          csrsm2Info info,
                          IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsm2_zeroPivot(cusparseContext handle,
                          csrsm2Info info,
                          int[] position);

public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const FloatPointer alpha,
                              cusparseMatDescr descrA,
                              @Const FloatPointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              @Const FloatPointer B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const FloatBuffer alpha,
                              cusparseMatDescr descrA,
                              @Const FloatBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              @Const FloatBuffer B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const float[] alpha,
                              cusparseMatDescr descrA,
                              @Const float[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              @Const float[] B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const DoublePointer alpha,
                              cusparseMatDescr descrA,
                              @Const DoublePointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              @Const DoublePointer B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const DoubleBuffer alpha,
                              cusparseMatDescr descrA,
                              @Const DoubleBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              @Const DoubleBuffer B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Const double[] alpha,
                              cusparseMatDescr descrA,
                              @Const double[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              @Const double[] B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuComplex*") float2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuComplex*") float2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuComplex*") float2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              @Cast("const cuComplex*") float2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuDoubleComplex*") double2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuDoubleComplex*") double2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_bufferSizeExt(cusparseContext handle,
                              int algo,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int m,
                              int nrhs,
                              int nnz,
                              @Cast("const cuDoubleComplex*") double2 alpha,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              @Cast("const cuDoubleComplex*") double2 B,
                              int ldb,
                              csrsm2Info info,
                              @Cast("cusparseSolvePolicy_t") int policy,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const FloatPointer alpha,
                         cusparseMatDescr descrA,
                         @Const FloatPointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const FloatPointer B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const FloatBuffer alpha,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const FloatBuffer B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const float[] alpha,
                         cusparseMatDescr descrA,
                         @Const float[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const float[] B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const DoublePointer alpha,
                         cusparseMatDescr descrA,
                         @Const DoublePointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const DoublePointer B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const DoubleBuffer alpha,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const DoubleBuffer B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Const double[] alpha,
                         cusparseMatDescr descrA,
                         @Const double[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const double[] B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuComplex*") float2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Cast("const cuComplex*") float2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuComplex*") float2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Cast("const cuComplex*") float2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuComplex*") float2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Cast("const cuComplex*") float2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuDoubleComplex*") double2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Cast("const cuDoubleComplex*") double2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuDoubleComplex*") double2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Cast("const cuDoubleComplex*") double2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_analysis(cusparseContext handle,
                         int algo,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transB,
                         int m,
                         int nrhs,
                         int nnz,
                         @Cast("const cuDoubleComplex*") double2 alpha,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Cast("const cuDoubleComplex*") double2 B,
                         int ldb,
                         csrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      FloatPointer B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      FloatBuffer B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      float[] B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      DoublePointer B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      DoubleBuffer B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      double[] B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Cast("cuComplex*") float2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Cast("cuComplex*") float2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Cast("cuComplex*") float2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Cast("cuDoubleComplex*") double2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Cast("cuDoubleComplex*") double2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrsm2_solve(cusparseContext handle,
                      int algo,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transB,
                      int m,
                      int nrhs,
                      int nnz,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Cast("cuDoubleComplex*") double2 B,
                      int ldb,
                      csrsm2Info info,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          int[] position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              FloatPointer bsrSortedVal,
                              @Const IntPointer bsrSortedRowPtr,
                              @Const IntPointer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              FloatBuffer bsrSortedVal,
                              @Const IntBuffer bsrSortedRowPtr,
                              @Const IntBuffer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              float[] bsrSortedVal,
                              @Const int[] bsrSortedRowPtr,
                              @Const int[] bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              DoublePointer bsrSortedVal,
                              @Const IntPointer bsrSortedRowPtr,
                              @Const IntPointer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              DoubleBuffer bsrSortedVal,
                              @Const IntBuffer bsrSortedRowPtr,
                              @Const IntBuffer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              double[] bsrSortedVal,
                              @Const int[] bsrSortedRowPtr,
                              @Const int[] bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedVal,
                              @Const IntPointer bsrSortedRowPtr,
                              @Const IntPointer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedVal,
                              @Const IntBuffer bsrSortedRowPtr,
                              @Const IntBuffer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuComplex*") float2 bsrSortedVal,
                              @Const int[] bsrSortedRowPtr,
                              @Const int[] bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                              @Const IntPointer bsrSortedRowPtr,
                              @Const IntPointer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                              @Const IntBuffer bsrSortedRowPtr,
                              @Const IntBuffer bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSizeExt(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              @Cast("cusparseOperation_t") int transA,
                              @Cast("cusparseOperation_t") int transB,
                              int mb,
                              int n,
                              int nnzb,
                              cusparseMatDescr descrA,
                              @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                              @Const int[] bsrSortedRowPtr,
                              @Const int[] bsrSortedColInd,
                              int blockSize,
                              bsrsm2Info info,
                              @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatPointer bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const float[] bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoublePointer bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const double[] bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const FloatPointer B,
                      int ldb,
                      FloatPointer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const FloatBuffer B,
                      int ldb,
                      FloatBuffer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const float[] B,
                      int ldb,
                      float[] X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const DoublePointer B,
                      int ldb,
                      DoublePointer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const DoubleBuffer B,
                      int ldb,
                      DoubleBuffer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const double[] B,
                      int ldb,
                      double[] X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

//##############################################################################
//# PRECONDITIONERS
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCsrilu0Ex(cusparseContext handle,
                  @Cast("cusparseOperation_t") int trans,
                  int m,
                  cusparseMatDescr descrA,
                  Pointer csrSortedValA_ValM,
                  @Cast("cudaDataType") int csrSortedValA_ValMtype,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  cusparseSolveAnalysisInfo info,
                  @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") int cusparseCsrilu0Ex(cusparseContext handle,
                  @Cast("cusparseOperation_t") int trans,
                  int m,
                  cusparseMatDescr descrA,
                  Pointer csrSortedValA_ValM,
                  @Cast("cudaDataType") int csrSortedValA_ValMtype,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  cusparseSolveAnalysisInfo info,
                  @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") int cusparseCsrilu0Ex(cusparseContext handle,
                  @Cast("cusparseOperation_t") int trans,
                  int m,
                  cusparseMatDescr descrA,
                  Pointer csrSortedValA_ValM,
                  @Cast("cudaDataType") int csrSortedValA_ValMtype,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  cusparseSolveAnalysisInfo info,
                  @Cast("cudaDataType") int executiontype);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                FloatPointer csrSortedValA_ValM,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                FloatBuffer csrSortedValA_ValM,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                float[] csrSortedValA_ValM,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 DoublePointer csrSortedValA_ValM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 DoubleBuffer csrSortedValA_ValM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 double[] csrSortedValA_ValM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu0(cusparseContext handle,
              @Cast("cusparseOperation_t") int trans,
              int m,
              cusparseMatDescr descrA,
              @Cast("cuComplex*") float2 csrSortedValA_ValM,
              @Const IntPointer csrSortedRowPtrA,
              @Const IntPointer csrSortedColIndA,
              cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu0(cusparseContext handle,
              @Cast("cusparseOperation_t") int trans,
              int m,
              cusparseMatDescr descrA,
              @Cast("cuComplex*") float2 csrSortedValA_ValM,
              @Const IntBuffer csrSortedRowPtrA,
              @Const IntBuffer csrSortedColIndA,
              cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu0(cusparseContext handle,
              @Cast("cusparseOperation_t") int trans,
              int m,
              cusparseMatDescr descrA,
              @Cast("cuComplex*") float2 csrSortedValA_ValM,
              @Const int[] csrSortedRowPtrA,
              @Const int[] csrSortedColIndA,
              cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu0(cusparseContext handle,
                 @Cast("cusparseOperation_t") int trans,
                 int m,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               FloatPointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               FloatBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               float[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               DoublePointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               DoubleBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               double[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuComplex*") float2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            int[] position);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             FloatPointer csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             FloatBuffer csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             float[] csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             DoublePointer csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             DoubleBuffer csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             double[] csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                FloatPointer csrSortedVal,
                                @Const IntPointer csrSortedRowPtr,
                                @Const IntPointer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                FloatBuffer csrSortedVal,
                                @Const IntBuffer csrSortedRowPtr,
                                @Const IntBuffer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                float[] csrSortedVal,
                                @Const int[] csrSortedRowPtr,
                                @Const int[] csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                DoublePointer csrSortedVal,
                                @Const IntPointer csrSortedRowPtr,
                                @Const IntPointer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                DoubleBuffer csrSortedVal,
                                @Const IntBuffer csrSortedRowPtr,
                                @Const IntBuffer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                double[] csrSortedVal,
                                @Const int[] csrSortedRowPtr,
                                @Const int[] csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 csrSortedVal,
                                @Const IntPointer csrSortedRowPtr,
                                @Const IntPointer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 csrSortedVal,
                                @Const IntBuffer csrSortedRowPtr,
                                @Const IntBuffer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 csrSortedVal,
                                @Const int[] csrSortedRowPtr,
                                @Const int[] csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuDoubleComplex*") double2 csrSortedVal,
                                @Const IntPointer csrSortedRowPtr,
                                @Const IntPointer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuDoubleComplex*") double2 csrSortedVal,
                                @Const IntBuffer csrSortedRowPtr,
                                @Const IntBuffer csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSizeExt(cusparseContext handle,
                                int m,
                                int nnz,
                                cusparseMatDescr descrA,
                                @Cast("cuDoubleComplex*") double2 csrSortedVal,
                                @Const int[] csrSortedRowPtr,
                                @Const int[] csrSortedColInd,
                                csrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const FloatPointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const FloatBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const float[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const DoublePointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const DoubleBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const double[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               FloatPointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               FloatBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               float[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               DoublePointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               DoubleBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               double[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuComplex*") float2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            int[] position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             FloatPointer bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             FloatBuffer bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             float[] bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             DoublePointer bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             DoubleBuffer bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             double[] bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                FloatPointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                FloatBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                float[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                DoublePointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                DoubleBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                double[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("cuComplex*") float2 bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int blockSize,
                                bsrilu02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const IntPointer bsrSortedRowPtr,
                               @Const IntPointer bsrSortedColInd,
                               int blockSize,
                               bsrilu02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const IntBuffer bsrSortedRowPtr,
                               @Const IntBuffer bsrSortedColInd,
                               int blockSize,
                               bsrilu02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const int[] bsrSortedRowPtr,
                               @Const int[] bsrSortedColInd,
                               int blockSize,
                               bsrilu02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  FloatPointer bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  FloatBuffer bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  float[] bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  DoublePointer bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  DoubleBuffer bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  double[] bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                FloatPointer csrSortedValA_ValM,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                FloatBuffer csrSortedValA_ValM,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                float[] csrSortedValA_ValM,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                DoublePointer csrSortedValA_ValM,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                DoubleBuffer csrSortedValA_ValM,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                double[] csrSortedValA_ValM,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuComplex*") float2 csrSortedValA_ValM,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuComplex*") float2 csrSortedValA_ValM,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuComplex*") float2 csrSortedValA_ValM,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseZcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                cusparseSolveAnalysisInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsric0(cusparseContext handle,
                @Cast("cusparseOperation_t") int trans,
                int m,
                cusparseMatDescr descrA,
                @Cast("cuDoubleComplex*") double2 csrSortedValA_ValM,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                cusparseSolveAnalysisInfo info);

public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           int[] position);

public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            FloatPointer csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            FloatBuffer csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            float[] csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            DoublePointer csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            DoubleBuffer csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            double[] csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               FloatPointer csrSortedVal,
                               @Const IntPointer csrSortedRowPtr,
                               @Const IntPointer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               FloatBuffer csrSortedVal,
                               @Const IntBuffer csrSortedRowPtr,
                               @Const IntBuffer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               float[] csrSortedVal,
                               @Const int[] csrSortedRowPtr,
                               @Const int[] csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               DoublePointer csrSortedVal,
                               @Const IntPointer csrSortedRowPtr,
                               @Const IntPointer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               DoubleBuffer csrSortedVal,
                               @Const IntBuffer csrSortedRowPtr,
                               @Const IntBuffer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               double[] csrSortedVal,
                               @Const int[] csrSortedRowPtr,
                               @Const int[] csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 csrSortedVal,
                               @Const IntPointer csrSortedRowPtr,
                               @Const IntPointer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 csrSortedVal,
                               @Const IntBuffer csrSortedRowPtr,
                               @Const IntBuffer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 csrSortedVal,
                               @Const int[] csrSortedRowPtr,
                               @Const int[] csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 csrSortedVal,
                               @Const IntPointer csrSortedRowPtr,
                               @Const IntPointer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 csrSortedVal,
                               @Const IntBuffer csrSortedRowPtr,
                               @Const IntBuffer csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSizeExt(cusparseContext handle,
                               int m,
                               int nnz,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 csrSortedVal,
                               @Const int[] csrSortedRowPtr,
                               @Const int[] csrSortedColInd,
                               csric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const FloatPointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const float[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 FloatPointer csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 FloatBuffer csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 float[] csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 DoublePointer csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 DoubleBuffer csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 double[] csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           IntPointer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           IntBuffer position);
public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           int[] position);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            FloatPointer bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            FloatBuffer bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            float[] bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            DoublePointer bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            DoubleBuffer bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            double[] bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               FloatPointer bsrSortedVal,
                               @Const IntPointer bsrSortedRowPtr,
                               @Const IntPointer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               FloatBuffer bsrSortedVal,
                               @Const IntBuffer bsrSortedRowPtr,
                               @Const IntBuffer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               float[] bsrSortedVal,
                               @Const int[] bsrSortedRowPtr,
                               @Const int[] bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                DoublePointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int blockSize,
                                bsric02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                DoubleBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int blockSize,
                                bsric02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSizeExt(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                double[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int blockSize,
                                bsric02Info info,
                                @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 bsrSortedVal,
                               @Const IntPointer bsrSortedRowPtr,
                               @Const IntPointer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 bsrSortedVal,
                               @Const IntBuffer bsrSortedRowPtr,
                               @Const IntBuffer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuComplex*") float2 bsrSortedVal,
                               @Const int[] bsrSortedRowPtr,
                               @Const int[] bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const IntPointer bsrSortedRowPtr,
                               @Const IntPointer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const IntBuffer bsrSortedRowPtr,
                               @Const IntBuffer bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSizeExt(cusparseContext handle,
                               @Cast("cusparseDirection_t") int dirA,
                               int mb,
                               int nnzb,
                               cusparseMatDescr descrA,
                               @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                               @Const int[] bsrSortedRowPtr,
                               @Const int[] bsrSortedColInd,
                               int blockSize,
                               bsric02Info info,
                               @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const FloatPointer bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const float[] bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const DoublePointer bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const double[] bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 FloatPointer bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 FloatBuffer bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 float[] bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 DoublePointer bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 DoubleBuffer bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 double[] bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv(cusparseContext handle,
              int m,
              int n,
              @Const FloatPointer dl,
              @Const FloatPointer d,
              @Const FloatPointer du,
              FloatPointer B,
              int ldb);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv(cusparseContext handle,
              int m,
              int n,
              @Const FloatBuffer dl,
              @Const FloatBuffer d,
              @Const FloatBuffer du,
              FloatBuffer B,
              int ldb);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv(cusparseContext handle,
              int m,
              int n,
              @Const float[] dl,
              @Const float[] d,
              @Const float[] du,
              float[] B,
              int ldb);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv(cusparseContext handle,
              int m,
              int n,
              @Const DoublePointer dl,
              @Const DoublePointer d,
              @Const DoublePointer du,
              DoublePointer B,
              int ldb);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv(cusparseContext handle,
              int m,
              int n,
              @Const DoubleBuffer dl,
              @Const DoubleBuffer d,
              @Const DoubleBuffer du,
              DoubleBuffer B,
              int ldb);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv(cusparseContext handle,
              int m,
              int n,
              @Const double[] dl,
              @Const double[] d,
              @Const double[] du,
              double[] B,
              int ldb);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv(cusparseContext handle,
              int m,
              int n,
              @Cast("const cuComplex*") float2 dl,
              @Cast("const cuComplex*") float2 d,
              @Cast("const cuComplex*") float2 du,
              @Cast("cuComplex*") float2 B,
              int ldb);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv(cusparseContext handle,
              int m,
              int n,
              @Cast("const cuDoubleComplex*") double2 dl,
              @Cast("const cuDoubleComplex*") double2 d,
              @Cast("const cuDoubleComplex*") double2 du,
              @Cast("cuDoubleComplex*") double2 B,
              int ldb);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const FloatPointer dl,
                             @Const FloatPointer d,
                             @Const FloatPointer du,
                             @Const FloatPointer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const FloatBuffer dl,
                             @Const FloatBuffer d,
                             @Const FloatBuffer du,
                             @Const FloatBuffer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const float[] dl,
                             @Const float[] d,
                             @Const float[] du,
                             @Const float[] B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const DoublePointer dl,
                             @Const DoublePointer d,
                             @Const DoublePointer du,
                             @Const DoublePointer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const DoubleBuffer dl,
                             @Const DoubleBuffer d,
                             @Const DoubleBuffer du,
                             @Const DoubleBuffer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const double[] dl,
                             @Const double[] d,
                             @Const double[] du,
                             @Const double[] B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Cast("const cuComplex*") float2 dl,
                             @Cast("const cuComplex*") float2 d,
                             @Cast("const cuComplex*") float2 du,
                             @Cast("const cuComplex*") float2 B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Cast("const cuDoubleComplex*") double2 dl,
                             @Cast("const cuDoubleComplex*") double2 d,
                             @Cast("const cuDoubleComplex*") double2 du,
                             @Cast("const cuDoubleComplex*") double2 B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const FloatPointer dl,
               @Const FloatPointer d,
               @Const FloatPointer du,
               FloatPointer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const FloatBuffer dl,
               @Const FloatBuffer d,
               @Const FloatBuffer du,
               FloatBuffer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const float[] dl,
               @Const float[] d,
               @Const float[] du,
               float[] B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const DoublePointer dl,
               @Const DoublePointer d,
               @Const DoublePointer du,
               DoublePointer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const DoubleBuffer dl,
               @Const DoubleBuffer d,
               @Const DoubleBuffer du,
               DoubleBuffer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const double[] dl,
               @Const double[] d,
               @Const double[] du,
               double[] B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2(cusparseContext handle,
               int m,
               int n,
               @Cast("const cuComplex*") float2 dl,
               @Cast("const cuComplex*") float2 d,
               @Cast("const cuComplex*") float2 du,
               @Cast("cuComplex*") float2 B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2(cusparseContext handle,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 dl,
               @Cast("const cuDoubleComplex*") double2 d,
               @Cast("const cuDoubleComplex*") double2 du,
               @Cast("cuDoubleComplex*") double2 B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv_nopivot(cusparseContext handle,
                      int m,
                      int n,
                      @Const FloatPointer dl,
                      @Const FloatPointer d,
                      @Const FloatPointer du,
                      FloatPointer B,
                      int ldb);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv_nopivot(cusparseContext handle,
                      int m,
                      int n,
                      @Const FloatBuffer dl,
                      @Const FloatBuffer d,
                      @Const FloatBuffer du,
                      FloatBuffer B,
                      int ldb);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv_nopivot(cusparseContext handle,
                      int m,
                      int n,
                      @Const float[] dl,
                      @Const float[] d,
                      @Const float[] du,
                      float[] B,
                      int ldb);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv_nopivot(cusparseContext handle,
                                                   int m,
                                                   int n,
                                                   @Const DoublePointer dl,
                                                   @Const DoublePointer d,
                                                   @Const DoublePointer du,
                                                   DoublePointer B,
                                                   int ldb);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv_nopivot(cusparseContext handle,
                                                   int m,
                                                   int n,
                                                   @Const DoubleBuffer dl,
                                                   @Const DoubleBuffer d,
                                                   @Const DoubleBuffer du,
                                                   DoubleBuffer B,
                                                   int ldb);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv_nopivot(cusparseContext handle,
                                                   int m,
                                                   int n,
                                                   @Const double[] dl,
                                                   @Const double[] d,
                                                   @Const double[] du,
                                                   double[] B,
                                                   int ldb);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv_nopivot(cusparseContext handle,
                      int m,
                      int n,
                      @Cast("const cuComplex*") float2 dl,
                      @Cast("const cuComplex*") float2 d,
                      @Cast("const cuComplex*") float2 du,
                      @Cast("cuComplex*") float2 B,
                      int ldb);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv_nopivot(cusparseContext handle,
                      int m,
                      int n,
                      @Cast("const cuDoubleComplex*") double2 dl,
                      @Cast("const cuDoubleComplex*") double2 d,
                      @Cast("const cuDoubleComplex*") double2 du,
                      @Cast("cuDoubleComplex*") double2 B,
                      int ldb);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const FloatPointer dl,
                                     @Const FloatPointer d,
                                     @Const FloatPointer du,
                                     @Const FloatPointer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const FloatBuffer dl,
                                     @Const FloatBuffer d,
                                     @Const FloatBuffer du,
                                     @Const FloatBuffer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const float[] dl,
                                     @Const float[] d,
                                     @Const float[] du,
                                     @Const float[] B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const DoublePointer dl,
                                     @Const DoublePointer d,
                                     @Const DoublePointer du,
                                     @Const DoublePointer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const DoubleBuffer dl,
                                     @Const DoubleBuffer d,
                                     @Const DoubleBuffer du,
                                     @Const DoubleBuffer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const double[] dl,
                                     @Const double[] d,
                                     @Const double[] du,
                                     @Const double[] B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Cast("const cuComplex*") float2 dl,
                                     @Cast("const cuComplex*") float2 d,
                                     @Cast("const cuComplex*") float2 du,
                                     @Cast("const cuComplex*") float2 B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Cast("const cuDoubleComplex*") double2 dl,
                                     @Cast("const cuDoubleComplex*") double2 d,
                                     @Cast("const cuDoubleComplex*") double2 du,
                                     @Cast("const cuDoubleComplex*") double2 B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const FloatPointer dl,
                       @Const FloatPointer d,
                       @Const FloatPointer du,
                       FloatPointer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const FloatBuffer dl,
                       @Const FloatBuffer d,
                       @Const FloatBuffer du,
                       FloatBuffer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const float[] dl,
                       @Const float[] d,
                       @Const float[] du,
                       float[] B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const DoublePointer dl,
                       @Const DoublePointer d,
                       @Const DoublePointer du,
                       DoublePointer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const DoubleBuffer dl,
                       @Const DoubleBuffer d,
                       @Const DoubleBuffer du,
                       DoubleBuffer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const double[] dl,
                       @Const double[] d,
                       @Const double[] du,
                       double[] B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Cast("const cuComplex*") float2 dl,
                       @Cast("const cuComplex*") float2 d,
                       @Cast("const cuComplex*") float2 du,
                       @Cast("cuComplex*") float2 B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Cast("const cuDoubleComplex*") double2 dl,
                       @Cast("const cuDoubleComplex*") double2 d,
                       @Cast("const cuDoubleComplex*") double2 du,
                       @Cast("cuDoubleComplex*") double2 B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const FloatPointer dl,
                          @Const FloatPointer d,
                          @Const FloatPointer du,
                          FloatPointer x,
                          int batchCount,
                          int batchStride);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const FloatBuffer dl,
                          @Const FloatBuffer d,
                          @Const FloatBuffer du,
                          FloatBuffer x,
                          int batchCount,
                          int batchStride);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const float[] dl,
                          @Const float[] d,
                          @Const float[] du,
                          float[] x,
                          int batchCount,
                          int batchStride);

public static native @Cast("cusparseStatus_t") int cusparseDgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const DoublePointer dl,
                          @Const DoublePointer d,
                          @Const DoublePointer du,
                          DoublePointer x,
                          int batchCount,
                          int batchStride);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const DoubleBuffer dl,
                          @Const DoubleBuffer d,
                          @Const DoubleBuffer du,
                          DoubleBuffer x,
                          int batchCount,
                          int batchStride);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Const double[] dl,
                          @Const double[] d,
                          @Const double[] du,
                          double[] x,
                          int batchCount,
                          int batchStride);

public static native @Cast("cusparseStatus_t") int cusparseCgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Cast("const cuComplex*") float2 dl,
                          @Cast("const cuComplex*") float2 d,
                          @Cast("const cuComplex*") float2 du,
                          @Cast("cuComplex*") float2 x,
                          int batchCount,
                          int batchStride);

public static native @Cast("cusparseStatus_t") int cusparseZgtsvStridedBatch(cusparseContext handle,
                          int m,
                          @Cast("const cuDoubleComplex*") double2 dl,
                          @Cast("const cuDoubleComplex*") double2 d,
                          @Cast("const cuDoubleComplex*") double2 du,
                          @Cast("cuDoubleComplex*") double2 x,
                          int batchCount,
                          int batchStride);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const FloatPointer dl,
                                         @Const FloatPointer d,
                                         @Const FloatPointer du,
                                         @Const FloatPointer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const FloatBuffer dl,
                                         @Const FloatBuffer d,
                                         @Const FloatBuffer du,
                                         @Const FloatBuffer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const float[] dl,
                                         @Const float[] d,
                                         @Const float[] du,
                                         @Const float[] x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const DoublePointer dl,
                                         @Const DoublePointer d,
                                         @Const DoublePointer du,
                                         @Const DoublePointer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const DoubleBuffer dl,
                                         @Const DoubleBuffer d,
                                         @Const DoubleBuffer du,
                                         @Const DoubleBuffer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const double[] dl,
                                         @Const double[] d,
                                         @Const double[] du,
                                         @Const double[] x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Cast("const cuComplex*") float2 dl,
                                         @Cast("const cuComplex*") float2 d,
                                         @Cast("const cuComplex*") float2 du,
                                         @Cast("const cuComplex*") float2 x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                          int m,
                                          @Cast("const cuDoubleComplex*") double2 dl,
                                          @Cast("const cuDoubleComplex*") double2 d,
                                          @Cast("const cuDoubleComplex*") double2 du,
                                          @Cast("const cuDoubleComplex*") double2 x,
                                          int batchCount,
                                          int batchStride,
                                          @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const FloatPointer dl,
                           @Const FloatPointer d,
                           @Const FloatPointer du,
                           FloatPointer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const FloatBuffer dl,
                           @Const FloatBuffer d,
                           @Const FloatBuffer du,
                           FloatBuffer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const float[] dl,
                           @Const float[] d,
                           @Const float[] du,
                           float[] x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const DoublePointer dl,
                           @Const DoublePointer d,
                           @Const DoublePointer du,
                           DoublePointer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const DoubleBuffer dl,
                           @Const DoubleBuffer d,
                           @Const DoubleBuffer du,
                           DoubleBuffer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const double[] dl,
                           @Const double[] d,
                           @Const double[] du,
                           double[] x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Cast("const cuComplex*") float2 dl,
                           @Cast("const cuComplex*") float2 d,
                           @Cast("const cuComplex*") float2 du,
                           @Cast("cuComplex*") float2 x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Cast("const cuDoubleComplex*") double2 dl,
                           @Cast("const cuDoubleComplex*") double2 d,
                           @Cast("const cuDoubleComplex*") double2 du,
                           @Cast("cuDoubleComplex*") double2 x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatPointer dl,
                                            @Const FloatPointer d,
                                            @Const FloatPointer du,
                                            @Const FloatPointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatBuffer dl,
                                            @Const FloatBuffer d,
                                            @Const FloatBuffer du,
                                            @Const FloatBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const float[] dl,
                                            @Const float[] d,
                                            @Const float[] du,
                                            @Const float[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const DoublePointer dl,
                                         @Const DoublePointer d,
                                         @Const DoublePointer du,
                                         @Const DoublePointer x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const DoubleBuffer dl,
                                         @Const DoubleBuffer d,
                                         @Const DoubleBuffer du,
                                         @Const DoubleBuffer x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const double[] dl,
                                         @Const double[] d,
                                         @Const double[] du,
                                         @Const double[] x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuComplex*") float2 dl,
                                            @Cast("const cuComplex*") float2 d,
                                            @Cast("const cuComplex*") float2 du,
                                            @Cast("const cuComplex*") float2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                             int algo,
                                             int m,
                                             @Cast("const cuDoubleComplex*") double2 dl,
                                             @Cast("const cuDoubleComplex*") double2 d,
                                             @Cast("const cuDoubleComplex*") double2 du,
                                             @Cast("const cuDoubleComplex*") double2 x,
                                             int batchCount,
                                             @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatPointer dl,
                              FloatPointer d,
                              FloatPointer du,
                              FloatPointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatBuffer dl,
                              FloatBuffer d,
                              FloatBuffer du,
                              FloatBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              float[] dl,
                              float[] d,
                              float[] du,
                              float[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoublePointer dl,
                              DoublePointer d,
                              DoublePointer du,
                              DoublePointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoubleBuffer dl,
                              DoubleBuffer d,
                              DoubleBuffer du,
                              DoubleBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              double[] dl,
                              double[] d,
                              double[] du,
                              double[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuComplex*") float2 dl,
                              @Cast("cuComplex*") float2 d,
                              @Cast("cuComplex*") float2 du,
                              @Cast("cuComplex*") float2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuDoubleComplex*") double2 dl,
                              @Cast("cuDoubleComplex*") double2 d,
                              @Cast("cuDoubleComplex*") double2 du,
                              @Cast("cuDoubleComplex*") double2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatPointer ds,
                                            @Const FloatPointer dl,
                                            @Const FloatPointer d,
                                            @Const FloatPointer du,
                                            @Const FloatPointer dw,
                                            @Const FloatPointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatBuffer ds,
                                            @Const FloatBuffer dl,
                                            @Const FloatBuffer d,
                                            @Const FloatBuffer du,
                                            @Const FloatBuffer dw,
                                            @Const FloatBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const float[] ds,
                                            @Const float[] dl,
                                            @Const float[] d,
                                            @Const float[] du,
                                            @Const float[] dw,
                                            @Const float[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const DoublePointer ds,
                                            @Const DoublePointer dl,
                                            @Const DoublePointer d,
                                            @Const DoublePointer du,
                                            @Const DoublePointer dw,
                                            @Const DoublePointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const DoubleBuffer ds,
                                            @Const DoubleBuffer dl,
                                            @Const DoubleBuffer d,
                                            @Const DoubleBuffer du,
                                            @Const DoubleBuffer dw,
                                            @Const DoubleBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const double[] ds,
                                            @Const double[] dl,
                                            @Const double[] d,
                                            @Const double[] du,
                                            @Const double[] dw,
                                            @Const double[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuComplex*") float2 ds,
                                            @Cast("const cuComplex*") float2 dl,
                                            @Cast("const cuComplex*") float2 d,
                                            @Cast("const cuComplex*") float2 du,
                                            @Cast("const cuComplex*") float2 dw,
                                            @Cast("const cuComplex*") float2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuDoubleComplex*") double2 ds,
                                            @Cast("const cuDoubleComplex*") double2 dl,
                                            @Cast("const cuDoubleComplex*") double2 d,
                                            @Cast("const cuDoubleComplex*") double2 du,
                                            @Cast("const cuDoubleComplex*") double2 dw,
                                            @Cast("const cuDoubleComplex*") double2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatPointer ds,
                              FloatPointer dl,
                              FloatPointer d,
                              FloatPointer du,
                              FloatPointer dw,
                              FloatPointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatBuffer ds,
                              FloatBuffer dl,
                              FloatBuffer d,
                              FloatBuffer du,
                              FloatBuffer dw,
                              FloatBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              float[] ds,
                              float[] dl,
                              float[] d,
                              float[] du,
                              float[] dw,
                              float[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoublePointer ds,
                              DoublePointer dl,
                              DoublePointer d,
                              DoublePointer du,
                              DoublePointer dw,
                              DoublePointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoubleBuffer ds,
                              DoubleBuffer dl,
                              DoubleBuffer d,
                              DoubleBuffer du,
                              DoubleBuffer dw,
                              DoubleBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              double[] ds,
                              double[] dl,
                              double[] d,
                              double[] du,
                              double[] dw,
                              double[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuComplex*") float2 ds,
                              @Cast("cuComplex*") float2 dl,
                              @Cast("cuComplex*") float2 d,
                              @Cast("cuComplex*") float2 du,
                              @Cast("cuComplex*") float2 dw,
                              @Cast("cuComplex*") float2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuDoubleComplex*") double2 ds,
                              @Cast("cuDoubleComplex*") double2 dl,
                              @Cast("cuDoubleComplex*") double2 d,
                              @Cast("cuDoubleComplex*") double2 du,
                              @Cast("cuDoubleComplex*") double2 dw,
                              @Cast("cuDoubleComplex*") double2 x,
                              int batchCount,
                              Pointer pBuffer);

//##############################################################################
//# SPARSE LEVEL 4 ROUTINES #
//##############################################################################

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgemmNnz(cusparseContext handle,
                    @Cast("cusparseOperation_t") int transA,
                    @Cast("cusparseOperation_t") int transB,
                    int m,
                    int n,
                    int k,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const IntPointer csrSortedRowPtrA,
                    @Const IntPointer csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const IntPointer csrSortedRowPtrB,
                    @Const IntPointer csrSortedColIndB,
                    cusparseMatDescr descrC,
                    IntPointer csrSortedRowPtrC,
                    IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgemmNnz(cusparseContext handle,
                    @Cast("cusparseOperation_t") int transA,
                    @Cast("cusparseOperation_t") int transB,
                    int m,
                    int n,
                    int k,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const IntBuffer csrSortedRowPtrA,
                    @Const IntBuffer csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const IntBuffer csrSortedRowPtrB,
                    @Const IntBuffer csrSortedColIndB,
                    cusparseMatDescr descrC,
                    IntBuffer csrSortedRowPtrC,
                    IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgemmNnz(cusparseContext handle,
                    @Cast("cusparseOperation_t") int transA,
                    @Cast("cusparseOperation_t") int transB,
                    int m,
                    int n,
                    int k,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const int[] csrSortedRowPtrA,
                    @Const int[] csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const int[] csrSortedRowPtrB,
                    @Const int[] csrSortedColIndB,
                    cusparseMatDescr descrC,
                    int[] csrSortedRowPtrC,
                    int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const FloatPointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const FloatPointer csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 FloatPointer csrSortedValC,
                 @Const IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const FloatBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const FloatBuffer csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 FloatBuffer csrSortedValC,
                 @Const IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const float[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const float[] csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 float[] csrSortedValC,
                 @Const int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const DoublePointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const DoublePointer csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 DoublePointer csrSortedValC,
                 @Const IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const DoubleBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const DoubleBuffer csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 DoubleBuffer csrSortedValC,
                 @Const IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const double[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const double[] csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 double[] csrSortedValC,
                 @Const int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 @Const IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 @Const IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgemm(cusparseContext handle,
                 @Cast("cusparseOperation_t") int transA,
                 @Cast("cusparseOperation_t") int transB,
                 int m,
                 int n,
                 int k,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 @Const int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsrgemm2Info(@ByPtrPtr csrgemm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsrgemm2Info(csrgemm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const FloatPointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                @Const FloatPointer beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntPointer csrSortedRowPtrD,
                                @Const IntPointer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const FloatBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                @Const FloatBuffer beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntBuffer csrSortedRowPtrD,
                                @Const IntBuffer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const float[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                @Const float[] beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const int[] csrSortedRowPtrD,
                                @Const int[] csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const DoublePointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                @Const DoublePointer beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntPointer csrSortedRowPtrD,
                                @Const IntPointer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const DoubleBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                @Const DoubleBuffer beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntBuffer csrSortedRowPtrD,
                                @Const IntBuffer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Const double[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                @Const double[] beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const int[] csrSortedRowPtrD,
                                @Const int[] csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntPointer csrSortedRowPtrD,
                                @Const IntPointer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntBuffer csrSortedRowPtrD,
                                @Const IntBuffer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const int[] csrSortedRowPtrD,
                                @Const int[] csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntPointer csrSortedRowPtrD,
                                @Const IntPointer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const IntBuffer csrSortedRowPtrD,
                                @Const IntBuffer csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int k,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrD,
                                int nnzD,
                                @Const int[] csrSortedRowPtrD,
                                @Const int[] csrSortedColIndD,
                                csrgemm2Info info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcsrgemm2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     int k,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntPointer csrSortedRowPtrB,
                     @Const IntPointer csrSortedColIndB,
                     cusparseMatDescr descrD,
                     int nnzD,
                     @Const IntPointer csrSortedRowPtrD,
                     @Const IntPointer csrSortedColIndD,
                     cusparseMatDescr descrC,
                     IntPointer csrSortedRowPtrC,
                     IntPointer nnzTotalDevHostPtr,
                     csrgemm2Info info,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgemm2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     int k,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntBuffer csrSortedRowPtrB,
                     @Const IntBuffer csrSortedColIndB,
                     cusparseMatDescr descrD,
                     int nnzD,
                     @Const IntBuffer csrSortedRowPtrD,
                     @Const IntBuffer csrSortedColIndD,
                     cusparseMatDescr descrC,
                     IntBuffer csrSortedRowPtrC,
                     IntBuffer nnzTotalDevHostPtr,
                     csrgemm2Info info,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgemm2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     int k,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const int[] csrSortedRowPtrB,
                     @Const int[] csrSortedColIndB,
                     cusparseMatDescr descrD,
                     int nnzD,
                     @Const int[] csrSortedRowPtrD,
                     @Const int[] csrSortedColIndD,
                     cusparseMatDescr descrC,
                     int[] csrSortedRowPtrC,
                     int[] nnzTotalDevHostPtr,
                     csrgemm2Info info,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const FloatPointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatPointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatPointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  @Const FloatPointer beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const FloatPointer csrSortedValD,
                  @Const IntPointer csrSortedRowPtrD,
                  @Const IntPointer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  FloatPointer csrSortedValC,
                  @Const IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const FloatBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  @Const FloatBuffer beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const FloatBuffer csrSortedValD,
                  @Const IntBuffer csrSortedRowPtrD,
                  @Const IntBuffer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  FloatBuffer csrSortedValC,
                  @Const IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const float[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const float[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const float[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  @Const float[] beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const float[] csrSortedValD,
                  @Const int[] csrSortedRowPtrD,
                  @Const int[] csrSortedColIndD,
                  cusparseMatDescr descrC,
                  float[] csrSortedValC,
                  @Const int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const DoublePointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoublePointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoublePointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  @Const DoublePointer beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const DoublePointer csrSortedValD,
                  @Const IntPointer csrSortedRowPtrD,
                  @Const IntPointer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  DoublePointer csrSortedValC,
                  @Const IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const DoubleBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoubleBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoubleBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  @Const DoubleBuffer beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const DoubleBuffer csrSortedValD,
                  @Const IntBuffer csrSortedRowPtrD,
                  @Const IntBuffer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  DoubleBuffer csrSortedValC,
                  @Const IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Const double[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const double[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const double[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  @Const double[] beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Const double[] csrSortedValD,
                  @Const int[] csrSortedRowPtrD,
                  @Const int[] csrSortedColIndD,
                  cusparseMatDescr descrC,
                  double[] csrSortedValC,
                  @Const int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2(cusparseContext handle,
                 int m,
                 int n,
                 int k,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrD,
                 int nnzD,
                 @Cast("const cuComplex*") float2 csrSortedValD,
                 @Const IntPointer csrSortedRowPtrD,
                 @Const IntPointer csrSortedColIndD,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC,
                 csrgemm2Info info,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2(cusparseContext handle,
                 int m,
                 int n,
                 int k,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrD,
                 int nnzD,
                 @Cast("const cuComplex*") float2 csrSortedValD,
                 @Const IntBuffer csrSortedRowPtrD,
                 @Const IntBuffer csrSortedColIndD,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC,
                 csrgemm2Info info,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgemm2(cusparseContext handle,
                 int m,
                 int n,
                 int k,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrD,
                 int nnzD,
                 @Cast("const cuComplex*") float2 csrSortedValD,
                 @Const int[] csrSortedRowPtrD,
                 @Const int[] csrSortedColIndD,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 @Const int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC,
                 csrgemm2Info info,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValD,
                  @Const IntPointer csrSortedRowPtrD,
                  @Const IntPointer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  @Const IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValD,
                  @Const IntBuffer csrSortedRowPtrD,
                  @Const IntBuffer csrSortedColIndD,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  @Const IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgemm2(cusparseContext handle,
                  int m,
                  int n,
                  int k,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrD,
                  int nnzD,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValD,
                  @Const int[] csrSortedRowPtrD,
                  @Const int[] csrSortedColIndD,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  @Const int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  csrgemm2Info info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgeamNnz(cusparseContext handle,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const IntPointer csrSortedRowPtrA,
                    @Const IntPointer csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const IntPointer csrSortedRowPtrB,
                    @Const IntPointer csrSortedColIndB,
                    cusparseMatDescr descrC,
                    IntPointer csrSortedRowPtrC,
                    IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgeamNnz(cusparseContext handle,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const IntBuffer csrSortedRowPtrA,
                    @Const IntBuffer csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const IntBuffer csrSortedRowPtrB,
                    @Const IntBuffer csrSortedColIndB,
                    cusparseMatDescr descrC,
                    IntBuffer csrSortedRowPtrC,
                    IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseXcsrgeamNnz(cusparseContext handle,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    int nnzA,
                    @Const int[] csrSortedRowPtrA,
                    @Const int[] csrSortedColIndA,
                    cusparseMatDescr descrB,
                    int nnzB,
                    @Const int[] csrSortedRowPtrB,
                    @Const int[] csrSortedColIndB,
                    cusparseMatDescr descrC,
                    int[] csrSortedRowPtrC,
                    int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const FloatPointer alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const FloatPointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 @Const FloatPointer beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const FloatPointer csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 FloatPointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const FloatBuffer alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const FloatBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 @Const FloatBuffer beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const FloatBuffer csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 FloatBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const float[] alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const float[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 @Const float[] beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const float[] csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 float[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const DoublePointer alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const DoublePointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 @Const DoublePointer beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const DoublePointer csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 DoublePointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const DoubleBuffer alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const DoubleBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 @Const DoubleBuffer beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const DoubleBuffer csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 DoubleBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Const double[] alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Const double[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 @Const double[] beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Const double[] csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 double[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuComplex*") float2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 @Cast("const cuComplex*") float2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuComplex*") float2 csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuDoubleComplex*") double2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 @Cast("const cuDoubleComplex*") double2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const IntPointer csrSortedRowPtrB,
                 @Const IntPointer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuDoubleComplex*") double2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 @Cast("const cuDoubleComplex*") double2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const IntBuffer csrSortedRowPtrB,
                 @Const IntBuffer csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsrgeam(cusparseContext handle,
                 int m,
                 int n,
                 @Cast("const cuDoubleComplex*") double2 alpha,
                 cusparseMatDescr descrA,
                 int nnzA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 @Cast("const cuDoubleComplex*") double2 beta,
                 cusparseMatDescr descrB,
                 int nnzB,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                 @Const int[] csrSortedRowPtrB,
                 @Const int[] csrSortedColIndB,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const FloatPointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const FloatPointer csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Const FloatPointer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const FloatPointer csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const FloatPointer csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const FloatBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const FloatBuffer csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Const FloatBuffer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const FloatBuffer csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const FloatBuffer csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const float[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const float[] csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Const float[] beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const float[] csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const float[] csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const DoublePointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const DoublePointer csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Const DoublePointer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const DoublePointer csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const DoublePointer csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const DoubleBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const DoubleBuffer csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Const DoubleBuffer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const DoubleBuffer csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const DoubleBuffer csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const double[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const double[] csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Const double[] beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const double[] csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const double[] csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntPointer csrSortedRowPtrB,
                     @Const IntPointer csrSortedColIndB,
                     cusparseMatDescr descrC,
                     IntPointer csrSortedRowPtrC,
                     IntPointer nnzTotalDevHostPtr,
                     Pointer workspace);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntBuffer csrSortedRowPtrB,
                     @Const IntBuffer csrSortedColIndB,
                     cusparseMatDescr descrC,
                     IntBuffer csrSortedRowPtrC,
                     IntBuffer nnzTotalDevHostPtr,
                     Pointer workspace);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const int[] csrSortedRowPtrB,
                     @Const int[] csrSortedColIndB,
                     cusparseMatDescr descrC,
                     int[] csrSortedRowPtrC,
                     int[] nnzTotalDevHostPtr,
                     Pointer workspace);

public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const FloatPointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatPointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const FloatPointer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatPointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  FloatPointer csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const FloatBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const FloatBuffer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  FloatBuffer csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const float[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const float[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const float[] beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const float[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  float[] csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const DoublePointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoublePointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const DoublePointer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoublePointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  DoublePointer csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const DoubleBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoubleBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const DoubleBuffer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoubleBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  DoubleBuffer csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const double[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const double[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const double[] beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const double[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  double[] csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

/* --- Sparse Matrix Reorderings --- */

/* Description: Find an approximate coloring of a matrix stored in CSR format.
 */
public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const FloatPointer csrSortedValA,
                                               @Const IntPointer csrSortedRowPtrA,
                                               @Const IntPointer csrSortedColIndA,
                                               @Const FloatPointer fractionToColor,
                                               IntPointer ncolors,
                                               IntPointer coloring,
                                               IntPointer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const FloatBuffer csrSortedValA,
                                               @Const IntBuffer csrSortedRowPtrA,
                                               @Const IntBuffer csrSortedColIndA,
                                               @Const FloatBuffer fractionToColor,
                                               IntBuffer ncolors,
                                               IntBuffer coloring,
                                               IntBuffer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const float[] csrSortedValA,
                                               @Const int[] csrSortedRowPtrA,
                                               @Const int[] csrSortedColIndA,
                                               @Const float[] fractionToColor,
                                               int[] ncolors,
                                               int[] coloring,
                                               int[] reordering,
                                               cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const DoublePointer csrSortedValA,
                                               @Const IntPointer csrSortedRowPtrA,
                                               @Const IntPointer csrSortedColIndA,
                                               @Const DoublePointer fractionToColor,
                                               IntPointer ncolors,
                                               IntPointer coloring,
                                               IntPointer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const DoubleBuffer csrSortedValA,
                                               @Const IntBuffer csrSortedRowPtrA,
                                               @Const IntBuffer csrSortedColIndA,
                                               @Const DoubleBuffer fractionToColor,
                                               IntBuffer ncolors,
                                               IntBuffer coloring,
                                               IntBuffer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Const double[] csrSortedValA,
                                               @Const int[] csrSortedRowPtrA,
                                               @Const int[] csrSortedColIndA,
                                               @Const double[] fractionToColor,
                                               int[] ncolors,
                                               int[] coloring,
                                               int[] reordering,
                                               cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Cast("const cuComplex*") float2 csrSortedValA,
                                               @Const IntPointer csrSortedRowPtrA,
                                               @Const IntPointer csrSortedColIndA,
                                               @Const FloatPointer fractionToColor,
                                               IntPointer ncolors,
                                               IntPointer coloring,
                                               IntPointer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Cast("const cuComplex*") float2 csrSortedValA,
                                               @Const IntBuffer csrSortedRowPtrA,
                                               @Const IntBuffer csrSortedColIndA,
                                               @Const FloatBuffer fractionToColor,
                                               IntBuffer ncolors,
                                               IntBuffer coloring,
                                               IntBuffer reordering,
                                               cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                                               int m,
                                               int nnz,
                                               cusparseMatDescr descrA,
                                               @Cast("const cuComplex*") float2 csrSortedValA,
                                               @Const int[] csrSortedRowPtrA,
                                               @Const int[] csrSortedColIndA,
                                               @Const float[] fractionToColor,
                                               int[] ncolors,
                                               int[] coloring,
                                               int[] reordering,
                                               cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                                   int m,
                                   int nnz,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   @Const DoublePointer fractionToColor,
                                   IntPointer ncolors,
                                   IntPointer coloring,
                                   IntPointer reordering,
                                   cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                                   int m,
                                   int nnz,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   @Const DoubleBuffer fractionToColor,
                                   IntBuffer ncolors,
                                   IntBuffer coloring,
                                   IntBuffer reordering,
                                   cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                                   int m,
                                   int nnz,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   @Const double[] fractionToColor,
                                   int[] ncolors,
                                   int[] coloring,
                                   int[] reordering,
                                   cusparseColorInfo info);

//##############################################################################
//# SPARSE FORMAT CONVERSION
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const FloatPointer A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const FloatBuffer A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const float[] A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const DoublePointer A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const DoubleBuffer A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const double[] A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

//##############################################################################
//# SPARSE FORMAT CONVERSION #
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      float tol);
public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      float tol);
public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      float tol);

public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      double tol);
public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      double tol);
public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      double tol);

public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);

public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);

public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const FloatPointer csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          FloatPointer csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          float tol);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          FloatBuffer csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          float tol);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const float[] csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          float[] csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          float tol);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          DoublePointer csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          double tol);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          DoubleBuffer csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          double tol);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          double[] csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          double tol);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);

public static native @Cast("cusparseStatus_t") int cusparseSdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   FloatPointer csrSortedValA,
                   IntPointer csrSortedRowPtrA,
                   IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseSdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   FloatBuffer csrSortedValA,
                   IntBuffer csrSortedRowPtrA,
                   IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseSdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] A,
                   int lda,
                   @Const int[] nnzPerRow,
                   float[] csrSortedValA,
                   int[] csrSortedRowPtrA,
                   int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseDdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   DoublePointer csrSortedValA,
                   IntPointer csrSortedRowPtrA,
                   IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseDdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   DoubleBuffer csrSortedValA,
                   IntBuffer csrSortedRowPtrA,
                   IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseDdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] A,
                   int lda,
                   @Const int[] nnzPerRow,
                   double[] csrSortedValA,
                   int[] csrSortedRowPtrA,
                   int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseCdense2csr(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 A,
                     int lda,
                     @Const IntPointer nnzPerRow,
                     @Cast("cuComplex*") float2 csrSortedValA,
                     IntPointer csrSortedRowPtrA,
                     IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseCdense2csr(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 A,
                     int lda,
                     @Const IntBuffer nnzPerRow,
                     @Cast("cuComplex*") float2 csrSortedValA,
                     IntBuffer csrSortedRowPtrA,
                     IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseCdense2csr(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 A,
                     int lda,
                     @Const int[] nnzPerRow,
                     @Cast("cuComplex*") float2 csrSortedValA,
                     int[] csrSortedRowPtrA,
                     int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseZdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   @Cast("cuDoubleComplex*") double2 csrSortedValA,
                   IntPointer csrSortedRowPtrA,
                   IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseZdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   @Cast("cuDoubleComplex*") double2 csrSortedValA,
                   IntBuffer csrSortedRowPtrA,
                   IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseZdense2csr(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const int[] nnzPerRow,
                   @Cast("cuDoubleComplex*") double2 csrSortedValA,
                   int[] csrSortedRowPtrA,
                   int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseScsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   FloatPointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseScsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   FloatBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseScsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   float[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   DoublePointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   DoubleBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   double[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   @Cast("cuComplex*") float2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   @Cast("cuComplex*") float2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   @Cast("cuComplex*") float2 A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2dense(cusparseContext handle,
                int m,
                int n,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const IntPointer csrSortedRowPtrA,
                @Const IntPointer csrSortedColIndA,
                @Cast("cuDoubleComplex*") double2 A,
                int lda);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2dense(cusparseContext handle,
                int m,
                int n,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const IntBuffer csrSortedRowPtrA,
                @Const IntBuffer csrSortedColIndA,
                @Cast("cuDoubleComplex*") double2 A,
                int lda);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2dense(cusparseContext handle,
                int m,
                int n,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                @Const int[] csrSortedRowPtrA,
                @Const int[] csrSortedColIndA,
                @Cast("cuDoubleComplex*") double2 A,
                int lda);

public static native @Cast("cusparseStatus_t") int cusparseSdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer A,
                   int lda,
                   @Const IntPointer nnzPerCol,
                   FloatPointer cscSortedValA,
                   IntPointer cscSortedRowIndA,
                   IntPointer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseSdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerCol,
                   FloatBuffer cscSortedValA,
                   IntBuffer cscSortedRowIndA,
                   IntBuffer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseSdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] A,
                   int lda,
                   @Const int[] nnzPerCol,
                   float[] cscSortedValA,
                   int[] cscSortedRowIndA,
                   int[] cscSortedColPtrA);

public static native @Cast("cusparseStatus_t") int cusparseDdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer A,
                   int lda,
                   @Const IntPointer nnzPerCol,
                   DoublePointer cscSortedValA,
                   IntPointer cscSortedRowIndA,
                   IntPointer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseDdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerCol,
                   DoubleBuffer cscSortedValA,
                   IntBuffer cscSortedRowIndA,
                   IntBuffer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseDdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] A,
                   int lda,
                   @Const int[] nnzPerCol,
                   double[] cscSortedValA,
                   int[] cscSortedRowIndA,
                   int[] cscSortedColPtrA);

public static native @Cast("cusparseStatus_t") int cusparseCdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const IntPointer nnzPerCol,
                   @Cast("cuComplex*") float2 cscSortedValA,
                   IntPointer cscSortedRowIndA,
                   IntPointer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseCdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const IntBuffer nnzPerCol,
                   @Cast("cuComplex*") float2 cscSortedValA,
                   IntBuffer cscSortedRowIndA,
                   IntBuffer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseCdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const int[] nnzPerCol,
                   @Cast("cuComplex*") float2 cscSortedValA,
                   int[] cscSortedRowIndA,
                   int[] cscSortedColPtrA);

public static native @Cast("cusparseStatus_t") int cusparseZdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntPointer nnzPerCol,
                   @Cast("cuDoubleComplex*") double2 cscSortedValA,
                   IntPointer cscSortedRowIndA,
                   IntPointer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseZdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntBuffer nnzPerCol,
                   @Cast("cuDoubleComplex*") double2 cscSortedValA,
                   IntBuffer cscSortedRowIndA,
                   IntBuffer cscSortedColPtrA);
public static native @Cast("cusparseStatus_t") int cusparseZdense2csc(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const int[] nnzPerCol,
                   @Cast("cuDoubleComplex*") double2 cscSortedValA,
                   int[] cscSortedRowIndA,
                   int[] cscSortedColPtrA);

public static native @Cast("cusparseStatus_t") int cusparseScsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer cscSortedValA,
                   @Const IntPointer cscSortedRowIndA,
                   @Const IntPointer cscSortedColPtrA,
                   FloatPointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseScsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer cscSortedValA,
                   @Const IntBuffer cscSortedRowIndA,
                   @Const IntBuffer cscSortedColPtrA,
                   FloatBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseScsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] cscSortedValA,
                   @Const int[] cscSortedRowIndA,
                   @Const int[] cscSortedColPtrA,
                   float[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseDcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer cscSortedValA,
                   @Const IntPointer cscSortedRowIndA,
                   @Const IntPointer cscSortedColPtrA,
                   DoublePointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer cscSortedValA,
                   @Const IntBuffer cscSortedRowIndA,
                   @Const IntBuffer cscSortedColPtrA,
                   DoubleBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] cscSortedValA,
                   @Const int[] cscSortedRowIndA,
                   @Const int[] cscSortedColPtrA,
                   double[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseCcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 cscSortedValA,
                   @Const IntPointer cscSortedRowIndA,
                   @Const IntPointer cscSortedColPtrA,
                   @Cast("cuComplex*") float2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseCcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 cscSortedValA,
                   @Const IntBuffer cscSortedRowIndA,
                   @Const IntBuffer cscSortedColPtrA,
                   @Cast("cuComplex*") float2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseCcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 cscSortedValA,
                   @Const int[] cscSortedRowIndA,
                   @Const int[] cscSortedColPtrA,
                   @Cast("cuComplex*") float2 A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseZcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                   @Const IntPointer cscSortedRowIndA,
                   @Const IntPointer cscSortedColPtrA,
                   @Cast("cuDoubleComplex*") double2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseZcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                   @Const IntBuffer cscSortedRowIndA,
                   @Const IntBuffer cscSortedColPtrA,
                   @Cast("cuDoubleComplex*") double2 A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseZcsc2dense(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                   @Const int[] cscSortedRowIndA,
                   @Const int[] cscSortedColPtrA,
                   @Cast("cuDoubleComplex*") double2 A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const IntPointer cooRowInd,
                 int nnz,
                 int m,
                 IntPointer csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const IntBuffer cooRowInd,
                 int nnz,
                 int m,
                 IntBuffer csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const int[] cooRowInd,
                 int nnz,
                 int m,
                 int[] csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const IntPointer csrSortedRowPtr,
                 int nnz,
                 int m,
                 IntPointer cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const IntBuffer csrSortedRowPtr,
                 int nnz,
                 int m,
                 IntBuffer cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const int[] csrSortedRowPtr,
                 int nnz,
                 int m,
                 int[] cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsr2cscEx(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  @Const Pointer csrSortedVal,
                  @Cast("cudaDataType") int csrSortedValtype,
                  @Const IntPointer csrSortedRowPtr,
                  @Const IntPointer csrSortedColInd,
                  Pointer cscSortedVal,
                  @Cast("cudaDataType") int cscSortedValtype,
                  IntPointer cscSortedRowInd,
                  IntPointer cscSortedColPtr,
                  @Cast("cusparseAction_t") int copyValues,
                  @Cast("cusparseIndexBase_t") int idxBase,
                  @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsr2cscEx(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  @Const Pointer csrSortedVal,
                  @Cast("cudaDataType") int csrSortedValtype,
                  @Const IntBuffer csrSortedRowPtr,
                  @Const IntBuffer csrSortedColInd,
                  Pointer cscSortedVal,
                  @Cast("cudaDataType") int cscSortedValtype,
                  IntBuffer cscSortedRowInd,
                  IntBuffer cscSortedColPtr,
                  @Cast("cusparseAction_t") int copyValues,
                  @Cast("cusparseIndexBase_t") int idxBase,
                  @Cast("cudaDataType") int executiontype);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCsr2cscEx(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  @Const Pointer csrSortedVal,
                  @Cast("cudaDataType") int csrSortedValtype,
                  @Const int[] csrSortedRowPtr,
                  @Const int[] csrSortedColInd,
                  Pointer cscSortedVal,
                  @Cast("cudaDataType") int cscSortedValtype,
                  int[] cscSortedRowInd,
                  int[] cscSortedColPtr,
                  @Cast("cusparseAction_t") int copyValues,
                  @Cast("cusparseIndexBase_t") int idxBase,
                  @Cast("cudaDataType") int executiontype);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const FloatPointer csrSortedVal,
                 @Const IntPointer csrSortedRowPtr,
                 @Const IntPointer csrSortedColInd,
                 FloatPointer cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const FloatBuffer csrSortedVal,
                 @Const IntBuffer csrSortedRowPtr,
                 @Const IntBuffer csrSortedColInd,
                 FloatBuffer cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseScsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const float[] csrSortedVal,
                 @Const int[] csrSortedRowPtr,
                 @Const int[] csrSortedColInd,
                 float[] cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const DoublePointer csrSortedVal,
                 @Const IntPointer csrSortedRowPtr,
                 @Const IntPointer csrSortedColInd,
                 DoublePointer cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const DoubleBuffer csrSortedVal,
                 @Const IntBuffer csrSortedRowPtr,
                 @Const IntBuffer csrSortedColInd,
                 DoubleBuffer cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseDcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Const double[] csrSortedVal,
                 @Const int[] csrSortedRowPtr,
                 @Const int[] csrSortedColInd,
                 double[] cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuComplex*") float2 csrSortedVal,
                 @Const IntPointer csrSortedRowPtr,
                 @Const IntPointer csrSortedColInd,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuComplex*") float2 csrSortedVal,
                 @Const IntBuffer csrSortedRowPtr,
                 @Const IntBuffer csrSortedColInd,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseCcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuComplex*") float2 csrSortedVal,
                 @Const int[] csrSortedRowPtr,
                 @Const int[] csrSortedColInd,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuDoubleComplex*") double2 csrSortedVal,
                 @Const IntPointer csrSortedRowPtr,
                 @Const IntPointer csrSortedColInd,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuDoubleComplex*") double2 csrSortedVal,
                 @Const IntBuffer csrSortedRowPtr,
                 @Const IntBuffer csrSortedColInd,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") @Deprecated int cusparseZcsr2csc(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 @Cast("const cuDoubleComplex*") double2 csrSortedVal,
                 @Const int[] csrSortedRowPtr,
                 @Const int[] csrSortedColInd,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr,
                 @Cast("cusparseAction_t") int copyValues,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseSdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseSdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseSdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] A,
                   int lda,
                   @Const int[] nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseDdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] A,
                   int lda,
                   @Const int[] nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseCdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 A,
                   int lda,
                   @Const int[] nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseZdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntPointer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const IntBuffer nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZdense2hyb(cusparseContext handle,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 A,
                   int lda,
                   @Const int[] nnzPerRow,
                   cusparseHybMat hybA,
                   int userEllWidth,
                   @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseShyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   FloatPointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseShyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   FloatBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseShyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   float[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseDhyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   DoublePointer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   DoubleBuffer A,
                   int lda);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   double[] A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseChyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   @Cast("cuComplex*") float2 A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseZhyb2dense(cusparseContext handle,
                   cusparseMatDescr descrA,
                   cusparseHybMat hybA,
                   @Cast("cuDoubleComplex*") double2 A,
                   int lda);

public static native @Cast("cusparseStatus_t") int cusparseScsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatPointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseScsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseScsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const float[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoublePointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const double[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseShyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 FloatPointer csrSortedValA,
                 IntPointer csrSortedRowPtrA,
                 IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseShyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 FloatBuffer csrSortedValA,
                 IntBuffer csrSortedRowPtrA,
                 IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseShyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 float[] csrSortedValA,
                 int[] csrSortedRowPtrA,
                 int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseDhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 DoublePointer csrSortedValA,
                 IntPointer csrSortedRowPtrA,
                 IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 DoubleBuffer csrSortedValA,
                 IntBuffer csrSortedRowPtrA,
                 IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 double[] csrSortedValA,
                 int[] csrSortedRowPtrA,
                 int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseChyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 csrSortedValA,
                 IntPointer csrSortedRowPtrA,
                 IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseChyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 csrSortedValA,
                 IntBuffer csrSortedRowPtrA,
                 IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseChyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 csrSortedValA,
                 int[] csrSortedRowPtrA,
                 int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseZhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA,
                 IntPointer csrSortedRowPtrA,
                 IntPointer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseZhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA,
                 IntBuffer csrSortedRowPtrA,
                 IntBuffer csrSortedColIndA);
public static native @Cast("cusparseStatus_t") int cusparseZhyb2csr(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA,
                 int[] csrSortedRowPtrA,
                 int[] csrSortedColIndA);

public static native @Cast("cusparseStatus_t") int cusparseScsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatPointer cscSortedValA,
                 @Const IntPointer cscSortedRowIndA,
                 @Const IntPointer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseScsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer cscSortedValA,
                 @Const IntBuffer cscSortedRowIndA,
                 @Const IntBuffer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseScsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const float[] cscSortedValA,
                 @Const int[] cscSortedRowIndA,
                 @Const int[] cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseDcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoublePointer cscSortedValA,
                 @Const IntPointer cscSortedRowIndA,
                 @Const IntPointer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer cscSortedValA,
                 @Const IntBuffer cscSortedRowIndA,
                 @Const IntBuffer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseDcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const double[] cscSortedValA,
                 @Const int[] cscSortedRowIndA,
                 @Const int[] cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseCcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 cscSortedValA,
                 @Const IntPointer cscSortedRowIndA,
                 @Const IntPointer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 cscSortedValA,
                 @Const IntBuffer cscSortedRowIndA,
                 @Const IntBuffer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseCcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 cscSortedValA,
                 @Const int[] cscSortedRowIndA,
                 @Const int[] cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseZcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                 @Const IntPointer cscSortedRowIndA,
                 @Const IntPointer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                 @Const IntBuffer cscSortedRowIndA,
                 @Const IntBuffer cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);
public static native @Cast("cusparseStatus_t") int cusparseZcsc2hyb(cusparseContext handle,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 cscSortedValA,
                 @Const int[] cscSortedRowIndA,
                 @Const int[] cscSortedColPtrA,
                 cusparseHybMat hybA,
                 int userEllWidth,
                 @Cast("cusparseHybPartition_t") int partitionType);

public static native @Cast("cusparseStatus_t") int cusparseShyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 FloatPointer cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseShyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 FloatBuffer cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseShyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 float[] cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr);

public static native @Cast("cusparseStatus_t") int cusparseDhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 DoublePointer cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 DoubleBuffer cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseDhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 double[] cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr);

public static native @Cast("cusparseStatus_t") int cusparseChyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseChyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseChyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuComplex*") float2 cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr);

public static native @Cast("cusparseStatus_t") int cusparseZhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 IntPointer cscSortedRowInd,
                 IntPointer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseZhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 IntBuffer cscSortedRowInd,
                 IntBuffer cscSortedColPtr);
public static native @Cast("cusparseStatus_t") int cusparseZhyb2csc(cusparseContext handle,
                 cusparseMatDescr descrA,
                 cusparseHybMat hybA,
                 @Cast("cuDoubleComplex*") double2 cscSortedVal,
                 int[] cscSortedRowInd,
                 int[] cscSortedColPtr);

public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const IntPointer csrSortedRowPtrA,
                    @Const IntPointer csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    IntPointer bsrSortedRowPtrC,
                    IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const IntBuffer csrSortedRowPtrA,
                    @Const IntBuffer csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    IntBuffer bsrSortedRowPtrC,
                    IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const int[] csrSortedRowPtrA,
                    @Const int[] csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    int[] bsrSortedRowPtrC,
                    int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatPointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatPointer bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatBuffer bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const float[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 float[] bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoublePointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoublePointer bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoubleBuffer bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const double[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 double[] bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const FloatPointer bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatPointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const float[] bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 float[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const DoublePointer bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoublePointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoubleBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const double[] bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 double[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const FloatPointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const FloatBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const float[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const DoublePointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const DoubleBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const double[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const FloatPointer bsrSortedVal,
                                   @Const IntPointer bsrSortedRowPtr,
                                   @Const IntPointer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const FloatBuffer bsrSortedVal,
                                   @Const IntBuffer bsrSortedRowPtr,
                                   @Const IntBuffer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const float[] bsrSortedVal,
                                   @Const int[] bsrSortedRowPtr,
                                   @Const int[] bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const DoublePointer bsrSortedVal,
                                   @Const IntPointer bsrSortedRowPtr,
                                   @Const IntPointer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const DoubleBuffer bsrSortedVal,
                                   @Const IntBuffer bsrSortedRowPtr,
                                   @Const IntBuffer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Const double[] bsrSortedVal,
                                   @Const int[] bsrSortedRowPtr,
                                   @Const int[] bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuComplex*") float2 bsrSortedVal,
                                   @Const IntPointer bsrSortedRowPtr,
                                   @Const IntPointer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuComplex*") float2 bsrSortedVal,
                                   @Const IntBuffer bsrSortedRowPtr,
                                   @Const IntBuffer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuComplex*") float2 bsrSortedVal,
                                   @Const int[] bsrSortedRowPtr,
                                   @Const int[] bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                   @Const IntPointer bsrSortedRowPtr,
                                   @Const IntPointer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                   @Const IntBuffer bsrSortedRowPtr,
                                   @Const IntBuffer bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSizeExt(cusparseContext handle,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                   @Const int[] bsrSortedRowPtr,
                                   @Const int[] bsrSortedColInd,
                                   int rowBlockDim,
                                   int colBlockDim,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const FloatPointer bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     FloatPointer bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const FloatBuffer bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     FloatBuffer bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const float[] bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     float[] bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const DoublePointer bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     DoublePointer bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const DoubleBuffer bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     DoubleBuffer bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const double[] bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     double[] bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const FloatPointer bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   FloatPointer csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   FloatBuffer csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const float[] bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   float[] csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const DoublePointer bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   DoublePointer csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   DoubleBuffer csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const double[] bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   double[] csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const FloatPointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const FloatBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const float[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const DoublePointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const DoubleBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const double[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const FloatPointer csrSortedValA,
                                 @Const IntPointer csrSortedRowPtrA,
                                 @Const IntPointer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const FloatBuffer csrSortedValA,
                                 @Const IntBuffer csrSortedRowPtrA,
                                 @Const IntBuffer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const float[] csrSortedValA,
                                 @Const int[] csrSortedRowPtrA,
                                 @Const int[] csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const DoublePointer csrSortedValA,
                                 @Const IntPointer csrSortedRowPtrA,
                                 @Const IntPointer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const DoubleBuffer csrSortedValA,
                                 @Const IntBuffer csrSortedRowPtrA,
                                 @Const IntBuffer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Const double[] csrSortedValA,
                                 @Const int[] csrSortedRowPtrA,
                                 @Const int[] csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuComplex*") float2 csrSortedValA,
                                 @Const IntPointer csrSortedRowPtrA,
                                 @Const IntPointer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuComplex*") float2 csrSortedValA,
                                 @Const IntBuffer csrSortedRowPtrA,
                                 @Const IntBuffer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuComplex*") float2 csrSortedValA,
                                 @Const int[] csrSortedRowPtrA,
                                 @Const int[] csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                 @Const IntPointer csrSortedRowPtrA,
                                 @Const IntPointer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                 @Const IntBuffer csrSortedRowPtrA,
                                 @Const IntBuffer csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSizeExt(cusparseContext handle,
                                 @Cast("cusparseDirection_t") int dirA,
                                 int m,
                                 int n,
                                 cusparseMatDescr descrA,
                                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                 @Const int[] csrSortedRowPtrA,
                                 @Const int[] csrSortedColIndA,
                                 int rowBlockDim,
                                 int colBlockDim,
                                 @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      cusparseMatDescr descrC,
                      IntPointer bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      IntPointer nnzTotalDevHostPtr,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      cusparseMatDescr descrC,
                      IntBuffer bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      IntBuffer nnzTotalDevHostPtr,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      cusparseMatDescr descrC,
                      int[] bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      int[] nnzTotalDevHostPtr,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   FloatPointer bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   FloatBuffer bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   float[] bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   DoublePointer bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   DoubleBuffer bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   double[] bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const FloatPointer bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const FloatBuffer bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const float[] bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const DoublePointer bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const DoubleBuffer bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const double[] bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const FloatPointer bsrSortedValA,
                                   @Const IntPointer bsrSortedRowPtrA,
                                   @Const IntPointer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const FloatBuffer bsrSortedValA,
                                   @Const IntBuffer bsrSortedRowPtrA,
                                   @Const IntBuffer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const float[] bsrSortedValA,
                                   @Const int[] bsrSortedRowPtrA,
                                   @Const int[] bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const DoublePointer bsrSortedValA,
                                   @Const IntPointer bsrSortedRowPtrA,
                                   @Const IntPointer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const DoubleBuffer bsrSortedValA,
                                   @Const IntBuffer bsrSortedRowPtrA,
                                   @Const IntBuffer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Const double[] bsrSortedValA,
                                   @Const int[] bsrSortedRowPtrA,
                                   @Const int[] bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuComplex*") float2 bsrSortedValA,
                                   @Const IntPointer bsrSortedRowPtrA,
                                   @Const IntPointer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuComplex*") float2 bsrSortedValA,
                                   @Const IntBuffer bsrSortedRowPtrA,
                                   @Const IntBuffer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuComplex*") float2 bsrSortedValA,
                                   @Const int[] bsrSortedRowPtrA,
                                   @Const int[] bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                   @Const IntPointer bsrSortedRowPtrA,
                                   @Const IntPointer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                   @Const IntBuffer bsrSortedRowPtrA,
                                   @Const IntBuffer bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSizeExt(cusparseContext handle,
                                   @Cast("cusparseDirection_t") int dirA,
                                   int mb,
                                   int nb,
                                   int nnzb,
                                   cusparseMatDescr descrA,
                                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                   @Const int[] bsrSortedRowPtrA,
                                   @Const int[] bsrSortedColIndA,
                                   int rowBlockDimA,
                                   int colBlockDimA,
                                   int rowBlockDimC,
                                   int colBlockDimC,
                                   @Cast("size_t*") SizeTPointer pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const IntPointer bsrSortedRowPtrA,
                        @Const IntPointer bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        IntPointer bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        IntPointer nnzTotalDevHostPtr,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const IntBuffer bsrSortedRowPtrA,
                        @Const IntBuffer bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        IntBuffer bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        IntBuffer nnzTotalDevHostPtr,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const int[] bsrSortedRowPtrA,
                        @Const int[] bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        int[] bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        int[] nnzTotalDevHostPtr,
                        Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const FloatPointer bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     FloatPointer bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const FloatBuffer bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     FloatBuffer bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const float[] bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     float[] bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const DoublePointer bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     DoublePointer bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const DoubleBuffer bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     DoubleBuffer bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const double[] bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     double[] bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

//##############################################################################
//# SPARSE MATRIX SORTING
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  IntPointer p);
public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  IntBuffer p);
public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  int[] p);

public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer cooRowsA,
                               @Const IntPointer cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer cooRowsA,
                               @Const IntBuffer cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] cooRowsA,
                               @Const int[] cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      IntPointer cooRowsA,
                      IntPointer cooColsA,
                      IntPointer P,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      IntBuffer cooRowsA,
                      IntBuffer cooColsA,
                      IntBuffer P,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      int[] cooRowsA,
                      int[] cooColsA,
                      int[] P,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         IntPointer cooRowsA,
                         IntPointer cooColsA,
                         IntPointer P,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         IntBuffer cooRowsA,
                         IntBuffer cooColsA,
                         IntBuffer P,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         int[] cooRowsA,
                         int[] cooColsA,
                         int[] P,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer csrRowPtrA,
                               @Const IntPointer csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer csrRowPtrA,
                               @Const IntBuffer csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] csrRowPtrA,
                               @Const int[] csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntPointer csrRowPtrA,
                 IntPointer csrColIndA,
                 IntPointer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntBuffer csrRowPtrA,
                 IntBuffer csrColIndA,
                 IntBuffer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const int[] csrRowPtrA,
                 int[] csrColIndA,
                 int[] P,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer cscColPtrA,
                               @Const IntPointer cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer cscColPtrA,
                               @Const IntBuffer cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] cscColPtrA,
                               @Const int[] cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntPointer cscColPtrA,
                 IntPointer cscRowIndA,
                 IntPointer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntBuffer cscColPtrA,
                 IntBuffer cscRowIndA,
                 IntBuffer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const int[] cscColPtrA,
                 int[] cscRowIndA,
                 int[] P,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                FloatPointer csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                FloatBuffer csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                float[] csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                DoublePointer csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                DoubleBuffer csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                double[] csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const FloatPointer A,
                                      int lda,
                                      @Const FloatPointer threshold,
                                      cusparseMatDescr descrC,
                                      @Const FloatPointer csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const FloatBuffer A,
                                      int lda,
                                      @Const FloatBuffer threshold,
                                      cusparseMatDescr descrC,
                                      @Const FloatBuffer csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const float[] A,
                                      int lda,
                                      @Const float[] threshold,
                                      cusparseMatDescr descrC,
                                      @Const float[] csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const DoublePointer A,
                                      int lda,
                                      @Const DoublePointer threshold,
                                      cusparseMatDescr descrC,
                                      @Const DoublePointer csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const DoubleBuffer A,
                                      int lda,
                                      @Const DoubleBuffer threshold,
                                      cusparseMatDescr descrC,
                                      @Const DoubleBuffer csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const double[] A,
                                      int lda,
                                      @Const double[] threshold,
                                      cusparseMatDescr descrC,
                                      @Const double[] csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           int[] csrRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const FloatPointer A,
                           int lda,
                           @Const FloatPointer threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const FloatBuffer A,
                           int lda,
                           @Const FloatBuffer threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const float[] A,
                           int lda,
                           @Const float[] threshold,
                           cusparseMatDescr descrC,
                           int[] csrRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const DoublePointer A,
                           int lda,
                           @Const DoublePointer threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrSortedRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const DoubleBuffer A,
                           int lda,
                           @Const DoubleBuffer threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrSortedRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const double[] A,
                           int lda,
                           @Const double[] threshold,
                           cusparseMatDescr descrC,
                           int[] csrSortedRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const FloatPointer A,
                        int lda,
                        @Const FloatPointer threshold,
                        cusparseMatDescr descrC,
                        FloatPointer csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const FloatBuffer A,
                        int lda,
                        @Const FloatBuffer threshold,
                        cusparseMatDescr descrC,
                        FloatBuffer csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const float[] A,
                        int lda,
                        @Const float[] threshold,
                        cusparseMatDescr descrC,
                        float[] csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const DoublePointer A,
                        int lda,
                        @Const DoublePointer threshold,
                        cusparseMatDescr descrC,
                        DoublePointer csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const DoubleBuffer A,
                        int lda,
                        @Const DoubleBuffer threshold,
                        cusparseMatDescr descrC,
                        DoubleBuffer csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const double[] A,
                        int lda,
                        @Const double[] threshold,
                        cusparseMatDescr descrC,
                        double[] csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatPointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const FloatPointer threshold,
                                    cusparseMatDescr descrC,
                                    @Const FloatPointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const FloatBuffer threshold,
                                    cusparseMatDescr descrC,
                                    @Const FloatBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const float[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const float[] threshold,
                                    cusparseMatDescr descrC,
                                    @Const float[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoublePointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const DoublePointer threshold,
                                    cusparseMatDescr descrC,
                                    @Const DoublePointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoubleBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const DoubleBuffer threshold,
                                    cusparseMatDescr descrC,
                                    @Const DoubleBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const double[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const double[] threshold,
                                    cusparseMatDescr descrC,
                                    @Const double[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         IntPointer csrSortedRowPtrC,
                         IntPointer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         IntBuffer csrSortedRowPtrC,
                         IntBuffer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         int[] csrSortedRowPtrC,
                         int[] nnzTotalDevHostPtr,
                         Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const FloatPointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const FloatPointer threshold,
                         cusparseMatDescr descrC,
                         IntPointer csrSortedRowPtrC,
                         IntPointer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const FloatBuffer threshold,
                         cusparseMatDescr descrC,
                         IntBuffer csrSortedRowPtrC,
                         IntBuffer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const float[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const float[] threshold,
                         cusparseMatDescr descrC,
                         int[] csrSortedRowPtrC,
                         int[] nnzTotalDevHostPtr,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          @Const DoublePointer threshold,
                          cusparseMatDescr descrC,
                          IntPointer csrSortedRowPtrC,
                          IntPointer nnzTotalDevHostPtr,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const DoubleBuffer threshold,
                          cusparseMatDescr descrC,
                          IntBuffer csrSortedRowPtrC,
                          IntBuffer nnzTotalDevHostPtr,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          @Const double[] threshold,
                          cusparseMatDescr descrC,
                          int[] csrSortedRowPtrC,
                          int[] nnzTotalDevHostPtr,
                          Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const FloatPointer threshold,
                      cusparseMatDescr descrC,
                      FloatPointer csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const FloatBuffer threshold,
                      cusparseMatDescr descrC,
                      FloatBuffer csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const float[] threshold,
                      cusparseMatDescr descrC,
                      float[] csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const DoublePointer threshold,
                      cusparseMatDescr descrC,
                      DoublePointer csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const DoubleBuffer threshold,
                      cusparseMatDescr descrC,
                      DoubleBuffer csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const double[] threshold,
                      cusparseMatDescr descrC,
                      double[] csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const FloatPointer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatPointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const FloatBuffer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const float[] A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const float[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const DoublePointer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoublePointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const DoubleBuffer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoubleBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const double[] A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const double[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatPointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const float[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoublePointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoubleBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const double[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatPointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    FloatPointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    FloatBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const float[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    float[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoublePointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    DoublePointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoubleBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    DoubleBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const double[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    double[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const FloatPointer csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatPointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const FloatBuffer csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const float[] csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const float[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const DoublePointer csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoublePointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const DoubleBuffer csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoubleBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const double[] csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const double[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatPointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const float[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoublePointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoubleBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const double[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const FloatPointer csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  FloatPointer csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const FloatBuffer csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  FloatBuffer csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const float[] csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  float[] csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const DoublePointer csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  DoublePointer csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const DoubleBuffer csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  DoubleBuffer csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const double[] csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  double[] csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

//##############################################################################
//# CSR2CSC
//##############################################################################

/** enum cusparseCsr2CscAlg_t */
public static final int
    CUSPARSE_CSR2CSC_ALG1 = 1, // faster than V2 (in general), deterministc
    CUSPARSE_CSR2CSC_ALG2 = 2;  // low memory requirement, non-deterministc

public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const IntPointer csrRowPtr,
                   @Const IntPointer csrColInd,
                   Pointer cscVal,
                   IntPointer cscColPtr,
                   IntPointer cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const IntBuffer csrRowPtr,
                   @Const IntBuffer csrColInd,
                   Pointer cscVal,
                   IntBuffer cscColPtr,
                   IntBuffer cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const int[] csrRowPtr,
                   @Const int[] csrColInd,
                   Pointer cscVal,
                   int[] cscColPtr,
                   int[] cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);

public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const IntPointer csrRowPtr,
                              @Const IntPointer csrColInd,
                              Pointer cscVal,
                              IntPointer cscColPtr,
                              IntPointer cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const IntBuffer csrRowPtr,
                              @Const IntBuffer csrColInd,
                              Pointer cscVal,
                              IntBuffer cscColPtr,
                              IntBuffer cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const int[] csrRowPtr,
                              @Const int[] csrColInd,
                              Pointer cscVal,
                              int[] cscColPtr,
                              int[] cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);

//##############################################################################
//# SpMM APIs
//##############################################################################

/** enum cusparseFormat_t */
public static final int
    /** Compressed Sparse Row (CSR) */
    CUSPARSE_FORMAT_CSR     = 1,
    /** Compressed Sparse Column (CSC) */
    CUSPARSE_FORMAT_CSC     = 2,
    /** Coordinate (COO) - Structure of Arrays */
    CUSPARSE_FORMAT_COO     = 3,
    /** Coordinate (COO) - Array of Structures */
    CUSPARSE_FORMAT_COO_AOS = 4;

/** enum cusparseOrder_t */
public static final int
    /** Column-Major Order - Matrix memory layout */
    CUSPARSE_ORDER_COL = 1,
    /** Row-Major Order - Matrix memory layout */
    CUSPARSE_ORDER_ROW = 2;

/** enum cusparseSpMVAlg_t */
public static final int
    CUSPARSE_MV_ALG_DEFAULT = 0,
    CUSPARSE_COOMV_ALG      = 1,
    CUSPARSE_CSRMV_ALG1     = 2,
    CUSPARSE_CSRMV_ALG2     = 3;

/** enum cusparseSpMMAlg_t */
public static final int
    CUSPARSE_MM_ALG_DEFAULT = 0,
    CUSPARSE_COOMM_ALG1 = 1, // non-deterministc results
    CUSPARSE_COOMM_ALG2 = 2, // deterministic results
    CUSPARSE_COOMM_ALG3 = 3, // non-deterministc results, for large matrices
    CUSPARSE_CSRMM_ALG1 = 4;

/** enum cusparseIndexType_t */
public static final int
    /** 16-bit unsigned integer for matrix/vector
 *  indices */
    CUSPARSE_INDEX_16U = 1,
    /** 32-bit signed integer for matrix/vector indices */
    CUSPARSE_INDEX_32I = 2,
    /** 64-bit signed integer for matrix/vector indices */
    CUSPARSE_INDEX_64I = 3;
// Targeting ../cusparse/cusparseSpVecDescr.java


// Targeting ../cusparse/cusparseDnVecDescr.java


// Targeting ../cusparse/cusparseSpMatDescr.java


// Targeting ../cusparse/cusparseDnMatDescr.java



//------------------------------------------------------------------------------
// SPARSE VECTOR DESCRIPTOR













//------------------------------------------------------------------------------
// DENSE VECTOR DESCRIPTOR











//------------------------------------------------------------------------------
// SPARSE MATRIX DESCRIPTOR



























//------------------------------------------------------------------------------
// DENSE MATRIX DESCRIPTOR















//------------------------------------------------------------------------------
// SPARSE VECTOR-VECTOR MULTIPLICATION





//------------------------------------------------------------------------------
// SPARSE MATRIX-VECTOR MULTIPLICATION





//------------------------------------------------------------------------------
// SPARSE MATRIX-MATRIX MULTIPLICATION





//==============================================================================
//==============================================================================

// #if defined(__cplusplus)
// #endif // defined(__cplusplus)

// #undef CUSPARSE_DEPRECATED
// #endif // !defined(CUSPARSE_H_)


}
