// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nppicom;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

import static org.bytedeco.cuda.global.nppicom.*;



/**
 * \name Hybrid CPU+GPU JPEG Huffman decoding
 *
 * These functions and structs are used for Huffman decoding part of JPEG decode pipeline.
 * It uses hybrid CPU + GPU approach.
 *
 * See \ref nppiJpegDecodeJob for more documentation and example
 */
/*@{*/

/**
 * JPEG frame descriptor.
 *
 * Can hold from 1 to 4 components.
 */
@Properties(inherit = org.bytedeco.cuda.presets.nppicom.class)
public class NppiJpegFrameDescr extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NppiJpegFrameDescr() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NppiJpegFrameDescr(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NppiJpegFrameDescr(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NppiJpegFrameDescr position(long position) {
        return (NppiJpegFrameDescr)super.position(position);
    }

    /** Number of components in frame */
    public native @Cast("Npp8u") byte nComponents(); public native NppiJpegFrameDescr nComponents(byte setter);
    /** Size of component with 1x1 subsampling (usually luma) in DCT blocks. */
    public native @ByRef NppiSize oSizeInBlocks(); public native NppiJpegFrameDescr oSizeInBlocks(NppiSize setter);
    /** Subsampling factors of component, as described in frame header */
    public native @ByRef NppiSize aComponentSubsampling(int i); public native NppiJpegFrameDescr aComponentSubsampling(int i, NppiSize setter);
    @MemberGetter public native NppiSize aComponentSubsampling();
    /**
            Buffer containing DCT coefficients. Use \ref nppiJpegDecodeGetDCTBufferSize to
            determine size of this buffer. After decoding, coefficients will be stored in
            zig-zag order, block by block. So the c-th coeffient of block {@code (x, y)} will
            be stored at {@code buffer[64 * (y * interleavedComponentWidthInBlocks + x) + c]}.
        */
    public native @Cast("Npp16s*") ShortPointer apComponentBuffer(int i); public native NppiJpegFrameDescr apComponentBuffer(int i, ShortPointer setter);
    @MemberGetter public native @Cast("Npp16s**") PointerPointer apComponentBuffer();
}
