// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.nppicc.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppicc extends org.bytedeco.cuda.presets.nppicc {
    static { Loader.load(); }

// Parsed from <nppi_color_conversion.h>

 /* Copyright 2009-2019 NVIDIA Corporation.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are 
  * subject to NVIDIA intellectual property rights under U.S. and 
  * international Copyright laws. 
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED 
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY                                                  
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_COLOR_CONVERSION_H
// #define NV_NPPI_COLOR_CONVERSION_H
 
/**
 * \file nppi_color_conversion.h
 * NPP Image Processing Functionality.
 */
 
// #include "nppdefs.h"


// #ifdef __cplusplus
// #endif


/** \defgroup image_color_conversion Color and Sampling Conversion
 *  \ingroup nppi
 *
 * Routines manipulating an image's color model and sampling format.
 *
 * \{
 *
 * These functions can be found in the nppicc library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 *
 */

/** \defgroup image_color_model_conversion Color Model Conversion
 *
 * Routines for converting between various image color models.
 *
 * \{ 
 *
 */

/** \defgroup rgbtoyuv RGBToYUV 
 *  RGB to YUV color conversion.
 *
 *  Here is how NPP converts gamma corrected RGB or BGR to YUV. For digital RGB values in the range [0..255], 
 *  Y has the range [0..255], U varies in the range [-112..+112], 
 *  and V in the range [-157..+157]. To fit in the range of [0..255], a constant value
 *  of 128 is added to computed U and V values, and V is then saturated.
 *
 *  <pre>{@code   
 *  Npp32f nY =  0.299F * R + 0.587F * G + 0.114F * B; 
 *  Npp32f nU = (0.492F * ((Npp32f)nB - nY)) + 128.0F;
 *  Npp32f nV = (0.877F * ((Npp32f)nR - nY)) + 128.0F;
 *  if (nV > 255.0F) 
 *      nV = 255.0F;
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed YUV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed YUV color conversion with alpha, not affecting alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YUV color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YUV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned planar YUV color conversion with alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV_8u_AC4P4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoyuv */

/** \defgroup bgrtoyuv BGRToYUV 
 *  BGR to YUV color conversion.
 *
 *  Here is how NPP converts gamma corrected RGB or BGR to YUV. For digital RGB values in the range [0..255], 
 *  Y has the range [0..255], U varies in the range [-112..+112], 
 *  and V in the range [-157..+157]. To fit in the range of [0..255], a constant value
 *  of 128 is added to computed U and V values, and V is then saturated.
 *
 *  <pre>{@code   
 *  Npp32f nY =  0.299F * R + 0.587F * G + 0.114F * B; 
 *  Npp32f nU = (0.492F * ((Npp32f)nB - nY)) + 128.0F;
 *  Npp32f nV = (0.877F * ((Npp32f)nR - nY)) + 128.0F;
 *  if (nV > 255.0F) 
 *      nV = 255.0F;
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned packed YUV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 4 channel 8-bit unsigned packed YUV color conversion with alpha, not affecting alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar YUV color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YUV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 4 channel 8-bit unsigned planar YUV color conversion with alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV_8u_AC4P4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoyuv */

/** \defgroup yuvtorgb YUVToRGB 
 *  YUV to RGB color conversion.
 *
 *  Here is how NPP converts YUV to gamma corrected RGB or BGR.
 *
 *  <pre>{@code
 *  Npp32f nY = (Npp32f)Y;
 *  Npp32f nU = (Npp32f)U - 128.0F;
 *  Npp32f nV = (Npp32f)V - 128.0F;
 *  Npp32f nR = nY + 1.140F * nV; 
 *  if (nR < 0.0F)
 *      nR = 0.0F;
 *  if (nR > 255.0F)
 *      nR = 255.0F;    
 *  Npp32f nG = nY - 0.394F * nU - 0.581F * nV;
 *  if (nG < 0.0F)
 *      nG = 0.0F;
 *  if (nG > 255.0F)
 *      nG = 255.0F;    
 *  Npp32f nB = nY + 2.032F * nU;
 *  if (nB < 0.0F)
 *      nB = 0.0F;
 *  if (nB > 255.0F)
 *      nB = 255.0F;    
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit packed YUV with alpha to 4 channel 8-bit unsigned packed RGB color conversion with alpha, not affecting alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} yuvtorgb */

/** \defgroup yuvtorgbbatch YUVToRGBBatch
 *  YUV to RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 *  NPP converts YUV to gamma corrected RGB the same way as in \ref yuvtorgb.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input and output images passed in pSrcBatchList and pSrcBatchList
 * arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the borders of any of provided images.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_C3R_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_C3R(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuvtorgbbatch */

/** \defgroup yuvtorgbbatchadvanced YUVToRGBBatchAdvanced
 *  YUV to RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 *  NPP converts YUV to gamma corrected RGB the same way as in \ref yuvtorgb.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair of input/output images has own ROI.
 * Provided oMaxSizeROI must contain the maximum width and the maximum height of all ROIs defined in pDstBatchList. API user must ensure that
 * ROI from pDstBatchList for each pair of input and output images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_C3R_Advanced_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_C3R_Advanced(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUVToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuvtorgbbatchadvanced */

/** \defgroup yuvtobgr YUVToBGR 
 *  YUV to BGR color conversion.
 *
 *  Here is how NPP converts YUV to gamma corrected RGB or BGR.
 *
 *  <pre>{@code
 *  Npp32f nY = (Npp32f)Y;
 *  Npp32f nU = (Npp32f)U - 128.0F;
 *  Npp32f nV = (Npp32f)V - 128.0F;
 *  Npp32f nR = nY + 1.140F * nV; 
 *  if (nR < 0.0F)
 *      nR = 0.0F;
 *  if (nR > 255.0F)
 *      nR = 255.0F;    
 *  Npp32f nG = nY - 0.394F * nU - 0.581F * nV;
 *  if (nG < 0.0F)
 *      nG = 0.0F;
 *  if (nG > 255.0F)
 *      nG = 255.0F;    
 *  Npp32f nB = nY + 2.032F * nU;
 *  if (nB < 0.0F)
 *      nB = 0.0F;
 *  if (nB > 255.0F)
 *      nB = 255.0F;    
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit packed YUV with alpha to 4 channel 8-bit unsigned packed BGR color conversion with alpha, not affecting alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} yuvtobgr */

/** \defgroup yuvtobgrbatch YUVToBGRBatch
 *  YUV to BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 *  NPP converts YUV to gamma corrected BGR the same way as in \ref yuvtobgr.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input and output images passed in pSrcBatchList and pSrcBatchList
 * arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the borders of any of provided images.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_C3R_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_C3R(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuvtobgrbatch */

/** \defgroup yuvtobgrbatchadvanced YUVToBGRBatchAdvanced
 *  YUV to BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 *  NPP converts YUV to gamma corrected BGR the same way as in \ref yuvtobgr.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YUV to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair of input/output images has own ROI.
 * Provided oMaxSizeROI must contain the maximum width and the maximum height of all ROIs defined in pDstBatchList. API user must ensure that
 * ROI from pDstBatchList for each pair of input and output images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_C3R_Advanced_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_C3R_Advanced(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUVToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuvtobgrbatchadvanced */

/** \defgroup rgbtoyuv422 RGBToYUV422 
 *  RGB to YUV422 color conversion.
 *
 *  NPP converts YUV to gamma corrected BGR the same way as in \ref yuvtobgr.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 2 channel 8-bit unsigned packed YUV422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YUV422 color conversion.
 * images.
 *                         
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YUV422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV422_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoyuv422 */

/** \defgroup yuv422torgb YUV422ToRGB 
 *  YUV422 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed YUV422 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV422 to 4 channel 8-bit unsigned packed RGB color conversion with alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} yuv422torgb */

/** \defgroup yuv422torgbbatch YUV422ToRGBBatch
 *  Planar YUV422 to packed RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuv422torgbbatch */

/** \defgroup yuv422torgbbatchadvanced YUV422ToRGBBatchAdvanced
 *  Planar YUV422 to packed RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuv422torgbbatchadvanced */

/** \defgroup yuv422tobgrbatch YUV422ToBGRBatch
 *  Planar YUV422 to packed BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuv422tobgrbatch */

/** \defgroup yuv422tobgrbatchadvanced YUV422ToBGRBatchAdvanced
 *  Planar YUV422 to packed BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV422 to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUV422ToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuv422tobgrbatchadvanced */

/** \defgroup rgbtoyuv420 RGBToYUV420 
 *  RGB to YUV420 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YUV420 color conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YUV420 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYUV420_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoyuv420 */

/** \defgroup yuv420torgb YUV420ToRGB 
 *  YUV420 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV420 to 4 channel 8-bit unsigned packed RGB color conversion with constant alpha (0xFF).
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV420 to 4 channel 8-bit unsigned packed RGB color conversion with alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGB_8u_P3AC4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} yuv420torgb */

/** \defgroup yuv420torgbbatch YUV420ToRGBBatch
 *  Planar YUV420 to packed RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents Y planes.
 *        The second element of array (pSrcBatchList[1]) represents U planes. The third element of array (pSrcBatchList[2])
 *        represents V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuv420torgbbatch */

/** \defgroup yuv420torgbbatchadvanced YUV420ToRGBBatchAdvanced
 *  Planar YUV420 to packed RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuv420torgbbatchadvanced */

/** \defgroup nv12torgb NV12ToRGB 
 *  NV12 to RGB color conversion.
 *
 * \{
 *
 */

/**
 *  2 channel 8-bit unsigned planar NV12 to 3 channel 8-bit
 *  unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y
 *  	  plane, one for UV plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 *  2 channel 8-bit unsigned planar NV12 to 3 channel 8-bit
 *  unsigned packed RGB 709 HDTV full color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y
 *  	  plane, one for UV plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToRGB_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} nv12torgb */

/** \defgroup nv21torgb NV21ToRGB 
 *  NV21 to RGB color conversion.
 *
 * \{
 *
 */

/**
 *  2 channel 8-bit unsigned planar NV21 to 4 channel 8-bit unsigned packed RGBA color conversion with constant alpha (0xFF).
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y plane, one for VU plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToRGB_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} nv21torgb */

/** \defgroup bgrtoyuv420 BGRToYUV420 
 *  BGR to YUV420 color conversion.
 *
 * \{
 *
 */

/**
 * 4 channel 8-bit unsigned pacmed BGR with alpha to 3 channel 8-bit unsigned planar YUV420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYUV420_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);
 
/** \} bgrtoyuv420 */

/** \defgroup yuv420tobgr YUV420ToBGR 
 *  YUV420 to BGR color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YUV420 to 4 channel 8-bit unsigned packed BGR color conversion with constant alpha (0xFF).
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} yuv420tobgr */

/** \defgroup yuv420tobgrbatch YUV420ToBGRBatch
 *  Planar YUV420 to packed BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents Y planes.
 *        The second element of array (pSrcBatchList[1]) represents U planes. The third element of array (pSrcBatchList[2])
 *        represents V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} yuv420tobgrbatch */

/** \defgroup yuv420tobgrbatchadvanced YUV420ToBGRBatchAdvanced
 *  Planar YUV420 to packed BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YUV420 to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of U planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of V planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYUV420ToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} yuv420tobgrbatchadvanced */

/** \defgroup nv12tobgr NV12ToBGR 
 *  NV12 to BGR color conversion.
 *
 * \{
 *
 */

/**
 *  2 channel 8-bit unsigned planar NV12 to 3 channel 8-bit
 *  unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y
 *  	  plane, one for UV plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 *  2 channel 8-bit unsigned planar NV12 to 3 channel 8-bit
 *  unsigned packed BGR 709 HDTV full color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y
 *  	  plane, one for UV plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToBGR_709HDTV_8u_P2C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} nv12tobgr */

/** \defgroup nv21tobgr NV21ToBGR 
 *  NV21 to BGR color conversion.
 *
 * \{
 *
 */

/**
 *  2 channel 8-bit unsigned planar NV21 to 4 channel 8-bit unsigned packed BGRA color conversion with constant alpha (0xFF).
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y plane, one for VU plane).
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV21ToBGR_8u_P2C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} nv21tobgr */

/** \defgroup rgbtoycbcr RGBToYCbCr 
 *  RGB to YCbCr color conversion.
 *
 *  Here is how NPP converts gamma corrected RGB or BGR to YCbCr.  In the YCbCr model, 
 *  Y is defined to have a nominal range [16..235], while Cb and Cr are defined
 *  to have a range [16..240], with the value of 128 as corresponding to zero.
 *
 *  <pre>{@code
 *  Npp32f nY  =  0.257F * R + 0.504F * G + 0.098F * B + 16.0F; 
 *  Npp32f nCb = -0.148F * R - 0.291F * G + 0.439F * B + 128.0F;
 *  Npp32f nCr =  0.439F * R - 0.368F * G - 0.071F * B + 128.0F;
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel unsigned 8-bit packed YCbCr color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel unsigned 8-bit packed YCbCr with alpha color conversion, not affecting alpha.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel planar 8-bit unsigned RGB to 3 channel planar 8-bit YCbCr color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel unsigned 8-bit planar YCbCr color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 3 channel 8-bit unsigned planar YCbCr color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycbcr */

/** \defgroup ycbcrtorgb YCbCrToRGB 
 *  YCbCr to RGB color conversion.
 *
 *  Here is how NPP converts YCbCr to gamma corrected RGB or BGR.  The output RGB values are saturated to the range [0..255].
 *
 *  <pre>{@code
 *  Npp32f nY = 1.164F * ((Npp32f)Y - 16.0F);
 *  Npp32f nR = ((Npp32f)Cr - 128.0F); Npp32f nB = ((Npp32f)Cb
 *  - 128.0F); Npp32f nG = nY - 0.813F * nR - 0.392F * nB; if (nG > 255.0F)
 *      nG = 255.0F;
 *  nR = nY + 1.596F * nR; 
 *  if (nR > 255.0F)
 *      nR = 255.0F;
 *  nB = nY + 2.017F * nB;
 *  if (nB > 255.0F)
 *      nB = 255.0F;
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YCbCr to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed YCbCr with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion, not affecting alpha.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 4 channel 8-bit unsigned packed RGB color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.                                         
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcrtorgb */

/** \defgroup ycbcrtorgbbatch YCbCrToRGBBatch
 *  YCbCr to RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 *  NPP converts YCbCr to gamma corrected RGB the same way as in \ref ycbcrtorgb.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YCbCr to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input and output images passed in pSrcBatchList and pSrcBatchList
 * arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the borders of any of provided images.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_C3R_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_C3R(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcrtorgbbatch */

/** \defgroup ycbcrtorgbbatchadvanced YCbCrToRGBBatchAdvanced
 *  YCbCr to RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 *  NPP converts YCbCr to gamma corrected RGB the same way as in \ref ycbcrtorgb.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YCbCr to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair of input/output images has own ROI.
 * Provided oMaxSizeROI must contain the maximum width and the maximum height of all ROIs defined in pDstBatchList. API user must ensure that
 * ROI from pDstBatchList for each pair of input and output images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_C3R_Advanced_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_C3R_Advanced(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcrtorgbbatchadvanced */

/** \defgroup ycbcrtobgr YCbCrToBGR 
 *  YCbCr to BGR color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 4 channel 8-bit unsigned packed BGR color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcrtobgr */

/** \defgroup ycbcrtobgrbatch YCbCrToBGRBatch
 *  YCbCr to BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 *  NPP converts YCbCr to gamma corrected BGR the same way as in \ref ycbcrtobgr.
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned packed YCbCr to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input and output images passed in pSrcBatchList and pSrcBatchList
 * arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the borders of any of provided images.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_C3R_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_C3R(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this  call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcrtobgrbatch */

/** \defgroup ycbcrtobgrbatchadvanced YCbCrToBGRBatchAdvanced
 *  YCbCr to BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 *  NPP converts YCbCr to gamma corrected BGR the same way as in \ref ycbcrtobgr.
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed YCbCr to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair of input/output images has own ROI.
 * Provided oMaxSizeROI must contain the maximum width and the maximum height of all ROIs defined in pDstBatchList. API user must ensure that
 * ROI from pDstBatchList for each pair of input and output images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList \ref source_batch_images_pointer.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context.
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_C3R_Advanced_Ctx(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_C3R_Advanced(@Const NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcrtobgrbatchadvanced */

/** \defgroup ycbcrtobgr709 YCbCrToBGR_709CSC 
 *  YCbCr to BGR_709CSC color conversion.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YCbCr to 3 channel 8-bit unsigned packed BGR_709CSC color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr to 4 channel 8-bit unsigned packed BGR_709CSC color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCrToBGR_709CSC_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcrtobgr709 */

/** \defgroup rgbtoycbcr422 RGBToYCbCr422 
 *  RGB to YCbCr422 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 2 channel 8-bit unsigned packed YCbCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 2 channel 8-bit unsigned packed YCbCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycbcr422 */

/** \defgroup ycbcr422torgb YCbCr422ToRGB 
 *  YCbCr422 to RGB color conversion.
 *
 * \{
 *
 */
 
/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned packed RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI); 

/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycbcr422torgb */

/** \defgroup ycbcr422torgbbatch YCbCr422ToRGBBatch
 *  Planar YCbCr422 to packed RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcr422torgbbatch */

/** \defgroup ycbcr422torgbbatchadvanced YCbCr422ToRGBBatchAdvanced
 *  Planar YCbCr422 to packed RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcr422torgbbatchadvanced */

/** \defgroup rgbtoycrcb422 RGBToYCrCb422 
 *  RGB to YCrCb422 color conversion.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned packed RGB to 2 channel 8-bit unsigned packed YCrCb422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 2 channel 8-bit unsigned packed YCrCb422 color conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycrcb422 */

/** \defgroup ycrcb422torgb YCrCb422ToRGB 
 *  YCrCb422 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned packed RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI); 

/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned planar RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToRGB_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycrcb422torgb */

/** \defgroup bgrtoycbcr422 BGRToYCbCr422 
 *  BGR to YCbCr422 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 2 channel 8-bit unsigned packed YCrCb422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 2 channel 8-bit unsigned packed YCrCb422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr422 */

/** \defgroup ycbcr422tobgr YCbCr422ToBGR 
 *  YCbCr422 to BGR color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned packed BGR color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 4 channel 8-bit unsigned packed BGR color conversion with constant alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed BGR color conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycbcr422tobgr */

/** \defgroup ycbcr422tobgrbatch YCbCr422ToBGRBatch
 *  Planar YCbCr422 to packed BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this  call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcr422tobgrbatch */

/** \defgroup ycbcr422tobgrbatchadvanced YCbCr422ToBGRBatchAdvanced
 *  Planar YCbCr422 to packed BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcr422tobgrbatchadvanced */

/** \defgroup rgbtocbycr422 RGBToCbYCr422 
 *  RGB to CbYCr422 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 2 channel 8-bit unsigned packed CbYCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB first gets forward gamma corrected then converted to 2 channel 8-bit unsigned packed CbYCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToCbYCr422Gamma_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtocbycr422 */

/** \defgroup cbcr422torgb CbYCr422ToRGB 
 *  CbYCr422 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed CbYCrC22 to 3 channel 8-bit unsigned packed RGB color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToRGB_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} cbcr422torgb */

/** \defgroup bgrtocbycr422 BGRToCbYCr422 
 *  BGR to CbYCr422 color conversion.
 *
 * \{
 *
 */

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 2 channel 8-bit unsigned packed CbYCr422 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_8u_AC4C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtocbycr422 */

/** \defgroup bgrtocbycr422709HDTV BGRToCbYCr422_709HDTV 
 *  BGR to CbYCr422_709HDTV color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 2 channel 8-bit unsigned packed CbYCr422_709HDTV color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_C3C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 2 channel 8-bit unsigned packed CbYCr422_709HDTV color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToCbYCr422_709HDTV_8u_AC4C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtocbycr422709HDTV */

/** \defgroup cbycr422tobgr CbYCr422ToBGR 
 *  CbYCr422 to BGR color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 4 channel 8-bit unsigned packed BGR color conversion with alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_8u_C2C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} cbycr422tobgr */

/** \defgroup cbycr422tobgr709hdtv CbYCr422ToBGR_709HDTV 
 *  CbYCr422 to BGR_709HDTV color conversion.
 *
 * \{
 *
 */

/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 3 channel 8-bit unsigned packed BGR_709HDTV color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 4 channel 8-bit unsigned packed BGR_709HDTV color conversion with constant alpha.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiCbYCr422ToBGR_709HDTV_8u_C2C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} cbycr422tobgr709hdtv */

/** \defgroup rgbtoycbcr420 RGBToYCbCr420 
 *  RGB to YCbCr420 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycbcr420 */

/** \defgroup ycbcr420torgb YCbCr420ToRGB 
 *  YCbCr420 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycbcr420torgb */

/** \defgroup ycbcr420torgbbatch YCbCr420ToRGBBatch
 *  Planar YCbCr420 to packed RGB batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed RGB batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcr420torgbbatch */

/** \defgroup ycbcr420torgbbatchadvanced YCbCr420ToRGBBatchAdvanced
 *  Planar YCbCr420 to packed RGB batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed RGB batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGBBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcr420torgbbatchadvanced */

/** \defgroup rgbtoycrcb420 RGBToYCrCb420 
 *  RGB to YCrCb420 color conversion.
 *
 * \{
 *
 */

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 3 channel 8-bit unsigned planar YCrCb420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycrcb420 */

/** \defgroup ycrcb420torgb YCrCb420ToRGB 
 *  YCrCb420 to RGB color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 4 channel 8-bit unsigned packed RGB color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc,IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc,IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc,IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc,int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc,IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc,IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc,IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCrCb420ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc,int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycrcb420torgb */

/** \defgroup bgrtoycbcr420 BGRToYCbCr420 
 *  BGR to YCbCr420 color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr420 */

/** \defgroup bgrtoycbcr420709csc BGRToYCbCr420_709CSC 
 *  BGR to YCbCr420_709CSC color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr420_709CSC color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr420_709CSC color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr420709csc */

/** \defgroup bgrtoycbcr420709hdtv BGRToYCbCr420_709HDTV 
 *  BGR to YCbCr420_709HDTV color conversion.
 *
 * \{
 *
 */

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr420_709HDTV color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_709HDTV_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr420709hdtv */

/** \defgroup bgrtoycrdb420709csc BGRToYCrCb420_709CSC 
 *  BGR to YCrCb420_709CSC color conversion.
 * \{
 */

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCrCb420_709CSC color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCrCb420_709CSC color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_709CSC_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycrdb420709csc */

/** \defgroup ycbcr420tobgr YCbCr420ToBGR 
 *  YCbCr420 to BGR color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 4 channel 8-bit unsigned packed BGR color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep,@Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep,@Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep,@Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep,@Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep,@Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep,@Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep,@Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep,@Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcr420tobgr */

/** \defgroup ycbcr420tobgrbatch YCbCr420ToBGRBatch
 *  Planar YCbCr420 to packed BGR batch color conversion with a single \ref roi_specification for all pairs of input/output images provided in batches.
 *
 * \{
 *
 */
 
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed BGR batch color conversion for a single ROI.
 * Provided oSizeROI will be used for all pairs of input planes making input images and output packed images passed in
 * pSrcBatchList and pSrcBatchList arguments. API user must ensure that provided ROI (oSizeROI) does not go beyond the
 * borders of any of provided images.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize A number of \ref NppiImageDescriptor structures processed in this  call (must be > 1).
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oSizeROI);

/** \} ycbcr420tobgrbatch */

/** \defgroup ycbcr420tobgrbatchadvanced YCbCr420ToBGRBatchAdvanced
 *  Planar YCbCr420 to packed BGR batch color conversion where each pair of input/output images from provided batches has own \ref roi_specification.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed BGR batch color conversion where each pair
 * of input/output images has own ROI. Provided oMaxSizeROI must contain the maximum width and the maximum height of all
 * ROIs defined in pDstBatchList. API user must ensure that ROI from pDstBatchList for each pair of input and output
 * images does not go beyond the borders of images in each pair.
 *
 * @param pSrcBatchList An array where each element is a batch of images representing one of planes in planar images,
 *        \ref source_batch_images_pointer. The first element of array (pSrcBatchList[0]) represents a batch of Y planes.
 *        The second element of array (pSrcBatchList[1]) represents a batch of Cb planes. The third element of array
 *        (pSrcBatchList[2]) represents a batch of Cr planes.
 * @param pDstBatchList \ref destination_batch_images_pointer.
 * @param nBatchSize Number of \ref NppiImageDescriptor structures processed in this call (must be > 1).
 * @param oMaxSizeROI \ref roi_specification, must contain the maximum width and the maximum height from all destination ROIs used for processing data.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Advanced_Ctx(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Advanced(@Cast("const NppiImageDescriptor*const*") PointerPointer pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGRBatch_8u_P3C3R_Advanced(@Const @ByPtrPtr NppiImageDescriptor pSrcBatchList, NppiImageDescriptor pDstBatchList, int nBatchSize, @ByVal NppiSize oMaxSizeROI);

/** \} ycbcr420tobgrbatchadvanced */

/** \defgroup ycbcr420tobgr709csc YCbCr420ToBGR_709CSC 
 *  YCbCr420_709CSC to BGR color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed BGR_709CSC color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709CSC_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycbcr420tobgr709csc */

/** \defgroup ycbcr420tobgr709hdtv YCbCr420ToBGR_709HDTV 
 *  YCbCr420_709HDTV to BGR color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 4 channel 8-bit unsigned packed BGR_709HDTV color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_709HDTV_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcr420tobgr709hdtv */

/** \defgroup bgrtoycrcb420 BGRToYCrCb420 
 *  BGR to YCrCb420 color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCrCb420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCrCb420 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCrCb420_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycrcb420 */

/** \defgroup bgrtoycbcr411 BGRToYCbCr411 
 *  BGR to YCbCr411 color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr411 */

/** \defgroup rgbtoycbcr411 RGBToYCbCr411 
 *  RGB to YCbCr411 color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycbcr411 */

/** \defgroup bgrtoycbcr BGRToYCbCr 
 *  BGR to YCbCr color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 3 channel 8-bit unsigned planar YCbCr color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 4 channel 8-bit unsigned planar YCbCr color conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr_8u_AC4P4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtoycbcr */

/** \defgroup ycbcr411tobgr YCbCr411ToBGR 
 *  YCbCr411 to BGR color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 4 channel 8-bit unsigned packed BGR color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcr411tobgr */

/** \defgroup ycbcr411torgb YCbCr411ToRGB 
 *  YCbCr411 to RGB color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 4 channel 8-bit unsigned packed RGB color conversion with constant alpha.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAval 8-bit unsigned alpha constant.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_8u_P3C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nAval);

/** \} ycbcr411torgb */

/** \defgroup rgbtoxyz RGBToXYZ 
 *  RGB to XYZ color conversion.
 *
 *  Here is how NPP converts gamma corrected RGB or BGR to XYZ.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nX = 0.412453F * nNormalizedR + 0.35758F  * nNormalizedG + 0.180423F * nNormalizedB; 
 *  if (nX > 1.0F)
 *      nX = 1.0F;
 *  Npp32f nY = 0.212671F * nNormalizedR + 0.71516F  * nNormalizedG + 0.072169F * nNormalizedB;
 *  if (nY > 1.0F)
 *      nY = 1.0F;
 *  Npp32f nZ = 0.019334F * nNormalizedR + 0.119193F * nNormalizedG + 0.950227F * nNormalizedB;
 *  if (nZ > 1.0F)
 *      nZ = 1.0F;
 *  X = (Npp8u)(nX * 255.0F);
 *  Y = (Npp8u)(nY * 255.0F);
 *  Z = (Npp8u)(nZ * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed XYZ color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed XYZ with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToXYZ_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoxyz */

/** \defgroup xyztorgb XYZToRGB 
 *  XYZ to RGB color conversion.
 *
 *  Here is how NPP converts XYZ to gamma corrected RGB or BGR.  The code assumes that X,Y, and Z values are in the range [0..1].
 *
 *  <pre>{@code
 *  Npp32f nNormalizedX = (Npp32f)X * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedY = (Npp32f)Y * 0.003921569F;
 *  Npp32f nNormalizedZ = (Npp32f)Z * 0.003921569F;
 *  Npp32f nR = 3.240479F * nNormalizedX - 1.53715F  * nNormalizedY - 0.498535F * nNormalizedZ; 
 *  if (nR > 1.0F)
 *      nR = 1.0F;
 *  Npp32f nG = -0.969256F * nNormalizedX + 1.875991F  * nNormalizedY + 0.041556F * nNormalizedZ;
 *  if (nG > 1.0F)
 *      nG = 1.0F;
 *  Npp32f nB = 0.055648F * nNormalizedX - 0.204043F * nNormalizedY + 1.057311F * nNormalizedZ;
 *  if (nB > 1.0F)
 *      nB = 1.0F;
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed XYZ to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed XYZ with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiXYZToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} xyztorgb */

/** \defgroup rgbtoluv RGBToLUV 
 *  RGB to LUV color conversion.
 *
 *  Here is how NPP converts gamma corrected RGB or BGR to CIE LUV using the CIE XYZ D65 white point with a Y luminance of 1.0.
 *  The computed values of the L component are in the range [0..100], U component in the range [-134..220], 
 *  and V component in the range [-140..122]. The code uses cbrtf() the 32 bit floating point cube root math function.
 *
 *  <pre>{@code
 *  // use CIE D65 chromaticity coordinates
 *  #define nCIE_XYZ_D65_xn 0.312713F
 *  #define nCIE_XYZ_D65_yn 0.329016F
 *  #define nn_DIVISOR (-2.0F * nCIE_XYZ_D65_xn + 12.0F * nCIE_XYZ_D65_yn + 3.0F)
 *  #define nun (4.0F * nCIE_XYZ_D65_xn / nn_DIVISOR)
 *  #define nvn (9.0F * nCIE_XYZ_D65_yn / nn_DIVISOR)
 *    
 *  // First convert to XYZ
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nX = 0.412453F * nNormalizedR + 0.35758F  * nNormalizedG + 0.180423F * nNormalizedB; 
 *  Npp32f nY = 0.212671F * nNormalizedR + 0.71516F  * nNormalizedG + 0.072169F * nNormalizedB;
 *  Npp32f nZ = 0.019334F * nNormalizedR + 0.119193F * nNormalizedG + 0.950227F * nNormalizedB;
 *  // Now calculate LUV from the XYZ value
 *  Npp32f nTemp = nX + 15.0F * nY + 3.0F * nZ;
 *  Npp32f nu = 4.0F * nX / nTemp;
 *  Npp32f nv = 9.0F * nY / nTemp;
 *  Npp32f nL = 116.0F * cbrtf(nY) - 16.0F;
 *  if (nL < 0.0F)
 *      nL = 0.0F;
 *  if (nL > 100.0F)
 *      nL = 100.0F;
 *  nTemp = 13.0F * nL;
 *  Npp32f nU = nTemp * (nu - nun);
 *  if (nU < -134.0F)
 *      nU = -134.0F;
 *  if (nU > 220.0F)
 *      nU = 220.0F;
 *  Npp32f nV = nTemp * (nv - nvn);
 *  if (nV < -140.0F)
 *      nV = -140.0F;
 *  if (nV > 122.0F)
 *      nV = 122.0F;
 *  L = (Npp8u)(nL * 255.0F * 0.01F); // / 100.0F
 *  U = (Npp8u)((nU + 134.0F) * 255.0F * 0.0028249F); // / 354.0F
 *  V = (Npp8u)((nV + 140.0F) * 255.0F * 0.0038168F); // / 262.0F
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed LUV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed LUV with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToLUV_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoluv */

/** \defgroup luvtorgb LUVToRGB 
 *  LUV to RGB color conversion.
 *
 *  Here is how NPP converts CIE LUV to gamma corrected RGB or BGR using the CIE XYZ D65 white point with a Y luminance of 1.0.
 *  The code uses powf() the 32 bit floating point power math function. 
 *
 *  <pre>{@code
 *  // use CIE D65 chromaticity coordinates
 *  #define nCIE_XYZ_D65_xn 0.312713F
 *  #define nCIE_XYZ_D65_yn 0.329016F
 *  #define nn_DIVISOR (-2.0F * nCIE_XYZ_D65_xn + 12.0F * nCIE_XYZ_D65_yn + 3.0F)
 *  #define nun (4.0F * nCIE_XYZ_D65_xn / nn_DIVISOR)
 *  #define nvn (9.0F * nCIE_XYZ_D65_yn / nn_DIVISOR)
 *    
 *  // First convert normalized LUV back to original CIE LUV range
 *  Npp32f nL = (Npp32f)L * 100.0F * 0.003921569F;  // / 255.0F
 *  Npp32f nU = ((Npp32f)U * 354.0F * 0.003921569F) - 134.0F;
 *  Npp32f nV = ((Npp32f)V * 262.0F * 0.003921569F) - 140.0F;
 *  // Now convert LUV to CIE XYZ
 *  Npp32f nTemp = 13.0F * nL;
 *  Npp32f nu = nU / nTemp + nun;
 *  Npp32f nv = nV / nTemp + nvn;
 *  Npp32f nNormalizedY;
 *  if (nL > 7.9996248F)
 *  {
 *      nNormalizedY = (nL + 16.0F) * 0.008621F; // / 116.0F
 *      nNormalizedY = powf(nNormalizedY, 3.0F);
 *  }
 *  else
 *  {    
 *      nNormalizedY = nL * 0.001107F; // / 903.3F
 *  }    
 *  Npp32f nNormalizedX = (-9.0F * nNormalizedY * nu) / ((nu - 4.0F) * nv - nu * nv);
 *  Npp32f nNormalizedZ = (9.0F * nNormalizedY - 15.0F * nv * nNormalizedY - nv * nNormalizedX) / (3.0F * nv);
 *  Npp32f nR = 3.240479F * nNormalizedX - 1.53715F  * nNormalizedY - 0.498535F * nNormalizedZ; 
 *  if (nR > 1.0F)
 *      nR = 1.0F;
 *  if (nR < 0.0F)
 *      nR = 0.0F;
 *  Npp32f nG = -0.969256F * nNormalizedX + 1.875991F  * nNormalizedY + 0.041556F * nNormalizedZ;
 *  if (nG > 1.0F)
 *      nG = 1.0F;
 *  if (nG < 0.0F)
 *      nG = 0.0F;
 *  Npp32f nB = 0.055648F * nNormalizedX - 0.204043F * nNormalizedY + 1.057311F * nNormalizedZ;
 *  if (nB > 1.0F)
 *      nB = 1.0F;
 *  if (nB < 0.0F)
 *      nB = 0.0F;
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed LUV to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed LUV with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLUVToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} luvtorgb */

/** \defgroup bgrtolab BGRToLab 
 *  BGR to Lab color conversion.
 *
 *  This is how NPP converts gamma corrected BGR or RGB to Lab using the CIE Lab D65 white point with a Y luminance of 1.0.
 *  The computed values of the L component are in the range [0..100], a and b component values are in the range [-128..127].
 *  The code uses cbrtf() the 32 bit floating point cube root math function.
 *
 *  <pre>{@code
 *  // use CIE Lab chromaticity coordinates
 *  #define nCIE_LAB_D65_xn 0.950455F
 *  #define nCIE_LAB_D65_yn 1.0F
 *  #define nCIE_LAB_D65_zn 1.088753F
 *  // First convert to XYZ
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nX = 0.412453F * nNormalizedR + 0.35758F  * nNormalizedG + 0.180423F * nNormalizedB; 
 *  Npp32f nY = 0.212671F * nNormalizedR + 0.71516F  * nNormalizedG + 0.072169F * nNormalizedB;
 *  Npp32f nZ = 0.019334F * nNormalizedR + 0.119193F * nNormalizedG + 0.950227F * nNormalizedB;
 *  Npp32f nL = cbrtf(nY);
 *  Npp32f nA; Npp32f nB; Npp32f nfX = nX * 1.052128F; // / nCIE_LAB_D65_xn; Npp32f nfY = nY; Npp32f nfZ = nZ * 0.918482F; // /
 *  nCIE_LAB_D65_zn; nfY = nL - 16.0F; nL = 116.0F * nL - 16.0F; nA = cbrtf(nfX) - 16.0F; nA = 500.0F
 *  * (nA - nfY); nB = cbrtf(nfZ) - 16.0F; nB = 200.0F * (nfY - nB); // Now scale Lab range nL = nL * 255.0F
 *  * 0.01F; // / 100.0F nA = nA + 128.0F; nB = nB + 128.0F; L = (Npp8u)nL; a = (Npp8u)nA; b = (Npp8u)nB;
 *  }</pre>
 * 
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned packed Lab color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToLab_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtolab */

/** \defgroup labtobgr LabToBGR 
 *  Lab to BGR color conversion.
 *
 *  This is how NPP converts Lab to gamma corrected BGR or RGB using the CIE Lab D65 white point with a Y luminance of 1.0.
 *  The code uses powf() the 32 bit floating point power math function. 
 *
 *  <pre>{@code
 *  // use CIE Lab chromaticity coordinates
 *  #define nCIE_LAB_D65_xn 0.950455F
 *  #define nCIE_LAB_D65_yn 1.0F
 *  #define nCIE_LAB_D65_zn 1.088753F
 *  // First convert Lab back to original range then to CIE XYZ
 *  Npp32f nL = (Npp32f)L * 100.0F * 0.003921569F;  // / 255.0F
 *  Npp32f nA = (Npp32f)a - 128.0F;
 *  Npp32f nB = (Npp32f)b - 128.0F;
 *  Npp32f nP = (nL + 16.0F) * 0.008621F; // / 116.0F
 *  Npp32f nNormalizedY = nP * nP * nP; // powf(nP, 3.0F);
 *  Npp32f nNormalizedX = nCIE_LAB_D65_xn * powf((nP + nA * 0.002F), 3.0F); // / 500.0F
 *  Npp32f nNormalizedZ = nCIE_LAB_D65_zn * powf((nP - nB * 0.005F), 3.0F); // / 200.0F
 *  Npp32f nR = 3.240479F * nNormalizedX - 1.53715F  * nNormalizedY - 0.498535F * nNormalizedZ; 
 *  if (nR > 1.0F)
 *      nR = 1.0F;
 *  Npp32f nG = -0.969256F * nNormalizedX + 1.875991F  * nNormalizedY + 0.041556F * nNormalizedZ;
 *  if (nG > 1.0F)
 *      nG = 1.0F;
 *  nB = 0.055648F * nNormalizedX - 0.204043F * nNormalizedY + 1.057311F * nNormalizedZ;
 *  if (nB > 1.0F)
 *      nB = 1.0F;
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed Lab to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiLabToBGR_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} labtobgr */

/** \defgroup rgbtoycc RGBToYCC 
 *  RGB to PhotoYCC color conversion.
 *
 *  This is how NPP converts gamma corrected BGR or RGB to PhotoYCC.
 *  The computed Y, C1, C2 values are then quantized and converted to fit in the range [0..1] before expanding to 8 bits.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nY = 0.299F * nNormalizedR + 0.587F  * nNormalizedG + 0.114F * nNormalizedB; 
 *  Npp32f nC1 = nNormalizedB - nY;
 *  nC1 = 111.4F * 0.003921569F * nC1 + 156.0F * 0.003921569F;
 *  Npp32f nC2 = nNormalizedR - nY;
 *  nC2 = 135.64F * 0.003921569F * nC2 + 137.0F * 0.003921569F;
 *  nY = 1.0F * 0.713267F * nY; // / 1.402F
 *  Y = (Npp8u)(nY  * 255.0F);
 *  C1 = (Npp8u)(nC1 * 255.0F);
 *  C2 = (Npp8u)(nC2 * 255.0F);
 *  }</pre>
 * 
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed YCC color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed YCC with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCC_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtoycc */

/** \defgroup ycctorgb YCCToRGB 
 *  PhotoYCC to RGB color conversion.
 *
 *  This is how NPP converts PhotoYCC to gamma corrected RGB or BGR.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedY  = ((Npp32f)Y * 0.003921569F) * 1.3584F;  // / 255.0F
 *  Npp32f nNormalizedC1 = (((Npp32f)C1 * 0.003921569F) - 156.0F * 0.003921569F) * 2.2179F;
 *  Npp32f nNormalizedC2 = (((Npp32f)C2 * 0.003921569F) - 137.0F * 0.003921569F) * 1.8215F;
 *  Npp32f nR = nNormalizedY + nNormalizedC2;
 *  if (nR > 1.0F)
 *      nR = 1.0F;
 *  Npp32f nG = nNormalizedY - 0.194F  * nNormalizedC1 - 0.509F * nNormalizedC2;
 *  if (nG > 1.0F)
 *      nG = 1.0F;
 *  Npp32f nB = nNormalizedY + nNormalizedC1;
 *  if (nB > 1.0F)
 *      nB = 1.0F;
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed YCC to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed YCC with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCCToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} ycctorgb */

/** \defgroup rgbtohls RGBToHLS 
 *  RGB to HLS color conversion.
 *
 *  This is how NPP converts gamma corrected RGB or BGR to HLS.
 *  This code uses the fmaxf() and fminf() 32 bit floating point math functions.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F;  // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nS;
 *  Npp32f nH;
 *  // Lightness
 *  Npp32f nMax = fmaxf(nNormalizedR, nNormalizedG);
 *         nMax = fmaxf(nMax, nNormalizedB);
 *  Npp32f nMin = fminf(nNormalizedR, nNormalizedG);
 *         nMin = fminf(nMin, nNormalizedB);
 *  Npp32f nL = (nMax + nMin) * 0.5F;
 *  Npp32f nDivisor = nMax - nMin;
 *  // Saturation
 *  if (nDivisor == 0.0F) // achromatics case
 *  {
 *      nS = 0.0F;
 *      nH = 0.0F;
 *  }
 *  else // chromatics case
 *  {
 *      if (nL > 0.5F)
 *          nS = nDivisor / (1.0F - (nMax + nMin - 1.0F));
 *      else
 *          nS = nDivisor / (nMax + nMin);
 *  }
 *  // Hue
 *  Npp32f nCr = (nMax - nNormalizedR) / nDivisor;
 *  Npp32f nCg = (nMax - nNormalizedG) / nDivisor;
 *  Npp32f nCb = (nMax - nNormalizedB) / nDivisor;
 *  if (nNormalizedR == nMax)
 *      nH = nCb - nCg;
 *  else if (nNormalizedG == nMax)
 *      nH = 2.0F + nCr - nCb;
 *  else if (nNormalizedB == nMax)
 *      nH = 4.0F + nCg - nCr;
 *  nH = nH * 0.166667F; // / 6.0F       
 *  if (nH < 0.0F)
 *      nH = nH + 1.0F;
 *  H = (Npp8u)(nH * 255.0F);
 *  L = (Npp8u)(nL * 255.0F);
 *  S = (Npp8u)(nS * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed HLS color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed HLS with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHLS_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtohls */

/** \defgroup hlstorgb HLSToRGB 
 *  HLS to RGB color conversion.
 *
 *  This is how NPP converts HLS to gamma corrected RGB or BGR.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedH = (Npp32f)H * 0.003921569F;  // / 255.0F
 *  Npp32f nNormalizedL = (Npp32f)L * 0.003921569F;
 *  Npp32f nNormalizedS = (Npp32f)S * 0.003921569F;
 *  Npp32f nM1;
 *  Npp32f nM2;
 *  Npp32f nR;
 *  Npp32f nG;
 *  Npp32f nB;
 *  Npp32f nh = 0.0F;
 *  if (nNormalizedL <= 0.5F)
 *      nM2 = nNormalizedL * (1.0F + nNormalizedS);
 *  else
 *      nM2 = nNormalizedL + nNormalizedS - nNormalizedL * nNormalizedS;
 *  nM1 = 2.0F * nNormalizedL - nM2;
 *  if (nNormalizedS == 0.0F)
 *      nR = nG = nB = nNormalizedL;
 *  else
 *  {
 *      nh = nNormalizedH + 0.3333F;
 *      if (nh > 1.0F)
 *          nh -= 1.0F;
 *  }
 *  Npp32f nMDiff = nM2 - nM1;
 *  if (0.6667F < nh)
 *      nR = nM1;
 *  else
 *  {    
 *      if (nh < 0.1667F)
 *          nR = (nM1 + nMDiff * nh * 6.0F); // / 0.1667F
 *      else if (nh < 0.5F)
 *          nR = nM2;
 *      else
 *          nR = nM1 + nMDiff * ( 0.6667F - nh ) * 6.0F; // / 0.1667F
 *  }
 *  if (nR > 1.0F)
 *      nR = 1.0F;     
 *  nh = nNormalizedH;
 *  if (0.6667F < nh)
 *      nG = nM1;
 *  else
 *  {
 *      if (nh < 0.1667F)
 *          nG = (nM1 + nMDiff * nh * 6.0F); // / 0.1667F
 *      else if (nh < 0.5F)
 *          nG = nM2;
 *      else
 *          nG = nM1 + nMDiff * (0.6667F - nh ) * 6.0F; // / 0.1667F
 *  }
 *  if (nG > 1.0F)
 *      nG = 1.0F;     
 *  nh = nNormalizedH - 0.3333F;
 *  if (nh < 0.0F)
 *      nh += 1.0F;
 *  if (0.6667F < nh)
 *      nB = nM1;
 *  else
 *  {
 *      if (nh < 0.1667F)
 *          nB = (nM1 + nMDiff * nh * 6.0F); // / 0.1667F
 *      else if (nh < 0.5F)
 *          nB = nM2;
 *      else
 *          nB = nM1 + nMDiff * (0.6667F - nh ) * 6.0F; // / 0.1667F
 *  }        
 *  if (nB > 1.0F)
 *      nB = 1.0F;     
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed HLS to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed HLS with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} hlstorgb */

/** \defgroup bgrtohls BGRToHLS 
 *  BGR to HLS color conversion.
 * \{
 */
/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 4 channel 8-bit unsigned packed HLS with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar HLS color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed BGR with alpha to 4 channel 8-bit unsigned planar HLS with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AC4P4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned packed HLS color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned planar BGR with alpha to 4 channel 8-bit unsigned packed HLS with alpha color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar HLS color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned planar BGR with alpha to 4 channel 8-bit unsigned planar HLS with alpha color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToHLS_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} bgrtohls */

/** \defgroup hlstobgr HLSToBGR 
 *  HLS to BGR color conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed HLS to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed HLS with alpha to 4 channel 8-bit unsigned planar BGR with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AC4P4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar HLS to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned planar HLS with alpha to 4 channel 8-bit unsigned planar BGR with alpha color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar HLS to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned planar HLS with alpha to 4 channel 8-bit unsigned packed BGR with alpha color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHLSToBGR_8u_AP4C4R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} hlstobgr */

/** \defgroup rgbtohsv RGBToHSV 
 *  RGB to HSV color conversion.
 *
 *  This is how NPP converts gamma corrected RGB or BGR to HSV.
 *  This code uses the fmaxf() and fminf() 32 bit floating point math functions.
 *
 * <pre>{@code
 *  Npp32f nNormalizedR = (Npp32f)R * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedG = (Npp32f)G * 0.003921569F;
 *  Npp32f nNormalizedB = (Npp32f)B * 0.003921569F;
 *  Npp32f nS;
 *  Npp32f nH;
 *  // Value
 *  Npp32f nV = fmaxf(nNormalizedR, nNormalizedG);
 *         nV = fmaxf(nV, nNormalizedB);
 *  // Saturation
 *  Npp32f nTemp = fminf(nNormalizedR, nNormalizedG);
 *         nTemp = fminf(nTemp, nNormalizedB);
 *  Npp32f nDivisor = nV - nTemp;
 *  if (nV == 0.0F) // achromatics case
 *  {
 *      nS = 0.0F;
 *      nH = 0.0F;
 *  }    
 *  else // chromatics case
 *      nS = nDivisor / nV;
 *  // Hue:
 *  Npp32f nCr = (nV - nNormalizedR) / nDivisor;
 *  Npp32f nCg = (nV - nNormalizedG) / nDivisor;
 *  Npp32f nCb = (nV - nNormalizedB) / nDivisor;
 *  if (nNormalizedR == nV)
 *      nH = nCb - nCg;
 *  else if (nNormalizedG == nV)
 *      nH = 2.0F + nCr - nCb;
 *  else if (nNormalizedB == nV)
 *      nH = 4.0F + nCg - nCr;
 *  nH = nH * 0.166667F; // / 6.0F       
 *  if (nH < 0.0F)
 *      nH = nH + 1.0F;
 *  H = (Npp8u)(nH * 255.0F);
 *  S = (Npp8u)(nS * 255.0F);
 *  V = (Npp8u)(nV * 255.0F);
 * }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned packed HSV color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 4 channel 8-bit unsigned packed HSV with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToHSV_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} rgbtohsv */

/** \defgroup hsvtorgb HSVToRGB 
 *  HSV to RGB color conversion.
 *
 *  This is how NPP converts HSV to gamma corrected RGB or BGR.
 *  This code uses the floorf() 32 bit floating point math function.
 *
 *  <pre>{@code
 *  Npp32f nNormalizedH = (Npp32f)H * 0.003921569F; // / 255.0F
 *  Npp32f nNormalizedS = (Npp32f)S * 0.003921569F;
 *  Npp32f nNormalizedV = (Npp32f)V * 0.003921569F;
 *  Npp32f nR;
 *  Npp32f nG;
 *  Npp32f nB;
 *  if (nNormalizedS == 0.0F)
 *  {
 *      nR = nG = nB = nNormalizedV;
 *  }
 *  else
 *  {
 *      if (nNormalizedH == 1.0F)
 *          nNormalizedH = 0.0F;
 *      else
 *          nNormalizedH = nNormalizedH * 6.0F; // / 0.1667F
 *  }
 *  Npp32f nI = floorf(nNormalizedH);
 *  Npp32f nF = nNormalizedH - nI;
 *  Npp32f nM = nNormalizedV * (1.0F - nNormalizedS);
 *  Npp32f nN = nNormalizedV * (1.0F - nNormalizedS * nF);
 *  Npp32f nK = nNormalizedV * (1.0F - nNormalizedS * (1.0F - nF));
 *  if (nI == 0.0F)
 *      { nR = nNormalizedV; nG = nK; nB = nM; }
 *  else if (nI == 1.0F)
 *      { nR = nN; nG = nNormalizedV; nB = nM; }
 *  else if (nI == 2.0F)
 *      { nR = nM; nG = nNormalizedV; nB = nK; }
 *  else if (nI == 3.0F)
 *      { nR = nM; nG = nN; nB = nNormalizedV; }
 *  else if (nI == 4.0F)
 *      { nR = nK; nG = nM; nB = nNormalizedV; }
 *  else if (nI == 5.0F)
 *      { nR = nNormalizedV; nG = nM; nB = nN; }
 *  R = (Npp8u)(nR * 255.0F);
 *  G = (Npp8u)(nG * 255.0F);
 *  B = (Npp8u)(nB * 255.0F);
 *  }</pre>
 *
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed HSV to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed HSV with alpha to 4 channel 8-bit unsigned packed RGB with alpha color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiHSVToRGB_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} hsvtorgb */

/** \defgroup image_JPEG_color_conversion JPEG Color Conversion
 * The set of JPEG color conversion functions available in the library.
 * \{
 *
 */

/** \name RGBToYCbCr_JPEG Planar to planar.
 *  JPEG RGB to YCbCr color conversion.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar RGB to 3 channel 8-bit unsigned planar YCbCr444 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar BGR to 3 channel 8-bit unsigned planar YCbCr444 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr444 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr444 to 3 channel 8-bit unsigned planar BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name RGBToYCbCr_JPEG Planar to packed.
 *  JPEG RGB to YCbCr color conversion.
 *
 * \{
 *
 */


/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed RGB to 3 channel 8-bit unsigned planar YCbCr444 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr420 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr420_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr422 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr422_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr411 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr411_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed BGR to 3 channel 8-bit unsigned planar YCbCr444 color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiBGRToYCbCr444_JPEG_8u_C3P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed YCbCr420 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed YCbCr411 to 3 channel 8-bit unsigned planar RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr444 to 3 channel 8-bit unsigned packed RGB color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToRGB_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param aSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer aSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer aSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] aSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr444 to 3 channel 8-bit unsigned packed BGR color conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr444ToBGR_JPEG_8u_P3C3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \} image_JPEG_color_conversion */

/** \} image_color_model_conversion */ 

/** \defgroup image_color_to_gray ColorToGray Conversion
 * Routines for converting color images to grayscale.
 *
 * \{ 
 *
 */

/** \name RGBToGray 
 *  RGB to CCIR601 Gray conversion.
 *
 *  Here is how NPP converts gamma corrected RGB to CCIR601 Gray.
 *
 *  <pre>{@code   
 *   nGray =  0.299F * R + 0.587F * G + 0.114F * B; 
 *  }</pre>
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 1 channel 8-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_C3C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 1 channel 8-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_8u_AC4C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 16-bit unsigned packed RGB to 1 channel 16-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_C3C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 16-bit unsigned packed RGB with alpha to 1 channel 16-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16u_AC4C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 16-bit signed packed RGB to 1 channel 16-bit signed packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_C3C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 16-bit signed packed RGB with alpha to 1 channel 16-bit signed packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_16s_AC4C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 32-bit floating point packed RGB to 1 channel 32-bit floating point packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_C3C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 32-bit floating point packed RGB with alpha to 1 channel 32-bit floating point packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiRGBToGray_32f_AC4C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name ColorToGray 
 *  RGB Color to Gray conversion using user supplied conversion coefficients.
 *
 *  Here is how NPP converts gamma corrected RGB Color to Gray using user supplied conversion coefficients.
 *
 *  <pre>{@code   
 *   nGray =  aCoeffs[0] * R + aCoeffs[1] * G + aCoeffs[2] * B;
 *  }</pre>
 *
 *  For the C4C1R versions of the functions the calculations are as follows.  
 *  For BGRA or other formats with alpha just rearrange the coefficients accordingly.
 *
 *  <pre>{@code   
 *   nGray =  aCoeffs[0] * R + aCoeffs[1] * G + aCoeffs[2] * B + aCoeffs[3] * A;
 *  }</pre>
 *
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 1 channel 8-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C3C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 8-bit unsigned packed RGB with alpha to 1 channel 8-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_AC4C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 8-bit unsigned packed RGBA to 1 channel 8-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_8u_C4C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 3 channel 16-bit unsigned packed RGB to 1 channel 16-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C3C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 16-bit unsigned packed RGB with alpha to 1 channel 16-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_AC4C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 16-bit unsigned packed RGBA to 1 channel 16-bit unsigned packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16u_C4C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 3 channel 16-bit signed packed RGB to 1 channel 16-bit signed packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C3C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 16-bit signed packed RGB with alpha to 1 channel 16-bit signed packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_AC4C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 16-bit signed packed RGBA to 1 channel 16-bit signed packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_16s_C4C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 3 channel 32-bit floating point packed RGB to 1 channel 32-bit floating point packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C3C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 32-bit floating point packed RGB with alpha to 1 channel 32-bit floating point packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_AC4C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/**
 * 4 channel 32-bit floating point packed RGBA to 1 channel 32-bit floating point packed Gray conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aCoeffs fixed size array of constant floating point conversion coefficient values, one per color channel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatPointer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") FloatBuffer aCoeffs);
public static native @Cast("NppStatus") int nppiColorToGray_32f_C4C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("const Npp32f*") float[] aCoeffs);

/** \} */

/** \name GradientColorToGray 
 *  RGB Color to Gray Gradient conversion using user selected gradient distance method.
 *
 * \{
 *
 */

/**
 * 3 channel 8-bit unsigned packed RGB to 1 channel 8-bit unsigned packed Gray Gradient conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eNorm Gradient distance method to use.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_8u_C3C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);

/**
 * 3 channel 16-bit unsigned packed RGB to 1 channel 16-bit unsigned packed Gray Gradient conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eNorm Gradient distance method to use.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16u_C3C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);

/**
 * 3 channel 16-bit signed packed RGB to 1 channel 16-bit signed packed Gray Gradient conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eNorm Gradient distance method to use.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_16s_C3C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);

/**
 * 3 channel 32-bit floating point packed RGB to 1 channel 32-bit floating point packed Gray Gradient conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param eNorm Gradient distance method to use.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);
public static native @Cast("NppStatus") int nppiGradientColorToGray_32f_C3C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("NppiNorm") int eNorm);

/** \} */

/** \} image_color_to_gray */

/** \defgroup image_color_debayer ColorDebayer 
 *  Grayscale Color Filter Array to RGB Color Debayer conversion. 
 *
 *  Generates one RGB color pixel for every grayscale source pixel.
 *  Source and destination images must have even width and height.  Missing pixel colors are generated using bilinear interpolation
 *  with chroma correlation of generated green values (eInterpolation MUST be set to 0). eGrid allows the user to specify the Bayer grid 
 *  registration position at source image location oSrcROI.x, oSrcROI.y relative to pSrc. Possible registration positions are:
 *
 *  <pre>{@code
 *  NPPI_BAYER_BGGR  NPPI_BAYER_RGGB  NPPI_BAYER_GBRG  NPPI_BAYER_GRBG
 *
 *        B G              R G              G B              G R
 *        G R              G B              R G              B G
 *
 *  }</pre>
 *
 *  If it becomes necessary to access source pixels outside source image then the source image borders are mirrored.
 *
 *  Here is how the algorithm works.  R, G, and B base pixels from the source image are used unmodified.  To generate R values for those
 *  G pixels, the average of R(x - 1, y) and R(x + 1, y) or R(x, y - 1) and R(x, y + 1) is used depending on whether the left and right
 *  or top and bottom pixels are R base pixels.  To generate B values for those G pixels, the same algorithm is used using nearest B values.
 *  For an R base pixel, if there are no B values in the upper, lower, left, or right adjacent pixels then B is the average of B values
 *  in the 4 diagonal (G base) pixels.  The same algorithm is used using R values to generate the R value of a B base pixel. 
 *  Chroma correlation is applied to generated G values only, for a B base pixel G(x - 1, y) and G(x + 1, y) are averaged or G(x, y - 1)
 *  and G(x, y + 1) are averaged depending on whether the absolute difference between B(x, y) and the average of B(x - 2, y) and B(x + 2, y)
 *  is smaller than the absolute difference between B(x, y) and the average of B(x, y - 2) and B(x, y + 2). For an R base pixel the same
 *  algorithm is used testing against the surrounding R values at those offsets.  If the horizontal and vertical differences are the same
 *  at one of those pixels then the average of the four left, right, upper and lower G values is used instead.
 *  
 *
 * \{
 *
 */

/**
 * 1 channel 8-bit unsigned packed CFA grayscale Bayer pattern to 3 channel 8-bit unsigned packed RGB conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize full source image width and height relative to pSrc.
 * @param oSrcROI rectangle specifying starting source image pixel x and y location relative to pSrc and ROI width and height. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param eGrid enumeration value specifying bayer grid registration position at location oSrcROI.x, oSrcROI.y relative to pSrc.
 * @param eInterpolation MUST be NPPI_INTER_UNDEFINED
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                @Cast("Npp8u*") BytePointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                @Cast("Npp8u*") byte[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                            @Cast("Npp8u*") BytePointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);
public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                            @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);
public static native @Cast("NppStatus") int nppiCFAToRGB_8u_C1C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                            @Cast("Npp8u*") byte[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);

/**
 * 1 channel 8-bit unsigned packed CFA grayscale Bayer pattern to 4 channel 8-bit unsigned packed RGB conversion with alpha.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize full source image width and height relative to pSrc.
 * @param oSrcROI rectangle specifying starting source image pixel x and y location relative to pSrc and ROI width and height. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param eGrid enumeration value specifying bayer grid registration position at location oSrcROI.x, oSrcROI.y relative to pSrc.
 * @param eInterpolation MUST be NPPI_INTER_UNDEFINED
 * @param nAlpha constant alpha value to be written to each destination pixel
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                  @Cast("Npp8u*") BytePointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                  @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                  @Cast("Npp8u*") byte[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                              @Cast("Npp8u*") BytePointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha);
public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                              @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha);
public static native @Cast("NppStatus") int nppiCFAToRGBA_8u_C1AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                              @Cast("Npp8u*") byte[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp8u") byte nAlpha);

/**
 * 1 channel 16-bit unsigned packed CFA grayscale Bayer pattern to 3 channel 16-bit unsigned packed RGB conversion.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize full source image width and height relative to pSrc.
 * @param oSrcROI rectangle specifying starting source image pixel x and y location relative to pSrc and ROI width and height. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param eGrid enumeration value specifying bayer grid registration position at location oSrcROI.x, oSrcROI.y relative to pSrc.
 * @param eInterpolation MUST be NPPI_INTER_UNDEFINED
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                 @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                 @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                 @Cast("Npp16u*") short[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                             @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);
public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                             @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);
public static native @Cast("NppStatus") int nppiCFAToRGB_16u_C1C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                             @Cast("Npp16u*") short[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation);

/**
 * 1 channel 16-bit unsigned packed CFA grayscale Bayer pattern to 4 channel 16-bit unsigned packed RGB conversion with alpha.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize full source image width and height relative to pSrc.
 * @param oSrcROI rectangle specifying starting source image pixel x and y location relative to pSrc and ROI width and height. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param eGrid enumeration value specifying bayer grid registration position at location oSrcROI.x, oSrcROI.y relative to pSrc.
 * @param eInterpolation MUST be NPPI_INTER_UNDEFINED
 * @param nAlpha constant alpha value to be written to each destination pixel
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                   @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                   @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                                   @Cast("Npp16u*") short[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                               @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha);
public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                               @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha);
public static native @Cast("NppStatus") int nppiCFAToRGBA_16u_C1AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiRect oSrcROI, 
                               @Cast("Npp16u*") short[] pDst, int nDstStep, @Cast("NppiBayerGridPosition") int eGrid, @Cast("NppiInterpolationMode") int eInterpolation, @Cast("Npp16u") short nAlpha);

/** \} image_color_debayer */


/** \defgroup image_color_sampling_format_conversion Color Sampling Format Conversion
 *
 * Routines for converting between various image color sampling formats.
 *
 *
 * \{                                         
 */

/** \name YCbCr420ToYCbCr411 
 *  YCbCr420 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 2 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr411_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToYCbCr422 
 *  YCbCr422 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToYCrCb422 
 *  YCbCr422 to YCrCb422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 2 channel 8-bit unsigned packed YCrCb422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 2 channel 8-bit unsigned packed YCrCb422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToCbYCr422 
 *  YCbCr422 to CbYCr422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 2 channel 8-bit unsigned packed CbYCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToCbYCr422_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name CbYCr422ToYCbCr411 
 *  CbYCr422 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToYCbCr420 
 *  YCbCr422 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb420ToYCbCr422 
 *  YCrCb420 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToYCrCb420 
 *  YCbCr422 to YCrCb420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar YCrCb420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr422ToYCbCr411 
 *  YCbCr422 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr422 to 2 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed YCbCr422 to 2 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr422ToYCbCr411_8u_C2P2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb422ToYCbCr422 
 *  YCrCb422 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb422ToYCbCr420 
 *  YCrCb422 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb422ToYCbCr411 
 *  YCrCb422 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed YCrCb422 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb422ToYCbCr411_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name CbYCr422ToYCbCr422 
 *  CbYCr422 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr422_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name CbYCr422ToYCbCr420 
 *  CbYCr422 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCbCr420_8u_C2P2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name CbYCr422ToYCrCb420 
 *  CbYCr422 to YCrCb420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned packed CbYCr422 to 3 channel 8-bit unsigned planar YCrCb420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiCbYCr422ToYCrCb420_8u_C2P3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr420ToYCbCr420 
 *  YCbCr420 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*const") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*const") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R(@Cast("const Npp8u*const") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420_8u_P2P3R(@Cast("const Npp8u*const") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);
 
/** \} */

/** \name YCbCr420ToYCbCr422 
 *  YCbCr420 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr420ToCbYCr422 
 *  YCbCr420 to CbYCr422 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 2 channel 8-bit unsigned packed CbYCr422 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToCbYCr422_8u_P2C2R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr420ToYCrCb420 
 *  YCbCr420 to YCrCb420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned planar YCbCr420 to 3 channel 8-bit unsigned planar YCrCb420 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr420ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb420ToCbYCr422 
 *  YCrCb420 to CbYCr422 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 2 channel 8-bit unsigned packed CbYCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToCbYCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb420ToYCbCr420 
 *  YCrCb420 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCrCb420ToYCbCr411 
 *  YCrCb420 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCrCb420 to 2 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCrCb420ToYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr411ToYCbCr411 
 *  YCbCr411 to YCbCr411 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 2 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCbCr411 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr411ToYCbCr422 
 *  YCbCr411 to YCbCr422 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCbCr422 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*const") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R_Ctx(@Cast("const Npp8u*const") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*const") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*const") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2P3R(@Cast("const Npp8u*const") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr411 to 2 channel 8-bit unsigned packed YCbCr422 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr422_8u_P2C2R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr411ToYCrCb422 
 *  YCbCr411 to YCrCb422 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCrCb422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 2 channel 8-bit unsigned packed YCrCb422 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb422_8u_P3C2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr411ToYCbCr420 
 *  YCbCr411 to YCbCr420 sampling format conversion.
 * \{
 */
/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param nDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar YCbCr411 to 2 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 * images.
 *
 * @param pSrc \ref source_planar_image_pointer_array.
 * @param rSrcStep \ref source_planar_image_line_step_array.
 * @param pDstY \ref destination_planar_image_pointer.
 * @param nDstYStep \ref destination_planar_image_line_step.
 * @param pDstCbCr \ref destination_planar_image_pointer.
 * @param nDstCbCrStep \ref destination_planar_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") PointerPointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, IntPointer rSrcStep, @Cast("Npp8u*") BytePointer pDstY, int nDstYStep, @Cast("Npp8u*") BytePointer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, IntBuffer rSrcStep, @Cast("Npp8u*") ByteBuffer pDstY, int nDstYStep, @Cast("Npp8u*") ByteBuffer pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P3P2R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int[] rSrcStep, @Cast("Npp8u*") byte[] pDstY, int nDstYStep, @Cast("Npp8u*") byte[] pDstCbCr, int nDstCbCrStep, @ByVal NppiSize oSizeROI);

/**
 * 2 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCbCr420 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCbCr420_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name YCbCr411ToYCrCb420 
 *  YCbCr411 to YCrCb420 sampling format conversion.
 * \{
 */
/**
 * 2 channel 8-bit unsigned planar YCbCr411 to 3 channel 8-bit unsigned planar YCrCb420 sampling format conversion.
 *
 * @param pSrcY \ref source_planar_image_pointer.
 * @param nSrcYStep \ref source_planar_image_line_step.
 * @param pSrcCbCr \ref source_planar_image_pointer.
 * @param nSrcCbCrStep \ref source_planar_image_line_step.
 * @param pDst \ref destination_planar_image_pointer_array.
 * @param rDstStep \ref destination_planar_image_line_step_array.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R_Ctx(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") BytePointer pSrcY, int nSrcYStep, @Cast("const Npp8u*") BytePointer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") ByteBuffer pSrcY, int nSrcYStep, @Cast("const Npp8u*") ByteBuffer pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer rDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiYCbCr411ToYCrCb420_8u_P2P3R(@Cast("const Npp8u*") byte[] pSrcY, int nSrcYStep, @Cast("const Npp8u*") byte[] pSrcCbCr, int nSrcCbCrStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] rDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name NV12ToYUV420
 *  NV12 to YUV420 color conversion.
 *
 * \{
 *
 */

/**
 *  2 channel 8-bit unsigned planar NV12 to 3 channel 8-bit unsigned planar YUV420 color conversion.
 *
 * @param pSrc \ref source_planar_image_pointer_array (one for Y plane, one for UV plane).
 * @param nSrcStep \ref source_planar_image_line_step_array.
 * @param pDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, IntPointer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, IntBuffer aDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiNV12ToYUV420_8u_P2P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int[] aDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \} image_color_sampling_format_conversion */ 

/** \defgroup image_color_gamma_correction Color Gamma Correction
 *
 * Routines for correcting image color gamma.
 *
 * \{                                         
 *
 */

/** \name GammaFwd 
 *  Forward gamma correction.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed color not in place forward gamma correction.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed color in place forward gamma correction.
 *
 * @param pSrcDst in place packed pixel image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed color with alpha not in place forward gamma correction.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed color with alpha in place forward gamma correction.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar color not in place forward gamma correction.
 *
 * @param pSrc source planar pixel format image pointer array.
 * @param nSrcStep source planar pixel format image line step.
 * @param pDst destination planar pixel format image pointer array.
 * @param nDstStep destination planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar color in place forward gamma correction.
 *
 * @param pSrcDst in place planar pixel format image pointer array.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R_Ctx(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaFwd_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \name GammaInv 
 *  Inverse gamma correction.
 * \{
 */
/**
 * 3 channel 8-bit unsigned packed color not in place inverse gamma correction.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned packed color in place inverse gamma correction.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed color with alpha not in place inverse gamma correction.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 4 channel 8-bit unsigned packed color with alpha in place inverse gamma correction.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar color not in place inverse gamma correction.
 *
 * @param pSrc source planar pixel format image pointer array.
 * @param nSrcStep source planar pixel format image line step.
 * @param pDst destination planar pixel format image pointer array.
 * @param nDstStep destination planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u**") PointerPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u**") @ByPtrPtr byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/**
 * 3 channel 8-bit unsigned planar color in place inverse gamma correction.
 *
 * @param pSrcDst in place planar pixel format image pointer array.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R_Ctx(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiGammaInv_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} */

/** \} image_color_gamma_correction */ 

/** \defgroup image_complement_color_key Complement Color Key
 *
 * Routines for performing complement color key replacement.
 *
 * \{                                         
 *
 */

/** \name CompColorKey 
 *  Complement color key replacement.
 * \{
 */
/**
 * 1 channel 8-bit unsigned packed color complement color key replacement of source image 1 by source image 2.
 *
 * @param pSrc1 source1 packed pixel format image pointer.
 * @param nSrc1Step source1 packed pixel format image line step.
 * @param pSrc2 source2 packed pixel format image pointer.
 * @param nSrc2Step source2 packed pixel format image line step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nColorKeyConst color key constant
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nColorKeyConst);

/**
 * 3 channel 8-bit unsigned packed color complement color key replacement of source image 1 by source image 2.
 *
 * @param pSrc1 source1 packed pixel format image pointer.
 * @param nSrc1Step source1 packed pixel format image line step.
 * @param pSrc2 source2 packed pixel format image pointer.
 * @param nSrc2Step source2 packed pixel format image line step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nColorKeyConst color key constant array
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst);

/**
 * 4 channel 8-bit unsigned packed color complement color key replacement of source image 1 by source image 2.
 *
 * @param pSrc1 source1 packed pixel format image pointer.
 * @param nSrc1Step source1 packed pixel format image line step.
 * @param pSrc2 source2 packed pixel format image pointer.
 * @param nSrc2Step source2 packed pixel format image line step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nColorKeyConst color key constant array
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst);
public static native @Cast("NppStatus") int nppiCompColorKey_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst);

/**
 * 4 channel 8-bit unsigned packed color complement color key replacement of source image 1 by source image 2 with alpha blending.
 *
 * @param pSrc1 source1 packed pixel format image pointer.
 * @param nSrc1Step source1 packed pixel format image line step.
 * @param nAlpha1 source1 image alpha opacity (0 - max channel pixel value).
 * @param pSrc2 source2 packed pixel format image pointer.
 * @param nSrc2Step source2 packed pixel format image line step.
 * @param nAlpha2 source2 image alpha opacity (0 - max channel pixel value).
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nColorKeyConst color key constant array
 * @param nppAlphaOp NppiAlphaOp alpha compositing operation selector  (excluding premul ops).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
											@ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
											@ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
											@ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
										@ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp);
public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
										@ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp);
public static native @Cast("NppStatus") int nppiAlphaCompColorKey_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("Npp8u") byte nAlpha1, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, @Cast("Npp8u") byte nAlpha2, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
										@ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] nColorKeyConst, @Cast("NppiAlphaOp") int nppAlphaOp);

/** \} */

/** \} image_complement_color_key */ 

/** \defgroup image_color_processing Color Processing
 *
 * Routines for performing image color manipulation.
 *
 * \{                                         
 *
 */

/** \defgroup image_color_twist ColorTwist
 *
 * Routines for converting between various image color models using user supplied matrix coefficients.
 *
 * \{ 
 *
 */

/** \name ColorTwist
 * 
 *  Perform color twist pixel processing.  Color twist consists of applying the following formula to each
 *  image pixel using coefficients from the user supplied color twist host matrix array as follows where 
 *  dst[x] and src[x] represent destination pixel and source pixel channel or plane x. The full sized
 *  coefficient matrix should be sent for all pixel channel sizes, the function will process the appropriate
 *  coefficients and channels for the corresponding pixel size.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3]
 *  }</pre>
 *
 * \{
 */

/**
 * 1 channel 8-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 8-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C1IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 8-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 8-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C2IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C3IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit unsigned color twist, with alpha copy.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is copied unmodified from the source pixel to the destination pixel.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit unsigned in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is unmodified.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_C4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit unsigned color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit unsigned in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_AC4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit unsigned color twist with 4x4 matrix and constant vector addition.
 *
 * An input 4x4 color twist matrix with floating-point coefficient values with an additional constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 4 channel 8-bit unsigned in place color twist with 4x4 matrix and an additional constant vector addition.
 *
 * An input 4x4 color twist matrix with floating-point coefficient values with an additional constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR_Ctx(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR_Ctx(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR_Ctx(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR(@Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR(@Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_8u_C4IR(@Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 3 channel 8-bit unsigned planar color twist.
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R_Ctx(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*const*") PointerPointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R_Ctx(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R(@Cast("const Npp8u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8u*const*") PointerPointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_P3R(@Cast("const Npp8u*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8u*const*") @ByPtrPtr byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit unsigned planar in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place planar pixel format image pointer array, one pointer per plane.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R_Ctx(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R_Ctx(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R(@Cast("Npp8u*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8u_IP3R(@Cast("Npp8u*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 8-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 8-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR_Ctx(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR_Ctx(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR_Ctx(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C1IR(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 8-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 8-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR_Ctx(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR_Ctx(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR_Ctx(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C2IR(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR_Ctx(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR_Ctx(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR_Ctx(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C3IR(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit signed color twist, with alpha copy.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is copied unmodified from the source pixel to the destination pixel.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit signed in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is unmodified.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR_Ctx(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR_Ctx(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR_Ctx(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_C4IR(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit signed color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 8-bit signed in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR_Ctx(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR_Ctx(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR_Ctx(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR(@Cast("Npp8s*") BytePointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR(@Cast("Npp8s*") ByteBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_AC4IR(@Cast("Npp8s*") byte[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit signed planar color twist.
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R_Ctx(@Cast("const Npp8s*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8s*const*") PointerPointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R_Ctx(@Cast("const Npp8s*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr BytePointer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R_Ctx(@Cast("const Npp8s*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr ByteBuffer pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R_Ctx(@Cast("const Npp8s*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr byte[] pDst, int nDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R(@Cast("const Npp8s*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp8s*const*") PointerPointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R(@Cast("const Npp8s*const*") @ByPtrPtr BytePointer pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr BytePointer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R(@Cast("const Npp8s*const*") @ByPtrPtr ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr ByteBuffer pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_P3R(@Cast("const Npp8s*const*") @ByPtrPtr byte[] pSrc, int nSrcStep, @Cast("Npp8s*const*") @ByPtrPtr byte[] pDst, int nDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 8-bit signed planar in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place planar pixel format image pointer array, one pointer per plane.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R_Ctx(@Cast("Npp8s*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R_Ctx(@Cast("Npp8s*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R_Ctx(@Cast("Npp8s*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R_Ctx(@Cast("Npp8s*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R(@Cast("Npp8s*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R(@Cast("Npp8s*const*") @ByPtrPtr BytePointer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R(@Cast("Npp8s*const*") @ByPtrPtr ByteBuffer pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_8s_IP3R(@Cast("Npp8s*const*") @ByPtrPtr byte[] pSrcDst, int nSrcDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);


/**
 * 1 channel 16-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 16-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C1IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C2IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit unsigned color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit unsigned in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_C3IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit unsigned color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit unsigned in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR_Ctx(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR_Ctx(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR(@Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR(@Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_AC4IR(@Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit unsigned planar color twist.
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R_Ctx(@Cast("const Npp16u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp16u*const*") PointerPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R_Ctx(@Cast("const Npp16u*const*") @ByPtrPtr ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R_Ctx(@Cast("const Npp16u*const*") @ByPtrPtr ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R_Ctx(@Cast("const Npp16u*const*") @ByPtrPtr short[] pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R(@Cast("const Npp16u*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp16u*const*") PointerPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R(@Cast("const Npp16u*const*") @ByPtrPtr ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R(@Cast("const Npp16u*const*") @ByPtrPtr ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_P3R(@Cast("const Npp16u*const*") @ByPtrPtr short[] pSrc, int nSrcStep, @Cast("Npp16u*const*") @ByPtrPtr short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit unsigned planar in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place planar pixel format image pointer array, one pointer per plane.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R_Ctx(@Cast("Npp16u*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R_Ctx(@Cast("Npp16u*const*") @ByPtrPtr ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R_Ctx(@Cast("Npp16u*const*") @ByPtrPtr ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R_Ctx(@Cast("Npp16u*const*") @ByPtrPtr short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R(@Cast("Npp16u*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R(@Cast("Npp16u*const*") @ByPtrPtr ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R(@Cast("Npp16u*const*") @ByPtrPtr ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16u_IP3R(@Cast("Npp16u*const*") @ByPtrPtr short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 16-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 16-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C1IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C2IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit signed color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit signed in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_C3IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit signed color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit signed in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR_Ctx(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR_Ctx(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR(@Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR(@Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_AC4IR(@Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit signed planar color twist.
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R_Ctx(@Cast("const Npp16s*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp16s*const*") PointerPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R_Ctx(@Cast("const Npp16s*const*") @ByPtrPtr ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr ShortPointer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R_Ctx(@Cast("const Npp16s*const*") @ByPtrPtr ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr ShortBuffer pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R_Ctx(@Cast("const Npp16s*const*") @ByPtrPtr short[] pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr short[] pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R(@Cast("const Npp16s*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp16s*const*") PointerPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R(@Cast("const Npp16s*const*") @ByPtrPtr ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr ShortPointer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R(@Cast("const Npp16s*const*") @ByPtrPtr ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr ShortBuffer pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_P3R(@Cast("const Npp16s*const*") @ByPtrPtr short[] pSrc, int nSrcStep, @Cast("Npp16s*const*") @ByPtrPtr short[] pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit signed planar in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place planar pixel format image pointer array, one pointer per plane.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R_Ctx(@Cast("Npp16s*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R_Ctx(@Cast("Npp16s*const*") @ByPtrPtr ShortPointer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R_Ctx(@Cast("Npp16s*const*") @ByPtrPtr ShortBuffer pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R_Ctx(@Cast("Npp16s*const*") @ByPtrPtr short[] pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R(@Cast("Npp16s*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R(@Cast("Npp16s*const*") @ByPtrPtr ShortPointer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R(@Cast("Npp16s*const*") @ByPtrPtr ShortBuffer pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16s_IP3R(@Cast("Npp16s*const*") @ByPtrPtr short[] pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 16-bit floating point color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 16-bit floating point in place color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C1IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit floating point color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 16-bit floating point in place color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C2IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit floating point color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 16-bit floating point in place color twist.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C3IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit floating point color twist, with alpha copy.
 *
 * An input color twist matrix with 32-bit floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is copied unmodified from the source pixel to the destination pixel.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                              @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                          @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit floating point in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with 32-bit floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not modified.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist32f_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 16-bit floating point color twist with 4x4 matrix and constant vector addition.
 *
 * An input 4x4 color twist matrix with 32-bit floating-point coefficient values with an additional 32-bit floating point constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                               @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 4 channel 16-bit floating point in place color twist with 4x4 matrix and an additional constant vector addition.
 *
 * An input 4x4 color twist matrix with 32-bit floating-point coefficient values with an additional 32-bit floating point constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR_Ctx(Npp16f pSrcDst, int nSrcDstStep, 
                                @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist32fC_16f_C4IR(Npp16f pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 1 channel 32-bit floating point color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 1 channel 32-bit floating point in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C1IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 32-bit floating point color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 2 channel 32-bit floating point in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C2IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 32-bit floating point color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 32-bit floating point in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C3IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 32-bit floating point color twist, with alpha copy.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is copied unmodified from the source pixel to the destination pixel.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 32-bit floating point in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not modified.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_C4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 32-bit floating point color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 32-bit floating point in place color twist, not affecting Alpha.
 *
 * An input color twist matrix with floating-point coefficient values is applied with
 * in ROI.
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_AC4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 4 channel 32-bit floating point color twist with 4x4 matrix and constant vector addition.
 *
 * An input 4x4 color twist matrix with floating-point coefficient values with an additional constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("Npp32f*") float[] pDst, int nDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 4 channel 32-bit floating point in place color twist with 4x4 matrix and an additional constant vector addition.
 *
 * An input 4x4 color twist matrix with floating-point coefficient values with an additional constant vector addition
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aConstants[0]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aConstants[1]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aConstants[2]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aConstants[3]
 *  }</pre>
 *
 * @param pSrcDst in place packed pixel format image pointer.
 * @param nSrcDstStep in place packed pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param aConstants fixed size array of constant values, one per channel..
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR_Ctx(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR_Ctx(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR_Ctx(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                             @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR(@Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatPointer aTwist, @Cast("const Npp32f*") FloatPointer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR(@Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") FloatBuffer aTwist, @Cast("const Npp32f*") FloatBuffer aConstants);
public static native @Cast("NppStatus") int nppiColorTwist_32fC_C4IR(@Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, 
                         @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[4]*/ )[4]") float[] aTwist, @Cast("const Npp32f*") float[] aConstants);

/**
 * 3 channel 32-bit floating point planar color twist.
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R_Ctx(@Cast("const Npp32f*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp32f*const*") PointerPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R_Ctx(@Cast("const Npp32f*const*") @ByPtrPtr FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr FloatPointer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R_Ctx(@Cast("const Npp32f*const*") @ByPtrPtr FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr FloatBuffer pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R_Ctx(@Cast("const Npp32f*const*") @ByPtrPtr float[] pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr float[] pDst, int nDstStep, 
                           @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R(@Cast("const Npp32f*const*") PointerPointer pSrc, int nSrcStep, @Cast("Npp32f*const*") PointerPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R(@Cast("const Npp32f*const*") @ByPtrPtr FloatPointer pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr FloatPointer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R(@Cast("const Npp32f*const*") @ByPtrPtr FloatBuffer pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr FloatBuffer pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_P3R(@Cast("const Npp32f*const*") @ByPtrPtr float[] pSrc, int nSrcStep, @Cast("Npp32f*const*") @ByPtrPtr float[] pDst, int nDstStep, 
                       @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);

/**
 * 3 channel 32-bit floating point planar in place color twist.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI.
 *
 * @param pSrcDst in place planar pixel format image pointer array, one pointer per plane.
 * @param nSrcDstStep in place planar pixel format image line step.
 * @param oSizeROI \ref roi_specification.
 * @param aTwist The color twist matrix with floating-point coefficient values.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R_Ctx(@Cast("Npp32f*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R_Ctx(@Cast("Npp32f*const*") @ByPtrPtr FloatPointer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R_Ctx(@Cast("Npp32f*const*") @ByPtrPtr FloatBuffer pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R_Ctx(@Cast("Npp32f*const*") @ByPtrPtr float[] pSrcDst, int nSrcDstStep, 
                            @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R(@Cast("Npp32f*const*") PointerPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R(@Cast("Npp32f*const*") @ByPtrPtr FloatPointer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatPointer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R(@Cast("Npp32f*const*") @ByPtrPtr FloatBuffer pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") FloatBuffer aTwist);
public static native @Cast("NppStatus") int nppiColorTwist_32f_IP3R(@Cast("Npp32f*const*") @ByPtrPtr float[] pSrcDst, int nSrcDstStep, 
                        @ByVal NppiSize oSizeROI, @Cast("const Npp32f(* /*[3]*/ )[4]") float[] aTwist);
// Targeting ../nppicc/NppiColorTwistBatchCXR.java



/**
 * 1 channel 8-bit unsigned integer color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C1R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C1R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 1 channel 8-bit unsigned integer in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C1IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C1IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 8-bit unsigned integer color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C3R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C3R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 8-bit unsigned integer in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C3IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C3IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer color twist batch, not affecting Alpha.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_AC4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_AC4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer in place color twist batch, not affecting Alpha.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_AC4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_8u_AC4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with floating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_8u_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_8u_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 8-bit unsigned integer in place color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with floating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_8u_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_8u_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 1 channel 32-bit floating point color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C1R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C1R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 1 channel 32-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C1IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C1IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 32-bit floating point color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C3R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C3R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 32-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C3IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C3IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 32-bit floating point color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 32-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 32-bit floating point color twist batch, not affecting Alpha.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_AC4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_AC4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 32-bit floating point in place color twist batch, not affecting Alpha.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_AC4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32f_AC4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 32-bit floating point color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with floating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32fC_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32fC_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel in place 32-bit floating point color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with floating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch_32fC_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch_32fC_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 1 channel 16-bit floating point color twist batch.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C1R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C1R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 1 channel 16-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C1IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C1IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 16-bit floating point color twist batch.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C3R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C3R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 3 channel 16-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C3IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C3IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 16-bit floating point color twist batch.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within the ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 16-bit floating point in place color twist batch.
 * 
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32f_16f_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel 16-bit floating point color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with 32-bit floating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_16f_C4R_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_16f_C4R(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/**
 * 4 channel in place 16-bit floating point color twist with 4x5 matrix including a constant vector (20 coefficients total).
 *
 * An input 4x5 color twist matrix with 32-bitfloating-point coefficient values including a constant (in the fourth column) vector
 * is applied within ROI.  For this particular version of the function the result is generated as shown below.
 *
 *  <pre>{@code
 *      dst[0] = aTwist[0][0] * src[0] + aTwist[0][1] * src[1] + aTwist[0][2] * src[2] + aTwist[0][3] * src[3] + aTwist[0][4]
 *      dst[1] = aTwist[1][0] * src[0] + aTwist[1][1] * src[1] + aTwist[1][2] * src[2] + aTwist[1][3] * src[3] + aTwist[1][4]
 *      dst[2] = aTwist[2][0] * src[0] + aTwist[2][1] * src[1] + aTwist[2][2] * src[2] + aTwist[2][3] * src[3] + aTwist[2][4]
 *      dst[3] = aTwist[3][0] * src[0] + aTwist[3][1] * src[1] + aTwist[3][2] * src[2] + aTwist[3][3] * src[3] + aTwist[3][4]
 *  }</pre>
 *
 * An input color twist matrix with 32-bit floating-point coefficient values is applied
 * within ROI for each image in batch.  Color twist matrix can vary per image. The same ROI is applied to each image.
 *
 * @param nMin Minimum clamp value.
 * @param nMax Maximum saturation and clamp value.
 * @param oSizeROI \ref roi_specification.
 * @param pBatchList Device memory pointer to nBatchSize list of NppiColorTwistBatchCXR structures.
 * @param nBatchSize Number of NppiColorTwistBatchCXR structures in this call (must be > 1).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_16f_C4IR_Ctx(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiColorTwistBatch32fC_16f_C4IR(@Cast("Npp32f") float nMin, @Cast("Npp32f") float nMax, @ByVal NppiSize oSizeROI, NppiColorTwistBatchCXR pBatchList, int nBatchSize);

/** \} color_twist_batch */

/** \} image_color_twist_batch */

/** \defgroup image_color_LUT ColorLUT
 *  Perform image color processing using members of various types of color look up tables.
 * 
 * \{
 */

/**
 * 8-bit unsigned look-up-table color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 8-bit unsigned look-up-table in place color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C1IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C1IR_Ctx(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C1IR_Ctx(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C1IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C1IR(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C1IR(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 3 channel 8-bit unsigned look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 3 channel 8-bit unsigned look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR_Ctx(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR_Ctx(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C3IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C3IR(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 8-bit unsigned look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 4 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
               @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 8-bit unsigned look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 4 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR_Ctx(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR_Ctx(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_C4IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_C4IR(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 8-bit unsigned look-up-table color conversion, not affecting Alpha.
 *
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 8-bit unsigned look-up-table in place color conversion, not affecting Alpha.
 *
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 256.
 */
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR_Ctx(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR_Ctx(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR_Ctx(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR(      @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR(      @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_8u_AC4IR(      @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 16-bit unsigned look-up-table color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 16-bit unsigned look-up-table in place color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C1IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C1IR_Ctx(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C1IR_Ctx(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C1IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C1IR(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C1IR(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 3 channel 16-bit unsigned look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 3 channel 16-bit unsigned look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR_Ctx(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR_Ctx(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C3IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C3IR(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit unsigned look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 4 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit unsigned look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 4 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR_Ctx(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR_Ctx(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_C4IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_C4IR(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit unsigned look-up-table color conversion, not affecting Alpha.
 *
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit unsigned look-up-table in place color conversion, not affecting Alpha.
 *
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 * Alpha channel is the last channel and is not processed.
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR_Ctx(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR_Ctx(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR_Ctx(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR(      @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR(      @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16u_AC4IR(      @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 16-bit signed look-up-table color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 16-bit signed look-up-table in place color conversion.
 *
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Pointer to an array of user defined OUTPUT values (this is a device memory pointer)
 * @param pLevels Pointer to an array of user defined INPUT values  (this is a device memory pointer)
 * @param nLevels Number of user defined number of input/output mapping points (levels)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16s_C1IR_Ctx(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C1IR_Ctx(      @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C1IR_Ctx(      @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16s_C1IR(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") IntPointer pValues, @Cast("const Npp32s*") IntPointer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C1IR(      @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") IntBuffer pValues, @Cast("const Npp32s*") IntBuffer pLevels, int nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C1IR(      @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s*") int[] pValues, @Cast("const Npp32s*") int[] pLevels, int nLevels);

/**
 * 3 channel 16-bit signed look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 3 channel 16-bit signed look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 3 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 3 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR_Ctx(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR_Ctx(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR_Ctx(      @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR_Ctx(      @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16s_C3IR(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR(      @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR(      @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C3IR(      @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, 
                 @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit signed look-up-table color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points with no interpolation. 
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined OUTPUT values.
 * @param pLevels Host pointer to an array of 4 device memory pointers, one per color CHANNEL, pointing to user defined INPUT values.
 * @param nLevels Host pointer to an array of 4 user defined number of input/output mapping points, one per color CHANNEL.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *        - ::NPP_LUT_NUMBER_OF_LEVELS_ERROR if the number of levels is less than 2 or greater than 1024 (the current size limit).
 */
public static native @Cast("NppStatus") int nppiLUT_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiLUT_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") PointerPointer pValues, @Cast("const Npp32s**") PointerPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntPointer pValues, @Cast("const Npp32s**") @ByPtrPtr IntPointer pLevels, IntPointer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr IntBuffer pValues, @Cast("const Npp32s**") @ByPtrPtr IntBuffer pLevels, IntBuffer nLevels);
public static native @Cast("NppStatus") int nppiLUT_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                @Cast("const Npp32s**") @ByPtrPtr int[] pValues, @Cast("const Npp32s**") @ByPtrPtr int[] pLevels, int[] nLevels);

/**
 * 4 channel 16-bit signed look-up-table in place color conversion.
 * 
 * The LUT is derived from a set of user defined mapping points using no interpolation. 
 *
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pValues