// Targeted by JavaCPP version 1.5.3-SNAPSHOT: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.nppicom.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppicom extends org.bytedeco.cuda.presets.nppicom {
    static { Loader.load(); }

// Parsed from <nppi_compression_functions.h>

 /* Copyright 2009-2019 NVIDIA Corporation.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are 
  * subject to NVIDIA intellectual property rights under U.S. and 
  * international Copyright laws. 
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED 
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY 
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_COMPRESSION_FUNCTIONS_H
// #define NV_NPPI_COMPRESSION_FUNCTIONS_H
 
/**
 * \file nppi_compression_functions.h
 * NPP Image Processing Functionality.
 */
 
// #include "nppdefs.h"

// #ifdef __cplusplus
// #endif

/** \defgroup image_compression Compression
 *  \ingroup nppi
 *
 * Image compression primitives.
 *
 * The JPEG standard defines a flow of level shift, DCT and quantization for
 * forward JPEG transform and inverse level shift, IDCT and de-quantization
 * for inverse JPEG transform. This group has the functions for both forward
 * and inverse functions. 
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 *  
 *
 * \{
 *
 * These functions can be found in the nppicom library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 *
 */

/** \defgroup image_quantization Quantization Functions
 * The set of quantization functions available in the library. 
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 *
 * \{
 *
 */

/**
 * Apply quality factor to raw 8-bit quantization table.
 *
 * This is effectively and in-place method that modifies a given raw
 * quantization table based on a quality factor.
 * Note that this method is a host method and that the pointer to the
 * raw quantization table is a host pointer.
 *
 * @param hpQuantRawTable Raw quantization table.
 * @param nQualityFactor Quality factor for the table. Range is [1:100].
 * @return Error code:
 *      ::NPP_NULL_POINTER_ERROR is returned if hpQuantRawTable is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiQuantFwdRawTableInit_JPEG_8u(@Cast("Npp8u*") BytePointer hpQuantRawTable, int nQualityFactor);
public static native @Cast("NppStatus") int nppiQuantFwdRawTableInit_JPEG_8u(@Cast("Npp8u*") ByteBuffer hpQuantRawTable, int nQualityFactor);
public static native @Cast("NppStatus") int nppiQuantFwdRawTableInit_JPEG_8u(@Cast("Npp8u*") byte[] hpQuantRawTable, int nQualityFactor);

/**
 * Initializes a quantization table for nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R().
 *    The method creates a 16-bit version of the raw table and converts the 
 * data order from zigzag layout to original row-order layout since raw
 * quantization tables are typically stored in zigzag format.
 *
 * This method is a host method. It consumes and produces host data. I.e. the pointers
 * passed to this function must be host pointers. The resulting table needs to be
 * transferred to device memory in order to be used with nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R()
 * function.
 *
 * @param hpQuantRawTable Host pointer to raw quantization table as returned by 
 *      nppiQuantFwdRawTableInit_JPEG_8u(). The raw quantization table is assumed to be in
 *      zigzag order.
 * @param hpQuantFwdRawTable Forward quantization table for use with nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R().
 * @return Error code:
 *      ::NPP_NULL_POINTER_ERROR pQuantRawTable is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiQuantFwdTableInit_JPEG_8u16u(@Cast("const Npp8u*") BytePointer hpQuantRawTable, @Cast("Npp16u*") ShortPointer hpQuantFwdRawTable);
public static native @Cast("NppStatus") int nppiQuantFwdTableInit_JPEG_8u16u(@Cast("const Npp8u*") ByteBuffer hpQuantRawTable, @Cast("Npp16u*") ShortBuffer hpQuantFwdRawTable);
public static native @Cast("NppStatus") int nppiQuantFwdTableInit_JPEG_8u16u(@Cast("const Npp8u*") byte[] hpQuantRawTable, @Cast("Npp16u*") short[] hpQuantFwdRawTable);

/**
 * Initializes a quantization table for nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R().
 *      The nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R() method uses a quantization table
 * in a 16-bit format allowing for faster processing. In addition it converts the 
 * data order from zigzag layout to original row-order layout. Typically raw
 * quantization tables are stored in zigzag format.
 *
 * This method is a host method and consumes and produces host data. I.e. the pointers
 * passed to this function must be host pointers. The resulting table needs to be
 * transferred to device memory in order to be used with nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R()
 * function.
 *
 * @param hpQuantRawTable Raw quantization table.
 * @param hpQuantFwdRawTable Inverse quantization table.
 * @return ::NPP_NULL_POINTER_ERROR pQuantRawTable or pQuantFwdRawTable is0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiQuantInvTableInit_JPEG_8u16u(@Cast("const Npp8u*") BytePointer hpQuantRawTable, @Cast("Npp16u*") ShortPointer hpQuantFwdRawTable);
public static native @Cast("NppStatus") int nppiQuantInvTableInit_JPEG_8u16u(@Cast("const Npp8u*") ByteBuffer hpQuantRawTable, @Cast("Npp16u*") ShortBuffer hpQuantFwdRawTable);
public static native @Cast("NppStatus") int nppiQuantInvTableInit_JPEG_8u16u(@Cast("const Npp8u*") byte[] hpQuantRawTable, @Cast("Npp16u*") short[] hpQuantFwdRawTable);


/**
 * Forward DCT, quantization and level shift part of the JPEG encoding.
 * Input is expected in 8x8 macro blocks and output is expected to be in 64x1
 * macro blocks.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param pQuantFwdTable Forward quantization tables for JPEG encoding created
 *          using nppiQuantInvTableInit_JPEG_8u16u().
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @Cast("const Npp16u*") ShortPointer pQuantFwdTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @Cast("const Npp16u*") ShortBuffer pQuantFwdTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @Cast("const Npp16u*") short[] pQuantFwdTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, 
                                          @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                    @Cast("const Npp16u*") ShortPointer pQuantFwdTable, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, 
                                          @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                    @Cast("const Npp16u*") ShortBuffer pQuantFwdTable, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, 
                                          @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                    @Cast("const Npp16u*") short[] pQuantFwdTable, @ByVal NppiSize oSizeROI);

/**
 * Inverse DCT, de-quantization and level shift part of the JPEG decoding.
 * Input is expected in 64x1 macro blocks and output is expected to be in 8x8
 * macro blocks.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pQuantInvTable Inverse quantization tables for JPEG decoding created
 *           using nppiQuantInvTableInit_JPEG_8u16u().
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                        @Cast("const Npp16u*") ShortPointer pQuantInvTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                        @Cast("const Npp16u*") ShortBuffer pQuantInvTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                        @Cast("const Npp16u*") short[] pQuantInvTable, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
   
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, 
                                          @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                    @Cast("const Npp16u*") ShortPointer pQuantInvTable, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, 
                                          @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                    @Cast("const Npp16u*") ShortBuffer pQuantInvTable, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, 
                                          @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                    @Cast("const Npp16u*") short[] pQuantInvTable, @ByVal NppiSize oSizeROI);
// Targeting ../nppicom/NppiDCTState.java


// #else
// #endif


/**
 * Initializes DCT state structure and allocates additional resources.
 *
 * @see nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW(), nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW.
 * 
 * @param ppState Pointer to pointer to DCT state structure. 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 *
 * @return NPP_SUCCESS Indicates no error. Any other value indicates an error
 *         or a warning
 * @return NPP_SIZE_ERROR Indicates an error condition if any image dimension
 *         has zero or negative value
 * @return NPP_NULL_POINTER_ERROR Indicates an error condition if pBufSize
 *         pointer is NULL
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTInitAlloc_Ctx(@Cast("NppiDCTState**") PointerPointer ppState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTInitAlloc_Ctx(@ByPtrPtr NppiDCTState ppState, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDCTInitAlloc(@Cast("NppiDCTState**") PointerPointer ppState);
public static native @Cast("NppStatus") int nppiDCTInitAlloc(@ByPtrPtr NppiDCTState ppState);

/**
 * Frees the additional resources of the DCT state structure.
 *
 * @see nppiDCTInitAlloc
 * 
 * @param pState Pointer to DCT state structure. 
 *
 * @return NPP_SUCCESS Indicates no error. Any other value indicates an error
 *         or a warning
 * @return NPP_SIZE_ERROR Indicates an error condition if any image dimension
 *         has zero or negative value
 * @return NPP_NULL_POINTER_ERROR Indicates an error condition if pState
 *         pointer is NULL
  *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
*/
public static native @Cast("NppStatus") int nppiDCTFree(NppiDCTState pState);

/**
 * Forward DCT, quantization and level shift part of the JPEG encoding.
 * Input is expected in 8x8 macro blocks and output is expected to be in 64x1
 * macro blocks. The new version of the primitive takes the ROI in image pixel size and
 * works with DCT coefficients that are in zig-zag order.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pQuantizationTable Quantization Table in zig-zag order.
 * @param oSizeROI \ref roi_specification.
 * @param pState Pointer to DCT state structure. This structure must be
 *          initialized allocated and initialized using nppiDCTInitAlloc(). 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, 
                                                  @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                            @Cast("const Npp8u*") BytePointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, 
                                                  @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                            @Cast("const Npp8u*") ByteBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, 
                                                  @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                            @Cast("const Npp8u*") byte[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") ShortPointer pDst, int nDstStep, 
                                        @Cast("const Npp8u*") BytePointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, 
                                        @Cast("const Npp8u*") ByteBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuantFwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, 
                                              @Cast("Npp16s*") short[] pDst, int nDstStep, 
                                        @Cast("const Npp8u*") byte[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);

/**
 * Inverse DCT, de-quantization and level shift part of the JPEG decoding.
 * Input is expected in 64x1 macro blocks and output is expected to be in 8x8
 * macro blocks. The new version of the primitive takes the ROI in image pixel size and
 * works with DCT coefficients that are in zig-zag order.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param pQuantizationTable Quantization Table in zig-zag order.
 * @param oSizeROI \ref roi_specification.
 * @param pState Pointer to DCT state structure. This structure must be
 *          initialized allocated and initialized using nppiDCTInitAlloc().  
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, 
                                                  @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                            @Cast("const Npp8u*") BytePointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, 
                                                  @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                            @Cast("const Npp8u*") ByteBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, 
                                                  @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                            @Cast("const Npp8u*") byte[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                            NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
                                    
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") BytePointer pDst, int nDstStep, 
                                        @Cast("const Npp8u*") BytePointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, 
                                        @Cast("const Npp8u*") ByteBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuantInv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, 
                                              @Cast("Npp8u*") byte[] pDst, int nDstStep, 
                                        @Cast("const Npp8u*") byte[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                        NppiDCTState pState);
                                    
/**
 * Forward DCT, quantization and level shift part of the JPEG encoding, 16-bit short integer.
 * Input is expected in 8x8 macro blocks and output is expected to be in 64x1
 * macro blocks. The new version of the primitive takes the ROI in image pixel size and
 * works with DCT coefficients that are in zig-zag order.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pQuantizationTable Quantization Table in zig-zag order.
 * @param oSizeROI \ref roi_specification.
 * @param pState Pointer to DCT state structure. This structure must be
 *          initialized allocated and initialized using nppiDCTInitAlloc(). 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                    @Cast("Npp16s*") ShortPointer pDst, int nDstStep,
                                              @Cast("const Npp16u*") ShortPointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                    @Cast("Npp16s*") ShortBuffer pDst, int nDstStep,
                                              @Cast("const Npp16u*") ShortBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                    @Cast("Npp16s*") short[] pDst, int nDstStep,
                                              @Cast("const Npp16u*") short[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortPointer pDst, int nDstStep,
                                          @Cast("const Npp16u*") ShortPointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep,
                                                @Cast("Npp16s*") ShortBuffer pDst, int nDstStep,
                                          @Cast("const Npp16u*") ShortBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuant16Fwd8x8LS_JPEG_8u16s_C1R_NEW(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep,
                                                @Cast("Npp16s*") short[] pDst, int nDstStep,
                                          @Cast("const Npp16u*") short[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);

/**
 * Inverse DCT, de-quantization and level shift part of the JPEG decoding, 16-bit short integer.
 * Input is expected in 64x1 macro blocks and output is expected to be in 8x8
 * macro blocks. The new version of the primitive takes the ROI in image pixel size and
 * works with DCT coefficients that are in zig-zag order.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep Image width in pixels x 8 x sizeof(Npp16s).
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param pQuantizationTable Quantization Table in zig-zag order.
 * @param oSizeROI \ref roi_specification.
 * @param pState Pointer to DCT state structure. This structure must be
 *          initialized allocated and initialized using nppiDCTInitAlloc().  
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") BytePointer pDst, int nDstStep,
                                              @Cast("const Npp16u*") ShortPointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") ByteBuffer pDst, int nDstStep,
                                              @Cast("const Npp16u*") ShortBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                    @Cast("Npp8u*") byte[] pDst, int nDstStep,
                                              @Cast("const Npp16u*") short[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                              NppiDCTState pState, @ByVal NppStreamContext nppStreamCtx);
                                          
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") BytePointer pDst, int nDstStep,
                                          @Cast("const Npp16u*") ShortPointer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep,
                                                @Cast("Npp8u*") ByteBuffer pDst, int nDstStep,
                                          @Cast("const Npp16u*") ShortBuffer pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);
public static native @Cast("NppStatus") int nppiDCTQuant16Inv8x8LS_JPEG_16s8u_C1R_NEW(@Cast("const Npp16s*") short[] pSrc, int nSrcStep,
                                                @Cast("Npp8u*") byte[] pDst, int nDstStep,
                                          @Cast("const Npp16u*") short[] pQuantizationTable, @ByVal NppiSize oSizeROI,
                                          NppiDCTState pState);
// Targeting ../nppicom/NppiDecodeHuffmanSpec.java


// #else
// #endif

/**
 * Returns the length of the NppiDecodeHuffmanSpec structure.
 * @param pSize Pointer to a variable that will receive the length of the NppiDecodeHuffmanSpec structure.
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecGetBufSize_JPEG(IntPointer pSize);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecGetBufSize_JPEG(IntBuffer pSize);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecGetBufSize_JPEG(int[] pSize);

/**
 * Creates a Huffman table in a format that is suitable for the decoder on the host.
 * @param pRawHuffmanTable Huffman table formated as specified in the JPEG standard.
 * @param eTableType Enum specifying type of table (nppiDCTable or nppiACTable).
 * @param pHuffmanSpec Pointer to the Huffman table for the decoder
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitHost_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiDecodeHuffmanSpec pHuffmanSpec);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitHost_JPEG(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiDecodeHuffmanSpec pHuffmanSpec);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitHost_JPEG(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiDecodeHuffmanSpec pHuffmanSpec);

/**
 * Allocates memory and creates a Huffman table in a format that is suitable for the decoder on the host.
 * @param pRawHuffmanTable Huffman table formated as specified in the JPEG standard.
 * @param eTableType Enum specifying type of table (nppiDCTable or nppiACTable).
 * @param ppHuffmanSpec Pointer to returned pointer to the Huffman table for the decoder
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitAllocHost_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @Cast("NppiDecodeHuffmanSpec**") PointerPointer ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitAllocHost_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiDecodeHuffmanSpec ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitAllocHost_JPEG(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiDecodeHuffmanSpec ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecInitAllocHost_JPEG(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiDecodeHuffmanSpec ppHuffmanSpec);

/**
 * Frees the host memory allocated by nppiDecodeHuffmanSpecInitAllocHost_JPEG.
 * @param pHuffmanSpec Pointer to the Huffman table for the decoder
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiDecodeHuffmanSpecFreeHost_JPEG(NppiDecodeHuffmanSpec pHuffmanSpec);

/**
 * Huffman Decoding of the JPEG decoding on the host.
 * Input is expected in byte stuffed huffman encoded JPEG scan and output is expected to be 64x1 macro blocks.
 *
 * @param pSrc Byte-stuffed huffman encoded JPEG scan.
 * @param nLength Byte length of the input.
 * @param restartInterval Restart Interval, see JPEG standard.
 * @param Ss Start Coefficient, see JPEG standard.
 * @param Se End Coefficient, see JPEG standard.
 * @param Ah Bit Approximation High, see JPEG standard.
 * @param Al Bit Approximation Low, see JPEG standard.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param pHuffmanTableDC DC Huffman table.
 * @param pHuffmanTableAC AC Huffman table.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
 

public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nLength,
                                         @Cast("Npp32s") int restartInterval, @Cast("Npp32s") int Ss, @Cast("Npp32s") int Se, @Cast("Npp32s") int Ah, @Cast("Npp32s") int Al,
                                         @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep,
                                         NppiDecodeHuffmanSpec pHuffmanTableDC, 
                                         NppiDecodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nLength,
                                         @Cast("Npp32s") int restartInterval, @Cast("Npp32s") int Ss, @Cast("Npp32s") int Se, @Cast("Npp32s") int Ah, @Cast("Npp32s") int Al,
                                         @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep,
                                         NppiDecodeHuffmanSpec pHuffmanTableDC, 
                                         NppiDecodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nLength,
                                         @Cast("Npp32s") int restartInterval, @Cast("Npp32s") int Ss, @Cast("Npp32s") int Se, @Cast("Npp32s") int Ah, @Cast("Npp32s") int Al,
                                         @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep,
                                         NppiDecodeHuffmanSpec pHuffmanTableDC, 
                                         NppiDecodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI); 

/**
 * Huffman Decoding of the JPEG decoding on the host.
 * Input is expected in byte stuffed huffman encoded JPEG scan and output is expected to be 64x1 macro blocks.
 *
 * @param pSrc Byte-stuffed huffman encoded JPEG scan.
 * @param nLength Byte length of the input.
 * @param nRestartInterval Restart Interval, see JPEG standard. 
 * @param nSs Start Coefficient, see JPEG standard.
 * @param nSe End Coefficient, see JPEG standard.
 * @param nAh Bit Approximation High, see JPEG standard.
 * @param nAl Bit Approximation Low, see JPEG standard.
 * @param apDst \ref destination_image_pointer.
 * @param aDstStep \ref destination_image_line_step.
 * @param apHuffmanDCTable DC Huffman tables.
 * @param apHuffmanACTable AC Huffman tables.
 * @param aSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
 

 public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nLength,
 				                          @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
 					                      @Cast("Npp16s**") PointerPointer apDst, @Cast("Npp32s*") IntPointer aDstStep,
 					                      @Cast("NppiDecodeHuffmanSpec**") PointerPointer apHuffmanDCTable, 
 					                      @Cast("NppiDecodeHuffmanSpec**") PointerPointer apHuffmanACTable, 
 					                      NppiSize aSizeROI);
 public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nLength,
 				                          @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
 					                      @Cast("Npp16s**") @ByPtrPtr ShortPointer apDst, @Cast("Npp32s*") IntPointer aDstStep,
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanDCTable, 
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanACTable, 
 					                      NppiSize aSizeROI);
 public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nLength,
 				                          @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
 					                      @Cast("Npp16s**") @ByPtrPtr ShortBuffer apDst, @Cast("Npp32s*") IntBuffer aDstStep,
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanDCTable, 
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanACTable, 
 					                      NppiSize aSizeROI);
 public static native @Cast("NppStatus") int nppiDecodeHuffmanScanHost_JPEG_8u16s_P3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nLength,
 				                          @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
 					                      @Cast("Npp16s**") @ByPtrPtr short[] apDst, @Cast("Npp32s*") int[] aDstStep,
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanDCTable, 
 					                      @ByPtrPtr NppiDecodeHuffmanSpec apHuffmanACTable, 
 					                      NppiSize aSizeROI);
// Targeting ../nppicom/NppiEncodeHuffmanSpec.java


// #else
// #endif


/**
 * Returns the length of the NppiEncodeHuffmanSpec structure.
 * @param pSize Pointer to a variable that will receive the length of the NppiEncodeHuffmanSpec structure.
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecGetBufSize_JPEG(IntPointer pSize);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecGetBufSize_JPEG(IntBuffer pSize);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecGetBufSize_JPEG(int[] pSize);

/**
 * Creates a Huffman table in a format that is suitable for the encoder.
 * @param pRawHuffmanTable Huffman table formated as specified in the JPEG standard.
 * @param eTableType Enum specifying type of table (nppiDCTable or nppiACTable).
 * @param pHuffmanSpec Pointer to the Huffman table for the decoder
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG_Ctx(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG_Ctx(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG_Ctx(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInit_JPEG(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, NppiEncodeHuffmanSpec pHuffmanSpec);

/**
 * Allocates memory and creates a Huffman table in a format that is suitable for the encoder.
 * @param pRawHuffmanTable Huffman table formated as specified in the JPEG standard.
 * @param eTableType Enum specifying type of table (nppiDCTable or nppiACTable).
 * @param ppHuffmanSpec Pointer to returned pointer to the Huffman table for the encoder
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_NULL_POINTER_ERROR If one of the pointers is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG_Ctx(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @Cast("NppiEncodeHuffmanSpec**") PointerPointer ppHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG_Ctx(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG_Ctx(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG_Ctx(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @Cast("NppiEncodeHuffmanSpec**") PointerPointer ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG(@Cast("const Npp8u*") BytePointer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG(@Cast("const Npp8u*") ByteBuffer pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec);
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecInitAlloc_JPEG(@Cast("const Npp8u*") byte[] pRawHuffmanTable, @Cast("NppiHuffmanTableType") int eTableType, @ByPtrPtr NppiEncodeHuffmanSpec ppHuffmanSpec);

/**
 * Frees the memory allocated by nppiEncodeHuffmanSpecInitAlloc_JPEG.
 * @param pHuffmanSpec Pointer to the Huffman table for the encoder.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
**/
public static native @Cast("NppStatus") int nppiEncodeHuffmanSpecFree_JPEG(NppiEncodeHuffmanSpec pHuffmanSpec);

/**
 * Huffman Encoding of the JPEG Encoding.
 * Input is expected to be 64x1 macro blocks and output is expected as byte stuffed huffman encoded JPEG scan.
 *
 * @param pSrc \ref destination_image_pointer.
 * @param nSrcStep \ref destination_image_line_step.
 * @param nRestartInterval Restart Interval, see JPEG standard. Currently only values <=0 are supported.
 * @param nSs Start Coefficient, see JPEG standard.
 * @param nSe End Coefficient, see JPEG standard.
 * @param nAh Bit Approximation High, see JPEG standard.
 * @param nAl Bit Approximation Low, see JPEG standard.
 * @param pDst Byte-stuffed huffman encoded JPEG scan.
 * @param nLength Byte length of the huffman encoded JPEG scan.
 * @param pHuffmanTableDC DC Huffman table.
 * @param pHuffmanTableAC AC Huffman table.
 * @param oSizeROI \ref roi_specification.
 * @param pTempStorage Temporary storage.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *         - ::NPP_NOT_SUFFICIENT_COMPUTE_CAPABILITY If the device has compute capability < 2.0. 
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep,
                                         @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                         @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                         NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                         NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI,
                                         @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep,
                                         @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                         @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer nLength,
                                         NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                         NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI,
                                         @Cast("Npp8u*") ByteBuffer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep,
                                         @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                         @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] nLength,
                                         NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                         NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                         @ByVal NppiSize oSizeROI,
                                         @Cast("Npp8u*") byte[] pTempStorage, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep,
                                     @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                     @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                     NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                     NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                     @ByVal NppiSize oSizeROI,
                                     @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep,
                                     @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                     @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer nLength,
                                     NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                     NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                     @ByVal NppiSize oSizeROI,
                                     @Cast("Npp8u*") ByteBuffer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep,
                                     @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                     @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] nLength,
                                     NppiEncodeHuffmanSpec pHuffmanTableDC, 
                                     NppiEncodeHuffmanSpec pHuffmanTableAC, 
                                     @ByVal NppiSize oSizeROI,
                                     @Cast("Npp8u*") byte[] pTempStorage); 

/**
 * Huffman Encoding of the JPEG Encoding.
 * Input is expected to be 64x1 macro blocks and output is expected as byte stuffed huffman encoded JPEG scan.
 *
 * @param apSrc \ref destination_image_pointer.
 * @param aSrcStep \ref destination_image_line_step.
 * @param nRestartInterval Restart Interval, see JPEG standard. Currently only values <=0 are supported.
 * @param nSs Start Coefficient, see JPEG standard.
 * @param nSe End Coefficient, see JPEG standard.
 * @param nAh Bit Approximation High, see JPEG standard.
 * @param nAl Bit Approximation Low, see JPEG standard.
 * @param pDst Byte-stuffed huffman encoded JPEG scan.
 * @param nLength Byte length of the huffman encoded JPEG scan.
 * @param apHuffmanDCTable DC Huffman tables.
 * @param apHuffmanACTable AC Huffman tables.
 * @param aSizeROI \ref roi_specification.
 * @param pTempStorage Temporary storage.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *         - ::NPP_NOT_SUFFICIENT_COMPUTE_CAPABILITY If the device has compute capability < 2.0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
 public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") PointerPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                           @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                           @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                           @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanDCTable, 
                                           @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanACTable, 
                                           NppiSize aSizeROI,
                                           @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
 public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr ShortPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                           @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                           @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                           NppiSize aSizeROI,
                                           @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
 public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr ShortBuffer apSrc, @Cast("Npp32s*") IntBuffer aSrcStep,
                                           @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                           @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer nLength,
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                           NppiSize aSizeROI,
                                           @Cast("Npp8u*") ByteBuffer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
 public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr short[] apSrc, @Cast("Npp32s*") int[] aSrcStep,
                                           @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                           @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] nLength,
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                           @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                           NppiSize aSizeROI,
                                           @Cast("Npp8u*") byte[] pTempStorage, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") PointerPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                      @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                      @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                      @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanDCTable, 
                                      @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanACTable, 
                                      NppiSize aSizeROI,
                                      @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr ShortPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                      @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                      @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer nLength,
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                      NppiSize aSizeROI,
                                      @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr ShortBuffer apSrc, @Cast("Npp32s*") IntBuffer aSrcStep,
                                      @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                      @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer nLength,
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                      NppiSize aSizeROI,
                                      @Cast("Npp8u*") ByteBuffer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr short[] apSrc, @Cast("Npp32s*") int[] aSrcStep,
                                      @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                      @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] nLength,
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                      @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                      NppiSize aSizeROI,
                                      @Cast("Npp8u*") byte[] pTempStorage);

/**
 * Optimize Huffman Encoding of the JPEG Encoding.
 * Input is expected to be 64x1 macro blocks and output is expected as byte stuffed huffman encoded JPEG scan.
 *
 * @param pSrc \ref destination_image_pointer.
 * @param nSrcStep \ref destination_image_line_step.
 * @param nRestartInterval Restart Interval, see JPEG standard. Currently only values <=0 are supported.
 * @param nSs Start Coefficient, see JPEG standard.
 * @param nSe End Coefficient, see JPEG standard.
 * @param nAh Bit Approximation High, see JPEG standard.
 * @param nAl Bit Approximation Low, see JPEG standard.
 * @param pDst Byte-stuffed huffman encoded JPEG scan.
 * @param pLength Pointer to the byte length of the huffman encoded JPEG scan.
 * @param hpCodesDC Host pointer to the code of the huffman tree for DC component.
 * @param hpTableDC Host pointer to the table of the huffman tree for DC component.
 * @param hpCodesAC Host pointer to the code of the huffman tree for AC component.
 * @param hpTableAC Host pointer to the table of the huffman tree for AC component.
 * @param pHuffmanDCTable DC Huffman table.
 * @param pHuffmanACTable AC Huffman table.
 * @param oSizeROI \ref roi_specification.
 * @param pTempStorage Temporary storage.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *         - ::NPP_NOT_SUFFICIENT_COMPUTE_CAPABILITY If the device has compute capability < 2.0. 
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                                 @Cast("Npp8u*") BytePointer hpCodesDC, @Cast("Npp8u*") BytePointer hpTableDC,
                                                 @Cast("Npp8u*") BytePointer hpCodesAC, @Cast("Npp8u*") BytePointer hpTableAC,
                                                 NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                                 NppiEncodeHuffmanSpec pHuffmanACTable, 
                                                 @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer pLength,
                                                 @Cast("Npp8u*") ByteBuffer hpCodesDC, @Cast("Npp8u*") ByteBuffer hpTableDC,
                                                 @Cast("Npp8u*") ByteBuffer hpCodesAC, @Cast("Npp8u*") ByteBuffer hpTableAC,
                                                 NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                                 NppiEncodeHuffmanSpec pHuffmanACTable, 
                                                 @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] pLength,
                                                 @Cast("Npp8u*") byte[] hpCodesDC, @Cast("Npp8u*") byte[] hpTableDC,
                                                 @Cast("Npp8u*") byte[] hpCodesAC, @Cast("Npp8u*") byte[] hpTableAC,
                                                 NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                                 NppiEncodeHuffmanSpec pHuffmanACTable, 
                                                 @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pTempStorage, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                             @Cast("Npp8u*") BytePointer hpCodesDC, @Cast("Npp8u*") BytePointer hpTableDC,
                                             @Cast("Npp8u*") BytePointer hpCodesAC, @Cast("Npp8u*") BytePointer hpTableAC,
                                             NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                             NppiEncodeHuffmanSpec pHuffmanACTable, 
                                             @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer pLength,
                                             @Cast("Npp8u*") ByteBuffer hpCodesDC, @Cast("Npp8u*") ByteBuffer hpTableDC,
                                             @Cast("Npp8u*") ByteBuffer hpCodesAC, @Cast("Npp8u*") ByteBuffer hpTableAC,
                                             NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                             NppiEncodeHuffmanSpec pHuffmanACTable, 
                                             @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] pLength,
                                             @Cast("Npp8u*") byte[] hpCodesDC, @Cast("Npp8u*") byte[] hpTableDC,
                                             @Cast("Npp8u*") byte[] hpCodesAC, @Cast("Npp8u*") byte[] hpTableAC,
                                             NppiEncodeHuffmanSpec pHuffmanDCTable, 
                                             NppiEncodeHuffmanSpec pHuffmanACTable, 
                                             @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pTempStorage);

/**
 * Optimize Huffman Encoding of the JPEG Encoding.
 * Input is expected to be 64x1 macro blocks and output is expected as byte stuffed huffman encoded JPEG scan.
 *
 * @param apSrc \ref destination_image_pointer.
 * @param aSrcStep \ref destination_image_line_step.
 * @param nRestartInterval Restart Interval, see JPEG standard. Currently only values <=0 are supported.
 * @param nSs Start Coefficient, see JPEG standard.
 * @param nSe End Coefficient, see JPEG standard.
 * @param nAh Bit Approximation High, see JPEG standard.
 * @param nAl Bit Approximation Low, see JPEG standard.
 * @param pDst Byte-stuffed huffman encoded JPEG scan.
 * @param pLength Pointer to the byte length of the huffman encoded JPEG scan.
 * @param hpCodesDC Host pointer to the code of the huffman tree for DC component.
 * @param hpTableDC Host pointer to the table of the huffman tree for DC component.
 * @param hpCodesAC Host pointer to the code of the huffman tree for AC component.
 * @param hpTableAC Host pointer to the table of the huffman tree for AC component.
 * @param apHuffmanDCTable DC Huffman tables.
 * @param apHuffmanACTable AC Huffman tables.
 * @param oSizeROI \ref roi_specification.
 * @param pTempStorage Temporary storage.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *         - ::NPP_NOT_SUFFICIENT_COMPUTE_CAPABILITY If the device has compute capability < 2.0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") PointerPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                                 @Cast("Npp8u**") PointerPointer hpCodesDC, @Cast("Npp8u**") PointerPointer hpTableDC,
                                                 @Cast("Npp8u**") PointerPointer hpCodesAC, @Cast("Npp8u**") PointerPointer hpTableAC,
                                                 @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanDCTable, 
                                                 @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanACTable, 
                                                 NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr ShortPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                                 @Cast("Npp8u**") @ByPtrPtr BytePointer hpCodesDC, @Cast("Npp8u**") @ByPtrPtr BytePointer hpTableDC,
                                                 @Cast("Npp8u**") @ByPtrPtr BytePointer hpCodesAC, @Cast("Npp8u**") @ByPtrPtr BytePointer hpTableAC,
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                                 NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr ShortBuffer apSrc, @Cast("Npp32s*") IntBuffer aSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer pLength,
                                                 @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpCodesDC, @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpTableDC,
                                                 @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpCodesAC, @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpTableAC,
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                                 NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pTempStorage, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R_Ctx(@Cast("Npp16s**") @ByPtrPtr short[] apSrc, @Cast("Npp32s*") int[] aSrcStep,
                                                 @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                                 @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                                 @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] pLength,
                                                 @Cast("Npp8u**") @ByPtrPtr byte[] hpCodesDC, @Cast("Npp8u**") @ByPtrPtr byte[] hpTableDC,
                                                 @Cast("Npp8u**") @ByPtrPtr byte[] hpCodesAC, @Cast("Npp8u**") @ByPtrPtr byte[] hpTableAC,
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                                 @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                                 NppiSize oSizeROI, @Cast("Npp8u*") byte[] pTempStorage, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") PointerPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                             @Cast("Npp8u**") PointerPointer hpCodesDC, @Cast("Npp8u**") PointerPointer hpTableDC,
                                             @Cast("Npp8u**") PointerPointer hpCodesAC, @Cast("Npp8u**") PointerPointer hpTableAC,
                                             @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanDCTable, 
                                             @Cast("NppiEncodeHuffmanSpec**") PointerPointer apHuffmanACTable, 
                                             NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr ShortPointer apSrc, @Cast("Npp32s*") IntPointer aSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s*") IntPointer pLength,
                                             @Cast("Npp8u**") @ByPtrPtr BytePointer hpCodesDC, @Cast("Npp8u**") @ByPtrPtr BytePointer hpTableDC,
                                             @Cast("Npp8u**") @ByPtrPtr BytePointer hpCodesAC, @Cast("Npp8u**") @ByPtrPtr BytePointer hpTableAC,
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                             NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr ShortBuffer apSrc, @Cast("Npp32s*") IntBuffer aSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s*") IntBuffer pLength,
                                             @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpCodesDC, @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpTableDC,
                                             @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpCodesAC, @Cast("Npp8u**") @ByPtrPtr ByteBuffer hpTableAC,
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                             NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pTempStorage);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanScan_JPEG_8u16s_P3R(@Cast("Npp16s**") @ByPtrPtr short[] apSrc, @Cast("Npp32s*") int[] aSrcStep,
                                             @Cast("Npp32s") int nRestartInterval, @Cast("Npp32s") int nSs, 
                                             @Cast("Npp32s") int nSe, @Cast("Npp32s") int nAh, @Cast("Npp32s") int nAl,
                                             @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s*") int[] pLength,
                                             @Cast("Npp8u**") @ByPtrPtr byte[] hpCodesDC, @Cast("Npp8u**") @ByPtrPtr byte[] hpTableDC,
                                             @Cast("Npp8u**") @ByPtrPtr byte[] hpCodesAC, @Cast("Npp8u**") @ByPtrPtr byte[] hpTableAC,
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanDCTable, 
                                             @ByPtrPtr NppiEncodeHuffmanSpec apHuffmanACTable, 
                                             NppiSize oSizeROI, @Cast("Npp8u*") byte[] pTempStorage);

/**
 * Calculates the size of the temporary buffer for baseline Huffman encoding.
 *
 * @see nppiEncodeHuffmanScan_JPEG_8u16s_P1R(), nppiEncodeHuffmanScan_JPEG_8u16s_P3R().
 * 
 * @param oSize Image Dimension.
 * @param nChannels Number of channels in the image.
 * @param pBufSize Pointer to variable that returns the size of the
 *        temporary buffer. 
 *
 * @return NPP_SUCCESS Indicates no error. Any other value indicates an error
 *         or a warning
 * @return NPP_SIZE_ERROR Indicates an error condition if any image dimension
 *         has zero or negative value
 * @return NPP_NULL_POINTER_ERROR Indicates an error condition if pBufSize
 *         pointer is NULL
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiEncodeHuffmanGetSize(@ByVal NppiSize oSize, int nChannels, @Cast("size_t*") SizeTPointer pBufSize);

/**
 * Calculates the size of the temporary buffer for optimize Huffman coding.
 *
 * 
 * @param oSize Image Dimension.
 * @param nChannels Number of channels in the image.
 * @param pBufSize Pointer to variable that returns the size of the
 *        temporary buffer. 
 *
 * @return NPP_SUCCESS Indicates no error. Any other value indicates an error
 *         or a warning
 * @return NPP_SIZE_ERROR Indicates an error condition if any image dimension
 *         has zero or negative value
 * @return NPP_NULL_POINTER_ERROR Indicates an error condition if pBufSize
 *         pointer is NULL
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanGetSize(@ByVal NppiSize oSize, int nChannels, IntPointer pBufSize);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanGetSize(@ByVal NppiSize oSize, int nChannels, IntBuffer pBufSize);
public static native @Cast("NppStatus") int nppiEncodeOptimizeHuffmanGetSize(@ByVal NppiSize oSize, int nChannels, int[] pBufSize);
// Targeting ../nppicom/NppiJpegFrameDescr.java


// Targeting ../nppicom/NppiJpegScanDescr.java



/**
 * Type of job to execute. Usually you will need just SIMPLE
 * for each scan, one MEMZERO at the beginning and FINALIZE at the end.
 * See the example in \ref nppiJpegDecodeJob
 *
 * SIMPLE can be split into multiple jobs: PRE, CPU & GPU.
 * Please note that if you don't use SIMPLE,
 * you man need to add some memcopies and synchronizes as
 * described in \ref nppiJpegDecodeJob.
 *
 * @see nppiJpegDecodeJob
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
/** enum NppiJpegDecodeJobKind */
public static final int
    /** Decode whole scan using a single job */
    NPPI_JPEG_DECODE_SIMPLE = 0,

    // SIMPLE can be split into:
    /*@{*/
    /** Preprocessing scan on GPU */
    NPPI_JPEG_DECODE_PRE = 1,
    /** Part of decoding run on CPU */
    NPPI_JPEG_DECODE_CPU = 2,
    /** Part of decoding run on GPU */
    NPPI_JPEG_DECODE_GPU = 3,
    /*@}*/

    /** Zeroing memory before decoding */
    NPPI_JPEG_DECODE_MEMZERO = 4,
    /** Change memory representation of DCT coefficients to final */
    NPPI_JPEG_DECODE_FINALIZE = 5;
// Targeting ../nppicom/NppiJpegDecodeJob.java



/** Number of additional buffers that may be used by JPEG decode jobs.
 * This number may change in the future, but it remain small.
 *
 * @see NppiJpegDecodeJobMemory
 */
public static final int NPPI_JPEG_DECODE_N_BUFFERS = 3;
// Targeting ../nppicom/NppiJpegDecodeJobMemory.java



/**
 * Calculates sizes of additional buffers used by the job.
 *
 * @param pJob has to point to properly initialized job
 * @param aSize [out] will be filled with \ref NPPI_JPEG_DECODE_N_BUFFERS sizes,
 * {@code aSize[i]} telling how much memory has to be allocated for {@code apCpuBuffer[i]} and {@code apGpuBuffer[i]}.
 *
 * @see NppiJpegDecodeJobMemory
 *
 * @return
 * * \ref NPP_SUCCESS
 * * \ref NPP_BAD_ARGUMENT_ERROR when the scan doesn't represent valid JPEG scan
 * * \ref NPP_NULL_POINTER_ERROR when one of necessary arguments is NULL
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiJpegDecodeJobMemorySize(@Const NppiJpegDecodeJob pJob, @Cast("size_t*") SizeTPointer aSize);

/**
 * Executes a job -- part of decoding.
 *
 * @param pJob has to be initialized by \ref nppiJpegDecodeJobCreateMemzero
 * or \ref nppiJpegDecodeJobCreateFinalize or manually.
 * @param pMemory has to point to valid structure, except for MEMZERO and FINALIZE
 * scans, for which it can be NULL.
 *
 * @see nppiJpegDecodeJobMemorySize
 * @see nppiJpegDecodeJobCreateMemzero
 * @see nppiJpegDecodeJobCreateFinalize
 *
 * This function can be used in two ways, depending on how much control do you need:
 * 1. Decode whole scan in one job. That is accomplished when the job.eKind is
 *    set to \ref NPPI_JPEG_DECODE_SIMPLE. Nppi function handless all in-scan synchronization
 *    (if needed).
 *    This is described in example.
 * 2. Split decoding of scan into multiple jobs. In this case, caller is responsible
 *    necessary synchronizations. If multiple jobs
 *    from the same scan claim to use the same additional buffer, it means that
 *    the jobs are exchaning information throught this buffer and the buffer should not be
 *    reused or reallocated meanwhile, additionaly if the buffer is used first by PRE job,
 *    and then by CPU job, caller has to call cudaStreamSynchronize before CPU job.
 *    \ref NppiJpegDecodeJobKind for more information.
 *
 * Example (pseudo)code for decoding JPEG:
 * (Error handling code omitted for brevity. Each function which may return
 * an error should be checked)
 * <pre>{@code
 // Allocate DCT buffers (using nppiJpegDecodeGetDCTBufferSize)
 
 NppiJpegFrameDescr frame;
 // Fill frame info...
 NppiJpegScanDescr scan;
 NppiJpegDecodeJob job;
 job.pFrame = frame;
 job.pScan = scan;
 
 nppiJpegDecodeJobCreateMemzero(&job);
 nppiJpegDecodeJob(&job, NULL);
 for (int i = 0; i < nScans; ++i)
 {
     // Fill scan info...
     job.eKind = NPPI_JPEG_DECODE_SIMPLE;
 
     size_t sizes[NPPI_JPEG_DECODE_N_BUFFERS];
     nppiJpegDecodeJobMemorySize(&job, sizes);
 
     NppiJpegJobMemory memory;
     // Allocate and fill scan buffers (using nppiJpegDecodeGetScanBufferSize)...
     // Fill the memory struct according to sizes...
 
     nppiJpegDecodeJob(&job, &memory);
 
     // Synchronization is needed only if you reuse buffers between scans. 
     cudaStreamSynchronize(nppGetStream()); or CudaStreamSynchronize(nppStreamCtx.hStream);
 }
 
 nppiJpegDecodeJobCreateFinalize(&job);
 nppiJpegDecodeJob(&job, NULL);
 
 // Perform further steps of decoding (iDCT etc.)
 * }</pre>
 *
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return
 * * \ref NPP_SUCCESS
 * * \ref NPP_BAD_ARGUMENT_ERROR when the scan doesn't represent valid JPEG scan
 * * \ref NPP_NULL_POINTER_ERROR when one of necessary arguments of buffers is NULL
 * * \ref NPP_ERROR when encountered CUDA error
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiJpegDecodeJob_Ctx(@Const NppiJpegDecodeJob pJob, @Const NppiJpegDecodeJobMemory pMemory, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiJpegDecodeJob(@Const NppiJpegDecodeJob pJob, @Const NppiJpegDecodeJobMemory pMemory);

/**
 * Initializes a job that has to be called at the beginning of decoding.
 *
 * @param pJob:
 * {@code pJob.pFrame} should point to valid frame description.
 * {@code *pJob.pScan} will be overwritten.
 *
 * If the caller had manually zeroed the memory for DCT buffers,
 * (note: whole \ref nppiJpegDecodeGetDCTBufferSize has to be zeroed).
 * this job doesn't have to be executed.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiJpegDecodeJobCreateMemzero(NppiJpegDecodeJob pJob);

/**
 * Initializes a job that has to be called at the end of decoding,
 * in order to convert temporary representation of DCT coefficients
 * to the final one.
 *
 * @param pJob:
 * pJob.pFrame should point to valid frame description
 * *pJob.pScan will be overwritten.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */ 
public static native @Cast("NppStatus") int nppiJpegDecodeJobCreateFinalize(NppiJpegDecodeJob pJob);

/**
 * This function returns how much additional memory has to be available
 * after the end of compressed scan data.
 *
 * The following buffers: {@code pCpuScan} and {@code pGpuScan} in \ref NppiJpegDecodeJobMemory
 * should have size at least {@code pScan->length + nppiJpegDecodeGetScanDeadzoneSize()}.
 *
 * The additional memory is needed because the decoder may perform
 * some speculative reads after the end of compressed scan data.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("size_t") long nppiJpegDecodeGetScanDeadzoneSize();

/**
 * Returns how much memory has to be allocated for DCT coefficient buffers
 * declared in \ref NppiJpegDecodeJobMemory. The returned value may be bigger than
 * simply {@code number of blocks * 64 * sizeof (short)}, because decoder
 * may use slightly bigger temporary representation of data.
 *
 * @param oBlocks Size of the interleaved component in blocks.
 * (That means that the size of component in blocks has to be aligned according
 * to subsampling of this component and frame).
 * 
 * This function assumes no ununsed space between rows,
 * so at the end stride = {@code oBlocks.width * 64 * sizeof (short)}.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("size_t") long nppiJpegDecodeGetDCTBufferSize(@ByVal NppiSize oBlocks);

/*@}*/

/**
 * Inverse DCT in WebP decoding. Input is the bitstream that contains the coefficients of 16x16 blocks.
 * These coefficients are based on a 4x4 sub-block unit, e.g., 
 * Coeffs in 0th 4x4 block, 1st 4x4 block 2nd 4x4 block, etc.
 * Output is the coefficients after inverse DCT transform.
 * The output is put in an image format (i.e. raster scan order), different from the input order.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return Error codes:
 *         - ::NPP_SIZE_ERROR For negative input height/width or not a multiple of
 *           8 width/height.
 *         - ::NPP_STEP_ERROR If input image width is not multiple of 8 or does not
 *           match ROI.
 *         - ::NPP_NULL_POINTER_ERROR If the destination pointer is 0.
 *  
 * NOTE THAT ALL OF THESE FUNCTIONS WILL BE DEPRECATED IN THE NEXT RELEASE OF NPP, USE NVJPEG INSTEAD. 
 */
public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDCTInv4x4_WebP_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI);

/** \} image_compression */


// #ifdef __cplusplus /* extern "C" */
// #endif

// #endif /* NV_NPPI_COMPRESSION_FUNCTIONS_H */


}
