// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
* Specifies the allocation properties for a allocation.
*/
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUmemAllocationProp extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUmemAllocationProp() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUmemAllocationProp(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUmemAllocationProp(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUmemAllocationProp position(long position) {
        return (CUmemAllocationProp)super.position(position);
    }

    /** Allocation type */
    public native @Cast("CUmemAllocationType") int type(); public native CUmemAllocationProp type(int setter);
    /** requested ::CUmemAllocationHandleType */
    public native @Cast("CUmemAllocationHandleType") int requestedHandleTypes(); public native CUmemAllocationProp requestedHandleTypes(int setter);
    /** Location of allocation */
    public native @ByRef CUmemLocation location(); public native CUmemAllocationProp location(CUmemLocation setter);
    /**
     * Windows-specific LPSECURITYATTRIBUTES required when
     * ::CU_MEM_HANDLE_TYPE_WIN32 is specified.  This security attribute defines
     * the scope of which exported allocations may be tranferred to other
     * processes.  In all other cases, this field is required to be zero.
     */
    public native Pointer win32HandleMetaData(); public native CUmemAllocationProp win32HandleMetaData(Pointer setter);
    /** Reserved for future use, must be zero */
    public native @Cast("unsigned long long") long reserved(); public native CUmemAllocationProp reserved(long setter);
}
