// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppist extends org.bytedeco.cuda.presets.nppist {
    static { Loader.load(); }

// Parsed from <nppi_statistics_functions.h>

 /* Copyright 2009-2018 NVIDIA Corporation.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are 
  * subject to NVIDIA intellectual property rights under U.S. and 
  * international Copyright laws. 
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED 
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY 
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_STATISTICS_FUNCTIONS_H
// #define NV_NPPI_STATISTICS_FUNCTIONS_H
 
/**
 * \file nppi_statistics_functions.h
 * NPP Image Processing Functionality.
 */
 
// #include "nppdefs.h"


// #ifdef __cplusplus
// #endif

/** \defgroup image_statistics_functions Statistical Operations
 *  \ingroup nppi
 *
 * Primitives for computing the statistical properties of an image.
 * Some statistical primitives also require scratch buffer during the computation. For details, please 
 * refer to \ref general_scratch_buffer.
 * 
 * \{
 *
 * These functions can be found in the nppist library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 *
 * \anchor CommonGetBufferHostSizeParameters
 * Common parameters for nppiGetBufferHostSize functions include:
 * @param oSizeROI \ref roi_specification.
 * @param hpBufferSize Required buffer size. Important: hpBufferSize is a 
 *        <em>host pointer.</em> \ref general_scratch_buffer.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return NPP_NULL_POINTER_ERROR if hpBufferSize is 0 (NULL),  \ref roi_error_codes.  
 */

/** \defgroup image_sum Sum
 * Primitives for computing the sum of all the pixel values in an image.
 * \{
 */

/** \name Sum
 * \{
 * Given an image {@code pSrc} with width {@code W} and height {@code H}, the sum
 * will be computed as
 * <pre>{@code \[Sum = \sum_{j=0}^{H-1}\sum_{i=0}^{W-1}pSrc(j,i)\]}</pre>
 * All the results are stored in a 64-bit double precision format, 
 * except for two primitives \ref nppiSum_8u64s_C1R and \ref nppiSum_8u64s_C4R.
 * The sum functions require additional scratch buffer for computations. 
 *
 * <h3><a name="CommonSumParameters">Common parameters for nppiSum functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer.
 *                      Use nppiSumGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pSum Pointer to the computed sum.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */
 
/**
 * One-channel 8-bit unsigned image sum. 
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum);
public static native @Cast("NppStatus") int nppiSum_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum);
public static native @Cast("NppStatus") int nppiSum_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum);

/**
 * One-channel 8-bit unsigned image sum. The result is 64-bit long long integer.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u64s_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64s*") LongPointer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u64s_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64s*") LongBuffer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u64s_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64s*") long[] pSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u64s_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64s*") LongPointer pSum);
public static native @Cast("NppStatus") int nppiSum_8u64s_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64s*") LongBuffer pSum);
public static native @Cast("NppStatus") int nppiSum_8u64s_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64s*") long[] pSum);

/**
 * One-channel 16-bit unsigned image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum);
public static native @Cast("NppStatus") int nppiSum_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum);
public static native @Cast("NppStatus") int nppiSum_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum);

/**
 * One-channel 16-bit signed image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum);
public static native @Cast("NppStatus") int nppiSum_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum);
public static native @Cast("NppStatus") int nppiSum_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum);

/**
 * One-channel 32-bit floating point image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pSum);
public static native @Cast("NppStatus") int nppiSum_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pSum);
public static native @Cast("NppStatus") int nppiSum_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pSum);

/**
 * Three-channel 8-bit unsigned image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Three-channel 16-bit unsigned image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Three-channel 16-bit signed image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Three-channel 32-bit floating point image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 8-bit unsigned image sum ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 16-bit unsigned image sum ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 16-bit signed image sum ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 32-bit floating point image sum ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 8-bit unsigned image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 8-bit unsigned image sum. The result is 64-bit long long integer.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_8u64s_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64s*") LongPointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u64s_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64s*") LongBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_8u64s_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64s*") long[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_8u64s_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64s*") LongPointer aSum);
public static native @Cast("NppStatus") int nppiSum_8u64s_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64s*") LongBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_8u64s_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64s*") long[] aSum);

/**
 * Four-channel 16-bit unsigned image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 16-bit signed image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/**
 * Four-channel 32-bit floating point image sum.
 *
 * For common parameter descriptions, see <a href="#CommonSumParameters">Common parameters for nppiSum functions</a>. 
 *
 */
public static native @Cast("NppStatus") int nppiSum_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSum_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSum_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aSum);
public static native @Cast("NppStatus") int nppiSum_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aSum);

/** \} Sum */

/** \name SumGetBufferHostSize 
 * Companion primitives for computing the device buffer size (in bytes) required by the sum primitives.
 * \{
 */

/**
 * Buffer size for \ref nppiSum_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/**
 * Buffer size for \ref nppiSum_8u64s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16s_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_8u64s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u64s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiSum_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiSumGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);
 
/** \} SumGetBufferHostSize */
/** \} image_sum */

/** \defgroup image_min Min
 * Primitives for computing the minimal pixel value of an image.
 * \{
 */

/** \name Min
 * The scratch buffer is required by the min functions.
 *
 * <h3><a name="CommonMinParameters">Common parameters for nppiMin functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer.
 *                      Use nppiMinGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pMin Pointer to the computed min.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 */

/**
 * One-channel 8-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMin);
public static native @Cast("NppStatus") int nppiMin_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMin);
public static native @Cast("NppStatus") int nppiMin_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMin);

/**
 * One-channel 16-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMin);
public static native @Cast("NppStatus") int nppiMin_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMin);
public static native @Cast("NppStatus") int nppiMin_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMin);

/**
 * One-channel 16-bit signed image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMin);
public static native @Cast("NppStatus") int nppiMin_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMin);
public static native @Cast("NppStatus") int nppiMin_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMin);

/**
 * One-channel 32-bit floating point image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMin);
public static native @Cast("NppStatus") int nppiMin_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMin);
public static native @Cast("NppStatus") int nppiMin_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMin);

/**
 * Three-channel 8-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin);

/**
 * Three-channel 16-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin);

/**
 * Three-channel 16-bit signed image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin);

/**
 * Three-channel 32-bit floating point image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin);

/**
 * Four-channel 8-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin);

/**
 * Four-channel 16-bit unsigned image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin);

/**
 * Four-channel 16-bit signed image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin);

/**
 * Four-channel 32-bit floating point image min. 
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin);

/**
 * Four-channel 8-bit unsigned image min ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin);

/**
 * Four-channel 16-bit unsigned image min ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin);

/**
 * Four-channel 16-bit signed image min ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin);

/**
 * Four-channel 32-bit floating point image min ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinParameters">Common parameters for nppiMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMin_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMin_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMin_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin);
public static native @Cast("NppStatus") int nppiMin_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin);

/** \} Min */

/** \name MinGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the min primitives.
 * \{
 */

/**
 * Buffer size for \ref nppiMin_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_16s_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMin_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} MinGetBufferHostSize */
/** \} image_min */

/** \defgroup image_min_index MinIndx
 * Primitives for computing the minimal value and its indices (X and Y coordinates) of an image.
 * \{
 */
/** \name MinIndx
 * If there are several minima in the selected ROI, the function returns one on the top leftmost position.
 * The scratch buffer is required by the functions.
 * 
 * <h3><a name="CommonMinIndxParameters">Common parameters for nppiMinIndx functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer
 *        Use nppiMinIndxGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pMin Pointer to the computed min result.
 * @param pIndexX Pointer to the X coordinate of the image min value.
 * @param pIndexY Ppointer to the Y coordinate of the image min value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 */
/**
 * One-channel 8-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMin, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMin, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMin, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMin, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 16-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMin, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMin, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMin, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMin, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 16-bit signed image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMin, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMin, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMin, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMin, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 32-bit floating point image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMin, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMin, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMin, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMin, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMin, int[] pIndexX, int[] pIndexY);

/**
 * Three-channel 8-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 16-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 16-bit signed image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 32-bit floating point image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 8-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit unsigned image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit signed image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 32-bit floating point image MinIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 8-bit unsigned image MinIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit unsigned image MinIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit signed image MinIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMin, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 32-bit floating point image MinIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinIndxParameters">Common parameters for nppiMinIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMin, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMin, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMinIndx_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMin, int[] aIndexX, int[] aIndexY);

/** \} Min */

/** \name MinIndxGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the MinIndx primitives.
 * \{
 */
/**
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMinIndx_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} MinIndxGetBufferHostSize */
/** \} image_min_index */

/** \defgroup image_max Max
 * Primitives for computing the maximal pixel value of an image.
 * 
 * <h3><a name="CommonMaxParameters">Common parameters for nppiMax functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer.
 *                      Use nppiMaxGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pMax Pointer to the computed max.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 * 
 * \{
 */

/** \name Max
 *  The scratch buffer is required by the functions.
 * \{
 */

/**
 * One-channel 8-bit unsigned image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMax);
public static native @Cast("NppStatus") int nppiMax_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMax);
public static native @Cast("NppStatus") int nppiMax_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMax);

/**
 * One-channel 16-bit unsigned image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMax);
public static native @Cast("NppStatus") int nppiMax_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMax);
public static native @Cast("NppStatus") int nppiMax_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMax);

/**
 * One-channel 16-bit signed image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMax);
public static native @Cast("NppStatus") int nppiMax_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMax);
public static native @Cast("NppStatus") int nppiMax_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMax);

/**
 * One-channel 32-bit floating point image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMax);
public static native @Cast("NppStatus") int nppiMax_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMax);
public static native @Cast("NppStatus") int nppiMax_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMax);

/**
 * Three-channel 8-bit unsigned image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax);

/**
 * Three-channel 16-bit unsigned image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax);

/**
 * Three-channel 16-bit signed image Max.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax);

/**
 * Three-channel 32-bit floating point image Max. 
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax);

/**
 * Four-channel 8-bit unsigned image Max. 
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax);

/**
 * Four-channel 16-bit unsigned image Max. 
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax);

/**
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax);

/**
 * Four-channel 32-bit floating point image Max. 
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax);

/**
 * Four-channel 8-bit unsigned image Max ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax);

/**
 * Four-channel 16-bit unsigned image Max ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax);

/**
 * Four-channel 16-bit signed image Max ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax);

/**
 * Four-channel 32-bit floating point image Max ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxParameters">Common parameters for nppiMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMax_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMax_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax);
public static native @Cast("NppStatus") int nppiMax_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax);
/** \} */

/** \name MaxGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Max primitives.
 * \{
 */
/**
 * Buffer size for \ref nppiMax_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16s_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_16s_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMax_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} MaxGetBufferHostSize */
/** \} image_max */

/** \defgroup image_max_index MaxIndx
 * Primitives for computing the maximal value and its indices (X and Y coordinates) of an image.
 * \{
 */
/** \name MaxIndx
 * If there are several maxima in the selected region of interest, the function returns one on the top leftmost position. 
 * The scratch buffer is required by the functions.
 * 
 * <h3><a name="CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer
 *        Use nppiMaxIndxGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pMax Pointer to the computed max result.
 * @param pIndexX Pointer to the X coordinate of the image max value.
 * @param pIndexY Ppointer to the Y coordinate of the image max value.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * One-channel 8-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMax, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMax, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer pMax, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] pMax, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 16-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMax, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMax, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer pMax, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] pMax, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 16-bit signed image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMax, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMax, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer pMax, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] pMax, int[] pIndexX, int[] pIndexY);

/**
 * One-channel 32-bit floating point image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMax, IntPointer pIndexX, IntPointer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMax, int[] pIndexX, int[] pIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer pMax, IntPointer pIndexX, IntPointer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer pMax, IntBuffer pIndexX, IntBuffer pIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] pMax, int[] pIndexX, int[] pIndexY);

/**
 * Three-channel 8-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 16-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 16-bit signed image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Three-channel 32-bit floating point image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 8-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit unsigned image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit signed image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 32-bit floating point image MaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 8-bit unsigned image MaxIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp8u*") BytePointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp8u*") ByteBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp8u*") byte[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit unsigned image MaxIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16u*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16u*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16u*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 16-bit signed image MaxIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp16s*") ShortPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp16s*") ShortBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp16s*") short[] aMax, int[] aIndexX, int[] aIndexY);

/**
 * Four-channel 32-bit floating point image MaxIndx ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMaxIndxParameters">Common parameters for nppiMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp32f*") FloatPointer aMax, IntPointer aIndexX, IntPointer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp32f*") FloatBuffer aMax, IntBuffer aIndexX, IntBuffer aIndexY);
public static native @Cast("NppStatus") int nppiMaxIndx_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp32f*") float[] aMax, int[] aIndexX, int[] aIndexY);

/** \} */

/** \name MaxIndxGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the MaxIndx primitives.
 * \{
 */

/**
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the dvice scratch buffer size (in bytes) for nppiMaxIndx_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMaxIndxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_max_index */

/** \defgroup image_min_max MinMax
 * Primitives for computing both the minimal and the maximal values of an image.
 * \{
 */

/** \name MinMax
 * The functions require the device scratch buffer.
 * 
 * <h3><a name="CommonMinMaxParameters">Common parameters for nppiMinMax functions include:</a></h3>
 * 
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pMin Pointer to the computed minimal result.
 * @param pMax Pointer to the computed maximal result.
 * @param pDeviceBuffer Buffer to a scratch memory. 
 *        Use nppiMinMax_XX_XXX to determine the minium number of bytes required.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 * 
 * \{
 */
/**
 * One-channel 8-bit unsigned image MinMax.
 * 
 */
public static native @Cast("NppStatus") int nppiMinMax_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMin, @Cast("Npp8u*") BytePointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMin, @Cast("Npp8u*") ByteBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMin, @Cast("Npp8u*") byte[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMin, @Cast("Npp8u*") BytePointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMin, @Cast("Npp8u*") ByteBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMin, @Cast("Npp8u*") byte[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMin, @Cast("Npp16u*") ShortPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMin, @Cast("Npp16u*") ShortBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMin, @Cast("Npp16u*") short[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMin, @Cast("Npp16u*") ShortPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMin, @Cast("Npp16u*") ShortBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMin, @Cast("Npp16u*") short[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer pMin, @Cast("Npp16s*") ShortPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer pMin, @Cast("Npp16s*") ShortBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] pMin, @Cast("Npp16s*") short[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer pMin, @Cast("Npp16s*") ShortPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer pMin, @Cast("Npp16s*") ShortBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] pMin, @Cast("Npp16s*") short[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMin, @Cast("Npp32f*") FloatPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMin, @Cast("Npp32f*") FloatBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMin, @Cast("Npp32f*") float[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMin, @Cast("Npp32f*") FloatPointer pMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMin, @Cast("Npp32f*") FloatBuffer pMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMin, @Cast("Npp32f*") float[] pMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image MinMax ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image MinMax ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image MinMax ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer aMin, @Cast("Npp8u*") BytePointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer aMin, @Cast("Npp8u*") ByteBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] aMin, @Cast("Npp8u*") byte[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer aMin, @Cast("Npp16u*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer aMin, @Cast("Npp16u*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] aMin, @Cast("Npp16u*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortPointer aMin, @Cast("Npp16s*") ShortPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") ShortBuffer aMin, @Cast("Npp16s*") ShortBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16s*") short[] aMin, @Cast("Npp16s*") short[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image MinMax.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxParameters">Common parameters for nppiMinMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMax_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMax_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer aMin, @Cast("Npp32f*") FloatPointer aMax, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer aMin, @Cast("Npp32f*") FloatBuffer aMax, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMax_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] aMin, @Cast("Npp32f*") float[] aMax, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */

/** \name MinMaxGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the MinMax primitives.
 * \{
 */
/** 
 * Buffer size for \ref nppiMinMax_8u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16s_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_32f_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_8u_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16u_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16s_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_32f_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_8u_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16u_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16s_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_32f_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_8u_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16u_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMax_16s_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_min_max */

/** \defgroup image_min_max_index MinMaxIndx
 * Primitives for computing the minimal and the maximal values with their indices (X and Y coordinates) of an image.
 * \{
 */

/** \name MinMaxIndx
 * If there are several minima and maxima in the selected region of interest, the function returns ones on the top leftmost position.
 * The scratch buffer is required by the functions.
 * 
 * <h3><a name="CommonMinMaxIndxParameters">Common parameters for nppiMinIndx functions include:</a></h3>
 * 
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.  
 * @param nCOI \ref channel_of_interest_number.
 * @param pMinValue Pointer to the minimum value.
 * @param pMaxValue Pointer to the maximum value.
 * @param pMinIndex Pointer to the indicies (X and Y coordinates) of the minimum value.
 * @param pMaxIndex Pointer to the indicies (X and Y coordinates) of the maximum value.
 * @param pDeviceBuffer Buffer to a scratch memory. Use nppiMinMaxIndxGetBufferHostSize_XX_XXX to determine
 *          the minium number of bytes required.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_COI_ERROR if an invalid channel of interest is specified.
 * If any of pMinValue, pMaxValue, pMinIndex, or pMaxIndex is not needed, zero pointer must be passed correspondingly.
 * If the mask is filled with zeros, then all the returned values are zeros, i.e., pMinIndex = {0, 0}, pMaxIndex = {0, 0},
 * pMinValue = 0, pMaxValue = 0.
 * \{
 */

/**
 * Computes the minimal and the maximal pixel values with their X and Y coordinates of 1-channel 8-bit unsigned char image. 
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Computes the minimal and the maximal pixel values with their X and Y coordinates of 1-channel 8-bit signed char image. 
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Computes the minimal and the maximal pixel values with their X and Y coordinates of 1-channel 16-bit unsigned short image. 
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Computes the minimal and the maximal pixel values with their X and Y coordinates of 1-channel 32-bit floating point image. 
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image MinMaxIndx.
 *
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 *  
 <p>
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image MinMaxIndx.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image MinMaxIndx.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image MinMaxIndx.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit signed image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */ 
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pMinValue, @Cast("Npp8u*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pMinValue, @Cast("Npp8u*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pMinValue, @Cast("Npp8u*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") BytePointer pMinValue, @Cast("Npp8s*") BytePointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") ByteBuffer pMinValue, @Cast("Npp8s*") ByteBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8s*") byte[] pMinValue, @Cast("Npp8s*") byte[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */ 
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortPointer pMinValue, @Cast("Npp16u*") ShortPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") ShortBuffer pMinValue, @Cast("Npp16u*") ShortBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp16u*") short[] pMinValue, @Cast("Npp16u*") short[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image MinMaxIndx affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonMinMaxIndxParameters">Common parameters for nppiMinMaxIndx functions</a>.
 */ 
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatPointer pMinValue, @Cast("Npp32f*") FloatPointer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") FloatBuffer pMinValue, @Cast("Npp32f*") FloatBuffer pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiMinMaxIndx_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp32f*") float[] pMinValue, @Cast("Npp32f*") float[] pMaxValue, NppiPoint pMinIndex, NppiPoint pMaxIndex, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */

/** \name MinMaxIndxGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the MinMaxIndx primitives.
 * \{
 */
/** 
 * Buffer size for \ref nppiMinMaxIndx_8u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8s_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_16u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_32f_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8u_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8s_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_16u_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_32f_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8u_C3CR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8s_C3CR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_16u_C3CR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_32f_C3CR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8u_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_8s_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_16u_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMinMaxIndx_32f_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMinMaxIndxGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_min_max_index */

/** \defgroup image_mean Mean
 * Primitives for computing the arithmetic mean of all the pixel values in an image.
 * \{
 */

/** \name Mean
 * Given an image {@code pSrc} with width {@code W} and height {@code H}, the arithmetic mean
 * will be computed as
 * <pre>{@code \[Mean = \frac{1}{W\cdot H}\sum_{j=0}^{H-1}\sum_{i=0}^{W-1}pSrc(j,i)\]}</pre>
 * The mean functions require additional scratch buffer for computations.
 * 
 * <h3><a name="CommonMeanParameters">Common parameters for nppiMean functions include:</a></h3>
 * 
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification. 
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param nCOI \ref channel_of_interest_number.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer
 *        Use nppiMeanGetBufferHostSize_XX_XXX to determine the minium number of bytes required.
 * @param pMean Pointer to the computed mean result.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_COI_ERROR if an invalid channel of interest is specified.s
 * 
 * \{
 */
/**
 * One-channel 8-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * One-channel 16-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * One-channel 16-bit signed image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * One-channel 32-bit floating point image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Three-channel 8-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Three-channel 16-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Three-channel 16-bit signed image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Three-channel 32-bit floating point image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 8-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 16-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 16-bit signed image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 32-bit floating point image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 8-bit unsigned image Mean ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 16-bit unsigned image Mean ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 16-bit signed image Mean ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Four-channel 32-bit floating point image Mean ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer aMean);
public static native @Cast("NppStatus") int nppiMean_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] aMean);

/**
 * Masked one-channel 8-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 <p>
 */
public static native @Cast("NppStatus") int nppiMean_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked one-channel 8-bit signed image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked one-channel 16-bit unsigned image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked one-channel 32-bit floating point image Mean.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked three-channel 8-bit unsigned image Mean affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked three-channel 8-bit signed image Mean affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked three-channel 16-bit unsigned image Mean affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/**
 * Masked three-channel 32-bit floating point image Mean affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonMeanParameters">Common parameters for nppiMean functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean);
public static native @Cast("NppStatus") int nppiMean_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean);

/** \} */

/** \name MeanGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Mean primitives.
 * \{
 */
/**
 * Buffer size for \ref nppiMean_8u_C1R.
 * 
 * <h3><a name="CommonGetBufferHostSizeParameters">Common parameters for nppiGetBufferHostSize functions include:</a></h3>
 * 
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/**
 * Buffer size for \ref nppiMean_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/**
 * Buffer size for \ref nppiMean_16s_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16s_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);
 
/** 
 * Buffer size for \ref nppiMean_8u_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8s_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16u_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8u_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_8s_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_16u_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_32f_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_mean */

/** \defgroup image_mean_stddev Mean_StdDev
 * Primitives for computing both the arithmetic mean and the standard deviation of an image.
 * \{
 */

/** \name Mean_StdDev
 * Given an image {@code pSrc} with width {@code W} and height {@code H}, the mean and the standard deviation
 * will be computed as
 * <pre>{@code \[Mean = \frac{1}{W\cdot H}\sum_{j=0}^{H-1}\sum_{i=0}^{W-1}pSrc(j,i)\]}</pre>
 * <pre>{@code \[StdDev = \sqrt{\frac{1}{W\cdot H}\sum_{j=0}^{H-1}\sum_{i=0}^{W-1}(pSrc(j,i)-Mean)^2}\]}</pre>
 * The Mean_StdDev primitives require additional scratch buffer for computations.
 *  
 * <h3><a name="CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions include:</a></h3>
*
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param nCOI \ref channel_of_interest_number.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer
 *        Use \ref nppiMeanStdDevGetBufferHostSize_8u_C1R to determine the minium number of bytes required.
 * @param pMean Pointer to the computed mean.
 * @param pStdDev Pointer to the computed standard deviation.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_COI_ERROR if an invalid channel of interest is specified.
 * 
 * \{
 */

/**
 * One-channel 8-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * One-channel 8-bit signed image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * One-channel 16-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * One-channel 32-bit floating point image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked one-channel 8-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked one-channel 8-bit signed image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked one-channel 16-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked one-channel 32-bit floating point image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/** \} */

 /** \name Channel Mean_StdDev
 * See \ref channel_of_interest.
 * \{
 */
 
/**
 * Three-channel 8-bit unsigned image Mean_StdDev affecting only single channel.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Three-channel 8-bit signed image Mean_StdDev affecting only single channel.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Three-channel 16-bit unsigned image Mean_StdDev affecting only single channel.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Three-channel 32-bit floating point image Mean_StdDev affecting only single channel.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked three-channel 8-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked three-channel 8-bit signed image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked three-channel 16-bit unsigned image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/**
 * Masked three-channel 32-bit floating point image Mean_StdDev.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevParameters">Common parameters for nppiMean_StdDev functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") BytePointer pDeviceBuffer, @Cast("Npp64f*") DoublePointer pMean, @Cast("Npp64f*") DoublePointer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @Cast("Npp64f*") DoubleBuffer pMean, @Cast("Npp64f*") DoubleBuffer pStdDev );
public static native @Cast("NppStatus") int nppiMean_StdDev_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp8u*") byte[] pDeviceBuffer, @Cast("Npp64f*") double[] pMean, @Cast("Npp64f*") double[] pStdDev );

/** \} */

/** \name MeanStdDevGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Mean_StdDev primitives.
 * 
 * \{
 */
/** 
 * Buffer size for \ref nppiMean_StdDev_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8s_C1R.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_16u_C1R.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_32f_C1R.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8u_C1MR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8s_C1MR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_16u_C1MR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_32f_C1MR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8u_C3CR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8s_C3CR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_16u_C3CR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_32f_C3CR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8u_C3CMR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_8s_C3CMR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_16u_C3CMR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiMean_StdDev_32f_C3CMR.
 * 
 * For common parameter descriptions, see <a href="#CommonMeanStdDevGetBufferHostSizeParameters">Common parameters for nppiMeanStdDevGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiMeanStdDevGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_mean_stddev */

/** \defgroup image_norm Image Norms
 *
 * Primitives for computing the norms of an image, the norms of difference, and the relative errors of two images.
 * Given an image {@code pSrc} with width {@code W} and height {@code H}, 
 * -# The infinity norm (Norm_Inf) is defined as the largest absolute pixel value of the image.
 * -# The L1 norm (Norm_L1) is defined as the sum of the absolute pixel value of the image, i.e., <pre>{@code \[Norm\_L1 = \sum_{j=0}^{H-1}\sum_{i=0}^{W-1}\left| pSrc(j,i)\right|\]}</pre>.
 * -# The L2 norm (Norm_L2) is defined as the square root of the sum of the squared absolute pixel value of the image, i.e.,<pre>{@code \[Norm\_L2 = \sqrt{\sum_{j=0}^{H-1}\sum_{i=0}^{W-1}\left| pSrc(j,i)\right| ^2}\]}</pre>.
 * 
 * Given two images {@code pSrc1} and {@code pSrc2} both with width {@code W} and height {@code H}, 
 * -# The infinity norm of differece (NormDiff_Inf) is defined as the largest absolute difference between pixels of two images.
 * -# The L1 norm of differece (NormDiff_L1) is defined as the sum of the absolute difference between pixels of two images, i.e., <pre>{@code \[NormDiff\_L1 = \sum_{j=0}^{H-1}\sum_{i=0}^{W-1}\left| pSrc1(j,i)-pSrc2(j,i)\right|\]}</pre>.
 * -# The L2 norm of differece (NormDiff_L2) is defined as the squared root of the sum of the squared absolute difference between pixels of two images, i.e.,<pre>{@code \[NormDiff\_L2 = \sqrt{\sum_{j=0}^{H-1}\sum_{i=0}^{W-1}\left| pSrc1(j,i)-pSrc2(j,i)\right| ^2}\]}</pre>.
 * 
 * Given two images {@code pSrc1} and {@code pSrc2} both with width {@code W} and height {@code H}, 
 * -# The relative error for the infinity norm of differece (NormRel_Inf) is defined as NormDiff_Inf divided by the infinity norm of the second image, i.e., <pre>{@code \[NormRel\_Inf = \frac{NormDiff\_Inf}{Norm\_Inf_{src2}}\]}</pre>
 * -# The relative error for the L1 norm of differece (NormRel_L1) is defined as NormDiff_L1 divided by the L1 norm of the second image, i.e., <pre>{@code \[NormRel\_L1 = \frac{NormDiff\_L1}{Norm\_L1_{src2}}\]}</pre>
 * -# The relative error for the L2 norm of differece (NormRel_L2) is defined as NormDiff_L2 divided by the L2 norm of the second image, i.e., <pre>{@code \[NormRel\_L2 = \frac{NormDiff\_L2}{Norm\_L2_{src2}}\]}</pre>
 * 
 * The norm functions require the addition device scratch buffer for the computations.
 * 
 * <h3><a name="CommonNormParameters">Common parameters for nppiNorm functions include:</a></h3>
 *
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param nCOI \ref channel_of_interest_number.
 * @param pNorm Pointer to the norm value.
 * @param pNormDiff Pointer to the computed norm of differences. 
 * @param pNormRel Pointer to the computed relative error for the infinity norm of two images.
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer. 
 *        Use nppiNormInfGetBufferHostSize_XX_XXX to compute the required size (in bytes).
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_COI_ERROR if an invalid channel of interest is specified, or NPP_NOT_EVEN_STEP_ERROR if an invalid floating-point image is specified.
 * 
 * \{
 *
 */ 

/** \defgroup image_inf_norm Norm_Inf
 * Primitives for computing the infinity norm of an image. 
 * \{
 */

/** \name Basic Norm_Inf
 *   
 * \{
 */

/**
 * One-channel 8-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit signed image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32s_C1R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_Inf ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_Inf ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_Inf ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_Inf ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image Norm_Inf.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image Norm_Inf affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image Norm_Inf affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image Norm_Inf affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image Norm_Inf affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_Inf_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */

/** \name NormInfGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Norm_Inf primitives.
 * \{
 */

/** Buffer size for \ref nppiNorm_Inf_8u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16s_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32s_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_C1R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8u_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8s_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_C1MR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8u_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16s_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_C3R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8u_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16s_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_AC4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8u_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16s_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_C4R.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8u_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_8s_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_16u_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_Inf_32f_C3CMR.
 * 
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_inf_norm */


/** \defgroup image_L1_norm Norm_L1
 * Primitives for computing the L1 norm of an image. 
 * \{
 */
/** \name Basic Norm_L1
 * \{
 */ 
/**
 * One-channel 8-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_L1 ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_L1 ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_L1 ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_L1 ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image Norm_L1.
 * 
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image Norm_L1 affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image Norm_L1 affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image Norm_L1 affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image Norm_L1 affecting only single channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormL1 functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L1_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */
 
 /** \name NormL1GetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Norm_L1 primitives.
 * 
 * \{
 */
/** 
 * Buffer size for \ref nppiNorm_L1_8u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16s_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_C1R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8u_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8s_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_C1MR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16s_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_C3R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16s_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_AC4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16s_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_C4R.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8u_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_8s_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_16u_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L1_32f_C3CMR.
 *
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 *
 */
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \}  */
/** \} image_L1_norm */

/** \defgroup image_L2_norm Norm_L2
 * Primitives for computing the L2 norm of an image. 
 * \{
 */
/** \name Basic Norm_L2
 * Computes the L2 norm of an image. 
 * 
 * \{
 */
/**
 * One-channel 8-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_L2 ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_L2 ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_L2 ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_L2 ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image Norm_L2.
 *
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiGetBufferHostSize functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C4R(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);
 
/**
 * Masked one-channel 8-bit unsigned image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.  
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.  
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.  
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C1MR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.  
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C1MR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

 /**
 * Masked three-channel 8-bit unsigned image Norm_L2.
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image Norm_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormMaskL2 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc, int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNorm, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc, int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNorm, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNorm_L2_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc, int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNorm, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */

/** \name NormL2GetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the Norm_L2 primitives.
 * \{
 */
/** 
 * Buffer size for \ref nppiNorm_L2_8u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16s_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8s_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16s_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16s_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16s_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_8s_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_16u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNorm_L2_32f_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_L2_norm */

/** \defgroup image_inf_normdiff NormDiff_Inf
 * Primitives for computing the infinity norm of difference of pixels between two images.
 * \{
 */

/** \name Basic NormDiff_Inf
 * \{
 */
/**
 * One-channel 8-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C1R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C3R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image NormDiff_Inf.
 *
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param aNormDiff Array that contains computed Inf-norm of differences. 
 * @param pDeviceBuffer Pointer to the required device memory allocation, \ref general_scratch_buffer. 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes, or NPP_NOT_EVEN_STEP_ERROR if 
 * an invalid floating-point image is specified.
*/
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_AC4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16s_C4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned images NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed images NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned images NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C1MR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point images NormDiff_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C1MR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image NormDiff_Inf affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image NormDiff_Inf affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image NormDiff_Inf affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                         @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                         @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                         @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image NormDiff_Inf affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffInf functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                         @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                         @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                         @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                         @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                         @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_Inf_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                     @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                     @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */
 
/** \name NormDiffInfGetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the NormDiff_Inf primitives.
 * \{
 */
/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16s_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8s_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16s_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16s_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16s_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_8s_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_16u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Buffer size for \ref nppiNormDiff_Inf_32f_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffInfGetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_inf_normdiff */

/** \defgroup image_L1_normdiff NormDiff_L1
 * Primitives for computing the L1 norm of difference of pixels between two images.
 * \{
 */

/** \name Basic NormDiff_L1
 * \{
 */
/**
 * One-channel 8-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C1R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C3R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_L1 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_L1 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_L1 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_AC4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_L1 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16s_C4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
 */
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C1MR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image NormDiff_L1.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C1MR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image NormDiff_L1 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image NormDiff_L1 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image NormDiff_L1 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image NormDiff_L1 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL1 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L1_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */
 
 /** \name NormDiffL1GetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the NormDiff_L1 primitives.
 * \{
 */
/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16s_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8s_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16s_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16s_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16s_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_8s_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_16u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L1_32f_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL1GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** \} */
/** \} image_L1_normdiff */

/** \defgroup image_L2_normdiff NormDiff_L2
 * Primitives for computing the L2 norm of difference of pixels between two images.
 * \{
 */
/** \name Basic NormDiff_L2
 * \{
 */
/**
 * One-channel 8-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C1R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C3R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_L2 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_L2 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_L2 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_AC4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_L2 ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16s_C4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C1MR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image NormDiff_L2.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C1MR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit unsigned image NormDiff_L2 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8u_C3CMR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 8-bit signed image NormDiff_L2 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_8s_C3CMR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 16-bit unsigned image NormDiff_L2 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_16u_C3CMR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked three-channel 32-bit floating point image NormDiff_L2 affecting only single channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormDiffL2 functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                        @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                        @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                        @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoublePointer pNormDiff, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") DoubleBuffer pNormDiff, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormDiff_L2_32f_C3CMR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                    @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                    @ByVal NppiSize oSizeROI, int nCOI, @Cast("Npp64f*") double[] pNormDiff, @Cast("Npp8u*") byte[] pDeviceBuffer);

/** \} */

/** \name NormDiffL2GetBufferHostSize
 * Companion primitives for computing the device buffer size (in bytes) required by the NormDiff_L2 primitives.
 * \{
 */
/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16s_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_C1R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8s_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_C1MR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C1MR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16s_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_C3R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16s_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_C4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16s_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16s_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_AC4R.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_AC4R(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_8s_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_8s_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_16u_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_16u_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize);

/** 
 * Computes the device scratch buffer size (in bytes) for nppiNormDiff_L2_32f_C3CMR.
 * For common parameter descriptions, see \ref CommonGetBufferHostSizeParameters.
 */
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR_Ctx(@ByVal NppiSize oSizeROI, int[] hpBufferSize, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntPointer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, IntBuffer hpBufferSize);
public static native @Cast("NppStatus") int nppiNormDiffL2GetBufferHostSize_32f_C3CMR(@ByVal NppiSize oSizeROI, int[] hpBufferSize); 

/** \} */
/** \} image_L2_normdiff */

/** \defgroup image_inf_normrel NormRel_Inf
 * Primitives for computing the relative error of infinity norm between two images.
 * \{
 */
/** \name Basic NormRel_Inf
 * \{
 */
/**
 * One-channel 8-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 16-bit signed image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C1R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * One-channel 32-bit floating point image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 8-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 16-bit signed image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C3R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Three-channel 32-bit floating point image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormRel_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormRel_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormRel_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_AC4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormRel_Inf ignoring alpha channel.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 8-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                     @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                     @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                 @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                 @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 16-bit signed image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16s_C4R(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Four-channel 32-bit floating point image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>.
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer aNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer aNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] aNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>. 
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8u_C1MR(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 8-bit signed image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>. 
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR_Ctx(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                      @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                      @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                      @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR(@Cast("const Npp8s*") BytePointer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") BytePointer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR(@Cast("const Npp8s*") ByteBuffer pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") ByteBuffer pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_8s_C1MR(@Cast("const Npp8s*") byte[] pSrc1, int nSrc1Step, 
                                  @Cast("const Npp8s*") byte[] pSrc2, int nSrc2Step, 
                                  @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                  @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 16-bit unsigned image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>. 
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_16u_C1MR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, 
                                   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer);

/**
 * Masked one-channel 32-bit floating point image NormRel_Inf.
 * For common parameter descriptions, see <a href="#CommonNormParameters">Common parameters for nppiNormRelInf functions</a>. 
*/
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoubleBuffer pNormRel, @Cast("Npp8u*") ByteBuffer pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1MR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, 
                                       @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                                       @Cast("const Npp8u*") byte[] pMask, int nMaskStep,
                                       @ByVal NppiSize oSizeROI, @Cast("Npp64f*") double[] pNormRel, @Cast("Npp8u*") byte[] pDeviceBuffer, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1MR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,
                                   @ByVal NppiSize oSizeROI, @Cast("Npp64f*") DoublePointer pNormRel, @Cast("Npp8u*") BytePointer pDeviceBuffer);
public static native @Cast("NppStatus") int nppiNormRel_Inf_32f_C1MR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, 
                                   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                                   @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,
                      