// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class nvblas extends org.bytedeco.cuda.presets.nvblas {
    static { Loader.load(); }

// Parsed from <nvblas.h>

/*
 * Copyright 1993-2019 NVIDIA Corporation. All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(NVBLAS_H_)
// #define NVBLAS_H_
 
// #include "driver_types.h"
// #include "cuComplex.h"   /* import complex data type */
 
// #if defined(__cplusplus)
// #endif

/* GEMM */
public static native void sgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
             @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
             @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void sgemm_(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
             @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
             @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void sgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
             @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
             @Const float[] beta, float[] c, @Const int[] ldc);
public static native void sgemm_(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
             @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
             @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void sgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
             @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
             @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void sgemm_(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
             @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
             @Const float[] beta, float[] c, @Const int[] ldc);

public static native void dgemm_( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dgemm_( String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dgemm_( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
public static native void dgemm_( String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dgemm_( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dgemm_( String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);

public static native void cgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cgemm_(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cgemm_(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cgemm_(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zgemm_(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zgemm_(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zgemm_(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zgemm_(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
public static native void sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void sgemm(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void sgemm(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void sgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void sgemm(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);

public static native void dgemm( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dgemm( String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dgemm( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
public static native void dgemm( String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dgemm( @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dgemm( String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);

public static native void cgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cgemm(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cgemm(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cgemm(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zgemm(String transa, String transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zgemm(String transa, String transb, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zgemm(@Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer transb, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zgemm(String transa, String transb, @Const int[] m, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);  
           
/* SYRK */           
public static native void ssyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyrk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssyrk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyrk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] beta, float[] c, @Const int[] ldc);                    

public static native void dsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyrk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] beta,
           double[] c, @Const int[] ldc);
public static native void dsyrk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyrk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] beta,
           double[] c, @Const int[] ldc);
           
public static native void csyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyrk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csyrk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyrk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
           
public static native void zsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyrk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsyrk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyrk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyrk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
public static native void ssyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyrk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssyrk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyrk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] beta, float[] c, @Const int[] ldc);                    

public static native void dsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyrk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] beta,
           double[] c, @Const int[] ldc);
public static native void dsyrk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyrk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] beta,
           double[] c, @Const int[] ldc);
           
public static native void csyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyrk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csyrk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyrk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
           
public static native void zsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyrk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsyrk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyrk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyrk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);           

/* HERK */ 
public static native void cherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Const FloatPointer beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cherk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Const FloatBuffer beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda, @Const float[] beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cherk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Const FloatPointer beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Const FloatBuffer beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cherk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda, @Const float[] beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
                     
public static native void zherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zherk_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zherk_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zherk_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zherk_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);      
           
public static native void cherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Const FloatPointer beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cherk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Const FloatBuffer beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda, @Const float[] beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cherk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Const FloatPointer beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Const FloatBuffer beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cherk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda, @Const float[] beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
                     
public static native void zherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zherk(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zherk(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zherk(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zherk(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);                 
                
/* TRSM */
public static native void strsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strsm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
public static native void strsm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strsm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
           
public static native void dtrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrsm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);
public static native void dtrsm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrsm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);

public static native void ctrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrsm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
public static native void ctrsm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrsm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
           
public static native void ztrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrsm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
public static native void ztrsm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrsm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrsm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
           
public static native void strsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strsm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
public static native void strsm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strsm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
           
public static native void dtrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrsm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);
public static native void dtrsm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrsm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);

public static native void ctrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrsm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
public static native void ctrsm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrsm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
           
public static native void ztrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrsm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
public static native void ztrsm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrsm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrsm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);           
                                            
/* SYMM */
public static native void ssymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssymm_(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssymm_(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssymm_(String side, String uplo, @Const int[] m, @Const int[] n,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
           
public static native void dsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dsymm_(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
public static native void dsymm_(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsymm_(String side, String uplo, @Const int[] m, @Const int[] n,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
           
public static native void csymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csymm_(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csymm_(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csymm_(String side, String uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
           
public static native void zsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsymm_(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsymm_(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsymm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsymm_(String side, String uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);                    

public static native void ssymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssymm(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssymm(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda, @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda, @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssymm(String side, String uplo, @Const int[] m, @Const int[] n,
           @Const float[] alpha, @Const float[] a, @Const int[] lda, @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
           
public static native void dsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dsymm(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
public static native void dsymm(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda, @Const DoublePointer b, @Const IntPointer ldb,
           @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native void dsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda, @Const DoubleBuffer b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsymm(String side, String uplo, @Const int[] m, @Const int[] n,
           @Const double[] alpha, @Const double[] a, @Const int[] lda, @Const double[] b, @Const int[] ldb,
           @Const double[] beta, double[] c, @Const int[] ldc);
           
public static native void csymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csymm(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csymm(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csymm(String side, String uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta,
           @Cast("cuComplex*") float2 c, @Const int[] ldc);
           
public static native void zsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsymm(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsymm(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsymm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsymm(String side, String uplo, @Const int[] m, @Const int[] n,
           @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta,
           @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);  
           
/* HEMM */ 
public static native void chemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
            @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void chemm_(String side, String uplo, @Const IntBuffer m, @Const IntBuffer n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
            @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void chemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
            @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void chemm_(String side, String uplo, @Const IntPointer m, @Const IntPointer n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
            @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void chemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
            @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void chemm_(String side, String uplo, @Const int[] m, @Const int[] n,
            @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
            @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta, 
            @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zhemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zhemm_(String side, String uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zhemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zhemm_(String side, String uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zhemm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zhemm_(String side, String uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);

/* HEMM with no underscore*/
public static native void chemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void chemm(String side, String uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void chemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void chemm(String side, String uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void chemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void chemm(String side, String uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha, @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb, @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zhemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zhemm(String side, String uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zhemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zhemm(String side, String uplo,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zhemm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zhemm(String side, String uplo,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha, @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb, @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);

/* SYR2K */
public static native void ssyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, 
           @Const FloatPointer a, @Const IntPointer lda, 
           @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyr2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, 
           @Const FloatBuffer a, @Const IntBuffer lda, 
           @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, 
           @Const float[] a, @Const int[] lda, 
           @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssyr2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, 
           @Const FloatPointer a, @Const IntPointer lda, 
           @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, 
           @Const FloatBuffer a, @Const IntBuffer lda, 
           @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyr2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, 
           @Const float[] a, @Const int[] lda, 
           @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);

public static native void dsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, 
           @Const DoublePointer a, @Const IntPointer lda, 
           @Const DoublePointer b, @Const IntPointer ldb, 
           @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyr2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, 
           @Const DoubleBuffer a, @Const IntBuffer lda, 
           @Const DoubleBuffer b, @Const IntBuffer ldb, 
           @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, 
           @Const double[] a, @Const int[] lda, 
           @Const double[] b, @Const int[] ldb, 
           @Const double[] beta,
           double[] c, @Const int[] ldc);
public static native void dsyr2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, 
           @Const DoublePointer a, @Const IntPointer lda, 
           @Const DoublePointer b, @Const IntPointer ldb, 
           @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, 
           @Const DoubleBuffer a, @Const IntBuffer lda, 
           @Const DoubleBuffer b, @Const IntBuffer ldb, 
           @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyr2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, 
           @Const double[] a, @Const int[] lda, 
           @Const double[] b, @Const int[] ldb, 
           @Const double[] beta,
           double[] c, @Const int[] ldc);

public static native void csyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyr2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csyr2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyr2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyr2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsyr2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyr2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyr2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
/* SYR2K no_underscore*/
public static native void ssyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyr2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
public static native void ssyr2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           @Const FloatPointer b, @Const IntPointer ldb,
           @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native void ssyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           @Const FloatBuffer b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native void ssyr2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const float[] alpha, @Const float[] a, @Const int[] lda,
           @Const float[] b, @Const int[] ldb,
           @Const float[] beta, float[] c, @Const int[] ldc);
           
public static native void dsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, 
           @Const DoublePointer a, @Const IntPointer lda, 
           @Const DoublePointer b, @Const IntPointer ldb, 
           @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyr2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, 
           @Const DoubleBuffer a, @Const IntBuffer lda, 
           @Const DoubleBuffer b, @Const IntBuffer ldb, 
           @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, 
           @Const double[] a, @Const int[] lda, 
           @Const double[] b, @Const int[] ldb, 
           @Const double[] beta,
           double[] c, @Const int[] ldc);
public static native void dsyr2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Const DoublePointer alpha, 
           @Const DoublePointer a, @Const IntPointer lda, 
           @Const DoublePointer b, @Const IntPointer ldb, 
           @Const DoublePointer beta,
           DoublePointer c, @Const IntPointer ldc);
public static native void dsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Const DoubleBuffer alpha, 
           @Const DoubleBuffer a, @Const IntBuffer lda, 
           @Const DoubleBuffer b, @Const IntBuffer ldb, 
           @Const DoubleBuffer beta,
           DoubleBuffer c, @Const IntBuffer ldc);
public static native void dsyr2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Const double[] alpha, 
           @Const double[] a, @Const int[] lda, 
           @Const double[] b, @Const int[] ldb, 
           @Const double[] beta,
           double[] c, @Const int[] ldc);
           
public static native void csyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyr2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void csyr2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void csyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void csyr2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Cast("const cuComplex*") float2 beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyr2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zsyr2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zsyr2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zsyr2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,           
           @Cast("const cuDoubleComplex*") double2 beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
/* HERK */
public static native void cher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Const FloatPointer beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cher2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Const float[] beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cher2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Const FloatPointer beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cher2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Const float[] beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zher2k_(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zher2k_(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zher2k_(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zher2k_(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
/* HER2K with no underscore */
public static native void cher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Const FloatPointer beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cher2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Const float[] beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);
public static native void cher2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda,
           @Cast("const cuComplex*") float2 b, @Const IntPointer ldb,
           @Const FloatPointer beta, @Cast("cuComplex*") float2 c, @Const IntPointer ldc);
public static native void cher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda,
           @Cast("const cuComplex*") float2 b, @Const IntBuffer ldb,
           @Const FloatBuffer beta, @Cast("cuComplex*") float2 c, @Const IntBuffer ldc);
public static native void cher2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuComplex*") float2 alpha, 
           @Cast("const cuComplex*") float2 a, @Const int[] lda,
           @Cast("const cuComplex*") float2 b, @Const int[] ldb,
           @Const float[] beta, @Cast("cuComplex*") float2 c, @Const int[] ldc);

public static native void zher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,           
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zher2k(String uplo, String trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,           
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,           
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
public static native void zher2k(String uplo, String trans, @Const IntPointer n, @Const IntPointer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntPointer ldb,           
           @Const DoublePointer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntPointer ldc);
public static native void zher2k(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer trans, @Const IntBuffer n, @Const IntBuffer k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const IntBuffer ldb,           
           @Const DoubleBuffer beta, @Cast("cuDoubleComplex*") double2 c, @Const IntBuffer ldc);
public static native void zher2k(String uplo, String trans, @Const int[] n, @Const int[] k,
           @Cast("const cuDoubleComplex*") double2 alpha, 
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda,
           @Cast("const cuDoubleComplex*") double2 b, @Const int[] ldb,           
           @Const double[] beta, @Cast("cuDoubleComplex*") double2 c, @Const int[] ldc);
           
/* TRMM */
public static native void strmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strmm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
public static native void strmm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strmm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
           
public static native void dtrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrmm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);
public static native void dtrmm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrmm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);

public static native void ctrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrmm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
public static native void ctrmm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrmm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
           
public static native void ztrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrmm_(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
public static native void ztrmm_(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrmm_(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrmm_(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
           
public static native void strmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strmm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
public static native void strmm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Const FloatPointer a, @Const IntPointer lda,
           FloatPointer b, @Const IntPointer ldb);
public static native void strmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Const FloatBuffer a, @Const IntBuffer lda,
           FloatBuffer b, @Const IntBuffer ldb);
public static native void strmm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const float[] alpha, @Const float[] a, @Const int[] lda,
           float[] b, @Const int[] ldb);
           
public static native void dtrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrmm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);
public static native void dtrmm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Const DoublePointer a, @Const IntPointer lda,
           DoublePointer b, @Const IntPointer ldb);
public static native void dtrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Const DoubleBuffer a, @Const IntBuffer lda,
           DoubleBuffer b, @Const IntBuffer ldb);
public static native void dtrmm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Const double[] alpha, @Const double[] a, @Const int[] lda,
           double[] b, @Const int[] ldb);

public static native void ctrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrmm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
public static native void ctrmm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntPointer lda, @Cast("cuComplex*") float2 b, @Const IntPointer ldb);
public static native void ctrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const IntBuffer lda, @Cast("cuComplex*") float2 b, @Const IntBuffer ldb);
public static native void ctrmm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuComplex*") float2 alpha,
           @Cast("const cuComplex*") float2 a, @Const int[] lda, @Cast("cuComplex*") float2 b, @Const int[] ldb);
           
public static native void ztrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrmm(String side, String uplo, String transa, String diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);
public static native void ztrmm(String side, String uplo, String transa, String diag,
           @Const IntPointer m, @Const IntPointer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntPointer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntPointer ldb);
public static native void ztrmm(@Cast("const char*") BytePointer side, @Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag,
           @Const IntBuffer m, @Const IntBuffer n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const IntBuffer lda, @Cast("cuDoubleComplex*") double2 b, @Const IntBuffer ldb);
public static native void ztrmm(String side, String uplo, String transa, String diag,
           @Const int[] m, @Const int[] n, @Cast("const cuDoubleComplex*") double2 alpha,
           @Cast("const cuDoubleComplex*") double2 a, @Const int[] lda, @Cast("cuDoubleComplex*") double2 b, @Const int[] ldb);    
           
                                                                        
// #if defined(__cplusplus)
// #endif /* __cplusplus */

// #endif /* !defined(NVBLAS_H_) */


}
