// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUlaunchAttributeValue extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUlaunchAttributeValue() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUlaunchAttributeValue(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUlaunchAttributeValue(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUlaunchAttributeValue position(long position) {
        return (CUlaunchAttributeValue)super.position(position);
    }
    @Override public CUlaunchAttributeValue getPointer(long i) {
        return new CUlaunchAttributeValue((Pointer)this).offsetAddress(i);
    }

    /** Pad to 64 bytes */
    public native @Cast("char") byte pad(int i); public native CUlaunchAttributeValue pad(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer pad();
    /** Attribute ::CUaccessPolicyWindow. */
    public native @ByRef @Cast("CUaccessPolicyWindow*") CUaccessPolicyWindow_v1 accessPolicyWindow(); public native CUlaunchAttributeValue accessPolicyWindow(CUaccessPolicyWindow_v1 setter);
    /** Nonzero indicates a cooperative kernel (see ::cuLaunchCooperativeKernel). */
    public native int cooperative(); public native CUlaunchAttributeValue cooperative(int setter);
    /** ::CUsynchronizationPolicy for work queued up in this stream */
    public native @Cast("CUsynchronizationPolicy") int syncPolicy(); public native CUlaunchAttributeValue syncPolicy(int setter);
        @Name("clusterDim.x") public native @Cast("unsigned int") int clusterDim_x(); public native CUlaunchAttributeValue clusterDim_x(int setter);
        @Name("clusterDim.y") public native @Cast("unsigned int") int clusterDim_y(); public native CUlaunchAttributeValue clusterDim_y(int setter);
        @Name("clusterDim.z") public native @Cast("unsigned int") int clusterDim_z(); public native CUlaunchAttributeValue clusterDim_z(int setter);
    /** Cluster scheduling policy preference for the kernel node. */
    public native @Cast("CUclusterSchedulingPolicy") int clusterSchedulingPolicyPreference(); public native CUlaunchAttributeValue clusterSchedulingPolicyPreference(int setter);
    public native int programmaticStreamSerializationAllowed(); public native CUlaunchAttributeValue programmaticStreamSerializationAllowed(int setter);
        @Name("programmaticEvent.event") public native CUevent_st programmaticEvent_event(); public native CUlaunchAttributeValue programmaticEvent_event(CUevent_st setter);
        @Name("programmaticEvent.flags") public native int programmaticEvent_flags(); public native CUlaunchAttributeValue programmaticEvent_flags(int setter);                      /* Does not accept ::CU_EVENT_RECORD_EXTERNAL */
        @Name("programmaticEvent.triggerAtBlockStart") public native int programmaticEvent_triggerAtBlockStart(); public native CUlaunchAttributeValue programmaticEvent_triggerAtBlockStart(int setter);
    /** Execution priority of the kernel. */
    public native int priority(); public native CUlaunchAttributeValue priority(int setter);
    public native @ByRef CUlaunchMemSyncDomainMap memSyncDomainMap(); public native CUlaunchAttributeValue memSyncDomainMap(CUlaunchMemSyncDomainMap setter);
    public native @Cast("CUlaunchMemSyncDomain") int memSyncDomain(); public native CUlaunchAttributeValue memSyncDomain(int setter);
}
