// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUlaunchConfig extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUlaunchConfig() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUlaunchConfig(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUlaunchConfig(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUlaunchConfig position(long position) {
        return (CUlaunchConfig)super.position(position);
    }
    @Override public CUlaunchConfig getPointer(long i) {
        return new CUlaunchConfig((Pointer)this).offsetAddress(i);
    }

    /** Width of grid in blocks */
    public native @Cast("unsigned int") int gridDimX(); public native CUlaunchConfig gridDimX(int setter);
    /** Height of grid in blocks */
    public native @Cast("unsigned int") int gridDimY(); public native CUlaunchConfig gridDimY(int setter);
    /** Depth of grid in blocks */
    public native @Cast("unsigned int") int gridDimZ(); public native CUlaunchConfig gridDimZ(int setter);
    /** X dimension of each thread block */
    public native @Cast("unsigned int") int blockDimX(); public native CUlaunchConfig blockDimX(int setter);
    /** Y dimension of each thread block */
    public native @Cast("unsigned int") int blockDimY(); public native CUlaunchConfig blockDimY(int setter);
    /** Z dimension of each thread block */
    public native @Cast("unsigned int") int blockDimZ(); public native CUlaunchConfig blockDimZ(int setter);
    /** Dynamic shared-memory size per thread block in bytes */
    public native @Cast("unsigned int") int sharedMemBytes(); public native CUlaunchConfig sharedMemBytes(int setter);
    /** Stream identifier */
    public native CUstream_st hStream(); public native CUlaunchConfig hStream(CUstream_st setter);
    /** nullable if numAttrs == 0 */
    public native CUlaunchAttribute attrs(); public native CUlaunchConfig attrs(CUlaunchAttribute setter);
    /** number of attributes populated in attrs */
    public native @Cast("unsigned int") int numAttrs(); public native CUlaunchConfig numAttrs(int setter);
}
