// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cusolver.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cusparse.*;
import static org.bytedeco.cuda.global.cusparse.*;

public class cusolver extends org.bytedeco.cuda.presets.cusolver {
    static { Loader.load(); }

// Parsed from <cusolver_common.h>

/*
 * Copyright 2014 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(CUSOLVER_COMMON_H_)
//   #define CUSOLVER_COMMON_H_

//   #include "library_types.h"

//   #ifndef CUSOLVERAPI
//     #ifdef _WIN32
//       #define CUSOLVERAPI __stdcall
//     #else
//       #define CUSOLVERAPI
//     #endif
//   #endif

//   #if defined(_MSC_VER)
//   #else
//     #include <inttypes.h>
//   #endif

  public static final int CUSOLVER_VER_MAJOR = 11;
  public static final int CUSOLVER_VER_MINOR = 4;
  public static final int CUSOLVER_VER_PATCH = 5;
  public static final int CUSOLVER_VER_BUILD = 107;
  public static final int CUSOLVER_VERSION =                                                     
      (CUSOLVER_VER_MAJOR * 1000 + CUSOLVER_VER_MINOR * 100 + CUSOLVER_VER_PATCH);

  /*
   * disable this macro to proceed old API
   */
//   #define DISABLE_CUSOLVER_DEPRECATED

//------------------------------------------------------------------------------

//   #if !defined(_MSC_VER)
//     #define CUSOLVER_CPP_VERSION __cplusplus
//   #elif _MSC_FULL_VER >= 190024210 // Visual Studio 2015 Update 3
//     #define CUSOLVER_CPP_VERSION _MSVC_LANG
//   #else
//     #define CUSOLVER_CPP_VERSION 0
//   #endif

//------------------------------------------------------------------------------

//   #if !defined(DISABLE_CUSOLVER_DEPRECATED)

//     #if CUSOLVER_CPP_VERSION >= 201402L

//       #define CUSOLVER_DEPRECATED(new_func)
//         [[deprecated("please use " #new_func " instead")]]

//     #elif defined(_MSC_VER)

//       #define CUSOLVER_DEPRECATED(new_func)
//         __declspec(deprecated("please use " #new_func " instead"))

//     #elif defined(__INTEL_COMPILER) || defined(__clang__) ||
//       (defined(__GNUC__) &&
//        (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5)))

//       #define CUSOLVER_DEPRECATED(new_func)
//         __attribute__((deprecated("please use " #new_func " instead")))

//     #elif defined(__GNUC__) || defined(__xlc__)

//       #define CUSOLVER_DEPRECATED(new_func) __attribute__((deprecated))

//     #else

//       #define CUSOLVER_DEPRECATED(new_func)

//     #endif // defined(__cplusplus) && __cplusplus >= 201402L
  //------------------------------------------------------------------------------

//     #if CUSOLVER_CPP_VERSION >= 201703L

//       #define CUSOLVER_DEPRECATED_ENUM(new_enum)
//         [[deprecated("please use " #new_enum " instead")]]

//     #elif defined(__clang__) ||
//       (defined(__GNUC__) && __GNUC__ >= 6 && !defined(__PGI))

//       #define CUSOLVER_DEPRECATED_ENUM(new_enum)
//         __attribute__((deprecated("please use " #new_enum " instead")))

//     #else

//       #define CUSOLVER_DEPRECATED_ENUM(new_enum)

//     #endif // defined(__cplusplus) && __cplusplus >= 201402L

//   #else // defined(DISABLE_CUSOLVER_DEPRECATED)

//     #define CUSOLVER_DEPRECATED(new_func)
//     #define CUSOLVER_DEPRECATED_ENUM(new_enum)

//   #endif // !defined(DISABLE_CUSOLVER_DEPRECATED)

//   #undef CUSOLVER_CPP_VERSION

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

  /** enum cusolverStatus_t */
  public static final int
    CUSOLVER_STATUS_SUCCESS = 0,
    CUSOLVER_STATUS_NOT_INITIALIZED = 1,
    CUSOLVER_STATUS_ALLOC_FAILED = 2,
    CUSOLVER_STATUS_INVALID_VALUE = 3,
    CUSOLVER_STATUS_ARCH_MISMATCH = 4,
    CUSOLVER_STATUS_MAPPING_ERROR = 5,
    CUSOLVER_STATUS_EXECUTION_FAILED = 6,
    CUSOLVER_STATUS_INTERNAL_ERROR = 7,
    CUSOLVER_STATUS_MATRIX_TYPE_NOT_SUPPORTED = 8,
    CUSOLVER_STATUS_NOT_SUPPORTED = 9,
    CUSOLVER_STATUS_ZERO_PIVOT = 10,
    CUSOLVER_STATUS_INVALID_LICENSE = 11,
    CUSOLVER_STATUS_IRS_PARAMS_NOT_INITIALIZED = 12,
    CUSOLVER_STATUS_IRS_PARAMS_INVALID = 13,
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_PREC = 14,
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_REFINE = 15,
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_MAXITER = 16,
    CUSOLVER_STATUS_IRS_INTERNAL_ERROR = 20,
    CUSOLVER_STATUS_IRS_NOT_SUPPORTED = 21,
    CUSOLVER_STATUS_IRS_OUT_OF_RANGE = 22,
    CUSOLVER_STATUS_IRS_NRHS_NOT_SUPPORTED_FOR_REFINE_GMRES = 23,
    CUSOLVER_STATUS_IRS_INFOS_NOT_INITIALIZED = 25,
    CUSOLVER_STATUS_IRS_INFOS_NOT_DESTROYED = 26,
    CUSOLVER_STATUS_IRS_MATRIX_SINGULAR = 30,
    CUSOLVER_STATUS_INVALID_WORKSPACE = 31;

  /** enum cusolverEigType_t */
  public static final int
    CUSOLVER_EIG_TYPE_1 = 1,
    CUSOLVER_EIG_TYPE_2 = 2,
    CUSOLVER_EIG_TYPE_3 = 3;

  /** enum cusolverEigMode_t */
  public static final int
    CUSOLVER_EIG_MODE_NOVECTOR = 0,
    CUSOLVER_EIG_MODE_VECTOR = 1;

  /** enum cusolverEigRange_t */
  public static final int
    CUSOLVER_EIG_RANGE_ALL = 1001,
    CUSOLVER_EIG_RANGE_I = 1002,
    CUSOLVER_EIG_RANGE_V = 1003;

  /** enum cusolverNorm_t */
  public static final int
    CUSOLVER_INF_NORM = 104,
    CUSOLVER_MAX_NORM = 105,
    CUSOLVER_ONE_NORM = 106,
    CUSOLVER_FRO_NORM = 107;

  /** enum cusolverIRSRefinement_t */
  public static final int
    CUSOLVER_IRS_REFINE_NOT_SET = 1100,
    CUSOLVER_IRS_REFINE_NONE = 1101,
    CUSOLVER_IRS_REFINE_CLASSICAL = 1102,
    CUSOLVER_IRS_REFINE_CLASSICAL_GMRES = 1103,
    CUSOLVER_IRS_REFINE_GMRES = 1104,
    CUSOLVER_IRS_REFINE_GMRES_GMRES = 1105,
    CUSOLVER_IRS_REFINE_GMRES_NOPCOND = 1106,

    CUSOLVER_PREC_DD = 1150,
    CUSOLVER_PREC_SS = 1151,
    CUSOLVER_PREC_SHT = 1152;

  /** enum cusolverPrecType_t */
  public static final int
    CUSOLVER_R_8I = 1201,
    CUSOLVER_R_8U = 1202,
    CUSOLVER_R_64F = 1203,
    CUSOLVER_R_32F = 1204,
    CUSOLVER_R_16F = 1205,
    CUSOLVER_R_16BF = 1206,
    CUSOLVER_R_TF32 = 1207,
    CUSOLVER_R_AP = 1208,
    CUSOLVER_C_8I = 1211,
    CUSOLVER_C_8U = 1212,
    CUSOLVER_C_64F = 1213,
    CUSOLVER_C_32F = 1214,
    CUSOLVER_C_16F = 1215,
    CUSOLVER_C_16BF = 1216,
    CUSOLVER_C_TF32 = 1217,
    CUSOLVER_C_AP = 1218;

  /** enum cusolverAlgMode_t */
  public static final int
    CUSOLVER_ALG_0 = 0, /* default algorithm */
    CUSOLVER_ALG_1 = 1,
    CUSOLVER_ALG_2 = 2;

  /** enum cusolverStorevMode_t */
  public static final int
    CUBLAS_STOREV_COLUMNWISE = 0,
    CUBLAS_STOREV_ROWWISE = 1;

  /** enum cusolverDirectMode_t */
  public static final int
    CUBLAS_DIRECT_FORWARD = 0,
    CUBLAS_DIRECT_BACKWARD = 1;

  public static native @Cast("cusolverStatus_t") int cusolverGetProperty(@Cast("libraryPropertyType") int type, IntPointer value);
  public static native @Cast("cusolverStatus_t") int cusolverGetProperty(@Cast("libraryPropertyType") int type, IntBuffer value);
  public static native @Cast("cusolverStatus_t") int cusolverGetProperty(@Cast("libraryPropertyType") int type, int[] value);

  public static native @Cast("cusolverStatus_t") int cusolverGetVersion(IntPointer version);
  public static native @Cast("cusolverStatus_t") int cusolverGetVersion(IntBuffer version);
  public static native @Cast("cusolverStatus_t") int cusolverGetVersion(int[] version);

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

// #endif // CUSOLVER_COMMON_H_


// Parsed from <cusolverDn.h>

/*
 * Copyright 2014 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cuSolverDN : Dense Linear Algebra Library

*/

// #if !defined(CUSOLVERDN_H_)
//   #define CUSOLVERDN_H_
// Targeting ../cusolver/cusolverDnContext.java


// Targeting ../cusolver/syevjInfo.java


// Targeting ../cusolver/gesvdjInfo.java


// Targeting ../cusolver/cusolverDnIRSParams.java


// Targeting ../cusolver/cusolverDnIRSInfos.java


// Targeting ../cusolver/cusolverDnParams.java



/** enum cusolverDnFunction_t */
public static final int
  CUSOLVERDN_GETRF = 0,
  CUSOLVERDN_POTRF = 1;

//   #include <stdio.h>

//   #include "cuComplex.h" /* import complex data type */
//   #include "cublas_api.h"
//   #include "cusolver_common.h"

  /*******************************************************************************/
//   #ifdef __cplusplus
//   #endif

  public static native @Cast("cusolverStatus_t") int cusolverDnCreate(@ByPtrPtr cusolverDnContext handle);
  public static native @Cast("cusolverStatus_t") int cusolverDnDestroy(cusolverDnContext handle);
  public static native @Cast("cusolverStatus_t") int cusolverDnSetStream(cusolverDnContext handle, CUstream_st streamId);
  public static native @Cast("cusolverStatus_t") int cusolverDnGetStream(cusolverDnContext handle, @ByPtrPtr CUstream_st streamId);

  //============================================================
  // IRS headers
  //============================================================

  // =============================================================================
  // IRS helper function API
  // =============================================================================
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsCreate(@ByPtrPtr cusolverDnIRSParams params_ptr);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsDestroy(cusolverDnIRSParams params);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetRefinementSolver(
      cusolverDnIRSParams params,
      @Cast("cusolverIRSRefinement_t") int refinement_solver);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetSolverMainPrecision(
      cusolverDnIRSParams params,
      @Cast("cusolverPrecType_t") int solver_main_precision);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetSolverLowestPrecision(
      cusolverDnIRSParams params,
      @Cast("cusolverPrecType_t") int solver_lowest_precision);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetSolverPrecisions(
      cusolverDnIRSParams params,
      @Cast("cusolverPrecType_t") int solver_main_precision,
      @Cast("cusolverPrecType_t") int solver_lowest_precision);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetTol(cusolverDnIRSParams params, double val);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetTolInner(cusolverDnIRSParams params, double val);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetMaxIters(
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t") int maxiters);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsSetMaxItersInner(
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t") int maxiters_inner);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsGetMaxIters(
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t*") IntPointer maxiters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsGetMaxIters(
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t*") IntBuffer maxiters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsGetMaxIters(
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t*") int[] maxiters);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsEnableFallback(cusolverDnIRSParams params);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSParamsDisableFallback(cusolverDnIRSParams params);

  // =============================================================================
  // cusolverDnIRSInfos prototypes
  // =============================================================================
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosDestroy(cusolverDnIRSInfos infos);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosCreate(@ByPtrPtr cusolverDnIRSInfos infos_ptr);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntPointer niters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntBuffer niters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") int[] niters);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetOuterNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntPointer outer_niters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetOuterNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntBuffer outer_niters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetOuterNiters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") int[] outer_niters);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosRequestResidual(cusolverDnIRSInfos infos);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetResidualHistory(
      cusolverDnIRSInfos infos,
      @Cast("void**") PointerPointer residual_history);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetResidualHistory(
      cusolverDnIRSInfos infos,
      @Cast("void**") @ByPtrPtr Pointer residual_history);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetMaxIters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntPointer maxiters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetMaxIters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") IntBuffer maxiters);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSInfosGetMaxIters(
      cusolverDnIRSInfos infos,
      @Cast("cusolver_int_t*") int[] maxiters);

  //============================================================
  //  IRS functions API
  //============================================================

  /*******************************************************************************/ /*
                                                                                     * [ZZ, ZC, ZK, ZE, ZY, CC, CK, CE, CY, DD, DS, DH, DB, DX, SS, SH, SB, SX]gesv
                                                                                     * users API Prototypes */
  /*******************************************************************************/
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  /*******************************************************************************/

  /*******************************************************************************/ /*
                                                                                     * [ZZ, ZC, ZK, ZE, ZY, CC, CK, CE, CY, DD, DS, DH, DB, DX, SS, SH, SB, SX]gesv_bufferSize
                                                                                     * users API Prototypes */
  /*******************************************************************************/
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntPointer dipiv,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") IntBuffer dipiv,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgesv_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cusolver_int_t*") int[] dipiv,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  /*******************************************************************************/

  /*******************************************************************************/ /*
                                                                                     * [ZZ, ZC, ZK, ZE, ZY, CC, CK, CE, CY, DD, DS, DH, DB, DX, SS, SH, SB, SX]gels
                                                                                     * users API Prototypes */
  /*******************************************************************************/
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCCgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCKgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCEgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCYgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer iter,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer iter,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] iter,
      @Cast("cusolver_int_t*") int[] d_info);
  /*******************************************************************************/

  /*******************************************************************************/ /*
                                                                                     * [ZZ, ZC, ZK, ZE, ZY, CC, CK, CE, CY, DD, DS, DH, DB, DX, SS, SH, SB, SX]gels_bufferSize
                                                                                     * API prototypes */
  /*******************************************************************************/
  public static native @Cast("cusolverStatus_t") int cusolverDnZZgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZCgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZKgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZEgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnZYgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuDoubleComplex*") double2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuDoubleComplex*") double2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuDoubleComplex*") double2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCCgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCKgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCEgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnCYgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("cuComplex*") float2 dA,
      @Cast("cusolver_int_t") int ldda,
      @Cast("cuComplex*") float2 dB,
      @Cast("cusolver_int_t") int lddb,
      @Cast("cuComplex*") float2 dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDDgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoublePointer dA,
      @Cast("cusolver_int_t") int ldda,
      DoublePointer dB,
      @Cast("cusolver_int_t") int lddb,
      DoublePointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      DoubleBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      DoubleBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      DoubleBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnDXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      double[] dA,
      @Cast("cusolver_int_t") int ldda,
      double[] dB,
      @Cast("cusolver_int_t") int lddb,
      double[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSSgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSHgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSBgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatPointer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatPointer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatPointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      FloatBuffer dA,
      @Cast("cusolver_int_t") int ldda,
      FloatBuffer dB,
      @Cast("cusolver_int_t") int lddb,
      FloatBuffer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  public static native @Cast("cusolverStatus_t") int cusolverDnSXgels_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      float[] dA,
      @Cast("cusolver_int_t") int ldda,
      float[] dB,
      @Cast("cusolver_int_t") int lddb,
      float[] dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  /*******************************************************************************/

  /*******************************************************************************/ /*
                                                                                     * expert users API for IRS Prototypes
                                                                                     * */
  /*******************************************************************************/
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgesv(
      cusolverDnContext handle,
      cusolverDnIRSParams gesv_irs_params,
      cusolverDnIRSInfos gesv_irs_infos,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer niters,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgesv(
      cusolverDnContext handle,
      cusolverDnIRSParams gesv_irs_params,
      cusolverDnIRSInfos gesv_irs_infos,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer niters,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgesv(
      cusolverDnContext handle,
      cusolverDnIRSParams gesv_irs_params,
      cusolverDnIRSInfos gesv_irs_infos,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] niters,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgesv_bufferSize(
      cusolverDnContext handle,
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("size_t*") SizeTPointer lwork_bytes);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgels(
      cusolverDnContext handle,
      cusolverDnIRSParams gels_irs_params,
      cusolverDnIRSInfos gels_irs_infos,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntPointer niters,
      @Cast("cusolver_int_t*") IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgels(
      cusolverDnContext handle,
      cusolverDnIRSParams gels_irs_params,
      cusolverDnIRSInfos gels_irs_infos,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") IntBuffer niters,
      @Cast("cusolver_int_t*") IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgels(
      cusolverDnContext handle,
      cusolverDnIRSParams gels_irs_params,
      cusolverDnIRSInfos gels_irs_infos,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      Pointer dA,
      @Cast("cusolver_int_t") int ldda,
      Pointer dB,
      @Cast("cusolver_int_t") int lddb,
      Pointer dX,
      @Cast("cusolver_int_t") int lddx,
      Pointer dWorkspace,
      @Cast("size_t") long lwork_bytes,
      @Cast("cusolver_int_t*") int[] niters,
      @Cast("cusolver_int_t*") int[] d_info);

  public static native @Cast("cusolverStatus_t") int cusolverDnIRSXgels_bufferSize(
      cusolverDnContext handle,
      cusolverDnIRSParams params,
      @Cast("cusolver_int_t") int m,
      @Cast("cusolver_int_t") int n,
      @Cast("cusolver_int_t") int nrhs,
      @Cast("size_t*") SizeTPointer lwork_bytes);
  /*******************************************************************************/

  /* Cholesky factorization and its solver */
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const FloatPointer A,
      int lda,
      FloatPointer B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const FloatBuffer A,
      int lda,
      FloatBuffer B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const float[] A,
      int lda,
      float[] B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const DoublePointer A,
      int lda,
      DoublePointer B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const DoubleBuffer A,
      int lda,
      DoubleBuffer B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Const double[] A,
      int lda,
      double[] B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      int[] devInfo);

  /* batched Cholesky factorization and its solver */
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("float**") PointerPointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr FloatPointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr FloatBuffer Aarray,
      int lda,
      IntBuffer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr float[] Aarray,
      int lda,
      int[] infoArray,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("double**") PointerPointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr DoublePointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr DoubleBuffer Aarray,
      int lda,
      IntBuffer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @ByPtrPtr double[] Aarray,
      int lda,
      int[] infoArray,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex**") PointerPointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex**") @ByPtrPtr float2 Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex**") @ByPtrPtr float2 Aarray,
      int lda,
      IntBuffer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex**") @ByPtrPtr float2 Aarray,
      int lda,
      int[] infoArray,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex**") PointerPointer Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 Aarray,
      int lda,
      IntPointer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 Aarray,
      int lda,
      IntBuffer infoArray,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrfBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 Aarray,
      int lda,
      int[] infoArray,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("float**") PointerPointer A,
      int lda,
      @Cast("float**") PointerPointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr FloatPointer A,
      int lda,
      @ByPtrPtr FloatPointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr FloatBuffer A,
      int lda,
      @ByPtrPtr FloatBuffer B,
      int ldb,
      IntBuffer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr float[] A,
      int lda,
      @ByPtrPtr float[] B,
      int ldb,
      int[] d_info,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("double**") PointerPointer A,
      int lda,
      @Cast("double**") PointerPointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr DoublePointer A,
      int lda,
      @ByPtrPtr DoublePointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr DoubleBuffer A,
      int lda,
      @ByPtrPtr DoubleBuffer B,
      int ldb,
      IntBuffer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @ByPtrPtr double[] A,
      int lda,
      @ByPtrPtr double[] B,
      int ldb,
      int[] d_info,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuComplex**") PointerPointer A,
      int lda,
      @Cast("cuComplex**") PointerPointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuComplex**") @ByPtrPtr float2 A,
      int lda,
      @Cast("cuComplex**") @ByPtrPtr float2 B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuComplex**") @ByPtrPtr float2 A,
      int lda,
      @Cast("cuComplex**") @ByPtrPtr float2 B,
      int ldb,
      IntBuffer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuComplex**") @ByPtrPtr float2 A,
      int lda,
      @Cast("cuComplex**") @ByPtrPtr float2 B,
      int ldb,
      int[] d_info,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuDoubleComplex**") PointerPointer A,
      int lda,
      @Cast("cuDoubleComplex**") PointerPointer B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 A,
      int lda,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 B,
      int ldb,
      IntPointer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 A,
      int lda,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 B,
      int ldb,
      IntBuffer d_info,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotrsBatched(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 A,
      int lda,
      @Cast("cuDoubleComplex**") @ByPtrPtr double2 B,
      int ldb,
      int[] d_info,
      int batchSize);

  /* s.p.d. matrix inversion (POTRI) and auxiliary routines (TRTRI and LAUUM) */
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZpotri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnXtrtri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("cublasDiagType_t") int diag,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXtrtri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("cublasDiagType_t") int diag,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnXtrtri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("cublasDiagType_t") int diag,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnXtrtri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("cublasDiagType_t") int diag,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] devInfo);

  /* lauum, auxiliar routine for s.p.d matrix inversion */
  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnClauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnClauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnClauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnClauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnClauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnClauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlauum(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] devInfo);

  /* LU Factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      FloatPointer A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      float[] A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      DoublePointer A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      double[] A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer Workspace,
      IntPointer devIpiv,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer Workspace,
      IntBuffer devIpiv,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      float[] A,
      int lda,
      float[] Workspace,
      int[] devIpiv,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer Workspace,
      IntPointer devIpiv,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer Workspace,
      IntBuffer devIpiv,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      double[] A,
      int lda,
      double[] Workspace,
      int[] devIpiv,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      IntPointer devIpiv,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      IntBuffer devIpiv,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 Workspace,
      int[] devIpiv,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      IntPointer devIpiv,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      IntBuffer devIpiv,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int[] devIpiv,
      int[] devInfo);

  /* Row pivoting */
  public static native @Cast("cusolverStatus_t") int cusolverDnSlaswp(
      cusolverDnContext handle,
      int n,
      FloatPointer A,
      int lda,
      int k1,
      int k2,
      @Const IntPointer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlaswp(
      cusolverDnContext handle,
      int n,
      FloatBuffer A,
      int lda,
      int k1,
      int k2,
      @Const IntBuffer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnSlaswp(
      cusolverDnContext handle,
      int n,
      float[] A,
      int lda,
      int k1,
      int k2,
      @Const int[] devIpiv,
      int incx);

  public static native @Cast("cusolverStatus_t") int cusolverDnDlaswp(
      cusolverDnContext handle,
      int n,
      DoublePointer A,
      int lda,
      int k1,
      int k2,
      @Const IntPointer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlaswp(
      cusolverDnContext handle,
      int n,
      DoubleBuffer A,
      int lda,
      int k1,
      int k2,
      @Const IntBuffer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnDlaswp(
      cusolverDnContext handle,
      int n,
      double[] A,
      int lda,
      int k1,
      int k2,
      @Const int[] devIpiv,
      int incx);

  public static native @Cast("cusolverStatus_t") int cusolverDnClaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int k1,
      int k2,
      @Const IntPointer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnClaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int k1,
      int k2,
      @Const IntBuffer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnClaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int k1,
      int k2,
      @Const int[] devIpiv,
      int incx);

  public static native @Cast("cusolverStatus_t") int cusolverDnZlaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int k1,
      int k2,
      @Const IntPointer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int k1,
      int k2,
      @Const IntBuffer devIpiv,
      int incx);
  public static native @Cast("cusolverStatus_t") int cusolverDnZlaswp(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int k1,
      int k2,
      @Const int[] devIpiv,
      int incx);

  /* LU solve */
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const FloatPointer A,
      int lda,
      @Const IntPointer devIpiv,
      FloatPointer B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const FloatBuffer A,
      int lda,
      @Const IntBuffer devIpiv,
      FloatBuffer B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const float[] A,
      int lda,
      @Const int[] devIpiv,
      float[] B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const DoublePointer A,
      int lda,
      @Const IntPointer devIpiv,
      DoublePointer B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const DoubleBuffer A,
      int lda,
      @Const IntBuffer devIpiv,
      DoubleBuffer B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Const double[] A,
      int lda,
      @Const int[] devIpiv,
      double[] B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const IntPointer devIpiv,
      @Cast("cuComplex*") float2 B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const IntBuffer devIpiv,
      @Cast("cuComplex*") float2 B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const int[] devIpiv,
      @Cast("cuComplex*") float2 B,
      int ldb,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const IntPointer devIpiv,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const IntBuffer devIpiv,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgetrs(
      cusolverDnContext handle,
      @Cast("cublasOperation_t") int trans,
      int n,
      int nrhs,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const int[] devIpiv,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      int[] devInfo);

  /* QR factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      FloatPointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      float[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      DoublePointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      double[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer TAU,
      FloatPointer Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer TAU,
      FloatBuffer Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      float[] A,
      int lda,
      float[] TAU,
      float[] Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer TAU,
      DoublePointer Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer TAU,
      DoubleBuffer Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      double[] A,
      int lda,
      double[] TAU,
      double[] Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 TAU,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 TAU,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 TAU,
      @Cast("cuComplex*") float2 Workspace,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 TAU,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 TAU,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgeqrf(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 TAU,
      @Cast("cuDoubleComplex*") double2 Workspace,
      int Lwork,
      int[] devInfo);

  /* generate unitary matrix Q from QR factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const float[] A,
      int lda,
      @Const float[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Const double[] A,
      int lda,
      @Const double[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      float[] A,
      int lda,
      @Const float[] tau,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      double[] A,
      int lda,
      @Const double[] tau,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungqr(
      cusolverDnContext handle,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* compute Q**T*b in solve min||A*x = b|| */
  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      @Const FloatPointer C,
      int ldc,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      @Const FloatBuffer C,
      int ldc,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const float[] A,
      int lda,
      @Const float[] tau,
      @Const float[] C,
      int ldc,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      @Const DoublePointer C,
      int ldc,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      @Const DoubleBuffer C,
      int ldc,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const double[] A,
      int lda,
      @Const double[] tau,
      @Const double[] C,
      int ldc,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("const cuComplex*") float2 C,
      int ldc,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("const cuComplex*") float2 C,
      int ldc,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("const cuComplex*") float2 C,
      int ldc,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("const cuDoubleComplex*") double2 C,
      int ldc,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("const cuDoubleComplex*") double2 C,
      int ldc,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("const cuDoubleComplex*") double2 C,
      int ldc,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      FloatPointer C,
      int ldc,
      FloatPointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      FloatBuffer C,
      int ldc,
      FloatBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const float[] A,
      int lda,
      @Const float[] tau,
      float[] C,
      int ldc,
      float[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      DoublePointer C,
      int ldc,
      DoublePointer work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      DoubleBuffer C,
      int ldc,
      DoubleBuffer work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDormqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Const double[] A,
      int lda,
      @Const double[] tau,
      double[] C,
      int ldc,
      double[] work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 C,
      int ldc,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 C,
      int ldc,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 C,
      int ldc,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 C,
      int ldc,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 C,
      int ldc,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZunmqr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      @Cast("cublasOperation_t") int trans,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 C,
      int ldc,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] devInfo);

  /* L*D*L**T,U*D*U**T factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      FloatPointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      float[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      DoublePointer A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      double[] A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf_bufferSize(
      cusolverDnContext handle,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      IntPointer ipiv,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      IntBuffer ipiv,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      int[] ipiv,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      IntPointer ipiv,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      IntBuffer ipiv,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      int[] ipiv,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntPointer ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      IntBuffer ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      int[] ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntPointer ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      IntBuffer ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytrf(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      int[] ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* Symmetric indefinite solve (SYTRS) */
  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") long[] ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsytrs(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") long[] ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* Symmetric indefinite inversion (sytri) */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      @Const IntPointer ipiv,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      @Const IntBuffer ipiv,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      @Const int[] ipiv,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      @Const IntPointer ipiv,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      @Const IntBuffer ipiv,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      @Const int[] ipiv,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const IntPointer ipiv,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const IntBuffer ipiv,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const int[] ipiv,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const IntPointer ipiv,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const IntBuffer ipiv,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const int[] ipiv,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      @Const IntPointer ipiv,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      @Const IntBuffer ipiv,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      @Const int[] ipiv,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      @Const IntPointer ipiv,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      @Const IntBuffer ipiv,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      @Const int[] ipiv,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const IntPointer ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const IntBuffer ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Const int[] ipiv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const IntPointer ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const IntBuffer ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZsytri(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Const int[] ipiv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* bidiagonal factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer Lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] Lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer D,
      FloatPointer E,
      FloatPointer TAUQ,
      FloatPointer TAUP,
      FloatPointer Work,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer D,
      FloatBuffer E,
      FloatBuffer TAUQ,
      FloatBuffer TAUP,
      FloatBuffer Work,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      float[] A,
      int lda,
      float[] D,
      float[] E,
      float[] TAUQ,
      float[] TAUP,
      float[] Work,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer D,
      DoublePointer E,
      DoublePointer TAUQ,
      DoublePointer TAUP,
      DoublePointer Work,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer D,
      DoubleBuffer E,
      DoubleBuffer TAUQ,
      DoubleBuffer TAUP,
      DoubleBuffer Work,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      double[] A,
      int lda,
      double[] D,
      double[] E,
      double[] TAUQ,
      double[] TAUP,
      double[] Work,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer D,
      FloatPointer E,
      @Cast("cuComplex*") float2 TAUQ,
      @Cast("cuComplex*") float2 TAUP,
      @Cast("cuComplex*") float2 Work,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer D,
      FloatBuffer E,
      @Cast("cuComplex*") float2 TAUQ,
      @Cast("cuComplex*") float2 TAUP,
      @Cast("cuComplex*") float2 Work,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] D,
      float[] E,
      @Cast("cuComplex*") float2 TAUQ,
      @Cast("cuComplex*") float2 TAUP,
      @Cast("cuComplex*") float2 Work,
      int Lwork,
      int[] devInfo);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer D,
      DoublePointer E,
      @Cast("cuDoubleComplex*") double2 TAUQ,
      @Cast("cuDoubleComplex*") double2 TAUP,
      @Cast("cuDoubleComplex*") double2 Work,
      int Lwork,
      IntPointer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer D,
      DoubleBuffer E,
      @Cast("cuDoubleComplex*") double2 TAUQ,
      @Cast("cuDoubleComplex*") double2 TAUP,
      @Cast("cuDoubleComplex*") double2 Work,
      int Lwork,
      IntBuffer devInfo);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgebrd(
      cusolverDnContext handle,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] D,
      double[] E,
      @Cast("cuDoubleComplex*") double2 TAUQ,
      @Cast("cuDoubleComplex*") double2 TAUP,
      @Cast("cuDoubleComplex*") double2 Work,
      int Lwork,
      int[] devInfo);

  /* generates one of the unitary matrices Q or P**T determined by GEBRD*/
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const float[] A,
      int lda,
      @Const float[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Const double[] A,
      int lda,
      @Const double[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      float[] A,
      int lda,
      @Const float[] tau,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      double[] A,
      int lda,
      @Const double[] tau,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungbr(
      cusolverDnContext handle,
      @Cast("cublasSideMode_t") int side,
      int m,
      int n,
      int k,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* tridiagonal factorization */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer d,
      @Const FloatPointer e,
      @Const FloatPointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer d,
      @Const FloatBuffer e,
      @Const FloatBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] d,
      @Const float[] e,
      @Const float[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer d,
      @Const DoublePointer e,
      @Const DoublePointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer d,
      @Const DoubleBuffer e,
      @Const DoubleBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] d,
      @Const double[] e,
      @Const double[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer d,
      @Const FloatPointer e,
      @Cast("const cuComplex*") float2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer d,
      @Const FloatBuffer e,
      @Cast("const cuComplex*") float2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] d,
      @Const float[] e,
      @Cast("const cuComplex*") float2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer d,
      @Const DoublePointer e,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer d,
      @Const DoubleBuffer e,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] d,
      @Const double[] e,
      @Cast("const cuDoubleComplex*") double2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer d,
      FloatPointer e,
      FloatPointer tau,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer d,
      FloatBuffer e,
      FloatBuffer tau,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] d,
      float[] e,
      float[] tau,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer d,
      DoublePointer e,
      DoublePointer tau,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer d,
      DoubleBuffer e,
      DoubleBuffer tau,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsytrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] d,
      double[] e,
      double[] tau,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer d,
      FloatPointer e,
      @Cast("cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer d,
      FloatBuffer e,
      @Cast("cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] d,
      float[] e,
      @Cast("cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer d,
      DoublePointer e,
      @Cast("cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer d,
      DoubleBuffer e,
      @Cast("cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhetrd(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] d,
      double[] e,
      @Cast("cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* generate unitary Q comes from sytrd */
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr_bufferSize(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      @Const FloatPointer tau,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      @Const FloatBuffer tau,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      @Const float[] tau,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      @Const DoublePointer tau,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      @Const DoubleBuffer tau,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDorgtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      @Const double[] tau,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 tau,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZungtr(
      cusolverDnContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 tau,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* compute op(Q)*C or C*op(Q) where Q comes from sytrd */
  

  

  

  

  

  

  

  

  /* singular value decomposition, A = U * Sigma * V^H */
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd_bufferSize(
      cusolverDnContext handle,
      int m,
      int n,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer S,
      FloatPointer U,
      int ldu,
      FloatPointer VT,
      int ldvt,
      FloatPointer work,
      int lwork,
      FloatPointer rwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer S,
      FloatBuffer U,
      int ldu,
      FloatBuffer VT,
      int ldvt,
      FloatBuffer work,
      int lwork,
      FloatBuffer rwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      float[] A,
      int lda,
      float[] S,
      float[] U,
      int ldu,
      float[] VT,
      int ldvt,
      float[] work,
      int lwork,
      float[] rwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer S,
      DoublePointer U,
      int ldu,
      DoublePointer VT,
      int ldvt,
      DoublePointer work,
      int lwork,
      DoublePointer rwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer S,
      DoubleBuffer U,
      int ldu,
      DoubleBuffer VT,
      int ldvt,
      DoubleBuffer work,
      int lwork,
      DoubleBuffer rwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      double[] A,
      int lda,
      double[] S,
      double[] U,
      int ldu,
      double[] VT,
      int ldvt,
      double[] work,
      int lwork,
      double[] rwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 VT,
      int ldvt,
      @Cast("cuComplex*") float2 work,
      int lwork,
      FloatPointer rwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 VT,
      int ldvt,
      @Cast("cuComplex*") float2 work,
      int lwork,
      FloatBuffer rwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 VT,
      int ldvt,
      @Cast("cuComplex*") float2 work,
      int lwork,
      float[] rwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 VT,
      int ldvt,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      DoublePointer rwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 VT,
      int ldvt,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      DoubleBuffer rwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvd(
      cusolverDnContext handle,
      byte jobu,
      byte jobvt,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 VT,
      int ldvt,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      double[] rwork,
      int[] info);

  /* standard symmetric eigenvalue solver, A*x = lambda*x, by divide-and-conquer
   */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] W,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] W,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevd(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* standard selective symmetric eigenvalue solver, A*x = lambda*x, by
   * divide-and-conquer  */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      float[] W,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      double[] W,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevdx(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* selective generalized symmetric eigenvalue solver, A*x = lambda*B*x, by
   * divide-and-conquer  */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      float[] W,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      double[] W,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntPointer meig,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      IntBuffer meig,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      float vl,
      float vu,
      int il,
      int iu,
      int[] meig,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntPointer meig,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      IntBuffer meig,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvdx(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      double vl,
      double vu,
      int il,
      int iu,
      int[] meig,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  /* generalized symmetric eigenvalue solver, A*x = lambda*B*x, by
   * divide-and-conquer  */
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer B,
      int ldb,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer B,
      int ldb,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] B,
      int ldb,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer B,
      int ldb,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer B,
      int ldb,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] B,
      int ldb,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const FloatPointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const FloatBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const float[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const DoublePointer W,
      IntPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const DoubleBuffer W,
      IntBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const double[] W,
      int[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer B,
      int ldb,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer B,
      int ldb,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] B,
      int ldb,
      float[] W,
      float[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer B,
      int ldb,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer B,
      int ldb,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] B,
      int ldb,
      double[] W,
      double[] work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvd(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverDnCreateSyevjInfo(@ByPtrPtr syevjInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDestroySyevjInfo(syevjInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjSetTolerance(syevjInfo info, double tolerance);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjSetMaxSweeps(syevjInfo info, int max_sweeps);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjSetSortEig(syevjInfo info, int sort_eig);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetResidual(
      cusolverDnContext handle,
      syevjInfo info,
      DoublePointer residual);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetResidual(
      cusolverDnContext handle,
      syevjInfo info,
      DoubleBuffer residual);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetResidual(
      cusolverDnContext handle,
      syevjInfo info,
      double[] residual);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetSweeps(
      cusolverDnContext handle,
      syevjInfo info,
      IntPointer executed_sweeps);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetSweeps(
      cusolverDnContext handle,
      syevjInfo info,
      IntBuffer executed_sweeps);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevjGetSweeps(
      cusolverDnContext handle,
      syevjInfo info,
      int[] executed_sweeps);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] W,
      int[] lwork,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] W,
      int[] lwork,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] W,
      int[] lwork,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] W,
      int[] lwork,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] W,
      float[] work,
      int lwork,
      int[] info,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] W,
      double[] work,
      int lwork,
      int[] info,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info,
      syevjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] W,
      float[] work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsyevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] W,
      double[] work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZheevj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer B,
      int ldb,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer B,
      int ldb,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] B,
      int ldb,
      @Const float[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer B,
      int ldb,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer B,
      int ldb,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] B,
      int ldb,
      @Const double[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const FloatPointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const FloatBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Cast("const cuComplex*") float2 B,
      int ldb,
      @Const float[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const DoublePointer W,
      IntPointer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const DoubleBuffer W,
      IntBuffer lwork,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Cast("const cuDoubleComplex*") double2 B,
      int ldb,
      @Const double[] W,
      int[] lwork,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer B,
      int ldb,
      FloatPointer W,
      FloatPointer work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer B,
      int ldb,
      FloatBuffer W,
      FloatBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      float[] A,
      int lda,
      float[] B,
      int ldb,
      float[] W,
      float[] work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer B,
      int ldb,
      DoublePointer W,
      DoublePointer work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer B,
      int ldb,
      DoubleBuffer W,
      DoubleBuffer work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDsygvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      double[] A,
      int lda,
      double[] B,
      int ldb,
      double[] W,
      double[] work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      FloatPointer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      FloatBuffer W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnChegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      @Cast("cuComplex*") float2 B,
      int ldb,
      float[] W,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      DoublePointer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      DoubleBuffer W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info,
      syevjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZhegvj(
      cusolverDnContext handle,
      @Cast("cusolverEigType_t") int itype,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      @Cast("cuDoubleComplex*") double2 B,
      int ldb,
      double[] W,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info,
      syevjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnCreateGesvdjInfo(@ByPtrPtr gesvdjInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverDnDestroyGesvdjInfo(gesvdjInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjSetTolerance(gesvdjInfo info, double tolerance);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjSetMaxSweeps(gesvdjInfo info, int max_sweeps);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjSetSortEig(gesvdjInfo info, int sort_svd);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetResidual(
      cusolverDnContext handle,
      gesvdjInfo info,
      DoublePointer residual);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetResidual(
      cusolverDnContext handle,
      gesvdjInfo info,
      DoubleBuffer residual);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetResidual(
      cusolverDnContext handle,
      gesvdjInfo info,
      double[] residual);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetSweeps(
      cusolverDnContext handle,
      gesvdjInfo info,
      IntPointer executed_sweeps);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetSweeps(
      cusolverDnContext handle,
      gesvdjInfo info,
      IntBuffer executed_sweeps);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdjGetSweeps(
      cusolverDnContext handle,
      gesvdjInfo info,
      int[] executed_sweeps);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer S,
      @Const FloatPointer U,
      int ldu,
      @Const FloatPointer V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer S,
      @Const FloatBuffer U,
      int ldu,
      @Const FloatBuffer V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] S,
      @Const float[] U,
      int ldu,
      @Const float[] V,
      int ldv,
      int[] lwork,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer S,
      @Const DoublePointer U,
      int ldu,
      @Const DoublePointer V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer S,
      @Const DoubleBuffer U,
      int ldu,
      @Const DoubleBuffer V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] S,
      @Const double[] U,
      int ldu,
      @Const double[] V,
      int ldv,
      int[] lwork,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      int[] lwork,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      int[] lwork,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer S,
      FloatPointer U,
      int ldu,
      FloatPointer V,
      int ldv,
      FloatPointer work,
      int lwork,
      IntPointer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer S,
      FloatBuffer U,
      int ldu,
      FloatBuffer V,
      int ldv,
      FloatBuffer work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      float[] A,
      int lda,
      float[] S,
      float[] U,
      int ldu,
      float[] V,
      int ldv,
      float[] work,
      int lwork,
      int[] info,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer S,
      DoublePointer U,
      int ldu,
      DoublePointer V,
      int ldv,
      DoublePointer work,
      int lwork,
      IntPointer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer S,
      DoubleBuffer U,
      int ldu,
      DoubleBuffer V,
      int ldv,
      DoubleBuffer work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      double[] A,
      int lda,
      double[] S,
      double[] U,
      int ldu,
      double[] V,
      int ldv,
      double[] work,
      int lwork,
      int[] info,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdjBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info,
      gesvdjInfo params,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const FloatPointer A,
      int lda,
      @Const FloatPointer S,
      @Const FloatPointer U,
      int ldu,
      @Const FloatPointer V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const FloatBuffer A,
      int lda,
      @Const FloatBuffer S,
      @Const FloatBuffer U,
      int ldu,
      @Const FloatBuffer V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const float[] A,
      int lda,
      @Const float[] S,
      @Const float[] U,
      int ldu,
      @Const float[] V,
      int ldv,
      int[] lwork,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const DoublePointer A,
      int lda,
      @Const DoublePointer S,
      @Const DoublePointer U,
      int ldu,
      @Const DoublePointer V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const DoubleBuffer A,
      int lda,
      @Const DoubleBuffer S,
      @Const DoubleBuffer U,
      int ldu,
      @Const DoubleBuffer V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Const double[] A,
      int lda,
      @Const double[] S,
      @Const double[] U,
      int ldu,
      @Const double[] V,
      int ldv,
      int[] lwork,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatPointer S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const FloatBuffer S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuComplex*") float2 A,
      int lda,
      @Const float[] S,
      @Cast("const cuComplex*") float2 U,
      int ldu,
      @Cast("const cuComplex*") float2 V,
      int ldv,
      int[] lwork,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoublePointer S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      IntPointer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const DoubleBuffer S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      IntBuffer lwork,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 A,
      int lda,
      @Const double[] S,
      @Cast("const cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("const cuDoubleComplex*") double2 V,
      int ldv,
      int[] lwork,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      FloatPointer A,
      int lda,
      FloatPointer S,
      FloatPointer U,
      int ldu,
      FloatPointer V,
      int ldv,
      FloatPointer work,
      int lwork,
      IntPointer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      FloatBuffer A,
      int lda,
      FloatBuffer S,
      FloatBuffer U,
      int ldu,
      FloatBuffer V,
      int ldv,
      FloatBuffer work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      float[] A,
      int lda,
      float[] S,
      float[] U,
      int ldu,
      float[] V,
      int ldv,
      float[] work,
      int lwork,
      int[] info,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      DoublePointer A,
      int lda,
      DoublePointer S,
      DoublePointer U,
      int ldu,
      DoublePointer V,
      int ldv,
      DoublePointer work,
      int lwork,
      IntPointer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      DoubleBuffer A,
      int lda,
      DoubleBuffer S,
      DoubleBuffer U,
      int ldu,
      DoubleBuffer V,
      int ldv,
      DoubleBuffer work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      double[] A,
      int lda,
      double[] S,
      double[] U,
      int ldu,
      double[] V,
      int ldv,
      double[] work,
      int lwork,
      int[] info,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatPointer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntPointer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      FloatBuffer S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuComplex*") float2 A,
      int lda,
      float[] S,
      @Cast("cuComplex*") float2 U,
      int ldu,
      @Cast("cuComplex*") float2 V,
      int ldv,
      @Cast("cuComplex*") float2 work,
      int lwork,
      int[] info,
      gesvdjInfo params);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoublePointer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntPointer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      DoubleBuffer S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      IntBuffer info,
      gesvdjInfo params);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdj(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      int m,
      int n,
      @Cast("cuDoubleComplex*") double2 A,
      int lda,
      double[] S,
      @Cast("cuDoubleComplex*") double2 U,
      int ldu,
      @Cast("cuDoubleComplex*") double2 V,
      int ldv,
      @Cast("cuDoubleComplex*") double2 work,
      int lwork,
      int[] info,
      gesvdjInfo params);

  /* batched approximate SVD */

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const FloatPointer d_A,
      int lda,
      long strideA,
      @Const FloatPointer d_S,
      long strideS,
      @Const FloatPointer d_U,
      int ldu,
      long strideU,
      @Const FloatPointer d_V,
      int ldv,
      long strideV,
      IntPointer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const FloatBuffer d_A,
      int lda,
      long strideA,
      @Const FloatBuffer d_S,
      long strideS,
      @Const FloatBuffer d_U,
      int ldu,
      long strideU,
      @Const FloatBuffer d_V,
      int ldv,
      long strideV,
      IntBuffer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const float[] d_A,
      int lda,
      long strideA,
      @Const float[] d_S,
      long strideS,
      @Const float[] d_U,
      int ldu,
      long strideU,
      @Const float[] d_V,
      int ldv,
      long strideV,
      int[] lwork,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const DoublePointer d_A,
      int lda,
      long strideA,
      @Const DoublePointer d_S,
      long strideS,
      @Const DoublePointer d_U,
      int ldu,
      long strideU,
      @Const DoublePointer d_V,
      int ldv,
      long strideV,
      IntPointer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const DoubleBuffer d_A,
      int lda,
      long strideA,
      @Const DoubleBuffer d_S,
      long strideS,
      @Const DoubleBuffer d_U,
      int ldu,
      long strideU,
      @Const DoubleBuffer d_V,
      int ldv,
      long strideV,
      IntBuffer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const double[] d_A,
      int lda,
      long strideA,
      @Const double[] d_S,
      long strideS,
      @Const double[] d_U,
      int ldu,
      long strideU,
      @Const double[] d_V,
      int ldv,
      long strideV,
      int[] lwork,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      @Const FloatPointer d_S,
      long strideS,
      @Cast("const cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      IntPointer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      @Const FloatBuffer d_S,
      long strideS,
      @Cast("const cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      IntBuffer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      @Const float[] d_S,
      long strideS,
      @Cast("const cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      int[] lwork,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      @Const DoublePointer d_S,
      long strideS,
      @Cast("const cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      IntPointer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      @Const DoubleBuffer d_S,
      long strideS,
      @Cast("const cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      IntBuffer lwork,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched_bufferSize(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      @Const double[] d_S,
      long strideS,
      @Cast("const cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("const cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      int[] lwork,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const FloatPointer d_A,
      int lda,
      long strideA,
      FloatPointer d_S,
      long strideS,
      FloatPointer d_U,
      int ldu,
      long strideU,
      FloatPointer d_V,
      int ldv,
      long strideV,
      FloatPointer d_work,
      int lwork,
      IntPointer d_info,
      DoublePointer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const FloatBuffer d_A,
      int lda,
      long strideA,
      FloatBuffer d_S,
      long strideS,
      FloatBuffer d_U,
      int ldu,
      long strideU,
      FloatBuffer d_V,
      int ldv,
      long strideV,
      FloatBuffer d_work,
      int lwork,
      IntBuffer d_info,
      DoubleBuffer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnSgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const float[] d_A,
      int lda,
      long strideA,
      float[] d_S,
      long strideS,
      float[] d_U,
      int ldu,
      long strideU,
      float[] d_V,
      int ldv,
      long strideV,
      float[] d_work,
      int lwork,
      int[] d_info,
      double[] h_R_nrmF,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const DoublePointer d_A,
      int lda,
      long strideA,
      DoublePointer d_S,
      long strideS,
      DoublePointer d_U,
      int ldu,
      long strideU,
      DoublePointer d_V,
      int ldv,
      long strideV,
      DoublePointer d_work,
      int lwork,
      IntPointer d_info,
      DoublePointer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const DoubleBuffer d_A,
      int lda,
      long strideA,
      DoubleBuffer d_S,
      long strideS,
      DoubleBuffer d_U,
      int ldu,
      long strideU,
      DoubleBuffer d_V,
      int ldv,
      long strideV,
      DoubleBuffer d_work,
      int lwork,
      IntBuffer d_info,
      DoubleBuffer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnDgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Const double[] d_A,
      int lda,
      long strideA,
      double[] d_S,
      long strideS,
      double[] d_U,
      int ldu,
      long strideU,
      double[] d_V,
      int ldv,
      long strideV,
      double[] d_work,
      int lwork,
      int[] d_info,
      double[] h_R_nrmF,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      FloatPointer d_S,
      long strideS,
      @Cast("cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      @Cast("cuComplex*") float2 d_work,
      int lwork,
      IntPointer d_info,
      DoublePointer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      FloatBuffer d_S,
      long strideS,
      @Cast("cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      @Cast("cuComplex*") float2 d_work,
      int lwork,
      IntBuffer d_info,
      DoubleBuffer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnCgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuComplex*") float2 d_A,
      int lda,
      long strideA,
      float[] d_S,
      long strideS,
      @Cast("cuComplex*") float2 d_U,
      int ldu,
      long strideU,
      @Cast("cuComplex*") float2 d_V,
      int ldv,
      long strideV,
      @Cast("cuComplex*") float2 d_work,
      int lwork,
      int[] d_info,
      double[] h_R_nrmF,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      DoublePointer d_S,
      long strideS,
      @Cast("cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      @Cast("cuDoubleComplex*") double2 d_work,
      int lwork,
      IntPointer d_info,
      DoublePointer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      DoubleBuffer d_S,
      long strideS,
      @Cast("cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      @Cast("cuDoubleComplex*") double2 d_work,
      int lwork,
      IntBuffer d_info,
      DoubleBuffer h_R_nrmF,
      int batchSize);
  public static native @Cast("cusolverStatus_t") int cusolverDnZgesvdaStridedBatched(
      cusolverDnContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      int rank,
      int m,
      int n,
      @Cast("const cuDoubleComplex*") double2 d_A,
      int lda,
      long strideA,
      double[] d_S,
      long strideS,
      @Cast("cuDoubleComplex*") double2 d_U,
      int ldu,
      long strideU,
      @Cast("cuDoubleComplex*") double2 d_V,
      int ldv,
      long strideV,
      @Cast("cuDoubleComplex*") double2 d_work,
      int lwork,
      int[] d_info,
      double[] h_R_nrmF,
      int batchSize);

  public static native @Cast("cusolverStatus_t") int cusolverDnCreateParams(@ByPtrPtr cusolverDnParams params);

  public static native @Cast("cusolverStatus_t") int cusolverDnDestroyParams(cusolverDnParams params);

  public static native @Cast("cusolverStatus_t") int cusolverDnSetAdvOptions(
      cusolverDnParams params,
      @Cast("cusolverDnFunction_t") int function,
      @Cast("cusolverAlgMode_t") int algo);

  /* 64-bit API for POTRF */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /* 64-bit API for POTRS */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnPotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      int[] info);

  /* 64-bit API for GEQRF */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGeqrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      @Const Pointer tau,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /* 64-bit API for GETRF */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") long[] ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /* 64-bit API for GETRS */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") long[] ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      int[] info);

  /* 64-bit API for SYEVD */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevd_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /* 64-bit API for SYEVDX */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongPointer h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongBuffer h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") long[] h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongPointer meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongBuffer meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnSyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") long[] meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /* 64-bit API for GESVD */
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGesvd_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      @Const Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      @Const Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      @Const Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") @Deprecated int cusolverDnGesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer pBuffer,
      @Cast("size_t") long workspaceInBytes,
      int[] info);

  /*
   * new 64-bit API
   */
  /* 64-bit API for POTRF */
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for POTRS */
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXpotrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      int[] info);

  /* 64-bit API for GEQRF */
  public static native @Cast("cusolverStatus_t") int cusolverDnXgeqrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      @Const Pointer tau,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgeqrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeTau,
      Pointer tau,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for GETRF */
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrf_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrf(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("int64_t*") long[] ipiv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for GETRS */
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongPointer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") LongBuffer ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgetrs(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cublasOperation_t") int trans,
      @Cast("int64_t") long n,
      @Cast("int64_t") long nrhs,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("const int64_t*") long[] ipiv,
      @Cast("cudaDataType") int dataTypeB,
      Pointer B,
      @Cast("int64_t") long ldb,
      int[] info);

  /* 64-bit API for SYEVD */
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevd_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevd(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for SYEVDX */
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongPointer h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongBuffer h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") long[] h_meig,
      @Cast("cudaDataType") int dataTypeW,
      @Const Pointer W,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongPointer meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") LongBuffer meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXsyevdx(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cusolverEigRange_t") int range,
      @Cast("cublasFillMode_t") int uplo,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      Pointer vl,
      Pointer vu,
      @Cast("int64_t") long il,
      @Cast("int64_t") long iu,
      @Cast("int64_t*") long[] meig64,
      @Cast("cudaDataType") int dataTypeW,
      Pointer W,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for GESVD */
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvd_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      @Const Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      @Const Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      @Const Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvd(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobvt,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeVT,
      Pointer VT,
      @Cast("int64_t") long ldvt,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] info);

  /* 64-bit API for GESVDP */
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdp_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      @Const Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      @Const Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeV,
      @Const Pointer V,
      @Cast("int64_t") long ldv,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdp(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeV,
      Pointer V,
      @Cast("int64_t") long ldv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer d_info,
      DoublePointer h_err_sigma);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdp(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeV,
      Pointer V,
      @Cast("int64_t") long ldv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer d_info,
      DoubleBuffer h_err_sigma);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdp(
      cusolverDnContext handle,
      cusolverDnParams params,
      @Cast("cusolverEigMode_t") int jobz,
      int econ,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeS,
      Pointer S,
      @Cast("cudaDataType") int dataTypeU,
      Pointer U,
      @Cast("int64_t") long ldu,
      @Cast("cudaDataType") int dataTypeV,
      Pointer V,
      @Cast("int64_t") long ldv,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] d_info,
      double[] h_err_sigma);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdr_bufferSize(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobv,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("int64_t") long k,
      @Cast("int64_t") long p,
      @Cast("int64_t") long niters,
      @Cast("cudaDataType") int dataTypeA,
      @Const Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeSrand,
      @Const Pointer Srand,
      @Cast("cudaDataType") int dataTypeUrand,
      @Const Pointer Urand,
      @Cast("int64_t") long ldUrand,
      @Cast("cudaDataType") int dataTypeVrand,
      @Const Pointer Vrand,
      @Cast("int64_t") long ldVrand,
      @Cast("cudaDataType") int computeType,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnDevice,
      @Cast("size_t*") SizeTPointer workspaceInBytesOnHost);

  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdr(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobv,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("int64_t") long k,
      @Cast("int64_t") long p,
      @Cast("int64_t") long niters,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeSrand,
      Pointer Srand,
      @Cast("cudaDataType") int dataTypeUrand,
      Pointer Urand,
      @Cast("int64_t") long ldUrand,
      @Cast("cudaDataType") int dataTypeVrand,
      Pointer Vrand,
      @Cast("int64_t") long ldVrand,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntPointer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdr(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobv,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("int64_t") long k,
      @Cast("int64_t") long p,
      @Cast("int64_t") long niters,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeSrand,
      Pointer Srand,
      @Cast("cudaDataType") int dataTypeUrand,
      Pointer Urand,
      @Cast("int64_t") long ldUrand,
      @Cast("cudaDataType") int dataTypeVrand,
      Pointer Vrand,
      @Cast("int64_t") long ldVrand,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      IntBuffer d_info);
  public static native @Cast("cusolverStatus_t") int cusolverDnXgesvdr(
      cusolverDnContext handle,
      cusolverDnParams params,
      byte jobu,
      byte jobv,
      @Cast("int64_t") long m,
      @Cast("int64_t") long n,
      @Cast("int64_t") long k,
      @Cast("int64_t") long p,
      @Cast("int64_t") long niters,
      @Cast("cudaDataType") int dataTypeA,
      Pointer A,
      @Cast("int64_t") long lda,
      @Cast("cudaDataType") int dataTypeSrand,
      Pointer Srand,
      @Cast("cudaDataType") int dataTypeUrand,
      Pointer Urand,
      @Cast("int64_t") long ldUrand,
      @Cast("cudaDataType") int dataTypeVrand,
      Pointer Vrand,
      @Cast("int64_t") long ldVrand,
      @Cast("cudaDataType") int computeType,
      Pointer bufferOnDevice,
      @Cast("size_t") long workspaceInBytesOnDevice,
      Pointer bufferOnHost,
      @Cast("size_t") long workspaceInBytesOnHost,
      int[] d_info);
// Targeting ../cusolver/cusolverDnLoggerCallback_t.java



  

  

  

  

  

  

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

// #endif /* !defined(CUDENSE_H_) */


// Parsed from <cusolverMg.h>

/*
 * Copyright 2019 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(CUSOLVERMG_H_)
//   #define CUSOLVERMG_H_

//   #include <stdint.h>
//   #include "cusolverDn.h"

//   #if defined(__cplusplus)
// Targeting ../cusolver/cusolverMgContext.java



  /**
   * \beief This enum decides how 1D device Ids (or process ranks) get mapped to
   * a 2D grid.
   */
  /** enum cusolverMgGridMapping_t */
  public static final int

    CUDALIBMG_GRID_MAPPING_ROW_MAJOR = 1,
    CUDALIBMG_GRID_MAPPING_COL_MAJOR = 0;
// Targeting ../cusolver/cudaLibMgGrid_t.java


// Targeting ../cusolver/cudaLibMgMatrixDesc_t.java



  public static native @Cast("cusolverStatus_t") int cusolverMgCreate(@ByPtrPtr cusolverMgContext handle);

  public static native @Cast("cusolverStatus_t") int cusolverMgDestroy(cusolverMgContext handle);

  public static native @Cast("cusolverStatus_t") int cusolverMgDeviceSelect(
      cusolverMgContext handle,
      int nbDevices,
      IntPointer deviceId);
  public static native @Cast("cusolverStatus_t") int cusolverMgDeviceSelect(
      cusolverMgContext handle,
      int nbDevices,
      IntBuffer deviceId);
  public static native @Cast("cusolverStatus_t") int cusolverMgDeviceSelect(
      cusolverMgContext handle,
      int nbDevices,
      int[] deviceId);

  /**
   * \brief Allocates resources related to the shared memory device grid.
   * @param grid [out] the opaque data strcuture that holds the grid
   * @param numRowDevices [in] number of devices in the row
   * @param numColDevices [in] number of devices in the column
   * @param deviceId [in] This array of size height * width stores the
   *            device-ids of the 2D grid; each entry must correspond to a valid
   * gpu or to -1 (denoting CPU). @param mapping [in] whether the 2D grid is in
   * row/column major @return the status code
   */
  public static native @Cast("cusolverStatus_t") int cusolverMgCreateDeviceGrid(
      @ByPtrPtr cudaLibMgGrid_t grid,
      int numRowDevices,
      int numColDevices,
      @Const IntPointer deviceId,
      @Cast("cusolverMgGridMapping_t") int mapping);
  public static native @Cast("cusolverStatus_t") int cusolverMgCreateDeviceGrid(
      @ByPtrPtr cudaLibMgGrid_t grid,
      int numRowDevices,
      int numColDevices,
      @Const IntBuffer deviceId,
      @Cast("cusolverMgGridMapping_t") int mapping);
  public static native @Cast("cusolverStatus_t") int cusolverMgCreateDeviceGrid(
      @ByPtrPtr cudaLibMgGrid_t grid,
      int numRowDevices,
      int numColDevices,
      @Const int[] deviceId,
      @Cast("cusolverMgGridMapping_t") int mapping);

  /**
   * \brief Releases the allocated resources related to the distributed grid.
   * @param grid [in] the opaque data strcuture that holds the distributed grid
   * @return the status code
   */
  public static native @Cast("cusolverStatus_t") int cusolverMgDestroyGrid(cudaLibMgGrid_t grid);

  /**
   * \brief Allocates resources related to the distributed matrix descriptor.
   * @param desc [out] the opaque data strcuture that holds the descriptor
   * @param numRows [in] number of total rows
   * @param numCols [in] number of total columns
   * @param rowBlockSize [in] row block size
   * @param colBlockSize [in] column block size
   * @param dataType [in] the data type of each element in cudaDataType
   * @param grid [in] the opaque data structure of the distributed grid
   * @return the status code
   */
  public static native @Cast("cusolverStatus_t") int cusolverMgCreateMatrixDesc(
      @ByPtrPtr cudaLibMgMatrixDesc_t desc,
      @Cast("int64_t") long numRows,
      @Cast("int64_t") long numCols,
      @Cast("int64_t") long rowBlockSize,
      @Cast("int64_t") long colBlockSize,
      @Cast("cudaDataType") int dataType,
      cudaLibMgGrid_t grid);

  /**
   * \brief Releases the allocated resources related to the distributed matrix
   * descriptor. @param desc [in] the opaque data strcuture that holds the
   * descriptor @return the status code
   */
  public static native @Cast("cusolverStatus_t") int cusolverMgDestroyMatrixDesc(cudaLibMgMatrixDesc_t desc);

  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd_bufferSize(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd_bufferSize(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd_bufferSize(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd_bufferSize(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgSyevd(
      cusolverMgContext handle,
      @Cast("cusolverEigMode_t") int jobz,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      Pointer W,
      @Cast("cudaDataType") int dataTypeW,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf_bufferSize(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("int**") PointerPointer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf_bufferSize(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntPointer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf_bufferSize(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntBuffer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf_bufferSize(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr int[] array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("int**") PointerPointer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntPointer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntBuffer array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrf(
      cusolverMgContext handle,
      int M,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr int[] array_d_IPIV,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("int**") PointerPointer array_d_IPIV,
      @Cast("void**") PointerPointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntPointer array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntBuffer array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr int[] array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("int**") PointerPointer array_d_IPIV,
      @Cast("void**") PointerPointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntPointer array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr IntBuffer array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer info);
  public static native @Cast("cusolverStatus_t") int cusolverMgGetrs(
      cusolverMgContext handle,
      @Cast("cublasOperation_t") int TRANS,
      int N,
      int NRHS,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @ByPtrPtr int[] array_d_IPIV,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] info);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrf(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] h_info);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") PointerPointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") PointerPointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotrs(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int n,
      int nrhs,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("void**") @ByPtrPtr Pointer array_d_B,
      int IB,
      int JB,
      cudaLibMgMatrixDesc_t descrB,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] h_info);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotri_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongPointer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") LongBuffer lwork);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri_bufferSize(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("int64_t*") long[] lwork);

  public static native @Cast("cusolverStatus_t") int cusolverMgPotri(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") PointerPointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") PointerPointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntPointer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      IntBuffer h_info);
  public static native @Cast("cusolverStatus_t") int cusolverMgPotri(
      cusolverMgContext handle,
      @Cast("cublasFillMode_t") int uplo,
      int N,
      @Cast("void**") @ByPtrPtr Pointer array_d_A,
      int IA,
      int JA,
      cudaLibMgMatrixDesc_t descrA,
      @Cast("cudaDataType") int computeType,
      @Cast("void**") @ByPtrPtr Pointer array_d_work,
      @Cast("int64_t") long lwork,
      int[] h_info);

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

// #endif // CUSOLVERMG_H_


// Parsed from <cusolverRf.h>

/*
 * Copyright 1993-2014 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(CUSOLVERRF_H_)
//   #define CUSOLVERRF_H_

//   #include "driver_types.h"
//   #include "cuComplex.h"
//   #include "cusolver_common.h"

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

  /* CUSOLVERRF mode */
  /** enum cusolverRfResetValuesFastMode_t */
  public static final int
    CUSOLVERRF_RESET_VALUES_FAST_MODE_OFF = 0, // default
    CUSOLVERRF_RESET_VALUES_FAST_MODE_ON = 1;

  /* CUSOLVERRF matrix format */
  /** enum cusolverRfMatrixFormat_t */
  public static final int
    CUSOLVERRF_MATRIX_FORMAT_CSR = 0, // default
    CUSOLVERRF_MATRIX_FORMAT_CSC = 1;

  /* CUSOLVERRF unit diagonal */
  /** enum cusolverRfUnitDiagonal_t */
  public static final int
    CUSOLVERRF_UNIT_DIAGONAL_STORED_L = 0, // default
    CUSOLVERRF_UNIT_DIAGONAL_STORED_U = 1,
    CUSOLVERRF_UNIT_DIAGONAL_ASSUMED_L = 2,
    CUSOLVERRF_UNIT_DIAGONAL_ASSUMED_U = 3;

  /* CUSOLVERRF factorization algorithm */
  /** enum cusolverRfFactorization_t */
  public static final int
    CUSOLVERRF_FACTORIZATION_ALG0 = 0, // default
    CUSOLVERRF_FACTORIZATION_ALG1 = 1,
    CUSOLVERRF_FACTORIZATION_ALG2 = 2;

  /* CUSOLVERRF triangular solve algorithm */
  /** enum cusolverRfTriangularSolve_t */
  public static final int
    CUSOLVERRF_TRIANGULAR_SOLVE_ALG1 = 1, // default
    CUSOLVERRF_TRIANGULAR_SOLVE_ALG2 = 2,
    CUSOLVERRF_TRIANGULAR_SOLVE_ALG3 = 3;

  /* CUSOLVERRF numeric boost report */
  /** enum cusolverRfNumericBoostReport_t */
  public static final int
    CUSOLVERRF_NUMERIC_BOOST_NOT_USED = 0, // default
    CUSOLVERRF_NUMERIC_BOOST_USED = 1;
// Targeting ../cusolver/cusolverRfCommon.java



  /* CUSOLVERRF create (allocate memory) and destroy (free memory) in the handle
   */
  public static native @Cast("cusolverStatus_t") int cusolverRfCreate(@ByPtrPtr cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfDestroy(cusolverRfCommon handle);

  /* CUSOLVERRF set and get input format */
  public static native @Cast("cusolverStatus_t") int cusolverRfGetMatrixFormat(
      cusolverRfCommon handle,
      @Cast("cusolverRfMatrixFormat_t*") IntPointer format,
      @Cast("cusolverRfUnitDiagonal_t*") IntPointer diag);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetMatrixFormat(
      cusolverRfCommon handle,
      @Cast("cusolverRfMatrixFormat_t*") IntBuffer format,
      @Cast("cusolverRfUnitDiagonal_t*") IntBuffer diag);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetMatrixFormat(
      cusolverRfCommon handle,
      @Cast("cusolverRfMatrixFormat_t*") int[] format,
      @Cast("cusolverRfUnitDiagonal_t*") int[] diag);

  public static native @Cast("cusolverStatus_t") int cusolverRfSetMatrixFormat(
      cusolverRfCommon handle,
      @Cast("cusolverRfMatrixFormat_t") int format,
      @Cast("cusolverRfUnitDiagonal_t") int diag);

  /* CUSOLVERRF set and get numeric properties */
  public static native @Cast("cusolverStatus_t") int cusolverRfSetNumericProperties(
      cusolverRfCommon handle,
      double _zero,
      double boost);

  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericProperties(
      cusolverRfCommon handle,
      DoublePointer _zero,
      DoublePointer boost);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericProperties(
      cusolverRfCommon handle,
      DoubleBuffer _zero,
      DoubleBuffer boost);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericProperties(
      cusolverRfCommon handle,
      double[] _zero,
      double[] boost);

  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericBoostReport(
      cusolverRfCommon handle,
      @Cast("cusolverRfNumericBoostReport_t*") IntPointer report);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericBoostReport(
      cusolverRfCommon handle,
      @Cast("cusolverRfNumericBoostReport_t*") IntBuffer report);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetNumericBoostReport(
      cusolverRfCommon handle,
      @Cast("cusolverRfNumericBoostReport_t*") int[] report);

  /* CUSOLVERRF choose the triangular solve algorithm */
  public static native @Cast("cusolverStatus_t") int cusolverRfSetAlgs(
      cusolverRfCommon handle,
      @Cast("cusolverRfFactorization_t") int factAlg,
      @Cast("cusolverRfTriangularSolve_t") int solveAlg);

  public static native @Cast("cusolverStatus_t") int cusolverRfGetAlgs(
      cusolverRfCommon handle,
      @Cast("cusolverRfFactorization_t*") IntPointer factAlg,
      @Cast("cusolverRfTriangularSolve_t*") IntPointer solveAlg);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetAlgs(
      cusolverRfCommon handle,
      @Cast("cusolverRfFactorization_t*") IntBuffer factAlg,
      @Cast("cusolverRfTriangularSolve_t*") IntBuffer solveAlg);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetAlgs(
      cusolverRfCommon handle,
      @Cast("cusolverRfFactorization_t*") int[] factAlg,
      @Cast("cusolverRfTriangularSolve_t*") int[] solveAlg);

  /* CUSOLVERRF set and get fast mode */
  public static native @Cast("cusolverStatus_t") int cusolverRfGetResetValuesFastMode(
      cusolverRfCommon handle,
      @Cast("cusolverRfResetValuesFastMode_t*") IntPointer fastMode);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetResetValuesFastMode(
      cusolverRfCommon handle,
      @Cast("cusolverRfResetValuesFastMode_t*") IntBuffer fastMode);
  public static native @Cast("cusolverStatus_t") int cusolverRfGetResetValuesFastMode(
      cusolverRfCommon handle,
      @Cast("cusolverRfResetValuesFastMode_t*") int[] fastMode);

  public static native @Cast("cusolverStatus_t") int cusolverRfSetResetValuesFastMode(
      cusolverRfCommon handle,
      @Cast("cusolverRfResetValuesFastMode_t") int fastMode);

  /*** Non-Batched Routines ***/
  /* CUSOLVERRF setup of internal structures from host or device memory */
  public static native @Cast("cusolverStatus_t") int cusolverRfSetupHost(
                          int n,
                          int nnzA,
                          IntPointer h_csrRowPtrA,
                          IntPointer h_csrColIndA,
                          DoublePointer h_csrValA,
                          int nnzL,
                          IntPointer h_csrRowPtrL,
                          IntPointer h_csrColIndL,
                          DoublePointer h_csrValL,
                          int nnzU,
                          IntPointer h_csrRowPtrU,
                          IntPointer h_csrColIndU,
                          DoublePointer h_csrValU,
                          IntPointer h_P,
                          IntPointer h_Q,
                          cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfSetupHost(
                          int n,
                          int nnzA,
                          IntBuffer h_csrRowPtrA,
                          IntBuffer h_csrColIndA,
                          DoubleBuffer h_csrValA,
                          int nnzL,
                          IntBuffer h_csrRowPtrL,
                          IntBuffer h_csrColIndL,
                          DoubleBuffer h_csrValL,
                          int nnzU,
                          IntBuffer h_csrRowPtrU,
                          IntBuffer h_csrColIndU,
                          DoubleBuffer h_csrValU,
                          IntBuffer h_P,
                          IntBuffer h_Q,
                          cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfSetupHost(
                          int n,
                          int nnzA,
                          int[] h_csrRowPtrA,
                          int[] h_csrColIndA,
                          double[] h_csrValA,
                          int nnzL,
                          int[] h_csrRowPtrL,
                          int[] h_csrColIndL,
                          double[] h_csrValL,
                          int nnzU,
                          int[] h_csrRowPtrU,
                          int[] h_csrColIndU,
                          double[] h_csrValU,
                          int[] h_P,
                          int[] h_Q,
                          cusolverRfCommon handle);

  public static native @Cast("cusolverStatus_t") int cusolverRfSetupDevice(
                            int n,
                            int nnzA,
                            IntPointer csrRowPtrA,
                            IntPointer csrColIndA,
                            DoublePointer csrValA,
                            int nnzL,
                            IntPointer csrRowPtrL,
                            IntPointer csrColIndL,
                            DoublePointer csrValL,
                            int nnzU,
                            IntPointer csrRowPtrU,
                            IntPointer csrColIndU,
                            DoublePointer csrValU,
                            IntPointer P,
                            IntPointer Q,
                            cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfSetupDevice(
                            int n,
                            int nnzA,
                            IntBuffer csrRowPtrA,
                            IntBuffer csrColIndA,
                            DoubleBuffer csrValA,
                            int nnzL,
                            IntBuffer csrRowPtrL,
                            IntBuffer csrColIndL,
                            DoubleBuffer csrValL,
                            int nnzU,
                            IntBuffer csrRowPtrU,
                            IntBuffer csrColIndU,
                            DoubleBuffer csrValU,
                            IntBuffer P,
                            IntBuffer Q,
                            cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfSetupDevice(
                            int n,
                            int nnzA,
                            int[] csrRowPtrA,
                            int[] csrColIndA,
                            double[] csrValA,
                            int nnzL,
                            int[] csrRowPtrL,
                            int[] csrColIndL,
                            double[] csrValL,
                            int nnzU,
                            int[] csrRowPtrU,
                            int[] csrColIndU,
                            double[] csrValU,
                            int[] P,
                            int[] Q,
                            cusolverRfCommon handle);

  /* CUSOLVERRF update the matrix values (assuming the reordering, pivoting
     and consequently the sparsity pattern of L and U did not change),
     and zero out the remaining values. */
  public static native @Cast("cusolverStatus_t") int cusolverRfResetValues(
                            int n,
                            int nnzA,
                            IntPointer csrRowPtrA,
                            IntPointer csrColIndA,
                            DoublePointer csrValA,
                            IntPointer P,
                            IntPointer Q,
                            cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfResetValues(
                            int n,
                            int nnzA,
                            IntBuffer csrRowPtrA,
                            IntBuffer csrColIndA,
                            DoubleBuffer csrValA,
                            IntBuffer P,
                            IntBuffer Q,
                            cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfResetValues(
                            int n,
                            int nnzA,
                            int[] csrRowPtrA,
                            int[] csrColIndA,
                            double[] csrValA,
                            int[] P,
                            int[] Q,
                            cusolverRfCommon handle);

  /* CUSOLVERRF analysis (for parallelism) */
  public static native @Cast("cusolverStatus_t") int cusolverRfAnalyze(cusolverRfCommon handle);

  /* CUSOLVERRF re-factorization (for parallelism) */
  public static native @Cast("cusolverStatus_t") int cusolverRfRefactor(cusolverRfCommon handle);

  /* CUSOLVERRF extraction: Get L & U packed into a single matrix M */
  public static native @Cast("cusolverStatus_t") int cusolverRfAccessBundledFactorsDevice(
                                           cusolverRfCommon handle,
                                           IntPointer nnzM,
                                           @Cast("int**") PointerPointer Mp,
                                           @Cast("int**") PointerPointer Mi,
                                           @Cast("double**") PointerPointer Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfAccessBundledFactorsDevice(
                                           cusolverRfCommon handle,
                                           IntPointer nnzM,
                                           @ByPtrPtr IntPointer Mp,
                                           @ByPtrPtr IntPointer Mi,
                                           @ByPtrPtr DoublePointer Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfAccessBundledFactorsDevice(
                                           cusolverRfCommon handle,
                                           IntBuffer nnzM,
                                           @ByPtrPtr IntBuffer Mp,
                                           @ByPtrPtr IntBuffer Mi,
                                           @ByPtrPtr DoubleBuffer Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfAccessBundledFactorsDevice(
                                           cusolverRfCommon handle,
                                           int[] nnzM,
                                           @ByPtrPtr int[] Mp,
                                           @ByPtrPtr int[] Mi,
                                           @ByPtrPtr double[] Mx);

  public static native @Cast("cusolverStatus_t") int cusolverRfExtractBundledFactorsHost(
                                          cusolverRfCommon handle,
                                          IntPointer h_nnzM,
                                          @Cast("int**") PointerPointer h_Mp,
                                          @Cast("int**") PointerPointer h_Mi,
                                          @Cast("double**") PointerPointer h_Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractBundledFactorsHost(
                                          cusolverRfCommon handle,
                                          IntPointer h_nnzM,
                                          @ByPtrPtr IntPointer h_Mp,
                                          @ByPtrPtr IntPointer h_Mi,
                                          @ByPtrPtr DoublePointer h_Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractBundledFactorsHost(
                                          cusolverRfCommon handle,
                                          IntBuffer h_nnzM,
                                          @ByPtrPtr IntBuffer h_Mp,
                                          @ByPtrPtr IntBuffer h_Mi,
                                          @ByPtrPtr DoubleBuffer h_Mx);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractBundledFactorsHost(
                                          cusolverRfCommon handle,
                                          int[] h_nnzM,
                                          @ByPtrPtr int[] h_Mp,
                                          @ByPtrPtr int[] h_Mi,
                                          @ByPtrPtr double[] h_Mx);

  /* CUSOLVERRF extraction: Get L & U individually */
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractSplitFactorsHost(
                                        cusolverRfCommon handle,
                                        IntPointer h_nnzL,
                                        @Cast("int**") PointerPointer h_csrRowPtrL,
                                        @Cast("int**") PointerPointer h_csrColIndL,
                                        @Cast("double**") PointerPointer h_csrValL,
                                        IntPointer h_nnzU,
                                        @Cast("int**") PointerPointer h_csrRowPtrU,
                                        @Cast("int**") PointerPointer h_csrColIndU,
                                        @Cast("double**") PointerPointer h_csrValU);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractSplitFactorsHost(
                                        cusolverRfCommon handle,
                                        IntPointer h_nnzL,
                                        @ByPtrPtr IntPointer h_csrRowPtrL,
                                        @ByPtrPtr IntPointer h_csrColIndL,
                                        @ByPtrPtr DoublePointer h_csrValL,
                                        IntPointer h_nnzU,
                                        @ByPtrPtr IntPointer h_csrRowPtrU,
                                        @ByPtrPtr IntPointer h_csrColIndU,
                                        @ByPtrPtr DoublePointer h_csrValU);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractSplitFactorsHost(
                                        cusolverRfCommon handle,
                                        IntBuffer h_nnzL,
                                        @ByPtrPtr IntBuffer h_csrRowPtrL,
                                        @ByPtrPtr IntBuffer h_csrColIndL,
                                        @ByPtrPtr DoubleBuffer h_csrValL,
                                        IntBuffer h_nnzU,
                                        @ByPtrPtr IntBuffer h_csrRowPtrU,
                                        @ByPtrPtr IntBuffer h_csrColIndU,
                                        @ByPtrPtr DoubleBuffer h_csrValU);
  public static native @Cast("cusolverStatus_t") int cusolverRfExtractSplitFactorsHost(
                                        cusolverRfCommon handle,
                                        int[] h_nnzL,
                                        @ByPtrPtr int[] h_csrRowPtrL,
                                        @ByPtrPtr int[] h_csrColIndL,
                                        @ByPtrPtr double[] h_csrValL,
                                        int[] h_nnzU,
                                        @ByPtrPtr int[] h_csrRowPtrU,
                                        @ByPtrPtr int[] h_csrColIndU,
                                        @ByPtrPtr double[] h_csrValU);

  /* CUSOLVERRF (forward and backward triangular) solves */
  public static native @Cast("cusolverStatus_t") int cusolverRfSolve(
                      cusolverRfCommon handle,
                      IntPointer P,
                      IntPointer Q,
                      int nrhs,
                      DoublePointer Temp,
                      int ldt,
                      DoublePointer XF,
                      int ldxf);
  public static native @Cast("cusolverStatus_t") int cusolverRfSolve(
                      cusolverRfCommon handle,
                      IntBuffer P,
                      IntBuffer Q,
                      int nrhs,
                      DoubleBuffer Temp,
                      int ldt,
                      DoubleBuffer XF,
                      int ldxf);
  public static native @Cast("cusolverStatus_t") int cusolverRfSolve(
                      cusolverRfCommon handle,
                      int[] P,
                      int[] Q,
                      int nrhs,
                      double[] Temp,
                      int ldt,
                      double[] XF,
                      int ldxf);

  /*** Batched Routines ***/
  /* CUSOLVERRF-batch setup of internal structures from host */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSetupHost(
                               int batchSize,
                               int n,
                               int nnzA,
                               IntPointer h_csrRowPtrA,
                               IntPointer h_csrColIndA,
                               @Cast("double**") PointerPointer h_csrValA_array,
                               int nnzL,
                               IntPointer h_csrRowPtrL,
                               IntPointer h_csrColIndL,
                               DoublePointer h_csrValL,
                               int nnzU,
                               IntPointer h_csrRowPtrU,
                               IntPointer h_csrColIndU,
                               DoublePointer h_csrValU,
                               IntPointer h_P,
                               IntPointer h_Q,
                               cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSetupHost(
                               int batchSize,
                               int n,
                               int nnzA,
                               IntPointer h_csrRowPtrA,
                               IntPointer h_csrColIndA,
                               @ByPtrPtr DoublePointer h_csrValA_array,
                               int nnzL,
                               IntPointer h_csrRowPtrL,
                               IntPointer h_csrColIndL,
                               DoublePointer h_csrValL,
                               int nnzU,
                               IntPointer h_csrRowPtrU,
                               IntPointer h_csrColIndU,
                               DoublePointer h_csrValU,
                               IntPointer h_P,
                               IntPointer h_Q,
                               cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSetupHost(
                               int batchSize,
                               int n,
                               int nnzA,
                               IntBuffer h_csrRowPtrA,
                               IntBuffer h_csrColIndA,
                               @ByPtrPtr DoubleBuffer h_csrValA_array,
                               int nnzL,
                               IntBuffer h_csrRowPtrL,
                               IntBuffer h_csrColIndL,
                               DoubleBuffer h_csrValL,
                               int nnzU,
                               IntBuffer h_csrRowPtrU,
                               IntBuffer h_csrColIndU,
                               DoubleBuffer h_csrValU,
                               IntBuffer h_P,
                               IntBuffer h_Q,
                               cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSetupHost(
                               int batchSize,
                               int n,
                               int nnzA,
                               int[] h_csrRowPtrA,
                               int[] h_csrColIndA,
                               @ByPtrPtr double[] h_csrValA_array,
                               int nnzL,
                               int[] h_csrRowPtrL,
                               int[] h_csrColIndL,
                               double[] h_csrValL,
                               int nnzU,
                               int[] h_csrRowPtrU,
                               int[] h_csrColIndU,
                               double[] h_csrValU,
                               int[] h_P,
                               int[] h_Q,
                               cusolverRfCommon handle);

  /* CUSOLVERRF-batch update the matrix values (assuming the reordering,
     pivoting and consequently the sparsity pattern of L and U did not change),
     and zero out the remaining values. */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchResetValues(
                                 int batchSize,
                                 int n,
                                 int nnzA,
                                 IntPointer csrRowPtrA,
                                 IntPointer csrColIndA,
                                 @Cast("double**") PointerPointer csrValA_array,
                                 IntPointer P,
                                 IntPointer Q,
                                 cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchResetValues(
                                 int batchSize,
                                 int n,
                                 int nnzA,
                                 IntPointer csrRowPtrA,
                                 IntPointer csrColIndA,
                                 @ByPtrPtr DoublePointer csrValA_array,
                                 IntPointer P,
                                 IntPointer Q,
                                 cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchResetValues(
                                 int batchSize,
                                 int n,
                                 int nnzA,
                                 IntBuffer csrRowPtrA,
                                 IntBuffer csrColIndA,
                                 @ByPtrPtr DoubleBuffer csrValA_array,
                                 IntBuffer P,
                                 IntBuffer Q,
                                 cusolverRfCommon handle);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchResetValues(
                                 int batchSize,
                                 int n,
                                 int nnzA,
                                 int[] csrRowPtrA,
                                 int[] csrColIndA,
                                 @ByPtrPtr double[] csrValA_array,
                                 int[] P,
                                 int[] Q,
                                 cusolverRfCommon handle);

  /* CUSOLVERRF-batch analysis (for parallelism) */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchAnalyze(cusolverRfCommon handle);

  /* CUSOLVERRF-batch re-factorization (for parallelism) */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchRefactor(cusolverRfCommon handle);

  /* CUSOLVERRF-batch (forward and backward triangular) solves */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSolve(
                           cusolverRfCommon handle,
                           IntPointer P,
                           IntPointer Q,
                           int nrhs,
                           DoublePointer Temp,
                           int ldt,
                           @Cast("double**") PointerPointer XF_array,
                           int ldxf);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSolve(
                           cusolverRfCommon handle,
                           IntPointer P,
                           IntPointer Q,
                           int nrhs,
                           DoublePointer Temp,
                           int ldt,
                           @ByPtrPtr DoublePointer XF_array,
                           int ldxf);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSolve(
                           cusolverRfCommon handle,
                           IntBuffer P,
                           IntBuffer Q,
                           int nrhs,
                           DoubleBuffer Temp,
                           int ldt,
                           @ByPtrPtr DoubleBuffer XF_array,
                           int ldxf);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchSolve(
                           cusolverRfCommon handle,
                           int[] P,
                           int[] Q,
                           int nrhs,
                           double[] Temp,
                           int ldt,
                           @ByPtrPtr double[] XF_array,
                           int ldxf);

  /* CUSOLVERRF-batch obtain the position of zero pivot */
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchZeroPivot(
                               cusolverRfCommon handle,
                               IntPointer _position);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchZeroPivot(
                               cusolverRfCommon handle,
                               IntBuffer _position);
  public static native @Cast("cusolverStatus_t") int cusolverRfBatchZeroPivot(
                               cusolverRfCommon handle,
                               int[] _position);

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

// #endif /* CUSOLVERRF_H_ */


// Parsed from cusolverSp.h

/*
 * Copyright 2014 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(CUSOLVERSP_H_)
//   #define CUSOLVERSP_H_

//   #include "cusparse.h"
//   #include "cublas_api.h"
//   #include "cusolver_common.h"

//   #if defined(__cplusplus)
// Targeting ../cusolver/cusolverSpContext.java


// Targeting ../cusolver/csrqrInfo.java



  public static native @Cast("cusolverStatus_t") int cusolverSpCreate(@ByPtrPtr cusolverSpContext handle);
  public static native @Cast("cusolverStatus_t") int cusolverSpDestroy(cusolverSpContext handle);
  public static native @Cast("cusolverStatus_t") int cusolverSpSetStream(cusolverSpContext handle, CUstream_st streamId);
  public static native @Cast("cusolverStatus_t") int cusolverSpGetStream(cusolverSpContext handle, @ByPtrPtr CUstream_st streamId);

  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrissymHost(
      cusolverSpContext handle,
      int m,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrEndPtrA,
      @Const IntPointer csrColIndA,
      IntPointer issym);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrissymHost(
      cusolverSpContext handle,
      int m,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrEndPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer issym);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrissymHost(
      cusolverSpContext handle,
      int m,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrEndPtrA,
      @Const int[] csrColIndA,
      int[] issym);

  /* -------- GPU linear solver by LU factorization
   *       solve A*x = b, A can be singular
   * [ls] stands for linear solve
   * [v] stands for vector
   * [lu] stands for LU factorization
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const FloatPointer b,
      float tol,
      int reorder,
      FloatPointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const FloatBuffer b,
      float tol,
      int reorder,
      FloatBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const float[] b,
      float tol,
      int reorder,
      float[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const DoublePointer b,
      double tol,
      int reorder,
      DoublePointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const DoubleBuffer b,
      double tol,
      int reorder,
      DoubleBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const double[] b,
      double tol,
      int reorder,
      double[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvluHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      int[] singularity);

  /* -------- GPU linear solver by QR factorization
   *       solve A*x = b, A can be singular
   * [ls] stands for linear solve
   * [v] stands for vector
   * [qr] stands for QR factorization
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const FloatPointer b,
      float tol,
      int reorder,
      FloatPointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const FloatBuffer b,
      float tol,
      int reorder,
      FloatBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const float[] b,
      float tol,
      int reorder,
      float[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const DoublePointer b,
      double tol,
      int reorder,
      DoublePointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const DoubleBuffer b,
      double tol,
      int reorder,
      DoubleBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const double[] b,
      double tol,
      int reorder,
      double[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqr(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      int[] singularity);

  /* -------- CPU linear solver by QR factorization
   *       solve A*x = b, A can be singular
   * [ls] stands for linear solve
   * [v] stands for vector
   * [qr] stands for QR factorization
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const FloatPointer b,
      float tol,
      int reorder,
      FloatPointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const FloatBuffer b,
      float tol,
      int reorder,
      FloatBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const float[] b,
      float tol,
      int reorder,
      float[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const DoublePointer b,
      double tol,
      int reorder,
      DoublePointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const DoubleBuffer b,
      double tol,
      int reorder,
      DoubleBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const double[] b,
      double tol,
      int reorder,
      double[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvqrHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      int[] singularity);

  /* -------- CPU linear solver by Cholesky factorization
   *       solve A*x = b, A can be singular
   * [ls] stands for linear solve
   * [v] stands for vector
   * [chol] stands for Cholesky factorization
   *
   * Only works for symmetric positive definite matrix.
   * The upper part of A is ignored.
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const FloatPointer b,
      float tol,
      int reorder,
      FloatPointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const FloatBuffer b,
      float tol,
      int reorder,
      FloatBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const float[] b,
      float tol,
      int reorder,
      float[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const DoublePointer b,
      double tol,
      int reorder,
      DoublePointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const DoubleBuffer b,
      double tol,
      int reorder,
      DoubleBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const double[] b,
      double tol,
      int reorder,
      double[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvcholHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      int[] singularity);

  /* -------- GPU linear solver by Cholesky factorization
   *       solve A*x = b, A can be singular
   * [ls] stands for linear solve
   * [v] stands for vector
   * [chol] stands for Cholesky factorization
   *
   * Only works for symmetric positive definite matrix.
   * The upper part of A is ignored.
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const FloatPointer b,
      float tol,
      int reorder,
      FloatPointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const FloatBuffer b,
      float tol,
      int reorder,
      FloatBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const float[] b,
      float tol,
      int reorder,
      float[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Const DoublePointer b,
      double tol,
      int reorder,
      DoublePointer x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Const DoubleBuffer b,
      double tol,
      int reorder,
      DoubleBuffer x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Const double[] b,
      double tol,
      int reorder,
      double[] x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int reorder,
      @Cast("cuComplex*") float2 x,
      int[] singularity);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer singularity);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsvchol(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int reorder,
      @Cast("cuDoubleComplex*") double2 x,
      int[] singularity);

  /* ----------- CPU least square solver by QR factorization
   *       solve min|b - A*x|
   * [lsq] stands for least square
   * [v] stands for vector
   * [qr] stands for QR factorization
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const FloatPointer b,
      float tol,
      IntPointer rankA,
      FloatPointer x,
      IntPointer p,
      FloatPointer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const FloatBuffer b,
      float tol,
      IntBuffer rankA,
      FloatBuffer x,
      IntBuffer p,
      FloatBuffer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const float[] b,
      float tol,
      int[] rankA,
      float[] x,
      int[] p,
      float[] min_norm);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const DoublePointer b,
      double tol,
      IntPointer rankA,
      DoublePointer x,
      IntPointer p,
      DoublePointer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const DoubleBuffer b,
      double tol,
      IntBuffer rankA,
      DoubleBuffer x,
      IntBuffer p,
      DoubleBuffer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const double[] b,
      double tol,
      int[] rankA,
      double[] x,
      int[] p,
      double[] min_norm);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      IntPointer rankA,
      @Cast("cuComplex*") float2 x,
      IntPointer p,
      FloatPointer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      IntBuffer rankA,
      @Cast("cuComplex*") float2 x,
      IntBuffer p,
      FloatBuffer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuComplex*") float2 b,
      float tol,
      int[] rankA,
      @Cast("cuComplex*") float2 x,
      int[] p,
      float[] min_norm);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      IntPointer rankA,
      @Cast("cuDoubleComplex*") double2 x,
      IntPointer p,
      DoublePointer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      IntBuffer rankA,
      @Cast("cuDoubleComplex*") double2 x,
      IntBuffer p,
      DoubleBuffer min_norm);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrlsqvqrHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      double tol,
      int[] rankA,
      @Cast("cuDoubleComplex*") double2 x,
      int[] p,
      double[] min_norm);

  /* --------- CPU eigenvalue solver by shift inverse
   *      solve A*x = lambda * x
   *   where lambda is the eigenvalue nearest mu0.
   * [eig] stands for eigenvalue solver
   * [si] stands for shift-inverse
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      float mu0,
      @Const FloatPointer x0,
      int maxite,
      float tol,
      FloatPointer mu,
      FloatPointer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      float mu0,
      @Const FloatBuffer x0,
      int maxite,
      float tol,
      FloatBuffer mu,
      FloatBuffer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      float mu0,
      @Const float[] x0,
      int maxite,
      float tol,
      float[] mu,
      float[] x);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      double mu0,
      @Const DoublePointer x0,
      int maxite,
      double tol,
      DoublePointer mu,
      DoublePointer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      double mu0,
      @Const DoubleBuffer x0,
      int maxite,
      double tol,
      DoubleBuffer mu,
      DoubleBuffer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      double mu0,
      @Const double[] x0,
      int maxite,
      double tol,
      double[] mu,
      double[] x);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float tol,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float tol,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float tol,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double tol,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double tol,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsiHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double tol,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);

  /* --------- GPU eigenvalue solver by shift inverse
   *      solve A*x = lambda * x
   *   where lambda is the eigenvalue nearest mu0.
   * [eig] stands for eigenvalue solver
   * [si] stands for shift-inverse
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      float mu0,
      @Const FloatPointer x0,
      int maxite,
      float eps,
      FloatPointer mu,
      FloatPointer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      float mu0,
      @Const FloatBuffer x0,
      int maxite,
      float eps,
      FloatBuffer mu,
      FloatBuffer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      float mu0,
      @Const float[] x0,
      int maxite,
      float eps,
      float[] mu,
      float[] x);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      double mu0,
      @Const DoublePointer x0,
      int maxite,
      double eps,
      DoublePointer mu,
      DoublePointer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      double mu0,
      @Const DoubleBuffer x0,
      int maxite,
      double eps,
      DoubleBuffer mu,
      DoubleBuffer x);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      double mu0,
      @Const double[] x0,
      int maxite,
      double eps,
      double[] mu,
      double[] x);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float eps,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float eps,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuComplex*") float2 mu0,
      @Cast("const cuComplex*") float2 x0,
      int maxite,
      float eps,
      @Cast("cuComplex*") float2 mu,
      @Cast("cuComplex*") float2 x);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double eps,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double eps,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigvsi(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 mu0,
      @Cast("const cuDoubleComplex*") double2 x0,
      int maxite,
      double eps,
      @Cast("cuDoubleComplex*") double2 mu,
      @Cast("cuDoubleComplex*") double2 x);

  // ----------- enclosed eigenvalues

  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      IntPointer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      IntBuffer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      int[] num_eigs);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      IntPointer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      IntBuffer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      int[] num_eigs);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      IntPointer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      IntBuffer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuComplex*") float2 left_bottom_corner,
      @ByVal @Cast("cuComplex*") float2 right_upper_corner,
      int[] num_eigs);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      IntPointer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      IntBuffer num_eigs);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsreigsHost(
      cusolverSpContext handle,
      int m,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @ByVal @Cast("cuDoubleComplex*") double2 left_bottom_corner,
      @ByVal @Cast("cuDoubleComplex*") double2 right_upper_corner,
      int[] num_eigs);

  /* --------- CPU symrcm
   *   Symmetric reverse Cuthill McKee permutation
   *
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymrcmHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymrcmHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymrcmHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] p);

  /* --------- CPU symmdq
   *   Symmetric minimum degree algorithm by quotient graph
   *
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymmdqHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymmdqHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymmdqHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] p);

  /* --------- CPU symmdq
   *   Symmetric Approximate minimum degree algorithm by quotient graph
   *
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymamdHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymamdHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrsymamdHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] p);

  /* --------- CPU metis
   *   symmetric reordering
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrmetisndHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const int64_t*") LongPointer options,
      IntPointer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrmetisndHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const int64_t*") LongBuffer options,
      IntBuffer p);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrmetisndHost(
      cusolverSpContext handle,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const int64_t*") long[] options,
      int[] p);

  /* --------- CPU zfd
   *  Zero free diagonal reordering
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer P,
      IntPointer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer P,
      IntBuffer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] P,
      int[] numnz);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer P,
      IntPointer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer P,
      IntBuffer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] P,
      int[] numnz);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer P,
      IntPointer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer P,
      IntBuffer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] P,
      int[] numnz);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      IntPointer P,
      IntPointer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      IntBuffer P,
      IntBuffer numnz);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrzfdHost(
      cusolverSpContext handle,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      int[] P,
      int[] numnz);

  /* --------- CPU permuation
   *   P*A*Q^T
   *
   */
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrperm_bufferSizeHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const IntPointer p,
      @Const IntPointer q,
      @Cast("size_t*") SizeTPointer bufferSizeInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrperm_bufferSizeHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const IntBuffer p,
      @Const IntBuffer q,
      @Cast("size_t*") SizeTPointer bufferSizeInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrperm_bufferSizeHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const int[] p,
      @Const int[] q,
      @Cast("size_t*") SizeTPointer bufferSizeInBytes);

  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrpermHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      IntPointer csrRowPtrA,
      IntPointer csrColIndA,
      @Const IntPointer p,
      @Const IntPointer q,
      IntPointer map,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrpermHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      IntBuffer csrRowPtrA,
      IntBuffer csrColIndA,
      @Const IntBuffer p,
      @Const IntBuffer q,
      IntBuffer map,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrpermHost(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      int[] csrRowPtrA,
      int[] csrColIndA,
      @Const int[] p,
      @Const int[] q,
      int[] map,
      Pointer pBuffer);

  /*
   *  Low-level API: Batched QR
   *
   */

  public static native @Cast("cusolverStatus_t") int cusolverSpCreateCsrqrInfo(@ByPtrPtr csrqrInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverSpDestroyCsrqrInfo(csrqrInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrqrAnalysisBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      csrqrInfo info);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrqrAnalysisBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      csrqrInfo info);
  public static native @Cast("cusolverStatus_t") int cusolverSpXcsrqrAnalysisBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnzA,
      cusparseMatDescr descrA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      csrqrInfo info);

  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntPointer csrRowPtr,
      @Const IntPointer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const IntBuffer csrRowPtr,
      @Const IntBuffer csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrBufferInfoBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrVal,
      @Const int[] csrRowPtr,
      @Const int[] csrColInd,
      int batchSize,
      csrqrInfo info,
      @Cast("size_t*") SizeTPointer internalDataInBytes,
      @Cast("size_t*") SizeTPointer workspaceInBytes);

  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatPointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const FloatPointer b,
      FloatPointer x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const FloatBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const FloatBuffer b,
      FloatBuffer x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpScsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const float[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const float[] b,
      float[] x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);

  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoublePointer csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Const DoublePointer b,
      DoublePointer x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const DoubleBuffer csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Const DoubleBuffer b,
      DoubleBuffer x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpDcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Const double[] csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Const double[] b,
      double[] x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);

  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      @Cast("cuComplex*") float2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuComplex*") float2 b,
      @Cast("cuComplex*") float2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpCcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuComplex*") float2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuComplex*") float2 b,
      @Cast("cuComplex*") float2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);

  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntPointer csrRowPtrA,
      @Const IntPointer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      @Cast("cuDoubleComplex*") double2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const IntBuffer csrRowPtrA,
      @Const IntBuffer csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      @Cast("cuDoubleComplex*") double2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);
  public static native @Cast("cusolverStatus_t") int cusolverSpZcsrqrsvBatched(
      cusolverSpContext handle,
      int m,
      int n,
      int nnz,
      cusparseMatDescr descrA,
      @Cast("const cuDoubleComplex*") double2 csrValA,
      @Const int[] csrRowPtrA,
      @Const int[] csrColIndA,
      @Cast("const cuDoubleComplex*") double2 b,
      @Cast("cuDoubleComplex*") double2 x,
      int batchSize,
      csrqrInfo info,
      Pointer pBuffer);

//   #if defined(__cplusplus)
//   #endif /* __cplusplus */

// #endif // define CUSOLVERSP_H_


}
