// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cusparse.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class cusparse extends org.bytedeco.cuda.presets.cusparse {
    static { Loader.load(); }

// Parsed from <cusparse.h>

/*
 * Copyright 1993-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */
// #if !defined(CUSPARSE_H_)
// #define CUSPARSE_H_

// #include <cuComplex.h>        // cuComplex
// #include <cuda_runtime_api.h> // cudaStream_t
// #include <library_types.h>    // CUDA_R_32F
// #include <stdint.h>           // int64_t
// #include <stdio.h>            // FILE*

// #if defined(__cplusplus)
// #   include <cuda_fp16.h>     // __half
// #endif // defined(__cplusplus)

//##############################################################################
//# CUSPARSE VERSION INFORMATION
//##############################################################################

public static final int CUSPARSE_VER_MAJOR = 12;
public static final int CUSPARSE_VER_MINOR = 1;
public static final int CUSPARSE_VER_PATCH = 0;
public static final int CUSPARSE_VER_BUILD = 106;
public static final int CUSPARSE_VERSION = (CUSPARSE_VER_MAJOR * 1000 + 
                          CUSPARSE_VER_MINOR *  100 + 
                          CUSPARSE_VER_PATCH);

// #############################################################################
// # BASIC MACROS
// #############################################################################

// #if !defined(CUSPARSEAPI)
// #    if defined(_WIN32)
// #        define CUSPARSEAPI __stdcall
// #    else
// #        define CUSPARSEAPI
// #    endif
// #endif

//------------------------------------------------------------------------------

// #if !defined(_MSC_VER)
// #   define CUSPARSE_CPP_VERSION __cplusplus
// #elif _MSC_FULL_VER >= 190024210 // Visual Studio 2015 Update 3
// #   define CUSPARSE_CPP_VERSION _MSVC_LANG
// #else
// #   define CUSPARSE_CPP_VERSION 0
// #endif

// #############################################################################
// # CUSPARSE_DEPRECATED MACRO
// #############################################################################

// #if !defined(DISABLE_CUSPARSE_DEPRECATED)

// #else // defined(DISABLE_CUSPARSE_DEPRECATED)

// #   define CUSPARSE_DEPRECATED(new_func)
// #   define CUSPARSE_DEPRECATED_ENUM(new_enum)

// #endif // !defined(DISABLE_CUSPARSE_DEPRECATED)

// #undef CUSPARSE_CPP_VERSION

//------------------------------------------------------------------------------

// #if defined(__cplusplus)
// Targeting ../cusparse/cusparseContext.java


// Targeting ../cusparse/cusparseMatDescr.java


// Targeting ../cusparse/bsrsv2Info.java


// Targeting ../cusparse/bsrsm2Info.java


// Targeting ../cusparse/csric02Info.java


// Targeting ../cusparse/bsric02Info.java


// Targeting ../cusparse/csrilu02Info.java


// Targeting ../cusparse/bsrilu02Info.java


// Targeting ../cusparse/csru2csrInfo.java


// Targeting ../cusparse/cusparseColorInfo.java


// Targeting ../cusparse/pruneInfo.java



//##############################################################################
//# ENUMERATORS
//##############################################################################

/** enum cusparseStatus_t */
public static final int
    CUSPARSE_STATUS_SUCCESS                   = 0,
    CUSPARSE_STATUS_NOT_INITIALIZED           = 1,
    CUSPARSE_STATUS_ALLOC_FAILED              = 2,
    CUSPARSE_STATUS_INVALID_VALUE             = 3,
    CUSPARSE_STATUS_ARCH_MISMATCH             = 4,
    CUSPARSE_STATUS_MAPPING_ERROR             = 5,
    CUSPARSE_STATUS_EXECUTION_FAILED          = 6,
    CUSPARSE_STATUS_INTERNAL_ERROR            = 7,
    CUSPARSE_STATUS_MATRIX_TYPE_NOT_SUPPORTED = 8,
    CUSPARSE_STATUS_ZERO_PIVOT                = 9,
    CUSPARSE_STATUS_NOT_SUPPORTED             = 10,
    CUSPARSE_STATUS_INSUFFICIENT_RESOURCES    = 11;

/** enum cusparsePointerMode_t */
public static final int
    CUSPARSE_POINTER_MODE_HOST   = 0,
    CUSPARSE_POINTER_MODE_DEVICE = 1;

/** enum cusparseAction_t */
public static final int
    CUSPARSE_ACTION_SYMBOLIC = 0,
    CUSPARSE_ACTION_NUMERIC  = 1;

/** enum cusparseMatrixType_t */
public static final int
    CUSPARSE_MATRIX_TYPE_GENERAL    = 0,
    CUSPARSE_MATRIX_TYPE_SYMMETRIC  = 1,
    CUSPARSE_MATRIX_TYPE_HERMITIAN  = 2,
    CUSPARSE_MATRIX_TYPE_TRIANGULAR = 3;

/** enum cusparseFillMode_t */
public static final int
    CUSPARSE_FILL_MODE_LOWER = 0,
    CUSPARSE_FILL_MODE_UPPER = 1;

/** enum cusparseDiagType_t */
public static final int
    CUSPARSE_DIAG_TYPE_NON_UNIT = 0,
    CUSPARSE_DIAG_TYPE_UNIT     = 1;

/** enum cusparseIndexBase_t */
public static final int
    CUSPARSE_INDEX_BASE_ZERO = 0,
    CUSPARSE_INDEX_BASE_ONE  = 1;

/** enum cusparseOperation_t */
public static final int
    CUSPARSE_OPERATION_NON_TRANSPOSE       = 0,
    CUSPARSE_OPERATION_TRANSPOSE           = 1,
    CUSPARSE_OPERATION_CONJUGATE_TRANSPOSE = 2;

/** enum cusparseDirection_t */
public static final int
    CUSPARSE_DIRECTION_ROW    = 0,
    CUSPARSE_DIRECTION_COLUMN = 1;

/** enum cusparseSolvePolicy_t */
public static final int
    CUSPARSE_SOLVE_POLICY_NO_LEVEL = 0,
    CUSPARSE_SOLVE_POLICY_USE_LEVEL = 1;

/** enum cusparseColorAlg_t */
public static final int
    CUSPARSE_COLOR_ALG0 = 0, // default
    CUSPARSE_COLOR_ALG1 = 1;

//##############################################################################
//# INITIALIZATION AND MANAGEMENT ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCreate(@ByPtrPtr cusparseContext handle);

public static native @Cast("cusparseStatus_t") int cusparseDestroy(cusparseContext handle);

public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   IntPointer version);
public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   IntBuffer version);
public static native @Cast("cusparseStatus_t") int cusparseGetVersion(cusparseContext handle,
                   int[] version);

public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    IntPointer value);
public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    IntBuffer value);
public static native @Cast("cusparseStatus_t") int cusparseGetProperty(@Cast("libraryPropertyType") int type,
                    int[] value);

public static native @Cast("const char*") BytePointer cusparseGetErrorName(@Cast("cusparseStatus_t") int status);

public static native @Cast("const char*") BytePointer cusparseGetErrorString(@Cast("cusparseStatus_t") int status);

public static native @Cast("cusparseStatus_t") int cusparseSetStream(cusparseContext handle,
                  CUstream_st streamId);

public static native @Cast("cusparseStatus_t") int cusparseGetStream(cusparseContext handle,
                  @ByPtrPtr CUstream_st streamId);

public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") IntPointer mode);
public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") IntBuffer mode);
public static native @Cast("cusparseStatus_t") int cusparseGetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t*") int[] mode);

public static native @Cast("cusparseStatus_t") int cusparseSetPointerMode(cusparseContext handle,
                       @Cast("cusparsePointerMode_t") int mode);
// Targeting ../cusparse/cusparseLoggerCallback_t.java



public static native @Cast("cusparseStatus_t") int cusparseLoggerSetCallback(cusparseLoggerCallback_t callback);

public static native @Cast("cusparseStatus_t") int cusparseLoggerSetFile(@Cast("FILE*") Pointer file);

public static native @Cast("cusparseStatus_t") int cusparseLoggerOpenFile(@Cast("const char*") BytePointer logFile);
public static native @Cast("cusparseStatus_t") int cusparseLoggerOpenFile(String logFile);

public static native @Cast("cusparseStatus_t") int cusparseLoggerSetLevel(int level);

public static native @Cast("cusparseStatus_t") int cusparseLoggerSetMask(int mask);

public static native @Cast("cusparseStatus_t") int cusparseLoggerForceDisable();

//##############################################################################
//# HELPER ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCreateMatDescr(@ByPtrPtr cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseDestroyMatDescr(cusparseMatDescr descrA);

//cusparseStatus_t CUSPARSEAPI
//cusparseCopyMatDescr(cusparseMatDescr_t       dest,
//                     const cusparseMatDescr_t src);

public static native @Cast("cusparseStatus_t") int cusparseSetMatType(cusparseMatDescr descrA,
                   @Cast("cusparseMatrixType_t") int type);

public static native @Cast("cusparseMatrixType_t") int cusparseGetMatType(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatFillMode(cusparseMatDescr descrA,
                       @Cast("cusparseFillMode_t") int fillMode);

public static native @Cast("cusparseFillMode_t") int cusparseGetMatFillMode(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatDiagType(cusparseMatDescr descrA,
                       @Cast("cusparseDiagType_t") int diagType);

public static native @Cast("cusparseDiagType_t") int cusparseGetMatDiagType(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseSetMatIndexBase(cusparseMatDescr descrA,
                        @Cast("cusparseIndexBase_t") int base);

public static native @Cast("cusparseIndexBase_t") int cusparseGetMatIndexBase(cusparseMatDescr descrA);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsric02Info(@ByPtrPtr csric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsric02Info(csric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsric02Info(@ByPtrPtr bsric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsric02Info(bsric02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsrilu02Info(@ByPtrPtr csrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsrilu02Info(csrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrilu02Info(@ByPtrPtr bsrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrilu02Info(bsrilu02Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrsv2Info(@ByPtrPtr bsrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrsv2Info(bsrsv2Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateBsrsm2Info(@ByPtrPtr bsrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyBsrsm2Info(bsrsm2Info info);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsru2csrInfo(@ByPtrPtr csru2csrInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyCsru2csrInfo(csru2csrInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCreateColorInfo(@ByPtrPtr cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyColorInfo(cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCreatePruneInfo(@ByPtrPtr pruneInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDestroyPruneInfo(pruneInfo info);

//##############################################################################
//# SPARSE LEVEL 2 ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const FloatPointer alpha,
               @Const FloatPointer A,
               int lda,
               int nnz,
               @Const FloatPointer xVal,
               @Const IntPointer xInd,
               @Const FloatPointer beta,
               FloatPointer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const FloatBuffer alpha,
               @Const FloatBuffer A,
               int lda,
               int nnz,
               @Const FloatBuffer xVal,
               @Const IntBuffer xInd,
               @Const FloatBuffer beta,
               FloatBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const float[] alpha,
               @Const float[] A,
               int lda,
               int nnz,
               @Const float[] xVal,
               @Const int[] xInd,
               @Const float[] beta,
               float[] y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseSgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const DoublePointer alpha,
               @Const DoublePointer A,
               int lda,
               int nnz,
               @Const DoublePointer xVal,
               @Const IntPointer xInd,
               @Const DoublePointer beta,
               DoublePointer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const DoubleBuffer alpha,
               @Const DoubleBuffer A,
               int lda,
               int nnz,
               @Const DoubleBuffer xVal,
               @Const IntBuffer xInd,
               @Const DoubleBuffer beta,
               DoubleBuffer y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Const double[] alpha,
               @Const double[] A,
               int lda,
               int nnz,
               @Const double[] xVal,
               @Const int[] xInd,
               @Const double[] beta,
               double[] y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseDgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuComplex*") float2 alpha,
               @Cast("const cuComplex*") float2 A,
               int lda,
               int nnz,
               @Cast("const cuComplex*") float2 xVal,
               @Const int[] xInd,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntPointer xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const IntBuffer xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi(cusparseContext handle,
               @Cast("cusparseOperation_t") int transA,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 alpha,
               @Cast("const cuDoubleComplex*") double2 A,
               int lda,
               int nnz,
               @Cast("const cuDoubleComplex*") double2 xVal,
               @Const int[] xInd,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y,
               @Cast("cusparseIndexBase_t") int idxBase,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntPointer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          IntBuffer pBufferSize);
public static native @Cast("cusparseStatus_t") int cusparseZgemvi_bufferSize(cusparseContext handle,
                          @Cast("cusparseOperation_t") int transA,
                          int m,
                          int n,
                          int nnz,
                          int[] pBufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Const FloatPointer x,
               @Const FloatPointer beta,
               FloatPointer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Const FloatBuffer x,
               @Const FloatBuffer beta,
               FloatBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Const float[] x,
               @Const float[] beta,
               float[] y);

public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Const DoublePointer x,
               @Const DoublePointer beta,
               DoublePointer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Const DoubleBuffer x,
               @Const DoubleBuffer beta,
               DoubleBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Const double[] x,
               @Const double[] beta,
               double[] y);

public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Cast("const cuComplex*") float2 x,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmv(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               int mb,
               int nb,
               int nnzb,
               @Cast("const cuDoubleComplex*") double2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockDim,
               @Cast("const cuDoubleComplex*") double2 x,
               @Cast("const cuDoubleComplex*") double2 beta,
               @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const FloatPointer alpha,
                cusparseMatDescr descrA,
                @Const FloatPointer bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Const FloatPointer x,
                @Const FloatPointer beta,
                FloatPointer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const FloatBuffer alpha,
                cusparseMatDescr descrA,
                @Const FloatBuffer bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Const FloatBuffer x,
                @Const FloatBuffer beta,
                FloatBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseSbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const float[] alpha,
                cusparseMatDescr descrA,
                @Const float[] bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Const float[] x,
                @Const float[] beta,
                float[] y);

public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const DoublePointer alpha,
                cusparseMatDescr descrA,
                @Const DoublePointer bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Const DoublePointer x,
                @Const DoublePointer beta,
                DoublePointer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const DoubleBuffer alpha,
                cusparseMatDescr descrA,
                @Const DoubleBuffer bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Const DoubleBuffer x,
                @Const DoubleBuffer beta,
                DoubleBuffer y);
public static native @Cast("cusparseStatus_t") int cusparseDbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Const double[] alpha,
                cusparseMatDescr descrA,
                @Const double[] bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Const double[] x,
                @Const double[] beta,
                double[] y);

public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);
public static native @Cast("cusparseStatus_t") int cusparseCbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuComplex*") float2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuComplex*") float2 bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Cast("const cuComplex*") float2 x,
                @Cast("const cuComplex*") float2 beta,
                @Cast("cuComplex*") float2 y);

public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntPointer bsrSortedMaskPtrA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedEndPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuDoubleComplex*") double2 x,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntBuffer bsrSortedMaskPtrA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedEndPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockDim,
                @Cast("const cuDoubleComplex*") double2 x,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 y);
public static native @Cast("cusparseStatus_t") int cusparseZbsrxmv(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                int sizeOfMask,
                int mb,
                int nb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const int[] bsrSortedMaskPtrA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedEndPtrA,
                @Const int[] bsrSortedColIndA,
                int blockDim,
                @Cast("const cuDoubleComplex*") double2 x,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 y);

public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsv2_zeroPivot(cusparseContext handle,
                          bsrsv2Info info,
                          int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const IntPointer bsrSortedRowPtrA,
                           @Const IntPointer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const IntBuffer bsrSortedRowPtrA,
                           @Const IntBuffer bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedValA,
                           @Const int[] bsrSortedRowPtrA,
                           @Const int[] bsrSortedColIndA,
                           int blockDim,
                           bsrsv2Info info,
                           int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatPointer bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const float[] bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoublePointer bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const double[] bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const IntPointer bsrSortedRowPtrA,
                         @Const IntPointer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const IntBuffer bsrSortedRowPtrA,
                         @Const IntBuffer bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         int mb,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                         @Const int[] bsrSortedRowPtrA,
                         @Const int[] bsrSortedColIndA,
                         int blockDim,
                         bsrsv2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const FloatPointer f,
                      FloatPointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const FloatBuffer f,
                      FloatBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const float[] f,
                      float[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const DoublePointer f,
                      DoublePointer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const DoubleBuffer f,
                      DoubleBuffer x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Const double[] f,
                      double[] x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuComplex*") float2 f,
                      @Cast("cuComplex*") float2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const IntPointer bsrSortedRowPtrA,
                      @Const IntPointer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const IntBuffer bsrSortedRowPtrA,
                      @Const IntBuffer bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsv2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      int mb,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                      @Const int[] bsrSortedRowPtrA,
                      @Const int[] bsrSortedColIndA,
                      int blockDim,
                      bsrsv2Info info,
                      @Cast("const cuDoubleComplex*") double2 f,
                      @Cast("cuDoubleComplex*") double2 x,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

//##############################################################################
//# SPARSE LEVEL 3 ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const FloatPointer alpha,
               cusparseMatDescr descrA,
               @Const FloatPointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Const FloatPointer B,
               int ldb,
               @Const FloatPointer beta,
               FloatPointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const FloatBuffer alpha,
               cusparseMatDescr descrA,
               @Const FloatBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Const FloatBuffer B,
               int ldb,
               @Const FloatBuffer beta,
               FloatBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseSbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const float[] alpha,
               cusparseMatDescr descrA,
               @Const float[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Const float[] B,
               int ldb,
               @Const float[] beta,
               float[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const DoublePointer alpha,
               cusparseMatDescr descrA,
               @Const DoublePointer bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Const DoublePointer B,
               int ldb,
               @Const DoublePointer beta,
               DoublePointer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const DoubleBuffer alpha,
               cusparseMatDescr descrA,
               @Const DoubleBuffer bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Const DoubleBuffer B,
               int ldb,
               @Const DoubleBuffer beta,
               DoubleBuffer C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseDbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Const double[] alpha,
               cusparseMatDescr descrA,
               @Const double[] bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Const double[] B,
               int ldb,
               @Const double[] beta,
               double[] C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntPointer bsrSortedRowPtrA,
               @Const IntPointer bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const IntBuffer bsrSortedRowPtrA,
               @Const IntBuffer bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);
public static native @Cast("cusparseStatus_t") int cusparseCbsrmm(cusparseContext handle,
               @Cast("cusparseDirection_t") int dirA,
               @Cast("cusparseOperation_t") int transA,
               @Cast("cusparseOperation_t") int transB,
               int mb,
               int n,
               int kb,
               int nnzb,
               @Cast("const cuComplex*") float2 alpha,
               cusparseMatDescr descrA,
               @Cast("const cuComplex*") float2 bsrSortedValA,
               @Const int[] bsrSortedRowPtrA,
               @Const int[] bsrSortedColIndA,
               int blockSize,
               @Cast("const cuComplex*") float2 B,
               int ldb,
               @Cast("const cuComplex*") float2 beta,
               @Cast("cuComplex*") float2 C,
               int ldc);

public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntPointer bsrSortedRowPtrA,
                @Const IntPointer bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const IntBuffer bsrSortedRowPtrA,
                @Const IntBuffer bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);
public static native @Cast("cusparseStatus_t") int cusparseZbsrmm(cusparseContext handle,
                @Cast("cusparseDirection_t") int dirA,
                @Cast("cusparseOperation_t") int transA,
                @Cast("cusparseOperation_t") int transB,
                int mb,
                int n,
                int kb,
                int nnzb,
                @Cast("const cuDoubleComplex*") double2 alpha,
                cusparseMatDescr descrA,
                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                @Const int[] bsrSortedRowPtrA,
                @Const int[] bsrSortedColIndA,
                int blockSize,
                @Cast("const cuDoubleComplex*") double2 B,
                int ldb,
                @Cast("const cuDoubleComplex*") double2 beta,
                @Cast("cuDoubleComplex*") double2 C,
                int ldc);

public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrsm2_zeroPivot(cusparseContext handle,
                          bsrsm2Info info,
                          int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_bufferSize(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           @Cast("cusparseOperation_t") int transA,
                           @Cast("cusparseOperation_t") int transXY,
                           int mb,
                           int n,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockSize,
                           bsrsm2Info info,
                           int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatPointer bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const float[] bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoublePointer bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const DoubleBuffer bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Const double[] bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuComplex*") float2 bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const IntPointer bsrSortedRowPtr,
                         @Const IntPointer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const IntBuffer bsrSortedRowPtr,
                         @Const IntBuffer bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_analysis(cusparseContext handle,
                         @Cast("cusparseDirection_t") int dirA,
                         @Cast("cusparseOperation_t") int transA,
                         @Cast("cusparseOperation_t") int transXY,
                         int mb,
                         int n,
                         int nnzb,
                         cusparseMatDescr descrA,
                         @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                         @Const int[] bsrSortedRowPtr,
                         @Const int[] bsrSortedColInd,
                         int blockSize,
                         bsrsm2Info info,
                         @Cast("cusparseSolvePolicy_t") int policy,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const FloatPointer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatPointer bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const FloatPointer B,
                      int ldb,
                      FloatPointer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const FloatBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const FloatBuffer B,
                      int ldb,
                      FloatBuffer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const float[] alpha,
                      cusparseMatDescr descrA,
                      @Const float[] bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const float[] B,
                      int ldb,
                      float[] X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const DoublePointer alpha,
                      cusparseMatDescr descrA,
                      @Const DoublePointer bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const DoublePointer B,
                      int ldb,
                      DoublePointer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const DoubleBuffer alpha,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const DoubleBuffer B,
                      int ldb,
                      DoubleBuffer X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Const double[] alpha,
                      cusparseMatDescr descrA,
                      @Const double[] bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Const double[] B,
                      int ldb,
                      double[] X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuComplex*") float2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuComplex*") float2 bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuComplex*") float2 B,
                      int ldb,
                      @Cast("cuComplex*") float2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const IntPointer bsrSortedRowPtr,
                      @Const IntPointer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const IntBuffer bsrSortedRowPtr,
                      @Const IntBuffer bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrsm2_solve(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      @Cast("cusparseOperation_t") int transA,
                      @Cast("cusparseOperation_t") int transXY,
                      int mb,
                      int n,
                      int nnzb,
                      @Cast("const cuDoubleComplex*") double2 alpha,
                      cusparseMatDescr descrA,
                      @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                      @Const int[] bsrSortedRowPtr,
                      @Const int[] bsrSortedColInd,
                      int blockSize,
                      bsrsm2Info info,
                      @Cast("const cuDoubleComplex*") double2 B,
                      int ldb,
                      @Cast("cuDoubleComplex*") double2 X,
                      int ldx,
                      @Cast("cusparseSolvePolicy_t") int policy,
                      Pointer pBuffer);

//##############################################################################
//# PRECONDITIONERS
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               FloatPointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               FloatBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               float[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               DoublePointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               DoubleBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               double[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuComplex*") float2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_numericBoost(cusparseContext handle,
                               csrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXcsrilu02_zeroPivot(cusparseContext handle,
                            csrilu02Info info,
                            int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             FloatPointer csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             FloatBuffer csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             float[] csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             DoublePointer csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             DoubleBuffer csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             double[] csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const IntPointer csrSortedRowPtrA,
                             @Const IntPointer csrSortedColIndA,
                             csrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const IntBuffer csrSortedRowPtrA,
                             @Const IntBuffer csrSortedColIndA,
                             csrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_bufferSize(cusparseContext handle,
                             int m,
                             int nnz,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 csrSortedValA,
                             @Const int[] csrSortedRowPtrA,
                             @Const int[] csrSortedColIndA,
                             csrilu02Info info,
                             int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const FloatPointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const FloatBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const float[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const DoublePointer csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const DoubleBuffer csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Const double[] csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuComplex*") float2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntPointer csrSortedRowPtrA,
                           @Const IntPointer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const IntBuffer csrSortedRowPtrA,
                           @Const IntBuffer csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02_analysis(cusparseContext handle,
                           int m,
                           int nnz,
                           cusparseMatDescr descrA,
                           @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                           @Const int[] csrSortedRowPtrA,
                           @Const int[] csrSortedColIndA,
                           csrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrilu02(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  csrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               FloatPointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               FloatBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               float[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               DoublePointer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               DoubleBuffer boost_val);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               double[] boost_val);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuComplex*") float2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuComplex*") float2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoublePointer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               DoubleBuffer tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_numericBoost(cusparseContext handle,
                               bsrilu02Info info,
                               int enable_boost,
                               double[] tol,
                               @Cast("cuDoubleComplex*") double2 boost_val);

public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsrilu02_zeroPivot(cusparseContext handle,
                            bsrilu02Info info,
                            int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             FloatPointer bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             FloatBuffer bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             float[] bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             DoublePointer bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             DoubleBuffer bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             double[] bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuComplex*") float2 bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const IntPointer bsrSortedRowPtr,
                             @Const IntPointer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const IntBuffer bsrSortedRowPtr,
                             @Const IntBuffer bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_bufferSize(cusparseContext handle,
                             @Cast("cusparseDirection_t") int dirA,
                             int mb,
                             int nnzb,
                             cusparseMatDescr descrA,
                             @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                             @Const int[] bsrSortedRowPtr,
                             @Const int[] bsrSortedColInd,
                             int blockDim,
                             bsrilu02Info info,
                             int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatPointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           FloatBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           float[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoublePointer bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           DoubleBuffer bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           double[] bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuComplex*") float2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntPointer bsrSortedRowPtr,
                           @Const IntPointer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const IntBuffer bsrSortedRowPtr,
                           @Const IntBuffer bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02_analysis(cusparseContext handle,
                           @Cast("cusparseDirection_t") int dirA,
                           int mb,
                           int nnzb,
                           cusparseMatDescr descrA,
                           @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                           @Const int[] bsrSortedRowPtr,
                           @Const int[] bsrSortedColInd,
                           int blockDim,
                           bsrilu02Info info,
                           @Cast("cusparseSolvePolicy_t") int policy,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  FloatPointer bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  FloatBuffer bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  float[] bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  DoublePointer bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  DoubleBuffer bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  double[] bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const IntPointer bsrSortedRowPtr,
                  @Const IntPointer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const IntBuffer bsrSortedRowPtr,
                  @Const IntBuffer bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsrilu02(cusparseContext handle,
                  @Cast("cusparseDirection_t") int dirA,
                  int mb,
                  int nnzb,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                  @Const int[] bsrSortedRowPtr,
                  @Const int[] bsrSortedColInd,
                  int blockDim,
                  bsrilu02Info info,
                  @Cast("cusparseSolvePolicy_t") int policy,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXcsric02_zeroPivot(cusparseContext handle,
                           csric02Info info,
                           int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            FloatPointer csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            FloatBuffer csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            float[] csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            DoublePointer csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            DoubleBuffer csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            double[] csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const IntPointer csrSortedRowPtrA,
                            @Const IntPointer csrSortedColIndA,
                            csric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const IntBuffer csrSortedRowPtrA,
                            @Const IntBuffer csrSortedColIndA,
                            csric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_bufferSize(cusparseContext handle,
                            int m,
                            int nnz,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 csrSortedValA,
                            @Const int[] csrSortedRowPtrA,
                            @Const int[] csrSortedColIndA,
                            csric02Info info,
                            int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const FloatPointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const float[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02_analysis(cusparseContext handle,
                          int m,
                          int nnz,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          csric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 FloatPointer csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 FloatBuffer csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 float[] csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 DoublePointer csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 DoubleBuffer csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 double[] csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsric02(cusparseContext handle,
                 int m,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 csrSortedValA_valM,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 csric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           IntPointer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           IntBuffer _position);
public static native @Cast("cusparseStatus_t") int cusparseXbsric02_zeroPivot(cusparseContext handle,
                           bsric02Info info,
                           int[] _position);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            FloatPointer bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            FloatBuffer bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            float[] bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            DoublePointer bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            DoubleBuffer bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            double[] bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuComplex*") float2 bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const IntPointer bsrSortedRowPtr,
                            @Const IntPointer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const IntBuffer bsrSortedRowPtr,
                            @Const IntBuffer bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_bufferSize(cusparseContext handle,
                            @Cast("cusparseDirection_t") int dirA,
                            int mb,
                            int nnzb,
                            cusparseMatDescr descrA,
                            @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                            @Const int[] bsrSortedRowPtr,
                            @Const int[] bsrSortedColInd,
                            int blockDim,
                            bsric02Info info,
                            int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const FloatPointer bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const float[] bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const DoublePointer bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Const double[] bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const IntPointer bsrSortedRowPtr,
                          @Const IntPointer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const IntBuffer bsrSortedRowPtr,
                          @Const IntBuffer bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02_analysis(cusparseContext handle,
                          @Cast("cusparseDirection_t") int dirA,
                          int mb,
                          int nnzb,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                          @Const int[] bsrSortedRowPtr,
                          @Const int[] bsrSortedColInd,
                          int blockDim,
                          bsric02Info info,
                          @Cast("cusparseSolvePolicy_t") int policy,
                          Pointer pInputBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 FloatPointer bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 FloatBuffer bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 float[] bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 DoublePointer bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 DoubleBuffer bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 double[] bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuComplex*") float2 bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const IntPointer bsrSortedRowPtr,
                 @Const IntPointer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const IntBuffer bsrSortedRowPtr,
                 @Const IntBuffer bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZbsric02(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nnzb,
                 cusparseMatDescr descrA,
                 @Cast("cuDoubleComplex*") double2 bsrSortedVal,
                 @Const int[] bsrSortedRowPtr,
                 @Const int[] bsrSortedColInd,
                 int blockDim,
                 bsric02Info info,
                 @Cast("cusparseSolvePolicy_t") int policy,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const FloatPointer dl,
                             @Const FloatPointer d,
                             @Const FloatPointer du,
                             @Const FloatPointer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const FloatBuffer dl,
                             @Const FloatBuffer d,
                             @Const FloatBuffer du,
                             @Const FloatBuffer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const float[] dl,
                             @Const float[] d,
                             @Const float[] du,
                             @Const float[] B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const DoublePointer dl,
                             @Const DoublePointer d,
                             @Const DoublePointer du,
                             @Const DoublePointer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const DoubleBuffer dl,
                             @Const DoubleBuffer d,
                             @Const DoubleBuffer du,
                             @Const DoubleBuffer B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Const double[] dl,
                             @Const double[] d,
                             @Const double[] du,
                             @Const double[] B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Cast("const cuComplex*") float2 dl,
                             @Cast("const cuComplex*") float2 d,
                             @Cast("const cuComplex*") float2 du,
                             @Cast("const cuComplex*") float2 B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_bufferSizeExt(cusparseContext handle,
                             int m,
                             int n,
                             @Cast("const cuDoubleComplex*") double2 dl,
                             @Cast("const cuDoubleComplex*") double2 d,
                             @Cast("const cuDoubleComplex*") double2 du,
                             @Cast("const cuDoubleComplex*") double2 B,
                             int ldb,
                             @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const FloatPointer dl,
               @Const FloatPointer d,
               @Const FloatPointer du,
               FloatPointer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const FloatBuffer dl,
               @Const FloatBuffer d,
               @Const FloatBuffer du,
               FloatBuffer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const float[] dl,
               @Const float[] d,
               @Const float[] du,
               float[] B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const DoublePointer dl,
               @Const DoublePointer d,
               @Const DoublePointer du,
               DoublePointer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const DoubleBuffer dl,
               @Const DoubleBuffer d,
               @Const DoubleBuffer du,
               DoubleBuffer B,
               int ldb,
               Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2(cusparseContext handle,
               int m,
               int n,
               @Const double[] dl,
               @Const double[] d,
               @Const double[] du,
               double[] B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2(cusparseContext handle,
               int m,
               int n,
               @Cast("const cuComplex*") float2 dl,
               @Cast("const cuComplex*") float2 d,
               @Cast("const cuComplex*") float2 du,
               @Cast("cuComplex*") float2 B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2(cusparseContext handle,
               int m,
               int n,
               @Cast("const cuDoubleComplex*") double2 dl,
               @Cast("const cuDoubleComplex*") double2 d,
               @Cast("const cuDoubleComplex*") double2 du,
               @Cast("cuDoubleComplex*") double2 B,
               int ldb,
               Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const FloatPointer dl,
                                     @Const FloatPointer d,
                                     @Const FloatPointer du,
                                     @Const FloatPointer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const FloatBuffer dl,
                                     @Const FloatBuffer d,
                                     @Const FloatBuffer du,
                                     @Const FloatBuffer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const float[] dl,
                                     @Const float[] d,
                                     @Const float[] du,
                                     @Const float[] B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const DoublePointer dl,
                                     @Const DoublePointer d,
                                     @Const DoublePointer du,
                                     @Const DoublePointer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const DoubleBuffer dl,
                                     @Const DoubleBuffer d,
                                     @Const DoubleBuffer du,
                                     @Const DoubleBuffer B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Const double[] dl,
                                     @Const double[] d,
                                     @Const double[] du,
                                     @Const double[] B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Cast("const cuComplex*") float2 dl,
                                     @Cast("const cuComplex*") float2 d,
                                     @Cast("const cuComplex*") float2 du,
                                     @Cast("const cuComplex*") float2 B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_nopivot_bufferSizeExt(cusparseContext handle,
                                     int m,
                                     int n,
                                     @Cast("const cuDoubleComplex*") double2 dl,
                                     @Cast("const cuDoubleComplex*") double2 d,
                                     @Cast("const cuDoubleComplex*") double2 du,
                                     @Cast("const cuDoubleComplex*") double2 B,
                                     int ldb,
                                     @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const FloatPointer dl,
                       @Const FloatPointer d,
                       @Const FloatPointer du,
                       FloatPointer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const FloatBuffer dl,
                       @Const FloatBuffer d,
                       @Const FloatBuffer du,
                       FloatBuffer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const float[] dl,
                       @Const float[] d,
                       @Const float[] du,
                       float[] B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const DoublePointer dl,
                       @Const DoublePointer d,
                       @Const DoublePointer du,
                       DoublePointer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const DoubleBuffer dl,
                       @Const DoubleBuffer d,
                       @Const DoubleBuffer du,
                       DoubleBuffer B,
                       int ldb,
                       Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Const double[] dl,
                       @Const double[] d,
                       @Const double[] du,
                       double[] B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Cast("const cuComplex*") float2 dl,
                       @Cast("const cuComplex*") float2 d,
                       @Cast("const cuComplex*") float2 du,
                       @Cast("cuComplex*") float2 B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2_nopivot(cusparseContext handle,
                       int m,
                       int n,
                       @Cast("const cuDoubleComplex*") double2 dl,
                       @Cast("const cuDoubleComplex*") double2 d,
                       @Cast("const cuDoubleComplex*") double2 du,
                       @Cast("cuDoubleComplex*") double2 B,
                       int ldb,
                       Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const FloatPointer dl,
                                         @Const FloatPointer d,
                                         @Const FloatPointer du,
                                         @Const FloatPointer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const FloatBuffer dl,
                                         @Const FloatBuffer d,
                                         @Const FloatBuffer du,
                                         @Const FloatBuffer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const float[] dl,
                                         @Const float[] d,
                                         @Const float[] du,
                                         @Const float[] x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const DoublePointer dl,
                                         @Const DoublePointer d,
                                         @Const DoublePointer du,
                                         @Const DoublePointer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const DoubleBuffer dl,
                                         @Const DoubleBuffer d,
                                         @Const DoubleBuffer du,
                                         @Const DoubleBuffer x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Const double[] dl,
                                         @Const double[] d,
                                         @Const double[] du,
                                         @Const double[] x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Cast("const cuComplex*") float2 dl,
                                         @Cast("const cuComplex*") float2 d,
                                         @Cast("const cuComplex*") float2 du,
                                         @Cast("const cuComplex*") float2 x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2StridedBatch_bufferSizeExt(cusparseContext handle,
                                         int m,
                                         @Cast("const cuDoubleComplex*") double2 dl,
                                         @Cast("const cuDoubleComplex*") double2 d,
                                         @Cast("const cuDoubleComplex*") double2 du,
                                         @Cast("const cuDoubleComplex*") double2 x,
                                         int batchCount,
                                         int batchStride,
                                         @Cast("size_t*") SizeTPointer bufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const FloatPointer dl,
                           @Const FloatPointer d,
                           @Const FloatPointer du,
                           FloatPointer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const FloatBuffer dl,
                           @Const FloatBuffer d,
                           @Const FloatBuffer du,
                           FloatBuffer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const float[] dl,
                           @Const float[] d,
                           @Const float[] du,
                           float[] x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const DoublePointer dl,
                           @Const DoublePointer d,
                           @Const DoublePointer du,
                           DoublePointer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const DoubleBuffer dl,
                           @Const DoubleBuffer d,
                           @Const DoubleBuffer du,
                           DoubleBuffer x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Const double[] dl,
                           @Const double[] d,
                           @Const double[] du,
                           double[] x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Cast("const cuComplex*") float2 dl,
                           @Cast("const cuComplex*") float2 d,
                           @Cast("const cuComplex*") float2 du,
                           @Cast("cuComplex*") float2 x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsv2StridedBatch(cusparseContext handle,
                           int m,
                           @Cast("const cuDoubleComplex*") double2 dl,
                           @Cast("const cuDoubleComplex*") double2 d,
                           @Cast("const cuDoubleComplex*") double2 du,
                           @Cast("cuDoubleComplex*") double2 x,
                           int batchCount,
                           int batchStride,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatPointer dl,
                                            @Const FloatPointer d,
                                            @Const FloatPointer du,
                                            @Const FloatPointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatBuffer dl,
                                            @Const FloatBuffer d,
                                            @Const FloatBuffer du,
                                            @Const FloatBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const float[] dl,
                                            @Const float[] d,
                                            @Const float[] du,
                                            @Const float[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const DoublePointer dl,
                                         @Const DoublePointer d,
                                         @Const DoublePointer du,
                                         @Const DoublePointer x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const DoubleBuffer dl,
                                         @Const DoubleBuffer d,
                                         @Const DoubleBuffer du,
                                         @Const DoubleBuffer x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                         int algo,
                                         int m,
                                         @Const double[] dl,
                                         @Const double[] d,
                                         @Const double[] du,
                                         @Const double[] x,
                                         int batchCount,
                                         @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuComplex*") float2 dl,
                                            @Cast("const cuComplex*") float2 d,
                                            @Cast("const cuComplex*") float2 du,
                                            @Cast("const cuComplex*") float2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgtsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuDoubleComplex*") double2 dl,
                                            @Cast("const cuDoubleComplex*") double2 d,
                                            @Cast("const cuDoubleComplex*") double2 du,
                                            @Cast("const cuDoubleComplex*") double2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatPointer dl,
                              FloatPointer d,
                              FloatPointer du,
                              FloatPointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatBuffer dl,
                              FloatBuffer d,
                              FloatBuffer du,
                              FloatBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              float[] dl,
                              float[] d,
                              float[] du,
                              float[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoublePointer dl,
                              DoublePointer d,
                              DoublePointer du,
                              DoublePointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoubleBuffer dl,
                              DoubleBuffer d,
                              DoubleBuffer du,
                              DoubleBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              double[] dl,
                              double[] d,
                              double[] du,
                              double[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuComplex*") float2 dl,
                              @Cast("cuComplex*") float2 d,
                              @Cast("cuComplex*") float2 du,
                              @Cast("cuComplex*") float2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgtsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuDoubleComplex*") double2 dl,
                              @Cast("cuDoubleComplex*") double2 d,
                              @Cast("cuDoubleComplex*") double2 du,
                              @Cast("cuDoubleComplex*") double2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatPointer ds,
                                            @Const FloatPointer dl,
                                            @Const FloatPointer d,
                                            @Const FloatPointer du,
                                            @Const FloatPointer dw,
                                            @Const FloatPointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const FloatBuffer ds,
                                            @Const FloatBuffer dl,
                                            @Const FloatBuffer d,
                                            @Const FloatBuffer du,
                                            @Const FloatBuffer dw,
                                            @Const FloatBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const float[] ds,
                                            @Const float[] dl,
                                            @Const float[] d,
                                            @Const float[] du,
                                            @Const float[] dw,
                                            @Const float[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const DoublePointer ds,
                                            @Const DoublePointer dl,
                                            @Const DoublePointer d,
                                            @Const DoublePointer du,
                                            @Const DoublePointer dw,
                                            @Const DoublePointer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const DoubleBuffer ds,
                                            @Const DoubleBuffer dl,
                                            @Const DoubleBuffer d,
                                            @Const DoubleBuffer du,
                                            @Const DoubleBuffer dw,
                                            @Const DoubleBuffer x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Const double[] ds,
                                            @Const double[] dl,
                                            @Const double[] d,
                                            @Const double[] du,
                                            @Const double[] dw,
                                            @Const double[] x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuComplex*") float2 ds,
                                            @Cast("const cuComplex*") float2 dl,
                                            @Cast("const cuComplex*") float2 d,
                                            @Cast("const cuComplex*") float2 du,
                                            @Cast("const cuComplex*") float2 dw,
                                            @Cast("const cuComplex*") float2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgpsvInterleavedBatch_bufferSizeExt(cusparseContext handle,
                                            int algo,
                                            int m,
                                            @Cast("const cuDoubleComplex*") double2 ds,
                                            @Cast("const cuDoubleComplex*") double2 dl,
                                            @Cast("const cuDoubleComplex*") double2 d,
                                            @Cast("const cuDoubleComplex*") double2 du,
                                            @Cast("const cuDoubleComplex*") double2 dw,
                                            @Cast("const cuDoubleComplex*") double2 x,
                                            int batchCount,
                                            @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatPointer ds,
                              FloatPointer dl,
                              FloatPointer d,
                              FloatPointer du,
                              FloatPointer dw,
                              FloatPointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              FloatBuffer ds,
                              FloatBuffer dl,
                              FloatBuffer d,
                              FloatBuffer du,
                              FloatBuffer dw,
                              FloatBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              float[] ds,
                              float[] dl,
                              float[] d,
                              float[] du,
                              float[] dw,
                              float[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoublePointer ds,
                              DoublePointer dl,
                              DoublePointer d,
                              DoublePointer du,
                              DoublePointer dw,
                              DoublePointer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              DoubleBuffer ds,
                              DoubleBuffer dl,
                              DoubleBuffer d,
                              DoubleBuffer du,
                              DoubleBuffer dw,
                              DoubleBuffer x,
                              int batchCount,
                              Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              double[] ds,
                              double[] dl,
                              double[] d,
                              double[] du,
                              double[] dw,
                              double[] x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuComplex*") float2 ds,
                              @Cast("cuComplex*") float2 dl,
                              @Cast("cuComplex*") float2 d,
                              @Cast("cuComplex*") float2 du,
                              @Cast("cuComplex*") float2 dw,
                              @Cast("cuComplex*") float2 x,
                              int batchCount,
                              Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgpsvInterleavedBatch(cusparseContext handle,
                              int algo,
                              int m,
                              @Cast("cuDoubleComplex*") double2 ds,
                              @Cast("cuDoubleComplex*") double2 dl,
                              @Cast("cuDoubleComplex*") double2 d,
                              @Cast("cuDoubleComplex*") double2 du,
                              @Cast("cuDoubleComplex*") double2 dw,
                              @Cast("cuDoubleComplex*") double2 x,
                              int batchCount,
                              Pointer pBuffer);

//##############################################################################
//# EXTRA ROUTINES
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const FloatPointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const FloatPointer csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Const FloatPointer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const FloatPointer csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const FloatPointer csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const FloatBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const FloatBuffer csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Const FloatBuffer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const FloatBuffer csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const FloatBuffer csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const float[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const float[] csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Const float[] beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const float[] csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const float[] csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const DoublePointer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const DoublePointer csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Const DoublePointer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const DoublePointer csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const DoublePointer csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const DoubleBuffer alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const DoubleBuffer csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Const DoubleBuffer beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const DoubleBuffer csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const DoubleBuffer csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Const double[] alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Const double[] csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Const double[] beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Const double[] csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Const double[] csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuComplex*") float2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuComplex*") float2 csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Cast("const cuComplex*") float2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuComplex*") float2 csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuComplex*") float2 csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const IntPointer csrSortedRowPtrA,
                                @Const IntPointer csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const IntPointer csrSortedRowPtrB,
                                @Const IntPointer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const IntPointer csrSortedRowPtrC,
                                @Const IntPointer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const IntBuffer csrSortedRowPtrA,
                                @Const IntBuffer csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const IntBuffer csrSortedRowPtrB,
                                @Const IntBuffer csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const IntBuffer csrSortedRowPtrC,
                                @Const IntBuffer csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                @Cast("const cuDoubleComplex*") double2 alpha,
                                cusparseMatDescr descrA,
                                int nnzA,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                                @Const int[] csrSortedRowPtrA,
                                @Const int[] csrSortedColIndA,
                                @Cast("const cuDoubleComplex*") double2 beta,
                                cusparseMatDescr descrB,
                                int nnzB,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                                @Const int[] csrSortedRowPtrB,
                                @Const int[] csrSortedColIndB,
                                cusparseMatDescr descrC,
                                @Cast("const cuDoubleComplex*") double2 csrSortedValC,
                                @Const int[] csrSortedRowPtrC,
                                @Const int[] csrSortedColIndC,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntPointer csrSortedRowPtrA,
                     @Const IntPointer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntPointer csrSortedRowPtrB,
                     @Const IntPointer csrSortedColIndB,
                     cusparseMatDescr descrC,
                     IntPointer csrSortedRowPtrC,
                     IntPointer nnzTotalDevHostPtr,
                     Pointer workspace);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const IntBuffer csrSortedRowPtrA,
                     @Const IntBuffer csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const IntBuffer csrSortedRowPtrB,
                     @Const IntBuffer csrSortedColIndB,
                     cusparseMatDescr descrC,
                     IntBuffer csrSortedRowPtrC,
                     IntBuffer nnzTotalDevHostPtr,
                     Pointer workspace);
public static native @Cast("cusparseStatus_t") int cusparseXcsrgeam2Nnz(cusparseContext handle,
                     int m,
                     int n,
                     cusparseMatDescr descrA,
                     int nnzA,
                     @Const int[] csrSortedRowPtrA,
                     @Const int[] csrSortedColIndA,
                     cusparseMatDescr descrB,
                     int nnzB,
                     @Const int[] csrSortedRowPtrB,
                     @Const int[] csrSortedColIndB,
                     cusparseMatDescr descrC,
                     int[] csrSortedRowPtrC,
                     int[] nnzTotalDevHostPtr,
                     Pointer workspace);

public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const FloatPointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatPointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const FloatPointer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatPointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  FloatPointer csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const FloatBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const FloatBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const FloatBuffer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const FloatBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  FloatBuffer csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const float[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const float[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const float[] beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const float[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  float[] csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const DoublePointer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoublePointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const DoublePointer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoublePointer csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  DoublePointer csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const DoubleBuffer alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const DoubleBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const DoubleBuffer beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const DoubleBuffer csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  DoubleBuffer csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Const double[] alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Const double[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const double[] beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Const double[] csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  double[] csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuComplex*") float2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuComplex*") float2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuComplex*") float2 csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuComplex*") float2 csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntPointer csrSortedRowPtrB,
                  @Const IntPointer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  IntPointer csrSortedRowPtrC,
                  IntPointer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const IntBuffer csrSortedRowPtrB,
                  @Const IntBuffer csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  IntBuffer csrSortedRowPtrC,
                  IntBuffer csrSortedColIndC,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsrgeam2(cusparseContext handle,
                  int m,
                  int n,
                  @Cast("const cuDoubleComplex*") double2 alpha,
                  cusparseMatDescr descrA,
                  int nnzA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Cast("const cuDoubleComplex*") double2 beta,
                  cusparseMatDescr descrB,
                  int nnzB,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValB,
                  @Const int[] csrSortedRowPtrB,
                  @Const int[] csrSortedColIndB,
                  cusparseMatDescr descrC,
                  @Cast("cuDoubleComplex*") double2 csrSortedValC,
                  int[] csrSortedRowPtrC,
                  int[] csrSortedColIndC,
                  Pointer pBuffer);

//##############################################################################
//# SPARSE MATRIX REORDERING
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const FloatPointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const FloatPointer fractionToColor,
                  IntPointer ncolors,
                  IntPointer coloring,
                  IntPointer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const FloatBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const FloatBuffer fractionToColor,
                  IntBuffer ncolors,
                  IntBuffer coloring,
                  IntBuffer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseScsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const float[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const float[] fractionToColor,
                  int[] ncolors,
                  int[] coloring,
                  int[] reordering,
                  cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const DoublePointer csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const DoublePointer fractionToColor,
                  IntPointer ncolors,
                  IntPointer coloring,
                  IntPointer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const DoubleBuffer csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const DoubleBuffer fractionToColor,
                  IntBuffer ncolors,
                  IntBuffer coloring,
                  IntBuffer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseDcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Const double[] csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const double[] fractionToColor,
                  int[] ncolors,
                  int[] coloring,
                  int[] reordering,
                  cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const FloatPointer fractionToColor,
                  IntPointer ncolors,
                  IntPointer coloring,
                  IntPointer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const FloatBuffer fractionToColor,
                  IntBuffer ncolors,
                  IntBuffer coloring,
                  IntBuffer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseCcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuComplex*") float2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const float[] fractionToColor,
                  int[] ncolors,
                  int[] coloring,
                  int[] reordering,
                  cusparseColorInfo info);

public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntPointer csrSortedRowPtrA,
                  @Const IntPointer csrSortedColIndA,
                  @Const DoublePointer fractionToColor,
                  IntPointer ncolors,
                  IntPointer coloring,
                  IntPointer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const IntBuffer csrSortedRowPtrA,
                  @Const IntBuffer csrSortedColIndA,
                  @Const DoubleBuffer fractionToColor,
                  IntBuffer ncolors,
                  IntBuffer coloring,
                  IntBuffer reordering,
                  cusparseColorInfo info);
public static native @Cast("cusparseStatus_t") int cusparseZcsrcolor(cusparseContext handle,
                  int m,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                  @Const int[] csrSortedRowPtrA,
                  @Const int[] csrSortedColIndA,
                  @Const double[] fractionToColor,
                  int[] ncolors,
                  int[] coloring,
                  int[] reordering,
                  cusparseColorInfo info);

//##############################################################################
//# SPARSE FORMAT CONVERSION
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const FloatPointer A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const FloatBuffer A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseSnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const float[] A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const DoublePointer A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const DoubleBuffer A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseDnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Const double[] A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseCnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuComplex*") float2 A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             IntPointer nnzPerRowCol,
             IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             IntBuffer nnzPerRowCol,
             IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseZnnz(cusparseContext handle,
             @Cast("cusparseDirection_t") int dirA,
             int m,
             int n,
             cusparseMatDescr descrA,
             @Cast("const cuDoubleComplex*") double2 A,
             int lda,
             int[] nnzPerRowCol,
             int[] nnzTotalDevHostPtr);

//##############################################################################
//# SPARSE FORMAT CONVERSION
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      float tol);
public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      float tol);
public static native @Cast("cusparseStatus_t") int cusparseSnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      float tol);

public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      double tol);
public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      double tol);
public static native @Cast("cusparseStatus_t") int cusparseDnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      double tol);

public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuComplex*") float2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      @ByVal @Cast("cuComplex*") float2 tol);

public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      IntPointer nnzPerRow,
                      IntPointer nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      IntBuffer nnzPerRow,
                      IntBuffer nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZnnz_compress(cusparseContext handle,
                      int m,
                      cusparseMatDescr descr,
                      @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      int[] nnzPerRow,
                      int[] nnzC,
                      @ByVal @Cast("cuDoubleComplex*") double2 tol);

public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const FloatPointer csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          FloatPointer csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          float tol);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const FloatBuffer csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          FloatBuffer csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          float tol);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const float[] csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          float[] csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          float tol);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          DoublePointer csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          double tol);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          DoubleBuffer csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          double tol);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          double[] csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          double tol);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuComplex*") float2 csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          @Cast("cuComplex*") float2 csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          @ByVal @Cast("cuComplex*") float2 tol);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntPointer csrSortedColIndA,
                          @Const IntPointer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntPointer nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          IntPointer csrSortedColIndC,
                          IntPointer csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const IntBuffer csrSortedRowPtrA,
                          int nnzA,
                          @Const IntBuffer nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          IntBuffer csrSortedColIndC,
                          IntBuffer csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csr_compress(cusparseContext handle,
                          int m,
                          int n,
                          cusparseMatDescr descrA,
                          @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                          @Const int[] csrSortedColIndA,
                          @Const int[] csrSortedRowPtrA,
                          int nnzA,
                          @Const int[] nnzPerRow,
                          @Cast("cuDoubleComplex*") double2 csrSortedValC,
                          int[] csrSortedColIndC,
                          int[] csrSortedRowPtrC,
                          @ByVal @Cast("cuDoubleComplex*") double2 tol);

public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const IntPointer cooRowInd,
                 int nnz,
                 int m,
                 IntPointer csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const IntBuffer cooRowInd,
                 int nnz,
                 int m,
                 IntBuffer csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcoo2csr(cusparseContext handle,
                 @Const int[] cooRowInd,
                 int nnz,
                 int m,
                 int[] csrSortedRowPtr,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const IntPointer csrSortedRowPtr,
                 int nnz,
                 int m,
                 IntPointer cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const IntBuffer csrSortedRowPtr,
                 int nnz,
                 int m,
                 IntBuffer cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2coo(cusparseContext handle,
                 @Const int[] csrSortedRowPtr,
                 int nnz,
                 int m,
                 int[] cooRowInd,
                 @Cast("cusparseIndexBase_t") int idxBase);

public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const IntPointer csrSortedRowPtrA,
                    @Const IntPointer csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    IntPointer bsrSortedRowPtrC,
                    IntPointer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const IntBuffer csrSortedRowPtrA,
                    @Const IntBuffer csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    IntBuffer bsrSortedRowPtrC,
                    IntBuffer nnzTotalDevHostPtr);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2bsrNnz(cusparseContext handle,
                    @Cast("cusparseDirection_t") int dirA,
                    int m,
                    int n,
                    cusparseMatDescr descrA,
                    @Const int[] csrSortedRowPtrA,
                    @Const int[] csrSortedColIndA,
                    int blockDim,
                    cusparseMatDescr descrC,
                    int[] bsrSortedRowPtrC,
                    int[] nnzTotalDevHostPtr);

public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatPointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatPointer bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatBuffer bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseScsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const float[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 float[] bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoublePointer csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoublePointer bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoubleBuffer bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Const double[] csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 double[] bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntPointer csrSortedRowPtrA,
                 @Const IntPointer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 IntPointer bsrSortedRowPtrC,
                 IntPointer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const IntBuffer csrSortedRowPtrA,
                 @Const IntBuffer csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 IntBuffer bsrSortedRowPtrC,
                 IntBuffer bsrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2bsr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int m,
                 int n,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                 @Const int[] csrSortedRowPtrA,
                 @Const int[] csrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                 int[] bsrSortedRowPtrC,
                 int[] bsrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const FloatPointer bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatPointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const FloatBuffer bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 FloatBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const float[] bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 float[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const DoublePointer bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoublePointer csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const DoubleBuffer bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 DoubleBuffer csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Const double[] bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 double[] csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuComplex*") float2 bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuComplex*") float2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const IntPointer bsrSortedRowPtrA,
                 @Const IntPointer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntPointer csrSortedRowPtrC,
                 IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const IntBuffer bsrSortedRowPtrA,
                 @Const IntBuffer bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 IntBuffer csrSortedRowPtrC,
                 IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZbsr2csr(cusparseContext handle,
                 @Cast("cusparseDirection_t") int dirA,
                 int mb,
                 int nb,
                 cusparseMatDescr descrA,
                 @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                 @Const int[] bsrSortedRowPtrA,
                 @Const int[] bsrSortedColIndA,
                 int blockDim,
                 cusparseMatDescr descrC,
                 @Cast("cuDoubleComplex*") double2 csrSortedValC,
                 int[] csrSortedRowPtrC,
                 int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const FloatPointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const FloatBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const float[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const DoublePointer bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const DoubleBuffer bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Const double[] bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuComplex*") float2 bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const IntPointer bsrSortedRowPtr,
                                @Const IntPointer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const IntBuffer bsrSortedRowPtr,
                                @Const IntBuffer bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc_bufferSize(cusparseContext handle,
                                int mb,
                                int nb,
                                int nnzb,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                                @Const int[] bsrSortedRowPtr,
                                @Const int[] bsrSortedColInd,
                                int rowBlockDim,
                                int colBlockDim,
                                int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const FloatPointer bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     FloatPointer bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const FloatBuffer bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     FloatBuffer bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const float[] bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     float[] bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const DoublePointer bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     DoublePointer bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const DoubleBuffer bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     DoubleBuffer bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Const double[] bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     double[] bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuComplex*") float2 bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuComplex*") float2 bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const IntPointer bsrSortedRowPtr,
                     @Const IntPointer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     IntPointer bscRowInd,
                     IntPointer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const IntBuffer bsrSortedRowPtr,
                     @Const IntBuffer bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     IntBuffer bscRowInd,
                     IntBuffer bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsc(cusparseContext handle,
                     int mb,
                     int nb,
                     int nnzb,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedVal,
                     @Const int[] bsrSortedRowPtr,
                     @Const int[] bsrSortedColInd,
                     int rowBlockDim,
                     int colBlockDim,
                     @Cast("cuDoubleComplex*") double2 bscVal,
                     int[] bscRowInd,
                     int[] bscColPtr,
                     @Cast("cusparseAction_t") int copyValues,
                     @Cast("cusparseIndexBase_t") int idxBase,
                     Pointer pBuffer);



public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const FloatPointer bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   FloatPointer csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   FloatBuffer csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const float[] bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   float[] csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const DoublePointer bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   DoublePointer csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   DoubleBuffer csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Const double[] bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   double[] csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const IntPointer bsrSortedRowPtrA,
                   @Const IntPointer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   IntPointer csrSortedRowPtrC,
                   IntPointer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const IntBuffer bsrSortedRowPtrA,
                   @Const IntBuffer bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   IntBuffer csrSortedRowPtrC,
                   IntBuffer csrSortedColIndC);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2csr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int mb,
                   int nb,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                   @Const int[] bsrSortedRowPtrA,
                   @Const int[] bsrSortedColIndA,
                   int rowBlockDim,
                   int colBlockDim,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 csrSortedValC,
                   int[] csrSortedRowPtrC,
                   int[] csrSortedColIndC);

public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const FloatPointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const FloatBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const float[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const DoublePointer csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const DoubleBuffer csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Const double[] csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuComplex*") float2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntPointer csrSortedRowPtrA,
                              @Const IntPointer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const IntBuffer csrSortedRowPtrA,
                              @Const IntBuffer csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr_bufferSize(cusparseContext handle,
                              @Cast("cusparseDirection_t") int dirA,
                              int m,
                              int n,
                              cusparseMatDescr descrA,
                              @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                              @Const int[] csrSortedRowPtrA,
                              @Const int[] csrSortedColIndA,
                              int rowBlockDim,
                              int colBlockDim,
                              int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      cusparseMatDescr descrC,
                      IntPointer bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      IntPointer nnzTotalDevHostPtr,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      cusparseMatDescr descrC,
                      IntBuffer bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      IntBuffer nnzTotalDevHostPtr,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsr2gebsrNnz(cusparseContext handle,
                      @Cast("cusparseDirection_t") int dirA,
                      int m,
                      int n,
                      cusparseMatDescr descrA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      cusparseMatDescr descrC,
                      int[] bsrSortedRowPtrC,
                      int rowBlockDim,
                      int colBlockDim,
                      int[] nnzTotalDevHostPtr,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatPointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   FloatPointer bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const FloatBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   FloatBuffer bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const float[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   float[] bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoublePointer csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   DoublePointer bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const DoubleBuffer csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   DoubleBuffer bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Const double[] csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   double[] bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuComplex*") float2 csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuComplex*") float2 bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const IntPointer csrSortedRowPtrA,
                   @Const IntPointer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   IntPointer bsrSortedRowPtrC,
                   IntPointer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const IntBuffer csrSortedRowPtrA,
                   @Const IntBuffer csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   IntBuffer bsrSortedRowPtrC,
                   IntBuffer bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2gebsr(cusparseContext handle,
                   @Cast("cusparseDirection_t") int dirA,
                   int m,
                   int n,
                   cusparseMatDescr descrA,
                   @Cast("const cuDoubleComplex*") double2 csrSortedValA,
                   @Const int[] csrSortedRowPtrA,
                   @Const int[] csrSortedColIndA,
                   cusparseMatDescr descrC,
                   @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                   int[] bsrSortedRowPtrC,
                   int[] bsrSortedColIndC,
                   int rowBlockDim,
                   int colBlockDim,
                   Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const FloatPointer bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const FloatBuffer bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const float[] bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const DoublePointer bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const DoubleBuffer bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Const double[] bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuComplex*") float2 bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const IntPointer bsrSortedRowPtrA,
                                @Const IntPointer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const IntBuffer bsrSortedRowPtrA,
                                @Const IntBuffer bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                IntBuffer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr_bufferSize(cusparseContext handle,
                                @Cast("cusparseDirection_t") int dirA,
                                int mb,
                                int nb,
                                int nnzb,
                                cusparseMatDescr descrA,
                                @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                                @Const int[] bsrSortedRowPtrA,
                                @Const int[] bsrSortedColIndA,
                                int rowBlockDimA,
                                int colBlockDimA,
                                int rowBlockDimC,
                                int colBlockDimC,
                                int[] pBufferSizeInBytes);









public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const IntPointer bsrSortedRowPtrA,
                        @Const IntPointer bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        IntPointer bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        IntPointer nnzTotalDevHostPtr,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const IntBuffer bsrSortedRowPtrA,
                        @Const IntBuffer bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        IntBuffer bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        IntBuffer nnzTotalDevHostPtr,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXgebsr2gebsrNnz(cusparseContext handle,
                        @Cast("cusparseDirection_t") int dirA,
                        int mb,
                        int nb,
                        int nnzb,
                        cusparseMatDescr descrA,
                        @Const int[] bsrSortedRowPtrA,
                        @Const int[] bsrSortedColIndA,
                        int rowBlockDimA,
                        int colBlockDimA,
                        cusparseMatDescr descrC,
                        int[] bsrSortedRowPtrC,
                        int rowBlockDimC,
                        int colBlockDimC,
                        int[] nnzTotalDevHostPtr,
                        Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const FloatPointer bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     FloatPointer bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const FloatBuffer bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     FloatBuffer bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const float[] bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     float[] bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const DoublePointer bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     DoublePointer bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const DoubleBuffer bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     DoubleBuffer bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Const double[] bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     double[] bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuComplex*") float2 bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuComplex*") float2 bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const IntPointer bsrSortedRowPtrA,
                     @Const IntPointer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     IntPointer bsrSortedRowPtrC,
                     IntPointer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const IntBuffer bsrSortedRowPtrA,
                     @Const IntBuffer bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     IntBuffer bsrSortedRowPtrC,
                     IntBuffer bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZgebsr2gebsr(cusparseContext handle,
                     @Cast("cusparseDirection_t") int dirA,
                     int mb,
                     int nb,
                     int nnzb,
                     cusparseMatDescr descrA,
                     @Cast("const cuDoubleComplex*") double2 bsrSortedValA,
                     @Const int[] bsrSortedRowPtrA,
                     @Const int[] bsrSortedColIndA,
                     int rowBlockDimA,
                     int colBlockDimA,
                     cusparseMatDescr descrC,
                     @Cast("cuDoubleComplex*") double2 bsrSortedValC,
                     int[] bsrSortedRowPtrC,
                     int[] bsrSortedColIndC,
                     int rowBlockDimC,
                     int colBlockDimC,
                     Pointer pBuffer);

//##############################################################################
//# SPARSE MATRIX SORTING
//##############################################################################

public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  IntPointer p);
public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  IntBuffer p);
public static native @Cast("cusparseStatus_t") int cusparseCreateIdentityPermutation(cusparseContext handle,
                                  int n,
                                  int[] p);

public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer cooRowsA,
                               @Const IntPointer cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer cooRowsA,
                               @Const IntBuffer cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcoosort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] cooRowsA,
                               @Const int[] cooColsA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      IntPointer cooRowsA,
                      IntPointer cooColsA,
                      IntPointer P,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      IntBuffer cooRowsA,
                      IntBuffer cooColsA,
                      IntBuffer P,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByRow(cusparseContext handle,
                      int m,
                      int n,
                      int nnz,
                      int[] cooRowsA,
                      int[] cooColsA,
                      int[] P,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         IntPointer cooRowsA,
                         IntPointer cooColsA,
                         IntPointer P,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         IntBuffer cooRowsA,
                         IntBuffer cooColsA,
                         IntBuffer P,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcoosortByColumn(cusparseContext handle,
                         int m,
                         int n,
                         int nnz,
                         int[] cooRowsA,
                         int[] cooColsA,
                         int[] P,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer csrRowPtrA,
                               @Const IntPointer csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer csrRowPtrA,
                               @Const IntBuffer csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] csrRowPtrA,
                               @Const int[] csrColIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntPointer csrRowPtrA,
                 IntPointer csrColIndA,
                 IntPointer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntBuffer csrRowPtrA,
                 IntBuffer csrColIndA,
                 IntBuffer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcsrsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const int[] csrRowPtrA,
                 int[] csrColIndA,
                 int[] P,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntPointer cscColPtrA,
                               @Const IntPointer cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const IntBuffer cscColPtrA,
                               @Const IntBuffer cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort_bufferSizeExt(cusparseContext handle,
                               int m,
                               int n,
                               int nnz,
                               @Const int[] cscColPtrA,
                               @Const int[] cscRowIndA,
                               @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntPointer cscColPtrA,
                 IntPointer cscRowIndA,
                 IntPointer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const IntBuffer cscColPtrA,
                 IntBuffer cscRowIndA,
                 IntBuffer P,
                 Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseXcscsort(cusparseContext handle,
                 int m,
                 int n,
                 int nnz,
                 cusparseMatDescr descrA,
                 @Const int[] cscColPtrA,
                 int[] cscRowIndA,
                 int[] P,
                 Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                FloatPointer csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                FloatBuffer csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                float[] csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                DoublePointer csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                DoubleBuffer csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                double[] csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuComplex*") float2 csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const IntPointer csrRowPtr,
                                IntPointer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const IntBuffer csrRowPtr,
                                IntBuffer csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr_bufferSizeExt(cusparseContext handle,
                                int m,
                                int n,
                                int nnz,
                                @Cast("cuDoubleComplex*") double2 csrVal,
                                @Const int[] csrRowPtr,
                                int[] csrColInd,
                                csru2csrInfo info,
                                @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsru2csr(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatPointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  FloatBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseScsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  float[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoublePointer csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  DoubleBuffer csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  double[] csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseCcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuComplex*") float2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntPointer csrRowPtr,
                  IntPointer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const IntBuffer csrRowPtr,
                  IntBuffer csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseZcsr2csru(cusparseContext handle,
                  int m,
                  int n,
                  int nnz,
                  cusparseMatDescr descrA,
                  @Cast("cuDoubleComplex*") double2 csrVal,
                  @Const int[] csrRowPtr,
                  int[] csrColInd,
                  csru2csrInfo info,
                  Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const __half A,
                                      int lda,
                                      @Const __half threshold,
                                      cusparseMatDescr descrC,
                                      @Const __half csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const FloatPointer A,
                                      int lda,
                                      @Const FloatPointer threshold,
                                      cusparseMatDescr descrC,
                                      @Const FloatPointer csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const FloatBuffer A,
                                      int lda,
                                      @Const FloatBuffer threshold,
                                      cusparseMatDescr descrC,
                                      @Const FloatBuffer csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const float[] A,
                                      int lda,
                                      @Const float[] threshold,
                                      cusparseMatDescr descrC,
                                      @Const float[] csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const DoublePointer A,
                                      int lda,
                                      @Const DoublePointer threshold,
                                      cusparseMatDescr descrC,
                                      @Const DoublePointer csrSortedValC,
                                      @Const IntPointer csrSortedRowPtrC,
                                      @Const IntPointer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const DoubleBuffer A,
                                      int lda,
                                      @Const DoubleBuffer threshold,
                                      cusparseMatDescr descrC,
                                      @Const DoubleBuffer csrSortedValC,
                                      @Const IntBuffer csrSortedRowPtrC,
                                      @Const IntBuffer csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr_bufferSizeExt(cusparseContext handle,
                                      int m,
                                      int n,
                                      @Const double[] A,
                                      int lda,
                                      @Const double[] threshold,
                                      cusparseMatDescr descrC,
                                      @Const double[] csrSortedValC,
                                      @Const int[] csrSortedRowPtrC,
                                      @Const int[] csrSortedColIndC,
                                      @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const __half A,
                           int lda,
                           @Const __half threshold,
                           cusparseMatDescr descrC,
                           int[] csrRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const FloatPointer A,
                           int lda,
                           @Const FloatPointer threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const FloatBuffer A,
                           int lda,
                           @Const FloatBuffer threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const float[] A,
                           int lda,
                           @Const float[] threshold,
                           cusparseMatDescr descrC,
                           int[] csrRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const DoublePointer A,
                           int lda,
                           @Const DoublePointer threshold,
                           cusparseMatDescr descrC,
                           IntPointer csrSortedRowPtrC,
                           IntPointer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const DoubleBuffer A,
                           int lda,
                           @Const DoubleBuffer threshold,
                           cusparseMatDescr descrC,
                           IntBuffer csrSortedRowPtrC,
                           IntBuffer nnzTotalDevHostPtr,
                           Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnz(cusparseContext handle,
                           int m,
                           int n,
                           @Const double[] A,
                           int lda,
                           @Const double[] threshold,
                           cusparseMatDescr descrC,
                           int[] csrSortedRowPtrC,
                           int[] nnzTotalDevHostPtr,
                           Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const __half A,
                        int lda,
                        @Const __half threshold,
                        cusparseMatDescr descrC,
                        __half csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const FloatPointer A,
                        int lda,
                        @Const FloatPointer threshold,
                        cusparseMatDescr descrC,
                        FloatPointer csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const FloatBuffer A,
                        int lda,
                        @Const FloatBuffer threshold,
                        cusparseMatDescr descrC,
                        FloatBuffer csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const float[] A,
                        int lda,
                        @Const float[] threshold,
                        cusparseMatDescr descrC,
                        float[] csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const DoublePointer A,
                        int lda,
                        @Const DoublePointer threshold,
                        cusparseMatDescr descrC,
                        DoublePointer csrSortedValC,
                        @Const IntPointer csrSortedRowPtrC,
                        IntPointer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const DoubleBuffer A,
                        int lda,
                        @Const DoubleBuffer threshold,
                        cusparseMatDescr descrC,
                        DoubleBuffer csrSortedValC,
                        @Const IntBuffer csrSortedRowPtrC,
                        IntBuffer csrSortedColIndC,
                        Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csr(cusparseContext handle,
                        int m,
                        int n,
                        @Const double[] A,
                        int lda,
                        @Const double[] threshold,
                        cusparseMatDescr descrC,
                        double[] csrSortedValC,
                        @Const int[] csrSortedRowPtrC,
                        int[] csrSortedColIndC,
                        Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const __half threshold,
                                    cusparseMatDescr descrC,
                                    @Const __half csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatPointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const FloatPointer threshold,
                                    cusparseMatDescr descrC,
                                    @Const FloatPointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const FloatBuffer threshold,
                                    cusparseMatDescr descrC,
                                    @Const FloatBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const float[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const float[] threshold,
                                    cusparseMatDescr descrC,
                                    @Const float[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoublePointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    @Const DoublePointer threshold,
                                    cusparseMatDescr descrC,
                                    @Const DoublePointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    @Const IntPointer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoubleBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    @Const DoubleBuffer threshold,
                                    cusparseMatDescr descrC,
                                    @Const DoubleBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    @Const IntBuffer csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr_bufferSizeExt(cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const double[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    @Const double[] threshold,
                                    cusparseMatDescr descrC,
                                    @Const double[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    @Const int[] csrSortedColIndC,
                                    @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         IntPointer csrSortedRowPtrC,
                         IntPointer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         IntBuffer csrSortedRowPtrC,
                         IntBuffer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const __half csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const __half threshold,
                         cusparseMatDescr descrC,
                         int[] csrSortedRowPtrC,
                         int[] nnzTotalDevHostPtr,
                         Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const FloatPointer csrSortedValA,
                         @Const IntPointer csrSortedRowPtrA,
                         @Const IntPointer csrSortedColIndA,
                         @Const FloatPointer threshold,
                         cusparseMatDescr descrC,
                         IntPointer csrSortedRowPtrC,
                         IntPointer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const FloatBuffer csrSortedValA,
                         @Const IntBuffer csrSortedRowPtrA,
                         @Const IntBuffer csrSortedColIndA,
                         @Const FloatBuffer threshold,
                         cusparseMatDescr descrC,
                         IntBuffer csrSortedRowPtrC,
                         IntBuffer nnzTotalDevHostPtr,
                         Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnz(cusparseContext handle,
                         int m,
                         int n,
                         int nnzA,
                         cusparseMatDescr descrA,
                         @Const float[] csrSortedValA,
                         @Const int[] csrSortedRowPtrA,
                         @Const int[] csrSortedColIndA,
                         @Const float[] threshold,
                         cusparseMatDescr descrC,
                         int[] csrSortedRowPtrC,
                         int[] nnzTotalDevHostPtr,
                         Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const DoublePointer csrSortedValA,
                          @Const IntPointer csrSortedRowPtrA,
                          @Const IntPointer csrSortedColIndA,
                          @Const DoublePointer threshold,
                          cusparseMatDescr descrC,
                          IntPointer csrSortedRowPtrC,
                          IntPointer nnzTotalDevHostPtr,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const DoubleBuffer csrSortedValA,
                          @Const IntBuffer csrSortedRowPtrA,
                          @Const IntBuffer csrSortedColIndA,
                          @Const DoubleBuffer threshold,
                          cusparseMatDescr descrC,
                          IntBuffer csrSortedRowPtrC,
                          IntBuffer nnzTotalDevHostPtr,
                          Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnz(cusparseContext handle,
                          int m,
                          int n,
                          int nnzA,
                          cusparseMatDescr descrA,
                          @Const double[] csrSortedValA,
                          @Const int[] csrSortedRowPtrA,
                          @Const int[] csrSortedColIndA,
                          @Const double[] threshold,
                          cusparseMatDescr descrC,
                          int[] csrSortedRowPtrC,
                          int[] nnzTotalDevHostPtr,
                          Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const __half csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const __half threshold,
                      cusparseMatDescr descrC,
                      __half csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const FloatPointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const FloatPointer threshold,
                      cusparseMatDescr descrC,
                      FloatPointer csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const FloatBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const FloatBuffer threshold,
                      cusparseMatDescr descrC,
                      FloatBuffer csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const float[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const float[] threshold,
                      cusparseMatDescr descrC,
                      float[] csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const DoublePointer csrSortedValA,
                      @Const IntPointer csrSortedRowPtrA,
                      @Const IntPointer csrSortedColIndA,
                      @Const DoublePointer threshold,
                      cusparseMatDescr descrC,
                      DoublePointer csrSortedValC,
                      @Const IntPointer csrSortedRowPtrC,
                      IntPointer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const DoubleBuffer csrSortedValA,
                      @Const IntBuffer csrSortedRowPtrA,
                      @Const IntBuffer csrSortedColIndA,
                      @Const DoubleBuffer threshold,
                      cusparseMatDescr descrC,
                      DoubleBuffer csrSortedValC,
                      @Const IntBuffer csrSortedRowPtrC,
                      IntBuffer csrSortedColIndC,
                      Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csr(cusparseContext handle,
                      int m,
                      int n,
                      int nnzA,
                      cusparseMatDescr descrA,
                      @Const double[] csrSortedValA,
                      @Const int[] csrSortedRowPtrA,
                      @Const int[] csrSortedColIndA,
                      @Const double[] threshold,
                      cusparseMatDescr descrC,
                      double[] csrSortedValC,
                      @Const int[] csrSortedRowPtrC,
                      int[] csrSortedColIndC,
                      Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const __half A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const FloatPointer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatPointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const FloatBuffer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const float[] A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const float[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const DoublePointer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoublePointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const DoubleBuffer A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoubleBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   @Const double[] A,
                                   int lda,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const double[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatPointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const float[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoublePointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoubleBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const double[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const __half A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    __half csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatPointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    FloatPointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const FloatBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    FloatBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const float[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    float[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoublePointer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    DoublePointer csrSortedValC,
                                    @Const IntPointer csrSortedRowPtrC,
                                    IntPointer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const DoubleBuffer A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    DoubleBuffer csrSortedValC,
                                    @Const IntBuffer csrSortedRowPtrC,
                                    IntBuffer csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneDense2csrByPercentage(cusparseContext handle,
                                    int m,
                                    int n,
                                    @Const double[] A,
                                    int lda,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    double[] csrSortedValC,
                                    @Const int[] csrSortedRowPtrC,
                                    int[] csrSortedColIndC,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const __half csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const __half csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const FloatPointer csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatPointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const FloatBuffer csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const FloatBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const float[] csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const float[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const DoublePointer csrSortedValA,
                                   @Const IntPointer csrSortedRowPtrA,
                                   @Const IntPointer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoublePointer csrSortedValC,
                                   @Const IntPointer csrSortedRowPtrC,
                                   @Const IntPointer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const DoubleBuffer csrSortedValA,
                                   @Const IntBuffer csrSortedRowPtrA,
                                   @Const IntBuffer csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const DoubleBuffer csrSortedValC,
                                   @Const IntBuffer csrSortedRowPtrC,
                                   @Const IntBuffer csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
                                   cusparseContext handle,
                                   int m,
                                   int n,
                                   int nnzA,
                                   cusparseMatDescr descrA,
                                   @Const double[] csrSortedValA,
                                   @Const int[] csrSortedRowPtrA,
                                   @Const int[] csrSortedColIndA,
                                   float percentage,
                                   cusparseMatDescr descrC,
                                   @Const double[] csrSortedValC,
                                   @Const int[] csrSortedRowPtrC,
                                   @Const int[] csrSortedColIndC,
                                   pruneInfo info,
                                   @Cast("size_t*") SizeTPointer pBufferSizeInBytes);

// #if defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const __half csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatPointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const FloatBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const float[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoublePointer csrSortedValA,
                                    @Const IntPointer csrSortedRowPtrA,
                                    @Const IntPointer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntPointer csrSortedRowPtrC,
                                    IntPointer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const DoubleBuffer csrSortedValA,
                                    @Const IntBuffer csrSortedRowPtrA,
                                    @Const IntBuffer csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    IntBuffer csrSortedRowPtrC,
                                    IntBuffer nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrNnzByPercentage(
                                    cusparseContext handle,
                                    int m,
                                    int n,
                                    int nnzA,
                                    cusparseMatDescr descrA,
                                    @Const double[] csrSortedValA,
                                    @Const int[] csrSortedRowPtrA,
                                    @Const int[] csrSortedColIndA,
                                    float percentage,
                                    cusparseMatDescr descrC,
                                    int[] csrSortedRowPtrC,
                                    int[] nnzTotalDevHostPtr,
                                    pruneInfo info,
                                    Pointer pBuffer);

// #if defined(__cplusplus)
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseHpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const __half csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  __half csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

// #endif // defined(__cplusplus)

public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const FloatPointer csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  FloatPointer csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const FloatBuffer csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  FloatBuffer csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseSpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const float[] csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  float[] csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const DoublePointer csrSortedValA,
                                  @Const IntPointer csrSortedRowPtrA,
                                  @Const IntPointer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  DoublePointer csrSortedValC,
                                  @Const IntPointer csrSortedRowPtrC,
                                  IntPointer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const DoubleBuffer csrSortedValA,
                                  @Const IntBuffer csrSortedRowPtrA,
                                  @Const IntBuffer csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  DoubleBuffer csrSortedValC,
                                  @Const IntBuffer csrSortedRowPtrC,
                                  IntBuffer csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);
public static native @Cast("cusparseStatus_t") int cusparseDpruneCsr2csrByPercentage(cusparseContext handle,
                                  int m,
                                  int n,
                                  int nnzA,
                                  cusparseMatDescr descrA,
                                  @Const double[] csrSortedValA,
                                  @Const int[] csrSortedRowPtrA,
                                  @Const int[] csrSortedColIndA,
                                  float percentage,
                                  cusparseMatDescr descrC,
                                  double[] csrSortedValC,
                                  @Const int[] csrSortedRowPtrC,
                                  int[] csrSortedColIndC,
                                  pruneInfo info,
                                  Pointer pBuffer);

//##############################################################################
//# CSR2CSC
//##############################################################################

/** enum cusparseCsr2CscAlg_t */
public static final int
    CUSPARSE_CSR2CSC_ALG_DEFAULT = 1,
    CUSPARSE_CSR2CSC_ALG1 = 1;

public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const IntPointer csrRowPtr,
                   @Const IntPointer csrColInd,
                   Pointer cscVal,
                   IntPointer cscColPtr,
                   IntPointer cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const IntBuffer csrRowPtr,
                   @Const IntBuffer csrColInd,
                   Pointer cscVal,
                   IntBuffer cscColPtr,
                   IntBuffer cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2(cusparseContext handle,
                   int m,
                   int n,
                   int nnz,
                   @Const Pointer csrVal,
                   @Const int[] csrRowPtr,
                   @Const int[] csrColInd,
                   Pointer cscVal,
                   int[] cscColPtr,
                   int[] cscRowInd,
                   @Cast("cudaDataType") int valType,
                   @Cast("cusparseAction_t") int copyValues,
                   @Cast("cusparseIndexBase_t") int idxBase,
                   @Cast("cusparseCsr2CscAlg_t") int alg,
                   Pointer buffer);

public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const IntPointer csrRowPtr,
                              @Const IntPointer csrColInd,
                              Pointer cscVal,
                              IntPointer cscColPtr,
                              IntPointer cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const IntBuffer csrRowPtr,
                              @Const IntBuffer csrColInd,
                              Pointer cscVal,
                              IntBuffer cscColPtr,
                              IntBuffer cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);
public static native @Cast("cusparseStatus_t") int cusparseCsr2cscEx2_bufferSize(cusparseContext handle,
                              int m,
                              int n,
                              int nnz,
                              @Const Pointer csrVal,
                              @Const int[] csrRowPtr,
                              @Const int[] csrColInd,
                              Pointer cscVal,
                              int[] cscColPtr,
                              int[] cscRowInd,
                              @Cast("cudaDataType") int valType,
                              @Cast("cusparseAction_t") int copyValues,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cusparseCsr2CscAlg_t") int alg,
                              @Cast("size_t*") SizeTPointer bufferSize);

// #############################################################################
// # GENERIC APIs - Enumerators and Opaque Data Structures
// #############################################################################

/** enum cusparseFormat_t */
public static final int
    /** Compressed Sparse Row (CSR) */
    CUSPARSE_FORMAT_CSR            = 1,
    /** Compressed Sparse Column (CSC) */
    CUSPARSE_FORMAT_CSC            = 2,
    /** Coordinate (COO) - Structure of Arrays */
    CUSPARSE_FORMAT_COO            = 3,
    /** Blocked ELL */
    CUSPARSE_FORMAT_BLOCKED_ELL    = 5,
    /** Blocked Compressed Sparse Row (BSR) */
    CUSPARSE_FORMAT_BSR            = 6,
    /** Sliced ELL */
    CUSPARSE_FORMAT_SLICED_ELLPACK = 7;

/** enum cusparseOrder_t */
public static final int
    /** Column-Major Order - Matrix memory layout */
    CUSPARSE_ORDER_COL = 1,
    /** Row-Major Order - Matrix memory layout */
    CUSPARSE_ORDER_ROW = 2;

/** enum cusparseIndexType_t */
public static final int
    /** 16-bit unsigned integer for matrix/vector
 *  indices */
    CUSPARSE_INDEX_16U = 1,
    /** 32-bit signed integer for matrix/vector indices */
    CUSPARSE_INDEX_32I = 2,
    /** 64-bit signed integer for matrix/vector indices */
    CUSPARSE_INDEX_64I = 3;
// Targeting ../cusparse/cusparseSpVecDescr.java


// Targeting ../cusparse/cusparseDnVecDescr.java


// Targeting ../cusparse/cusparseSpMatDescr.java


// Targeting ../cusparse/cusparseDnMatDescr.java




// #############################################################################
// # SPARSE VECTOR DESCRIPTOR
// #############################################################################



public static native @Cast("cusparseStatus_t") int cusparseCreateConstSpVec(@Cast("cusparseConstSpVecDescr_t*") @ByPtrPtr cusparseSpVecDescr spVecDescr,
                         @Cast("int64_t") long size,
                         @Cast("int64_t") long nnz,
                         @Const Pointer indices,
                         @Const Pointer values,
                         @Cast("cusparseIndexType_t") int idxType,
                         @Cast("cusparseIndexBase_t") int idxBase,
                         @Cast("cudaDataType") int valueType);





public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGet(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                      @Cast("int64_t*") LongPointer size,
                      @Cast("int64_t*") LongPointer nnz,
                      @Cast("const void**") PointerPointer indices,
                      @Cast("const void**") PointerPointer values,
                      @Cast("cusparseIndexType_t*") IntPointer idxType,
                      @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                      @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGet(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                      @Cast("int64_t*") LongPointer size,
                      @Cast("int64_t*") LongPointer nnz,
                      @Cast("const void**") @ByPtrPtr Pointer indices,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cusparseIndexType_t*") IntPointer idxType,
                      @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                      @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGet(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                      @Cast("int64_t*") LongBuffer size,
                      @Cast("int64_t*") LongBuffer nnz,
                      @Cast("const void**") @ByPtrPtr Pointer indices,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cusparseIndexType_t*") IntBuffer idxType,
                      @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
                      @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGet(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                      @Cast("int64_t*") long[] size,
                      @Cast("int64_t*") long[] nnz,
                      @Cast("const void**") @ByPtrPtr Pointer indices,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cusparseIndexType_t*") int[] idxType,
                      @Cast("cusparseIndexBase_t*") int[] idxBase,
                      @Cast("cudaDataType*") int[] valueType);





public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGetValues(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                            @Cast("const void**") PointerPointer values);
public static native @Cast("cusparseStatus_t") int cusparseConstSpVecGetValues(@Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr spVecDescr,
                            @Cast("const void**") @ByPtrPtr Pointer values);



// #############################################################################
// # DENSE VECTOR DESCRIPTOR
// #############################################################################



public static native @Cast("cusparseStatus_t") int cusparseCreateConstDnVec(@Cast("cusparseConstDnVecDescr_t*") @ByPtrPtr cusparseDnVecDescr dnVecDescr,
                         @Cast("int64_t") long size,
                         @Const Pointer values,
                         @Cast("cudaDataType") int valueType);





public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGet(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                      @Cast("int64_t*") LongPointer size,
                      @Cast("const void**") PointerPointer values,
                      @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGet(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                      @Cast("int64_t*") LongPointer size,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGet(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                      @Cast("int64_t*") LongBuffer size,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGet(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                      @Cast("int64_t*") long[] size,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") int[] valueType);



public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGetValues(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                            @Cast("const void**") PointerPointer values);
public static native @Cast("cusparseStatus_t") int cusparseConstDnVecGetValues(@Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr dnVecDescr,
                            @Cast("const void**") @ByPtrPtr Pointer values);



// #############################################################################
// # SPARSE MATRIX DESCRIPTOR
// #############################################################################



 





public static native @Cast("cusparseStatus_t") int cusparseConstSpMatGetValues(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                            @Cast("const void**") PointerPointer values);
public static native @Cast("cusparseStatus_t") int cusparseConstSpMatGetValues(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                            @Cast("const void**") @ByPtrPtr Pointer values);



public static native @Cast("cusparseStatus_t") int cusparseSpMatGetSize(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                     @Cast("int64_t*") LongPointer rows,
                     @Cast("int64_t*") LongPointer cols,
                     @Cast("int64_t*") LongPointer nnz);
public static native @Cast("cusparseStatus_t") int cusparseSpMatGetSize(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                     @Cast("int64_t*") LongBuffer rows,
                     @Cast("int64_t*") LongBuffer cols,
                     @Cast("int64_t*") LongBuffer nnz);
public static native @Cast("cusparseStatus_t") int cusparseSpMatGetSize(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                     @Cast("int64_t*") long[] rows,
                     @Cast("int64_t*") long[] cols,
                     @Cast("int64_t*") long[] nnz);



public static native @Cast("cusparseStatus_t") int cusparseCooSetStridedBatch(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           int batchCount,
                           @Cast("int64_t") long batchStride);

public static native @Cast("cusparseStatus_t") int cusparseCsrSetStridedBatch(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           int batchCount,
                           @Cast("int64_t") long offsetsBatchStride,
                           @Cast("int64_t") long columnsValuesBatchStride);

public static native @Cast("cusparseStatus_t") int cusparseBsrSetStridedBatch(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           int batchCount,
                           @Cast("int64_t") long offsetsBatchStride,
                           @Cast("int64_t") long columnsValuesBatchStride,
                           @Cast("int64_t") long ValuesBatchStride);

/** enum cusparseSpMatAttribute_t */
public static final int
    CUSPARSE_SPMAT_FILL_MODE = 0,
    CUSPARSE_SPMAT_DIAG_TYPE = 1;

public static native @Cast("cusparseStatus_t") int cusparseSpMatGetAttribute(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                          @Cast("cusparseSpMatAttribute_t") int attribute,
                          Pointer data,
                          @Cast("size_t") long dataSize);

public static native @Cast("cusparseStatus_t") int cusparseSpMatSetAttribute(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                          @Cast("cusparseSpMatAttribute_t") int attribute,
                          Pointer data,
                          @Cast("size_t") long dataSize);

//------------------------------------------------------------------------------
// ### CSR ###



public static native @Cast("cusparseStatus_t") int cusparseCreateConstCsr(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                       @Cast("int64_t") long rows,
                       @Cast("int64_t") long cols,
                       @Cast("int64_t") long nnz,
                       @Const Pointer csrRowOffsets,
                       @Const Pointer csrColInd,
                       @Const Pointer csrValues,
                       @Cast("cusparseIndexType_t") int csrRowOffsetsType,
                       @Cast("cusparseIndexType_t") int csrColIndType,
                       @Cast("cusparseIndexBase_t") int idxBase,
                       @Cast("cudaDataType") int valueType);

public static native @Cast("cusparseStatus_t") int cusparseCreateCsc(@Cast("cusparseSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                  @Cast("int64_t") long rows,
                  @Cast("int64_t") long cols,
                  @Cast("int64_t") long nnz,
                  Pointer cscColOffsets,
                  Pointer cscRowInd,
                  Pointer cscValues,
                  @Cast("cusparseIndexType_t") int cscColOffsetsType,
                  @Cast("cusparseIndexType_t") int cscRowIndType,
                  @Cast("cusparseIndexBase_t") int idxBase,
                  @Cast("cudaDataType") int valueType);

public static native @Cast("cusparseStatus_t") int cusparseCreateConstCsc(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                       @Cast("int64_t") long rows,
                       @Cast("int64_t") long cols,
                       @Cast("int64_t") long nnz,
                       @Const Pointer cscColOffsets,
                       @Const Pointer cscRowInd,
                       @Const Pointer cscValues,
                       @Cast("cusparseIndexType_t") int cscColOffsetsType,
                       @Cast("cusparseIndexType_t") int cscRowIndType,
                       @Cast("cusparseIndexBase_t") int idxBase,
                       @Cast("cudaDataType") int valueType);



public static native @Cast("cusparseStatus_t") int cusparseConstCsrGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") PointerPointer csrRowOffsets,
                    @Cast("const void**") PointerPointer csrColInd,
                    @Cast("const void**") PointerPointer csrValues,
                    @Cast("cusparseIndexType_t*") IntPointer csrRowOffsetsType,
                    @Cast("cusparseIndexType_t*") IntPointer csrColIndType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCsrGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer csrRowOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer csrColInd,
                    @Cast("const void**") @ByPtrPtr Pointer csrValues,
                    @Cast("cusparseIndexType_t*") IntPointer csrRowOffsetsType,
                    @Cast("cusparseIndexType_t*") IntPointer csrColIndType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCsrGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongBuffer rows,
                    @Cast("int64_t*") LongBuffer cols,
                    @Cast("int64_t*") LongBuffer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer csrRowOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer csrColInd,
                    @Cast("const void**") @ByPtrPtr Pointer csrValues,
                    @Cast("cusparseIndexType_t*") IntBuffer csrRowOffsetsType,
                    @Cast("cusparseIndexType_t*") IntBuffer csrColIndType,
                    @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
                    @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCsrGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") long[] rows,
                    @Cast("int64_t*") long[] cols,
                    @Cast("int64_t*") long[] nnz,
                    @Cast("const void**") @ByPtrPtr Pointer csrRowOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer csrColInd,
                    @Cast("const void**") @ByPtrPtr Pointer csrValues,
                    @Cast("cusparseIndexType_t*") int[] csrRowOffsetsType,
                    @Cast("cusparseIndexType_t*") int[] csrColIndType,
                    @Cast("cusparseIndexBase_t*") int[] idxBase,
                    @Cast("cudaDataType*") int[] valueType);

public static native @Cast("cusparseStatus_t") int cusparseCscGet(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
               @Cast("int64_t*") LongPointer rows,
               @Cast("int64_t*") LongPointer cols,
               @Cast("int64_t*") LongPointer nnz,
               @Cast("void**") PointerPointer cscColOffsets,
               @Cast("void**") PointerPointer cscRowInd,
               @Cast("void**") PointerPointer cscValues,
               @Cast("cusparseIndexType_t*") IntPointer cscColOffsetsType,
               @Cast("cusparseIndexType_t*") IntPointer cscRowIndType,
               @Cast("cusparseIndexBase_t*") IntPointer idxBase,
               @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseCscGet(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
               @Cast("int64_t*") LongPointer rows,
               @Cast("int64_t*") LongPointer cols,
               @Cast("int64_t*") LongPointer nnz,
               @Cast("void**") @ByPtrPtr Pointer cscColOffsets,
               @Cast("void**") @ByPtrPtr Pointer cscRowInd,
               @Cast("void**") @ByPtrPtr Pointer cscValues,
               @Cast("cusparseIndexType_t*") IntPointer cscColOffsetsType,
               @Cast("cusparseIndexType_t*") IntPointer cscRowIndType,
               @Cast("cusparseIndexBase_t*") IntPointer idxBase,
               @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseCscGet(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
               @Cast("int64_t*") LongBuffer rows,
               @Cast("int64_t*") LongBuffer cols,
               @Cast("int64_t*") LongBuffer nnz,
               @Cast("void**") @ByPtrPtr Pointer cscColOffsets,
               @Cast("void**") @ByPtrPtr Pointer cscRowInd,
               @Cast("void**") @ByPtrPtr Pointer cscValues,
               @Cast("cusparseIndexType_t*") IntBuffer cscColOffsetsType,
               @Cast("cusparseIndexType_t*") IntBuffer cscRowIndType,
               @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
               @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseCscGet(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
               @Cast("int64_t*") long[] rows,
               @Cast("int64_t*") long[] cols,
               @Cast("int64_t*") long[] nnz,
               @Cast("void**") @ByPtrPtr Pointer cscColOffsets,
               @Cast("void**") @ByPtrPtr Pointer cscRowInd,
               @Cast("void**") @ByPtrPtr Pointer cscValues,
               @Cast("cusparseIndexType_t*") int[] cscColOffsetsType,
               @Cast("cusparseIndexType_t*") int[] cscRowIndType,
               @Cast("cusparseIndexBase_t*") int[] idxBase,
               @Cast("cudaDataType*") int[] valueType);

public static native @Cast("cusparseStatus_t") int cusparseConstCscGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") PointerPointer cscColOffsets,
                    @Cast("const void**") PointerPointer cscRowInd,
                    @Cast("const void**") PointerPointer cscValues,
                    @Cast("cusparseIndexType_t*") IntPointer cscColOffsetsType,
                    @Cast("cusparseIndexType_t*") IntPointer cscRowIndType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCscGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cscColOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer cscRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cscValues,
                    @Cast("cusparseIndexType_t*") IntPointer cscColOffsetsType,
                    @Cast("cusparseIndexType_t*") IntPointer cscRowIndType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCscGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongBuffer rows,
                    @Cast("int64_t*") LongBuffer cols,
                    @Cast("int64_t*") LongBuffer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cscColOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer cscRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cscValues,
                    @Cast("cusparseIndexType_t*") IntBuffer cscColOffsetsType,
                    @Cast("cusparseIndexType_t*") IntBuffer cscRowIndType,
                    @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
                    @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCscGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") long[] rows,
                    @Cast("int64_t*") long[] cols,
                    @Cast("int64_t*") long[] nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cscColOffsets,
                    @Cast("const void**") @ByPtrPtr Pointer cscRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cscValues,
                    @Cast("cusparseIndexType_t*") int[] cscColOffsetsType,
                    @Cast("cusparseIndexType_t*") int[] cscRowIndType,
                    @Cast("cusparseIndexBase_t*") int[] idxBase,
                    @Cast("cudaDataType*") int[] valueType);

public static native @Cast("cusparseStatus_t") int cusparseCsrSetPointers(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                       Pointer csrRowOffsets,
                       Pointer csrColInd,
                       Pointer csrValues);

public static native @Cast("cusparseStatus_t") int cusparseCscSetPointers(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                       Pointer cscColOffsets,
                       Pointer cscRowInd,
                       Pointer cscValues);

//------------------------------------------------------------------------------
// ### BSR ###

public static native @Cast("cusparseStatus_t") int cusparseCreateBsr(@Cast("cusparseSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                  @Cast("int64_t") long brows,
                  @Cast("int64_t") long bcols,
                  @Cast("int64_t") long bnnz,
                  @Cast("int64_t") long rowBlockDim,
                  @Cast("int64_t") long colBlockDim,
                  Pointer bsrRowOffsets,
                  Pointer bsrColInd,
                  Pointer bsrValues,
                  @Cast("cusparseIndexType_t") int bsrRowOffsetsType,
                  @Cast("cusparseIndexType_t") int bsrColIndType,
                  @Cast("cusparseIndexBase_t") int idxBase,
                  @Cast("cudaDataType") int valueType,
                  @Cast("cusparseOrder_t") int order);

public static native @Cast("cusparseStatus_t") int cusparseCreateConstBsr(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                       @Cast("int64_t") long brows,
                       @Cast("int64_t") long bcols,
                       @Cast("int64_t") long bnnz,
                       @Cast("int64_t") long rowBlockDim,
                       @Cast("int64_t") long colBlockDim,
                       @Const Pointer bsrRowOffsets,
                       @Const Pointer bsrColInd,
                       @Const Pointer bsrValues,
                       @Cast("cusparseIndexType_t") int bsrRowOffsetsType,
                       @Cast("cusparseIndexType_t") int bsrColIndType,
                       @Cast("cusparseIndexBase_t") int idxBase,
                       @Cast("cudaDataType") int valueType,
                       @Cast("cusparseOrder_t") int order);

//------------------------------------------------------------------------------
// ### COO ###



public static native @Cast("cusparseStatus_t") int cusparseCreateConstCoo(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                       @Cast("int64_t") long rows,
                       @Cast("int64_t") long cols,
                       @Cast("int64_t") long nnz,
                       @Const Pointer cooRowInd,
                       @Const Pointer cooColInd,
                       @Const Pointer cooValues,
                       @Cast("cusparseIndexType_t") int cooIdxType,
                       @Cast("cusparseIndexBase_t") int idxBase,
                       @Cast("cudaDataType") int valueType);



public static native @Cast("cusparseStatus_t") int cusparseConstCooGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") PointerPointer cooRowInd,
                    @Cast("const void**") PointerPointer cooColInd,
                    @Cast("const void**") PointerPointer cooValues,
                    @Cast("cusparseIndexType_t*") IntPointer idxType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCooGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongPointer rows,
                    @Cast("int64_t*") LongPointer cols,
                    @Cast("int64_t*") LongPointer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cooRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooColInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooValues,
                    @Cast("cusparseIndexType_t*") IntPointer idxType,
                    @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                    @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCooGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") LongBuffer rows,
                    @Cast("int64_t*") LongBuffer cols,
                    @Cast("int64_t*") LongBuffer nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cooRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooColInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooValues,
                    @Cast("cusparseIndexType_t*") IntBuffer idxType,
                    @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
                    @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstCooGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                    @Cast("int64_t*") long[] rows,
                    @Cast("int64_t*") long[] cols,
                    @Cast("int64_t*") long[] nnz,
                    @Cast("const void**") @ByPtrPtr Pointer cooRowInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooColInd,
                    @Cast("const void**") @ByPtrPtr Pointer cooValues,
                    @Cast("cusparseIndexType_t*") int[] idxType,
                    @Cast("cusparseIndexBase_t*") int[] idxBase,
                    @Cast("cudaDataType*") int[] valueType);

public static native @Cast("cusparseStatus_t") int cusparseCooSetPointers(@Cast("cusparseSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                       Pointer cooRows,
                       Pointer cooColumns,
                       Pointer cooValues);

//------------------------------------------------------------------------------
// ### BLOCKED ELL ###

public static native @Cast("cusparseStatus_t") int cusparseCreateBlockedEll(@Cast("cusparseSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                         @Cast("int64_t") long rows,
                         @Cast("int64_t") long cols,
                         @Cast("int64_t") long ellBlockSize,
                         @Cast("int64_t") long ellCols,
                         Pointer ellColInd,
                         Pointer ellValue,
                         @Cast("cusparseIndexType_t") int ellIdxType,
                         @Cast("cusparseIndexBase_t") int idxBase,
                         @Cast("cudaDataType") int valueType);

public static native @Cast("cusparseStatus_t") int cusparseCreateConstBlockedEll(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                              @Cast("int64_t") long rows,
                              @Cast("int64_t") long cols,
                              @Cast("int64_t") long ellBlockSize,
                              @Cast("int64_t") long ellCols,
                              @Const Pointer ellColInd,
                              @Const Pointer ellValue,
                              @Cast("cusparseIndexType_t") int ellIdxType,
                              @Cast("cusparseIndexBase_t") int idxBase,
                              @Cast("cudaDataType") int valueType);



public static native @Cast("cusparseStatus_t") int cusparseConstBlockedEllGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           @Cast("int64_t*") LongPointer rows,
                           @Cast("int64_t*") LongPointer cols,
                           @Cast("int64_t*") LongPointer ellBlockSize,
                           @Cast("int64_t*") LongPointer ellCols,
                           @Cast("const void**") PointerPointer ellColInd,
                           @Cast("const void**") PointerPointer ellValue,
                           @Cast("cusparseIndexType_t*") IntPointer ellIdxType,
                           @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                           @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstBlockedEllGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           @Cast("int64_t*") LongPointer rows,
                           @Cast("int64_t*") LongPointer cols,
                           @Cast("int64_t*") LongPointer ellBlockSize,
                           @Cast("int64_t*") LongPointer ellCols,
                           @Cast("const void**") @ByPtrPtr Pointer ellColInd,
                           @Cast("const void**") @ByPtrPtr Pointer ellValue,
                           @Cast("cusparseIndexType_t*") IntPointer ellIdxType,
                           @Cast("cusparseIndexBase_t*") IntPointer idxBase,
                           @Cast("cudaDataType*") IntPointer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstBlockedEllGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           @Cast("int64_t*") LongBuffer rows,
                           @Cast("int64_t*") LongBuffer cols,
                           @Cast("int64_t*") LongBuffer ellBlockSize,
                           @Cast("int64_t*") LongBuffer ellCols,
                           @Cast("const void**") @ByPtrPtr Pointer ellColInd,
                           @Cast("const void**") @ByPtrPtr Pointer ellValue,
                           @Cast("cusparseIndexType_t*") IntBuffer ellIdxType,
                           @Cast("cusparseIndexBase_t*") IntBuffer idxBase,
                           @Cast("cudaDataType*") IntBuffer valueType);
public static native @Cast("cusparseStatus_t") int cusparseConstBlockedEllGet(@Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr spMatDescr,
                           @Cast("int64_t*") long[] rows,
                           @Cast("int64_t*") long[] cols,
                           @Cast("int64_t*") long[] ellBlockSize,
                           @Cast("int64_t*") long[] ellCols,
                           @Cast("const void**") @ByPtrPtr Pointer ellColInd,
                           @Cast("const void**") @ByPtrPtr Pointer ellValue,
                           @Cast("cusparseIndexType_t*") int[] ellIdxType,
                           @Cast("cusparseIndexBase_t*") int[] idxBase,
                           @Cast("cudaDataType*") int[] valueType);

//------------------------------------------------------------------------------
// ### Sliced ELLPACK ###

public static native @Cast("cusparseStatus_t") int cusparseCreateSlicedEll(@Cast("cusparseSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                        @Cast("int64_t") long rows,
                        @Cast("int64_t") long cols,
                        @Cast("int64_t") long nnz,
                        @Cast("int64_t") long sellValuesSize,
                        @Cast("int64_t") long sliceSize,
	                Pointer sellSliceOffsets,
                        Pointer sellColInd,
                        Pointer sellValues,
			@Cast("cusparseIndexType_t") int sellSliceOffsetsType,
                        @Cast("cusparseIndexType_t") int sellColIndType,
                        @Cast("cusparseIndexBase_t") int idxBase,
                        @Cast("cudaDataType") int valueType);

public static native @Cast("cusparseStatus_t") int cusparseCreateConstSlicedEll(@Cast("cusparseConstSpMatDescr_t*") @ByPtrPtr cusparseSpMatDescr spMatDescr,
                             @Cast("int64_t") long rows,
                             @Cast("int64_t") long cols,
                             @Cast("int64_t") long nnz,
                             @Cast("int64_t") long sellValuesSize,
                             @Cast("int64_t") long sliceSize,
                             @Const Pointer sellSliceOffsets,
                             @Const Pointer sellColInd,
                             @Const Pointer sellValues,
                             @Cast("cusparseIndexType_t") int sellSliceOffsetsType,
                             @Cast("cusparseIndexType_t") int sellColIndType,
                             @Cast("cusparseIndexBase_t") int idxBase,
                             @Cast("cudaDataType") int valueType);

// #############################################################################
// # DENSE MATRIX DESCRIPTOR
// #############################################################################



public static native @Cast("cusparseStatus_t") int cusparseCreateConstDnMat(@Cast("cusparseConstDnMatDescr_t*") @ByPtrPtr cusparseDnMatDescr dnMatDescr,
                         @Cast("int64_t") long rows,
                         @Cast("int64_t") long cols,
                         @Cast("int64_t") long ld,
                         @Const Pointer values,
                         @Cast("cudaDataType") int valueType,
                         @Cast("cusparseOrder_t") int order);





public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGet(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                      @Cast("int64_t*") LongPointer rows,
                      @Cast("int64_t*") LongPointer cols,
                      @Cast("int64_t*") LongPointer ld,
                      @Cast("const void**") PointerPointer values,
                      @Cast("cudaDataType*") IntPointer type,
                      @Cast("cusparseOrder_t*") IntPointer order);
public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGet(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                      @Cast("int64_t*") LongPointer rows,
                      @Cast("int64_t*") LongPointer cols,
                      @Cast("int64_t*") LongPointer ld,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") IntPointer type,
                      @Cast("cusparseOrder_t*") IntPointer order);
public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGet(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                      @Cast("int64_t*") LongBuffer rows,
                      @Cast("int64_t*") LongBuffer cols,
                      @Cast("int64_t*") LongBuffer ld,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") IntBuffer type,
                      @Cast("cusparseOrder_t*") IntBuffer order);
public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGet(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                      @Cast("int64_t*") long[] rows,
                      @Cast("int64_t*") long[] cols,
                      @Cast("int64_t*") long[] ld,
                      @Cast("const void**") @ByPtrPtr Pointer values,
                      @Cast("cudaDataType*") int[] type,
                      @Cast("cusparseOrder_t*") int[] order);



public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGetValues(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                            @Cast("const void**") PointerPointer values);
public static native @Cast("cusparseStatus_t") int cusparseConstDnMatGetValues(@Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr dnMatDescr,
                            @Cast("const void**") @ByPtrPtr Pointer values);







// #############################################################################
// # VECTOR-VECTOR OPERATIONS
// #############################################################################

public static native @Cast("cusparseStatus_t") int cusparseAxpby(cusparseContext handle,
              @Const Pointer alpha,
              @Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr vecX,
              @Const Pointer beta,
              @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY);

public static native @Cast("cusparseStatus_t") int cusparseGather(cusparseContext handle,
               @Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr vecY,
               @Cast("cusparseSpVecDescr_t") cusparseSpVecDescr vecX);

public static native @Cast("cusparseStatus_t") int cusparseScatter(cusparseContext handle,
                @Cast("cusparseConstSpVecDescr_t") cusparseSpVecDescr vecX,
                @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY);

public static native @Cast("cusparseStatus_t") int cusparseRot(cusparseContext handle,
            @Const Pointer c_coeff,
            @Const Pointer s_coeff,
            @Cast("cusparseSpVecDescr_t") cusparseSpVecDescr vecX,
            @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY);





// #############################################################################
// # SPARSE TO DENSE
// #############################################################################

/** enum cusparseSparseToDenseAlg_t */
public static final int
    CUSPARSE_SPARSETODENSE_ALG_DEFAULT = 0;

public static native @Cast("cusparseStatus_t") int cusparseSparseToDense_bufferSize(cusparseContext handle,
                                 @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                                 @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matB,
                                 @Cast("cusparseSparseToDenseAlg_t") int alg,
                                 @Cast("size_t*") SizeTPointer bufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSparseToDense(cusparseContext handle,
                      @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                      @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matB,
                      @Cast("cusparseSparseToDenseAlg_t") int alg,
                      Pointer externalBuffer);

// #############################################################################
// # DENSE TO SPARSE
// #############################################################################

/** enum cusparseDenseToSparseAlg_t */
public static final int
    CUSPARSE_DENSETOSPARSE_ALG_DEFAULT = 0;

public static native @Cast("cusparseStatus_t") int cusparseDenseToSparse_bufferSize(cusparseContext handle,
                                 @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
                                 @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matB,
                                 @Cast("cusparseDenseToSparseAlg_t") int alg,
                                 @Cast("size_t*") SizeTPointer bufferSize);

public static native @Cast("cusparseStatus_t") int cusparseDenseToSparse_analysis(cusparseContext handle,
                               @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
                               @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matB,
                               @Cast("cusparseDenseToSparseAlg_t") int alg,
                               Pointer externalBuffer);

public static native @Cast("cusparseStatus_t") int cusparseDenseToSparse_convert(cusparseContext handle,
                              @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
                              @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matB,
                              @Cast("cusparseDenseToSparseAlg_t") int alg,
                              Pointer externalBuffer);

// #############################################################################
// # SPARSE MATRIX-VECTOR MULTIPLICATION
// #############################################################################

/** enum cusparseSpMVAlg_t */
public static final int
    CUSPARSE_SPMV_ALG_DEFAULT = 0,
    CUSPARSE_SPMV_CSR_ALG1    = 2,
    CUSPARSE_SPMV_CSR_ALG2    = 3,
    CUSPARSE_SPMV_COO_ALG1    = 1,
    CUSPARSE_SPMV_COO_ALG2    = 4,
    CUSPARSE_SPMV_SELL_ALG1   = 5;





// #############################################################################
// # SPARSE TRIANGULAR VECTOR SOLVE
// #############################################################################

/** enum cusparseSpSVAlg_t */
public static final int
    CUSPARSE_SPSV_ALG_DEFAULT = 0;

/** enum cusparseSpSVUpdate_t */
public static final int
    CUSPARSE_SPSV_UPDATE_GENERAL  = 0,
    CUSPARSE_SPSV_UPDATE_DIAGONAL = 1;
// Targeting ../cusparse/cusparseSpSVDescr.java



public static native @Cast("cusparseStatus_t") int cusparseSpSV_createDescr(@ByPtrPtr cusparseSpSVDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpSV_destroyDescr(cusparseSpSVDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpSV_bufferSize(cusparseContext handle,
                        @Cast("cusparseOperation_t") int opA,
                        @Const Pointer alpha,
                        @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                        @Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr vecX,
                        @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY,
                        @Cast("cudaDataType") int computeType,
                        @Cast("cusparseSpSVAlg_t") int alg,
                        cusparseSpSVDescr spsvDescr,
                        @Cast("size_t*") SizeTPointer bufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSpSV_analysis(cusparseContext handle,
                      @Cast("cusparseOperation_t") int opA,
                      @Const Pointer alpha,
                      @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                      @Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr vecX,
                      @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY,
                      @Cast("cudaDataType") int computeType,
                      @Cast("cusparseSpSVAlg_t") int alg,
                      cusparseSpSVDescr spsvDescr,
                      Pointer externalBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSpSV_solve(cusparseContext handle,
                   @Cast("cusparseOperation_t") int opA,
                   @Const Pointer alpha,
                   @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                   @Cast("cusparseConstDnVecDescr_t") cusparseDnVecDescr vecX,
                   @Cast("cusparseDnVecDescr_t") cusparseDnVecDescr vecY,
                   @Cast("cudaDataType") int computeType,
                   @Cast("cusparseSpSVAlg_t") int alg,
                   cusparseSpSVDescr spsvDescr);

public static native @Cast("cusparseStatus_t") int cusparseSpSV_updateMatrix(cusparseContext handle,
				          cusparseSpSVDescr spsvDescr,
                          Pointer newValues,
                          @Cast("cusparseSpSVUpdate_t") int updatePart);



// #############################################################################
// # SPARSE TRIANGULAR MATRIX SOLVE
// #############################################################################

/** enum cusparseSpSMAlg_t */
public static final int
    CUSPARSE_SPSM_ALG_DEFAULT = 0;
// Targeting ../cusparse/cusparseSpSMDescr.java



public static native @Cast("cusparseStatus_t") int cusparseSpSM_createDescr(@ByPtrPtr cusparseSpSMDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpSM_destroyDescr(cusparseSpSMDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpSM_bufferSize(cusparseContext handle,
                        @Cast("cusparseOperation_t") int opA,
                        @Cast("cusparseOperation_t") int opB,
                        @Const Pointer alpha,
                        @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                        @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                        @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matC,
                        @Cast("cudaDataType") int computeType,
                        @Cast("cusparseSpSMAlg_t") int alg,
                        cusparseSpSMDescr spsmDescr,
                        @Cast("size_t*") SizeTPointer bufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSpSM_analysis(cusparseContext handle,
                      @Cast("cusparseOperation_t") int opA,
                      @Cast("cusparseOperation_t") int opB,
                      @Const Pointer alpha,
                      @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                      @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                      @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matC,
                      @Cast("cudaDataType") int computeType,
                      @Cast("cusparseSpSMAlg_t") int alg,
                      cusparseSpSMDescr spsmDescr,
                      Pointer externalBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSpSM_solve(cusparseContext handle,
                   @Cast("cusparseOperation_t") int opA,
                   @Cast("cusparseOperation_t") int opB,
                   @Const Pointer alpha,
                   @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                   @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                   @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matC,
                   @Cast("cudaDataType") int computeType,
                   @Cast("cusparseSpSMAlg_t") int alg,
                   cusparseSpSMDescr spsmDescr);

// #############################################################################
// # SPARSE MATRIX-MATRIX MULTIPLICATION
// #############################################################################

/** enum cusparseSpMMAlg_t */
public static final int
    CUSPARSE_SPMM_ALG_DEFAULT      = 0,
    CUSPARSE_SPMM_COO_ALG1         = 1,
    CUSPARSE_SPMM_COO_ALG2         = 2,
    CUSPARSE_SPMM_COO_ALG3         = 3,
    CUSPARSE_SPMM_COO_ALG4         = 5,
    CUSPARSE_SPMM_CSR_ALG1         = 4,
    CUSPARSE_SPMM_CSR_ALG2         = 6,
    CUSPARSE_SPMM_CSR_ALG3         = 12,
    CUSPARSE_SPMM_BLOCKED_ELL_ALG1 = 13;



public static native @Cast("cusparseStatus_t") int cusparseSpMM_preprocess(cusparseContext handle,
                        @Cast("cusparseOperation_t") int opA,
                        @Cast("cusparseOperation_t") int opB,
                        @Const Pointer alpha,
                        @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                        @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                        @Const Pointer beta,
                        @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matC,
                        @Cast("cudaDataType") int computeType,
                        @Cast("cusparseSpMMAlg_t") int alg,
                        Pointer externalBuffer);



// #############################################################################
// # SPARSE MATRIX - SPARSE MATRIX MULTIPLICATION (SpGEMM)
// #############################################################################

/** enum cusparseSpGEMMAlg_t */
public static final int
    CUSPARSE_SPGEMM_DEFAULT                 = 0,
    CUSPARSE_SPGEMM_CSR_ALG_DETERMINITIC    = 1,
    CUSPARSE_SPGEMM_CSR_ALG_NONDETERMINITIC = 2,
    CUSPARSE_SPGEMM_ALG1                    = 3,
    CUSPARSE_SPGEMM_ALG2                    = 4,
    CUSPARSE_SPGEMM_ALG3                    = 5;
// Targeting ../cusparse/cusparseSpGEMMDescr.java



public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_createDescr(@ByPtrPtr cusparseSpGEMMDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_destroyDescr(cusparseSpGEMMDescr descr);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_workEstimation(cusparseContext handle,
                              @Cast("cusparseOperation_t") int opA,
                              @Cast("cusparseOperation_t") int opB,
                              @Const Pointer alpha,
                              @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                              @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                              @Const Pointer beta,
                              @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                              @Cast("cudaDataType") int computeType,
                              @Cast("cusparseSpGEMMAlg_t") int alg,
                              cusparseSpGEMMDescr spgemmDescr,
                              @Cast("size_t*") SizeTPointer bufferSize1,
                              Pointer externalBuffer1);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_getNumProducts(cusparseSpGEMMDescr spgemmDescr,
                              @Cast("int64_t*") LongPointer num_prods);
public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_getNumProducts(cusparseSpGEMMDescr spgemmDescr,
                              @Cast("int64_t*") LongBuffer num_prods);
public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_getNumProducts(cusparseSpGEMMDescr spgemmDescr,
                              @Cast("int64_t*") long[] num_prods);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_estimateMemory(cusparseContext handle,
                              @Cast("cusparseOperation_t") int opA,
                              @Cast("cusparseOperation_t") int opB,
                              @Const Pointer alpha,
                              @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                              @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                              @Const Pointer beta,
                              @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                              @Cast("cudaDataType") int computeType,
                              @Cast("cusparseSpGEMMAlg_t") int alg,
                              cusparseSpGEMMDescr spgemmDescr,
                              float chunk_fraction,
                              @Cast("size_t*") SizeTPointer bufferSize3,
                              Pointer externalBuffer3,
                              @Cast("size_t*") SizeTPointer bufferSize2);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_compute(cusparseContext handle,
                       @Cast("cusparseOperation_t") int opA,
                       @Cast("cusparseOperation_t") int opB,
                       @Const Pointer alpha,
                       @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                       @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                       @Const Pointer beta,
                       @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                       @Cast("cudaDataType") int computeType,
                       @Cast("cusparseSpGEMMAlg_t") int alg,
                       cusparseSpGEMMDescr spgemmDescr,
                       @Cast("size_t*") SizeTPointer bufferSize2,
                       Pointer externalBuffer2);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMM_copy(cusparseContext handle,
                    @Cast("cusparseOperation_t") int opA,
                    @Cast("cusparseOperation_t") int opB,
                    @Const Pointer alpha,
                    @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                    @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                    @Const Pointer beta,
                    @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                    @Cast("cudaDataType") int computeType,
                    @Cast("cusparseSpGEMMAlg_t") int alg,
                    cusparseSpGEMMDescr spgemmDescr);

// #############################################################################
// # SPARSE MATRIX - SPARSE MATRIX MULTIPLICATION (SpGEMM) STRUCTURE REUSE
// #############################################################################

public static native @Cast("cusparseStatus_t") int cusparseSpGEMMreuse_workEstimation(cusparseContext handle,
                                   @Cast("cusparseOperation_t") int opA,
                                   @Cast("cusparseOperation_t") int opB,
                                   @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                                   @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                                   @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                                   @Cast("cusparseSpGEMMAlg_t") int alg,
                                   cusparseSpGEMMDescr spgemmDescr,
                                   @Cast("size_t*") SizeTPointer bufferSize1,
                                   Pointer externalBuffer1);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMMreuse_nnz(cusparseContext handle,
                        @Cast("cusparseOperation_t") int opA,
                        @Cast("cusparseOperation_t") int opB,
                        @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                        @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                        @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                        @Cast("cusparseSpGEMMAlg_t") int alg,
                        cusparseSpGEMMDescr spgemmDescr,
                        @Cast("size_t*") SizeTPointer bufferSize2,
                        Pointer externalBuffer2,
                        @Cast("size_t*") SizeTPointer bufferSize3,
                        Pointer externalBuffer3,
                        @Cast("size_t*") SizeTPointer bufferSize4,
                        Pointer externalBuffer4);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMMreuse_copy(cusparseContext handle,
                         @Cast("cusparseOperation_t") int opA,
                         @Cast("cusparseOperation_t") int opB,
                         @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                         @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                         @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                         @Cast("cusparseSpGEMMAlg_t") int alg,
                         cusparseSpGEMMDescr spgemmDescr,
                         @Cast("size_t*") SizeTPointer bufferSize5,
                         Pointer externalBuffer5);

public static native @Cast("cusparseStatus_t") int cusparseSpGEMMreuse_compute(cusparseContext handle,
                            @Cast("cusparseOperation_t") int opA,
                            @Cast("cusparseOperation_t") int opB,
                            @Const Pointer alpha,
                            @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                            @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matB,
                            @Const Pointer beta,
                            @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                            @Cast("cudaDataType") int computeType,
                            @Cast("cusparseSpGEMMAlg_t") int alg,
                            cusparseSpGEMMDescr spgemmDescr);

// #############################################################################
// # SAMPLED DENSE-DENSE MATRIX MULTIPLICATION
// #############################################################################

/** enum cusparseSDDMMAlg_t */
public static final int
    CUSPARSE_SDDMM_ALG_DEFAULT = 0;

public static native @Cast("cusparseStatus_t") int cusparseSDDMM_bufferSize(cusparseContext handle,
                         @Cast("cusparseOperation_t") int opA,
                         @Cast("cusparseOperation_t") int opB,
                         @Const Pointer alpha,
                         @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
                         @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                         @Const Pointer beta,
                         @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                         @Cast("cudaDataType") int computeType,
                         @Cast("cusparseSDDMMAlg_t") int alg,
                         @Cast("size_t*") SizeTPointer bufferSize);

public static native @Cast("cusparseStatus_t") int cusparseSDDMM_preprocess(cusparseContext handle,
                         @Cast("cusparseOperation_t") int opA,
                         @Cast("cusparseOperation_t") int opB,
                         @Const Pointer alpha,
                         @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
                         @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                         @Const Pointer beta,
                         @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
                         @Cast("cudaDataType") int computeType,
                         @Cast("cusparseSDDMMAlg_t") int alg,
                         Pointer externalBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSDDMM(cusparseContext handle,
              @Cast("cusparseOperation_t") int opA,
              @Cast("cusparseOperation_t") int opB,
              @Const Pointer alpha,
              @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matA,
              @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
              @Const Pointer beta,
              @Cast("cusparseSpMatDescr_t") cusparseSpMatDescr matC,
              @Cast("cudaDataType") int computeType,
              @Cast("cusparseSDDMMAlg_t") int alg,
              Pointer externalBuffer);
// Targeting ../cusparse/cusparseSpMMOpPlan.java



/** enum cusparseSpMMOpAlg_t */
public static final int
    CUSPARSE_SPMM_OP_ALG_DEFAULT = 0;

public static native @Cast("cusparseStatus_t") int cusparseSpMMOp_createPlan(cusparseContext handle,
                          @ByPtrPtr cusparseSpMMOpPlan plan,
                          @Cast("cusparseOperation_t") int opA,
                          @Cast("cusparseOperation_t") int opB,
                          @Cast("cusparseConstSpMatDescr_t") cusparseSpMatDescr matA,
                          @Cast("cusparseConstDnMatDescr_t") cusparseDnMatDescr matB,
                          @Cast("cusparseDnMatDescr_t") cusparseDnMatDescr matC,
                          @Cast("cudaDataType") int computeType,
                          @Cast("cusparseSpMMOpAlg_t") int alg,
                          @Const Pointer addOperationNvvmBuffer,
                          @Cast("size_t") long addOperationBufferSize,
                          @Const Pointer mulOperationNvvmBuffer,
                          @Cast("size_t") long mulOperationBufferSize,
                          @Const Pointer epilogueNvvmBuffer,
                          @Cast("size_t") long epilogueBufferSize,
                          @Cast("size_t*") SizeTPointer SpMMWorkspaceSize);

public static native @Cast("cusparseStatus_t") int cusparseSpMMOp(cusparseSpMMOpPlan plan,
               Pointer externalBuffer);

public static native @Cast("cusparseStatus_t") int cusparseSpMMOp_destroyPlan(cusparseSpMMOpPlan plan);

//------------------------------------------------------------------------------

// #if defined(__cplusplus) // extern "C"
// #endif // defined(__cplusplus)

// #undef CUSPARSE_DEPRECATED

// #endif // !defined(CUSPARSE_H_)


}
