// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppial extends org.bytedeco.cuda.presets.nppial {
    static { Loader.load(); }

// Parsed from <nppi_arithmetic_and_logical_operations.h>

 /* Copyright 2009-2022 NVIDIA CORPORATION & AFFILIATES.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are 
  * subject to NVIDIA intellectual property rights under U.S. and 
  * international Copyright laws. 
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED 
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY 
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_ARITHMETIC_AND_LOGICAL_OPERATIONS_H
// #define NV_NPPI_ARITHMETIC_AND_LOGICAL_OPERATIONS_H
 
/**
 * \file nppi_arithmetic_and_logical_operations.h
 * Image Arithmetic and Logical Operations.
 */
 
// #include "nppdefs.h"


// #ifdef __cplusplus
// #endif


/** 
 * \defgroup image_arithmetic_and_logical_operations Arithmetic and Logical Operations
 * \ingroup nppi
 * \{
 *
 * These functions can be found in the nppial library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 */

/** 
 * \defgroup image_arithmetic_operations Arithmetic Operations
 * The set of image processing arithmetic operations available in the library.
 * \{
 */

/** 
 * \defgroup image_addc AddC
 *
 * Adds a constant value to each pixel of an image. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory Constant. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling. 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant pointer to device memory Constant. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling. 
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstant, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstant, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstant, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
/** 
 * One 8-bit unsigned char channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory Constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstant pointer to device memory Constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C3IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                              @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                              @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                              @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel..
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel..
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel..
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel..
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
/** 
 * Four 8-bit unsigned char channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_8u_C4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstant, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstant, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstant, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);


/** 
 * One 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C3IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                               @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                               @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                               @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                           @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                           @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                           @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                     @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                     @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                     @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_AC4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16u_C4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstant, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstant, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstant, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C3IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                               @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                               @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                               @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                           @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                           @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                           @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                     @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                     @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                     @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_AC4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
/** 
 * Four 16-bit signed short channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_16s_C4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step. 
 * @param nConstant host memory constant. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_C1IRSfs_Ctx(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_C1IRSfs(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_C3IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_C3IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                                Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                            Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16sc_AC4IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16sc_AC4IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstant, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstant, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstant, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed integer channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstants, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstants, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstants, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAddC_32s_C3IRSfs(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image add constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image add constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_C1IRSfs_Ctx(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_C1IRSfs(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_C3IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_C3IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha image add constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                                Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                            Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image add constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32sc_AC4IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32sc_AC4IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit floating point channel in place image add constant.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C1IR(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image add constant.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel in place image add constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C3IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image add constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel in place image add constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_16f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_16f_C4IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image add constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel in place image add constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image add constant.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel in place image add constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C3IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image add constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                            @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                            @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                            @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                        @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                        @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                        @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                  @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                  @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                  @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image add constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_AC4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image add constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);


/** 
 * Four 32-bit floating point channel in place image add constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddC_32f_C4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image add constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image add constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C1IR_Ctx(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_C1IR(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddC_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image add constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C3IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_C3IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                             Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                         Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha in place image add constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_AC4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_AC4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image add constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_C4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image add constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddC_32fc_C4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddC_32fc_C4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_addc */ 


/** 
 * \defgroup image_mulc MulC
 *
 * Multiplies each pixel of an image by a constant value. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstant, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstant, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstant, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 8-bit unsigned char channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C3IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                              @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                              @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                              @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_8u_C4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstant, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstant, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstant, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);


/** 
 * One 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C3IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                               @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                               @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                               @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                           @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                           @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                           @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                     @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                     @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                     @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_AC4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16u_C4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstant, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstant, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstant, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C3IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                               @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                               @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                               @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                           @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                           @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                           @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                     @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                     @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                     @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_AC4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_16s_C4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_C1IRSfs_Ctx(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_C1IRSfs(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_C3IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_C3IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                                Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                            Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16sc_AC4IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16sc_AC4IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstant, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstant, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstant, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed integer channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstants, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstants, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstants, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMulC_32s_C3IRSfs(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_C1IRSfs_Ctx(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_C1IRSfs(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_C3IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_C3IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha image multiply by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                            Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                            Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image multiply by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32sc_AC4IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32sc_AC4IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant 32-bit floating point host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant 32-bit floating point device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit floating point channel in place image multiply by constant.
 * @param nConstant 32-bit floating point host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C1IR(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image multiply by constant.
 * @param pConstant 32-bit floating point device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel in place image multiply by constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C3IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image multiply by constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel in place image multiply by constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_16f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_16f_C4IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image multiply by constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel in place image multiply by constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image multiply by constant.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel in place image multiply by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C3IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image multiply by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                            @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                            @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                            @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                        @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                        @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                        @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                  @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                  @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                  @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);


/** 
 * Four 32-bit floating point channel with unmodified alpha in place image multiply by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_AC4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image multiply by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);


/** 
 * Four 32-bit floating point channel in place image multiply by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulC_32f_C4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image multiply by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image multiply by constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C1IR_Ctx(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C1IR(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image multiply by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C3IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C3IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                             Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                         Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha in place image multiply by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_AC4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_AC4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image multiply by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image multiply by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulC_32fc_C4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulC_32fc_C4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_mulc */ 

/** 
 * \defgroup image_mulcscale MulCScale
 *
 * Multiplies each pixel of an image by a constant value then scales the result
 * by the maximum value for the data bit width. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                               @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                               @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                               @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                           @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                           @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                           @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstant, 
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstant, 
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstant, 
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 8-bit unsigned char channel in place image multiply by constant and scale by max bit width value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C1IR(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 8-bit unsigned char channel in place image multiply by constant and scale by max bit width value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1IR_Ctx(@Cast("const Npp8u*") BytePointer pConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1IR_Ctx(@Cast("const Npp8u*") ByteBuffer pConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C1IR_Ctx(@Cast("const Npp8u*") byte[] pConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                               @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                               @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                               @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                           @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                           @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                           @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image multiply by constant and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C3IR(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image multiply by constant and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C3IR_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                                @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                                @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                                @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                      @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                      @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                      @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image multiply by constant, scale and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_AC4IR(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image multiply by constant, scale and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_AC4IR_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                               @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                               @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                               @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                           @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                           @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                           @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 8-bit unsigned char channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                     @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                     @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                     @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel in place image multiply by constant and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_8u_C4IR(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 8-bit unsigned char channel in place image multiply by constant and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_8u_C4IR_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                                @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                                @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                                @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                            @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                            @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                            @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstant, 
                                      @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstant, 
                                      @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstant, 
                                      @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C1IR(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1IR_Ctx(@Cast("const Npp16u*") ShortPointer pConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1IR_Ctx(@Cast("const Npp16u*") ShortBuffer pConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C1IR_Ctx(@Cast("const Npp16u*") short[] pConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                                @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                                @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                                @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                            @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                            @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                            @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                      @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                      @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                      @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C3IR(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C3IR_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                                 @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                                 @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                                 @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                       @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                       @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                       @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);


/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image multiply by constant and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_AC4IR(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image multiply by constant and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_AC4IR_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                                @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                                @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                                @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                            @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                            @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                            @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit unsigned short channel image multiply by constant and scale by max bit width value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                      @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                      @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                      @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMulCScale_16u_C4IR(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit unsigned short channel in place image multiply by constant and scale by max bit width value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMulDeviceCScale_16u_C4IR_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** \} image_mulcscale */ 

/** \defgroup image_subc SubC
 * Subtracts a constant value from each pixel of an image. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstant, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstant, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstant, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 8-bit unsigned char channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C3IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                              @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                              @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                              @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_8u_C4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstant, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstant, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstant, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C3IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                               @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                               @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                               @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                           @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                           @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                           @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                     @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                     @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                     @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_AC4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16u_C4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstant, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstant, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstant, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C3IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                               @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                               @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                               @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                           @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                           @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                           @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                     @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                     @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                     @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_AC4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_16s_C4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_C1IRSfs_Ctx(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_C1IRSfs(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_C3IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_C3IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                                Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                            Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16sc_AC4IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16sc_AC4IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstant, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstant, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstant, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed integer channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstants, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstants, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstants, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiSubC_32s_C3IRSfs(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image subtract constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image subtract constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_C1IRSfs_Ctx(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_C1IRSfs(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_C3IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_C3IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha image subtract constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                                Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                            Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image subtract constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32sc_AC4IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32sc_AC4IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit floating point channel in place image subtract constant.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16f_C1IR(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image subtract constant.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel in place image subtract constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C3IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image subtract constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
  
/** 
 * Four 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
  
/** 
 * Four 16-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel in place image subtract constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_16f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_16f_C4IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image subtract constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel in place image subtract constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image subtract constant.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel in place image subtract constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C3IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image subtract constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                            @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                            @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                            @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                        @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                        @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                        @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                  @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                  @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                  @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image subtract constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_AC4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image subtract constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel in place image subtract constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiSubC_32f_C4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image subtract constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSubDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image subtract constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C1IR_Ctx(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C1IR(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image subtract constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C3IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C3IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                             Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                         Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha in place image subtract constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_AC4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_AC4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image subtract constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image subtract constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiSubC_32fc_C4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSubC_32fc_C4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_subc */ 

/** 
 * \defgroup image_divc DivC
 *
 * Divides each pixel of an image by a constant value. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u") byte nConstant, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstant, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstant, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstant, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 8-bit unsigned char channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs_Ctx(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C1IRSfs(@Cast("const Npp8u") byte nConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstant, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstant, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstant, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C3IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel 8-bit unsigned char in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                              @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                              @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                              @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                          @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                          @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                          @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                    @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                    @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                    @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer aConstants, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer aConstants, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] aConstants, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pConstants, 
                                   @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pConstants, 
                                   @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pConstants, 
                                   @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 8-bit unsigned char channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer aConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer aConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_8u_C4IRSfs(@Cast("const Npp8u*") byte[] aConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pConstants, @Cast("Npp8u*") BytePointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pConstants, @Cast("Npp8u*") ByteBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pConstants, @Cast("Npp8u*") byte[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u") short nConstant, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstant, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstant, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstant, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs_Ctx(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C1IRSfs(@Cast("const Npp16u") short nConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstant, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstant, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstant, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C3IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                               @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                               @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                               @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                           @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                           @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                           @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                     @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                     @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                     @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);


/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_AC4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer aConstants, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer aConstants, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] aConstants, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pConstants, 
                                    @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pConstants, 
                                    @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pConstants, 
                                    @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer aConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer aConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16u_C4IRSfs(@Cast("const Npp16u*") short[] aConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pConstants, @Cast("Npp16u*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pConstants, @Cast("Npp16u*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pConstants, @Cast("Npp16u*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s") short nConstant, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstant, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstant, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstant, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs_Ctx(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C1IRSfs(@Cast("const Npp16s") short nConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstant, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstant, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstant, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C3IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                               @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                               @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                               @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                           @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                           @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                           @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                     @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                     @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                     @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_AC4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer aConstants, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer aConstants, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] aConstants, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pConstants, 
                                    @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pConstants, 
                                    @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pConstants, 
                                    @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer aConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer aConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_16s_C4IRSfs(@Cast("const Npp16s*") short[] aConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pConstants, @Cast("Npp16s*") ShortPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pConstants, @Cast("Npp16s*") ShortBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pConstants, @Cast("Npp16s*") short[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const @ByVal Npp16sc nConstant, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_C1IRSfs_Ctx(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_C1IRSfs(@Const @ByVal Npp16sc nConstant, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_C3IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_C3IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                                Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc aConstants, 
                            Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16sc_AC4IRSfs_Ctx(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16sc_AC4IRSfs(@Const Npp16sc aConstants, Npp16sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s") int nConstant, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstant, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstant, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstant, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed integer channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs_Ctx(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C1IRSfs(@Cast("const Npp32s") int nConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstant, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstant, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstant, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                              @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                              @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                              @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer aConstants, 
                          @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer aConstants, 
                          @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] aConstants, 
                          @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pConstants, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pConstants, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pConstants, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit signed integer channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer aConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer aConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiDivC_32s_C3IRSfs(@Cast("const Npp32s*") int[] aConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image divided by constant, scale, then clamp to saturated value.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pConstants, @Cast("Npp32s*") IntPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pConstants, @Cast("Npp32s*") IntBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pConstants, @Cast("Npp32s*") int[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const @ByVal Npp32sc nConstant, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image divided by constant, scale, then clamp to saturated value.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_C1IRSfs_Ctx(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_C1IRSfs(@Const @ByVal Npp32sc nConstant, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_C3IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_C3IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha image divided by constant, scale, then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                                Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc aConstants, 
                            Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed complex integer (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image divided by constant, scale, then clamp to saturated value.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32sc_AC4IRSfs_Ctx(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32sc_AC4IRSfs(@Const Npp32sc aConstants, Npp32sc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit floating point channel in place image divided by constant.
 * @param nConstant host memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C1IR(@Cast("const Npp32f") float nConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image divided by constant.
 * @param pConstant device memory 32-bit floating point constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 16-bit floating point channel in place image divided by constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C3IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image divided by constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 16-bit floating point channel in place image divided by constant.
 * @param aConstants fixed size host memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_16f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_16f_C4IR(@Cast("const Npp32f*") float[] aConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image divided by constant.
 * @param pConstants fixed size device memory array of 32-bit floating point constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_16f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, Npp16f pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f") float nConstant, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstant, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstant, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstant, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel in place image divided by constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C1IR_Ctx(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C1IR(@Cast("const Npp32f") float nConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image divided by constant.
 * @param pConstant device memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstant, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstant, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pConstant, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Three 32-bit floating point channel in place image divided by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C3IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C3IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C3IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image divided by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                            @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                            @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                            @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                        @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                        @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                        @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                  @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                  @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                  @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image divided by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_AC4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image divided by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer aConstants, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer aConstants, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] aConstants, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pConstants, 
                                 @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pConstants, 
                                 @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pConstants, 
                                 @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * Four 32-bit floating point channel in place image divided by constant.
 * @param aConstants fixed size host memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32f_C4IR(@Cast("const Npp32f*") FloatPointer aConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C4IR(@Cast("const Npp32f*") FloatBuffer aConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiDivC_32f_C4IR(@Cast("const Npp32f*") float[] aConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image divided by constant.
 * @param pConstants fixed size device memory array of constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pConstants, @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pConstants, @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiDivDeviceC_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pConstants, @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const @ByVal Npp32fc nConstant, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image divided by constant.
 * @param nConstant host memory constant.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C1IR_Ctx(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C1IR(@Const @ByVal Npp32fc nConstant, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image divided by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C3IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C3IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                             Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                         Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel with unmodified alpha in place image divided by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_AC4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_AC4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel image divided by constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc aConstants, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit complex floating point (32-bit floating point real, 32-bit floating point imaginary) channel in place image divided by constant.
 * @param aConstants fixed size array of host memory constant values, one per channel.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiDivC_32fc_C4IR_Ctx(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiDivC_32fc_C4IR(@Const Npp32fc aConstants, Npp32fc pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_divc */ 

/** 
 * \defgroup image_absdiffc AbsDiffC
 *
 * Determines absolute difference between each pixel of an image and a constant value. 
 *  
 * Note: If you use one of the device constant versions of these functions and the function called immediately preceeding that 
 * function generates that device constant you MUST either call cudaStreamSynchronize() or cudaDeviceSynchronize() before calling 
 * the device constant function. 
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_8u_C1R(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u") byte nConstant);

/** 
 * One 8-bit unsigned char channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u*") BytePointer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u*") ByteBuffer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp8u*") byte[] pConstant, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 16-bit unsigned short channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortPointer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("Npp16u*") short[] pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortPointer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_16u_C1R(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("Npp16u*") short[] pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u") short nConstant);

/** 
 * One 16-bit unsigned short channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortPointer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortPointer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u*") ShortBuffer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("Npp16u*") short[] pDst, int nDstStep,  @ByVal NppiSize oSizeROI, @Cast("Npp16u*") short[] pConstant, @ByVal NppStreamContext nppStreamCtx);

/** 
 * One 32-bit floating point channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param nConstant host memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant);
public static native @Cast("NppStatus") int nppiAbsDiffC_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nConstant);

/** 
 * One 32-bit floating point channel image absolute difference with constant.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pConstant device memory constant.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatPointer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("Npp32f*") FloatBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") FloatBuffer pConstant, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAbsDiffDeviceC_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("Npp32f*") float[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f*") float[] pConstant, @ByVal NppStreamContext nppStreamCtx);

/** \} image_absdiffc */ 

/** 
 * \defgroup image_add Add
 *
 * Pixel by pixel addition of two images.
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C1IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C3IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_8u_C4IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C1IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C3IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_AC4IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16u_C4IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C1IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C3IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_AC4IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_16s_C4IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                              Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                          Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_C1IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                               Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_C1IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                           Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                              Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                          Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_C3IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                               Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_C3IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                           Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16sc_AC4IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                                Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16sc_AC4IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                            Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/**
 * Note: This function is to be deprecated in future NPP releases, use the function above with a scale factor of 0 instead. 
 * 32-bit image add.
 * Add the pixel values of corresponding pixels in the ROI and write them to the output image.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32s_C1R_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1R_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);                        

public static native @Cast("NppStatus") int nppiAdd_32s_C1R(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") IntPointer pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32s_C1R(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") IntBuffer pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32s_C1R(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") int[] pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI);                        

/** 
 * One 32-bit signed integer channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C1IRSfs(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiAdd_32s_C3IRSfs(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                              Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                          Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_C1IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                               Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_C1IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                           Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                              Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                          Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_C3IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                               Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_C3IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                           Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image addition, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32sc_AC4IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                                Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32sc_AC4IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                            Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C1IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C1IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C3IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C3IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_16f_C4IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_16f_C4IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C1IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C1IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C1IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C3IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C3IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C3IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_AC4IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAdd_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32f_C4IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C4IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAdd_32f_C4IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                           Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                       Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C1IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                            Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C1IR(@Const Npp32fc pSrc,     int nSrcStep, 
                        Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                           Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                       Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C3IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                            Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C3IR(@Const Npp32fc pSrc,     int nSrcStep, 
                        Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_AC4IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                             Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_AC4IR(@Const Npp32fc pSrc,     int nSrcStep, 
                         Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image addition.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                           Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                       Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel in place image addition.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAdd_32fc_C4IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                            Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAdd_32fc_C4IR(@Const Npp32fc pSrc,     int nSrcStep, 
                        Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_add */ 

/** 
 * \defgroup image_addsquare AddSquare
 *
 * Pixel by pixel addition of squared pixels from source image to floating point
 * pixel values of destination image.
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image squared then added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                    @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                    @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                    @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IMR(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 8-bit unsigned char channel image squared then added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_8u32f_C1IR(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel image squared then added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                     @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                     @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                     @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                 @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                 @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IMR(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                 @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel image squared then added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                                    @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                                    @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                                    @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                                @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                                @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_16u32f_C1IR(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                                @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image squared then added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                  @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                  @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                  @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                              @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                              @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IMR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                              @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image squared then added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                             @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddSquare_32f_C1IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                             @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_addsquare */ 

/** 
 * \defgroup image_addproduct AddProduct
 * Pixel by pixel addition of product of pixels from two source images to
 * floating point pixel values of destination image.
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image product added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                               @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                               @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") byte[] pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                               @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR(@Cast("const Npp8u*") BytePointer pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                           @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR(@Cast("const Npp8u*") ByteBuffer pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                           @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IMR(@Cast("const Npp8u*") byte[] pSrc1,  int nSrc1Step,    @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                           @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,    int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 8-bit unsigned char channel image product added to in place floating point destination image.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR_Ctx(@Cast("const Npp8u*") BytePointer pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                    @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                    @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR_Ctx(@Cast("const Npp8u*") byte[] pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                    @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR(@Cast("const Npp8u*") BytePointer pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step,
                                @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR(@Cast("const Npp8u*") ByteBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step,
                                @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_8u32f_C1IR(@Cast("const Npp8u*") byte[] pSrc1,    int nSrc1Step,   @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step,
                                @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel image product added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step,    @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                            @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step,    @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                            @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IMR(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step,    @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                            @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit unsigned short channel image product added to in place floating point destination image.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                     @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                     @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR_Ctx(@Cast("const Npp16u*") short[] pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                     @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR(@Cast("const Npp16u*") ShortPointer pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step,
                                 @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR(@Cast("const Npp16u*") ShortBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step,
                                 @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_16u32f_C1IR(@Cast("const Npp16u*") short[] pSrc1,    int nSrc1Step,   @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step,
                                 @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image product added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                             @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                             @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                             @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step,    @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                         @Cast("const Npp8u*") BytePointer pMask, int nMaskStep,    @Cast("Npp32f*") FloatPointer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step,    @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                         @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep,    @Cast("Npp32f*") FloatBuffer pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IMR(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step,    @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                         @Cast("const Npp8u*") byte[] pMask, int nMaskStep,    @Cast("Npp32f*") float[] pSrcDst,     int nSrcDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image product added to in place floating point destination image.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                                  @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                                  @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                                  @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR(@Cast("const Npp32f*") FloatPointer pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step,
                              @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR(@Cast("const Npp32f*") FloatBuffer pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step,
                              @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiAddProduct_32f_C1IR(@Cast("const Npp32f*") float[] pSrc1,    int nSrc1Step,   @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step,
                              @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel image product added to in place floating point destination image.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddProduct_16f_C1IR_Ctx(@Const Npp16f pSrc1,    int nSrc1Step,   @Const Npp16f pSrc2, int nSrc2Step,
                                  Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddProduct_16f_C1IR(@Const Npp16f pSrc1,    int nSrc1Step,   @Const Npp16f pSrc2, int nSrc2Step,
                              Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** \} image_addproduct */ 

/** 
 * \defgroup image_addweighted AddWeighted
 * Pixel by pixel addition of alpha weighted pixel values from a source image to
 * floating point pixel values of destination image.
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel alpha weighted image added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                      @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                      @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                      @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                  @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                  @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IMR(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                  @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);

/** 
 * One 8-bit unsigned char channel alpha weighted image added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                                     @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                                     @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                                     @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") FloatPointer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") FloatBuffer pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_8u32f_C1IR(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                                 @Cast("Npp32f*") float[] pSrcDst, int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);

/** 
 * One 16-bit unsigned short channel alpha weighted image added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep,     @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                   @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep,     @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                   @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IMR(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep,     @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                   @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep,  @ByVal NppiSize oSizeROI,   @Cast("Npp32f") float nAlpha);

/** 
 * One 16-bit unsigned short channel alpha weighted image added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                                      @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_16u32f_C1IR(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                                  @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);

/** 
 * One 32-bit floating point channel alpha weighted image added to in place floating point destination image using filter mask (updates destination when mask is non-zero).
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pMask \ref mask_image_pointer.
 * @param nMaskStep \ref mask_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                    @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                    @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                    @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, @Cast("const Npp8u*") BytePointer pMask, int nMaskStep, 
                                @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, @Cast("const Npp8u*") ByteBuffer pMask, int nMaskStep, 
                                @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IMR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, @Cast("const Npp8u*") byte[] pMask, int nMaskStep, 
                                @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);

/** 
 * One 32-bit floating point channel alpha weighted image added to in place floating point destination image.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nAlpha Alpha weight to be applied to source image pixels (0.0F to 1.0F)
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                                   @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);
public static native @Cast("NppStatus") int nppiAddWeighted_32f_C1IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                               @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @Cast("Npp32f") float nAlpha);

/** \} image_addweighted */ 

/** 
 * \defgroup image_mul Mul
 *
 * Pixel by pixel multiply of two images.
 *
 * \{
 */

/** 
 * One 8-bit unsigned char channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C1RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 8-bit unsigned char channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C1IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C3RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 8-bit unsigned char channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C3IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                             @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_AC4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                         @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel with unmodified alpha in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                              @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_AC4IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                          @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                            @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs(@Cast("const Npp8u*") BytePointer pSrc1, int nSrc1Step, @Cast("const Npp8u*") BytePointer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") BytePointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs(@Cast("const Npp8u*") ByteBuffer pSrc1, int nSrc1Step, @Cast("const Npp8u*") ByteBuffer pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") ByteBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C4RSfs(@Cast("const Npp8u*") byte[] pSrc1, int nSrc1Step, @Cast("const Npp8u*") byte[] pSrc2, int nSrc2Step, 
                        @Cast("Npp8u*") byte[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 8-bit unsigned char channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs_Ctx(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                             @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs(@Cast("const Npp8u*") BytePointer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") BytePointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs(@Cast("const Npp8u*") ByteBuffer pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") ByteBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_8u_C4IRSfs(@Cast("const Npp8u*") byte[] pSrc,     int nSrcStep, 
                         @Cast("Npp8u*") byte[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit unsigned short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C1RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit unsigned short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C1IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C3RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit unsigned short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C3IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                              @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_AC4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                          @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel with unmodified alpha in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                               @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_AC4IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                           @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs_Ctx(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs(@Cast("const Npp16u*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs(@Cast("const Npp16u*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16u*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C4RSfs(@Cast("const Npp16u*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16u*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16u*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit unsigned short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs_Ctx(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs(@Cast("const Npp16u*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs(@Cast("const Npp16u*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16u_C4IRSfs(@Cast("const Npp16u*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16u*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C1RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit signed short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C1IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C3RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit signed short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C3IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                              @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_AC4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                          @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short channel with unmodified alpha in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                               @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_AC4IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                           @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs_Ctx(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                             @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs(@Cast("const Npp16s*") ShortPointer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs(@Cast("const Npp16s*") ShortBuffer pSrc1, int nSrc1Step, @Cast("const Npp16s*") ShortBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") ShortBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C4RSfs(@Cast("const Npp16s*") short[] pSrc1, int nSrc1Step, @Cast("const Npp16s*") short[] pSrc2, int nSrc2Step, 
                         @Cast("Npp16s*") short[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs_Ctx(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                              @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs(@Cast("const Npp16s*") ShortPointer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs(@Cast("const Npp16s*") ShortBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") ShortBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_16s_C4IRSfs(@Cast("const Npp16s*") short[] pSrc,     int nSrcStep, 
                          @Cast("Npp16s*") short[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_C1RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                              Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_C1RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                          Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_C1IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                               Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_C1IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                           Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_C3RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                              Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_C3RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                          Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_C3IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                               Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_C3IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                           Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_AC4RSfs_Ctx(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                               Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_AC4RSfs(@Const Npp16sc pSrc1, int nSrc1Step, @Const Npp16sc pSrc2, int nSrc2Step, 
                           Npp16sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 16-bit signed short complex number (16-bit real, 16-bit imaginary) channel with unmodified alpha in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16sc_AC4IRSfs_Ctx(@Const Npp16sc pSrc,     int nSrcStep, 
                                Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16sc_AC4IRSfs(@Const Npp16sc pSrc,     int nSrcStep, 
                            Npp16sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C1RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Note: This function is to be deprecated in future NPP releases, use the function above with a scale factor of 0 instead.
 * 1 channel 32-bit image multiplication.
 * Multiply corresponding pixels in ROI. 
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32s_C1R_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") IntPointer pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") IntBuffer pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1R_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, 
                              @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                                    @Cast("Npp32s*") int[] pDst,  int nDstStep, 
                                    @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx); 

public static native @Cast("NppStatus") int nppiMul_32s_C1R(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") IntPointer pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32s_C1R(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") IntBuffer pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32s_C1R(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, 
                          @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                                @Cast("Npp32s*") int[] pDst,  int nDstStep, 
                                @ByVal NppiSize oSizeROI); 

/** 
 * One 32-bit signed integer channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs_Ctx(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C1IRSfs(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs_Ctx(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                             @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs(@Cast("const Npp32s*") IntPointer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntPointer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs(@Cast("const Npp32s*") IntBuffer pSrc1, int nSrc1Step, @Cast("const Npp32s*") IntBuffer pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") IntBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C3RSfs(@Cast("const Npp32s*") int[] pSrc1, int nSrc1Step, @Cast("const Npp32s*") int[] pSrc2, int nSrc2Step, 
                         @Cast("Npp32s*") int[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 32-bit signed integer channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs_Ctx(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                              @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs(@Cast("const Npp32s*") IntPointer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs(@Cast("const Npp32s*") IntBuffer pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") IntBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);
public static native @Cast("NppStatus") int nppiMul_32s_C3IRSfs(@Cast("const Npp32s*") int[] pSrc,     int nSrcStep, 
                          @Cast("Npp32s*") int[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_C1RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                              Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_C1RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                          Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * One 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_C1IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                               Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_C1IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                           Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Three 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_C3RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                              Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_C3RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                          Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Three 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_C3IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                               Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_C3IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                           Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * Four 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_AC4RSfs_Ctx(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                               Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_AC4RSfs(@Const Npp32sc pSrc1, int nSrc1Step, @Const Npp32sc pSrc2, int nSrc2Step, 
                           Npp32sc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI,   int nScaleFactor);

/** 
 * Four 32-bit signed integer complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image multiplication, scale by 2^(-nScaleFactor), then clamp to saturated value.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nScaleFactor \ref integer_result_scaling.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32sc_AC4IRSfs_Ctx(@Const Npp32sc pSrc,     int nSrcStep, 
                                Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32sc_AC4IRSfs(@Const Npp32sc pSrc,     int nSrcStep, 
                            Npp32sc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, int nScaleFactor);

/** 
 * One 16-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C1R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C1R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 16-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C1IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C1IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C3R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C3R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 16-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C3IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C3IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C4R_Ctx(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                          Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C4R(@Const Npp16f pSrc1, int nSrc1Step, @Const Npp16f pSrc2, int nSrc2Step, 
                      Npp16f pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 16-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_16f_C4IR_Ctx(@Const Npp16f pSrc,     int nSrcStep, 
                           Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_16f_C4IR(@Const Npp16f pSrc,     int nSrcStep, 
                       Npp16f pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C1R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C1IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C1IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C1IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C1IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C1IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C3R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C3IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C3IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C3IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C3IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C3IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                           @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_AC4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                       @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel with unmodified alpha in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_AC4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_AC4IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                            @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_AC4IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_AC4IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_AC4IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                        @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                          @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatPointer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatPointer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc1, int nSrc1Step, @Cast("const Npp32f*") FloatBuffer pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") FloatBuffer pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C4R(@Cast("const Npp32f*") float[] pSrc1, int nSrc1Step, @Cast("const Npp32f*") float[] pSrc2, int nSrc2Step, 
                      @Cast("Npp32f*") float[] pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C4IR_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiMul_32f_C4IR_Ctx(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                           @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32f_C4IR(@Cast("const Npp32f*") FloatPointer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatPointer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C4IR(@Cast("const Npp32f*") FloatBuffer pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") FloatBuffer pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);
public static native @Cast("NppStatus") int nppiMul_32f_C4IR(@Cast("const Npp32f*") float[] pSrc,     int nSrcStep, 
                       @Cast("Npp32f*") float[] pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_C1R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                           Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_C1R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                       Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * One 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_C1IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                            Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_C1IR(@Const Npp32fc pSrc,     int nSrcStep, 
                        Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_C3R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                           Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_C3R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                       Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Three 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_C3IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                            Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_C3IR(@Const Npp32fc pSrc,     int nSrcStep, 
                        Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step \ref source_image_line_step.
 * @param pSrc2 \ref source_image_pointer.
 * @param nSrc2Step \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_AC4R_Ctx(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                            Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_AC4R(@Const Npp32fc pSrc1, int nSrc1Step, @Const Npp32fc pSrc2, int nSrc2Step, 
                        Npp32fc pDst,  int nDstStep,  @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel with unmodified alpha in place image multiplication.
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pSrcDst \ref in_place_image_pointer.
 * @param nSrcDstStep \ref in_place_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiMul_32fc_AC4IR_Ctx(@Const Npp32fc pSrc,     int nSrcStep, 
                             Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiMul_32fc_AC4IR(@Const Npp32fc pSrc,     int nSrcStep, 
                         Npp32fc pSrcDst,  int nSrcDstStep, @ByVal NppiSize oSizeROI);

/** 
 * Four 32-bit floating point complex number (32-bit real, 32-bit imaginary) channel image multiplication.
 * @param pSrc1 \ref source_image_pointer.
 * @param nSrc1Step 