// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;


/**
 * Memory allocation information for a device (v2).
 *
 * Version 2 adds versioning for the struct and the amount of system-reserved memory as an output.
 * \note The \ref nvmlMemory_v2_t.used amount also includes the \ref nvmlMemory_v2_t.reserved amount.
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlMemory_v2_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlMemory_v2_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlMemory_v2_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlMemory_v2_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlMemory_v2_t position(long position) {
        return (nvmlMemory_v2_t)super.position(position);
    }
    @Override public nvmlMemory_v2_t getPointer(long i) {
        return new nvmlMemory_v2_t((Pointer)this).offsetAddress(i);
    }

    /** Structure format version (must be 2) */
    public native @Cast("unsigned int") int version(); public native nvmlMemory_v2_t version(int setter);
    /** Total physical device memory (in bytes) */
    public native @Cast("unsigned long long") long total(); public native nvmlMemory_v2_t total(long setter);
    /** Device memory (in bytes) reserved for system use (driver or firmware) */
    public native @Cast("unsigned long long") long reserved(); public native nvmlMemory_v2_t reserved(long setter);
    /** Unallocated device memory (in bytes) */
    public native @Cast("unsigned long long") @Name("free") long _free(); public native nvmlMemory_v2_t _free(long setter);
    /** Allocated device memory (in bytes). Note that the driver/GPU always sets aside a small amount of memory for bookkeeping */
    public native @Cast("unsigned long long") long used(); public native nvmlMemory_v2_t used(long setter);
}
