// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;

// #endif /* defined(__GNUC__) */

/**
 * \ingroup CUDA_MATH_INTRINSIC_BFLOAT16
 * \brief nv_bfloat16 datatype 
 * 
 * \details This structure implements the datatype for storing 
 * nv_bfloat16 floating-point numbers. The structure implements 
 * assignment operators and type conversions. 16 bits are being 
 * used in total: 1 sign bit, 8 bits for the exponent, and 
 * the significand is being stored in 7 bits. The total 
 * precision is 8 bits.
 * 
 */
@NoOffset @Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class __nv_bfloat16 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public __nv_bfloat16(Pointer p) { super(p); }


    /**
     * Constructor by default.
     */
// #if defined(__CPP_VERSION_AT_LEAST_11_BF16)
    public __nv_bfloat16() { super((Pointer)null); allocate(); }
    private native void allocate();
// #else
// #endif /* defined(__CPP_VERSION_AT_LEAST_11_BF16) */

    /* Convert to/from __nv_bfloat16_raw */
    /**
     * Constructor from \p __nv_bfloat16_raw.
     */
    public __nv_bfloat16(@Const @ByRef __nv_bfloat16_raw hr) { super((Pointer)null); allocate(hr); }
    private native void allocate(@Const @ByRef __nv_bfloat16_raw hr);
    /**
     * Assignment operator from \p __nv_bfloat16_raw.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(@Const @ByRef __nv_bfloat16_raw hr);
    /**
     * Assignment operator from \p __nv_bfloat16_raw to \p volatile \p __nv_bfloat16.
     */
    /**
     * Assignment operator from \p volatile \p __nv_bfloat16_raw to \p volatile \p __nv_bfloat16.
     */
    /**
     * Type cast to \p __nv_bfloat16_raw operator.
     */
    public native @ByVal @Name("operator __nv_bfloat16_raw") __nv_bfloat16_raw as__nv_bfloat16_raw();
    /**
     * Type cast to \p __nv_bfloat16_raw operator with \p volatile input.
     */

// #if !defined(__CUDA_NO_BFLOAT16_CONVERSIONS__)
// #if defined(__CPP_VERSION_AT_LEAST_11_BF16)
    /**
     * Construct \p __nv_bfloat16 from \p __half input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(@Const @ByVal __half f) { super((Pointer)null); allocate(f); }
    private native void allocate(@Const @ByVal __half f);
// #endif /* #if defined(__CPP_VERSION_AT_LEAST_11_BF16) */

    /* Construct from float/double */
    /**
     * Construct \p __nv_bfloat16 from \p float input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(float f) { super((Pointer)null); allocate(f); }
    private native void allocate(float f);
    /**
     * Construct \p __nv_bfloat16 from \p double input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(double f) { super((Pointer)null); allocate(f); }
    private native void allocate(double f);
    /**
     * Type cast to \p float operator.
     */
    public native @Name("operator float") float asFloat();
    /**
     * Type cast to \p __nv_bfloat16 assignment operator from \p float input using default round-to-nearest-even rounding mode.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(float f);

    /* We omit "cast to double" operator, so as to not be ambiguous about up-cast */
    /**
     * Type cast to \p __nv_bfloat16 assignment operator from \p double input using default round-to-nearest-even rounding mode.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(double f);

/*
 * Implicit type conversions to/from integer types were only available to nvcc compilation.
 * Introducing them for all compilers is a potentially breaking change that may affect
 * overloads resolution and will require users to update their code.
 * Define __CUDA_BF16_DISABLE_IMPLICIT_INTEGER_CONVERTS_FOR_HOST_COMPILERS__ to opt-out.
 */
// #if !(defined __CUDA_BF16_DISABLE_IMPLICIT_INTEGER_CONVERTS_FOR_HOST_COMPILERS__) || (defined __CUDACC__)
    /* Allow automatic construction from types supported natively in hardware */
    /* Note we do avoid constructor init-list because of special host/device compilation rules */

    /**
     * Construct \p __nv_bfloat16 from \p short integer input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(short val) { super((Pointer)null); allocate(val); }
    private native void allocate(short val);
    /**
     * Construct \p __nv_bfloat16 from \p unsigned \p short integer input using default round-to-nearest-even rounding mode.
     */
    /**
     * Construct \p __nv_bfloat16 from \p int input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(int val) { super((Pointer)null); allocate(val); }
    private native void allocate(int val);
    /**
     * Construct \p __nv_bfloat16 from \p unsigned \p int input using default round-to-nearest-even rounding mode.
     */
    /**
     * Construct \p __nv_bfloat16 from \p long input using default round-to-nearest-even rounding mode.
     */
    public __nv_bfloat16(long val) { super((Pointer)null); allocate(val); }
    private native void allocate(long val);

    /**
     * Construct \p __nv_bfloat16 from \p unsigned \p long input using default round-to-nearest-even rounding mode.
     */
    /**
     * Construct \p __nv_bfloat16 from \p long \p long input using default round-to-nearest-even rounding mode.
     */
    /**
     * Construct \p __nv_bfloat16 from \p unsigned \p long \p long input using default round-to-nearest-even rounding mode.
     */

    /* Allow automatic casts to supported builtin types, matching all that are permitted with float */

    /**
     * Conversion operator to \p signed \p char data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162char_rz(__nv_bfloat16) for further details
     */
    public native @Name("operator signed char") byte asByte();
    /**
     * Conversion operator to \p unsigned \p char data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162uchar_rz(__nv_bfloat16) for further details
     */
    /**
     * Conversion operator to an implementation defined \p char data type.
     * Using round-toward-zero rounding mode.
     * 
     * Detects signedness of the \p char type and proceeds accordingly, see
     * further details in signed and unsigned char operators.
     */
    /**
     * Conversion operator to \p short data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162short_rz(__nv_bfloat16) for further details
     */
    public native @Name("operator short") short asShort();
    /**
     * Conversion operator to \p unsigned \p short data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162ushort_rz(__nv_bfloat16) for further details
     */
    /**
     * Conversion operator to \p int data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162int_rz(__nv_bfloat16) for further details
     */
    public native @Name("operator int") int asInt();
    /**
     * Conversion operator to \p unsigned \p int data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162uint_rz(__nv_bfloat16) for further details
     */
    /**
     * Conversion operator to \p long data type.
     * Using round-toward-zero rounding mode.
     */
    public native @Name("operator long") long asLong();
    /**
     * Conversion operator to \p unsigned \p long data type.
     * Using round-toward-zero rounding mode.
     */
    /**
     * Conversion operator to \p long \p long data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162ll_rz(__nv_bfloat16) for further details
     */
    /**
     * Conversion operator to \p unsigned \p long \p long data type.
     * Using round-toward-zero rounding mode.
     * 
     * See __bfloat162ull_rz(__nv_bfloat16) for further details
     */
    /**
     * Type cast from \p short assignment operator, using default round-to-nearest-even rounding mode.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(short val);
    /**
     * Type cast from \p unsigned \p short assignment operator, using default round-to-nearest-even rounding mode.
     */
    /**
     * Type cast from \p int assignment operator, using default round-to-nearest-even rounding mode.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(int val);
   /**
     * Type cast from \p unsigned \p int assignment operator, using default round-to-nearest-even rounding mode.
     */
    /**
     * Type cast from \p long \p long assignment operator, using default round-to-nearest-even rounding mode.
     */
    public native @ByRef @Name("operator =") __nv_bfloat16 put(long val);
    /**
     * Type cast from \p unsigned \p long \p long assignment operator, using default round-to-nearest-even rounding mode.
     */
    /**
     * Conversion operator to \p bool data type.
     * +0 and -0 inputs convert to \p false.
     * Non-zero inputs convert to \p true.
     */
    public native @Cast("bool") @Name("operator bool") boolean asBoolean();
// #endif /* !(defined __CUDA_BF16_DISABLE_IMPLICIT_INTEGER_CONVERTS_FOR_HOST_COMPILERS__) || (defined __CUDACC__) */
// #endif /* !defined(__CUDA_NO_BFLOAT16_CONVERSIONS__) */
}
