// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * CUDA conditional node parameters
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaConditionalNodeParams extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaConditionalNodeParams() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaConditionalNodeParams(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaConditionalNodeParams(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaConditionalNodeParams position(long position) {
        return (cudaConditionalNodeParams)super.position(position);
    }
    @Override public cudaConditionalNodeParams getPointer(long i) {
        return new cudaConditionalNodeParams((Pointer)this).offsetAddress(i);
    }

    /** Conditional node handle.
                                                      Handles must be created in advance of creating the node
                                                      using ::cudaGraphConditionalHandleCreate. */
    public native @Cast("cudaGraphConditionalHandle") long handle(); public native cudaConditionalNodeParams handle(long setter);
    /** Type of conditional node. */
    public native @Cast("cudaGraphConditionalNodeType") int type(); public native cudaConditionalNodeParams type(int setter);
    /** Size of graph output array.  Must be 1 for WHILE nodes, 1 or 2 for IF nodes, and >0 for SWITCH nodes. */
    public native @Cast("unsigned int") int size(); public native cudaConditionalNodeParams size(int setter);
    /** CUDA-owned array populated with conditional node child graphs during creation of the node.
                                                      Valid for the lifetime of the conditional node.
                                                      The contents of the graph(s) are subject to the following constraints:
                                                      
                                                      - Allowed node types are kernel nodes, empty nodes, child graphs, memsets,
                                                        memcopies, and conditionals. This applies recursively to child graphs and conditional bodies.
                                                      - All kernels, including kernels in nested conditionals or child graphs at any level,
                                                        must belong to the same CUDA context.
                                                      
                                                      These graphs may be populated using graph node creation APIs or ::cudaStreamBeginCaptureToGraph. */
    public native @ByPtrPtr CUgraph_st phGraph_out(); public native cudaConditionalNodeParams phGraph_out(CUgraph_st setter);
}
