// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Optional annotation for edges in a CUDA graph. Note, all edges implicitly have annotations and
 * default to a zero-initialized value if not specified. A zero-initialized struct indicates a
 * standard full serialization of two nodes with memory visibility.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaGraphEdgeData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaGraphEdgeData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaGraphEdgeData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaGraphEdgeData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaGraphEdgeData position(long position) {
        return (cudaGraphEdgeData)super.position(position);
    }
    @Override public cudaGraphEdgeData getPointer(long i) {
        return new cudaGraphEdgeData((Pointer)this).offsetAddress(i);
    }

    /** This indicates when the dependency is triggered from the upstream
                                      node on the edge. The meaning is specfic to the node type. A value
                                      of 0 in all cases means full completion of the upstream node, with
                                      memory visibility to the downstream node or portion thereof
                                      (indicated by \c to_port).
                                      <br>
                                      Only kernel nodes define non-zero ports. A kernel node
                                      can use the following output port types:
                                      ::cudaGraphKernelNodePortDefault, ::cudaGraphKernelNodePortProgrammatic,
                                      or ::cudaGraphKernelNodePortLaunchCompletion. */
    public native @Cast("unsigned char") byte from_port(); public native cudaGraphEdgeData from_port(byte setter);
    /** This indicates what portion of the downstream node is dependent on
                                    the upstream node or portion thereof (indicated by \c from_port). The
                                    meaning is specific to the node type. A value of 0 in all cases means
                                    the entirety of the downstream node is dependent on the upstream work.
                                    <br>
                                    Currently no node types define non-zero ports. Accordingly, this field
                                    must be set to zero. */
    public native @Cast("unsigned char") byte to_port(); public native cudaGraphEdgeData to_port(byte setter);
    /** This should be populated with a value from ::cudaGraphDependencyType. (It
                                 is typed as char due to compiler-specific layout of bitfields.) See
                                 ::cudaGraphDependencyType. */
    public native @Cast("unsigned char") byte type(); public native cudaGraphEdgeData type(byte setter);
    /** These bytes are unused and must be zeroed. This ensures
                                        compatibility if additional fields are added in the future. */
    public native @Cast("unsigned char") byte reserved(int i); public native cudaGraphEdgeData reserved(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer reserved();
}
