// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * CUDA Memset node parameters
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaMemsetParamsV2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaMemsetParamsV2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaMemsetParamsV2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaMemsetParamsV2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaMemsetParamsV2 position(long position) {
        return (cudaMemsetParamsV2)super.position(position);
    }
    @Override public cudaMemsetParamsV2 getPointer(long i) {
        return new cudaMemsetParamsV2((Pointer)this).offsetAddress(i);
    }

    /** Destination device pointer */
    public native Pointer dst(); public native cudaMemsetParamsV2 dst(Pointer setter);
    /** Pitch of destination device pointer. Unused if height is 1 */
    public native @Cast("size_t") long pitch(); public native cudaMemsetParamsV2 pitch(long setter);
    /** Value to be set */
    public native @Cast("unsigned int") int value(); public native cudaMemsetParamsV2 value(int setter);
    /** Size of each element in bytes. Must be 1, 2, or 4. */
    public native @Cast("unsigned int") int elementSize(); public native cudaMemsetParamsV2 elementSize(int setter);
    /** Width of the row in elements */
    public native @Cast("size_t") long width(); public native cudaMemsetParamsV2 width(long setter);
    /** Number of rows */
    public native @Cast("size_t") long height(); public native cudaMemsetParamsV2 height(long setter);
}
