// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.nvToolsExt.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class nvToolsExt extends org.bytedeco.cuda.presets.nvToolsExt {
    static { Loader.load(); }

// Parsed from <nvToolsExt.h>

/*
* Copyright 2009-2017  NVIDIA Corporation.  All rights reserved.
*
* NOTICE TO USER:
*
* This source code is subject to NVIDIA ownership rights under U.S. and
* international Copyright laws.
*
* This software and the information contained herein is PROPRIETARY and
* CONFIDENTIAL to NVIDIA and is being provided under the terms and conditions
* of a form of NVIDIA software license agreement.
*
* NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
* CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
* IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
* REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
* IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
* OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
* OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
* OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
* OR PERFORMANCE OF THIS SOURCE CODE.
*
* U.S. Government End Users.   This source code is a "commercial item" as
* that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
* "commercial computer  software"  and "commercial computer software
* documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
* and is provided to the U.S. Government only as a commercial end item.
* Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
* 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
* source code with only those rights set forth herein.
*
* Any use of this source code in individual and commercial software must
* include, in the user documentation and internal comments to the code,
* the above Disclaimer and U.S. Government End Users Notice.
*/

/** \file nvToolsExt.h
 */

/* ========================================================================= */
/** \mainpage
 * \tableofcontents
 * \section INTRODUCTION Introduction
 *
 * The NVIDIA Tools Extension library is a set of functions that a
 * developer can use to provide additional information to tools.
 * The additional information is used by the tool to improve
 * analysis and visualization of data.
 *
 * The library introduces close to zero overhead if no tool is
 * attached to the application.  The overhead when a tool is
 * attached is specific to the tool.
 *
 * \section INITIALIZATION_SECTION Initialization
 *
 * Typically the tool's library that plugs into NVTX is indirectly 
 * loaded via enviromental properties that are platform specific. 
 * For some platform or special cases, the user may be required 
 * to instead explicity initialize instead though.   This can also
 * be helpful to control when the API loads a tool's library instead
 * of what would typically be the first function call to emit info.
 * For these rare case, see \ref INITIALIZATION for additional information.
 *
 * \section MARKERS_AND_RANGES Markers and Ranges
 *
 * Markers and ranges are used to describe events at a specific time (markers)
 * or over a time span (ranges) during the execution of the application
 * respectively. 
 *
 * \subsection MARKERS Markers
 * 
 * Markers denote specific moments in time.
 * 
 * 
 * See \ref DOMAINS and \ref EVENT_ATTRIBUTES for additional information on
 * how to specify the domain.
 * 
 * \subsection THREAD_RANGES Thread Ranges
 *
 * Thread ranges denote nested time ranges. Nesting is maintained per thread
 * per domain and does not require any additional correlation mechanism. The
 * duration of a thread range is defined by the corresponding pair of
 * nvtxRangePush* to nvtxRangePop API calls.
 *
 * See \ref DOMAINS and \ref EVENT_ATTRIBUTES for additional information on
 * how to specify the domain.
 *
 * \subsection PROCESS_RANGES Process Ranges
 *
 * Process ranges denote a time span that can expose arbitrary concurrency, as 
 * opposed to thread ranges that only support nesting. In addition the range
 * start event can happen on a different thread than the end marker. For the 
 * correlation of a start/end pair an unique correlation ID is used that is
 * returned from the start API call and needs to be passed into the end API
 * call.
 *
 * \subsection EVENT_ATTRIBUTES Event Attributes
 *
 * \ref MARKERS_AND_RANGES can be annotated with various attributes to provide
 * additional information for an event or to guide the tool's visualization of
 * the data. Each of the attributes is optional and if left unused the
 * attributes fall back to a default value. The attributes include:
 * - color
 * - category
 *
 * To specify any attribute other than the text message, the \ref
 * EVENT_ATTRIBUTE_STRUCTURE "Event Attribute Structure" must be used.
 *
 * \section DOMAINS Domains
 *
 * Domains enable developers to scope annotations. By default all events and
 * annotations are in the default domain. Additional domains can be registered.
 * This allows developers to scope markers, ranges, and resources names to
 * avoid conflicts.
 *
 * The function ::nvtxDomainCreateA or ::nvtxDomainCreateW is used to create
 * a named domain.
 * 
 * Each domain maintains its own
 * - categories
 * - thread range stacks
 * - registered strings
 *
 * The function ::nvtxDomainDestroy marks the end of the domain. Destroying 
 * a domain unregisters and destroys all objects associated with it such as 
 * registered strings, resource objects, named categories, and started ranges. 
 *
 * \section RESOURCE_NAMING Resource Naming
 *
 * This section covers calls that allow to annotate objects with user-provided
 * names in order to allow for a better analysis of complex trace data. All of
 * the functions take the handle or the ID of the object to name and the name.
 * The functions can be called multiple times during the execution of an
 * application, however, in that case it is implementation dependent which
 * name will be reported by the tool.
 * 
 * \subsection CATEGORY_NAMING Category Naming
 *
 * Some function in this library support associating an integer category 
 * to enable filtering and sorting.  The category naming functions allow 
 * the application to associate a user friendly name with the integer 
 * category.  Support for domains have been added in NVTX_VERSION_2 to 
 * avoid collisions when domains are developed independantly. 
 *
 * \subsection RESOURCE_OBJECTS Resource Objects
 *
 * Resource objects are a generic mechanism for attaching data to an application 
 * resource.  The identifier field makes the association to a pointer or handle, 
 * while the type field helps provide deeper understanding of the identifier as 
 * well as enabling differentiation in cases where handles generated by different
 * APIs may collide.  The resource object may also have an associated message to
 * associate with the application resource, enabling further annotation of this 
 * object and how it is used.
 * 
 * The resource object was introduced in NVTX_VERSION_2 to supersede existing naming
 * functions and allow the application resource identified by those functions to be
 * associated to a domain.  The other naming functions are still supported for backward
 * compatibility but will be associated only to the default domain.
 *
 * \subsection RESOURCE_NAMING_OS Resource Naming
 * 
 * Some operating system resources creation APIs do not support providing a user friendly 
 * name, such as some OS thread creation APIs.  This API support resource naming though 
 * both through resource objects and functions following the pattern 
 * nvtxName[RESOURCE_TYPE][A|W](identifier, name).  Resource objects introduced in NVTX_VERSION 2 
 * supersede the other functions with a a more general method of assigning names to OS resources,
 * along with associating them to domains too.  The older nvtxName* functions are only associated 
 * with the default domain.
 * \section EXTENSIONS Optional Extensions
 * Optional extensions will either appear within the existing sections the extend or appear 
 * in the "Related Pages" when they introduce new concepts.
 */

// #ifndef NVTOOLSEXT_H_
// #define NVTOOLSEXT_H_

// #if defined(_MSC_VER)
//     #ifdef NVTX_EXPORTS
//         #define NVTX_DECLSPEC
//     #else
//         #define NVTX_DECLSPEC __declspec(dllimport)
//     #endif /* NVTX_EXPORTS */
//     #define NVTX_API __stdcall
//     #define NVTX_INLINE_STATIC __inline static
// #else /*defined(__GNUC__)*/
//     #define NVTX_DECLSPEC
//     #define NVTX_API
//     #define NVTX_INLINE_STATIC inline static
// #endif /* Platform */

/**
 * The nvToolsExt library depends on stdint.h.  If the build tool chain in use
 * does not include stdint.h then define NVTX_STDINT_TYPES_ALREADY_DEFINED
 * and define the following types:
 * <ul>
 *   <li>uint8_t
 *   <li>int8_t
 *   <li>uint16_t
 *   <li>int16_t
 *   <li>uint32_t
 *   <li>int32_t
 *   <li>uint64_t
 *   <li>int64_t
 *   <li>uintptr_t
 *   <li>intptr_t
 * </ul>
 #define NVTX_STDINT_TYPES_ALREADY_DEFINED if you are using your own header file.
 */
// #ifndef NVTX_STDINT_TYPES_ALREADY_DEFINED
// #include <stdint.h>
// #endif

// #include <stddef.h>

// #ifdef __cplusplus
// #endif /* __cplusplus */

/**
 * Tools Extension API version
 */
public static final int NVTX_VERSION = 2;

/**
 * Size of the nvtxEventAttributes_t structure.
 */
public static native @MemberGetter int NVTX_EVENT_ATTRIB_STRUCT_SIZE();
public static final int NVTX_EVENT_ATTRIB_STRUCT_SIZE = NVTX_EVENT_ATTRIB_STRUCT_SIZE();

/**
 * Size of the nvtxInitializationAttributes_t structure.
 */
public static native @MemberGetter int NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE();
public static final int NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE = NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE();

public static final int NVTX_NO_PUSH_POP_TRACKING = ((int)-2);


/* \brief String Handle Structure.
* \anchor STRING_HANDLE_STRUCTURE
*
* This structure is opaque to the user and is used as a handle to reference
* a string.  The tools will return a pointer through the API for the application
* to hold on it's behalf to reference the string in the future.
*
*/

/* \brief Domain Handle Structure.
* \anchor DOMAIN_HANDLE_STRUCTURE
*
* This structure is opaque to the user and is used as a handle to reference
* a domain.  The tools will return a pointer through the API for the application
* to hold on its behalf to reference the domain in the future.
*
*/






/* ========================================================================= */
/** \defgroup GENERAL General
 * \{
 */

/** ---------------------------------------------------------------------------
 * Color Types
 * ------------------------------------------------------------------------- */
/** enum nvtxColorType_t */
public static final int
    /** Color attribute is unused. */
    NVTX_COLOR_UNKNOWN  = 0,
    /** An ARGB color is provided. */
    NVTX_COLOR_ARGB     = 1;

/** ---------------------------------------------------------------------------
 * Message Types
 * ------------------------------------------------------------------------- */
/** enum nvtxMessageType_t */
public static final int
    /** Message payload is unused. */
    NVTX_MESSAGE_UNKNOWN          = 0,
    /** A character sequence is used as payload. */
    NVTX_MESSAGE_TYPE_ASCII       = 1,
    /** A wide character sequence is used as payload. */
    NVTX_MESSAGE_TYPE_UNICODE     = 2,
    /* NVTX_VERSION_2 */
    /** A unique string handle that was registered
                                                with \ref nvtxDomainRegisterStringA() or 
                                                \ref nvtxDomainRegisterStringW(). */
    NVTX_MESSAGE_TYPE_REGISTERED  = 3;


/** \} */ /*END defgroup*/

/* ========================================================================= */
/** \defgroup INITIALIZATION Initialization
* \{
* Typically the tool's library that plugs into NVTX is indirectly
* loaded via enviromental properties that are platform specific.
* For some platform or special cases, the user may be required
* to instead explicity initialize instead though.  This can also
* be helpful to control when the API loads a tool's library instead
* of what would typically be the first function call to emit info.
*/

/** ---------------------------------------------------------------------------
* Initialization Modes
* ------------------------------------------------------------------------- */
/** enum nvtxInitializationMode_t */
public static final int
    /** A platform that supports indirect initialization will attempt this style, otherwise expect failure. */
    NVTX_INITIALIZATION_MODE_UNKNOWN = 0,
    /** A function pointer conforming to NVTX_VERSION=1 will be used. */
    NVTX_INITIALIZATION_MODE_CALLBACK_V1 = 1,
    /** A function pointer conforming to NVTX_VERSION=2 will be used. */
    NVTX_INITIALIZATION_MODE_CALLBACK_V2 = 2,
    NVTX_INITIALIZATION_MODE_SIZE = 3;


/** \brief Initialization Attribute Structure.
* \anchor INITIALIZATION_ATTRIBUTE_STRUCTURE
*
* This structure is used to describe the attributes used for initialization
* of the NVTX API.
*
* \par Initializing the Attributes
*
* The caller should always perform the following three tasks when using
* attributes:
* <ul>
*    <li>Zero the structure
*    <li>Set the version field
*    <li>Set the size field
* </ul>
*
* Zeroing the structure sets all the event attributes types and values
* to the default value.
*
* The version and size field are used by the Tools Extension
* implementation to handle multiple versions of the attributes structure.
* NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE may be used for the size.
*
* It is recommended that the caller use one of the following to methods
* to initialize the event attributes structure:
*
* \par Method 1: Initializing nvtxInitializationAttributes_t for future compatibility
* <pre>{@code
* nvtxInitializationAttributes_t initAttribs = {0};
* initAttribs.version = NVTX_VERSION;
* initAttribs.size = NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE;
* }</pre>
*
* \par Method 2: Initializing nvtxInitializationAttributes_t for a specific version
* <pre>{@code
* nvtxInitializationAttributes_t initAttribs = {0};
* initAttribs.version =2;
* initAttribs.size = (uint16_t)(sizeof(nvtxInitializationAttributes_v2));
* }</pre>
*
* If the caller uses Method 1 it is critical that the entire binary
* layout of the structure be configured to 0 so that all fields
* are initialized to the default value.
*
* The caller should either use both NVTX_VERSION and
* NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE (Method 1) or use explicit values
* and a versioned type (Method 2).  Using a mix of the two methods
* will likely cause either source level incompatibility or binary
* incompatibility in the future.
*
* \par Settings Attribute Types and Values
*
*
* \par Example:
* <pre>{@code
* // Initialize
* nvtxInitializationAttributes_t initAttribs = {0};
* initAttribs.version = NVTX_VERSION;
* initAttribs.size = NVTX_INITIALIZATION_ATTRIB_STRUCT_SIZE;
*
* // Configure the Attributes
* initAttribs.mode = NVTX_INITIALIZATION_MODE_CALLBACK_V2;
* initAttribs.fnptr = InitializeInjectionNvtx2;
* }</pre>
<p>
* @see
* ::nvtxInitializationMode_t
* ::nvtxInitialize
*/


/* ------------------------------------------------------------------------- */
/** \brief Force initialization (optional on most platforms)
*
* Force NVTX library to initialize.  On some platform NVTX will implicit initialize
* upon the first function call into an NVTX API.
*
* @return Result codes are simplest to assume NVTX_SUCCESS or !NVTX_SUCCESS
*
* @param initAttrib - The initialization attribute structure
*
* @see
* ::nvtxInitializationAttributes_t
*
* @version \NVTX_VERSION_2
* \{ */
public static native int nvtxInitialize(@Cast("const nvtxInitializationAttributes_t*") Pointer initAttrib);
/** \} */


/** \} */ /*END defgroup*/

/* ========================================================================= */
/** \defgroup EVENT_ATTRIBUTES Event Attributes
* \{
*/

/** ---------------------------------------------------------------------------
* Payload Types
* ------------------------------------------------------------------------- */
/** enum nvtxPayloadType_t */
public static final int
    /** Color payload is unused. */
    NVTX_PAYLOAD_UNKNOWN = 0,
    /** A 64 bit unsigned integer value is used as payload. */
    NVTX_PAYLOAD_TYPE_UNSIGNED_INT64 = 1,
    /** A 64 bit signed integer value is used as payload. */
    NVTX_PAYLOAD_TYPE_INT64 = 2,
    /** A 64 bit floating point value is used as payload. */
    NVTX_PAYLOAD_TYPE_DOUBLE = 3,
    /* NVTX_VERSION_2 */
    /** A 32 bit floating point value is used as payload. */
    NVTX_PAYLOAD_TYPE_UNSIGNED_INT32 = 4,
    /** A 32 bit floating point value is used as payload. */
    NVTX_PAYLOAD_TYPE_INT32 = 5,
    /** A 32 bit floating point value is used as payload. */
    NVTX_PAYLOAD_TYPE_FLOAT = 6;
// Targeting ../nvToolsExt/nvtxEventAttributes_t.java



/** \} */ /*END defgroup*/
/* ========================================================================= */
/** \defgroup MARKERS_AND_RANGES Markers and Ranges
 *
 * See \ref MARKERS_AND_RANGES for more details
 *
 * \{
 */

/** \name Marker */

/* ------------------------------------------------------------------------- */
/** \brief Marks an instantaneous event in the application.
*
* A marker can contain a text message or specify additional information
* using the event attributes structure.  These attributes include a text
* message, color, category, and a payload. Each of the attributes is optional
* and can only be sent out using the \ref nvtxDomainMarkEx function.
*
* nvtxDomainMarkEx(NULL, event) is equivalent to calling
* nvtxMarkEx(event).
*
* @param domain    - The domain of scoping the category.
* @param eventAttrib - The event attribute structure defining the marker's
* attribute types and attribute values.
*
* @see
* ::nvtxMarkEx
*
* @version \NVTX_VERSION_2
* \{ */
public static native void nvtxDomainMarkEx(@Cast("nvtxDomainHandle_t") Pointer domain, @Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Marks an instantaneous event in the application.
 *
 * A marker can contain a text message or specify additional information
 * using the event attributes structure.  These attributes include a text
 * message, color, category, and a payload. Each of the attributes is optional
 * and can only be sent out using the \ref nvtxMarkEx function.
 * If \ref nvtxMarkA or \ref nvtxMarkW are used to specify the marker
 * or if an attribute is unspecified then a default value will be used.
 *
 * @param eventAttrib - The event attribute structure defining the marker's
 * attribute types and attribute values.
 *
 * \par Example:
 * <pre>{@code
 * // zero the structure
 * nvtxEventAttributes_t eventAttrib = {0};
 * // set the version and the size information
 * eventAttrib.version = NVTX_VERSION;
 * eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
 * // configure the attributes.  0 is the default for all attributes.
 * eventAttrib.colorType = NVTX_COLOR_ARGB;
 * eventAttrib.color = 0xFF880000;
 * eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
 * eventAttrib.message.ascii = "Example nvtxMarkEx";
 * nvtxMarkEx(&eventAttrib);
 * }</pre>
 *
 * @see
 * ::nvtxDomainMarkEx
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxMarkEx(@Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Marks an instantaneous event in the application.
 *
 * A marker created using \ref nvtxMarkA or \ref nvtxMarkW contains only a
 * text message.
 *
 * @param message     - The message associated to this marker event.
 *
 * \par Example:
 * <pre>{@code
 * nvtxMarkA("Example nvtxMarkA");
 * nvtxMarkW(L"Example nvtxMarkW");
 * }</pre>
 *
 * @see
 * ::nvtxDomainMarkEx
 * ::nvtxMarkEx
 *
 * @version \NVTX_VERSION_0
 * \{ */
public static native void nvtxMarkA(@Cast("const char*") BytePointer message);
public static native void nvtxMarkA(String message);
public static native void nvtxMarkW(@Cast("const wchar_t*") CharPointer message);
public static native void nvtxMarkW(@Cast("const wchar_t*") IntPointer message);
/** \} */


/** \name Process Ranges */

/* ------------------------------------------------------------------------- */
/** \brief Starts a process range in a domain.
*
* @param domain    - The domain of scoping the category.
* @param eventAttrib - The event attribute structure defining the range's
* attribute types and attribute values.
*
* @return The unique ID used to correlate a pair of Start and End events.
*
* \remarks Ranges defined by Start/End can overlap.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("my domain");
* nvtxEventAttributes_t eventAttrib = {0};
* eventAttrib.version = NVTX_VERSION;
* eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
* eventAttrib.message.ascii = "my range";
* nvtxRangeId_t rangeId = nvtxDomainRangeStartEx(&eventAttrib);
* // ...
* nvtxDomainRangeEnd(rangeId);
* }</pre>
*
* @see
* ::nvtxDomainRangeEnd
*
* @version \NVTX_VERSION_2
* \{ */
public static native @Cast("nvtxRangeId_t") long nvtxDomainRangeStartEx(@Cast("nvtxDomainHandle_t") Pointer domain, @Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Starts a process range.
 *
 * @param eventAttrib - The event attribute structure defining the range's
 * attribute types and attribute values.
 *
 * @return The unique ID used to correlate a pair of Start and End events.
 *
 * \remarks Ranges defined by Start/End can overlap.
 *
 * \par Example:
 * <pre>{@code
 * nvtxEventAttributes_t eventAttrib = {0};
 * eventAttrib.version = NVTX_VERSION;
 * eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
 * eventAttrib.category = 3;
 * eventAttrib.colorType = NVTX_COLOR_ARGB;
 * eventAttrib.color = 0xFF0088FF;
 * eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
 * eventAttrib.message.ascii = "Example Range";
 * nvtxRangeId_t rangeId = nvtxRangeStartEx(&eventAttrib);
 * // ...
 * nvtxRangeEnd(rangeId);
 * }</pre>
 *
 * @see
 * ::nvtxRangeEnd
 * ::nvtxDomainRangeStartEx
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native @Cast("nvtxRangeId_t") long nvtxRangeStartEx(@Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Starts a process range.
 *
 * @param message     - The event message associated to this range event.
 *
 * @return The unique ID used to correlate a pair of Start and End events.
 *
 * \remarks Ranges defined by Start/End can overlap.
 *
 * \par Example:
 * <pre>{@code
 * nvtxRangeId_t r1 = nvtxRangeStartA("Range 1");
 * nvtxRangeId_t r2 = nvtxRangeStartW(L"Range 2");
 * nvtxRangeEnd(r1);
 * nvtxRangeEnd(r2);
 * }</pre>
 *
 * @see
 * ::nvtxRangeEnd
 * ::nvtxRangeStartEx
 * ::nvtxDomainRangeStartEx
 *
 * @version \NVTX_VERSION_0
 * \{ */
public static native @Cast("nvtxRangeId_t") long nvtxRangeStartA(@Cast("const char*") BytePointer message);
public static native @Cast("nvtxRangeId_t") long nvtxRangeStartA(String message);
public static native @Cast("nvtxRangeId_t") long nvtxRangeStartW(@Cast("const wchar_t*") CharPointer message);
public static native @Cast("nvtxRangeId_t") long nvtxRangeStartW(@Cast("const wchar_t*") IntPointer message);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Ends a process range.
*
* @param domain - The domain 
* @param id - The correlation ID returned from a nvtxRangeStart call.
*
* \remarks This function is offered completeness but is an alias for ::nvtxRangeEnd. 
* It does not need a domain param since that is associated iwth the range ID at ::nvtxDomainRangeStartEx
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("my domain");
* nvtxEventAttributes_t eventAttrib = {0};
* eventAttrib.version = NVTX_VERSION;
* eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
* eventAttrib.message.ascii = "my range";
* nvtxRangeId_t rangeId = nvtxDomainRangeStartEx(&eventAttrib);
* // ...
* nvtxDomainRangeEnd(rangeId);
* }</pre>
*
* @see
* ::nvtxDomainRangeStartEx
*
* @version \NVTX_VERSION_2
* \{ */
public static native void nvtxDomainRangeEnd(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("nvtxRangeId_t") long id);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Ends a process range.
 *
 * @param id - The correlation ID returned from an nvtxRangeStart call.
 *
 * @see
 * ::nvtxDomainRangeStartEx
 * ::nvtxRangeStartEx
 * ::nvtxRangeStartA
 * ::nvtxRangeStartW
 *
 * @version \NVTX_VERSION_0
 * \{ */
public static native void nvtxRangeEnd(@Cast("nvtxRangeId_t") long id);
/** \} */

/** \name Thread Ranges */

/* ------------------------------------------------------------------------- */
/** \brief Starts a nested thread range.
*
* @param domain    - The domain of scoping.
* @param eventAttrib - The event attribute structure defining the range's
* attribute types and attribute values.
*
* @return The 0 based level of range being started. This value is scoped to the domain.
* If an error occurs, a negative value is returned.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("example domain");
* nvtxEventAttributes_t eventAttrib = {0};
* eventAttrib.version = NVTX_VERSION;
* eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib.colorType = NVTX_COLOR_ARGB;
* eventAttrib.color = 0xFFFF0000;
* eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
* eventAttrib.message.ascii = "Level 0";
* nvtxDomainRangePushEx(domain, &eventAttrib);
*
* // Re-use eventAttrib
* eventAttrib.messageType = NVTX_MESSAGE_TYPE_UNICODE;
* eventAttrib.message.unicode = L"Level 1";
* nvtxDomainRangePushEx(domain, &eventAttrib);
*
* nvtxDomainRangePop(domain); //level 1
* nvtxDomainRangePop(domain); //level 0
* }</pre>
*
* @see
* ::nvtxDomainRangePop
*
* @version \NVTX_VERSION_2
* \{ */
public static native int nvtxDomainRangePushEx(@Cast("nvtxDomainHandle_t") Pointer domain, @Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Starts a nested thread range.
 *
 * @param eventAttrib - The event attribute structure defining the range's
 * attribute types and attribute values.
 *
 * @return The 0 based level of range being started. This level is per domain.
 * If an error occurs a negative value is returned.
 *
 * \par Example:
 * <pre>{@code
 * nvtxEventAttributes_t eventAttrib = {0};
 * eventAttrib.version = NVTX_VERSION;
 * eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
 * eventAttrib.colorType = NVTX_COLOR_ARGB;
 * eventAttrib.color = 0xFFFF0000;
 * eventAttrib.messageType = NVTX_MESSAGE_TYPE_ASCII;
 * eventAttrib.message.ascii = "Level 0";
 * nvtxRangePushEx(&eventAttrib);
 *
 * // Re-use eventAttrib
 * eventAttrib.messageType = NVTX_MESSAGE_TYPE_UNICODE;
 * eventAttrib.message.unicode = L"Level 1";
 * nvtxRangePushEx(&eventAttrib);
 *
 * nvtxRangePop();
 * nvtxRangePop();
 * }</pre>
 *
 * @see
 * ::nvtxDomainRangePushEx
 * ::nvtxRangePop
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native int nvtxRangePushEx(@Const nvtxEventAttributes_t eventAttrib);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Starts a nested thread range.
 *
 * @param message     - The event message associated to this range event.
 *
 * @return The 0 based level of range being started.  If an error occurs a
 * negative value is returned.
 *
 * \par Example:
 * <pre>{@code
 * nvtxRangePushA("Level 0");
 * nvtxRangePushW(L"Level 1");
 * nvtxRangePop();
 * nvtxRangePop();
 * }</pre>
 *
 * @see
 * ::nvtxDomainRangePushEx
 * ::nvtxRangePop
 *
 * @version \NVTX_VERSION_0
 * \{ */
public static native int nvtxRangePushA(@Cast("const char*") BytePointer message);
public static native int nvtxRangePushA(String message);
public static native int nvtxRangePushW(@Cast("const wchar_t*") CharPointer message);
public static native int nvtxRangePushW(@Cast("const wchar_t*") IntPointer message);
/** \} */


/* ------------------------------------------------------------------------- */
/** \brief Ends a nested thread range.
*
* @return The level of the range being ended. If an error occurs a negative
* value is returned on the current thread.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreate("example library");
* nvtxDomainRangePushA(domain, "Level 0");
* nvtxDomainRangePushW(domain, L"Level 1");
* nvtxDomainRangePop(domain);
* nvtxDomainRangePop(domain);
* }</pre>
*
* @see
* ::nvtxRangePushEx
* ::nvtxRangePushA
* ::nvtxRangePushW
*
* @version \NVTX_VERSION_2
* \{ */
public static native int nvtxDomainRangePop(@Cast("nvtxDomainHandle_t") Pointer domain);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Ends a nested thread range.
 *
 * @return The level of the range being ended. If an error occurs a negative
 * value is returned on the current thread.
 *
 * \par Example:
 * <pre>{@code
 * nvtxRangePushA("Level 0");
 * nvtxRangePushW(L"Level 1");
 * nvtxRangePop();
 * nvtxRangePop();
 * }</pre>
 *
 * @see
 * ::nvtxRangePushEx
 * ::nvtxRangePushA
 * ::nvtxRangePushW
 *
 * @version \NVTX_VERSION_0
 * \{ */
public static native int nvtxRangePop();
/** \} */


/** \} */ /*END defgroup*/
/* ========================================================================= */
/** \defgroup RESOURCE_NAMING Resource Naming
 *
 * See \ref RESOURCE_NAMING for more details
 *
 * \{
 */


/*  ------------------------------------------------------------------------- */
/** \name Functions for Generic Resource Naming*/
/*  ------------------------------------------------------------------------- */

/*  ------------------------------------------------------------------------- */
/** \cond SHOW_HIDDEN
* \brief Resource typing helpers.  
*
* Classes are used to make it easy to create a series of resource types 
* per API without collisions 
*/
// #define NVTX_RESOURCE_MAKE_TYPE(CLASS, INDEX) ((((uint32_t)(NVTX_RESOURCE_CLASS_ ## CLASS))<<16)|((uint32_t)(INDEX)))
public static final int NVTX_RESOURCE_CLASS_GENERIC = 1;
/** \endcond */

/* ------------------------------------------------------------------------- */
/** \brief Generic resource type for when a resource class is not available.
*
* @see
* ::nvtxDomainResourceCreate
*
* @version \NVTX_VERSION_2
*/
/** enum nvtxResourceGenericType_t */
public static final int
    NVTX_RESOURCE_TYPE_UNKNOWN = 0;
public static native @MemberGetter int NVTX_RESOURCE_TYPE_GENERIC_POINTER();
public static final int
    /** Generic pointer assumed to have no collisions with other pointers. */
    NVTX_RESOURCE_TYPE_GENERIC_POINTER = NVTX_RESOURCE_TYPE_GENERIC_POINTER();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_GENERIC_HANDLE();
public static final int
    /** Generic handle assumed to have no collisions with other handles. */
    NVTX_RESOURCE_TYPE_GENERIC_HANDLE = NVTX_RESOURCE_TYPE_GENERIC_HANDLE();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_GENERIC_THREAD_NATIVE();
public static final int
    /** OS native thread identifier. */
    NVTX_RESOURCE_TYPE_GENERIC_THREAD_NATIVE = NVTX_RESOURCE_TYPE_GENERIC_THREAD_NATIVE();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_GENERIC_THREAD_POSIX();
public static final int
    /** POSIX pthread identifier. */
    NVTX_RESOURCE_TYPE_GENERIC_THREAD_POSIX = NVTX_RESOURCE_TYPE_GENERIC_THREAD_POSIX();



/** \brief Resource Attribute Structure.
* \anchor RESOURCE_ATTRIBUTE_STRUCTURE
*
* This structure is used to describe the attributes of a resource. The layout of
* the structure is defined by a specific version of the tools extension
* library and can change between different versions of the Tools Extension
* library.
*
* \par Initializing the Attributes
*
* The caller should always perform the following three tasks when using
* attributes:
* <ul>
*    <li>Zero the structure
*    <li>Set the version field
*    <li>Set the size field
* </ul>
*
* Zeroing the structure sets all the resource attributes types and values
* to the default value.
*
* The version and size field are used by the Tools Extension
* implementation to handle multiple versions of the attributes structure.
*
* It is recommended that the caller use one of the following to methods
* to initialize the event attributes structure:
*
* \par Method 1: Initializing nvtxEventAttributes for future compatibility
* <pre>{@code
* nvtxResourceAttributes_t attribs = {0};
* attribs.version = NVTX_VERSION;
* attribs.size = NVTX_RESOURCE_ATTRIB_STRUCT_SIZE;
* }</pre>
*
* \par Method 2: Initializing nvtxEventAttributes for a specific version
* <pre>{@code
* nvtxResourceAttributes_v0 attribs = {0};
* attribs.version = 2;
* attribs.size = (uint16_t)(sizeof(nvtxResourceAttributes_v0));
* }</pre>
*
* If the caller uses Method 1 it is critical that the entire binary
* layout of the structure be configured to 0 so that all fields
* are initialized to the default value.
*
* The caller should either use both NVTX_VERSION and
* NVTX_RESOURCE_ATTRIB_STRUCT_SIZE (Method 1) or use explicit values
* and a versioned type (Method 2).  Using a mix of the two methods
* will likely cause either source level incompatibility or binary
* incompatibility in the future.
*
* \par Settings Attribute Types and Values
*
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("example domain");
*
* // Initialize
* nvtxResourceAttributes_t attribs = {0};
* attribs.version = NVTX_VERSION;
* attribs.size = NVTX_RESOURCE_ATTRIB_STRUCT_SIZE;
*
* // Configure the Attributes
* attribs.identifierType = NVTX_RESOURCE_TYPE_GENERIC_POINTER;
* attribs.identifier.pValue = (const void*)pMutex;
* attribs.messageType = NVTX_MESSAGE_TYPE_ASCII;
* attribs.message.ascii = "Single thread access to database.";
*
* nvtxResourceHandle_t handle = nvtxDomainResourceCreate(domain, attribs);
* }</pre>
*
* @see
* ::nvtxDomainResourceCreate
*/

/* \cond SHOW_HIDDEN 
* \version \NVTX_VERSION_2
*/
public static native @MemberGetter int NVTX_RESOURCE_ATTRIB_STRUCT_SIZE();
public static final int NVTX_RESOURCE_ATTRIB_STRUCT_SIZE = NVTX_RESOURCE_ATTRIB_STRUCT_SIZE();
/** \endcond */



/* ------------------------------------------------------------------------- */
/** \brief Create a resource object to track and associate data with OS and middleware objects
*
* Allows users to associate an API handle or pointer with a user-provided name.
* 
*
* @param domain - Domain to own the resource object
* @param attribs - Attributes to be associated with the resource
*
* @return A handle that represents the newly created resource object.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("example domain");
* nvtxResourceAttributes_t attribs = {0};
* attribs.version = NVTX_VERSION;
* attribs.size = NVTX_RESOURCE_ATTRIB_STRUCT_SIZE;
* attribs.identifierType = NVTX_RESOURCE_TYPE_GENERIC_POINTER;
* attribs.identifier.pValue = (const void*)pMutex;
* attribs.messageType = NVTX_MESSAGE_TYPE_ASCII;
* attribs.message.ascii = "Single thread access to database.";
* nvtxResourceHandle_t handle = nvtxDomainResourceCreate(domain, attribs);
* }</pre>
*
* @see
* ::nvtxResourceAttributes_t
* ::nvtxDomainResourceDestroy
*
* @version \NVTX_VERSION_2
* \{ */
public static native @Cast("nvtxResourceHandle_t") Pointer nvtxDomainResourceCreate(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("nvtxResourceAttributes_t*") Pointer attribs);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Destroy a resource object to track and associate data with OS and middleware objects
*
* Allows users to associate an API handle or pointer with a user-provided name.
*
* @param resource - Handle to the resource in which to operate.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("example domain");
* nvtxResourceAttributes_t attribs = {0};
* attribs.version = NVTX_VERSION;
* attribs.size = NVTX_RESOURCE_ATTRIB_STRUCT_SIZE;
* attribs.identifierType = NVTX_RESOURCE_TYPE_GENERIC_POINTER;
* attribs.identifier.pValue = (const void*)pMutex;
* attribs.messageType = NVTX_MESSAGE_TYPE_ASCII;
* attribs.message.ascii = "Single thread access to database.";
* nvtxResourceHandle_t handle = nvtxDomainResourceCreate(domain, attribs);
* nvtxDomainResourceDestroy(handle);
* }</pre>
*
* @see
* ::nvtxDomainResourceCreate
*
* @version \NVTX_VERSION_2
* \{ */
public static native void nvtxDomainResourceDestroy(@Cast("nvtxResourceHandle_t") Pointer resource);
/** \} */


/** \name Functions for NVTX Category Naming*/

/* ------------------------------------------------------------------------- */
/**
* \brief Annotate an NVTX category used within a domain.
*
* Categories are used to group sets of events. Each category is identified
* through a unique ID and that ID is passed into any of the marker/range
* events to assign that event to a specific category. The nvtxDomainNameCategory
* function calls allow the user to assign a name to a category ID that is
* specific to the domain.
*
* nvtxDomainNameCategory(NULL, category, name) is equivalent to calling
* nvtxNameCategory(category, name).
*
* @param domain    - The domain of scoping the category.
* @param category  - The category ID to name.
* @param name      - The name of the category.
*
* \remarks The category names are tracked per domain.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("example");
* nvtxDomainNameCategoryA(domain, 1, "Memory Allocation");
* nvtxDomainNameCategoryW(domain, 2, L"Memory Transfer");
* }</pre>
*
* @version \NVTX_VERSION_2
* \{ */
public static native void nvtxDomainNameCategoryA(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("uint32_t") int category, @Cast("const char*") BytePointer name);
public static native void nvtxDomainNameCategoryA(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("uint32_t") int category, String name);
public static native void nvtxDomainNameCategoryW(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("uint32_t") int category, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxDomainNameCategoryW(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("uint32_t") int category, @Cast("const wchar_t*") IntPointer name);
/** \} */

/** \brief Annotate an NVTX category.
 *
 * Categories are used to group sets of events. Each category is identified
 * through a unique ID and that ID is passed into any of the marker/range
 * events to assign that event to a specific category. The nvtxNameCategory
 * function calls allow the user to assign a name to a category ID.
 *
 * @param category - The category ID to name.
 * @param name     - The name of the category.
 *
 * \remarks The category names are tracked per process.
 *
 * \par Example:
 * <pre>{@code
 * nvtxNameCategory(1, "Memory Allocation");
 * nvtxNameCategory(2, "Memory Transfer");
 * nvtxNameCategory(3, "Memory Object Lifetime");
 * }</pre>
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCategoryA(@Cast("uint32_t") int category, @Cast("const char*") BytePointer name);
public static native void nvtxNameCategoryA(@Cast("uint32_t") int category, String name);
public static native void nvtxNameCategoryW(@Cast("uint32_t") int category, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCategoryW(@Cast("uint32_t") int category, @Cast("const wchar_t*") IntPointer name);
/** \} */

/** \name Functions for OS Threads Naming*/

/* ------------------------------------------------------------------------- */
/** \brief Annotate an OS thread.
 *
 * Allows the user to name an active thread of the current process. If an
 * invalid thread ID is provided or a thread ID from a different process is
 * used the behavior of the tool is implementation dependent.
 *
 * The thread name is associated to the default domain.  To support domains 
 * use resource objects via ::nvtxDomainResourceCreate.
 *
 * @param threadId - The ID of the thread to name.
 * @param name     - The name of the thread.
 *
 * \par Example:
 * <pre>{@code
 * nvtxNameOsThread(GetCurrentThreadId(), "MAIN_THREAD");
 * }</pre>
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameOsThreadA(@Cast("uint32_t") int threadId, @Cast("const char*") BytePointer name);
public static native void nvtxNameOsThreadA(@Cast("uint32_t") int threadId, String name);
public static native void nvtxNameOsThreadW(@Cast("uint32_t") int threadId, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameOsThreadW(@Cast("uint32_t") int threadId, @Cast("const wchar_t*") IntPointer name);
/** \} */


/** \} */ /*END defgroup*/
/* ========================================================================= */
/** \defgroup STRING_REGISTRATION String Registration
*
* Registered strings are intended to increase performance by lowering instrumentation
* overhead.  String may be registered once and the handle may be passed in place of
* a string where an the APIs may allow.
*
* See \ref STRING_REGISTRATION for more details
*
* \{
*/

/* ------------------------------------------------------------------------- */
/** \brief Register a string.
<p>
* Registers an immutable string with NVTX. Once registered the pointer used
* to register the domain name can be used in nvtxEventAttributes_t
* \ref MESSAGE_FIELD. This allows NVTX implementation to skip copying the
* contents of the message on each event invocation.
*
* String registration is an optimization. It is recommended to use string
* registration if the string will be passed to an event many times.
*
* String are not unregistered, except that by unregistering the entire domain
*
* @param domain  - Domain handle. If NULL then the global domain is used.
* @param string    - A unique pointer to a sequence of characters.
*
* @return A handle representing the registered string.
*
* \par Example:
* <pre>{@code
* nvtxDomainCreateA("com.nvidia.nvtx.example");
* nvtxStringHandle_t message = nvtxDomainRegisterStringA(domain, "registered string");
* nvtxEventAttributes_t eventAttrib = {0};
* eventAttrib.version = NVTX_VERSION;
* eventAttrib.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib.messageType = NVTX_MESSAGE_TYPE_REGISTERED;
* eventAttrib.message.registered = message;
* }</pre>
*
* @version \NVTX_VERSION_2
* \{ */
public static native @Cast("nvtxStringHandle_t") Pointer nvtxDomainRegisterStringA(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("const char*") BytePointer string);
public static native @Cast("nvtxStringHandle_t") Pointer nvtxDomainRegisterStringA(@Cast("nvtxDomainHandle_t") Pointer domain, String string);
public static native @Cast("nvtxStringHandle_t") Pointer nvtxDomainRegisterStringW(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("const wchar_t*") CharPointer string);
public static native @Cast("nvtxStringHandle_t") Pointer nvtxDomainRegisterStringW(@Cast("nvtxDomainHandle_t") Pointer domain, @Cast("const wchar_t*") IntPointer string);
/** \} */

/** \} */ /*END defgroup*/
/* ========================================================================= */
/** \defgroup DOMAINS Domains
*
* Domains are used to group events to a developer defined scope. Middleware
* vendors may also scope their own events to avoid collisions with the
* the application developer's events, so that the application developer may
* inspect both parts and easily differentiate or filter them.  By default
* all events are scoped to a global domain where NULL is provided or when
* using APIs provided b versions of NVTX below v2
*
* Domains are intended to be typically long lived objects with the intention
* of logically separating events of large modules from each other such as
* middleware libraries from each other and the main application.
*
* See \ref DOMAINS for more details
*
* \{
*/

/* ------------------------------------------------------------------------- */
/** \brief Register a NVTX domain.
*
* Domains are used to scope annotations. All NVTX_VERSION_0 and NVTX_VERSION_1
* annotations are scoped to the global domain. The function nvtxDomainCreate
* creates a new named domain.
*
* Each domain maintains its own nvtxRangePush and nvtxRangePop stack.
*
* @param name - A unique string representing the domain.
*
* @return A handle representing the domain.
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("com.nvidia.nvtx.example");
*
* nvtxMarkA("nvtxMarkA to global domain");
*
* nvtxEventAttributes_t eventAttrib1 = {0};
* eventAttrib1.version = NVTX_VERSION;
* eventAttrib1.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib1.message.ascii = "nvtxDomainMarkEx to global domain";
* nvtxDomainMarkEx(NULL, &eventAttrib1);
*
* nvtxEventAttributes_t eventAttrib2 = {0};
* eventAttrib2.version = NVTX_VERSION;
* eventAttrib2.size = NVTX_EVENT_ATTRIB_STRUCT_SIZE;
* eventAttrib2.message.ascii = "nvtxDomainMarkEx to com.nvidia.nvtx.example";
* nvtxDomainMarkEx(domain, &eventAttrib2);
* nvtxDomainDestroy(domain);
* }</pre>
*
* @see
* ::nvtxDomainDestroy
*
* @version \NVTX_VERSION_2
* \{ */
public static native @Cast("nvtxDomainHandle_t") Pointer nvtxDomainCreateA(@Cast("const char*") BytePointer name);
public static native @Cast("nvtxDomainHandle_t") Pointer nvtxDomainCreateA(String name);
public static native @Cast("nvtxDomainHandle_t") Pointer nvtxDomainCreateW(@Cast("const wchar_t*") CharPointer name);
public static native @Cast("nvtxDomainHandle_t") Pointer nvtxDomainCreateW(@Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Unregister a NVTX domain.
*
* Unregisters the domain handle and frees all domain specific resources.
*
* @param domain    - the domain handle
*
* \par Example:
* <pre>{@code
* nvtxDomainHandle_t domain = nvtxDomainCreateA("com.nvidia.nvtx.example");
* nvtxDomainDestroy(domain);
* }</pre>
*
* @see
* ::nvtxDomainCreateA
* ::nvtxDomainCreateW
*
* @version \NVTX_VERSION_2
* \{ */
public static native void nvtxDomainDestroy(@Cast("nvtxDomainHandle_t") Pointer domain);
/** \} */


/** \} */ /*END defgroup*/
/* ========================================================================= */
/** \cond SHOW_HIDDEN */


/** \endcond */

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* NVTOOLSEXT_H_ */


// Parsed from <nvToolsExtCuda.h>

/*
* Copyright 2009-2017  NVIDIA Corporation.  All rights reserved.
*
* NOTICE TO USER:
*
* This source code is subject to NVIDIA ownership rights under U.S. and
* international Copyright laws.
*
* This software and the information contained herein is PROPRIETARY and
* CONFIDENTIAL to NVIDIA and is being provided under the terms and conditions
* of a form of NVIDIA software license agreement.
*
* NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
* CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
* IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
* REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
* IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
* OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
* OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
* OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
* OR PERFORMANCE OF THIS SOURCE CODE.
*
* U.S. Government End Users.   This source code is a "commercial item" as
* that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
* "commercial computer  software"  and "commercial computer software
* documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
* and is provided to the U.S. Government only as a commercial end item.
* Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
* 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
* source code with only those rights set forth herein.
*
* Any use of this source code in individual and commercial software must
* include, in the user documentation and internal comments to the code,
* the above Disclaimer and U.S. Government End Users Notice.
*/

// #ifndef NVTOOLSEXT_CUDA_H_
// #define NVTOOLSEXT_CUDA_H_

// #include "cuda.h"

// #include "nvToolsExt.h"

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* ========================================================================= */
/** \name Functions for CUDA Resource Naming
*/
/** \addtogroup RESOURCE_NAMING
 * \section RESOURCE_NAMING_CUDA CUDA Resource Naming
 *
 * This section covers the API functions that allow to annotate CUDA resources
 * with user-provided names.
 *
 * \{
 */

/*  ------------------------------------------------------------------------- */
/* \cond SHOW_HIDDEN 
* \brief Used to build a non-colliding value for resource types separated class
* \version \NVTX_VERSION_2
*/
public static final int NVTX_RESOURCE_CLASS_CUDA =  4;
/** \endcond */

/*  ------------------------------------------------------------------------- */
/** \brief Resource types for CUDA
*/
/** enum nvtxResourceCUDAType_t */

public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDA_DEVICE();
public static final int
    NVTX_RESOURCE_TYPE_CUDA_DEVICE = NVTX_RESOURCE_TYPE_CUDA_DEVICE();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDA_CONTEXT();
public static final int /* CUdevice */
    NVTX_RESOURCE_TYPE_CUDA_CONTEXT = NVTX_RESOURCE_TYPE_CUDA_CONTEXT();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDA_STREAM();
public static final int /* CUcontext */
    NVTX_RESOURCE_TYPE_CUDA_STREAM = NVTX_RESOURCE_TYPE_CUDA_STREAM();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDA_EVENT();
public static final int /* CUstream */
    NVTX_RESOURCE_TYPE_CUDA_EVENT = NVTX_RESOURCE_TYPE_CUDA_EVENT();  /* CUevent */


/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA device.
 *
 * Allows the user to associate a CUDA device with a user-provided name.
 *
 * @param device - The handle of the CUDA device to name.
 * @param name   - The name of the CUDA device.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCuDeviceA(@Cast("CUdevice") int device, @Cast("const char*") BytePointer name);
public static native void nvtxNameCuDeviceA(@Cast("CUdevice") int device, String name);
public static native void nvtxNameCuDeviceW(@Cast("CUdevice") int device, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCuDeviceW(@Cast("CUdevice") int device, @Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA context.
 *
 * Allows the user to associate a CUDA context with a user-provided name.
 *
 * @param context - The handle of the CUDA context to name.
 * @param name    - The name of the CUDA context.
 *
 * \par Example:
 * <pre>{@code
 * CUresult status = cuCtxCreate( &cuContext, 0, cuDevice );
 * if ( CUDA_SUCCESS != status )
 *     goto Error;
 * nvtxNameCuContext(cuContext, "CTX_NAME");
 * }</pre>
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCuContextA(CUctx_st context, @Cast("const char*") BytePointer name);
public static native void nvtxNameCuContextA(CUctx_st context, String name);
public static native void nvtxNameCuContextW(CUctx_st context, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCuContextW(CUctx_st context, @Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA stream.
 *
 * Allows the user to associate a CUDA stream with a user-provided name.
 *
 * @param stream - The handle of the CUDA stream to name.
 * @param name   - The name of the CUDA stream.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCuStreamA(CUstream_st stream, @Cast("const char*") BytePointer name);
public static native void nvtxNameCuStreamA(CUstream_st stream, String name);
public static native void nvtxNameCuStreamW(CUstream_st stream, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCuStreamW(CUstream_st stream, @Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA event.
 *
 * Allows the user to associate a CUDA event with a user-provided name.
 *
 * @param event - The handle of the CUDA event to name.
 * @param name  - The name of the CUDA event.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCuEventA(CUevent_st event, @Cast("const char*") BytePointer name);
public static native void nvtxNameCuEventA(CUevent_st event, String name);
public static native void nvtxNameCuEventW(CUevent_st event, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCuEventW(CUevent_st event, @Cast("const wchar_t*") IntPointer name);
/** \} */

/** \} */ /* END RESOURCE_NAMING */

/* ========================================================================= */

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* NVTOOLSEXT_CUDA_H_ */


// Parsed from <nvToolsExtCudaRt.h>

/*
* Copyright 2009-2017  NVIDIA Corporation.  All rights reserved.
*
* NOTICE TO USER:
*
* This source code is subject to NVIDIA ownership rights under U.S. and
* international Copyright laws.
*
* This software and the information contained herein is PROPRIETARY and
* CONFIDENTIAL to NVIDIA and is being provided under the terms and conditions
* of a form of NVIDIA software license agreement.
*
* NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
* CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
* IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
* REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
* IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
* OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
* OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
* OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
* OR PERFORMANCE OF THIS SOURCE CODE.
*
* U.S. Government End Users.   This source code is a "commercial item" as
* that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
* "commercial computer  software"  and "commercial computer software
* documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
* and is provided to the U.S. Government only as a commercial end item.
* Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
* 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
* source code with only those rights set forth herein.
*
* Any use of this source code in individual and commercial software must
* include, in the user documentation and internal comments to the code,
* the above Disclaimer and U.S. Government End Users Notice.
*/

// #ifndef NVTOOLSEXT_CUDART_H_
// #define NVTOOLSEXT_CUDART_H_

// #include "cuda.h"
// #include "driver_types.h"

// #include "nvToolsExt.h"

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* ========================================================================= */
/** \name Functions for CUDA Resource Naming
*/
/** \addtogroup RESOURCE_NAMING
 * \section RESOURCE_NAMING_CUDART CUDA Runtime Resource Naming
 *
 * This section covers the API functions that allow to annotate CUDA resources
 * with user-provided names.
 *
 * \{
 */

/*  ------------------------------------------------------------------------- */
/* \cond SHOW_HIDDEN 
* \brief Used to build a non-colliding value for resource types separated class
* \version \NVTX_VERSION_2
*/
public static final int NVTX_RESOURCE_CLASS_CUDART = 5;
/** \endcond */

/*  ------------------------------------------------------------------------- */
/** \brief Resource types for CUDART
*/
/** enum nvtxResourceCUDARTType_t */

public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDART_DEVICE();
public static final int
    NVTX_RESOURCE_TYPE_CUDART_DEVICE = NVTX_RESOURCE_TYPE_CUDART_DEVICE();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDART_STREAM();
public static final int /* int device */
    NVTX_RESOURCE_TYPE_CUDART_STREAM = NVTX_RESOURCE_TYPE_CUDART_STREAM();
public static native @MemberGetter int NVTX_RESOURCE_TYPE_CUDART_EVENT();
public static final int /* cudaStream_t */
    NVTX_RESOURCE_TYPE_CUDART_EVENT = NVTX_RESOURCE_TYPE_CUDART_EVENT();  /* cudaEvent_t */


/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA device.
 *
 * Allows the user to associate a CUDA device with a user-provided name.
 *
 * @param device - The id of the CUDA device to name.
 * @param name   - The name of the CUDA device.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCudaDeviceA(int device, @Cast("const char*") BytePointer name);
public static native void nvtxNameCudaDeviceA(int device, String name);
public static native void nvtxNameCudaDeviceW(int device, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCudaDeviceW(int device, @Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA stream.
 *
 * Allows the user to associate a CUDA stream with a user-provided name.
 *
 * @param stream - The handle of the CUDA stream to name.
 * @param name   - The name of the CUDA stream.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCudaStreamA(CUstream_st stream, @Cast("const char*") BytePointer name);
public static native void nvtxNameCudaStreamA(CUstream_st stream, String name);
public static native void nvtxNameCudaStreamW(CUstream_st stream, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCudaStreamW(CUstream_st stream, @Cast("const wchar_t*") IntPointer name);
/** \} */

/* ------------------------------------------------------------------------- */
/** \brief Annotates a CUDA event.
 *
 * Allows the user to associate a CUDA event with a user-provided name.
 *
 * @param event - The handle of the CUDA event to name.
 * @param name  - The name of the CUDA event.
 *
 * @version \NVTX_VERSION_1
 * \{ */
public static native void nvtxNameCudaEventA(CUevent_st event, @Cast("const char*") BytePointer name);
public static native void nvtxNameCudaEventA(CUevent_st event, String name);
public static native void nvtxNameCudaEventW(CUevent_st event, @Cast("const wchar_t*") CharPointer name);
public static native void nvtxNameCudaEventW(CUevent_st event, @Cast("const wchar_t*") IntPointer name);
/** \} */

/** \} */ /* END RESOURCE_NAMING */

/* ========================================================================= */

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* NVTOOLSEXT_CUDART_H_ */


}
