// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.nvcomp.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class nvcomp extends org.bytedeco.cuda.presets.nvcomp {
    static { Loader.load(); }

// Parsed from <nvcomp.h>

/*
 * Copyright (c) 2017-2020, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_H
// #define NVCOMP_H

// #include "nvcomp/shared_types.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * CONSTANTS ******************************************************************
 *****************************************************************************/

public static final int NVCOMP_MAJOR_VERSION = 3;
public static final int NVCOMP_MINOR_VERSION = 0;
public static final int NVCOMP_PATCH_VERSION = 5;

/* Supported datatypes */
/** enum nvcompType_t */
public static final int
  NVCOMP_TYPE_CHAR = 0,      // 1B
  NVCOMP_TYPE_UCHAR = 1,     // 1B
  NVCOMP_TYPE_SHORT = 2,     // 2B
  NVCOMP_TYPE_USHORT = 3,    // 2B
  NVCOMP_TYPE_INT = 4,       // 4B
  NVCOMP_TYPE_UINT = 5,      // 4B
  NVCOMP_TYPE_LONGLONG = 6,  // 8B
  NVCOMP_TYPE_ULONGLONG = 7, // 8B
  NVCOMP_TYPE_BITS = 0xff;    // 1b

/******************************************************************************
 * FUNCTION PROTOTYPES ********************************************************
 *****************************************************************************/

/**
 * NOTE: These interfaces will be removed in future releases, please switch to
 * the compression schemes specific interfaces in nvcomp/cascaded.h,
 * nvcomp/lz4.h, nvcomp/snappy, nvcomp/bitcomp.h, and nvcomp/gdeflate.h.
 */

/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Extracts the metadata from the input in_ptr on the device and copies
 *it to the host.
 *
 * @param in_ptr The compressed memory on the device.
 * @param in_bytes The size of the compressed memory on the device.
 * @param metadata_ptr The metadata on the host to create from the compresesd
 * data.
 * @param stream The stream to use for reading memory from the device.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Destroys the metadata object and frees the associated memory.
 *
 * @param metadata_ptr The pointer to destroy.
 */


/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Computes the required temporary workspace required to perform
 * decompression.
 *
 * \para metadata_ptr The metadata.
 * @param temp_bytes The size of the required temporary workspace in bytes
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Computes the size of the uncompressed data in bytes.
 *
 * \para metadata_ptr The metadata.
 * @param output_bytes The size of the uncompressed data (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Get the type of the compressed data.
 *
 * @param metadata_ptr The metadata.
 * @param type The data type (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * DEPRECATED: Will be removed in future releases.
 *
 * \brief Perform the asynchronous decompression.
 *
 * @param in_ptr The compressed data on the device to decompress.
 * @param in_bytes The size of the compressed data.
 * @param temp_ptr The temporary workspace on the device.
 * @param temp_bytes The size of the temporary workspace.
 * @param metadata_ptr The metadata.
 * @param out_ptr The output location on the device.
 * @param out_bytes The size of the output location.
 * @param stream The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/shared_types.h>

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #pragma once

/** enum nvcompStatus_t */
public static final int
  nvcompSuccess = 0,
  nvcompErrorInvalidValue = 10,
  nvcompErrorNotSupported = 11,
  nvcompErrorCannotDecompress = 12,
  nvcompErrorBadChecksum = 13,
  nvcompErrorCannotVerifyChecksums = 14,
  nvcompErrorOutputBufferTooSmall = 15,
  nvcompErrorWrongHeaderLength = 16,
  nvcompErrorAlignment = 17,
  nvcompErrorChunkSizeTooLarge = 18,
  nvcompErrorCudaError = 1000,
  nvcompErrorInternal = 10000;

/** enum ChecksumPolicy */
public static final int
  // During compression, do not compute checksums
  // During decompression, do not verify checksums
  NoComputeNoVerify = 0,
  
  // During compression, compute checksums
  // During decompression, do not attempt to verify checksums
  ComputeAndNoVerify = 1,

  // During compression, do not compute checksums
  // During decompression, verify checksums if they were included
  NoComputeAndVerifyIfPresent = 2,

  // During compression, compute checksums
  // During decompression, verify checksums if they were included
  ComputeAndVerifyIfPresent = 3,

  // During compression, compute checksums
  // During decompression, verify checksums
  // A runtime error will be thrown upon configure_decompression if 
  // checksums were not included in the compressed buffer.
  ComputeAndVerify = 4;

// Parsed from <nvcomp/nvcompManager.hpp>

// #pragma once

/*
 * Copyright (c) 2020-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include "nvcomp.h"

// #include <memory>
// #include <vector>
// #include <functional>
// #include <stdint.h>

/******************************************************************************
 * CLASSES ********************************************************************
 *****************************************************************************/

/**
 * Internal memory pool used for compression / decompression configs
 */
// Targeting ../nvcomp/CompressionConfig.java


// Targeting ../nvcomp/DecompressionConfig.java


// Targeting ../nvcomp/nvcompManagerBase.java


// Targeting ../nvcomp/PimplManager.java



 // namespace nvcomp


// Parsed from <nvcomp/nvcompManagerFactory.hpp>

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #pragma once

// #include "nvcompManager.hpp"
// #include "ans.hpp"
// #include "gdeflate.hpp"
// #include "lz4.hpp"
// #include "snappy.hpp"
// #include "bitcomp.hpp"
// #include "cascaded.hpp"
// #include "zstd.hpp"
// #include "deflate.hpp"

// #include <cassert>
// #include <stdint.h>

/** 
 * \brief Construct a ManagerBase from a buffer
 * 
 * This synchronizes the stream
 * 
 */ 
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") BytePointer comp_buffer, CUstream_st stream/*=0*/, 
    int device_id/*=0*/, @Cast("ChecksumPolicy") int checksum_policy/*=NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") BytePointer comp_buffer);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") ByteBuffer comp_buffer, CUstream_st stream/*=0*/, 
    int device_id/*=0*/, @Cast("ChecksumPolicy") int checksum_policy/*=NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") ByteBuffer comp_buffer);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") byte[] comp_buffer, CUstream_st stream/*=0*/, 
    int device_id/*=0*/, @Cast("ChecksumPolicy") int checksum_policy/*=NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") byte[] comp_buffer);

 // namespace nvcomp


// Parsed from <nvcomp/ans.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_ANS_H
// #define NVCOMP_ANS_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched compression/decompression interface for ANS
 *****************************************************************************/

/** enum nvcompANSType_t */
public static final int
  nvcomp_rANS = 0;
// Targeting ../nvcomp/nvcompBatchedANSOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedANSOpts_t nvcompBatchedANSDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompANSCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompANSRequiredAlignment();

/**
 * \brief Get temporary space required for compression.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts Compression options.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts Compression options.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatched[R|T|H]ANSCompressAsync() for each batch item.
 *
 * @param max_chunk_size The maximum size of a chunk in the batch.
 * @param format_opts Compression options.
 * @param max_compressed_size The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_chunk_size,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_size);

/**
 * \brief Perform compression.
 *
 * The caller is responsible for passing device_compressed_bytes of size
 * sufficient to hold compressed data
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * Each pointer must be aligned to a 4-byte boundary.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * @param max_uncompressed_chunk_bytes The size of the largest uncompressed chunk.
 * @param batch_size The number of batch items.
 * @param device_temp_ptr The temporary GPU workspace, could be NULL in case temprorary space is not needed.
 * @param temp_bytes The size of the temporary GPU workspace.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for each compressed batch item (output).
 * Each pointer must be aligned to an 8-byte boundary.
 * @param device_compressed_bytes The compressed size of each chunk on the GPU (output).
 * @param format_opts Compression options.
 * @param stream The stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    CUstream_st stream);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression with extra total size argument.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. Unused in ANS.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_uncompressed_total_size );    

/**
 * \brief Compute uncompressed sizes.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The actual size of each uncompressed chunk.
 * @param batch_size The number of batch items.
 * @param stream The stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

/**
 * \brief Perform decompression.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks. 
 * Each pointer must be aligned to an 8-byte boundary.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The size of each device_uncompressed_ptrs[i] buffer.
 * @param device_actual_uncompressed_bytes The actual size of each uncompressed chunk
 * @param batch_size The number of batch items.
 * @param device_temp_ptr The temporary GPU space, could be NULL in case temporary space is not needed.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to uncompress each chunk (output).
 * @param device_statuses The pointers on the GPU, to where to uncompress each chunk (output).
 * @param stream The stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/ans.hpp>

// #pragma once

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/ans.h"
// Targeting ../nvcomp/ANSFormatSpecHeader.java


// Targeting ../nvcomp/ANSManager.java



 // namespace nvcomp


// Parsed from <nvcomp/bitcomp.h>

/*
 * Copyright (c) 2017-2020, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_BITCOMP_H
// #define NVCOMP_BITCOMP_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/**
 * \brief Structure for configuring Bitcomp compression.
 */

@MemberGetter public static native @Cast("const size_t") long nvcompBitcompCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompBitcompRequiredAlignment();

/**
 * \brief Get the temporary workspace size required to perform compression.
 *
 * @param format_opts The bitcomp format options (can pass NULL for default
 * options).
 * @param in_type The type of the uncompressed data.
 * @param uncompressed_bytes The size of the uncompressed data in bytes.
 * @param temp_bytes The size of the required temporary workspace in bytes
 * (output).
 * @param max_compressed_bytes The maximum size of the compressed data
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Perform asynchronous compression.
 *
 * @param format_opts The bitcomp format options (can pass NULL for default
 * options).
 * @param in_type The data type of the uncompressed data.
 * @param uncompressed_ptr The uncompressed data on the device.
 * @param uncompressed_bytes The size of the uncompressed data in bytes.
 * @param temp_ptr The temporary workspace on the device.
 * @param temp_bytes The size of the temporary workspace in bytes.
 * @param compressed_ptr The location to write compresesd data to on the device
 * (output).
 * @param compressed_bytes The size of the compressed data (output). This must
 * be GPU accessible.
 * @param stream The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Extracts the metadata from the input in_ptr on the device and copies
 * it to the host. This function synchronizes on the stream.
 *
 * @param compressed_ptr The compressed memory on the device.
 * @param compressed_bytes The size of the compressed memory on the device.
 * @param metadata_ptr The metadata on the host to create from the compresesd
 * data (output).
 * @param metadata_bytes The size of the created metadata (output).
 * @param temp_bytes The amount of temporary space required for decompression
 * (output).
 * @param uncompressed_bytes The size the data will decompress to (output).
 * @param stream The stream to use for copying from the device to the host.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Destroys the metadata object and frees the associated memory.
 *
 * @param metadata_ptr The pointer to destroy.
 */


/**
 * \brief Perform the asynchronous decompression.
 *
 * @param compressed_ptr The compressed data on the device to decompress.
 * @param compressed_bytes The size of the compressed data.
 * @param metadata_ptr The metadata.
 * @param metadata_bytes The size of the metadata.
 * @param temp_ptr The temporary workspace on the device. Not used, can pass
 * NULL.
 * @param temp_bytes The size of the temporary workspace. Not used.
 * @param uncompressed_ptr The output location on the device.
 * @param uncompressed_bytes The size of the output location.
 * @param stream The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Checks if the compressed data was compressed with bitcomp.
 *
 * @param in_ptr The compressed data.
 * @param in_bytes The size of the compressed buffer.
 *
 * @return 1 if the data was compressed with bitcomp, 0 otherwise
 */

// Targeting ../nvcomp/nvcompBatchedBitcompFormatOpts.java



@MemberGetter public static native @Const @ByRef nvcompBatchedBitcompFormatOpts nvcompBatchedBitcompDefaultOpts();

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedSnappyCompressAsync() for each batch item.
 *
 * @param max_chunk_size The maximum size of a chunk in the batch.
 * @param format_ops Snappy compression options.
 * @param max_compressed_size The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_chunk_size,
    @ByVal nvcompBatchedBitcompFormatOpts format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_size);
/**
 * \brief Perform batched asynchronous compression.
 *
 * NOTE: The maximum number of batch partitions is 2^31.
 * 
 * NOTE: Unlike {@code nvcompBitcompCompressAsync}, a valid compression format must
 * be supplied to {@code format_opts}.
 *
 * @param device_uncompressed_ptrs [in] Array with size \p batch_size of pointers
 * to the uncompressed partitions. Both the pointers and the uncompressed data
 * should reside in device-accessible memory. The uncompressed data must start
 * at locations with alignments of the data type.
 * @param device_uncompressed_bytes [in] Sizes of the uncompressed partitions in
 * bytes. The sizes should reside in device-accessible memory.
 * Each chunk size MUST be a multiple of the size of the data type specified by
 * format_opts.data_type, else this may crash or produce invalid output.
 * @param max_uncompressed_chunk_bytes [in] This argument is not used.
 * @param batch_size [in] Number of partitions to compress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_compressed_ptrs [out] Array with size \p batch_size of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with size at least (8B + the uncompressed size). Each
 * compressed buffer should start at a location with 64-bit alignment.
 * @param device_compressed_bytes [out] Compressed sizes in bytes for all
 * partitions. The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The bitcomp format options. The format must be valid.
 * @param type [in] The data type of the uncompressed data.
 * @param stream [in] The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedBitcompFormatOpts format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedBitcompFormatOpts format_opts,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * NOTE: This function is used to decompress compressed buffers produced by
 * {@code nvcompBatchedBitcompCompressAsync}. It can also decompress buffers
 * compressed with {@code nvcompBitcompCompressAsync} or the standalone Bitcomp library.
 * 
 * NOTE: The function is not completely asynchronous, as it needs to look
 * at the compressed data in order to create the proper bitcomp handle.
 * The stream is synchronized, the data is examined, then the asynchronous
 * decompression is launched.
 *
 * @param device_compressed_ptrs [in] Array with size \p batch_size of pointers
 * in device-accessible memory to compressed buffers. Each compressed buffer
 * should reside in device-accessible memory and start at a location which is
 * 64-bit aligned.
 * @param device_compressed_bytes [in] This argument is not used.
 * @param device_uncompressed_bytes [in] Sizes of the output uncompressed
 * buffers in bytes. The sizes should reside in device-accessible memory. If the
 * size is not large enough to hold all decompressed elements, the decompressor
 * will set the status specified in \p device_statuses corresponding to the
 * overflow partition to {@code nvcompErrorCannotDecompress}.
 * @param device_actual_uncompressed_bytes [out] Array with size \p batch_size of
 * the actual number of bytes decompressed for every partitions. This argument
 * needs to be preallocated.
 * @param batch_size [in] Number of partitions to decompress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_uncompressed_ptrs [out] This argument is not used.
 * @param device_statuses [out] Array with size \p batch_size of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * partition, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The cuda stream to operate on.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Asynchronously get the number of bytes of the uncompressed data in
 * every partitions.
 *
 * @param device_compressed_ptrs [in] Array with size \p batch_size of pointers
 * in device-accessible memory to compressed buffers.
 * @param device_compressed_bytes [in] This argument is not used.
 * @param device_uncompressed_bytes [out] Sizes of the uncompressed data in
 * bytes. If there is an error when retrieving the size of a partition, the
 * uncompressed size of that partition will be set to 0. This argument needs to
 * be prealloated in device-accessible memory.
 * @param batch_size [in] Number of partitions to check sizes.
 * @param stream [in] The cuda stream to operate on.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

/**
 * \brief Return the temp size needed for Bitcomp compression.
 * Bitcomp currently doesn't use any temp memory.
 * 
 * @param batch_size [in]  Number of chunks
 * @param max_uncompressed_chunk_bytes [in] Size in bytes of the largest chunk
 * @param format_opts [in] Bitcomp options
 * @param temp_bytes [out] The temp size
 * 
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompFormatOpts format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Return the temp size needed for Bitcomp compression.
 * Bitcomp currently doesn't use any temp memory.
 * 
 * @param batch_size [in]  Number of chunks
 * @param max_uncompressed_chunk_bytes [in] Size in bytes of the largest chunk
 * @param format_opts [in] Bitcomp options
 * @param temp_bytes [out] The temp size
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 * 
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompFormatOpts format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);    

/**
 * \brief Return the temp size needed for Bitcomp decompression.
 * Bitcomp currently doesn't use any temp memory.
 * 
 * @param batch_size [in]  Number of chunks
 * @param max_chunk_bytes [in] Size in bytes of the largest chunk
 * @param format_opts [in] Bitcomp options
 * @param temp_bytes [out] The temp size
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Return the temp size needed for Bitcomp decompression.
 * Bitcomp currently doesn't use any temp memory.
 * 
 * @param batch_size [in]  Number of chunks
 * @param max_chunk_bytes [in] Size in bytes of the largest chunk
 * @param format_opts [in] Bitcomp options
 * @param max_uncompressed_total_size [in]  The total decompressed size of all the chunks. Unused in bitcomp.
 * @param temp_bytes [out] The temp size
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("size_t") long max_uncompressed_total_size );

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/bitcomp.hpp>

// #pragma once

/*
 * Copyright (c) 2020-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include "nvcompManager.hpp"
// #include "nvcomp/bitcomp.h"
// Targeting ../nvcomp/BitcompFormatSpecHeader.java


// Targeting ../nvcomp/BitcompManager.java



 // namespace nvcomp

// Parsed from <nvcomp/cascaded.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_CASCADED_H
// #define NVCOMP_CASCADED_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompCascadedFormatOpts.java


// Targeting ../nvcomp/nvcompBatchedCascadedOpts_t.java



// Default options for batched compression
@MemberGetter public static native @Const @ByRef nvcompBatchedCascadedOpts_t nvcompBatchedCascadedDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompCascadedCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompCascadedRequiredAlignment();

/**
 * \brief Get temporary space required for compression.
 *
 * NOTE: Batched Cascaded compression does not require temp space, so
 * this will set temp_bytes=0, unless an error is found with the format_opts.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The Cascaded compression options and datatype to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * NOTE: Batched Cascaded compression does not require temp space, so
 * this will set temp_bytes=0, unless an error is found with the format_opts.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The Cascaded compression options and datatype to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedCascadedCompressAsync() for each batch item.
 *
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts The Cascaded compression options to use.
 * @param max_compressed_byes The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * NOTE: Unlike {@code nvcompCascadedCompressAsync}, a valid compression format must
 * be supplied to {@code format_opts}.
 *
 * NOTE: The current implementation does not support uncompressed size larger
 * than 4,294,967,295 bytes (max uint32_t).
 *
 * @param device_uncompressed_ptrs [in] Array with size \p batch_size of pointers
 * to the uncompressed partitions. Both the pointers and the uncompressed data
 * should reside in device-accessible memory. The uncompressed data must start
 * at locations with alignments of the data type.
 * @param device_uncompressed_bytes [in] Sizes of the uncompressed partitions in
 * bytes. The sizes should reside in device-accessible memory.
 * Each chunk size MUST be a multiple of the size of the data type specified by
 * format_opts.type, else this may crash or produce invalid output.
 * @param max_uncompressed_chunk_bytes [in] This argument is not used.
 * @param batch_size [in] Number of partitions to compress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_compressed_ptrs [out] Array with size \p batch_size of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with size at least (8B + the uncompressed size). Each
 * compressed buffer should start at a location with alignment of both 4B and
 * the data type.
 * @param device_compressed_bytes [out] Number of bytes decompressed of all
 * partitions. The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The cascaded format options. The format must be valid.
 * @param stream [in] The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedCascadedOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedCascadedOpts_t format_opts,
    CUstream_st stream);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in Cascaded.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, 
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_uncompressed_total_size);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * NOTE: This function is used to decompress compressed buffers produced by
 * {@code nvcompBatchedCascadedCompressAsync}. Currently it is not compatible with
 * compressed buffers produced by {@code nvcompCascadedCompressAsync}.
 *
 * @param device_compressed_ptrs [in] Array with size \p batch_size of pointers
 * in device-accessible memory to compressed buffers. Each compressed buffer
 * should reside in device-accessible memory and start at a location with
 * alignment of both 4B and the data type.
 * @param device_compressed_bytes [in] Sizes of the compressed buffers in bytes.
 * The sizes should reside in device-accessible memory.
 * @param device_uncompressed_bytes [in] Sizes of the output uncompressed
 * buffers in bytes. The sizes should reside in device-accessible memory. If the
 * size is not large enough to hold all decompressed elements, the decompressor
 * will set the status specified in \p device_statuses corresponding to the
 * overflow partition to {@code nvcompErrorCannotDecompress}.
 * @param device_actual_uncompressed_bytes [out] Array with size \p batch_size of
 * the actual number of bytes decompressed for every partitions. This argument
 * needs to be preallocated.
 * @param batch_size [in] Number of partitions to decompress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_uncompressed_ptrs [out] Array with size \p batch_size of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, and start at a
 * location with alignment of the data type.
 * @param device_statuses [out] Array with size \p batch_size of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * partition, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The cuda stream to operate on.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Asynchronously get the number of bytes of the uncompressed data in
 * every partitions.
 *
 * @param device_compressed_ptrs [in] Array with size \p batch_size of pointers
 * in device-accessible memory to compressed buffers.
 * @param device_compressed_bytes [in] Sizes of the compressed buffers in bytes.
 * The sizes should reside in device-accessible memory.
 * @param device_uncompressed_bytes [out] Sizes of the uncompressed data in
 * bytes. If there is an error when retrieving the size of a partition, the
 * uncompressed size of that partition will be set to 0. This argument needs to
 * be prealloated in device-accessible memory.
 * @param batch_size [in] Number of partitions to check sizes.
 * @param stream [in] The cuda stream to operate on.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/CRC32.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
// #ifndef NVCOMP_CRC32_H
// #define NVCOMP_CRC32_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched compute interface for CRC32
 *****************************************************************************/

/**
 * \brief Perform CRC32 checksum calculation asynchronously. All pointers must point to GPU
 * accessible locations.
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * @param batch_size The number of chunks to compress.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for
 * each CRC32 checksum (output). This pointer must be GPU accessible.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    @Cast("uint32_t*") IntPointer device_CRC32_ptrs,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    @Cast("uint32_t*") IntPointer device_CRC32_ptrs,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    @Cast("uint32_t*") IntBuffer device_CRC32_ptrs,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    @Cast("uint32_t*") int[] device_CRC32_ptrs,
    CUstream_st stream);


// #ifdef __cplusplus
// #endif
// #endif // NVCOMP_CRC32_H

// Parsed from <nvcomp/deflate.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_DEFLATE_H
// #define NVCOMP_DEFLATE_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompBatchedDeflateOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedDeflateOpts_t nvcompBatchedDeflateDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompDeflateCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompDeflateRequiredAlignment();

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The Deflate compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The Deflate compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);    

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedDeflateCompressAsync() for each batch item.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts The Deflate compression options to use.
 * @param max_compressed_byes The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_bytes);

/**
 * \brief Perform compression asynchronously. All pointers must point to GPU
 * accessible locations. The individual chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended. The output buffer has to be algned by 8 bytes.  
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * @param max_uncompressed_chunk_bytes The maximum size in bytes of the largest
 * chunk in the batch.
 * @param batch_size The number of chunks to compress.
 * @param device_temp_ptr The temporary GPU workspace.
 * @param temp_bytes The size of the temporary GPU workspace.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for
 * each compressed batch item (output). This pointer must be GPU accessible.
 * @param device_compressed_bytes The compressed size of each chunk on the GPU
 * (output). This pointer must be GPU accessible.
 * @param format_opts The Deflate compression options to use.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    CUstream_st stream);


/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in deflate.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("size_t") long max_uncompressed_total_size );

/**
 * \brief Perform decompression asynchronously. All pointers must be GPU
 * accessible. In the case where a chunk of compressed data is not a valid Deflate
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_ptrs The pointers on the GPU, to the compressed
 * chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The decompressed buffer size. This is needed
 * to prevent OOB accesses. This pointer must be GPU accessible.
 * @param device_actual_uncompressed_bytes The actual calculated decompressed
 * size of each chunk. Can be nullptr if desired, 
 * in which case the actual_uncompressed_bytes is not reported.
 * @param batch_size The number of batch items.
 * @param device_temp_ptr The temporary GPU space.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to
 * uncompress each chunk (output).
 * @param device_statuses The status for each chunk of whether it was
 * decompressed or not. Can be nullptr if desired, 
 * in which case error status is not reported.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Calculates the decompressed size of each chunk asynchronously. This is
 * needed when we do not know the expected output size. All pointers must be GPU
 * accessible. Note, if the stream is corrupt, the sizes will be garbage.
 *
 * @param device_compress_ptrs The compressed chunks of data. List of pointers
 * must be GPU accessible along with each chunk.
 * @param device_compressed_bytes The size of each compressed chunk. Must be GPU
 * accessible.
 * @param device_uncompressed_bytes The calculated decompressed size of each
 * chunk. Must be GPU accessible.
 * @param batch_size The number of chunks
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_DEFLATE_H


// Parsed from <nvcomp/deflate.hpp>

// #pragma once

/*
 * Copyright (c) 2020-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include "nvcompManager.hpp"
// #include "nvcomp/deflate.h"
// Targeting ../nvcomp/DeflateFormatSpecHeader.java


// Targeting ../nvcomp/DeflateManager.java



 // namespace nvcomp

// Parsed from <nvcomp/gdeflate.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_GDEFLATE_H
// #define NVCOMP_GDEFLATE_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompBatchedGdeflateOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedGdeflateOpts_t nvcompBatchedGdeflateDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompGdeflateCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers passed to
 * compression or decompression functions.  Typed memory buffers must still be aligned
 * to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompGdeflateRequiredAlignment();

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The GDeflate compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The GDeflate compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);    

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedGdeflateCompressAsync() for each batch item.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts The GDeflate compression options to use.
 * @param max_compressed_byes The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_bytes);

/**
 * \brief Perform compression asynchronously. All pointers must point to GPU
 * accessible locations. The individual chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * @param max_uncompressed_chunk_bytes The maximum size in bytes of the largest
 * chunk in the batch.
 * @param batch_size The number of chunks to compress.
 * @param device_temp_ptr The temporary GPU workspace.
 * @param temp_bytes The size of the temporary GPU workspace.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for
 * each compressed batch item (output). This pointer must be GPU accessible.
 * @param device_compressed_bytes The compressed size of each chunk on the GPU
 * (output). This pointer must be GPU accessible.
 * @param format_opts The GDeflate compression options to use.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    CUstream_st stream);


/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in gdeflate.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("size_t") long max_uncompressed_total_size );

/**
 * \brief Perform decompression asynchronously. All pointers must be GPU
 * accessible. In the case where a chunk of compressed data is not a valid GDeflate
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_ptrs The pointers on the GPU, to the compressed
 * chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The decompressed buffer size. This is needed
 * to prevent OOB accesses. This pointer must be GPU accessible.
 * @param device_actual_uncompressed_bytes The actual calculated decompressed
 * size of each chunk. Can be nullptr if desired, 
 * in which case the actual_uncompressed_bytes is not reported.
 * @param batch_size The number of batch items.
 * @param device_temp_ptr The temporary GPU space.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to
 * uncompress each chunk (output).
 * @param device_statuses The status for each chunk of whether it was
 * decompressed or not. Can be nullptr if desired, 
 * in which case error status is not reported.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Calculates the decompressed size of each chunk asynchronously. This is
 * needed when we do not know the expected output size. All pointers must be GPU
 * accessible. Note, if the stream is corrupt, the sizes will be garbage.
 *
 * @param device_compress_ptrs The compressed chunks of data. List of pointers
 * must be GPU accessible along with each chunk.
 * @param device_compressed_bytes The size of each compressed chunk. Must be GPU
 * accessible.
 * @param device_uncompressed_bytes The calculated decompressed size of each
 * chunk. Must be GPU accessible.
 * @param batch_size The number of chunks
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_GDEFLATE_H


// Parsed from <nvcomp/gdeflate.hpp>

// #pragma once

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include <memory>

// #include "nvcompManager.hpp"
// #include "gdeflate.h"
// Targeting ../nvcomp/GdeflateFormatSpecHeader.java


// Targeting ../nvcomp/GdeflateManager.java



 // namespace nvcomp



// Parsed from <nvcomp/gzip.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_GZIP_H
// #define NVCOMP_GZIP_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched decompression interface for gzip
 *****************************************************************************/

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in gzip.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("size_t") long max_uncompressed_total_size );

/**
 * \brief Perform decompression asynchronously. All pointers must be GPU
 * accessible. In the case where a chunk of compressed data is not a valid gzip
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_ptrs The pointers on the GPU, to the compressed
 * chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The decompressed buffer size. This is needed
 * to prevent OOB accesses. This pointer must be GPU accessible.
 * @param device_actual_uncompressed_bytes The actual calculated decompressed
 * size of each chunk. Can be nullptr if desired, 
 * in which case the actual_uncompressed_bytes is not reported.
 * @param batch_size The number of batch items.
 * @param device_temp_ptr The temporary GPU space.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to
 * uncompress each chunk (output).
 * @param device_statuses The status for each chunk of whether it was
 * decompressed or not. Can be nullptr if desired, 
 * in which case error status is not reported.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Calculates the decompressed size of each chunk asynchronously. This is
 * needed when we do not know the expected output size. All pointers must be GPU
 * accessible. Note, if the stream is corrupt, the sizes will be garbage.
 *
 * @param device_compress_ptrs The compressed chunks of data. List of pointers
 * must be GPU accessible along with each chunk.
 * @param device_compressed_bytes The size of each compressed chunk. Must be GPU
 * accessible.
 * @param device_uncompressed_bytes The calculated decompressed size of each
 * chunk. Must be GPU accessible.
 * @param batch_size The number of chunks
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_GZIP_H


// Parsed from <nvcomp/lz4.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_LZ4_H
// #define NVCOMP_LZ4_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompLZ4FormatOpts.java


// Targeting ../nvcomp/nvcompBatchedLZ4Opts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedLZ4Opts_t nvcompBatchedLZ4DefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompLZ4CompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompLZ4RequiredAlignment();

/******************************************************************************
 * Batched compression/decompression interface
 *****************************************************************************/

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 16777216 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The LZ4 compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 16777216 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The LZ4 compression options to use.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedLZ4CompressAsync() for each batch item.
 *
 * Chunk size must not exceed
 * 16777216 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts The LZ4 compression options to use.
 * @param max_compressed_byes The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_bytes);

/**
 * \brief Perform compression asynchronously. All pointers must point to GPU
 * accessible locations. The individual chunk size must not exceed
 * 16777216 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * Each chunk size MUST be a multiple of the size of the data type specified by
 * format_opts.data_type, else this may crash or produce invalid output.
 * @param max_uncompressed_chunk_bytes The maximum size in bytes of the largest
 * chunk in the batch. This parameter is currently unused, so if it is not set
 * with the maximum size, it should be set to zero. If a future version makes
 * use of it, it will return an error if it is set to zero.
 * @param batch_size The number of chunks to compress.
 * @param device_temp_ptr The temporary GPU workspace.
 * @param temp_bytes The size of the temporary GPU workspace.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for
 * each compressed batch item (output). This pointer must be GPU accessible.
 * @param device_compressed_bytes The compressed size of each chunk on the GPU
 * (output). This pointer must be GPU accessible.
 * @param format_opts The LZ4 compression options to use.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    CUstream_st stream);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);


/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in lz4.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_uncompressed_total_size );    

/**
 * \brief Perform decompression asynchronously. All pointers must be GPU
 * accessible. In the case where a chunk of compressed data is not a valid LZ4
 * block, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_ptrs The pointers on the GPU, to the compressed
 * chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The decompressed buffer size. This is needed
 * to prevent OOB accesses.
 * @param device_actual_uncompressed_bytes The actual calculated decompressed
 * size of each chunk. Can be nullptr if desired, 
 * in which case the actual_uncompressed_bytes is not reported.
 * @param batch_size The number of chunks to decompress.
 * @param device_temp_ptr The temporary GPU space.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to
 * uncompress each chunk (output).
 * @param device_statuses The status for each chunk of whether it was
 * decompressed or not. Can be nullptr if desired, 
 * in which case error status is not reported.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Calculates the decompressed size of each chunk asynchronously. This is
 * needed when we do not know the expected output size. All pointers must be GPU
 * accessible. Note, if the stream is corrupt, the sizes will be garbage.
 *
 * @param device_compress_ptrs The compressed chunks of data. List of pointers
 * must be GPU accessible along with each chunk.
 * @param device_compressed_bytes The size of each compressed chunk. Must be GPU
 * accessible.
 * @param device_uncompressed_bytes The calculated decompressed size of each
 * chunk. Must be GPU accessible.
 * @param batch_size The number of chunks.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4GetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4GetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/lz4.hpp>

// #pragma once

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/lz4.h"
// Targeting ../nvcomp/LZ4FormatSpecHeader.java


// Targeting ../nvcomp/LZ4Manager.java



 // namespace nvcomp


// Parsed from <nvcomp/snappy.h>

/*
 * Copyright (c) 2017-2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_SNAPPY_H
// #define NVCOMP_SNAPPY_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompBatchedSnappyOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedSnappyOpts_t nvcompBatchedSnappyDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompSnappyCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 *
 * The Snappy compressor supports unaligned data, so this value is 1.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompSnappyRequiredAlignment();

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_size The size of the largest chunk when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_size, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_size The size of the largest chunk when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks. 
 * Unused in snappy.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_size, @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_uncompressed_total_size );    

/**
 * \brief Compute uncompressed sizes.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The actual size of each uncompressed chunk.
 * @param batch_size The number of chunks in the batch.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

/**
 * \brief Perform decompression.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The size of each device_uncompressed_ptr[i] buffer.
 * @param device_actual_uncompressed_bytes The actual size of each uncompressed chunk
 * Can be nullptr if desired, in which case the actual_uncompressed_bytes is not reported.
 * @param batch_size The number of chunks in the batch.
 * @param device_temp_ptr The temporary GPU space, could be NULL in case temprorary space is not needed.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to uncompress each chunk (output).
 * @param device_statuses The pointers on the GPU, to where to uncompress each chunk (output).
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Get temporary space required for compression.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_ops Snappy compression options.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetTempSize(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_ops,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_ops Snappy compression options.
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetTempSizeEx(
    @Cast("size_t") long batch_size,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_ops,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);    

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedSnappyCompressAsync() for each batch item.
 *
 * @param max_chunk_size The maximum size of a chunk in the batch.
 * @param format_ops Snappy compression options.
 * @param max_compressed_size The maximum compressed size of the largest chunk
 * (output).
 *
 * @return The nvcompSuccess unless there is an error.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_chunk_size,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_size);

/**
 * \brief Perform compression.
 *
 * The caller is responsible for passing device_compressed_bytes of size
 * sufficient to hold compressed data
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * @param max_uncompressed_chunk_bytes The size of the largest uncompressed chunk.
 * @param batch_size The number of chunks in the batch.
 * @param device_temp_ptr The temporary GPU workspace, could be NULL in case temprorary space is not needed.
 * @param temp_bytes The size of the temporary GPU workspace.
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for each compressed batch item (output).
 * @param device_compressed_bytes The compressed size of each chunk on the GPU (output).
 * @param format_ops Snappy compression options.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_ops,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_ops,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/snappy.hpp>

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #pragma once

// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/snappy.h"
// Targeting ../nvcomp/SnappyFormatSpecHeader.java


// Targeting ../nvcomp/SnappyManager.java



 // namespace nvcomp


// Parsed from <nvcomp/zstd.h>

/*
 * Copyright (c) 2022, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #ifndef NVCOMP_Zstd_H
// #define NVCOMP_Zstd_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ../nvcomp/nvcompBatchedZstdOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedZstdOpts_t nvcompBatchedZstdDefaultOpts();

// Set this to 16 MB for now. In theory this could go up to 2 GB, but 
// we only want to provide that if a user has a really good reason for it because
// decompression performance will be really awful.
@MemberGetter public static native @Cast("const size_t") long nvcompZstdCompressionMaxAllowedChunkSize();

/**
 * This is the minimum alignment required for void type CUDA memory buffers
 * passed to compression or decompression functions.  Typed memory buffers must
 * still be aligned to their type's size, e.g. 8 bytes for size_t.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompZstdRequiredAlignment();

/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_size The size of the largest chunk when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_size, @Cast("size_t*") SizeTPointer temp_bytes);


/**
 * \brief Get the amount of temp space required on the GPU for decompression.
 *
 * @param num_chunks The number of items in the batch.
 * @param max_uncompressed_chunk_size The size of the largest chunk when uncompressed.
 * @param temp_bytes The amount of temporary GPU space that will be required to
 * decompress.
 * @param max_uncompressed_total_size  The total decompressed size of all the chunks.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_size, @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_uncompressed_total_size );

/**
 * \brief Compute uncompressed sizes.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The actual size of each uncompressed chunk.
 * @param batch_size The number of chunks in the batch.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    CUstream_st stream);

/**
 * \brief Perform decompression.
 *
 * @param device_compresed_ptrs The pointers on the GPU, to the compressed chunks.
 * @param device_compressed_bytes The size of each compressed chunk on the GPU.
 * @param device_uncompressed_bytes The size of each device_uncompressed_ptrs[i] buffer.
 * @param device_actual_uncompressed_bytes The actual size of each uncompressed chunk
 * @param batch_size The number of chunks in the batch.
 * @param device_temp_ptr The temporary GPU space, could be NULL in case temprorary space is not needed.
 * @param temp_bytes The size of the temporary GPU space.
 * @param device_uncompressed_ptrs The pointers on the GPU, to where to uncompress each chunk (output).
 * @param device_statuses The pointers on the GPU, to where to uncompress each chunk (output).
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compresed_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_bytes,
    @Cast("size_t*") SizeTPointer device_actual_uncompressed_bytes,
    @Cast("size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

/**
 * \brief Perform compression asynchronously. All pointers must point to GPU
 * accessible locations. The individual chunk size must not exceed
 * 64 KB. For best performance, a chunk size of 64 KB is
 * recommended.
 *
 * @param device_uncompressed_ptrs The pointers on the GPU, to uncompressed batched items.
 * This pointer must be GPU accessible.
 * @param device_uncompressed_bytes The size of each uncompressed batch item on the GPU.
 * Each chunk size MUST be a multiple of the size of the data type specified by
 * format_opts.data_type, else this may crash or produce invalid output.
 * @param max_uncompressed_chunk_bytes The maximum size in bytes of the largest
 * chunk in the batch. This parameter is currently unused, so if it is not set
 * with the maximum size, it should be set to zero. If a future version makes
 * use of it, it will return an error if it is set to zero.
 * @param batch_size The number of chunks to compress.
 * @param device_temp_ptr The temporary GPU workspace.
 * @param temp_bytes The size of the temporary GPU workspace. 
 * @param device_compressed_ptrs The pointers on the GPU, to the output location for
 * each compressed batch item (output). This pointer must be GPU accessible.
 * @param device_compressed_bytes The compressed size of each chunk on the GPU
 * (output). This pointer must be GPU accessible.
 * @param format_opts The Zstd compression options to use. Currently empty.
 * @param stream The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressAsync(
    @Cast("const void*const*const") PointerPointer device_uncompressed_ptrs,
    @Cast("const size_t*const") SizeTPointer device_uncompressed_bytes,
    @Cast("const size_t") long max_uncompressed_chunk_bytes,
    @Cast("const size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*const") PointerPointer device_compressed_ptrs,
    @Cast("size_t*const") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedZstdOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressAsync(
    @Cast("const void*const*const") @ByPtrPtr Pointer device_uncompressed_ptrs,
    @Cast("const size_t*const") SizeTPointer device_uncompressed_bytes,
    @Cast("const size_t") long max_uncompressed_chunk_bytes,
    @Cast("const size_t") long batch_size,
    Pointer device_temp_ptr,
    @Cast("const size_t") long temp_bytes,
    @Cast("void*const*const") @ByPtrPtr Pointer device_compressed_ptrs,
    @Cast("size_t*const") SizeTPointer device_compressed_bytes,
    @Const @ByVal nvcompBatchedZstdOpts_t format_opts,
    CUstream_st stream);

/**
 * \brief Get the maximum size any chunk could compress to in the batch. That
 * is, the minimum amount of output memory required to be given
 * nvcompBatchedZstdCompressAsync() for each batch item.
 *
 * Chunk size must not exceed
 * 64 KB bytes. For best performance, a chunk size of 64 KB is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the batch.
 * @param format_opts The Zstd compression options to use. Currently empty.
 * @param max_compressed_byes The maximum compressed size of the largest chunk
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetMaxOutputChunkSize(
    @Cast("const size_t") long max_uncompressed_chunk_bytes,
    @Const @ByVal nvcompBatchedZstdOpts_t arg1,
    @Cast("size_t*const") SizeTPointer max_compressed_size);

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 64 KB. For best performance, a chunk size of 64 KB is
 * recommended.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The ZSTD compression options to use -- currently empty
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetTempSize(
    @Cast("const size_t") long batch_size,
    @Cast("const size_t") long max_uncompressed_chunk_bytes,
    @Const @ByVal nvcompBatchedZstdOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get temporary space required for compression.
 *
 * Chunk size must not exceed
 * 16 MB. For best performance, a chunk size of 64 KB is
 * recommended.
 * 
 * This extended API is useful for cases where chunk sizes aren't uniform in the batch
 * I.e. in the regular API, if all but 1 chunk is 64 KB, but 1 chunk is 16 MB, the temporary space
 * computed is based on 16 MB * num_chunks.
 *
 * @param batch_size The number of items in the batch.
 * @param max_uncompressed_chunk_bytes The maximum size of a chunk in the
 * batch.
 * @param format_opts The ZSTD compression options to use -- currently empty
 * @param temp_bytes The size of the required GPU workspace for compression
 * (output).
 * @param max_total_uncompressed_bytes Upper bound on the total uncompressed size of all
 * chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetTempSizeEx(
    @Cast("const size_t") long batch_size,
    @Cast("const size_t") long max_uncompressed_chunk_bytes,
    @Const @ByVal nvcompBatchedZstdOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);    

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/zstd.hpp>

// #pragma once

/*
 * Copyright (c) 2023, NVIDIA CORPORATION. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of NVIDIA CORPORATION nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/zstd.h"
// Targeting ../nvcomp/ZstdFormatSpecHeader.java


// Targeting ../nvcomp/ZstdManager.java



 // namespace nvcomp



}
