// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/******************************************************************************
 * Batched compression/decompression interface
 *****************************************************************************/

/**
 * \brief Structure for configuring Bitcomp compression.
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class nvcompBatchedBitcompFormatOpts extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvcompBatchedBitcompFormatOpts() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvcompBatchedBitcompFormatOpts(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvcompBatchedBitcompFormatOpts(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvcompBatchedBitcompFormatOpts position(long position) {
        return (nvcompBatchedBitcompFormatOpts)super.position(position);
    }
    @Override public nvcompBatchedBitcompFormatOpts getPointer(long i) {
        return new nvcompBatchedBitcompFormatOpts((Pointer)this).offsetAddress(i);
    }

  /**
   * \brief Bitcomp algorithm options.
   *  algorithm_type: The type of Bitcomp algorithm used.
   *    0 : Default algorithm, usually gives the best compression ratios
   *    1 : "Sparse" algorithm, works well on sparse data (with lots of zeroes).
   *        and is usually a faster than the default algorithm.
   *  data_type is one of nvcomp's possible data types
   */
  public native int algorithm_type(); public native nvcompBatchedBitcompFormatOpts algorithm_type(int setter);
  public native @Cast("nvcompType_t") int data_type(); public native nvcompBatchedBitcompFormatOpts data_type(int setter);
}
