// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvcomp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvcomp.*;


/**
 * \brief Abstract base class that defines the nvCOMP high level interface
 */
@Namespace("nvcomp") @Properties(inherit = org.bytedeco.cuda.presets.nvcomp.class)
public class nvcompManagerBase extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvcompManagerBase(Pointer p) { super(p); }

  /**
   * \brief Configure the compression. 
   *
   * This routine computes the size of the required result buffer. The result config also
   * contains the nvcompStatus* that allows error checking. Synchronizes the device (cudaMemcpy)
   * 
   * @param decomp_buffer_size The uncompressed input data size.
   * @return comp_config Result
   */
  public native @ByVal CompressionConfig configure_compression(
      @Cast("const size_t") long decomp_buffer_size);

  /**
   * \brief Perform compression asynchronously.
   *
   * @param decomp_buffer The uncompressed input data (GPU accessible).
   * @param comp_buffer The location to output the compressed data to (GPU accessible).
   * @param comp_config Resulted from configure_compression for this decomp_buffer.
   */
  public native void compress(
        @Cast("const uint8_t*") BytePointer decomp_buffer, 
        @Cast("uint8_t*") BytePointer comp_buffer,
        @Const @ByRef CompressionConfig comp_config);
  public native void compress(
        @Cast("const uint8_t*") ByteBuffer decomp_buffer, 
        @Cast("uint8_t*") ByteBuffer comp_buffer,
        @Const @ByRef CompressionConfig comp_config);
  public native void compress(
        @Cast("const uint8_t*") byte[] decomp_buffer, 
        @Cast("uint8_t*") byte[] comp_buffer,
        @Const @ByRef CompressionConfig comp_config);

  /**
   * \brief Configure the decompression using a compressed buffer. 
   *
   * Synchronizes the user stream. 
   * 
   * In the base case, this only computes the size of the decompressed buffer from the compressed buffer header. 
   * 
   * @param comp_buffer The compressed input data (GPU accessible).
   * @return decomp_config Result
   */
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") BytePointer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") ByteBuffer comp_buffer);
  public native @ByVal DecompressionConfig configure_decompression(
      @Cast("const uint8_t*") byte[] comp_buffer);

  /**
   * \brief Configure the decompression using a CompressionConfig object. 
   *
   * Does not synchronize the user stream. 
   * 
   * In the base case, this only computes the size of the decompressed buffer from the compressed buffer header. 
   * 
   * @param comp_config The config used to compress a buffer
   * @return decomp_config Result
   */
  public native @ByVal DecompressionConfig configure_decompression(
      @Const @ByRef CompressionConfig comp_config);

  /**
   * \brief Perform decompression asynchronously.
   *
   * @param decomp_buffer The location to output the decompressed data to (GPU accessible).
   * @param comp_buffer The compressed input data (GPU accessible).
   * @param decomp_config Resulted from configure_decompression given this decomp_buffer_size.
   * Contains nvcompStatus* in CPU/GPU-accessible memory to allow error checking.
   */
  public native void decompress(
        @Cast("uint8_t*") BytePointer decomp_buffer, 
        @Cast("const uint8_t*") BytePointer comp_buffer,
        @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
        @Cast("uint8_t*") ByteBuffer decomp_buffer, 
        @Cast("const uint8_t*") ByteBuffer comp_buffer,
        @Const @ByRef DecompressionConfig decomp_config);
  public native void decompress(
        @Cast("uint8_t*") byte[] decomp_buffer, 
        @Cast("const uint8_t*") byte[] comp_buffer,
        @Const @ByRef DecompressionConfig decomp_config);
  
  /**
   * \brief Allows the user to provide a function for allocating / deallocating memory
   * 
   * The HLIF manager requires scratch memory to perform its operations. 
   * By default, it will use internal allocators which make use of 
   * cudaMallocAsync / cudaFreeAsync
   * The user can override the allocation functions with this API. 
   * The required signatures are
   *   void alloc_fn(size_t alloc_size)
   * and
   *   void dealloc_fn(size_t alloc_size)
   * 
   * @param alloc_fn The host function to use to alloc a new scratch result buffer
   * @param dealloc_fn The host function to use to dealloc a scratch result buffer
   * 
   */
  
  
  /** 
   * \brief Computes the compressed output size of a given buffer 
   * 
   * Synchronously copies the size of the compressed buffer to a stack variable for return.
   * 
   * @param comp_buffer The start pointer of the compressed buffer to assess.
   * @return Size of the compressed buffer
   */ 
  public native @Cast("size_t") long get_compressed_output_size(@Cast("uint8_t*") BytePointer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("uint8_t*") ByteBuffer comp_buffer);
  public native @Cast("size_t") long get_compressed_output_size(@Cast("uint8_t*") byte[] comp_buffer);
}
