// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;


@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlDeviceAttributes_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlDeviceAttributes_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlDeviceAttributes_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlDeviceAttributes_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlDeviceAttributes_t position(long position) {
        return (nvmlDeviceAttributes_t)super.position(position);
    }
    @Override public nvmlDeviceAttributes_t getPointer(long i) {
        return new nvmlDeviceAttributes_t((Pointer)this).offsetAddress(i);
    }

    /** Streaming Multiprocessor count */
    public native @Cast("unsigned int") int multiprocessorCount(); public native nvmlDeviceAttributes_t multiprocessorCount(int setter);
    /** Shared Copy Engine count */
    public native @Cast("unsigned int") int sharedCopyEngineCount(); public native nvmlDeviceAttributes_t sharedCopyEngineCount(int setter);
    /** Shared Decoder Engine count */
    public native @Cast("unsigned int") int sharedDecoderCount(); public native nvmlDeviceAttributes_t sharedDecoderCount(int setter);
    /** Shared Encoder Engine count */
    public native @Cast("unsigned int") int sharedEncoderCount(); public native nvmlDeviceAttributes_t sharedEncoderCount(int setter);
    /** Shared JPEG Engine count */
    public native @Cast("unsigned int") int sharedJpegCount(); public native nvmlDeviceAttributes_t sharedJpegCount(int setter);
    /** Shared OFA Engine count */
    public native @Cast("unsigned int") int sharedOfaCount(); public native nvmlDeviceAttributes_t sharedOfaCount(int setter);
    /** GPU instance slice count */
    public native @Cast("unsigned int") int gpuInstanceSliceCount(); public native nvmlDeviceAttributes_t gpuInstanceSliceCount(int setter);
    /** Compute instance slice count */
    public native @Cast("unsigned int") int computeInstanceSliceCount(); public native nvmlDeviceAttributes_t computeInstanceSliceCount(int setter);
    /** Device memory size (in MiB) */
    public native @Cast("unsigned long long") long memorySizeMB(); public native nvmlDeviceAttributes_t memorySizeMB(long setter);
}
