// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;


/**
 * Structure to store the state and logs of a software runlist
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlVgpuSchedulerLogEntry_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlVgpuSchedulerLogEntry_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlVgpuSchedulerLogEntry_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlVgpuSchedulerLogEntry_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlVgpuSchedulerLogEntry_t position(long position) {
        return (nvmlVgpuSchedulerLogEntry_t)super.position(position);
    }
    @Override public nvmlVgpuSchedulerLogEntry_t getPointer(long i) {
        return new nvmlVgpuSchedulerLogEntry_t((Pointer)this).offsetAddress(i);
    }

    /** Timestamp in ns when this software runlist was preeempted */
    public native @Cast("unsigned long long") long timestamp(); public native nvmlVgpuSchedulerLogEntry_t timestamp(long setter);
    /** Total time in ns this software runlist has run */
    public native @Cast("unsigned long long") long timeRunTotal(); public native nvmlVgpuSchedulerLogEntry_t timeRunTotal(long setter);
    /** Time in ns this software runlist ran before preemption */
    public native @Cast("unsigned long long") long timeRun(); public native nvmlVgpuSchedulerLogEntry_t timeRun(long setter);
    /** Software runlist Id */
    public native @Cast("unsigned int") int swRunlistId(); public native nvmlVgpuSchedulerLogEntry_t swRunlistId(int setter);
    /** The actual timeslice after deduction */
    public native @Cast("unsigned long long") long targetTimeSlice(); public native nvmlVgpuSchedulerLogEntry_t targetTimeSlice(long setter);
    /** Preemption time in ns for this SW runlist */
    public native @Cast("unsigned long long") long cumulativePreemptionTime(); public native nvmlVgpuSchedulerLogEntry_t cumulativePreemptionTime(long setter);
}
